/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseBlockUtils;
import gcewing.sg.BlockPos;
import gcewing.sg.DHDTE;
import gcewing.sg.SGAddressing;
import gcewing.sg.SGBaseTE;
import gcewing.sg.SGChannel;
import gcewing.sg.SGCraft;
import gcewing.sg.SGScreen;
import gcewing.sg.SGState;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class DHDScreen
extends SGScreen {
    static final int dhdWidth = 320;
    static final int dhdHeight = 120;
    static final double dhdRadius1 = 32.0;
    static final double dhdRadius2 = 88.0;
    static final double dhdRadius3 = 144.0;
    World world;
    BlockPos pos;
    int dhdTop;
    int dhdCentreX;
    int dhdCentreY;
    int closingDelay = 0;
    int addressLength;
    DHDTE cte;

    public DHDScreen(EntityPlayer entityPlayer, World world, BlockPos blockPos) {
        this.world = world;
        this.pos = blockPos;
        this.cte = this.getControllerTE();
        SGBaseTE sGBaseTE = this.getStargateTE();
        if (sGBaseTE != null) {
            this.addressLength = sGBaseTE.getNumChevrons();
        }
    }

    SGBaseTE getStargateTE() {
        if (this.cte != null) {
            return this.cte.getLinkedStargateTE();
        }
        return null;
    }

    DHDTE getControllerTE() {
        TileEntity tileEntity = BaseBlockUtils.getWorldTileEntity((IBlockAccess)this.world, this.pos);
        if (tileEntity instanceof DHDTE) {
            return (DHDTE)tileEntity;
        }
        return null;
    }

    String getEnteredAddress() {
        return this.cte.enteredAddress;
    }

    void setEnteredAddress(String string) {
        this.cte.enteredAddress = string;
        SGChannel.sendEnteredAddressToServer(this.cte, string);
    }

    @Override
    public void func_73866_w_() {
        this.dhdTop = this.field_146295_m - 120;
        this.dhdCentreX = this.field_146294_l / 2;
        this.dhdCentreY = this.dhdTop + 60;
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.closingDelay > 0 && --this.closingDelay == 0) {
            this.setEnteredAddress("");
            this.close();
        }
    }

    @Override
    protected void mousePressed(int n, int n2, int n3) {
        int n4;
        if (n3 == 0 && (n4 = this.findDHDButton(n, n2)) >= 0) {
            this.dhdButtonPressed(n4);
            return;
        }
    }

    void closeAfterDelay(int n) {
        this.closingDelay = n;
    }

    int findDHDButton(int n, int n2) {
        int n3;
        int n4;
        int n5 = -(n - this.dhdCentreX);
        int n6 = -(n2 - this.dhdCentreY);
        if (n6 > 0 && Math.hypot(n5, n6) <= 32.0) {
            return 0;
        }
        double d = Math.hypot(n5, n6 = n6 * 320 / 120);
        if (d > 144.0) {
            return -1;
        }
        if (d <= 32.0) {
            return 0;
        }
        double d2 = Math.toDegrees(Math.atan2(n6, n5));
        if (d2 < 0.0) {
            d2 += 360.0;
        }
        if (d > 88.0) {
            n4 = 1;
            n3 = 26;
        } else {
            n4 = 27;
            n3 = 11;
        }
        int n7 = n4 + (int)Math.floor(d2 * (double)n3 / 360.0);
        return n7;
    }

    void dhdButtonPressed(int n) {
        this.buttonSound();
        if (n == 0) {
            this.orangeButtonPressed(false);
        } else if (n >= 37) {
            this.backspace();
        } else {
            this.enterCharacter(SGBaseTE.symbolToChar(n - 1));
        }
    }

    void buttonSound() {
        EntityClientPlayerMP entityClientPlayerMP = this.field_146297_k.field_71439_g;
        PositionedSoundRecord positionedSoundRecord = new PositionedSoundRecord(new ResourceLocation("random.click"), 1.0f, 1.0f, (float)entityClientPlayerMP.field_70165_t, (float)entityClientPlayerMP.field_70163_u, (float)entityClientPlayerMP.field_70161_v);
        this.field_146297_k.func_147118_V().func_147682_a((ISound)positionedSoundRecord);
    }

    @Override
    public void func_73869_a(char c, int n) {
        if (n == 1) {
            this.close();
        } else if (n == 14 || n == 211) {
            this.backspace();
        } else if (n == 28 || n == 156) {
            this.orangeButtonPressed(true);
        } else {
            String string = String.valueOf(c).toUpperCase();
            if (SGAddressing.isValidSymbolChar(string)) {
                this.enterCharacter(string.charAt(0));
            }
        }
    }

    void orangeButtonPressed(boolean bl) {
        SGBaseTE sGBaseTE = this.getStargateTE();
        if (sGBaseTE != null) {
            if (sGBaseTE.state == SGState.Idle) {
                this.sendConnectOrDisconnect(sGBaseTE, this.getEnteredAddress());
            } else if (!bl) {
                this.sendConnectOrDisconnect(sGBaseTE, "");
            }
        }
    }

    void sendConnectOrDisconnect(SGBaseTE sGBaseTE, String string) {
        SGChannel.sendConnectOrDisconnectToServer(sGBaseTE, string);
        this.closeAfterDelay(10);
    }

    void backspace() {
        if (this.stargateIsIdle()) {
            this.buttonSound();
            String string = this.getEnteredAddress();
            int n = string.length();
            if (n > 0) {
                this.setEnteredAddress(string.substring(0, n - 1));
            }
        }
    }

    void enterCharacter(char c) {
        if (this.stargateIsIdle()) {
            this.buttonSound();
            String string = this.getEnteredAddress();
            int n = string.length();
            if (n < this.addressLength) {
                this.setEnteredAddress(string + c);
            }
        }
    }

    boolean stargateIsIdle() {
        SGBaseTE sGBaseTE = this.getStargateTE();
        return sGBaseTE != null && sGBaseTE.state == SGState.Idle;
    }

    @Override
    protected void func_146976_a(float f, int n, int n2) {
        SGBaseTE sGBaseTE = this.getStargateTE();
        GL11.glPushAttrib((int)24576);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        this.drawBackgroundImage();
        this.drawOrangeButton();
        if (sGBaseTE != null && sGBaseTE.state == SGState.Idle) {
            this.drawEnteredSymbols();
            this.drawEnteredString();
        }
        GL11.glPopAttrib();
    }

    void drawBackgroundImage() {
        this.bindTexture(SGCraft.mod.resourceLocation("textures/gui/dhd_gui.png"));
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        this.drawTexturedRect((this.field_146294_l - 320) / 2, this.field_146295_m - 120, 320.0, 120.0);
    }

    void drawOrangeButton() {
        boolean bl;
        this.bindTexture(SGCraft.mod.resourceLocation("textures/gui/dhd_centre.png"), 128, 64);
        SGBaseTE sGBaseTE = this.getStargateTE();
        boolean bl2 = bl = sGBaseTE != null && sGBaseTE.isActive();
        if (sGBaseTE == null || !sGBaseTE.isMerged) {
            this.setColor(0.2, 0.2, 0.2);
        } else if (bl) {
            this.setColor(1.0, 0.5, 0.0);
        } else {
            this.setColor(0.5, 0.25, 0.0);
        }
        double d = 30.0;
        double d2 = 22.5;
        this.drawTexturedRect((double)this.dhdCentreX - d, (double)this.dhdCentreY - d2 - 6.0, 2.0 * d, 1.5 * d2, 64.0, 0.0, 64.0, 48.0);
        this.resetColor();
        if (bl) {
            GL11.glBlendFunc((int)1, (int)1);
            double d3 = 5.0;
            this.drawTexturedRect((double)this.dhdCentreX - d - d3, (double)this.dhdCentreY - d2 - d3 - 6.0, 2.0 * (d + d3), d2 + d3, 0.0, 0.0, 64.0, 32.0);
            this.drawTexturedRect((double)this.dhdCentreX - d - d3, this.dhdCentreY - 6, 2.0 * (d + d3), 0.5 * d2 + d3, 0.0, 32.0, 64.0, 32.0);
            GL11.glBlendFunc((int)770, (int)771);
        }
    }

    void drawEnteredSymbols() {
        this.drawAddressSymbols(this.field_146294_l / 2, this.dhdTop - 80, this.getEnteredAddress());
    }

    void drawEnteredString() {
        String string = SGAddressing.padAddress(this.getEnteredAddress(), "|", this.addressLength);
        this.drawAddressString(this.field_146294_l / 2, this.dhdTop - 20, string);
    }
}

