/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseBlockUtils;
import gcewing.sg.BaseConfiguration;
import gcewing.sg.BaseTileInventory;
import gcewing.sg.BlockPos;
import gcewing.sg.DHDBlock;
import gcewing.sg.ISGEnergySource;
import gcewing.sg.SGBaseTE;
import gcewing.sg.SGCraft;
import gcewing.sg.Trans3;
import gcewing.sg.Vector3;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;

public class DHDTE
extends BaseTileInventory
implements ISGEnergySource {
    public static boolean debugLink = false;
    public static int linkRangeX = 5;
    public static int linkRangeY = 1;
    public static int linkRangeZ = 6;
    public static final int firstFuelSlot = 0;
    public static final int numFuelSlots = 4;
    public static final int numSlots = 4;
    public boolean isLinkedToStargate;
    public BlockPos linkedPos = new BlockPos(0, 0, 0);
    public String enteredAddress = "";
    IInventory inventory = new InventoryBasic("DHD", false, 4);
    static AxisAlignedBB bounds;
    static double maxEnergyBuffer;
    double energyInBuffer;

    public static void configure(BaseConfiguration baseConfiguration) {
        linkRangeX = baseConfiguration.getInteger("dhd", "linkRangeX", linkRangeX);
        linkRangeY = baseConfiguration.getInteger("dhd", "linkRangeY", linkRangeY);
        linkRangeZ = baseConfiguration.getInteger("dhd", "linkRangeZ", linkRangeZ);
        maxEnergyBuffer = SGBaseTE.energyPerFuelItem;
    }

    public static DHDTE at(IBlockAccess iBlockAccess, BlockPos blockPos) {
        TileEntity tileEntity = BaseBlockUtils.getWorldTileEntity(iBlockAccess, blockPos);
        if (tileEntity instanceof DHDTE) {
            return (DHDTE)tileEntity;
        }
        return null;
    }

    public static DHDTE at(IBlockAccess iBlockAccess, NBTTagCompound nBTTagCompound) {
        BlockPos blockPos = new BlockPos(nBTTagCompound.func_74762_e("x"), nBTTagCompound.func_74762_e("y"), nBTTagCompound.func_74762_e("z"));
        return DHDTE.at(iBlockAccess, blockPos);
    }

    public void setEnteredAddress(String string) {
        this.enteredAddress = string;
        this.markChanged();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return bounds.func_72321_a((double)this.getX() + 0.5, (double)this.getY(), (double)this.getZ() + 0.5);
    }

    public double func_145833_n() {
        return 32768.0;
    }

    @Override
    protected IInventory getInventory() {
        return this.inventory;
    }

    public DHDBlock getBlock() {
        return (DHDBlock)this.func_145838_q();
    }

    @Override
    public void readContentsFromNBT(NBTTagCompound nBTTagCompound) {
        super.readContentsFromNBT(nBTTagCompound);
        this.isLinkedToStargate = nBTTagCompound.func_74767_n("isLinkedToStargate");
        this.energyInBuffer = nBTTagCompound.func_74769_h("energyInBuffer");
        int n = nBTTagCompound.func_74762_e("linkedX");
        int n2 = nBTTagCompound.func_74762_e("linkedY");
        int n3 = nBTTagCompound.func_74762_e("linkedZ");
        this.linkedPos = new BlockPos(n, n2, n3);
        this.enteredAddress = nBTTagCompound.func_74779_i("enteredAddress");
    }

    @Override
    public void writeContentsToNBT(NBTTagCompound nBTTagCompound) {
        super.writeContentsToNBT(nBTTagCompound);
        nBTTagCompound.func_74757_a("isLinkedToStargate", this.isLinkedToStargate);
        nBTTagCompound.func_74780_a("energyInBuffer", this.energyInBuffer);
        nBTTagCompound.func_74768_a("linkedX", this.linkedPos.getX());
        nBTTagCompound.func_74768_a("linkedY", this.linkedPos.getY());
        nBTTagCompound.func_74768_a("linkedZ", this.linkedPos.getZ());
        nBTTagCompound.func_74778_a("enteredAddress", this.enteredAddress);
    }

    SGBaseTE getLinkedStargateTE() {
        TileEntity tileEntity;
        if (this.isLinkedToStargate && (tileEntity = BaseBlockUtils.getWorldTileEntity((IBlockAccess)this.field_145850_b, this.linkedPos)) instanceof SGBaseTE) {
            return (SGBaseTE)tileEntity;
        }
        return null;
    }

    void checkForLink() {
        if (debugLink) {
            System.out.printf("DHDTE.checkForLink at %s: isLinkedToStargate = %s\n", this.getPos(), this.isLinkedToStargate);
        }
        if (!this.isLinkedToStargate) {
            Trans3 trans3 = this.localToGlobalTransformation();
            for (int i = -linkRangeX; i <= linkRangeX; ++i) {
                for (int j = -linkRangeY; j <= linkRangeY; ++j) {
                    for (int k = 1; k <= linkRangeZ; ++k) {
                        TileEntity tileEntity;
                        Vector3 vector3 = trans3.p(i, j, -k);
                        BlockPos blockPos = new BlockPos(vector3.floorX(), vector3.floorY(), vector3.floorZ());
                        if (debugLink) {
                            System.out.printf("DHDTE.checkForLink: probing %s\n", blockPos);
                        }
                        if (!((tileEntity = BaseBlockUtils.getWorldTileEntity((IBlockAccess)this.field_145850_b, blockPos)) instanceof SGBaseTE)) continue;
                        if (debugLink) {
                            System.out.printf("DHDTE.checkForLink: Found stargate at %s\n", BaseBlockUtils.getTileEntityPos(tileEntity));
                        }
                        if (!this.linkToStargate((SGBaseTE)tileEntity)) continue;
                        return;
                    }
                }
            }
        }
    }

    boolean linkToStargate(SGBaseTE sGBaseTE) {
        if (!this.isLinkedToStargate && !sGBaseTE.isLinkedToController && sGBaseTE.isMerged) {
            if (debugLink) {
                System.out.printf("DHDTE.linkToStargate: Linking controller at %s with stargate at %s\n", this.getPos(), BaseBlockUtils.getTileEntityPos(sGBaseTE));
            }
            this.linkedPos = sGBaseTE.getPos();
            this.isLinkedToStargate = true;
            this.markChanged();
            sGBaseTE.linkedPos = this.getPos();
            sGBaseTE.isLinkedToController = true;
            sGBaseTE.markChanged();
            return true;
        }
        return false;
    }

    public void clearLinkToStargate() {
        if (debugLink) {
            System.out.printf("DHDTE: Unlinking controller at %s from stargate\n", this.getPos());
        }
        this.isLinkedToStargate = false;
        this.markChanged();
    }

    @Override
    public double availableEnergy() {
        double d = this.energyInBuffer;
        for (int i = 0; i < 4; ++i) {
            ItemStack itemStack = this.fuelStackInSlot(i);
            if (itemStack == null) continue;
            d += (double)itemStack.field_77994_a * SGBaseTE.energyPerFuelItem;
        }
        return d;
    }

    @Override
    public double drawEnergy(double d) {
        double d2 = 0.0;
        while (d2 < d && (this.energyInBuffer != 0.0 || this.useFuelItem())) {
            double d3 = Math.min(d, this.energyInBuffer);
            d2 += d3;
            this.energyInBuffer -= d3;
        }
        if (SGBaseTE.debugEnergyUse) {
            System.out.printf("DHDTE.drawEnergy: %s; supplied: %s; buffered: %s\n", d, d2, this.energyInBuffer);
        }
        this.markChanged();
        return d2;
    }

    boolean useFuelItem() {
        for (int i = 3; i >= 0; --i) {
            ItemStack itemStack = this.fuelStackInSlot(i);
            if (itemStack == null) continue;
            this.func_70298_a(i, 1);
            this.energyInBuffer += SGBaseTE.energyPerFuelItem;
            return true;
        }
        return false;
    }

    ItemStack fuelStackInSlot(int n) {
        ItemStack itemStack = this.func_70301_a(0 + n);
        if (DHDTE.isValidFuelItem(itemStack)) {
            return itemStack;
        }
        return null;
    }

    public static boolean isValidFuelItem(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() == SGCraft.naquadah && itemStack.field_77994_a > 0;
    }

    @Override
    public boolean func_94041_b(int n, ItemStack itemStack) {
        return DHDTE.isValidFuelItem(itemStack);
    }
}

