/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import gcewing.sg.BaseBlockUtils;
import gcewing.sg.BaseEntity;
import gcewing.sg.BaseUtils;
import gcewing.sg.BlockPos;
import gcewing.sg.SGBaseTE;
import gcewing.sg.Trans3;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class IrisEntity
extends BaseEntity
implements IEntityAdditionalSpawnData {
    public static boolean debugIrisEntity = false;
    BlockPos blockPos;

    public IrisEntity(World world) {
        super(world);
    }

    public IrisEntity(SGBaseTE sGBaseTE) {
        this(BaseBlockUtils.getTileEntityWorld(sGBaseTE));
        double d = 2.0;
        double d2 = 0.2;
        double d3 = 0.0;
        double d4 = 2.0;
        double d5 = 0.1;
        double d6 = d;
        double d7 = d;
        double d8 = d2;
        AxisAlignedBB axisAlignedBB = BaseUtils.newAxisAlignedBB(d3 - d6, d4 - d7, d5 - d8, d3 + d6, d4 + d7, d5 + d8);
        Trans3 trans3 = sGBaseTE.localToGlobalTransformation();
        AxisAlignedBB axisAlignedBB2 = trans3.t(axisAlignedBB);
        this.init(sGBaseTE.getPos(), axisAlignedBB2);
    }

    void init(BlockPos blockPos, AxisAlignedBB axisAlignedBB) {
        if (debugIrisEntity) {
            System.out.printf("IrisEntity.init: %s at %s box %s\n", new Object[]{this, blockPos, axisAlignedBB});
        }
        this.blockPos = blockPos;
        this.func_70107_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c);
        this.setBoundingBox(axisAlignedBB);
    }

    protected void func_70088_a() {
    }

    SGBaseTE getBaseTE() {
        TileEntity tileEntity = BaseBlockUtils.getWorldTileEntity((IBlockAccess)this.field_70170_p, this.blockPos);
        if (tileEntity instanceof SGBaseTE) {
            return (SGBaseTE)tileEntity;
        }
        return null;
    }

    public boolean func_70067_L() {
        SGBaseTE sGBaseTE = this.getBaseTE();
        boolean bl = sGBaseTE != null ? sGBaseTE.irisIsClosed() : false;
        return bl;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBox() {
        if (this.func_70067_L()) {
            return super.getEntityBoundingBox();
        }
        return null;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70037_a(NBTTagCompound nBTTagCompound) {
        if (debugIrisEntity) {
            System.out.printf("IrisEntity.readEntityFromNBT: %s\n", nBTTagCompound);
        }
        int n = nBTTagCompound.func_74762_e("blockX");
        int n2 = nBTTagCompound.func_74762_e("blockY");
        int n3 = nBTTagCompound.func_74762_e("blockZ");
        BlockPos blockPos = new BlockPos(n, n2, n3);
        double d = nBTTagCompound.func_74769_h("minX");
        double d2 = nBTTagCompound.func_74769_h("minY");
        double d3 = nBTTagCompound.func_74769_h("minZ");
        double d4 = nBTTagCompound.func_74769_h("maxX");
        double d5 = nBTTagCompound.func_74769_h("maxY");
        double d6 = nBTTagCompound.func_74769_h("maxZ");
        AxisAlignedBB axisAlignedBB = BaseUtils.newAxisAlignedBB(d, d2, d3, d4, d5, d6);
        this.init(blockPos, axisAlignedBB);
    }

    public void func_70014_b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74768_a("blockX", this.blockPos.getX());
        nBTTagCompound.func_74768_a("blockY", this.blockPos.getY());
        nBTTagCompound.func_74768_a("blockZ", this.blockPos.getZ());
        AxisAlignedBB axisAlignedBB = this.getEntityBoundingBox();
        nBTTagCompound.func_74780_a("minX", axisAlignedBB.field_72340_a);
        nBTTagCompound.func_74780_a("minY", axisAlignedBB.field_72338_b);
        nBTTagCompound.func_74780_a("minZ", axisAlignedBB.field_72339_c);
        nBTTagCompound.func_74780_a("maxX", axisAlignedBB.field_72336_d);
        nBTTagCompound.func_74780_a("maxY", axisAlignedBB.field_72337_e);
        nBTTagCompound.func_74780_a("maxZ", axisAlignedBB.field_72334_f);
        if (debugIrisEntity) {
            System.out.printf("IrisEntity.writeEntityToNBT: %s\n", nBTTagCompound);
        }
    }

    protected boolean func_142008_O() {
        return false;
    }

    public void writeSpawnData(ByteBuf byteBuf) {
        try {
            ByteBufOutputStream byteBufOutputStream = new ByteBufOutputStream(byteBuf);
            BaseUtils.writeBlockPos((DataOutput)byteBufOutputStream, this.blockPos);
            AxisAlignedBB axisAlignedBB = this.getEntityBoundingBox();
            byteBufOutputStream.writeDouble(axisAlignedBB.field_72340_a);
            byteBufOutputStream.writeDouble(axisAlignedBB.field_72338_b);
            byteBufOutputStream.writeDouble(axisAlignedBB.field_72339_c);
            byteBufOutputStream.writeDouble(axisAlignedBB.field_72336_d);
            byteBufOutputStream.writeDouble(axisAlignedBB.field_72337_e);
            byteBufOutputStream.writeDouble(axisAlignedBB.field_72334_f);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void readSpawnData(ByteBuf byteBuf) {
        try {
            ByteBufInputStream byteBufInputStream = new ByteBufInputStream(byteBuf);
            BlockPos blockPos = BaseUtils.readBlockPos((DataInput)byteBufInputStream);
            double d = byteBufInputStream.readDouble();
            double d2 = byteBufInputStream.readDouble();
            double d3 = byteBufInputStream.readDouble();
            double d4 = byteBufInputStream.readDouble();
            double d5 = byteBufInputStream.readDouble();
            double d6 = byteBufInputStream.readDouble();
            AxisAlignedBB axisAlignedBB = BaseUtils.newAxisAlignedBB(d, d2, d3, d4, d5, d6);
            this.init(blockPos, axisAlignedBB);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

