/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import cpw.mods.fml.common.IWorldGenerator;
import gcewing.sg.BaseConfiguration;
import gcewing.sg.SGChunkData;
import gcewing.sg.SGCraft;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;

public class NaquadahOreWorldGen
implements IWorldGenerator {
    static int genUnderLavaOdds = 4;
    static int maxNodesUnderLava = 8;
    static int genIsolatedOdds = 8;
    static int maxIsolatedNodes = 4;
    static boolean debugLava = false;
    static boolean debugRandom = false;
    static int debugLevel = 0;
    Random random;
    World world;
    Chunk chunk;
    int x0;
    int z0;
    Block stone = Blocks.field_150348_b;
    Block lava = Blocks.field_150353_l;
    Block naquadah = SGCraft.naquadahOre;

    public static void configure(BaseConfiguration baseConfiguration) {
        genUnderLavaOdds = baseConfiguration.getInteger("naquadah", "genUnderLavaOdds", genUnderLavaOdds);
        maxNodesUnderLava = baseConfiguration.getInteger("naquadah", "maxNodesUnderLava", maxNodesUnderLava);
        genIsolatedOdds = baseConfiguration.getInteger("naquadah", "genIsolatedOdds", genIsolatedOdds);
        maxIsolatedNodes = baseConfiguration.getInteger("naquadah", "maxIsolatedNodes", maxIsolatedNodes);
        debugLava = baseConfiguration.getBoolean("naquadah", "debugLava", debugLava);
        debugRandom = baseConfiguration.getBoolean("naquadah", "debugRandom", debugRandom);
        debugLevel = baseConfiguration.getInteger("naquadah", "debugLevel", debugLevel);
    }

    public void generate(Random random, int n, int n2, World world, IChunkProvider iChunkProvider, IChunkProvider iChunkProvider2) {
        this.random = random;
        this.world = world;
        this.x0 = n * 16;
        this.z0 = n2 * 16;
        this.chunk = world.func_72964_e(n, n2);
        this.generateChunk();
    }

    public void regenerate(Chunk chunk) {
        this.chunk = chunk;
        this.world = chunk.field_76637_e;
        int n = chunk.field_76635_g;
        int n2 = chunk.field_76647_h;
        long l = this.world.func_72905_C();
        this.random = new Random(l);
        long l2 = this.random.nextLong() >> 3;
        long l3 = this.random.nextLong() >> 3;
        this.random.setSeed(l2 * (long)n + l3 * (long)n2 ^ l);
        this.x0 = n * 16;
        this.z0 = n2 * 16;
        this.generateChunk();
    }

    Block getBlock(int n, int n2, int n3) {
        return this.chunk.func_150810_a(n, n2, n3);
    }

    void setBlock(int n, int n2, int n3, Block block) {
        this.chunk.func_150807_a(n, n2, n3, block, 0);
    }

    void generateNode(Block block, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.random.nextInt(n4);
        int n8 = this.random.nextInt(n5);
        int n9 = this.random.nextInt(n6);
        int n10 = this.world.func_72800_K();
        if (debugRandom && debugLevel >= 1) {
            System.out.printf("NaquadahOreWorldGen: %d x %d x %d node at (%d, %d, %d)\n", n7 + 1, n8 + 1, n9 + 1, this.x0 + n, n2, this.z0 + n3);
        }
        for (int i = n; i <= n + n7; ++i) {
            for (int j = n2; j <= n2 + n8; ++j) {
                for (int k = n3; k <= n3 + n9; ++k) {
                    if (i >= 16 || j >= n10 || k >= 16 || this.getBlock(i, j, k) != this.stone) continue;
                    if (debugRandom && debugLevel >= 2) {
                        System.out.printf("NaquadahOreWorldGen: block at (%d, %d, %d)\n", this.x0 + i, j, this.z0 + k);
                    }
                    this.setBlock(i, j, k, block);
                }
            }
        }
    }

    boolean odds(int n) {
        return this.random.nextInt(n) == 0;
    }

    void generateChunk() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        SGChunkData.forChunk((Chunk)this.chunk).oresGenerated = true;
        if (this.odds(genUnderLavaOdds)) {
            n5 = this.random.nextInt(maxNodesUnderLava) + 1;
            for (n4 = 0; n4 < n5; ++n4) {
                n3 = this.random.nextInt(16);
                n2 = this.random.nextInt(16);
                for (n = 0; n < 64; ++n) {
                    if (this.getBlock(n3, n, n2) != this.stone || this.getBlock(n3, n + 1, n2) != this.lava) continue;
                    if (debugLava) {
                        System.out.printf("NaquadahOreWorldGen: generating under lava at (%d, %d, %d)\n", this.x0 + n3, n, this.z0 + n2);
                    }
                    this.generateNode(this.naquadah, n3, n, n2, 3, 1, 3);
                }
            }
        }
        if (this.odds(genIsolatedOdds)) {
            n5 = this.random.nextInt(maxIsolatedNodes) + 1;
            for (n4 = 0; n4 < n5; ++n4) {
                n3 = this.random.nextInt(16);
                if (this.getBlock(n3, n2 = this.random.nextInt(64), n = this.random.nextInt(16)) != this.stone) continue;
                if (debugRandom) {
                    System.out.printf("NaquadahOreWorldGen: generating randomly at (%d, %d, %d)\n", this.x0 + n3, n2, this.z0 + n);
                }
                this.generateNode(this.naquadah, n3, n2, n, 2, 2, 2);
            }
        }
    }
}

