/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseTileEntity;
import gcewing.sg.ISGEnergySource;
import net.minecraft.nbt.NBTTagCompound;

public abstract class PowerTE
extends BaseTileEntity
implements ISGEnergySource {
    boolean debugOutput = false;
    public double energyBuffer = 0.0;
    public double energyMax;
    double energyPerSGEnergyUnit;

    public PowerTE(double d, double d2) {
        this.energyMax = d;
        this.energyPerSGEnergyUnit = d2;
    }

    public abstract String getScreenTitle();

    public abstract String getUnitName();

    @Override
    public void readContentsFromNBT(NBTTagCompound nBTTagCompound) {
        super.readContentsFromNBT(nBTTagCompound);
        this.energyBuffer = nBTTagCompound.func_74769_h("energyBuffer");
    }

    @Override
    public void writeContentsToNBT(NBTTagCompound nBTTagCompound) {
        super.writeContentsToNBT(nBTTagCompound);
        nBTTagCompound.func_74780_a("energyBuffer", this.energyBuffer);
    }

    @Override
    public double availableEnergy() {
        double d = this.energyBuffer / this.energyPerSGEnergyUnit;
        if (this.debugOutput) {
            System.out.printf("SGCraft: PowerTE: %s SGU available\n", d);
        }
        return d;
    }

    @Override
    public double drawEnergy(double d) {
        double d2 = this.energyBuffer / this.energyPerSGEnergyUnit;
        double d3 = Math.min(d, d2);
        this.energyBuffer -= d3 * this.energyPerSGEnergyUnit;
        this.markChanged();
        if (this.debugOutput) {
            System.out.printf("SGCraft: PowerTE: Supplying %s SGU of %s requested\n", d3, d);
        }
        return d3;
    }
}

