/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseUtils;
import gcewing.sg.SGBaseTE;
import gcewing.sg.SGDimensionMap;
import gcewing.sg.SGLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class SGAddressing {
    static boolean debugAddressing = false;
    static AddressingError malformedAddressError = new AddressingError("Malformed stargate address");
    static AddressingError coordRangeError = new AddressingError("Coordinates out of stargate range");
    static AddressingError dimensionRangeError = new AddressingError("Dimension not reachable by stargate");
    public static final String symbolChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    public static final int numSymbols = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".length();
    public static final int numCoordSymbols = 7;
    public static final int numDimensionSymbols = 2;
    public static final int maxAddressLength = 9;
    public static final int maxCoord = 139967;
    public static final int minCoord = -139967;
    public static final int coordRange = 279935;
    public static final int minDirectDimension = -648;
    public static final int maxDimensionIndex = 1295;
    public static final int dimensionRange = 1296;
    static final String padding = "---------";
    static final long mc = 279937L;
    static final long pc = 93563L;
    static final long qc = 153742L;
    static final long md = 1297L;
    static final long pd = 953L;
    static final long qd = 788L;
    static final long mdOld = 1298L;
    static final long qdOld = 459L;

    protected static boolean isValidSymbolChar(char c) {
        return SGAddressing.isValidSymbolChar(String.valueOf(c));
    }

    protected static boolean isValidSymbolChar(String string) {
        return symbolChars.indexOf(string) >= 0;
    }

    protected static char symbolToChar(int n) {
        return symbolChars.charAt(n);
    }

    protected static int charToSymbol(char c) {
        return SGAddressing.charToSymbol(String.valueOf(c));
    }

    protected static int charToSymbol(String string) {
        return symbolChars.indexOf(string);
    }

    protected static boolean validSymbols(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (SGAddressing.charToSymbol(string.charAt(i)) >= 0) continue;
            return false;
        }
        return true;
    }

    protected static void validateAddress(String string) throws AddressingError {
        int n = string.length();
        if ((n == 7 || n == 9) && SGAddressing.validSymbols(string)) {
            return;
        }
        throw malformedAddressError;
    }

    public static String normalizeAddress(String string) {
        return string.replace("-", "").toUpperCase();
    }

    protected static String coordSymbolsOf(String string) {
        return string.substring(0, 7);
    }

    protected static String dimensionSymbolsOf(String string) {
        return string.substring(7);
    }

    public static String addressForLocation(SGLocation sGLocation) throws AddressingError {
        if (debugAddressing) {
            System.out.printf("SGAddressing.addressForLocation: coord range = %d to %d\n", -139967, 139967);
        }
        int n = sGLocation.pos.getX() >> 4;
        int n2 = sGLocation.pos.getZ() >> 4;
        if (!SGAddressing.inCoordRange(n) || !SGAddressing.inCoordRange(n2)) {
            throw coordRangeError;
        }
        Integer n3 = SGDimensionMap.indexForDimension(sGLocation.dimension);
        if (n3 > 1295) {
            throw dimensionRangeError;
        }
        long l = SGAddressing.interleaveCoords(SGAddressing.hash(n - -139967, 93563L, 279937L), SGAddressing.hash(n2 - -139967, 93563L, 279937L));
        int n4 = SGAddressing.permuteDimension(l, n3);
        int n5 = SGAddressing.hash(n4, 953L, 1297L);
        if (debugAddressing) {
            System.out.printf("SGAddressing.addressForLocation: chunk (%d,%d) in dimension %d gives c = %s d = %d\n", n, n2, sGLocation.dimension, l, n5);
        }
        return SGAddressing.longToSymbols(l, 7) + SGAddressing.intToSymbols(n5, 2);
    }

    public static SGBaseTE findAddressedStargate(String string, World world) throws AddressingError {
        if (debugAddressing) {
            System.out.printf("SGAddressing.findAddressedStargate: %s\n", string);
        }
        SGAddressing.validateAddress(string);
        String string2 = string.substring(0, 7);
        long l = SGAddressing.longFromSymbols(string2);
        int[] nArray = SGAddressing.uninterleaveCoords(l);
        int n = -139967 + SGAddressing.hash(nArray[0], 153742L, 279937L);
        int n2 = -139967 + SGAddressing.hash(nArray[1], 153742L, 279937L);
        if (debugAddressing) {
            System.out.printf("SGAddressing.findAddressedStargate: c = %s chunk = (%d,%d)\n", l, n, n2);
        }
        SGBaseTE sGBaseTE = null;
        if (string.length() == 9) {
            String string3 = string.substring(7);
            int n3 = SGAddressing.intFromSymbols(string3);
            int n4 = SGAddressing.hash(n3, 788L, 1297L);
            int n5 = SGAddressing.unpermuteDimension(l, n4);
            Integer n6 = SGDimensionMap.dimensionForIndex(n5);
            if (debugAddressing) {
                System.out.printf("SGAddressing.findAddressedStargate: d = %s dimension = %s\n", n3, n6);
            }
            if (n6 != null) {
                sGBaseTE = SGAddressing.getBaseTE(n, n2, n6);
            }
            if (sGBaseTE == null) {
                int n7 = -648 + SGAddressing.hash(n3, 459L, 1298L);
                if (debugAddressing) {
                    System.out.printf("SGAddressing.findAddressedStargate: Trying dimension = %s\n", n7);
                }
                sGBaseTE = SGAddressing.getBaseTE(n, n2, n7);
            }
        } else {
            int n8 = world.field_73011_w.field_76574_g;
            sGBaseTE = SGAddressing.getBaseTE(n, n2, n8);
        }
        return sGBaseTE;
    }

    protected static SGBaseTE getBaseTE(int n, int n2, int n3) {
        Chunk chunk;
        WorldServer worldServer = SGAddressing.getWorld(n3);
        if (worldServer != null && (chunk = worldServer.func_72964_e(n, n2)) != null) {
            for (Object v : chunk.field_150816_i.values()) {
                if (!(v instanceof SGBaseTE)) continue;
                return (SGBaseTE)v;
            }
        }
        return null;
    }

    protected static int permuteDimension(long l, int n) {
        return (int)(((long)n + l) % 1296L);
    }

    protected static int unpermuteDimension(long l, int n) {
        int n2 = (int)(((long)n - l) % 1296L);
        if (n2 < 0) {
            n2 += 1296;
        }
        return n2;
    }

    protected static long interleaveCoords(int n, int n2) {
        if (debugAddressing) {
            System.out.printf("SGAddressing.interleaveCoords: %d, %d\n", n, n2);
        }
        long l = 1L;
        long l2 = 0L;
        while (n > 0 || n2 > 0) {
            if (debugAddressing) {
                System.out.printf("SGAddressing.interleaveCoords: half-digits %d %d\n", n % 6, n2 % 6);
            }
            l2 += l * (long)(n % 6);
            n /= 6;
            l2 += (l *= 6L) * (long)(n2 % 6);
            n2 /= 6;
            l *= 6L;
        }
        return l2;
    }

    protected static int[] uninterleaveCoords(long l) {
        int n = 1;
        int[] nArray = new int[]{0, 0};
        while (l > 0L) {
            nArray[0] = (int)((long)nArray[0] + (long)n * (l % 6L));
            nArray[1] = (int)((long)nArray[1] + (long)n * ((l /= 6L) % 6L));
            l /= 6L;
            n *= 6;
        }
        return nArray;
    }

    protected static int hash(int n, long l, long l2) {
        int n2 = (int)((long)(n + 1) * l % l2) - 1;
        if (debugAddressing) {
            System.out.printf("SGAddressing.hash(%s, %s, %s) = %s\n", n, l, l2, n2);
        }
        return n2;
    }

    public static WorldServer getWorld(int n) {
        return BaseUtils.getWorldForDimension(n);
    }

    protected static boolean inCoordRange(int n) {
        return n >= -139967 && n <= 139967;
    }

    protected static String intToSymbols(int n, int n2) {
        return SGAddressing.longToSymbols(n, n2);
    }

    protected static String longToSymbols(long l, int n) {
        String string = "";
        while (n-- > 0) {
            string = SGAddressing.symbolToChar((int)(l % (long)numSymbols)) + string;
            l /= (long)numSymbols;
        }
        return string;
    }

    protected static int intFromSymbols(String string) {
        return (int)SGAddressing.longFromSymbols(string);
    }

    protected static long longFromSymbols(String string) {
        long l = 0L;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            l = l * (long)numSymbols + (long)SGAddressing.charToSymbol(c);
        }
        return l;
    }

    public static String padAddress(String string, String string2, int n) {
        if (n < 7) {
            n = 7;
        }
        return SGAddressing.formatAddress(string + padding.substring(string.length(), n), " ", " ");
    }

    public static String formatAddress(String string, String string2, String string3) {
        String string4 = string.substring(0, 7);
        String string5 = string.substring(7);
        int n = 4;
        String string6 = string4.substring(0, n) + string2 + string4.substring(n);
        if (string5.length() > 0) {
            string6 = string6 + string3 + string5;
        }
        return string6;
    }

    public static String localAddress(String string) {
        return string.substring(0, 7);
    }

    static class AddressingError
    extends Exception {
        AddressingError(String string) {
            super(string);
        }
    }
}

