/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseBlock;
import gcewing.sg.BaseBlockUtils;
import gcewing.sg.BaseConfiguration;
import gcewing.sg.BaseMod;
import gcewing.sg.BaseOrientation;
import gcewing.sg.BlockPos;
import gcewing.sg.EnumWorldBlockLayer;
import gcewing.sg.IBlockState;
import gcewing.sg.SGBaseTE;
import gcewing.sg.SGBlock;
import gcewing.sg.SGCraft;
import gcewing.sg.SGGui;
import gcewing.sg.SGRingBlock;
import gcewing.sg.SGState;
import gcewing.sg.Trans3;
import gcewing.sg.Vector3;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SGBaseBlock
extends SGBlock<SGBaseTE> {
    static boolean debugMerge = false;
    static int explosionRadius = 10;
    static boolean fieryExplosion = true;
    static boolean smokyExplosion = true;
    static int[][] pattern = new int[][]{{2, 1, 2, 1, 2}, {1, 0, 0, 0, 1}, {2, 0, 0, 0, 2}, {1, 0, 0, 0, 1}, {2, 1, 0, 1, 2}};
    protected static String[] textures = new String[]{"stargateBlock", "stargateRing", "stargateBase_front"};
    protected static BaseMod.ModelSpec model = new BaseMod.ModelSpec("block/sg_base_block.smeg", textures);

    public static void configure(BaseConfiguration baseConfiguration) {
        explosionRadius = baseConfiguration.getInteger("stargate", "explosionRadius", explosionRadius);
        fieryExplosion = baseConfiguration.getBoolean("stargate", "explosionFlame", fieryExplosion);
        smokyExplosion = baseConfiguration.getBoolean("stargate", "explosionSmoke", smokyExplosion);
    }

    public SGBaseBlock() {
        super(Material.field_151576_e, SGBaseTE.class);
        this.func_149711_c(1.5f);
        this.func_149647_a(CreativeTabs.field_78026_f);
    }

    @Override
    public boolean canRenderInLayer(EnumWorldBlockLayer enumWorldBlockLayer) {
        return true;
    }

    @Override
    public BaseBlock.IOrientationHandler getOrientationHandler() {
        return BaseOrientation.orient4WaysByState;
    }

    @Override
    public String[] getTextureNames() {
        return textures;
    }

    @Override
    public BaseMod.ModelSpec getModelSpec(IBlockState iBlockState) {
        return model;
    }

    @Override
    public SGBaseTE getBaseTE(IBlockAccess iBlockAccess, BlockPos blockPos) {
        return (SGBaseTE)this.getTileEntity(iBlockAccess, blockPos);
    }

    @Override
    protected String getRendererClassName() {
        return "SGRingBlockRenderer";
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean isSideSolid(IBlockAccess iBlockAccess, BlockPos blockPos, EnumFacing enumFacing) {
        return true;
    }

    @Override
    public boolean canHarvestBlock(IBlockState iBlockState, EntityPlayer entityPlayer) {
        return true;
    }

    @Override
    public boolean isMerged(IBlockAccess iBlockAccess, BlockPos blockPos) {
        SGBaseTE sGBaseTE = (SGBaseTE)this.getTileEntity(iBlockAccess, blockPos);
        return sGBaseTE != null && sGBaseTE.isMerged;
    }

    @Override
    public void onBlockAdded(World world, BlockPos blockPos, IBlockState iBlockState) {
        if (debugMerge) {
            System.out.printf("SGBaseBlock.onBlockAdded: at %s\n", blockPos);
        }
        this.checkForMerge(world, blockPos);
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos blockPos, IBlockState iBlockState, EntityPlayer entityPlayer, EnumFacing enumFacing, float f, float f2, float f3) {
        if (!world.field_72995_K) {
            System.out.printf("SGBaseBlock: at %s meta %s state %s\n", blockPos, world.func_72805_g(blockPos.x, blockPos.y, blockPos.z), iBlockState);
        }
        String string = world.field_72995_K ? "Client" : "Server";
        SGBaseTE sGBaseTE = (SGBaseTE)this.getTileEntity((IBlockAccess)world, blockPos);
        if (sGBaseTE != null) {
            if (debugMerge) {
                System.out.printf("SGBaseBlock.onBlockActivated: %s: isMerged = %s\n", string, sGBaseTE.isMerged);
            }
            if (sGBaseTE.isMerged) {
                SGCraft.mod.openGui(entityPlayer, (Enum)SGGui.SGBase, world, blockPos);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean getWeakChanges(IBlockAccess iBlockAccess, BlockPos blockPos) {
        return true;
    }

    @Override
    public void onNeighborBlockChange(World world, BlockPos blockPos, IBlockState iBlockState, Block block) {
        SGBaseTE sGBaseTE = (SGBaseTE)this.getTileEntity((IBlockAccess)world, blockPos);
        if (sGBaseTE != null) {
            sGBaseTE.onNeighborBlockChange();
        }
    }

    void checkForMerge(World world, BlockPos blockPos) {
        if (debugMerge) {
            System.out.printf("SGBaseBlock.checkForMerge at %s\n", blockPos);
        }
        if (!this.isMerged((IBlockAccess)world, blockPos)) {
            int n;
            Trans3 trans3 = this.localToGlobalTransformation((IBlockAccess)world, blockPos);
            for (int i = -2; i <= 2; ++i) {
                for (n = 0; n <= 4; ++n) {
                    if (i == 0 && n == 0) continue;
                    BlockPos blockPos2 = trans3.p(i, n, 0.0).blockPos();
                    int n2 = this.getRingBlockType(world, blockPos2);
                    int n3 = pattern[4 - n][2 + i];
                    if (n3 == 0 || n2 == n3) continue;
                    if (debugMerge) {
                        System.out.printf("SGBaseBlock: world %d != pattern %d at %s\n", n2, pattern[n][2 + i], blockPos2);
                    }
                    return;
                }
            }
            if (debugMerge) {
                System.out.printf("SGBaseBlock: Merging\n", new Object[0]);
            }
            SGBaseTE sGBaseTE = (SGBaseTE)this.getTileEntity((IBlockAccess)world, blockPos);
            sGBaseTE.setMerged(true);
            BaseBlockUtils.markWorldBlockForUpdate(world, blockPos);
            for (n = -2; n <= 2; ++n) {
                for (int i = 0; i <= 4; ++i) {
                    BlockPos blockPos3;
                    Block block;
                    if (n == 0 && i == 0 || !((block = BaseBlockUtils.getWorldBlock((IBlockAccess)world, blockPos3 = trans3.p(n, i, 0.0).blockPos())) instanceof SGRingBlock)) continue;
                    ((SGRingBlock)block).mergeWith(world, blockPos3, blockPos);
                }
            }
            sGBaseTE.checkForLink();
        }
    }

    int getRingBlockType(World world, BlockPos blockPos) {
        Block block = BaseBlockUtils.getWorldBlock((IBlockAccess)world, blockPos);
        if (block == Blocks.field_150350_a) {
            return 0;
        }
        if (block == SGCraft.sgRingBlock && !SGCraft.sgRingBlock.isMerged((IBlockAccess)world, blockPos)) {
            IBlockState iBlockState = BaseBlockUtils.getWorldBlockState((IBlockAccess)world, blockPos);
            switch (iBlockState.getValue(SGRingBlock.VARIANT)) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
            }
        }
        return -1;
    }

    @Override
    public void breakBlock(World world, BlockPos blockPos, IBlockState iBlockState) {
        this.unmerge(world, blockPos);
        this.dropUpgrades(world, blockPos);
        super.breakBlock(world, blockPos, iBlockState);
    }

    void dropUpgrades(World world, BlockPos blockPos) {
        SGBaseTE sGBaseTE = (SGBaseTE)this.getTileEntity((IBlockAccess)world, blockPos);
        if (sGBaseTE != null) {
            if (sGBaseTE.hasChevronUpgrade) {
                this.spawnAsEntity(world, blockPos, new ItemStack(SGCraft.sgChevronUpgrade));
            }
            if (sGBaseTE.hasIrisUpgrade) {
                this.spawnAsEntity(world, blockPos, new ItemStack(SGCraft.sgIrisUpgrade));
            }
        }
    }

    public void unmerge(World world, BlockPos blockPos) {
        SGBaseTE sGBaseTE = (SGBaseTE)this.getTileEntity((IBlockAccess)world, blockPos);
        boolean bl = false;
        if (sGBaseTE != null) {
            if (sGBaseTE.isMerged && sGBaseTE.state == SGState.Connected) {
                sGBaseTE.state = SGState.Idle;
                bl = true;
            }
            sGBaseTE.disconnect();
            sGBaseTE.unlinkFromController();
            sGBaseTE.setMerged(false);
            BaseBlockUtils.markWorldBlockForUpdate(world, blockPos);
            this.unmergeRing(world, blockPos);
        }
        if (bl && explosionRadius > 0) {
            this.explode(world, new Vector3(blockPos).add(0.5, 2.5, 0.5), explosionRadius);
        }
    }

    void explode(World world, Vector3 vector3, double d) {
        world.func_72885_a(null, vector3.x, vector3.y, vector3.z, (float)d, fieryExplosion, smokyExplosion);
    }

    void unmergeRing(World world, BlockPos blockPos) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = 0; j <= 4; ++j) {
                for (int k = -2; k <= 2; ++k) {
                    this.unmergeRingBlock(world, blockPos, blockPos.add(i, j, k));
                }
            }
        }
    }

    void unmergeRingBlock(World world, BlockPos blockPos, BlockPos blockPos2) {
        Block block = BaseBlockUtils.getWorldBlock((IBlockAccess)world, blockPos2);
        if (debugMerge) {
            System.out.printf("SGBaseBlock.unmergeRingBlock: found %s at %s\n", block, blockPos2);
        }
        if (block instanceof SGRingBlock) {
            ((SGRingBlock)block).unmergeFrom(world, blockPos2, blockPos);
        }
    }

    public boolean func_149744_f() {
        return true;
    }

    @Override
    public int getStrongPower(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, EnumFacing enumFacing) {
        return this.getWeakPower(iBlockAccess, blockPos, iBlockState, enumFacing);
    }

    @Override
    public int getWeakPower(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, EnumFacing enumFacing) {
        SGBaseTE sGBaseTE = (SGBaseTE)this.getTileEntity(iBlockAccess, blockPos);
        return sGBaseTE != null && sGBaseTE.state != SGState.Idle ? 15 : 0;
    }
}

