/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import gcewing.sg.BaseBlockUtils;
import gcewing.sg.BaseConfiguration;
import gcewing.sg.BaseInventoryUtils;
import gcewing.sg.BaseTileInventory;
import gcewing.sg.BaseUtils;
import gcewing.sg.BlockPos;
import gcewing.sg.BlockRef;
import gcewing.sg.DHDTE;
import gcewing.sg.IComputerInterface;
import gcewing.sg.ISGEnergySource;
import gcewing.sg.IrisEntity;
import gcewing.sg.IrisState;
import gcewing.sg.SGAddressing;
import gcewing.sg.SGBaseBlock;
import gcewing.sg.SGCraft;
import gcewing.sg.SGInterfaceTE;
import gcewing.sg.SGLocation;
import gcewing.sg.SGRingTE;
import gcewing.sg.SGState;
import gcewing.sg.Trans3;
import gcewing.sg.Utils;
import gcewing.sg.Vector3;
import gcewing.sg.oc.OCWirelessEndpoint;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.network.play.server.S1FPacketSetExperience;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.network.ForgeMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SGBaseTE
extends BaseTileInventory {
    static boolean debugState = false;
    static boolean debugEnergyUse = false;
    static boolean debugConnect = false;
    static boolean debugTransientDamage = false;
    static boolean debugTeleport = false;
    public static final String symbolChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    public static final int numRingSymbols = SGAddressing.numSymbols;
    public static final double ringSymbolAngle = 360.0 / (double)numRingSymbols;
    public static final double irisZPosition = 0.1;
    public static final double irisThickness = 0.2;
    public static final DamageSource irisDamageSource = new DamageSource("sgcraft:iris");
    public static final float irisDamageAmount = 1000000.0f;
    static final int diallingTime = 40;
    static final int interDiallingTime = 10;
    static final String diallingSound = "sgcraft:sg_dial7";
    static final int transientDuration = 20;
    static final int disconnectTime = 30;
    static final double openingTransientIntensity = 1.3;
    static final double openingTransientRandomness = 0.25;
    static final double closingTransientRandomness = 0.25;
    static final double transientDamageRate = 50.0;
    static final int maxIrisPhase = 60;
    static final int firstCamouflageSlot = 0;
    static final int numCamouflageSlots = 5;
    static final int numInventorySlots = 5;
    static float defaultChevronAngle = 40.0f;
    static float[][] chevronAngles = new float[][]{{45.0f, 45.0f, 40.0f}, {36.0f, 33.0f, 30.0f}};
    static double maxEnergyBuffer = 1000.0;
    static double energyPerFuelItem = 96000.0;
    static double distanceFactorMultiplier = 1.0;
    static double interDimensionMultiplier = 4.0;
    static int gateOpeningsPerFuelItem = 24;
    static int minutesOpenPerFuelItem = 80;
    static int secondsToStayOpen = 300;
    static boolean oneWayTravel = false;
    static boolean closeFromEitherEnd = true;
    static int chunkLoadingRange = 1;
    static boolean logStargateEvents = false;
    static boolean preserveInventory = false;
    static float soundVolume = 1.0f;
    static boolean variableChevronPositions = true;
    public static double energyToOpen;
    static double energyUsePerTick;
    static int ticksToStayOpen;
    public static boolean transparency;
    static Random random;
    static DamageSource transientDamage;
    public boolean isMerged;
    public SGState state = SGState.Idle;
    public double ringAngle;
    public double lastRingAngle;
    public double targetRingAngle;
    public int numEngagedChevrons;
    public String dialledAddress = "";
    public boolean isLinkedToController;
    public BlockPos linkedPos = new BlockPos(0, 0, 0);
    public boolean hasChevronUpgrade;
    public boolean hasIrisUpgrade;
    public IrisState irisState = IrisState.Open;
    public int irisPhase = 60;
    public int lastIrisPhase = 60;
    public OCWirelessEndpoint ocWirelessEndpoint;
    SGLocation connectedLocation;
    boolean isInitiator;
    int timeout;
    double energyInBuffer;
    double distanceFactor;
    boolean redstoneInput;
    boolean loaded;
    public String homeAddress;
    public String addressError;
    IInventory inventory = new InventoryBasic("Stargate", false, 5);
    double[][][] ehGrid;
    List<TrackedEntity> trackedEntities = new ArrayList<TrackedEntity>();

    public static void configure(BaseConfiguration baseConfiguration) {
        energyPerFuelItem = baseConfiguration.getDouble("stargate", "energyPerFuelItem", energyPerFuelItem);
        gateOpeningsPerFuelItem = baseConfiguration.getInteger("stargate", "gateOpeningsPerFuelItem", gateOpeningsPerFuelItem);
        minutesOpenPerFuelItem = baseConfiguration.getInteger("stargate", "minutesOpenPerFuelItem", minutesOpenPerFuelItem);
        secondsToStayOpen = baseConfiguration.getInteger("stargate", "secondsToStayOpen", secondsToStayOpen);
        oneWayTravel = baseConfiguration.getBoolean("stargate", "oneWayTravel", oneWayTravel);
        closeFromEitherEnd = baseConfiguration.getBoolean("stargate", "closeFromEitherEnd", closeFromEitherEnd);
        maxEnergyBuffer = baseConfiguration.getDouble("stargate", "maxEnergyBuffer", maxEnergyBuffer);
        energyToOpen = energyPerFuelItem / (double)gateOpeningsPerFuelItem;
        energyUsePerTick = energyPerFuelItem / (double)(minutesOpenPerFuelItem * 60 * 20);
        distanceFactorMultiplier = baseConfiguration.getDouble("stargate", "distanceFactorMultiplier", distanceFactorMultiplier);
        interDimensionMultiplier = baseConfiguration.getDouble("stargate", "interDimensionMultiplier", interDimensionMultiplier);
        if (debugEnergyUse) {
            System.out.printf("SGBaseTE: energyPerFuelItem = %s\n", energyPerFuelItem);
            System.out.printf("SGBaseTE: energyToOpen = %s\n", energyToOpen);
            System.out.printf("SGBaseTE: energyUsePerTick = %s\n", energyUsePerTick);
        }
        ticksToStayOpen = 20 * secondsToStayOpen;
        chunkLoadingRange = baseConfiguration.getInteger("options", "chunkLoadingRange", chunkLoadingRange);
        transparency = baseConfiguration.getBoolean("stargate", "transparency", transparency);
        logStargateEvents = baseConfiguration.getBoolean("options", "logStargateEvents", logStargateEvents);
        preserveInventory = baseConfiguration.getBoolean("iris", "preserveInventory", preserveInventory);
        soundVolume = (float)baseConfiguration.getDouble("stargate", "soundVolume", soundVolume);
        variableChevronPositions = baseConfiguration.getBoolean("stargate", "variableChevronPositions", variableChevronPositions);
    }

    public static SGBaseTE get(IBlockAccess iBlockAccess, BlockPos blockPos) {
        TileEntity tileEntity = BaseBlockUtils.getWorldTileEntity(iBlockAccess, blockPos);
        if (tileEntity instanceof SGBaseTE) {
            return (SGBaseTE)tileEntity;
        }
        if (tileEntity instanceof SGRingTE) {
            return ((SGRingTE)tileEntity).getBaseTE();
        }
        return null;
    }

    public String toString() {
        return String.format("SGBaseTE(pos=%s,dim=%s)", this.getPos(), BaseUtils.getWorldDimensionId(this.field_145850_b));
    }

    public AxisAlignedBB getRenderBoundingBox() {
        int n = this.getX();
        int n2 = this.getY();
        int n3 = this.getZ();
        return BaseUtils.newAxisAlignedBB(n - 2, n2, n3 - 2, n + 3, n2 + 5, n3 + 3);
    }

    public double func_145833_n() {
        return 32768.0;
    }

    @Override
    public void onAddedToWorld() {
        if (SGBaseBlock.debugMerge) {
            System.out.printf("SGBaseTE.onAddedToWorld\n", new Object[0]);
        }
        this.updateChunkLoadingStatus();
    }

    void updateChunkLoadingStatus() {
        if (this.state != SGState.Idle) {
            int n = chunkLoadingRange;
            if (n >= 0) {
                SGCraft.chunkManager.setForcedChunkRange(this, -n, -n, n, n);
            }
        } else {
            SGCraft.chunkManager.clearForcedChunkRange(this);
        }
    }

    public static SGBaseTE at(IBlockAccess iBlockAccess, BlockPos blockPos) {
        TileEntity tileEntity = BaseBlockUtils.getWorldTileEntity(iBlockAccess, blockPos);
        if (tileEntity instanceof SGBaseTE) {
            return (SGBaseTE)tileEntity;
        }
        return null;
    }

    public static SGBaseTE at(SGLocation sGLocation) {
        WorldServer worldServer;
        if (sGLocation != null && (worldServer = SGAddressing.getWorld(sGLocation.dimension)) != null) {
            return SGBaseTE.at((IBlockAccess)worldServer, sGLocation.pos);
        }
        return null;
    }

    public static SGBaseTE at(IBlockAccess iBlockAccess, NBTTagCompound nBTTagCompound) {
        BlockPos blockPos = new BlockPos(nBTTagCompound.func_74762_e("x"), nBTTagCompound.func_74762_e("y"), nBTTagCompound.func_74762_e("z"));
        return SGBaseTE.at(iBlockAccess, blockPos);
    }

    void setMerged(boolean bl) {
        if (this.isMerged != bl) {
            String string;
            this.isMerged = bl;
            this.markBlockChanged();
            if (logStargateEvents && (string = this.tryToGetHomeAddress()) != null) {
                Logger logger = LogManager.getLogger();
                String string2 = this.isMerged ? "ADDED" : "REMOVED";
                String string3 = this.field_145850_b.func_72912_H().func_76065_j();
                logger.info(String.format("STARGATE %s %s %s %s", string2, string3, this.getPos(), string));
            }
            this.updateIrisEntity();
        }
    }

    String tryToGetHomeAddress() {
        try {
            return this.getHomeAddress();
        }
        catch (SGAddressing.AddressingError addressingError) {
            return null;
        }
    }

    public int dimension() {
        if (this.field_145850_b != null) {
            return BaseUtils.getWorldDimensionId(this.field_145850_b);
        }
        return -999;
    }

    @Override
    public void readContentsFromNBT(NBTTagCompound nBTTagCompound) {
        super.readContentsFromNBT(nBTTagCompound);
        this.isMerged = nBTTagCompound.func_74767_n("isMerged");
        this.state = SGState.valueOf(nBTTagCompound.func_74762_e("state"));
        this.targetRingAngle = nBTTagCompound.func_74769_h("targetRingAngle");
        this.numEngagedChevrons = nBTTagCompound.func_74762_e("numEngagedChevrons");
        this.dialledAddress = nBTTagCompound.func_74779_i("dialledAddress");
        this.isLinkedToController = nBTTagCompound.func_74767_n("isLinkedToController");
        int n = nBTTagCompound.func_74762_e("linkedX");
        int n2 = nBTTagCompound.func_74762_e("linkedY");
        int n3 = nBTTagCompound.func_74762_e("linkedZ");
        this.linkedPos = new BlockPos(n, n2, n3);
        this.hasChevronUpgrade = nBTTagCompound.func_74767_n("hasChevronUpgrade");
        if (nBTTagCompound.func_74764_b("connectedLocation")) {
            this.connectedLocation = new SGLocation(nBTTagCompound.func_74775_l("connectedLocation"));
        }
        this.isInitiator = nBTTagCompound.func_74767_n("isInitiator");
        this.timeout = nBTTagCompound.func_74762_e("timeout");
        this.energyInBuffer = nBTTagCompound.func_74764_b("energyInBuffer") ? nBTTagCompound.func_74769_h("energyInBuffer") : (double)nBTTagCompound.func_74762_e("fuelBuffer");
        this.distanceFactor = nBTTagCompound.func_74769_h("distanceFactor");
        this.hasIrisUpgrade = nBTTagCompound.func_74767_n("hasIrisUpgrade");
        this.irisState = IrisState.valueOf(nBTTagCompound.func_74762_e("irisState"));
        this.irisPhase = nBTTagCompound.func_74762_e("irisPhase");
        this.redstoneInput = nBTTagCompound.func_74767_n("redstoneInput");
        this.homeAddress = this.getStringOrNull(nBTTagCompound, "address");
        this.addressError = nBTTagCompound.func_74779_i("addressError");
    }

    protected String getStringOrNull(NBTTagCompound nBTTagCompound, String string) {
        if (nBTTagCompound.func_74764_b(string)) {
            return nBTTagCompound.func_74779_i(string);
        }
        return null;
    }

    @Override
    public void writeContentsToNBT(NBTTagCompound nBTTagCompound) {
        super.writeContentsToNBT(nBTTagCompound);
        nBTTagCompound.func_74757_a("isMerged", this.isMerged);
        nBTTagCompound.func_74768_a("state", this.state.ordinal());
        nBTTagCompound.func_74780_a("targetRingAngle", this.targetRingAngle);
        nBTTagCompound.func_74768_a("numEngagedChevrons", this.numEngagedChevrons);
        nBTTagCompound.func_74778_a("dialledAddress", this.dialledAddress);
        nBTTagCompound.func_74757_a("isLinkedToController", this.isLinkedToController);
        nBTTagCompound.func_74768_a("linkedX", this.linkedPos.getX());
        nBTTagCompound.func_74768_a("linkedY", this.linkedPos.getY());
        nBTTagCompound.func_74768_a("linkedZ", this.linkedPos.getZ());
        nBTTagCompound.func_74757_a("hasChevronUpgrade", this.hasChevronUpgrade);
        if (this.connectedLocation != null) {
            nBTTagCompound.func_74782_a("connectedLocation", (NBTBase)this.connectedLocation.toNBT());
        }
        nBTTagCompound.func_74757_a("isInitiator", this.isInitiator);
        nBTTagCompound.func_74768_a("timeout", this.timeout);
        nBTTagCompound.func_74780_a("energyInBuffer", this.energyInBuffer);
        nBTTagCompound.func_74780_a("distanceFactor", this.distanceFactor);
        nBTTagCompound.func_74757_a("hasIrisUpgrade", this.hasIrisUpgrade);
        nBTTagCompound.func_74768_a("irisState", this.irisState.ordinal());
        nBTTagCompound.func_74768_a("irisPhase", this.irisPhase);
        nBTTagCompound.func_74757_a("redstoneInput", this.redstoneInput);
        if (this.homeAddress != null) {
            nBTTagCompound.func_74778_a("address", this.homeAddress);
        }
        if (this.addressError != null) {
            nBTTagCompound.func_74778_a("addressError", this.addressError);
        }
    }

    public boolean isActive() {
        return this.state != SGState.Idle && this.state != SGState.Disconnecting;
    }

    static boolean isValidSymbolChar(String string) {
        return SGAddressing.isValidSymbolChar(string);
    }

    static char symbolToChar(int n) {
        return SGAddressing.symbolToChar(n);
    }

    static int charToSymbol(char c) {
        return SGAddressing.charToSymbol(c);
    }

    static int charToSymbol(String string) {
        return SGAddressing.charToSymbol(string);
    }

    public boolean applyChevronUpgrade(ItemStack itemStack, EntityPlayer entityPlayer) {
        if (!this.field_145850_b.field_72995_K && !this.hasChevronUpgrade && itemStack.field_77994_a > 0) {
            this.hasChevronUpgrade = true;
            --itemStack.field_77994_a;
            this.markChanged();
        }
        return true;
    }

    public boolean applyIrisUpgrade(ItemStack itemStack, EntityPlayer entityPlayer) {
        if (!this.field_145850_b.field_72995_K && !this.hasIrisUpgrade && itemStack.field_77994_a > 0) {
            this.hasIrisUpgrade = true;
            --itemStack.field_77994_a;
            this.markChanged();
            this.updateIrisEntity();
        }
        return true;
    }

    public int getNumChevrons() {
        if (this.hasChevronUpgrade) {
            return 9;
        }
        return 7;
    }

    public boolean chevronIsEngaged(int n) {
        return n < this.numEngagedChevrons;
    }

    public float angleBetweenChevrons() {
        if (variableChevronPositions) {
            int n = this.getNumChevrons() > 7 ? 1 : 0;
            int n2 = this.baseCornerCamouflage();
            return chevronAngles[n][n2];
        }
        return defaultChevronAngle;
    }

    Item getItemInSlot(int n) {
        ItemStack itemStack = this.func_70301_a(n);
        return itemStack != null ? itemStack.func_77973_b() : null;
    }

    public String getHomeAddress() throws SGAddressing.AddressingError {
        return SGAddressing.addressForLocation(new SGLocation(this));
    }

    public SGBaseBlock getBlock() {
        return (SGBaseBlock)this.func_145838_q();
    }

    public double interpolatedRingAngle(double d) {
        return Utils.interpolateAngle(this.lastRingAngle, this.ringAngle, d);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_145845_h() {
        this.tick();
    }

    public void tick() {
        if (this.field_145850_b.field_72995_K) {
            this.clientUpdate();
        } else {
            this.serverUpdate();
            this.checkForEntitiesInPortal();
        }
        this.irisUpdate();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && this.ocWirelessEndpoint != null) {
            this.ocWirelessEndpoint.remove();
        }
    }

    String side() {
        return this.field_145850_b.field_72995_K ? "Client" : "Server";
    }

    void enterState(SGState sGState, int n) {
        String string;
        String string2;
        if (debugState) {
            System.out.printf("SGBaseTE: at %s in dimension %s entering state %s with timeout %s\n", new Object[]{this.getPos(), BaseUtils.getWorldDimensionId(this.field_145850_b), sGState, n});
        }
        SGState sGState2 = this.state;
        this.state = sGState;
        this.timeout = n;
        this.markChanged();
        if (sGState2 == SGState.Idle != (sGState == SGState.Idle)) {
            this.updateChunkLoadingStatus();
            BaseBlockUtils.notifyWorldNeighborsOfStateChange(this.field_145850_b, this.getPos(), this.func_145838_q());
        }
        if (!(string2 = SGBaseTE.sgStateDescription(sGState2)).equals(string = SGBaseTE.sgStateDescription(sGState))) {
            this.postEvent("sgStargateStateChange", string, string2);
        }
    }

    public boolean isConnected() {
        return this.state == SGState.Transient || this.state == SGState.Connected || this.state == SGState.Disconnecting;
    }

    DHDTE getLinkedControllerTE() {
        TileEntity tileEntity;
        if (this.isLinkedToController && (tileEntity = BaseBlockUtils.getWorldTileEntity((IBlockAccess)this.field_145850_b, this.linkedPos)) instanceof DHDTE) {
            return (DHDTE)tileEntity;
        }
        return null;
    }

    void checkForLink() {
        int n = Math.max(DHDTE.linkRangeX, DHDTE.linkRangeY);
        int n2 = DHDTE.linkRangeZ;
        if (SGBaseBlock.debugMerge) {
            System.out.printf("SGBaseTE.checkForLink: in range +/-(%d,%d,%d) of %s\n", n, n2, n, this.getPos());
        }
        for (int i = -n; i <= n; ++i) {
            for (int j = -n2; j <= n2; ++j) {
                for (int k = -n; k <= n; ++k) {
                    TileEntity tileEntity = BaseBlockUtils.getWorldTileEntity((IBlockAccess)this.field_145850_b, this.getPos().add(i, j, k));
                    if (!(tileEntity instanceof DHDTE)) continue;
                    ((DHDTE)tileEntity).checkForLink();
                }
            }
        }
    }

    public void unlinkFromController() {
        if (this.isLinkedToController) {
            DHDTE dHDTE = this.getLinkedControllerTE();
            if (dHDTE != null) {
                dHDTE.clearLinkToStargate();
            }
            this.clearLinkToController();
        }
    }

    public void clearLinkToController() {
        if (SGBaseBlock.debugMerge) {
            System.out.printf("SGBaseTE: Unlinking stargate at %s from controller\n", this.getPos());
        }
        this.isLinkedToController = false;
        this.func_70296_d();
    }

    public void connectOrDisconnect(String string, EntityPlayer entityPlayer) {
        if (debugConnect) {
            System.out.printf("SGBaseTE: %s: connectOrDisconnect('%s') in state %s by %s\n", new Object[]{this.side(), string, this.state, entityPlayer});
        }
        if (string.length() > 0) {
            this.connect(string, entityPlayer);
        } else {
            this.attemptToDisconnect(entityPlayer);
        }
    }

    public String attemptToDisconnect(EntityPlayer entityPlayer) {
        boolean bl;
        boolean bl2 = this.disconnectionAllowed();
        SGBaseTE sGBaseTE = this.getConnectedStargateTE();
        boolean bl3 = bl = sGBaseTE != null && !sGBaseTE.func_145837_r() && sGBaseTE.getConnectedStargateTE() == this;
        if (bl2 || !bl) {
            if (this.state != SGState.Disconnecting) {
                this.disconnect();
            }
            return null;
        }
        return this.operationFailure(entityPlayer, "Connection initiated from other end");
    }

    public boolean disconnectionAllowed() {
        return this.isInitiator || closeFromEitherEnd;
    }

    String connect(String string, EntityPlayer entityPlayer) {
        SGBaseTE sGBaseTE;
        if (this.state != SGState.Idle) {
            return this.diallingFailure(entityPlayer, "Stargate is busy");
        }
        String string2 = this.findHomeAddress();
        if (string2.equals("")) {
            return this.diallingFailure(entityPlayer, "Coordinates of dialling stargate are out of range");
        }
        try {
            sGBaseTE = SGAddressing.findAddressedStargate(string, this.field_145850_b);
        }
        catch (SGAddressing.AddressingError addressingError) {
            return this.diallingFailure(entityPlayer, addressingError.getMessage());
        }
        if (sGBaseTE == null || !sGBaseTE.isMerged) {
            return this.diallingFailure(entityPlayer, "No stargate at address " + string);
        }
        if (this.field_145850_b == BaseBlockUtils.getTileEntityWorld(sGBaseTE)) {
            string = SGAddressing.localAddress(string);
            string2 = SGAddressing.localAddress(string2);
        }
        if (string.length() > this.getNumChevrons()) {
            return this.diallingFailure(entityPlayer, "Not enough chevrons to dial " + string);
        }
        if (sGBaseTE == this) {
            return this.diallingFailure(entityPlayer, "Stargate cannot connect to itself");
        }
        if (debugConnect) {
            System.out.printf("SGBaseTE.connect: to %s in dimension %d with state %s\n", new Object[]{sGBaseTE.getPos(), BaseUtils.getWorldDimensionId(BaseBlockUtils.getTileEntityWorld(sGBaseTE)), sGBaseTE.state});
        }
        if (sGBaseTE.getNumChevrons() < string2.length()) {
            return this.diallingFailure(entityPlayer, "Destination stargate has insufficient chevrons");
        }
        if (sGBaseTE.state != SGState.Idle) {
            return this.diallingFailure(entityPlayer, "Stargate at address " + string + " is busy");
        }
        this.distanceFactor = SGBaseTE.distanceFactorForCoordDifference(this, sGBaseTE);
        if (debugEnergyUse) {
            System.out.printf("SGBaseTE: distanceFactor = %s\n", this.distanceFactor);
        }
        if (!this.energyIsAvailable(energyToOpen * this.distanceFactor)) {
            return this.diallingFailure(entityPlayer, "Stargate has insufficient energy");
        }
        this.startDiallingStargate(string, sGBaseTE, true);
        sGBaseTE.startDiallingStargate(string2, this, false);
        return null;
    }

    public static double distanceFactorForCoordDifference(TileEntity tileEntity, TileEntity tileEntity2) {
        BlockPos blockPos = BaseBlockUtils.getTileEntityPos(tileEntity);
        BlockPos blockPos2 = BaseBlockUtils.getTileEntityPos(tileEntity2);
        double d = blockPos.getX() - blockPos2.getX();
        double d2 = blockPos.getZ() - blockPos2.getZ();
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (debugEnergyUse) {
            System.out.printf("SGBaseTE: Connection distance = %s\n", d3);
        }
        double d4 = Math.log(0.05 * d3 + 1.0);
        double d5 = Math.log(223948.0);
        double d6 = d4 / d5;
        double d7 = 1.0 + 14.0 * distanceFactorMultiplier * d6 * d6;
        if (BaseBlockUtils.getTileEntityWorld(tileEntity) != BaseBlockUtils.getTileEntityWorld(tileEntity2)) {
            d7 *= interDimensionMultiplier;
        }
        return d7;
    }

    public void playSGSoundEffect(String string, float f, float f2) {
        this.playSoundEffect(string, f * soundVolume, f2);
    }

    String diallingFailure(EntityPlayer entityPlayer, String string) {
        if (entityPlayer != null && this.state == SGState.Idle) {
            this.playSGSoundEffect("sgcraft:sg_abort", 1.0f, 1.0f);
        }
        return this.operationFailure(entityPlayer, string);
    }

    String operationFailure(EntityPlayer entityPlayer, String string) {
        if (entityPlayer != null) {
            SGBaseTE.sendChatMessage(entityPlayer, string);
        }
        return string;
    }

    static void sendChatMessage(EntityPlayer entityPlayer, String string) {
        entityPlayer.func_145747_a((IChatComponent)new ChatComponentText(string));
    }

    String findHomeAddress() {
        try {
            return this.getHomeAddress();
        }
        catch (SGAddressing.AddressingError addressingError) {
            System.out.printf("SGBaseTE.findHomeAddress: %s\n", addressingError);
            return "";
        }
    }

    public void disconnect() {
        SGBaseTE sGBaseTE;
        if (debugConnect) {
            System.out.printf("SGBaseTE: %s: disconnect()\n", this.side());
        }
        if ((sGBaseTE = SGBaseTE.at(this.connectedLocation)) != null) {
            sGBaseTE.clearConnection();
        }
        this.clearConnection();
    }

    public void clearConnection() {
        if (this.state != SGState.Idle || this.connectedLocation != null) {
            this.dialledAddress = "";
            this.connectedLocation = null;
            this.isInitiator = false;
            this.numEngagedChevrons = 0;
            this.markChanged();
            if (this.state == SGState.Connected) {
                this.enterState(SGState.Disconnecting, 30);
                this.playSGSoundEffect("sgcraft:sg_close", 1.0f, 1.0f);
            } else {
                if (this.state != SGState.Idle && this.state != SGState.Disconnecting) {
                    this.playSGSoundEffect("sgcraft:sg_abort", 1.0f, 1.0f);
                }
                this.enterState(SGState.Idle, 0);
            }
        }
    }

    void startDiallingStargate(String string, SGBaseTE sGBaseTE, boolean bl) {
        this.dialledAddress = string;
        this.connectedLocation = new SGLocation(sGBaseTE);
        this.isInitiator = bl;
        this.func_70296_d();
        this.startDiallingNextSymbol();
        this.postEvent(bl ? "sgDialOut" : "sgDialIn", string);
    }

    void serverUpdate() {
        if (!this.loaded) {
            this.loaded = true;
            try {
                this.homeAddress = this.getHomeAddress();
                this.addressError = "";
            }
            catch (SGAddressing.AddressingError addressingError) {
                this.homeAddress = null;
                this.addressError = addressingError.getMessage();
            }
            if (SGCraft.ocIntegration != null) {
                SGCraft.ocIntegration.onSGBaseTEAdded(this);
            }
        }
        if (this.isMerged) {
            if (debugState && this.state != SGState.Connected && this.timeout > 0) {
                int n = BaseUtils.getWorldDimensionId(this.field_145850_b);
                System.out.printf("SGBaseTE.serverUpdate at %s in dimension %d: state %s, timeout %s\n", new Object[]{this.getPos(), n, this.state, this.timeout});
            }
            this.tickEnergyUsage();
            if (this.timeout > 0) {
                if (this.state == SGState.Transient && !this.irisIsClosed()) {
                    this.performTransientDamage();
                }
                --this.timeout;
            } else {
                switch (this.state) {
                    case Idle: {
                        if (!this.undialledDigitsRemaining()) break;
                        this.startDiallingNextSymbol();
                        break;
                    }
                    case Dialling: {
                        this.finishDiallingSymbol();
                        break;
                    }
                    case InterDialling: {
                        this.startDiallingNextSymbol();
                        break;
                    }
                    case Transient: {
                        this.enterState(SGState.Connected, this.isInitiator ? ticksToStayOpen : 0);
                        break;
                    }
                    case Connected: {
                        if (!this.isInitiator || ticksToStayOpen <= 0) break;
                        this.disconnect();
                        break;
                    }
                    case Disconnecting: {
                        this.enterState(SGState.Idle, 0);
                    }
                }
            }
        }
    }

    void tickEnergyUsage() {
        if (this.state == SGState.Connected && this.isInitiator && !this.useEnergy(energyUsePerTick * this.distanceFactor)) {
            this.disconnect();
        }
    }

    double availableEnergy() {
        List<ISGEnergySource> list = this.findEnergySources();
        return this.energyInBuffer + this.energyAvailableFrom(list);
    }

    boolean energyIsAvailable(double d) {
        double d2 = this.availableEnergy();
        if (debugEnergyUse) {
            System.out.printf("SGBaseTE.energyIsAvailable: need %s, have %s\n", d, d2);
        }
        return d2 >= d;
    }

    boolean useEnergy(double d) {
        if (debugEnergyUse) {
            System.out.printf("SGBaseTE.useEnergy: %s; buffered: %s\n", d, this.energyInBuffer);
        }
        if (d <= this.energyInBuffer) {
            this.energyInBuffer -= d;
            return true;
        }
        List<ISGEnergySource> list = this.findEnergySources();
        double d2 = this.energyInBuffer + this.energyAvailableFrom(list);
        if (debugEnergyUse) {
            System.out.printf("SGBaseTE.useEnergy: %s available\n", d2);
        }
        if (d > d2) {
            System.out.printf("SGBaseTE: Not enough energy available\n", new Object[0]);
            return false;
        }
        double d3 = Math.max(d, maxEnergyBuffer);
        double d4 = Math.min(d3, d2);
        double d5 = d4 - this.energyInBuffer;
        if (debugEnergyUse) {
            System.out.printf("SGBaseTE.useEnergy: another %s required\n", d5);
        }
        double d6 = this.energyInBuffer + this.drawEnergyFrom(list, d5);
        if (debugEnergyUse) {
            System.out.printf("SGBaseTE.useEnergy: %s now on hand, need %s\n", d6, d);
        }
        if (d - 1.0E-4 > d6) {
            System.out.printf("SGBaseTE: Energy sources only delivered %s of promised %s\n", d6 - this.energyInBuffer, d2);
            return false;
        }
        this.setEnergyInBuffer(d6 - d);
        if (debugEnergyUse) {
            System.out.printf("SGBaseTE.useEnergy: %s left over in buffer\n", this.energyInBuffer);
        }
        return true;
    }

    List<ISGEnergySource> findEnergySources() {
        if (debugEnergyUse) {
            System.out.printf("SGBaseTe.findEnergySources: for %s\n", this.getPos());
        }
        ArrayList<ISGEnergySource> arrayList = new ArrayList<ISGEnergySource>();
        Trans3 trans3 = this.localToGlobalTransformation();
        for (int i = -2; i <= 2; ++i) {
            TileEntity tileEntity;
            BlockPos blockPos = trans3.p(i, -1.0, 0.0).blockPos();
            if (debugEnergyUse) {
                System.out.printf("SGBaseTE.findEnergySources: Checking %s\n", blockPos);
            }
            if (!((tileEntity = BaseBlockUtils.getWorldTileEntity((IBlockAccess)this.field_145850_b, blockPos)) instanceof ISGEnergySource)) continue;
            arrayList.add((ISGEnergySource)tileEntity);
        }
        DHDTE dHDTE = this.getLinkedControllerTE();
        if (dHDTE != null) {
            arrayList.add(dHDTE);
        }
        return arrayList;
    }

    double energyAvailableFrom(List<ISGEnergySource> list) {
        double d = 0.0;
        for (ISGEnergySource iSGEnergySource : list) {
            double d2 = iSGEnergySource.availableEnergy();
            if (debugEnergyUse) {
                System.out.printf("SGBaseTe.energyAvailableFrom: %s can supply %s\n", iSGEnergySource, d2);
            }
            d += d2;
        }
        return d;
    }

    double drawEnergyFrom(List<ISGEnergySource> list, double d) {
        double d2 = 0.0;
        for (ISGEnergySource iSGEnergySource : list) {
            if (d2 >= d) break;
            double d3 = iSGEnergySource.drawEnergy(d - d2);
            if (debugEnergyUse) {
                System.out.printf("SGBaseTe.drawEnergyFrom: %s supplied %s\n", iSGEnergySource, d3);
            }
            d2 += d3;
        }
        if (d2 < d) {
            System.out.printf("SGCraft: Warning: Energy sources did not deliver promised energy (%s requested, %s delivered)\n", d, d2);
        }
        return d2;
    }

    void setEnergyInBuffer(double d) {
        if (this.energyInBuffer != d) {
            this.energyInBuffer = d;
            this.func_70296_d();
        }
    }

    void performTransientDamage() {
        Entity entity2;
        Trans3 trans3 = this.localToGlobalTransformation();
        Vector3 vector3 = trans3.p(-1.5, 0.5, 0.5);
        Vector3 vector32 = trans3.p(1.5, 3.5, 5.5);
        Vector3 vector33 = vector3.min(vector32);
        Vector3 vector34 = vector3.max(vector32);
        AxisAlignedBB axisAlignedBB = BaseUtils.newAxisAlignedBB(vector33.x, vector33.y, vector33.z, vector34.x, vector34.y, vector34.z);
        if (debugTransientDamage) {
            System.out.printf("SGBaseTE.performTransientDamage: players in world:\n", new Object[0]);
            for (Entity entity2 : this.field_145850_b.field_72996_f) {
                if (!(entity2 instanceof EntityPlayer)) continue;
                System.out.printf("--- %s\n", entity2);
            }
            System.out.printf("SGBaseTE.performTransientDamage: box = %s\n", axisAlignedBB);
        }
        List list = this.field_145850_b.func_72872_a(EntityLivingBase.class, axisAlignedBB);
        entity2 = list.iterator();
        while (entity2.hasNext()) {
            EntityLivingBase entityLivingBase = (EntityLivingBase)entity2.next();
            Vector3 vector35 = new Vector3(entityLivingBase.field_70165_t, entityLivingBase.field_70163_u, entityLivingBase.field_70161_v);
            Vector3 vector36 = trans3.p(0.0, 2.0, 0.5);
            double d = vector35.distance(vector36);
            if (debugTransientDamage) {
                System.out.printf("SGBaseTE.performTransientDamage: found %s\n", entityLivingBase);
            }
            if (d > 1.0) {
                d = 1.0;
            }
            int n = (int)Math.ceil(d * 50.0);
            if (debugTransientDamage) {
                System.out.printf("SGBaseTE.performTransientDamage: distance = %s, damage = %s\n", d, n);
            }
            entityLivingBase.func_70097_a(transientDamage, (float)n);
        }
    }

    boolean undialledDigitsRemaining() {
        int n = this.numEngagedChevrons;
        return n < this.dialledAddress.length();
    }

    void startDiallingNextSymbol() {
        if (debugState) {
            System.out.printf("SGBaseTE.startDiallingNextSymbol: %s of %s\n", this.numEngagedChevrons, this.dialledAddress);
        }
        this.startDiallingSymbol(this.dialledAddress.charAt(this.numEngagedChevrons));
    }

    void startDiallingSymbol(char c) {
        int n = SGAddressing.charToSymbol(c);
        if (debugState) {
            System.out.printf("SGBaseTE.startDiallingSymbol: %s\n", n);
        }
        if (n >= 0 && n < numRingSymbols) {
            this.startDiallingToAngle((double)n * ringSymbolAngle);
            this.playSGSoundEffect(diallingSound, 1.0f, 1.0f);
        } else {
            System.out.printf("SGCraft: Stargate jammed trying to dial symbol %s\n", Character.valueOf(c));
            this.dialledAddress = "";
            this.enterState(SGState.Idle, 0);
        }
    }

    void startDiallingToAngle(double d) {
        this.targetRingAngle = Utils.normaliseAngle(d);
        this.enterState(SGState.Dialling, 40);
    }

    void finishDiallingSymbol() {
        ++this.numEngagedChevrons;
        String string = this.dialledAddress.substring(this.numEngagedChevrons - 1, this.numEngagedChevrons);
        this.postEvent("sgChevronEngaged", this.numEngagedChevrons, string);
        if (this.undialledDigitsRemaining()) {
            this.enterState(SGState.InterDialling, 10);
        } else {
            this.finishDiallingAddress();
        }
    }

    void finishDiallingAddress() {
        if (!this.isInitiator || this.useEnergy(energyToOpen * this.distanceFactor)) {
            this.enterState(SGState.Transient, 20);
            this.playSGSoundEffect("sgcraft:sg_open", 1.0f, 1.0f);
        } else {
            this.disconnect();
        }
    }

    boolean canTravelFromThisEnd() {
        return this.isInitiator || !oneWayTravel;
    }

    static String repr(Entity entity) {
        if (entity != null) {
            String string = String.format("%s#%s", entity.getClass().getSimpleName(), entity.func_145782_y());
            if (entity.field_70128_L) {
                string = string + "(dead)";
            }
            return string;
        }
        return "null";
    }

    void checkForEntitiesInPortal() {
        if (this.state == SGState.Connected) {
            for (TrackedEntity object2 : this.trackedEntities) {
                this.entityInPortal(object2.entity, object2.lastPos);
            }
            this.trackedEntities.clear();
            Vector3 vector3 = new Vector3(-1.5, 0.5, -3.5);
            Vector3 vector32 = new Vector3(1.5, 3.5, 3.5);
            Trans3 trans3 = this.localToGlobalTransformation();
            AxisAlignedBB axisAlignedBB = trans3.box(vector3, vector32);
            List list = this.field_145850_b.func_72872_a(Entity.class, axisAlignedBB);
            for (Entity entity : list) {
                if (entity instanceof EntityFishHook || entity.field_70128_L || entity.field_70154_o != null) continue;
                this.trackedEntities.add(new TrackedEntity(entity));
            }
        } else {
            this.trackedEntities.clear();
        }
    }

    public void entityInPortal(Entity entity, Vector3 vector3) {
        if (!entity.field_70128_L && this.state == SGState.Connected && this.canTravelFromThisEnd()) {
            Trans3 trans3 = this.localToGlobalTransformation();
            double d = entity.field_70165_t - vector3.x;
            double d2 = entity.field_70163_u - vector3.y;
            double d3 = entity.field_70161_v - vector3.z;
            Vector3 vector32 = trans3.ip(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            Vector3 vector33 = trans3.ip(2.0 * vector3.x - entity.field_70165_t, 2.0 * vector3.y - entity.field_70163_u, 2.0 * vector3.z - entity.field_70161_v);
            double d4 = 0.0;
            if (vector33.z >= d4 && vector32.z < d4 && vector32.z > d4 - 5.0) {
                entity.field_70159_w = d;
                entity.field_70181_x = d2;
                entity.field_70179_y = d3;
                SGBaseTE sGBaseTE = this.getConnectedStargateTE();
                if (sGBaseTE != null) {
                    Trans3 trans32 = sGBaseTE.localToGlobalTransformation();
                    while (entity.field_70154_o != null) {
                        entity = entity.field_70154_o;
                    }
                    this.teleportEntityAndRider(entity, trans3, trans32, this.connectedLocation.dimension, sGBaseTE.irisIsClosed());
                }
            }
        }
    }

    Entity teleportEntityAndRider(Entity entity, Trans3 trans3, Trans3 trans32, int n, boolean bl) {
        Entity entity2;
        if (debugTeleport) {
            System.out.printf("SGBaseTE.teleportEntityAndRider: destBlocked = %s\n", bl);
        }
        if ((entity2 = entity.field_70153_n) != null) {
            entity2.func_70078_a(null);
            entity2 = this.teleportEntityAndRider(entity2, trans3, trans32, n, bl);
        }
        SGBaseTE.unleashEntity(entity);
        entity = SGBaseTE.teleportEntity(entity, trans3, trans32, n, bl);
        if (entity != null && !entity.field_70128_L && entity2 != null && !entity2.field_70128_L) {
            entity2.func_70078_a(entity);
        }
        return entity;
    }

    protected static void unleashEntity(Entity entity) {
        if (entity instanceof EntityLiving) {
            ((EntityLiving)entity).func_110160_i(true, false);
        }
        for (EntityLiving entityLiving : SGBaseTE.entitiesWithinLeashRange(entity)) {
            if (!entityLiving.func_110167_bD() || entityLiving.func_110166_bE() != entity) continue;
            entityLiving.func_110160_i(true, false);
        }
    }

    protected static List<EntityLiving> entitiesWithinLeashRange(Entity entity) {
        AxisAlignedBB axisAlignedBB = AxisAlignedBB.func_72330_a((double)(entity.field_70165_t - 7.0), (double)(entity.field_70163_u - 7.0), (double)(entity.field_70161_v - 7.0), (double)(entity.field_70165_t + 7.0), (double)(entity.field_70163_u + 7.0), (double)(entity.field_70161_v + 7.0));
        return entity.field_70170_p.func_72872_a(EntityLiving.class, axisAlignedBB);
    }

    static Entity teleportEntity(Entity entity, Trans3 trans3, Trans3 trans32, int n, boolean bl) {
        Entity entity2 = null;
        if (debugTeleport) {
            System.out.printf("SGBaseTE.teleportEntity: %s (in dimension %d)  to dimension %d\n", SGBaseTE.repr(entity), entity.field_71093_bK, n);
            System.out.printf("SGBaseTE.teleportEntity: pos (%.2f, %.2f, %.2f) prev (%.2f, %.2f, %.2f) last (%.2f, %.2f, %.2f)\n", entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70169_q, entity.field_70167_r, entity.field_70166_s, entity.field_70142_S, entity.field_70137_T, entity.field_70136_U);
        }
        Vector3 vector3 = trans3.ip(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        Vector3 vector32 = trans3.iv(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
        Vector3 vector33 = trans3.iv(SGBaseTE.yawVector(entity));
        Vector3 vector34 = trans32.p(-vector3.x, vector3.y, -vector3.z);
        Vector3 vector35 = trans32.v(-vector32.x, vector32.y, -vector32.z);
        Vector3 vector36 = trans32.v(vector33.mul(-1.0));
        if (debugTeleport) {
            System.out.printf("SGBaseTE.teleportEntity: Facing old %s new %s\n", vector33, vector36);
        }
        double d = SGBaseTE.yawAngle(vector36, entity);
        if (debugTeleport) {
            System.out.printf("SGBaseTE.teleportEntity: new yaw %.2f\n", d);
        }
        if (!bl) {
            if (entity.field_71093_bK == n) {
                entity2 = SGBaseTE.teleportWithinDimension(entity, vector34, vector35, d, bl);
            } else {
                entity2 = SGBaseTE.teleportToOtherDimension(entity, vector34, vector35, d, n, bl);
                if (entity2 != null) {
                    entity2.field_71093_bK = n;
                }
            }
        } else {
            SGBaseTE.terminateEntityByIrisImpact(entity);
            SGBaseTE.playIrisHitSound((World)SGBaseTE.worldForDimension(n), vector34, entity);
        }
        return entity2;
    }

    static void terminateEntityByIrisImpact(Entity entity) {
        if (entity instanceof EntityPlayer) {
            SGBaseTE.terminatePlayerByIrisImpact((EntityPlayer)entity);
        } else {
            entity.func_70106_y();
        }
    }

    static void terminatePlayerByIrisImpact(EntityPlayer entityPlayer) {
        if (entityPlayer.field_71075_bZ.field_75098_d) {
            SGBaseTE.sendChatMessage(entityPlayer, "Destination blocked by iris");
        } else {
            if (!preserveInventory && !BaseUtils.getGameRuleBoolean(entityPlayer.field_70170_p.func_82736_K(), "keepInventory")) {
                BaseInventoryUtils.clearInventory((IInventory)entityPlayer.field_71071_by);
            }
            entityPlayer.func_70097_a(irisDamageSource, 1000000.0f);
        }
    }

    static WorldServer worldForDimension(int n) {
        MinecraftServer minecraftServer = MinecraftServer.func_71276_C();
        return minecraftServer.func_71218_a(n);
    }

    static void playIrisHitSound(World world, Vector3 vector3, Entity entity) {
        double d = Math.min((double)(entity.field_70130_N * entity.field_70131_O), 1.0);
        double d2 = 2.0 - d;
        if (debugTeleport) {
            System.out.printf("SGBaseTE.playIrisHitSound: at (%.3f,%.3f,%.3f) volume %.3f pitch %.3f\n", vector3.x, vector3.y, vector3.z, d, d2);
        }
        world.func_72908_a(vector3.x, vector3.y, vector3.z, "sgcraft:iris_hit", (float)d, (float)d2);
    }

    static Entity teleportWithinDimension(Entity entity, Vector3 vector3, Vector3 vector32, double d, boolean bl) {
        if (entity instanceof EntityPlayerMP) {
            return SGBaseTE.teleportPlayerWithinDimension((EntityPlayerMP)entity, vector3, vector32, d);
        }
        return SGBaseTE.teleportEntityToWorld(entity, vector3, vector32, d, (WorldServer)entity.field_70170_p, bl);
    }

    static Entity teleportPlayerWithinDimension(EntityPlayerMP entityPlayerMP, Vector3 vector3, Vector3 vector32, double d) {
        entityPlayerMP.field_70177_z = (float)d;
        entityPlayerMP.func_70634_a(vector3.x, vector3.y, vector3.z);
        entityPlayerMP.field_70170_p.func_72866_a((Entity)entityPlayerMP, false);
        return entityPlayerMP;
    }

    static Entity teleportToOtherDimension(Entity entity, Vector3 vector3, Vector3 vector32, double d, int n, boolean bl) {
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)entity;
            Vector3 vector33 = vector3.add(SGBaseTE.yawVector(d));
            SGBaseTE.transferPlayerToDimension(entityPlayerMP, n, vector33, d);
            return entityPlayerMP;
        }
        return SGBaseTE.teleportEntityToDimension(entity, vector3, vector32, d, n, bl);
    }

    static void sendDimensionRegister(EntityPlayerMP entityPlayerMP, int n) {
        int n2 = DimensionManager.getProviderType((int)n);
        ForgeMessage.DimensionRegisterMessage dimensionRegisterMessage = new ForgeMessage.DimensionRegisterMessage(n, n2);
        FMLEmbeddedChannel fMLEmbeddedChannel = NetworkRegistry.INSTANCE.getChannel("FORGE", Side.SERVER);
        fMLEmbeddedChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        fMLEmbeddedChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)entityPlayerMP);
        fMLEmbeddedChannel.writeAndFlush((Object)dimensionRegisterMessage).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    static void transferPlayerToDimension(EntityPlayerMP entityPlayerMP, int n, Vector3 vector3, double d) {
        MinecraftServer minecraftServer = MinecraftServer.func_71276_C();
        ServerConfigurationManager serverConfigurationManager = minecraftServer.func_71203_ab();
        int n2 = entityPlayerMP.field_71093_bK;
        entityPlayerMP.field_71093_bK = n;
        WorldServer worldServer = minecraftServer.func_71218_a(n2);
        WorldServer worldServer2 = minecraftServer.func_71218_a(n);
        SGBaseTE.sendDimensionRegister(entityPlayerMP, n);
        entityPlayerMP.func_71053_j();
        entityPlayerMP.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(entityPlayerMP.field_71093_bK, BaseUtils.getWorldDifficulty(entityPlayerMP.field_70170_p), worldServer2.func_72912_H().func_76067_t(), entityPlayerMP.field_71134_c.func_73081_b()));
        if (SGCraft.mystcraftIntegration != null) {
            SGCraft.mystcraftIntegration.sendAgeData((World)worldServer2, (EntityPlayer)entityPlayerMP);
        }
        worldServer.func_72973_f((Entity)entityPlayerMP);
        entityPlayerMP.field_70128_L = false;
        entityPlayerMP.func_70012_b(vector3.x, vector3.y, vector3.z, (float)d, entityPlayerMP.field_70125_A);
        worldServer2.func_72838_d((Entity)entityPlayerMP);
        entityPlayerMP.func_70029_a((World)worldServer2);
        BaseUtils.scmPreparePlayer(serverConfigurationManager, entityPlayerMP, worldServer);
        entityPlayerMP.field_71135_a.func_147364_a(vector3.x, vector3.y, vector3.z, (float)d, entityPlayerMP.field_70125_A);
        entityPlayerMP.field_71134_c.func_73080_a(worldServer2);
        serverConfigurationManager.func_72354_b(entityPlayerMP, worldServer2);
        serverConfigurationManager.func_72385_f(entityPlayerMP);
        for (PotionEffect potionEffect : entityPlayerMP.func_70651_bq()) {
            entityPlayerMP.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(entityPlayerMP.func_145782_y(), potionEffect));
        }
        entityPlayerMP.field_71135_a.func_147359_a((Packet)new S1FPacketSetExperience(entityPlayerMP.field_71106_cc, entityPlayerMP.field_71067_cb, entityPlayerMP.field_71068_ca));
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)entityPlayerMP, n2, n);
    }

    static Entity teleportEntityToDimension(Entity entity, Vector3 vector3, Vector3 vector32, double d, int n, boolean bl) {
        MinecraftServer minecraftServer = MinecraftServer.func_71276_C();
        WorldServer worldServer = minecraftServer.func_71218_a(n);
        return SGBaseTE.teleportEntityToWorld(entity, vector3, vector32, d, worldServer, bl);
    }

    static Entity teleportEntityToWorld(Entity entity, Vector3 vector3, Vector3 vector32, double d, WorldServer worldServer, boolean bl) {
        if (debugTeleport) {
            System.out.printf("SGBaseTE.teleportEntityToWorld: %s to %s, destBlocked = %s\n", SGBaseTE.repr(entity), worldServer, bl);
        }
        WorldServer worldServer2 = (WorldServer)entity.field_70170_p;
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        entity.func_70109_d(nBTTagCompound);
        SGBaseTE.extractEntityFromWorld((World)worldServer2, entity);
        if (bl && !(entity instanceof EntityLivingBase)) {
            return null;
        }
        Entity entity2 = SGBaseTE.instantiateEntityFromNBT(entity.getClass(), nBTTagCompound, worldServer);
        if (entity2 != null) {
            if (entity instanceof EntityLiving) {
                SGBaseTE.copyMoreEntityData((EntityLiving)entity, (EntityLiving)entity2);
            }
            SGBaseTE.setVelocity(entity2, vector32);
            entity2.func_70012_b(vector3.x, vector3.y, vector3.z, (float)d, entity.field_70125_A);
            SGBaseTE.checkChunk((World)worldServer, entity2);
            entity2.field_98038_p = true;
            worldServer.func_72838_d(entity2);
            entity2.func_70029_a((World)worldServer);
            if (debugTeleport) {
                System.out.printf("SGBaseTE.teleportEntityToWorld: Spawned %s pos (%.2f, %.2f, %.2f) vel (%.2f, %.2f, %.2f) pitch %.2f (%.2f) yaw %.2f (%.2f)\n", SGBaseTE.repr(entity2), entity2.field_70165_t, entity2.field_70163_u, entity2.field_70161_v, entity2.field_70159_w, entity2.field_70181_x, entity2.field_70179_y, Float.valueOf(entity2.field_70125_A), Float.valueOf(entity2.field_70127_C), Float.valueOf(entity2.field_70177_z), Float.valueOf(entity2.field_70126_B));
            }
        }
        worldServer2.func_82742_i();
        if (worldServer2 != worldServer) {
            worldServer.func_82742_i();
        }
        return entity2;
    }

    static Entity instantiateEntityFromNBT(Class clazz, NBTTagCompound nBTTagCompound, WorldServer worldServer) {
        try {
            Entity entity = (Entity)clazz.getConstructor(World.class).newInstance(worldServer);
            entity.func_70020_e(nBTTagCompound);
            return entity;
        }
        catch (Exception exception) {
            System.out.printf("SGCraft: SGBaseTE.instantiateEntityFromNBT: Could not instantiate %s: %s\n", clazz, exception);
            exception.printStackTrace();
            return null;
        }
    }

    static void copyMoreEntityData(EntityLiving entityLiving, EntityLiving entityLiving2) {
        float f = entityLiving.func_70689_ay();
        if (f != 0.0f) {
            entityLiving2.func_70659_e(f);
        }
    }

    static void setVelocity(Entity entity, Vector3 vector3) {
        entity.field_70159_w = vector3.x;
        entity.field_70181_x = vector3.y;
        entity.field_70179_y = vector3.z;
    }

    static void extractEntityFromWorld(World world, Entity entity) {
        if (entity instanceof EntityPlayer) {
            world.field_73010_i.remove(entity);
            world.func_72854_c();
        }
        int n = entity.field_70176_ah;
        int n2 = entity.field_70164_aj;
        if (entity.field_70175_ag && world.func_72863_F().func_73149_a(n, n2)) {
            world.func_72964_e(n, n2).func_76622_b(entity);
        }
        world.field_72996_f.remove(entity);
        world.func_72847_b(entity);
    }

    static void checkChunk(World world, Entity entity) {
        int n = MathHelper.func_76128_c((double)(entity.field_70165_t / 16.0));
        int n2 = MathHelper.func_76128_c((double)(entity.field_70161_v / 16.0));
        Chunk chunk = world.func_72964_e(n, n2);
    }

    protected static int yawSign(Entity entity) {
        if (entity instanceof EntityArrow) {
            return -1;
        }
        return 1;
    }

    static Vector3 yawVector(Entity entity) {
        return SGBaseTE.yawVector((float)SGBaseTE.yawSign(entity) * entity.field_70177_z);
    }

    static Vector3 yawVector(double d) {
        double d2 = Math.toRadians(d);
        Vector3 vector3 = new Vector3(-Math.sin(d2), 0.0, Math.cos(d2));
        return vector3;
    }

    static double yawAngle(Vector3 vector3, Entity entity) {
        double d = Math.atan2(-vector3.x, vector3.z);
        double d2 = Math.toDegrees(d);
        return (double)SGBaseTE.yawSign(entity) * d2;
    }

    public SGBaseTE getConnectedStargateTE() {
        if (this.isConnected() && this.connectedLocation != null) {
            return this.connectedLocation.getStargateTE();
        }
        return null;
    }

    @Override
    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity s35PacketUpdateTileEntity) {
        SGState sGState = this.state;
        super.onDataPacket(networkManager, s35PacketUpdateTileEntity);
        if (this.isMerged && this.state != sGState) {
            switch (this.state) {
                case Transient: {
                    this.initiateOpeningTransient();
                    break;
                }
                case Disconnecting: {
                    this.initiateClosingTransient();
                }
            }
        }
    }

    void clientUpdate() {
        this.lastRingAngle = this.ringAngle;
        switch (this.state) {
            case Dialling: {
                this.updateRingAngle();
                break;
            }
            case Transient: 
            case Connected: 
            case Disconnecting: {
                this.applyRandomImpulse();
                this.updateEventHorizon();
            }
        }
    }

    void setRingAngle(double d) {
        this.ringAngle = d;
    }

    void updateRingAngle() {
        if (this.timeout > 0) {
            double d = Utils.diffAngle(this.ringAngle, this.targetRingAngle) / (double)this.timeout;
            this.setRingAngle(Utils.addAngle(this.ringAngle, d));
            --this.timeout;
        } else {
            this.setRingAngle(this.targetRingAngle);
        }
    }

    public double[][][] getEventHorizonGrid() {
        if (this.ehGrid == null) {
            int n = 5;
            int n2 = 32;
            this.ehGrid = new double[2][n2 + 2][n + 1];
            for (int i = 0; i < 2; ++i) {
                this.ehGrid[i][0] = this.ehGrid[i][n2];
                this.ehGrid[i][n2 + 1] = this.ehGrid[i][1];
            }
        }
        return this.ehGrid;
    }

    void initiateOpeningTransient() {
        double[][] dArray = this.getEventHorizonGrid()[1];
        int n = 32;
        for (int i = 0; i <= n + 1; ++i) {
            dArray[i][0] = 1.3;
            dArray[i][1] = dArray[i][0] + 0.25 * random.nextGaussian();
        }
    }

    void initiateClosingTransient() {
        double[][] dArray = this.getEventHorizonGrid()[1];
        int n = 5;
        int n2 = 32;
        for (int i = 1; i < n; ++i) {
            for (int j = 1; j <= n2; ++j) {
                double[] dArray2 = dArray[j];
                int n3 = i;
                dArray2[n3] = dArray2[n3] + 0.25 * random.nextGaussian();
            }
        }
    }

    void applyRandomImpulse() {
        double[][] dArray = this.getEventHorizonGrid()[1];
        int n = 5;
        int n2 = 32;
        int n3 = random.nextInt(n - 1) + 1;
        int n4 = random.nextInt(n2) + 1;
        double[] dArray2 = dArray[n4];
        int n5 = n3;
        dArray2[n5] = dArray2[n5] + 0.05 * random.nextGaussian();
    }

    void updateEventHorizon() {
        int n;
        double d;
        int n2;
        int n3;
        double[][][] dArray = this.getEventHorizonGrid();
        double[][] dArray2 = dArray[0];
        double[][] dArray3 = dArray[1];
        int n4 = 5;
        int n5 = 32;
        double d2 = 1.0;
        double d3 = 0.03;
        double d4 = 0.95;
        for (n3 = 1; n3 < n4; ++n3) {
            for (n2 = 1; n2 <= n5; ++n2) {
                d = 0.5 * (dArray2[n2][n3 + 1] - dArray2[n2][n3 - 1]);
                double d5 = dArray2[n2][n3 + 1] - 2.0 * dArray2[n2][n3] + dArray2[n2][n3 - 1];
                double d6 = dArray2[n2 + 1][n3] - 2.0 * dArray2[n2][n3] + dArray2[n2 - 1][n3];
                dArray3[n2][n3] = d4 * dArray3[n2][n3] + d3 * d2 * (d5 + d / (double)n3 + d6 / (double)(n3 * n3));
            }
        }
        for (n3 = 1; n3 < n4; ++n3) {
            for (n2 = 1; n2 <= n5; ++n2) {
                double[] dArray4 = dArray2[n2];
                int n6 = n3;
                dArray4[n6] = dArray4[n6] + dArray3[n2][n3] * d2;
            }
        }
        double d7 = 0.0;
        d = 0.0;
        for (n = 1; n <= n5; ++n) {
            d7 += dArray2[n][1];
            d += dArray3[n][1];
        }
        d7 /= (double)n5;
        d /= (double)n5;
        for (n = 1; n <= n5; ++n) {
            dArray2[n][0] = d7;
            dArray3[n][0] = d;
        }
    }

    void dumpGrid(String string, double[][] dArray) {
        System.out.printf("SGBaseTE: %s:\n", string);
        int n = 5;
        int n2 = 32;
        for (int i = 0; i <= n2 + 1; ++i) {
            for (int j = 0; j <= n; ++j) {
                System.out.printf(" %6.3f", dArray[i][j]);
            }
            System.out.printf("\n", new Object[0]);
        }
    }

    @Override
    protected IInventory getInventory() {
        return this.inventory;
    }

    public boolean irisIsClosed() {
        return this.hasIrisUpgrade && this.irisPhase <= 30;
    }

    public double getIrisAperture(double d) {
        return ((double)this.lastIrisPhase * (1.0 - d) + (double)this.irisPhase * d) / 60.0;
    }

    void irisUpdate() {
        this.lastIrisPhase = this.irisPhase;
        switch (this.irisState) {
            case Opening: {
                if (this.irisPhase < 60) {
                    ++this.irisPhase;
                    break;
                }
                this.enterIrisState(IrisState.Open);
                break;
            }
            case Closing: {
                if (this.irisPhase > 0) {
                    --this.irisPhase;
                    break;
                }
                this.enterIrisState(IrisState.Closed);
            }
        }
    }

    void enterIrisState(IrisState irisState) {
        if (this.irisState != irisState) {
            String string = SGBaseTE.irisStateDescription(this.irisState);
            String string2 = SGBaseTE.irisStateDescription(irisState);
            this.irisState = irisState;
            this.markChanged();
            if (!this.field_145850_b.field_72995_K) {
                switch (irisState) {
                    case Opening: {
                        this.playSGSoundEffect("sgcraft:iris_open", 1.0f, 1.0f);
                        break;
                    }
                    case Closing: {
                        this.playSGSoundEffect("sgcraft:iris_close", 1.0f, 1.0f);
                    }
                }
            }
            if (!string.equals(string2)) {
                this.postEvent("sgIrisStateChange", string2, string);
            }
        }
    }

    public void openIris() {
        if (this.isMerged && this.hasIrisUpgrade && this.irisState != IrisState.Open) {
            this.enterIrisState(IrisState.Opening);
        }
    }

    public void closeIris() {
        if (this.isMerged && this.hasIrisUpgrade && this.irisState != IrisState.Closed) {
            this.enterIrisState(IrisState.Closing);
        }
    }

    public void onNeighborBlockChange() {
        boolean bl;
        if (!this.field_145850_b.field_72995_K && this.redstoneInput != (bl = BaseBlockUtils.blockIsGettingExternallyPowered(this.field_145850_b, this.getPos()))) {
            this.redstoneInput = bl;
            this.func_70296_d();
            if (this.redstoneInput) {
                this.closeIris();
            } else {
                this.openIris();
            }
        }
    }

    void updateIrisEntity() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isMerged && this.hasIrisUpgrade) {
                if (!this.hasIrisEntity()) {
                    IrisEntity irisEntity = new IrisEntity(this);
                    this.field_145850_b.func_72838_d((Entity)irisEntity);
                }
            } else {
                for (IrisEntity irisEntity : this.findIrisEntities()) {
                    this.field_145850_b.func_72900_e((Entity)irisEntity);
                }
            }
        }
    }

    boolean hasIrisEntity() {
        return this.findIrisEntities().size() != 0;
    }

    List<IrisEntity> findIrisEntities() {
        int n = this.getX();
        int n2 = this.getY();
        int n3 = this.getZ();
        AxisAlignedBB axisAlignedBB = BaseUtils.newAxisAlignedBB(n, n2, n3, n + 1, n2 + 2, n3 + 1);
        return this.field_145850_b.func_72872_a(IrisEntity.class, axisAlignedBB);
    }

    ItemStack getCamouflageStack(BlockPos blockPos) {
        int n;
        Trans3 trans3 = this.localToGlobalTransformation();
        Vector3 vector3 = trans3.ip(Vector3.blockCenter(blockPos));
        if (vector3.y == 0.0 && (n = 2 + vector3.roundX()) >= 0 && n < 5) {
            return this.func_70301_a(0 + n);
        }
        return null;
    }

    boolean isCamouflageSlot(int n) {
        return n >= 0 && n < 5;
    }

    @Override
    protected void onInventoryChanged(int n) {
        super.onInventoryChanged(n);
        if (this.isCamouflageSlot(n)) {
            for (int i = -2; i <= 2; ++i) {
                for (int j = -2; j <= 2; ++j) {
                    BaseBlockUtils.markWorldBlockForUpdate(this.field_145850_b, this.getPos().add(i, 0, j));
                }
            }
        }
    }

    public int numItemsInSlot(int n) {
        ItemStack itemStack = this.func_70301_a(n);
        if (itemStack != null) {
            return itemStack.field_77994_a;
        }
        return 0;
    }

    protected int baseCornerCamouflage() {
        return Math.max(this.baseCamouflageAt(0), this.baseCamouflageAt(4));
    }

    protected int baseCamouflageAt(int n) {
        ItemStack itemStack = this.func_70301_a(n);
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
            if (block != null) {
                if (block instanceof BlockSlab) {
                    return 1;
                }
                if (block.func_149637_q()) {
                    return 2;
                }
            }
        }
        return 0;
    }

    public Collection<BlockRef> adjacentTiles() {
        ArrayList<BlockRef> arrayList = new ArrayList<BlockRef>();
        Trans3 trans3 = this.localToGlobalTransformation();
        for (int i = -2; i <= 2; ++i) {
            BlockPos blockPos = trans3.p(i, -1.0, 0.0).blockPos();
            TileEntity tileEntity = BaseBlockUtils.getWorldTileEntity((IBlockAccess)this.field_145850_b, blockPos);
            if (tileEntity == null) continue;
            arrayList.add(new BlockRef(tileEntity));
        }
        return arrayList;
    }

    public void forwardNetworkPacket(Object object) {
        SGBaseTE sGBaseTE = this.getConnectedStargateTE();
        if (sGBaseTE != null) {
            sGBaseTE.rebroadcastNetworkPacket(object);
        }
    }

    void rebroadcastNetworkPacket(Object object) {
        for (BlockRef blockRef : this.adjacentTiles()) {
            TileEntity tileEntity = blockRef.getTileEntity();
            if (!(tileEntity instanceof SGInterfaceTE)) continue;
            ((SGInterfaceTE)tileEntity).rebroadcastNetworkPacket(object);
        }
    }

    public String sendMessage(Object[] objectArray) {
        SGBaseTE sGBaseTE = this.getConnectedStargateTE();
        if (sGBaseTE != null) {
            sGBaseTE.postEvent("sgMessageReceived", objectArray);
            return null;
        }
        return "Stargate not connected";
    }

    void postEvent(String string, Object ... objectArray) {
        for (BlockRef blockRef : this.adjacentTiles()) {
            TileEntity tileEntity = blockRef.getTileEntity();
            if (!(tileEntity instanceof IComputerInterface)) continue;
            ((IComputerInterface)tileEntity).postEvent(this, string, objectArray);
        }
    }

    public String sgStateDescription() {
        return SGBaseTE.sgStateDescription(this.state);
    }

    static String sgStateDescription(SGState sGState) {
        switch (sGState) {
            case Idle: {
                return "Idle";
            }
            case Dialling: 
            case InterDialling: {
                return "Dialling";
            }
            case Transient: {
                return "Opening";
            }
            case Connected: {
                return "Connected";
            }
            case Disconnecting: {
                return "Closing";
            }
        }
        return "Unknown";
    }

    public String irisStateDescription() {
        return SGBaseTE.irisStateDescription(this.irisState);
    }

    static String irisStateDescription(IrisState irisState) {
        return irisState.toString();
    }

    public static SGBaseTE getBaseTE(SGInterfaceTE sGInterfaceTE) {
        return SGBaseTE.get((IBlockAccess)BaseBlockUtils.getTileEntityWorld(sGInterfaceTE), BaseBlockUtils.getTileEntityPos(sGInterfaceTE).add(0, 1, 0));
    }

    static {
        transparency = true;
        random = new Random();
        transientDamage = new DamageSource("sgcraft:transient");
    }

    class TrackedEntity {
        public Entity entity;
        public Vector3 lastPos;

        public TrackedEntity(Entity entity) {
            this.entity = entity;
            this.lastPos = new Vector3(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        }
    }
}

