/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseGLUtils;
import gcewing.sg.BaseTileEntityRenderer;
import gcewing.sg.RingType;
import gcewing.sg.SGBaseTE;
import gcewing.sg.SGCraft;
import gcewing.sg.Vector3;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

class SGBaseTERenderer
extends BaseTileEntityRenderer {
    static final int numRingSegments = 32;
    static final double ringInnerRadius = 2.0;
    static final double ringMidRadius = 2.25;
    static final double ringOuterRadius = 2.5;
    static final double ringDepth = 0.5;
    static final double ringOverlap = 0.015625;
    static final double ringZOffset = 1.0E-4;
    static final double chevronInnerRadius = 2.25;
    static final double chevronOuterRadius = 2.5625;
    static final double chevronWidth = 0.46875;
    static final double chevronDepth = 0.125;
    static final double chevronBorderWidth = 0.078125;
    static final double chevronMotionDistance = 0.125;
    static final int textureTilesWide = 32;
    static final int textureTilesHigh = 2;
    static final double textureScaleU = 0.001953125;
    static final double textureScaleV = 0.03125;
    static final int ringFaceTextureIndex = 1;
    static final int ringTextureIndex = 0;
    static final int ringSymbolTextureIndex = 32;
    static final int chevronTextureIndex = 3;
    static final int chevronLitTextureIndex = 2;
    static final double ringSymbolTextureLength = 512.0;
    static final double ringSymbolTextureHeight = 16.0;
    static final double ringSymbolSegmentWidth = 16.0;
    static final int ehGridRadialSize = 5;
    static final int ehGridPolarSize = 32;
    static final double ehBandWidth = 0.4;
    static final double numIrisBlades = 12.0;
    static int[][] chevronEngagementSequences = new int[][]{{9, 3, 4, 5, 6, 0, 1, 2, 9}, {7, 3, 4, 5, 8, 0, 1, 2, 6}};
    static double[] s = new double[33];
    static double[] c = new double[33];
    double u0;
    double v0;

    SGBaseTERenderer() {
    }

    @Override
    public void renderTileEntityAt(TileEntity tileEntity, double d, double d2, double d3, float f, int n) {
        SGBaseTE sGBaseTE = (SGBaseTE)tileEntity;
        if (sGBaseTE.isMerged) {
            GL11.glPushMatrix();
            if (SGBaseTE.transparency) {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
            } else {
                GL11.glDisable((int)3042);
            }
            GL11.glEnable((int)32826);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslated((double)(d + 0.5), (double)(d2 + 2.5), (double)(d3 + 0.5));
            this.renderStargate(sGBaseTE, f);
            GL11.glDisable((int)32826);
            GL11.glPopMatrix();
        }
    }

    void renderStargate(SGBaseTE sGBaseTE, float f) {
        BaseGLUtils.glMultMatrix(sGBaseTE.localToGlobalTransformation(Vector3.zero));
        this.func_147499_a(SGCraft.mod.resourceLocation("textures/tileentity/stargate.png"));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        this.renderRing(2.234375, 2.5, RingType.Outer, 1.0E-4);
        this.renderInnerRing(sGBaseTE, f);
        this.renderChevrons(sGBaseTE);
        if (sGBaseTE.hasIrisUpgrade) {
            this.renderIris(sGBaseTE, f);
        }
        if (sGBaseTE.isConnected()) {
            this.renderEventHorizon(sGBaseTE);
        }
    }

    void renderInnerRing(SGBaseTE sGBaseTE, float f) {
        GL11.glPushMatrix();
        GL11.glRotatef((float)((float)(sGBaseTE.interpolatedRingAngle(f) + SGBaseTE.ringSymbolAngle / 2.0)), (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderRing(2.0, 2.25, RingType.Inner, 0.0);
        GL11.glPopMatrix();
    }

    void renderRing(double d, double d2, RingType ringType, double d3) {
        double d4 = 0.25 + d3;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        GL11.glBegin((int)7);
        for (int i = 0; i < 32; ++i) {
            this.selectTile(0);
            if (ringType == RingType.Outer) {
                GL11.glNormal3d((double)c[i], (double)s[i], (double)0.0);
                this.vertex(d2 * c[i], d2 * s[i], d4, 0.0, 0.0);
                this.vertex(d2 * c[i], d2 * s[i], -d4, 0.0, 16.0);
                this.vertex(d2 * c[i + 1], d2 * s[i + 1], -d4, 16.0, 16.0);
                this.vertex(d2 * c[i + 1], d2 * s[i + 1], d4, 16.0, 0.0);
            }
            if (ringType == RingType.Inner) {
                GL11.glNormal3d((double)(-c[i]), (double)(-s[i]), (double)0.0);
                this.vertex(d * c[i], d * s[i], -d4, 0.0, 0.0);
                this.vertex(d * c[i], d * s[i], d4, 0.0, 16.0);
                this.vertex(d * c[i + 1], d * s[i + 1], d4, 16.0, 16.0);
                this.vertex(d * c[i + 1], d * s[i + 1], -d4, 16.0, 0.0);
            }
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
            this.vertex(d * c[i], d * s[i], -d4, 0.0, 16.0);
            this.vertex(d * c[i + 1], d * s[i + 1], -d4, 16.0, 16.0);
            this.vertex(d2 * c[i + 1], d2 * s[i + 1], -d4, 16.0, 0.0);
            this.vertex(d2 * c[i], d2 * s[i], -d4, 0.0, 0.0);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
            switch (ringType) {
                case Outer: {
                    this.selectTile(1);
                    d5 = 0.0;
                    d6 = 16.0;
                    d7 = 16.0;
                    break;
                }
                case Inner: {
                    this.selectTile(32);
                    d5 = 512.0 - (double)(i + 1) * 16.0;
                    d6 = 16.0;
                    d7 = 16.0;
                }
            }
            this.vertex(d * c[i], d * s[i], d4, d5 + d6, d7);
            this.vertex(d2 * c[i], d2 * s[i], d4, d5 + d6, 0.0);
            this.vertex(d2 * c[i + 1], d2 * s[i + 1], d4, d5, 0.0);
            this.vertex(d * c[i + 1], d * s[i + 1], d4, d5, d7);
        }
        GL11.glEnd();
    }

    void renderChevrons(SGBaseTE sGBaseTE) {
        int n = sGBaseTE.getNumChevrons();
        int n2 = n > 7 ? 0 : 1;
        int n3 = sGBaseTE.dialledAddress.length() > 7 ? 1 : 0;
        float f = sGBaseTE.angleBetweenChevrons();
        for (int i = n2; i < n2 + n; ++i) {
            int n4 = chevronEngagementSequences[n3][i];
            boolean bl = sGBaseTE.chevronIsEngaged(n4);
            this.renderChevronAtPosition(i, f, bl);
        }
    }

    void renderChevronAtPosition(int n, float f, boolean bl) {
        GL11.glPushMatrix();
        GL11.glRotatef((float)(90.0f - (float)(n - 4) * f), (float)0.0f, (float)0.0f, (float)1.0f);
        this.chevron(bl);
        GL11.glPopMatrix();
    }

    void chevron(boolean bl) {
        double d = 2.25;
        double d2 = 2.5625;
        double d3 = 0.25;
        double d4 = d3 + 0.125;
        double d5 = 0.078125;
        double d6 = d5 * 1.25;
        double d7 = d;
        double d8 = 0.1171875;
        double d9 = d2;
        double d10 = 0.234375;
        if (bl) {
            GL11.glTranslated((double)-0.125, (double)0.0, (double)0.0);
        }
        GL11.glBegin((int)7);
        this.selectTile(3);
        this.vertex(d9, d10, d4, 0.0, 2.0);
        this.vertex(d7, d8, d4, 0.0, 16.0);
        this.vertex(d7 + d5, d8 - d5, d4, 4.0, 12.0);
        this.vertex(d9, d10 - d6, d4, 4.0, 2.0);
        this.vertex(d9, d10, d4, 0.0, 0.0);
        this.vertex(d9, d10, d3, 0.0, 4.0);
        this.vertex(d7, d8, d3, 16.0, 4.0);
        this.vertex(d7, d8, d4, 16.0, 0.0);
        this.vertex(d9, d10, d4, 16.0, 0.0);
        this.vertex(d9, d10 - d6, d4, 12.0, 0.0);
        this.vertex(d9, d10 - d6, d3, 12.0, 4.0);
        this.vertex(d9, d10, d3, 16.0, 4.0);
        this.vertex(d7 + d5, d8 - d5, d4, 4.0, 12.0);
        this.vertex(d7, d8, d4, 0.0, 16.0);
        this.vertex(d7, -d8, d4, 16.0, 16.0);
        this.vertex(d7 + d5, -d8 + d5, d4, 12.0, 12.0);
        this.vertex(d7, d8, d4, 0.0, 0.0);
        this.vertex(d7, d8, d3, 0.0, 4.0);
        this.vertex(d7, -d8, d3, 16.0, 4.0);
        this.vertex(d7, -d8, d4, 16.0, 0.0);
        this.vertex(d9, -d10 + d6, d4, 12.0, 0.0);
        this.vertex(d7 + d5, -d8 + d5, d4, 12.0, 12.0);
        this.vertex(d7, -d8, d4, 16.0, 16.0);
        this.vertex(d9, -d10, d4, 16.0, 0.0);
        this.vertex(d7, -d8, d4, 0.0, 0.0);
        this.vertex(d7, -d8, d3, 0.0, 4.0);
        this.vertex(d9, -d10, d3, 16.0, 4.0);
        this.vertex(d9, -d10, d4, 16.0, 0.0);
        this.vertex(d9, -d10, d4, 0.0, 0.0);
        this.vertex(d9, -d10, d3, 0.0, 4.0);
        this.vertex(d9, -d10 + d6, d3, 4.0, 4.0);
        this.vertex(d9, -d10 + d6, d4, 4.0, 0.0);
        this.vertex(d9, -d10, d3, 0.0, 0.0);
        this.vertex(d7, -d8, d3, 0.0, 16.0);
        this.vertex(d7, d8, d3, 16.0, 16.0);
        this.vertex(d9, d10, d3, 16.0, 0.0);
        GL11.glEnd();
        this.selectTile(2);
        if (!bl) {
            GL11.glColor3d((double)0.5, (double)0.5, (double)0.5);
        } else {
            GL11.glDisable((int)2896);
            SGBaseTERenderer.setLightingDisabled(true);
        }
        GL11.glBegin((int)7);
        this.vertex(d9, d10 - d6, d4, 0.0, 4.0);
        this.vertex(d7 + d5, d8 - d5, d4, 4.0, 16.0);
        this.vertex(d7 + d5, 0.0, d4, 8.0, 16.0);
        this.vertex(d9, 0.0, d4, 8.0, 4.0);
        this.vertex(d9, 0.0, d4, 8.0, 4.0);
        this.vertex(d7 + d5, 0.0, d4, 8.0, 16.0);
        this.vertex(d7 + d5, -d8 + d5, d4, 12.0, 16.0);
        this.vertex(d9, -d10 + d6, d4, 16.0, 4.0);
        this.vertex(d9, d10 - d6, d3, 0.0, 0.0);
        this.vertex(d9, d10 - d6, d4, 0.0, 4.0);
        this.vertex(d9, -d10 + d6, d4, 16.0, 4.0);
        this.vertex(d9, -d10 + d6, d3, 16.0, 0.0);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnd();
        GL11.glEnable((int)2896);
        SGBaseTERenderer.setLightingDisabled(false);
    }

    protected static void setLightingDisabled(boolean bl) {
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        if (bl) {
            GL11.glDisable((int)3553);
        } else {
            GL11.glEnable((int)3553);
        }
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    void renderEventHorizon(SGBaseTE sGBaseTE) {
        int n;
        this.func_147499_a(SGCraft.mod.resourceLocation("textures/tileentity/eventhorizon.png"));
        GL11.glDisable((int)2884);
        GL11.glNormal3d((double)0.0, (double)0.0, (double)1.0);
        double[][] dArray = sGBaseTE.getEventHorizonGrid()[0];
        double d = 2.5 * (sGBaseTE.irisIsClosed() ? sGBaseTE.getIrisAperture(0.0) : 1.0);
        for (n = 1; n < 5; ++n) {
            GL11.glBegin((int)8);
            for (int i = 0; i <= 32; ++i) {
                this.ehVertex(dArray, n, i, d);
                this.ehVertex(dArray, n + 1, i, d);
            }
            GL11.glEnd();
        }
        GL11.glBegin((int)6);
        GL11.glTexCoord2d((double)0.0, (double)0.0);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)this.ehClip(dArray[1][0], 0.0, d));
        for (n = 0; n <= 32; ++n) {
            this.ehVertex(dArray, 1, n, d);
        }
        GL11.glEnd();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2884);
    }

    void ehVertex(double[][] dArray, int n, int n2, double d) {
        double d2 = (double)n * 0.4;
        double d3 = d2 * c[n2];
        double d4 = d2 * s[n2];
        double d5 = this.ehClip(dArray[n2 + 1][n], d2, d);
        GL11.glTexCoord2d((double)d3, (double)d4);
        GL11.glVertex3d((double)d3, (double)d4, (double)d5);
    }

    double ehClip(double d, double d2, double d3) {
        if (d2 >= d3) {
            d = Math.min(d, 0.0);
        }
        return d;
    }

    void renderIris(SGBaseTE sGBaseTE, double d) {
        this.func_147499_a(SGCraft.mod.resourceLocation("textures/tileentity/iris.png"));
        double d2 = 0.8 * sGBaseTE.getIrisAperture(d);
        int n = 0;
        while ((double)n < 12.0) {
            GL11.glPushMatrix();
            GL11.glRotated((double)(360.0 * (double)n / 12.0), (double)0.0, (double)0.0, (double)1.0);
            this.renderIrisBlade(sGBaseTE, d2, d);
            GL11.glPopMatrix();
            ++n;
        }
    }

    void renderIrisBlade(SGBaseTE sGBaseTE, double d, double d2) {
        double d3 = d * 60.0;
        double d4 = 2.31;
        double d5 = 2.4;
        double d6 = 1.85;
        double d7 = 0.16;
        double d8 = 1.0;
        double d9 = d8 - (d8 - d7) * d * d;
        double d10 = d6 / d5;
        double d11 = d9 / d8;
        double d12 = d7 / d8;
        double d13 = 0.1;
        double d14 = 0.01;
        GL11.glPushMatrix();
        GL11.glTranslated((double)d4, (double)0.0, (double)0.0);
        GL11.glRotated((double)(-d3), (double)0.0, (double)0.0, (double)1.0);
        GL11.glBegin((int)6);
        GL11.glTexCoord2d((double)0.0, (double)0.0);
        GL11.glVertex3d((double)(-d5), (double)0.0, (double)d13);
        GL11.glTexCoord2d((double)1.0, (double)0.0);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)(d13 + d14));
        GL11.glTexCoord2d((double)1.0, (double)d12);
        GL11.glVertex3d((double)0.0, (double)d7, (double)(d13 + d14));
        GL11.glTexCoord2d((double)d10, (double)d11);
        GL11.glVertex3d((double)(-d5 + d6), (double)d9, (double)d13);
        GL11.glTexCoord2d((double)0.0, (double)d11);
        GL11.glVertex3d((double)(-d5), (double)d9, (double)d13);
        GL11.glEnd();
        GL11.glBegin((int)6);
        GL11.glTexCoord2d((double)0.0, (double)0.0);
        GL11.glVertex3d((double)(-d5), (double)0.0, (double)d13);
        GL11.glTexCoord2d((double)0.0, (double)d11);
        GL11.glVertex3d((double)(-d5), (double)d9, (double)d13);
        GL11.glTexCoord2d((double)d10, (double)d11);
        GL11.glVertex3d((double)(-d5 + d6), (double)d9, (double)d13);
        GL11.glTexCoord2d((double)1.0, (double)d12);
        GL11.glVertex3d((double)0.0, (double)d7, (double)(d13 - d14));
        GL11.glTexCoord2d((double)1.0, (double)0.0);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)(d13 - d14));
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    void selectTile(int n) {
        this.u0 = (double)(n % 32) * 0.03125;
        this.v0 = (double)(n / 32) * 0.5;
    }

    void vertex(double d, double d2, double d3, double d4, double d5) {
        GL11.glTexCoord2d((double)(this.u0 + d4 * 0.001953125), (double)(this.v0 + d5 * 0.03125));
        GL11.glVertex3d((double)d, (double)d2, (double)d3);
    }

    static {
        for (int i = 0; i <= 32; ++i) {
            double d = Math.PI * 2 * (double)i / 32.0;
            SGBaseTERenderer.s[i] = Math.sin(d);
            SGBaseTERenderer.c[i] = Math.cos(d);
        }
    }
}

