/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.SGCraft;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkDataEvent;

public class SGChunkData {
    static boolean debug = false;
    static HashMap<ChunkCoordIntPair, SGChunkData> map = new HashMap();
    public boolean oresGenerated;

    public static SGChunkData forChunk(Chunk chunk) {
        return SGChunkData.forChunk(chunk, null);
    }

    public static SGChunkData forChunk(Chunk chunk, NBTTagCompound nBTTagCompound) {
        ChunkCoordIntPair chunkCoordIntPair = new ChunkCoordIntPair(chunk.field_76635_g, chunk.field_76647_h);
        SGChunkData sGChunkData = map.get(chunkCoordIntPair);
        if (sGChunkData == null) {
            sGChunkData = new SGChunkData();
            if (nBTTagCompound != null) {
                sGChunkData.readFromNBT(nBTTagCompound);
            }
            map.put(chunkCoordIntPair, sGChunkData);
        }
        return sGChunkData;
    }

    public void readFromNBT(NBTTagCompound nBTTagCompound) {
        this.oresGenerated = nBTTagCompound.func_74767_n("gcewing.sg.oresGenerated");
    }

    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74757_a("gcewing.sg.oresGenerated", this.oresGenerated);
    }

    public static void onChunkLoad(ChunkDataEvent.Load load) {
        Chunk chunk = load.getChunk();
        SGChunkData sGChunkData = SGChunkData.forChunk(chunk, load.getData());
        if (!sGChunkData.oresGenerated && SGCraft.addOresToExistingWorlds) {
            if (debug) {
                System.out.printf("SGChunkData.onChunkLoad: Adding ores to chunk (%d, %d)\n", chunk.field_76635_g, chunk.field_76647_h);
            }
            SGCraft.naquadahOreGenerator.regenerate(chunk);
        }
    }

    public static void onChunkSave(ChunkDataEvent.Save save) {
        Chunk chunk = save.getChunk();
        SGChunkData sGChunkData = SGChunkData.forChunk(chunk);
        sGChunkData.writeToNBT(save.getData());
    }
}

