/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import gcewing.sg.BaseMod;
import gcewing.sg.BaseSubsystem;
import gcewing.sg.BaseTEChunkManager;
import gcewing.sg.BaseUtils;
import gcewing.sg.DHDBlock;
import gcewing.sg.DHDFuelContainer;
import gcewing.sg.DHDTE;
import gcewing.sg.FeatureGeneration;
import gcewing.sg.FeatureUnderDesertPyramid;
import gcewing.sg.IIntegration;
import gcewing.sg.IrisEntity;
import gcewing.sg.MystcraftIntegration;
import gcewing.sg.NaquadahBlock;
import gcewing.sg.NaquadahOreBlock;
import gcewing.sg.NaquadahOreWorldGen;
import gcewing.sg.PowerContainer;
import gcewing.sg.SGBaseBlock;
import gcewing.sg.SGBaseContainer;
import gcewing.sg.SGBaseTE;
import gcewing.sg.SGChannel;
import gcewing.sg.SGChevronUpgradeItem;
import gcewing.sg.SGChunkData;
import gcewing.sg.SGCraftClient;
import gcewing.sg.SGEntity;
import gcewing.sg.SGGui;
import gcewing.sg.SGIrisUpgradeItem;
import gcewing.sg.SGRingBlock;
import gcewing.sg.SGRingItem;
import gcewing.sg.SGTradeHandler;
import gcewing.sg.oc.OCIntegration;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;

@Mod(modid="SGCraft", name="SG Craft", version="1.13.3", acceptableRemoteVersions="[1.13,1.14)")
public class SGCraft
extends BaseMod<SGCraftClient> {
    public static final Material machineMaterial = new Material(MapColor.field_151668_h);
    public static SGCraft mod;
    public static SGChannel channel;
    public static BaseTEChunkManager chunkManager;
    public static SGBaseBlock sgBaseBlock;
    public static SGRingBlock sgRingBlock;
    public static DHDBlock sgControllerBlock;
    public static Block naquadahBlock;
    public static Block naquadahOre;
    public static Item naquadah;
    public static Item naquadahIngot;
    public static Item sgCoreCrystal;
    public static Item sgControllerCrystal;
    public static Item sgChevronUpgrade;
    public static Item sgIrisUpgrade;
    public static Item sgIrisBlade;
    public static Block ic2PowerUnit;
    public static Item ic2Capacitor;
    public static Block rfPowerUnit;
    public static boolean addOresToExistingWorlds;
    public static NaquadahOreWorldGen naquadahOreGenerator;
    public static int tokraVillagerID;
    public static BaseSubsystem ic2Integration;
    public static BaseSubsystem rfIntegration;
    public static BaseSubsystem txIntegration;
    public static BaseSubsystem ccIntegration;
    public static OCIntegration ocIntegration;
    public static MystcraftIntegration mystcraftIntegration;

    public SGCraft() {
        mod = this;
        this.itemDomain = "gcewing_sg";
        this.blockDomain = "gcewing_sg";
        this.creativeTab = new CreativeTabs("gcewing_sg:sgcraft"){

            public Item func_78016_d() {
                return Item.func_150898_a((Block)sgBaseBlock);
            }
        };
    }

    @Override
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent fMLPreInitializationEvent) {
        FMLCommonHandler.instance().bus().register((Object)this);
        ic2Integration = this.integrateWithMod("IC2", "gcewing.sg.ic2.IC2Integration");
        rfIntegration = this.integrateWithMod("CoFHCore", "gcewing.sg.rf.RFIntegration");
        txIntegration = this.integrateWithMod("ThermalExpansion", "gcewing.sg.TXIntegration");
        ccIntegration = this.integrateWithMod("ComputerCraft", "gcewing.sg.cc.CCIntegration");
        ocIntegration = (OCIntegration)this.integrateWithMod("OpenComputers", "gcewing.sg.oc.OCIntegration");
        mystcraftIntegration = (MystcraftIntegration)this.integrateWithMod("Mystcraft", "gcewing.sg.MystcraftIntegration");
        super.preInit(fMLPreInitializationEvent);
    }

    @Override
    @Mod.EventHandler
    public void init(FMLInitializationEvent fMLInitializationEvent) {
        super.init(fMLInitializationEvent);
        System.out.printf("SGCraft.init\n", new Object[0]);
        this.configure();
        channel = new SGChannel("SGCraft");
        chunkManager = new BaseTEChunkManager(this);
    }

    @Override
    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent fMLPostInitializationEvent) {
        super.postInit(fMLPostInitializationEvent);
    }

    @Override
    protected SGCraftClient initClient() {
        return new SGCraftClient(this);
    }

    @Override
    void configure() {
        DHDTE.configure(this.config);
        NaquadahOreWorldGen.configure(this.config);
        SGBaseBlock.configure(this.config);
        SGBaseTE.configure(this.config);
        FeatureGeneration.configure(this.config);
        addOresToExistingWorlds = this.config.getBoolean("options", "addOresToExistingWorlds", false);
    }

    @Override
    protected void registerOther() {
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this);
    }

    @Override
    protected void registerBlocks() {
        sgRingBlock = this.newBlock("stargateRing", SGRingBlock.class, SGRingItem.class);
        sgBaseBlock = this.newBlock("stargateBase", SGBaseBlock.class);
        sgControllerBlock = this.newBlock("stargateController", DHDBlock.class);
        naquadahBlock = this.newBlock("naquadahBlock", NaquadahBlock.class);
        naquadahOre = this.newBlock("naquadahOre", NaquadahOreBlock.class);
    }

    @Override
    protected void registerItems() {
        naquadah = this.newItem("naquadah");
        naquadahIngot = this.newItem("naquadahIngot");
        sgCoreCrystal = this.newItem("sgCoreCrystal");
        sgControllerCrystal = this.newItem("sgControllerCrystal");
        sgChevronUpgrade = this.addItem(new SGChevronUpgradeItem(), "sgChevronUpgrade");
        sgIrisUpgrade = this.addItem(new SGIrisUpgradeItem(), "sgIrisUpgrade");
        sgIrisBlade = this.newItem("sgIrisBlade");
        if (SGCraft.isModLoaded("IC2") || SGCraft.isModLoaded("CoFHCore") && !SGCraft.isModLoaded("ThermalExpansion")) {
            ic2Capacitor = this.newItem("ic2Capacitor");
        }
    }

    public static boolean isValidStargateUpgrade(Item item) {
        return item == sgChevronUpgrade || item == sgIrisUpgrade;
    }

    @Override
    protected void registerOres() {
        this.addOre("oreNaquadah", naquadahOre);
        this.addOre("naquadah", naquadah);
        this.addOre("ingotNaquadahAlloy", naquadahIngot);
    }

    @Override
    protected void registerRecipes() {
        ItemStack itemStack = new ItemStack(Blocks.field_150322_A, 1, 1);
        ItemStack itemStack2 = new ItemStack(Blocks.field_150322_A, 1, 2);
        ItemStack itemStack3 = new ItemStack((Block)sgRingBlock, 1, 1);
        ItemStack itemStack4 = new ItemStack(Items.field_151100_aR, 1, 4);
        ItemStack itemStack5 = new ItemStack(Items.field_151100_aR, 1, 14);
        if (this.config.getBoolean("options", "allowCraftingNaquadah", false)) {
            this.newShapelessRecipe(naquadah, 1, Items.field_151044_h, Items.field_151123_aH, Items.field_151065_br);
        }
        this.newRecipe((Block)sgRingBlock, 1, "CCC", "NNN", "SSS", Character.valueOf('S'), itemStack2, Character.valueOf('N'), "ingotNaquadahAlloy", Character.valueOf('C'), itemStack);
        this.newRecipe(itemStack3, "CgC", "NpN", "SrS", Character.valueOf('S'), itemStack2, Character.valueOf('N'), "ingotNaquadahAlloy", Character.valueOf('C'), itemStack, Character.valueOf('g'), Items.field_151114_aO, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('p'), Items.field_151079_bi);
        this.newRecipe((Block)sgBaseBlock, 1, "CrC", "NeN", "ScS", Character.valueOf('S'), itemStack2, Character.valueOf('N'), "ingotNaquadahAlloy", Character.valueOf('C'), itemStack, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('c'), sgCoreCrystal);
        this.newRecipe((Block)sgControllerBlock, 1, "bbb", "OpO", "OcO", Character.valueOf('b'), Blocks.field_150430_aB, Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('p'), Items.field_151079_bi, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('c'), sgControllerCrystal);
        this.newShapelessRecipe(naquadahIngot, 1, "naquadah", Items.field_151042_j);
        this.newRecipe(naquadahBlock, 1, "NNN", "NNN", "NNN", Character.valueOf('N'), "ingotNaquadahAlloy");
        this.newRecipe(sgChevronUpgrade, 1, "g g", "pNp", "r r", Character.valueOf('N'), "ingotNaquadahAlloy", Character.valueOf('g'), Items.field_151114_aO, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('p'), Items.field_151079_bi);
        this.newRecipe(naquadahIngot, 9, "B", Character.valueOf('B'), naquadahBlock);
        this.newRecipe(sgIrisBlade, 1, " ii", "ic ", "i  ", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('c'), new ItemStack(Items.field_151044_h, 1, 1));
        this.newRecipe(sgIrisUpgrade, 1, "bbb", "brb", "bbb", Character.valueOf('b'), sgIrisBlade, Character.valueOf('r'), Items.field_151137_ax);
        if (this.config.getBoolean("options", "allowCraftingCrystals", false)) {
            this.newRecipe(sgCoreCrystal, 1, "bbr", "rdb", "brb", Character.valueOf('b'), itemStack4, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('d'), Items.field_151045_i);
            this.newRecipe(sgControllerCrystal, 1, "roo", "odr", "oor", Character.valueOf('o'), itemStack5, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('d'), Items.field_151045_i);
        }
        if (!SGCraft.isModLoaded("ThermalExpansion") && SGCraft.isModLoaded("CoFHCore")) {
            if (!SGCraft.isModLoaded("IC2")) {
                this.registerFallbackCapacitorRecipe();
            }
            this.registerFallbackPowerBlockRecipe();
        }
    }

    protected void registerFallbackCapacitorRecipe() {
        this.newRecipe(ic2Capacitor, 1, "iii", "ppp", "iii", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('p'), Items.field_151121_aF);
    }

    protected void registerFallbackPowerBlockRecipe() {
        this.newRecipe(rfPowerUnit, 1, "cgc", "gIg", "crc", Character.valueOf('c'), ic2Capacitor, Character.valueOf('g'), Items.field_151043_k, Character.valueOf('I'), Blocks.field_150339_S, Character.valueOf('r'), Items.field_151137_ax);
    }

    @Override
    protected void registerContainers() {
        this.addContainer(SGGui.SGBase, SGBaseContainer.class);
        this.addContainer(SGGui.DHDFuel, DHDFuelContainer.class);
        this.addContainer(SGGui.PowerUnit, PowerContainer.class);
    }

    @Override
    protected void registerRandomItems() {
        String[] stringArray = new String[]{"mineshaftCorridor", "pyramidDesertyChest", "pyramidJungleChest", "strongholdLibrary", "villageBlacksmith"};
        this.addRandomChestItem(new ItemStack(sgCoreCrystal), 1, 1, 2, stringArray);
        this.addRandomChestItem(new ItemStack(sgControllerCrystal), 1, 1, 1, stringArray);
    }

    @Override
    protected void registerWorldGenerators() {
        if (this.config.getBoolean("options", "enableNaquadahOre", true)) {
            System.out.printf("SGCraft: Registering NaquadahOreWorldGen\n", new Object[0]);
            naquadahOreGenerator = new NaquadahOreWorldGen();
            GameRegistry.registerWorldGenerator((IWorldGenerator)naquadahOreGenerator, (int)0);
        }
        this.registerStructureComponent(FeatureUnderDesertPyramid.class, "SGCraft:FeatureUnderDesertPyramid");
    }

    @Override
    protected void registerVillagers() {
        tokraVillagerID = this.addVillager("tokra", this.resourceLocation("textures/skins/tokra.png"));
        this.addTradeHandler(tokraVillagerID, new SGTradeHandler());
    }

    @Override
    protected void registerEntities() {
        this.addEntity(IrisEntity.class, "Stargate Iris", SGEntity.Iris, 1000000, false);
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load load) {
        Chunk chunk = load.getChunk();
        SGChunkData.onChunkLoad(load);
    }

    @SubscribeEvent
    public void onChunkSave(ChunkDataEvent.Save save) {
        Chunk chunk = save.getChunk();
        SGChunkData.onChunkSave(save);
    }

    @SubscribeEvent
    public void onInitMapGen(InitMapGenEvent initMapGenEvent) {
        FeatureGeneration.onInitMapGen(initMapGenEvent);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent serverTickEvent) {
        switch (serverTickEvent.phase) {
            case START: {
                for (BaseSubsystem baseSubsystem : this.subsystems) {
                    if (!(baseSubsystem instanceof IIntegration)) continue;
                    ((IIntegration)((Object)baseSubsystem)).onServerTick();
                }
                break;
            }
        }
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload unload) {
        Chunk chunk = unload.getChunk();
        if (!BaseUtils.getChunkWorld((Chunk)chunk).field_72995_K) {
            for (Object v : BaseUtils.getChunkTileEntityMap(chunk).values()) {
                if (!(v instanceof SGBaseTE)) continue;
                SGBaseTE sGBaseTE = (SGBaseTE)v;
                sGBaseTE.disconnect();
            }
        }
    }
}

