/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import com.google.common.primitives.Ints;
import gcewing.sg.BaseUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;

public class SGDimensionMap
extends WorldSavedData {
    public static boolean debugDimensionMap = false;
    protected List<Integer> indexToDimension = new ArrayList<Integer>();
    protected Map<Integer, Integer> dimensionToIndex = new HashMap<Integer, Integer>();

    public SGDimensionMap(String string) {
        super(string);
    }

    public static SGDimensionMap get() {
        WorldServer worldServer = BaseUtils.getWorldForDimension(0);
        return BaseUtils.getWorldData((World)worldServer, SGDimensionMap.class, "sgcraft:dimension_map");
    }

    public static Integer dimensionForIndex(int n) {
        return SGDimensionMap.get().getDimensionForIndex(n);
    }

    protected Integer getDimensionForIndex(int n) {
        Integer n2 = null;
        if (n >= 0 && n < this.indexToDimension.size()) {
            n2 = this.indexToDimension.get(n);
        }
        if (debugDimensionMap) {
            System.out.printf("SGDimensionMap: Found index %s -> dimension %s\n", n, n2);
        }
        return n2;
    }

    public static Integer indexForDimension(int n) {
        return SGDimensionMap.get().getIndexForDimension(n);
    }

    protected Integer getIndexForDimension(int n) {
        if (!this.dimensionToIndex.containsKey(n)) {
            int n2 = this.indexToDimension.size();
            if (debugDimensionMap) {
                System.out.printf("SGDimensionMap: Adding dimension %s -> index %s\n", n, n2);
            }
            this.indexToDimension.add(n);
            this.dimensionToIndex.put(n, n2);
            this.func_76185_a();
            return n2;
        }
        int n3 = this.dimensionToIndex.get(n);
        if (debugDimensionMap) {
            System.out.printf("SGDimensionMap: Found dimension %s -> index %s\n", n, n3);
        }
        return n3;
    }

    public void func_76184_a(NBTTagCompound nBTTagCompound) {
        if (debugDimensionMap) {
            System.out.printf("SGDimensionMap: Reading from nbt\n", new Object[0]);
        }
        int[] nArray = nBTTagCompound.func_74759_k("dimensions");
        for (int i = 0; i < nArray.length; ++i) {
            this.indexToDimension.add(nArray[i]);
            this.dimensionToIndex.put(nArray[i], i);
        }
    }

    public void func_76187_b(NBTTagCompound nBTTagCompound) {
        if (debugDimensionMap) {
            System.out.printf("SGDimensionMap: Writing to nbt\n", new Object[0]);
        }
        int[] nArray = Ints.toArray(this.indexToDimension);
        nBTTagCompound.func_74783_a("dimensions", nArray);
    }
}

