/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseBlockUtils;
import gcewing.sg.BaseTileEntity;
import gcewing.sg.SGAddressing;
import gcewing.sg.SGBaseTE;
import net.minecraft.world.IBlockAccess;

public class SGInterfaceTE
extends BaseTileEntity {
    public SGBaseTE getBaseTE() {
        return SGBaseTE.get((IBlockAccess)this.field_145850_b, this.getPos().add(0, 1, 0));
    }

    public static Object[] prependArgs(Object ... objectArray) {
        int n;
        int n2 = objectArray.length - 1;
        Object[] objectArray2 = (Object[])objectArray[n2];
        Object[] objectArray3 = new Object[n2 + objectArray2.length];
        for (n = 0; n < n2; ++n) {
            objectArray3[n] = objectArray[n];
        }
        for (n = 0; n < objectArray2.length; ++n) {
            objectArray3[n2 + n] = objectArray2[n];
        }
        return objectArray3;
    }

    public void rebroadcastNetworkPacket(Object object) {
    }

    public SGBaseTE requireBaseTE() {
        SGBaseTE sGBaseTE = this.getBaseTE();
        if (sGBaseTE != null && sGBaseTE.isMerged) {
            return sGBaseTE;
        }
        throw new IllegalArgumentException("No stargate connected to interface");
    }

    public SGBaseTE requireIrisTE() {
        SGBaseTE sGBaseTE = this.requireBaseTE();
        if (sGBaseTE != null && sGBaseTE.hasIrisUpgrade) {
            return sGBaseTE;
        }
        throw new IllegalArgumentException("No iris fitted to stargate");
    }

    String directionDescription(SGBaseTE sGBaseTE) {
        if (sGBaseTE.isConnected()) {
            if (sGBaseTE.isInitiator) {
                return "Outgoing";
            }
            return "Incoming";
        }
        return "";
    }

    public CIStargateState ciStargateState() {
        SGBaseTE sGBaseTE = this.getBaseTE();
        if (sGBaseTE != null) {
            return new CIStargateState(sGBaseTE.sgStateDescription(), sGBaseTE.numEngagedChevrons, this.directionDescription(sGBaseTE));
        }
        return new CIStargateState("Offline", 0, "");
    }

    public double ciEnergyAvailable() {
        SGBaseTE sGBaseTE = this.getBaseTE();
        if (sGBaseTE != null) {
            return sGBaseTE.availableEnergy();
        }
        return 0.0;
    }

    public double ciEnergyToDial(String string) {
        SGBaseTE sGBaseTE = this.requireBaseTE();
        try {
            string = SGAddressing.normalizeAddress(string);
            SGBaseTE sGBaseTE2 = SGAddressing.findAddressedStargate(string, BaseBlockUtils.getTileEntityWorld(sGBaseTE));
            if (sGBaseTE2 == null) {
                throw new IllegalArgumentException("No stargate at address " + string);
            }
            double d = SGBaseTE.distanceFactorForCoordDifference(sGBaseTE, sGBaseTE2);
            return SGBaseTE.energyToOpen * d;
        }
        catch (SGAddressing.AddressingError addressingError) {
            System.out.printf("SGBaseTE.ciEnergyToDial: caught %s\n", addressingError);
            throw new IllegalArgumentException(addressingError.getMessage());
        }
    }

    public String ciLocalAddress() {
        SGBaseTE sGBaseTE = this.getBaseTE();
        try {
            if (sGBaseTE != null) {
                return sGBaseTE.getHomeAddress();
            }
            return "";
        }
        catch (SGAddressing.AddressingError addressingError) {
            throw new IllegalArgumentException(addressingError.getMessage());
        }
    }

    public String ciRemoteAddress() {
        SGBaseTE sGBaseTE = this.requireBaseTE();
        try {
            if (sGBaseTE.connectedLocation != null) {
                return SGAddressing.addressForLocation(sGBaseTE.connectedLocation);
            }
            return "";
        }
        catch (SGAddressing.AddressingError addressingError) {
            throw new IllegalArgumentException(addressingError.getMessage());
        }
    }

    public void ciDial(String string) {
        SGBaseTE sGBaseTE = this.requireBaseTE();
        String string2 = sGBaseTE.connect(string = SGAddressing.normalizeAddress(string), null);
        if (string2 != null) {
            throw new IllegalArgumentException(string2);
        }
    }

    public void ciDisconnect() {
        SGBaseTE sGBaseTE = this.requireBaseTE();
        String string = sGBaseTE.attemptToDisconnect(null);
        if (string != null) {
            throw new IllegalArgumentException(string);
        }
    }

    public String ciIrisState() {
        SGBaseTE sGBaseTE = this.getBaseTE();
        if (sGBaseTE != null && sGBaseTE.hasIrisUpgrade) {
            return sGBaseTE.irisStateDescription();
        }
        return "Offline";
    }

    public void ciOpenIris() {
        this.requireIrisTE().openIris();
    }

    public void ciCloseIris() {
        this.requireIrisTE().closeIris();
    }

    public void ciSendMessage(Object[] objectArray) {
        SGBaseTE sGBaseTE = this.requireBaseTE();
        String string = sGBaseTE.sendMessage(objectArray);
        if (string != null) {
            throw new IllegalArgumentException(string);
        }
    }

    public static class CIStargateState {
        public String state;
        public int chevrons;
        public String direction;

        public CIStargateState(String string, int n, String string2) {
            this.state = string;
            this.chevrons = n;
            this.direction = string2;
        }
    }
}

