/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseBlockUtils;
import gcewing.sg.BaseUtils;
import gcewing.sg.BlockPos;
import gcewing.sg.SGAddressing;
import gcewing.sg.SGBaseTE;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;

public class SGLocation {
    public int dimension;
    public BlockPos pos;

    public SGLocation(TileEntity tileEntity) {
        this(BaseUtils.getWorldDimensionId(BaseBlockUtils.getTileEntityWorld(tileEntity)), BaseBlockUtils.getTileEntityPos(tileEntity));
    }

    public SGLocation(int n, BlockPos blockPos) {
        this.dimension = n;
        this.pos = blockPos;
    }

    public SGLocation(NBTTagCompound nBTTagCompound) {
        this.dimension = nBTTagCompound.func_74762_e("dimension");
        int n = nBTTagCompound.func_74762_e("x");
        int n2 = nBTTagCompound.func_74762_e("y");
        int n3 = nBTTagCompound.func_74762_e("z");
        this.pos = new BlockPos(n, n2, n3);
    }

    NBTTagCompound toNBT() {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74768_a("dimension", this.dimension);
        nBTTagCompound.func_74768_a("x", this.pos.getX());
        nBTTagCompound.func_74768_a("y", this.pos.getY());
        nBTTagCompound.func_74768_a("z", this.pos.getZ());
        return nBTTagCompound;
    }

    SGBaseTE getStargateTE() {
        WorldServer worldServer = SGAddressing.getWorld(this.dimension);
        if (worldServer == null) {
            System.out.printf("SGCraft: SGLocation.getStargateTE: Oh, noes! Dimension %d is not loaded. How can this be?", this.dimension);
            return null;
        }
        TileEntity tileEntity = BaseBlockUtils.getWorldTileEntity((IBlockAccess)worldServer, this.pos);
        if (tileEntity instanceof SGBaseTE) {
            return (SGBaseTE)tileEntity;
        }
        return null;
    }
}

