/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseBlockUtils;
import gcewing.sg.BaseMod;
import gcewing.sg.BlockPos;
import gcewing.sg.EnumWorldBlockLayer;
import gcewing.sg.IBlockState;
import gcewing.sg.IProperty;
import gcewing.sg.PropertyInteger;
import gcewing.sg.SGBaseBlock;
import gcewing.sg.SGBaseTE;
import gcewing.sg.SGBlock;
import gcewing.sg.SGRingTE;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SGRingBlock
extends SGBlock<SGRingTE> {
    static final int numSubBlocks = 2;
    public static IProperty<Integer> VARIANT = PropertyInteger.create("variant", 0, 1);
    static String[] textures = new String[]{"stargateBlock", "stargateRing", "stargateChevron"};
    static BaseMod.ModelSpec[] models = new BaseMod.ModelSpec[]{new BaseMod.ModelSpec("block/sg_ring_block.smeg", "stargateBlock", "stargateRing"), new BaseMod.ModelSpec("block/sg_ring_block.smeg", "stargateBlock", "stargateChevron")};
    static String[] subBlockTitles = new String[]{"Stargate Ring Block", "Stargate Chevron Block"};

    public SGRingBlock() {
        super(Material.field_151576_e, SGRingTE.class);
        this.func_149711_c(1.5f);
        this.func_149647_a(CreativeTabs.field_78026_f);
    }

    @Override
    protected void defineProperties() {
        super.defineProperties();
        this.addProperty(VARIANT);
    }

    @Override
    public int getNumSubtypes() {
        return VARIANT.getAllowedValues().size();
    }

    @Override
    public String[] getTextureNames() {
        return textures;
    }

    @Override
    public BaseMod.ModelSpec getModelSpec(IBlockState iBlockState) {
        return models[iBlockState.getValue(VARIANT)];
    }

    @Override
    protected String getRendererClassName() {
        return "SGRingBlockRenderer";
    }

    @Override
    public boolean canRenderInLayer(EnumWorldBlockLayer enumWorldBlockLayer) {
        return true;
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean shouldCheckWeakPower(IBlockAccess iBlockAccess, BlockPos blockPos, EnumFacing enumFacing) {
        return true;
    }

    @Override
    public boolean isSideSolid(IBlockAccess iBlockAccess, BlockPos blockPos, EnumFacing enumFacing) {
        return true;
    }

    @Override
    public boolean canHarvestBlock(IBlockState iBlockState, EntityPlayer entityPlayer) {
        return true;
    }

    @Override
    public int damageDropped(IBlockState iBlockState) {
        return this.getMetaFromState(iBlockState);
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos blockPos, IBlockState iBlockState, EntityPlayer entityPlayer, EnumFacing enumFacing, float f, float f2, float f3) {
        SGRingTE sGRingTE = (SGRingTE)this.getTileEntity((IBlockAccess)world, blockPos);
        if (sGRingTE.isMerged) {
            IBlockState iBlockState2 = BaseBlockUtils.getWorldBlockState((IBlockAccess)world, sGRingTE.basePos);
            Block block = iBlockState2.getBlock();
            if (block instanceof SGBaseBlock) {
                ((SGBaseBlock)block).onBlockActivated(world, sGRingTE.basePos, iBlockState2, entityPlayer, enumFacing, f, f2, f3);
            }
            return true;
        }
        return false;
    }

    @Override
    public SGBaseTE getBaseTE(IBlockAccess iBlockAccess, BlockPos blockPos) {
        SGRingTE sGRingTE = (SGRingTE)this.getTileEntity(iBlockAccess, blockPos);
        if (sGRingTE != null) {
            return sGRingTE.getBaseTE();
        }
        return null;
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < 2; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @Override
    public boolean isMerged(IBlockAccess iBlockAccess, BlockPos blockPos) {
        SGRingTE sGRingTE = (SGRingTE)this.getTileEntity(iBlockAccess, blockPos);
        return sGRingTE != null && sGRingTE.isMerged;
    }

    public void mergeWith(World world, BlockPos blockPos, BlockPos blockPos2) {
        SGRingTE sGRingTE = (SGRingTE)this.getTileEntity((IBlockAccess)world, blockPos);
        sGRingTE.isMerged = true;
        sGRingTE.basePos = blockPos2;
        BaseBlockUtils.markWorldBlockForUpdate(world, blockPos);
    }

    public void unmergeFrom(World world, BlockPos blockPos, BlockPos blockPos2) {
        SGRingTE sGRingTE = (SGRingTE)this.getTileEntity((IBlockAccess)world, blockPos);
        if (SGBaseBlock.debugMerge) {
            System.out.printf("SGRingBlock.unmergeFrom: ring at %s base at %s te.isMerged = %s te.basePos = %s\n", blockPos, blockPos2, sGRingTE.isMerged, sGRingTE.basePos);
        }
        if (sGRingTE.isMerged && sGRingTE.basePos.equals(blockPos2)) {
            if (SGBaseBlock.debugMerge) {
                System.out.printf("SGRingBlock.unmergeFrom: unmerging\n", new Object[0]);
            }
            sGRingTE.isMerged = false;
            sGRingTE.markBlockChanged();
        }
    }

    @Override
    public void onBlockAdded(World world, BlockPos blockPos, IBlockState iBlockState) {
        if (SGBaseBlock.debugMerge) {
            System.out.printf("SGRingBlock.onBlockAdded: at %s\n", blockPos);
        }
        SGRingTE sGRingTE = (SGRingTE)this.getTileEntity((IBlockAccess)world, blockPos);
        this.updateBaseBlocks(world, blockPos, sGRingTE);
    }

    @Override
    public void breakBlock(World world, BlockPos blockPos, IBlockState iBlockState) {
        SGRingTE sGRingTE = (SGRingTE)this.getTileEntity((IBlockAccess)world, blockPos);
        super.breakBlock(world, blockPos, iBlockState);
        if (sGRingTE != null && sGRingTE.isMerged) {
            this.updateBaseBlocks(world, blockPos, sGRingTE);
        }
    }

    void updateBaseBlocks(World world, BlockPos blockPos, SGRingTE sGRingTE) {
        if (SGBaseBlock.debugMerge) {
            System.out.printf("SGRingBlock.updateBaseBlocks: merged = %s, base = %s\n", sGRingTE.isMerged, sGRingTE.basePos);
        }
        for (int i = -2; i <= 2; ++i) {
            for (int j = -4; j <= 0; ++j) {
                for (int k = -2; k <= 2; ++k) {
                    BlockPos blockPos2 = blockPos.add(i, j, k);
                    Block block = BaseBlockUtils.getWorldBlock((IBlockAccess)world, blockPos2);
                    if (!(block instanceof SGBaseBlock)) continue;
                    if (SGBaseBlock.debugMerge) {
                        System.out.printf("SGRingBlock.updateBaseBlocks: found base at %s\n", blockPos2);
                    }
                    SGBaseBlock sGBaseBlock = (SGBaseBlock)block;
                    if (!sGRingTE.isMerged) {
                        sGBaseBlock.checkForMerge(world, blockPos2);
                        continue;
                    }
                    if (!sGRingTE.basePos.equals(blockPos2)) continue;
                    sGBaseBlock.unmerge(world, blockPos2);
                }
            }
        }
    }
}

