/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.cc;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import gcewing.sg.cc.CCCall;
import gcewing.sg.cc.CCMethod;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class CCMethodQueue {
    public static CCMethodQueue instance;
    Queue<CCCall> items = new ConcurrentLinkedQueue<CCCall>();

    public static void init() {
        instance = new CCMethodQueue();
    }

    public static void onServerTick() {
        if (instance != null) {
            instance.tick();
        }
    }

    public Object[] invoke(IComputerAccess iComputerAccess, ILuaContext iLuaContext, Object object, CCMethod cCMethod, Object[] objectArray) throws LuaException, InterruptedException {
        CCCall cCCall = new CCCall(iComputerAccess, iLuaContext, object, cCMethod, objectArray);
        this.items.add(cCCall);
        cCCall.lock.acquire();
        if (cCCall.exception == null) {
            return cCCall.result;
        }
        throw cCCall.exception;
    }

    void tick() {
        int n = this.items.size();
        while (n-- > 0) {
            CCCall cCCall = this.items.poll();
            if (cCCall == null) {
                return;
            }
            try {
                cCCall.result = cCCall.method.invoke(cCCall.cpu, cCCall.ctx, cCCall.target, cCCall.args);
            }
            catch (LuaException luaException) {
                cCCall.exception = luaException;
            }
            catch (Exception exception) {
                cCCall.exception = new LuaException(exception.getMessage());
            }
            cCCall.lock.release();
        }
    }
}

