/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.oc;

import gcewing.sg.BaseConfiguration;
import gcewing.sg.SGBaseTE;
import li.cil.oc.api.Network;
import li.cil.oc.api.network.Packet;
import li.cil.oc.api.network.WirelessEndpoint;
import net.minecraft.world.World;

public class OCWirelessEndpoint
implements WirelessEndpoint {
    public static double forwardingStrength = 50.0;
    static boolean debugWireless = false;
    SGBaseTE te;

    public static void configure(BaseConfiguration baseConfiguration) {
        forwardingStrength = baseConfiguration.getDouble("opencomputers", "wirelessRebroadcastStrength", forwardingStrength);
    }

    public OCWirelessEndpoint(SGBaseTE sGBaseTE) {
        if (debugWireless) {
            System.out.printf("SGCraft: OCSGWirelessEndpoint: added %s for %s\n", this, sGBaseTE);
        }
        this.te = sGBaseTE;
        Network.joinWirelessNetwork(this);
    }

    public void remove() {
        if (debugWireless) {
            System.out.printf("SGCraft: OCSGWirelessEndpoint: removed for %s\n", this.te);
        }
        Network.leaveWirelessNetwork(this);
    }

    @Override
    public int x() {
        return this.te.field_145851_c;
    }

    @Override
    public int y() {
        return this.te.field_145848_d;
    }

    @Override
    public int z() {
        return this.te.field_145849_e;
    }

    @Override
    public World world() {
        return this.te.func_145831_w();
    }

    @Override
    public void receivePacket(Packet packet, WirelessEndpoint wirelessEndpoint) {
        SGBaseTE sGBaseTE;
        if (debugWireless) {
            System.out.printf("OCSGWirelessEndpoint.receivePacket: ttl %s from %s by %s\n", packet.ttl(), wirelessEndpoint, this.te);
        }
        if (packet.ttl() > 0 && (sGBaseTE = this.te.getConnectedStargateTE()) != null && sGBaseTE.ocWirelessEndpoint != null) {
            if (debugWireless) {
                System.out.printf("OCSGWirelessEndpoint.receivePacket: forwarding to %s\n", sGBaseTE);
            }
            Network.sendWirelessPacket(sGBaseTE.ocWirelessEndpoint, forwardingStrength, packet.hop());
        }
    }
}

