/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.api.dimension.world;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class OreGenerator
implements IWorldGenerator {
    private final int amountPerChunk;
    private final int maxGenerateLevel;
    private final int minGenerateLevel;
    private final int amountPerVein;
    private final Block oreBlock;
    private final int metadata;
    private final Block replaceBlock;
    private final int repmetadata;
    private final int dimId;

    public OreGenerator(Block oreBlock, int metadata, int amountPerChunk, int minGenLevel, int maxGenLevel, int amountPerVein, Block replace, int repMeta, int dim) {
        this.oreBlock = oreBlock;
        this.metadata = metadata;
        this.amountPerChunk = amountPerChunk;
        this.minGenerateLevel = minGenLevel;
        this.maxGenerateLevel = maxGenLevel;
        this.amountPerVein = amountPerVein;
        this.replaceBlock = replace;
        this.repmetadata = repMeta;
        this.dimId = dim;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76574_g == this.dimId) {
            for (int i = 0; i < this.amountPerChunk; ++i) {
                int x = chunkX * 16 + random.nextInt(16);
                int z = chunkZ * 16 + random.nextInt(16);
                int y = random.nextInt(Math.max(this.maxGenerateLevel - this.minGenerateLevel, 0)) + this.minGenerateLevel;
                this.generateOre(world, random, x, y, z);
            }
        }
    }

    private boolean generateOre(World par1World, Random par2Random, int par3, int par4, int par5) {
        float var6 = par2Random.nextFloat() * (float)Math.PI;
        double var7 = (float)(par3 + 8) + MathHelper.func_76126_a((float)var6) * (float)this.amountPerVein / 8.0f;
        double var9 = (float)(par3 + 8) - MathHelper.func_76126_a((float)var6) * (float)this.amountPerVein / 8.0f;
        double var11 = (float)(par5 + 8) + MathHelper.func_76134_b((float)var6) * (float)this.amountPerVein / 8.0f;
        double var13 = (float)(par5 + 8) - MathHelper.func_76134_b((float)var6) * (float)this.amountPerVein / 8.0f;
        double var15 = par4 + par2Random.nextInt(3) - 2;
        double var17 = par4 + par2Random.nextInt(3) - 2;
        for (int var19 = 0; var19 <= this.amountPerVein; ++var19) {
            double var20 = var7 + (var9 - var7) * (double)var19 / (double)this.amountPerVein;
            double var22 = var15 + (var17 - var15) * (double)var19 / (double)this.amountPerVein;
            double var24 = var11 + (var13 - var11) * (double)var19 / (double)this.amountPerVein;
            double var26 = par2Random.nextDouble() * (double)this.amountPerVein / 16.0;
            double var28 = (double)(MathHelper.func_76126_a((float)((float)var19 * (float)Math.PI / (float)this.amountPerVein)) + 1.0f) * var26 + 1.0;
            double var30 = (double)(MathHelper.func_76126_a((float)((float)var19 * (float)Math.PI / (float)this.amountPerVein)) + 1.0f) * var26 + 1.0;
            int var32 = MathHelper.func_76128_c((double)(var20 - var28 / 2.0));
            int var33 = MathHelper.func_76128_c((double)(var22 - var30 / 2.0));
            int var34 = MathHelper.func_76128_c((double)(var24 - var28 / 2.0));
            int var35 = MathHelper.func_76128_c((double)(var20 + var28 / 2.0));
            int var36 = MathHelper.func_76128_c((double)(var22 + var30 / 2.0));
            int var37 = MathHelper.func_76128_c((double)(var24 + var28 / 2.0));
            for (int var38 = var32; var38 <= var35; ++var38) {
                double var39 = ((double)var38 + 0.5 - var20) / (var28 / 2.0);
                if (!(var39 * var39 < 1.0)) continue;
                for (int var41 = var33; var41 <= var36; ++var41) {
                    double var42 = ((double)var41 + 0.5 - var22) / (var30 / 2.0);
                    if (!(var39 * var39 + var42 * var42 < 1.0)) continue;
                    for (int var44 = var34; var44 <= var37; ++var44) {
                        double var45 = ((double)var44 + 0.5 - var24) / (var28 / 2.0);
                        Block block = par1World.func_147439_a(var38, var41, var44);
                        int meta = par1World.func_72805_g(var38, var41, var44);
                        if (!(var39 * var39 + var42 * var42 + var45 * var45 < 1.0) || block != this.replaceBlock || meta != this.repmetadata) continue;
                        par1World.func_147465_d(var38, var41, var44, this.oreBlock, this.metadata, 2);
                    }
                }
            }
        }
        return true;
    }
}

