/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.animations.MCACommonLibrary.math;

import galaxyspace.core.animations.MCACommonLibrary.math.AxisAngle4f;
import galaxyspace.core.animations.MCACommonLibrary.math.AxisAngle4f$Matrix3d;
import galaxyspace.core.animations.MCACommonLibrary.math.AxisAngle4f$Matrix4f;
import galaxyspace.core.animations.MCACommonLibrary.math.Matrix3f;
import galaxyspace.core.animations.MCACommonLibrary.math.Matrix3f$Matrix3d;
import galaxyspace.core.animations.MCACommonLibrary.math.Quaternion;
import galaxyspace.core.animations.MCACommonLibrary.math.Vector3f;
import galaxyspace.core.animations.MCACommonLibrary.math.Vector3f$Matrix3d;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public class Matrix3d
implements Serializable,
Cloneable {
    static final long serialVersionUID = 6837536777072402710L;
    public double m00;
    public double m01;
    public double m02;
    public double m10;
    public double m11;
    public double m12;
    public double m20;
    public double m21;
    public double m22;
    private static final double EPS = 1.110223024E-16;
    private static final double ERR_EPS = 1.0E-8;
    private static double xin;
    private static double yin;
    private static double zin;
    private static double xout;
    private static double yout;
    private static double zout;
    private static volatile transient Object[] \uc717;

    public Matrix3d(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m10 = d4;
        this.m11 = d5;
        this.m12 = d6;
        this.m20 = d7;
        this.m21 = d8;
        this.m22 = d9;
    }

    public Matrix3d(double[] dArray) {
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m02 = dArray[2];
        this.m10 = dArray[3];
        this.m11 = dArray[4];
        this.m12 = dArray[5];
        this.m20 = dArray[6];
        this.m21 = dArray[7];
        this.m22 = dArray[8];
    }

    public Matrix3d(Matrix3d matrix3d) {
        this.m00 = matrix3d.m00;
        this.m01 = matrix3d.m01;
        this.m02 = matrix3d.m02;
        this.m10 = matrix3d.m10;
        this.m11 = matrix3d.m11;
        this.m12 = matrix3d.m12;
        this.m20 = matrix3d.m20;
        this.m21 = matrix3d.m21;
        this.m22 = matrix3d.m22;
    }

    public Matrix3d(Matrix3f matrix3f) {
        this.m00 = matrix3f.m00;
        this.m01 = matrix3f.m01;
        this.m02 = matrix3f.m02;
        this.m10 = matrix3f.m10;
        this.m11 = matrix3f.m11;
        this.m12 = matrix3f.m12;
        this.m20 = matrix3f.m20;
        this.m21 = matrix3f.m21;
        this.m22 = matrix3f.m22;
    }

    public Matrix3d() {
        this.m00 = 0.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 0.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 0.0;
    }

    public String toString() {
        return Matrix3d.j("\u3f36", (StringBuilder)Matrix3d.\ud028("\u2ca9", (StringBuilder)Matrix3d.\u4079("\u9205", (StringBuilder)Matrix3d.\ud028("\u2ca9", (StringBuilder)Matrix3d.\u4079("\u9205", (StringBuilder)Matrix3d.\ud028("\u2ca9", (StringBuilder)Matrix3d.\u4079("\u9205", (StringBuilder)Matrix3d.\ud028("\u2ca9", (StringBuilder)Matrix3d.\u4079("\u9205", (StringBuilder)Matrix3d.\ud028("\u2ca9", (StringBuilder)Matrix3d.\u4079("\u9205", (StringBuilder)Matrix3d.\ud028("\u2ca9", (StringBuilder)Matrix3d.\u4079("\u9205", (StringBuilder)Matrix3d.\ud028("\u2ca9", (StringBuilder)Matrix3d.\u4079("\u9205", (StringBuilder)Matrix3d.\ud028("\u2ca9", (StringBuilder)Matrix3d.\u4079("\u9205", (StringBuilder)Matrix3d.\ud028("\u2ca9", (StringBuilder)Matrix3d.\u4079("\u9205", (StringBuilder)new StringBuilder(), (double)this.m00), (String)Vector3f$Matrix3d.\u9c53("\u9818\u0f2a")), (double)this.m01), (String)Vector3f$Matrix3d.\u9c53("\u9818\u0f2a")), (double)this.m02), (String)Vector3f$Matrix3d.\u9c53("\u983e")), (double)this.m10), (String)Vector3f$Matrix3d.\u9c53("\u9818\u0f2a")), (double)this.m11), (String)Vector3f$Matrix3d.\u9c53("\u9818\u0f2a")), (double)this.m12), (String)Vector3f$Matrix3d.\u9c53("\u983e")), (double)this.m20), (String)Vector3f$Matrix3d.\u9c53("\u9818\u0f2a")), (double)this.m21), (String)Vector3f$Matrix3d.\u9c53("\u9818\u0f2a")), (double)this.m22), (String)Vector3f$Matrix3d.\u9c53("\u983e")));
    }

    public final void setIdentity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    }

    public final void setScale(double d) {
        double[] dArray = new double[9];
        double[] dArray2 = new double[3];
        this.getScaleRotate(dArray2, dArray);
        this.m00 = dArray[0] * d;
        this.m01 = dArray[1] * d;
        this.m02 = dArray[2] * d;
        this.m10 = dArray[3] * d;
        this.m11 = dArray[4] * d;
        this.m12 = dArray[5] * d;
        this.m20 = dArray[6] * d;
        this.m21 = dArray[7] * d;
        this.m22 = dArray[8] * d;
    }

    public final void setElement(int n, int n2, double d) {
        block0 : switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        this.m00 = d;
                        break block0;
                    }
                    case 1: {
                        this.m01 = d;
                        break block0;
                    }
                    case 2: {
                        this.m02 = d;
                        break block0;
                    }
                }
                throw new ArrayIndexOutOfBoundsException(Matrix3f$Matrix3d.\u610c("\u1218\ua543\u7edb\u8ec4\u1ddb\u4dbc\uf910\u416a\u8fd9\u049d\u0328\ub38a\u4a0a\u77c8\ub35d\u0bd9\u6f0a\uc4c5\ubf38"));
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        this.m10 = d;
                        break block0;
                    }
                    case 1: {
                        this.m11 = d;
                        break block0;
                    }
                    case 2: {
                        this.m12 = d;
                        break block0;
                    }
                }
                throw new ArrayIndexOutOfBoundsException(Matrix3f$Matrix3d.\u610c("\u1218\ua543\u7edb\u8ec4\u1ddb\u4dbc\uf910\u416a\u8fd9\u049d\u0328\ub38a\u4a0a\u77c8\ub35d\u0bd9\u6f0a\uc4c5\ubf38"));
            }
            case 2: {
                switch (n2) {
                    case 0: {
                        this.m20 = d;
                        break block0;
                    }
                    case 1: {
                        this.m21 = d;
                        break block0;
                    }
                    case 2: {
                        this.m22 = d;
                        break block0;
                    }
                }
                throw new ArrayIndexOutOfBoundsException(Matrix3f$Matrix3d.\u610c("\u1218\ua543\u7edb\u8ec4\u1ddb\u4dbc\uf910\u416a\u8fd9\u049d\u0328\ub38a\u4a0a\u77c8\ub35d\u0bd9\u6f0a\uc4c5\ubf38"));
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(Matrix3f$Matrix3d.\u610c("\u1218\ua543\u7edb\u8ec4\u1ddb\u4dbc\uf910\u416a\u8fd9\u049d\u0328\ub38a\u4a0a\u77c8\ub35d\u0bd9\u6f0a\uc4c5\ubf38"));
            }
        }
    }

    public final double getElement(int n, int n2) {
        switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m01;
                    }
                    case 2: {
                        return this.m02;
                    }
                }
                break;
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        return this.m10;
                    }
                    case 1: {
                        return this.m11;
                    }
                    case 2: {
                        return this.m12;
                    }
                }
                break;
            }
            case 2: {
                switch (n2) {
                    case 0: {
                        return this.m20;
                    }
                    case 1: {
                        return this.m21;
                    }
                    case 2: {
                        return this.m22;
                    }
                }
                break;
            }
        }
        throw new ArrayIndexOutOfBoundsException(Matrix3f$Matrix3d.\u610c("\u1218\ua543\u7edb\u8ec4\u1ddb\u4dbc\uf910\u416a\u8fd9\u049d\u0328\ub38a\u4a0a\u77c8\ub35d\u0bd9\u6f0a\uc4c5\ubf38"));
    }

    public final void getRow(int n, Vector3f vector3f) {
        if (n == 0) {
            vector3f.x = (float)this.m00;
            vector3f.y = (float)this.m01;
            vector3f.z = (float)this.m02;
        } else if (n == 1) {
            vector3f.x = (float)this.m10;
            vector3f.y = (float)this.m11;
            vector3f.z = (float)this.m12;
        } else if (n == 2) {
            vector3f.x = (float)this.m20;
            vector3f.y = (float)this.m21;
            vector3f.z = (float)this.m22;
        } else {
            throw new ArrayIndexOutOfBoundsException(AxisAngle4f$Matrix3d.\u6dd0("\u4ac7\u0fa6\uab73\ua5bf\u9ed8\u1f31\u54ba\uc504\u6c8b\ueae3\uf18a\uf5d4\u33e9\u92d1\u813c\u839d\u2476\ua966\u943f"));
        }
    }

    public final void getRow(int n, double[] dArray) {
        if (n == 0) {
            dArray[0] = this.m00;
            dArray[1] = this.m01;
            dArray[2] = this.m02;
        } else if (n == 1) {
            dArray[0] = this.m10;
            dArray[1] = this.m11;
            dArray[2] = this.m12;
        } else if (n == 2) {
            dArray[0] = this.m20;
            dArray[1] = this.m21;
            dArray[2] = this.m22;
        } else {
            throw new ArrayIndexOutOfBoundsException(Matrix3f$Matrix3d.\u610c("\u1218\ua543\u7edb\u8ec4\u1ddb\u4dbc\uf910\u416a\u8fd9\u049d\u0328\ub38a\u4a0a\u77c8\ub35d\u0bd9\u6f0a\uc4c5\ubf38"));
        }
    }

    public final void getColumn(int n, Vector3f vector3f) {
        if (n == 0) {
            vector3f.x = (float)this.m00;
            vector3f.y = (float)this.m10;
            vector3f.z = (float)this.m20;
        } else if (n == 1) {
            vector3f.x = (float)this.m01;
            vector3f.y = (float)this.m11;
            vector3f.z = (float)this.m21;
        } else if (n == 2) {
            vector3f.x = (float)this.m02;
            vector3f.y = (float)this.m12;
            vector3f.z = (float)this.m22;
        } else {
            throw new ArrayIndexOutOfBoundsException(AxisAngle4f$Matrix4f.\ufb61("\u3600\u2555\u5508\uf3f7\u8a88\u9a46\ud779\u4cdd\u3011\u3b79\u2d7f\u27ef\ud2c1\uc9b7\u906a\u99ef\ueeee\uf1a6\u1f65"));
        }
    }

    public final void getColumn(int n, double[] dArray) {
        if (n == 0) {
            dArray[0] = this.m00;
            dArray[1] = this.m10;
            dArray[2] = this.m20;
        } else if (n == 1) {
            dArray[0] = this.m01;
            dArray[1] = this.m11;
            dArray[2] = this.m21;
        } else if (n == 2) {
            dArray[0] = this.m02;
            dArray[1] = this.m12;
            dArray[2] = this.m22;
        } else {
            throw new ArrayIndexOutOfBoundsException(Matrix3f$Matrix3d.\u610c("\u1218\ua543\u7edb\u8ec4\u1ddb\u4dbc\uf910\u416a\u8fd9\u049d\u0328\ub38a\u4a0a\u77c8\ub35d\u0bd9\u6f0a\uc4c5\ubf38"));
        }
    }

    public final void setRow(int n, double d, double d2, double d3) {
        switch (n) {
            case 0: {
                this.m00 = d;
                this.m01 = d2;
                this.m02 = d3;
                break;
            }
            case 1: {
                this.m10 = d;
                this.m11 = d2;
                this.m12 = d3;
                break;
            }
            case 2: {
                this.m20 = d;
                this.m21 = d2;
                this.m22 = d3;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(Matrix3f$Matrix3d.\u610c("\u1218\ua543\u7edb\u8ec4\u1ddb\u4dbc\uf910\u416a\u8fd9\u049d\u0328\ub38a\u4a0a\u77c8\ub35d\u0bd9\u6f0a\uc4c5\ubf38"));
            }
        }
    }

    public final void setRow(int n, Vector3f vector3f) {
        switch (n) {
            case 0: {
                this.m00 = vector3f.x;
                this.m01 = vector3f.y;
                this.m02 = vector3f.z;
                break;
            }
            case 1: {
                this.m10 = vector3f.x;
                this.m11 = vector3f.y;
                this.m12 = vector3f.z;
                break;
            }
            case 2: {
                this.m20 = vector3f.x;
                this.m21 = vector3f.y;
                this.m22 = vector3f.z;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(AxisAngle4f$Matrix3d.\u6dd0("\u4ac7\u0fa6\uab73\ua5bf\u9ed8\u1f31\u54ba\uc504\u6c8b\ueae3\uf18a\uf5d4\u33e9\u92d1\u813c\u839d\u2476\ua966\u943f"));
            }
        }
    }

    public final void setRow(int n, double[] dArray) {
        switch (n) {
            case 0: {
                this.m00 = dArray[0];
                this.m01 = dArray[1];
                this.m02 = dArray[2];
                break;
            }
            case 1: {
                this.m10 = dArray[0];
                this.m11 = dArray[1];
                this.m12 = dArray[2];
                break;
            }
            case 2: {
                this.m20 = dArray[0];
                this.m21 = dArray[1];
                this.m22 = dArray[2];
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(AxisAngle4f$Matrix4f.\ufb61("\u3600\u2555\u5508\uf3f7\u8a88\u9a46\ud779\u4cdd\u3011\u3b79\u2d7f\u27ef\ud2c1\uc9b7\u906a\u99ef\ueeee\uf1a6\u1f65"));
            }
        }
    }

    public final void setColumn(int n, double d, double d2, double d3) {
        switch (n) {
            case 0: {
                this.m00 = d;
                this.m10 = d2;
                this.m20 = d3;
                break;
            }
            case 1: {
                this.m01 = d;
                this.m11 = d2;
                this.m21 = d3;
                break;
            }
            case 2: {
                this.m02 = d;
                this.m12 = d2;
                this.m22 = d3;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(AxisAngle4f$Matrix3d.\u6dd0("\u4ac7\u0fa6\uab73\ua5bf\u9ed8\u1f31\u54ba\uc504\u6c8b\ueae3\uf18a\uf5d4\u33e9\u92d1\u813c\u839d\u2476\ua966\u943f"));
            }
        }
    }

    public final void setColumn(int n, Vector3f vector3f) {
        switch (n) {
            case 0: {
                this.m00 = vector3f.x;
                this.m10 = vector3f.y;
                this.m20 = vector3f.z;
                break;
            }
            case 1: {
                this.m01 = vector3f.x;
                this.m11 = vector3f.y;
                this.m21 = vector3f.z;
                break;
            }
            case 2: {
                this.m02 = vector3f.x;
                this.m12 = vector3f.y;
                this.m22 = vector3f.z;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(Matrix3f$Matrix3d.\u610c("\u1218\ua543\u7edb\u8ec4\u1ddb\u4dbc\uf910\u416a\u8fd9\u049d\u0328\ub38a\u4a0a\u77c8\ub35d\u0bd9\u6f0a\uc4c5\ubf38"));
            }
        }
    }

    public final void setColumn(int n, double[] dArray) {
        switch (n) {
            case 0: {
                this.m00 = dArray[0];
                this.m10 = dArray[1];
                this.m20 = dArray[2];
                break;
            }
            case 1: {
                this.m01 = dArray[0];
                this.m11 = dArray[1];
                this.m21 = dArray[2];
                break;
            }
            case 2: {
                this.m02 = dArray[0];
                this.m12 = dArray[1];
                this.m22 = dArray[2];
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(AxisAngle4f$Matrix4f.\ufb61("\u3600\u2555\u5508\uf3f7\u8a88\u9a46\ud779\u4cdd\u3011\u3b79\u2d7f\u27ef\ud2c1\uc9b7\u906a\u99ef\ueeee\uf1a6\u1f65"));
            }
        }
    }

    public final double getScale() {
        double[] dArray = new double[3];
        double[] dArray2 = new double[9];
        this.getScaleRotate(dArray, dArray2);
        return Matrix3d.max3(dArray);
    }

    public final void add(double d) {
        this.m00 += d;
        this.m01 += d;
        this.m02 += d;
        this.m10 += d;
        this.m11 += d;
        this.m12 += d;
        this.m20 += d;
        this.m21 += d;
        this.m22 += d;
    }

    public final void add(double d, Matrix3d matrix3d) {
        this.m00 = matrix3d.m00 + d;
        this.m01 = matrix3d.m01 + d;
        this.m02 = matrix3d.m02 + d;
        this.m10 = matrix3d.m10 + d;
        this.m11 = matrix3d.m11 + d;
        this.m12 = matrix3d.m12 + d;
        this.m20 = matrix3d.m20 + d;
        this.m21 = matrix3d.m21 + d;
        this.m22 = matrix3d.m22 + d;
    }

    public final void add(Matrix3d matrix3d, Matrix3d matrix3d2) {
        this.m00 = matrix3d.m00 + matrix3d2.m00;
        this.m01 = matrix3d.m01 + matrix3d2.m01;
        this.m02 = matrix3d.m02 + matrix3d2.m02;
        this.m10 = matrix3d.m10 + matrix3d2.m10;
        this.m11 = matrix3d.m11 + matrix3d2.m11;
        this.m12 = matrix3d.m12 + matrix3d2.m12;
        this.m20 = matrix3d.m20 + matrix3d2.m20;
        this.m21 = matrix3d.m21 + matrix3d2.m21;
        this.m22 = matrix3d.m22 + matrix3d2.m22;
    }

    public final void add(Matrix3d matrix3d) {
        this.m00 += matrix3d.m00;
        this.m01 += matrix3d.m01;
        this.m02 += matrix3d.m02;
        this.m10 += matrix3d.m10;
        this.m11 += matrix3d.m11;
        this.m12 += matrix3d.m12;
        this.m20 += matrix3d.m20;
        this.m21 += matrix3d.m21;
        this.m22 += matrix3d.m22;
    }

    public final void sub(Matrix3d matrix3d, Matrix3d matrix3d2) {
        this.m00 = matrix3d.m00 - matrix3d2.m00;
        this.m01 = matrix3d.m01 - matrix3d2.m01;
        this.m02 = matrix3d.m02 - matrix3d2.m02;
        this.m10 = matrix3d.m10 - matrix3d2.m10;
        this.m11 = matrix3d.m11 - matrix3d2.m11;
        this.m12 = matrix3d.m12 - matrix3d2.m12;
        this.m20 = matrix3d.m20 - matrix3d2.m20;
        this.m21 = matrix3d.m21 - matrix3d2.m21;
        this.m22 = matrix3d.m22 - matrix3d2.m22;
    }

    public final void sub(Matrix3d matrix3d) {
        this.m00 -= matrix3d.m00;
        this.m01 -= matrix3d.m01;
        this.m02 -= matrix3d.m02;
        this.m10 -= matrix3d.m10;
        this.m11 -= matrix3d.m11;
        this.m12 -= matrix3d.m12;
        this.m20 -= matrix3d.m20;
        this.m21 -= matrix3d.m21;
        this.m22 -= matrix3d.m22;
    }

    public final void transpose() {
        double d = this.m10;
        this.m10 = this.m01;
        this.m01 = d;
        d = this.m20;
        this.m20 = this.m02;
        this.m02 = d;
        d = this.m21;
        this.m21 = this.m12;
        this.m12 = d;
    }

    public final void transpose(Matrix3d matrix3d) {
        if (this != matrix3d) {
            this.m00 = matrix3d.m00;
            this.m01 = matrix3d.m10;
            this.m02 = matrix3d.m20;
            this.m10 = matrix3d.m01;
            this.m11 = matrix3d.m11;
            this.m12 = matrix3d.m21;
            this.m20 = matrix3d.m02;
            this.m21 = matrix3d.m12;
            this.m22 = matrix3d.m22;
        } else {
            this.transpose();
        }
    }

    public final void set(Quaternion quaternion) {
        this.m00 = 1.0 - 2.0 * (double)quaternion.y * (double)quaternion.y - 2.0 * (double)quaternion.z * (double)quaternion.z;
        this.m10 = 2.0 * (double)(quaternion.x * quaternion.y + quaternion.w * quaternion.z);
        this.m20 = 2.0 * (double)(quaternion.x * quaternion.z - quaternion.w * quaternion.y);
        this.m01 = 2.0 * (double)(quaternion.x * quaternion.y - quaternion.w * quaternion.z);
        this.m11 = 1.0 - 2.0 * (double)quaternion.x * (double)quaternion.x - 2.0 * (double)quaternion.z * (double)quaternion.z;
        this.m21 = 2.0 * (double)(quaternion.y * quaternion.z + quaternion.w * quaternion.x);
        this.m02 = 2.0 * (double)(quaternion.x * quaternion.z + quaternion.w * quaternion.y);
        this.m12 = 2.0 * (double)(quaternion.y * quaternion.z - quaternion.w * quaternion.x);
        this.m22 = 1.0 - 2.0 * (double)quaternion.x * (double)quaternion.x - 2.0 * (double)quaternion.y * (double)quaternion.y;
    }

    public final void set(AxisAngle4f axisAngle4f) {
        Object object = Matrix3d.\u84fc("\u7aaf", (double)(axisAngle4f.x * axisAngle4f.x + axisAngle4f.y * axisAngle4f.y + axisAngle4f.z * axisAngle4f.z));
        if (object < 1.110223024E-16) {
            this.m00 = 1.0;
            this.m01 = 0.0;
            this.m02 = 0.0;
            this.m10 = 0.0;
            this.m11 = 1.0;
            this.m12 = 0.0;
            this.m20 = 0.0;
            this.m21 = 0.0;
            this.m22 = 1.0;
        } else {
            object = 1.0 / object;
            double d = (double)axisAngle4f.x * object;
            double d2 = (double)axisAngle4f.y * object;
            double d3 = (double)axisAngle4f.z * object;
            Object object2 = Matrix3d.\u582e("\u9c2e", (double)axisAngle4f.angle);
            Object object3 = Matrix3d.\u4ce4("\u1bc6", (double)axisAngle4f.angle);
            double d4 = 1.0 - object3;
            double d5 = d * d3;
            double d6 = d * d2;
            double d7 = d2 * d3;
            this.m00 = d4 * d * d + object3;
            this.m01 = d4 * d6 - object2 * d3;
            this.m02 = d4 * d5 + object2 * d2;
            this.m10 = d4 * d6 + object2 * d3;
            this.m11 = d4 * d2 * d2 + object3;
            this.m12 = d4 * d7 - object2 * d;
            this.m20 = d4 * d5 - object2 * d2;
            this.m21 = d4 * d7 + object2 * d;
            this.m22 = d4 * d3 * d3 + object3;
        }
    }

    public final void set(Matrix3f matrix3f) {
        this.m00 = matrix3f.m00;
        this.m01 = matrix3f.m01;
        this.m02 = matrix3f.m02;
        this.m10 = matrix3f.m10;
        this.m11 = matrix3f.m11;
        this.m12 = matrix3f.m12;
        this.m20 = matrix3f.m20;
        this.m21 = matrix3f.m21;
        this.m22 = matrix3f.m22;
    }

    public final void set(Matrix3d matrix3d) {
        this.m00 = matrix3d.m00;
        this.m01 = matrix3d.m01;
        this.m02 = matrix3d.m02;
        this.m10 = matrix3d.m10;
        this.m11 = matrix3d.m11;
        this.m12 = matrix3d.m12;
        this.m20 = matrix3d.m20;
        this.m21 = matrix3d.m21;
        this.m22 = matrix3d.m22;
    }

    public final void set(double[] dArray) {
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m02 = dArray[2];
        this.m10 = dArray[3];
        this.m11 = dArray[4];
        this.m12 = dArray[5];
        this.m20 = dArray[6];
        this.m21 = dArray[7];
        this.m22 = dArray[8];
    }

    public final void invert(Matrix3d matrix3d) {
        this.invertGeneral(matrix3d);
    }

    public final void invert() {
        this.invertGeneral(this);
    }

    private final void invertGeneral(Matrix3d matrix3d) {
        double[] dArray = new double[9];
        int[] nArray = new int[3];
        double[] dArray2 = new double[]{matrix3d.m00, matrix3d.m01, matrix3d.m02, matrix3d.m10, matrix3d.m11, matrix3d.m12, matrix3d.m20, matrix3d.m21, matrix3d.m22};
        if (!Matrix3d.luDecomposition(dArray2, nArray)) {
            try {
                throw new Exception(Matrix3f$Matrix3d.\u610c("\u1218\ua543\u7edb\u8ec4\u1ddb\u4dbc\uf910\u416a\u8fd9\u049d\u0328\ub38a\u4a0a\u77c8\ub35d\u0bd9\u6f0a\uc4c5\ubf38\u3688\udd9f"));
            }
            catch (Exception exception) {
                Matrix3d.\u16ef("\u3ab7", (Exception)exception);
            }
        }
        for (int i = 0; i < 9; ++i) {
            dArray[i] = 0.0;
        }
        dArray[0] = 1.0;
        dArray[4] = 1.0;
        dArray[8] = 1.0;
        Matrix3d.luBacksubstitution(dArray2, nArray, dArray);
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m02 = dArray[2];
        this.m10 = dArray[3];
        this.m11 = dArray[4];
        this.m12 = dArray[5];
        this.m20 = dArray[6];
        this.m21 = dArray[7];
        this.m22 = dArray[8];
    }

    static boolean luDecomposition(double[] dArray, int[] nArray) {
        int n;
        double[] dArray2 = new double[3];
        int n2 = 0;
        int n3 = 0;
        int n4 = 3;
        while (n4-- != 0) {
            Object object = 0.0;
            n = 3;
            while (n-- != 0) {
                Object object2 = dArray[n2++];
                if (!((object2 = (Object)Matrix3d.\u63a8("\u6a9c", (double)object2)) > object)) continue;
                object = object2;
            }
            if (object == 0.0) {
                return false;
            }
            dArray2[n3++] = 1.0 / object;
        }
        n = 0;
        for (n4 = 0; n4 < 3; ++n4) {
            double d;
            int n5;
            int n6;
            int n7;
            double d2;
            int n8;
            for (n2 = 0; n2 < n4; ++n2) {
                n8 = n + 3 * n2 + n4;
                d2 = dArray[n8];
                int n9 = n2;
                int n10 = n + 3 * n2;
                n7 = n + n4;
                while (n9-- != 0) {
                    d2 -= dArray[n10] * dArray[n7];
                    ++n10;
                    n7 += 3;
                }
                dArray[n8] = d2;
            }
            double d3 = 0.0;
            n3 = -1;
            for (n2 = n4; n2 < 3; ++n2) {
                double d4;
                n8 = n + 3 * n2 + n4;
                d2 = dArray[n8];
                n6 = n4;
                n5 = n + 3 * n2;
                n7 = n + n4;
                while (n6-- != 0) {
                    d2 -= dArray[n5] * dArray[n7];
                    ++n5;
                    n7 += 3;
                }
                dArray[n8] = d2;
                d = dArray2[n2] * Matrix3d.\u63a8("\u6a9c", (double)d2);
                if (!(d4 >= d3)) continue;
                d3 = d;
                n3 = n2;
            }
            if (n3 < 0) {
                throw new RuntimeException(AxisAngle4f$Matrix4f.\ufb61("\u3600\u2555\u5508\uf3f7\u8a88\u9a46\ud779\u4cdd\u3011\u3b79\u2d7f\u27ef\ud2c1\uc9b7\u906a\u99ef\ueeee\uf1a6\u1f65"));
            }
            if (n4 != n3) {
                n6 = 3;
                n5 = n + 3 * n3;
                n7 = n + 3 * n4;
                while (n6-- != 0) {
                    d = dArray[n5];
                    dArray[n5++] = dArray[n7];
                    dArray[n7++] = d;
                }
                dArray2[n3] = dArray2[n4];
            }
            nArray[n4] = n3;
            if (dArray[n + 3 * n4 + n4] == 0.0) {
                return false;
            }
            if (n4 == 2) continue;
            d = 1.0 / dArray[n + 3 * n4 + n4];
            n8 = n + 3 * (n4 + 1) + n4;
            n2 = 2 - n4;
            while (n2-- != 0) {
                int n11 = n8;
                dArray[n11] = dArray[n11] * d;
                n8 += 3;
            }
        }
        return true;
    }

    static void luBacksubstitution(double[] dArray, int[] nArray, double[] dArray2) {
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            int n2;
            int n3 = i;
            int n4 = -1;
            for (int j = 0; j < 3; ++j) {
                int n5 = nArray[n + j];
                double d = dArray2[n3 + 3 * n5];
                dArray2[n3 + 3 * n5] = dArray2[n3 + 3 * j];
                if (n4 >= 0) {
                    n2 = j * 3;
                    for (int k = n4; k <= j - 1; ++k) {
                        d -= dArray[n2 + k] * dArray2[n3 + 3 * k];
                    }
                } else if (d != 0.0) {
                    n4 = j;
                }
                dArray2[n3 + 3 * j] = d;
            }
            n2 = 6;
            int n6 = n3 + 6;
            dArray2[n6] = dArray2[n6] / dArray[n2 + 2];
            dArray2[n3 + 3] = (dArray2[n3 + 3] - dArray[(n2 -= 3) + 2] * dArray2[n3 + 6]) / dArray[n2 + 1];
            dArray2[n3 + 0] = (dArray2[n3 + 0] - dArray[(n2 -= 3) + 1] * dArray2[n3 + 3] - dArray[n2 + 2] * dArray2[n3 + 6]) / dArray[n2 + 0];
        }
    }

    public final double determinant() {
        double d = this.m00 * (this.m11 * this.m22 - this.m12 * this.m21) + this.m01 * (this.m12 * this.m20 - this.m10 * this.m22) + this.m02 * (this.m10 * this.m21 - this.m11 * this.m20);
        return d;
    }

    public final void set(double d) {
        this.m00 = d;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = d;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = d;
    }

    public final void rotX(double d) {
        Object object = Matrix3d.\u582e("\u9c2e", (double)d);
        Object object2 = Matrix3d.\u4ce4("\u1bc6", (double)d);
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = (double)object2;
        this.m12 = (double)(-object);
        this.m20 = 0.0;
        this.m21 = (double)object;
        this.m22 = (double)object2;
    }

    public final void rotY(double d) {
        Object object = Matrix3d.\u582e("\u9c2e", (double)d);
        Object object2 = Matrix3d.\u4ce4("\u1bc6", (double)d);
        this.m00 = (double)object2;
        this.m01 = 0.0;
        this.m02 = (double)object;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = (double)(-object);
        this.m21 = 0.0;
        this.m22 = (double)object2;
    }

    public final void rotZ(double d) {
        Object object = Matrix3d.\u582e("\u9c2e", (double)d);
        Object object2 = Matrix3d.\u4ce4("\u1bc6", (double)d);
        this.m00 = (double)object2;
        this.m01 = (double)(-object);
        this.m02 = 0.0;
        this.m10 = (double)object;
        this.m11 = (double)object2;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    }

    public final void mul(double d) {
        this.m00 *= d;
        this.m01 *= d;
        this.m02 *= d;
        this.m10 *= d;
        this.m11 *= d;
        this.m12 *= d;
        this.m20 *= d;
        this.m21 *= d;
        this.m22 *= d;
    }

    public final void mul(double d, Matrix3d matrix3d) {
        this.m00 = d * matrix3d.m00;
        this.m01 = d * matrix3d.m01;
        this.m02 = d * matrix3d.m02;
        this.m10 = d * matrix3d.m10;
        this.m11 = d * matrix3d.m11;
        this.m12 = d * matrix3d.m12;
        this.m20 = d * matrix3d.m20;
        this.m21 = d * matrix3d.m21;
        this.m22 = d * matrix3d.m22;
    }

    public final void mul(Matrix3d matrix3d) {
        double d = this.m00 * matrix3d.m00 + this.m01 * matrix3d.m10 + this.m02 * matrix3d.m20;
        double d2 = this.m00 * matrix3d.m01 + this.m01 * matrix3d.m11 + this.m02 * matrix3d.m21;
        double d3 = this.m00 * matrix3d.m02 + this.m01 * matrix3d.m12 + this.m02 * matrix3d.m22;
        double d4 = this.m10 * matrix3d.m00 + this.m11 * matrix3d.m10 + this.m12 * matrix3d.m20;
        double d5 = this.m10 * matrix3d.m01 + this.m11 * matrix3d.m11 + this.m12 * matrix3d.m21;
        double d6 = this.m10 * matrix3d.m02 + this.m11 * matrix3d.m12 + this.m12 * matrix3d.m22;
        double d7 = this.m20 * matrix3d.m00 + this.m21 * matrix3d.m10 + this.m22 * matrix3d.m20;
        double d8 = this.m20 * matrix3d.m01 + this.m21 * matrix3d.m11 + this.m22 * matrix3d.m21;
        double d9 = this.m20 * matrix3d.m02 + this.m21 * matrix3d.m12 + this.m22 * matrix3d.m22;
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m10 = d4;
        this.m11 = d5;
        this.m12 = d6;
        this.m20 = d7;
        this.m21 = d8;
        this.m22 = d9;
    }

    public final void mul(Matrix3d matrix3d, Matrix3d matrix3d2) {
        if (this != matrix3d && this != matrix3d2) {
            this.m00 = matrix3d.m00 * matrix3d2.m00 + matrix3d.m01 * matrix3d2.m10 + matrix3d.m02 * matrix3d2.m20;
            this.m01 = matrix3d.m00 * matrix3d2.m01 + matrix3d.m01 * matrix3d2.m11 + matrix3d.m02 * matrix3d2.m21;
            this.m02 = matrix3d.m00 * matrix3d2.m02 + matrix3d.m01 * matrix3d2.m12 + matrix3d.m02 * matrix3d2.m22;
            this.m10 = matrix3d.m10 * matrix3d2.m00 + matrix3d.m11 * matrix3d2.m10 + matrix3d.m12 * matrix3d2.m20;
            this.m11 = matrix3d.m10 * matrix3d2.m01 + matrix3d.m11 * matrix3d2.m11 + matrix3d.m12 * matrix3d2.m21;
            this.m12 = matrix3d.m10 * matrix3d2.m02 + matrix3d.m11 * matrix3d2.m12 + matrix3d.m12 * matrix3d2.m22;
            this.m20 = matrix3d.m20 * matrix3d2.m00 + matrix3d.m21 * matrix3d2.m10 + matrix3d.m22 * matrix3d2.m20;
            this.m21 = matrix3d.m20 * matrix3d2.m01 + matrix3d.m21 * matrix3d2.m11 + matrix3d.m22 * matrix3d2.m21;
            this.m22 = matrix3d.m20 * matrix3d2.m02 + matrix3d.m21 * matrix3d2.m12 + matrix3d.m22 * matrix3d2.m22;
        } else {
            double d = matrix3d.m00 * matrix3d2.m00 + matrix3d.m01 * matrix3d2.m10 + matrix3d.m02 * matrix3d2.m20;
            double d2 = matrix3d.m00 * matrix3d2.m01 + matrix3d.m01 * matrix3d2.m11 + matrix3d.m02 * matrix3d2.m21;
            double d3 = matrix3d.m00 * matrix3d2.m02 + matrix3d.m01 * matrix3d2.m12 + matrix3d.m02 * matrix3d2.m22;
            double d4 = matrix3d.m10 * matrix3d2.m00 + matrix3d.m11 * matrix3d2.m10 + matrix3d.m12 * matrix3d2.m20;
            double d5 = matrix3d.m10 * matrix3d2.m01 + matrix3d.m11 * matrix3d2.m11 + matrix3d.m12 * matrix3d2.m21;
            double d6 = matrix3d.m10 * matrix3d2.m02 + matrix3d.m11 * matrix3d2.m12 + matrix3d.m12 * matrix3d2.m22;
            double d7 = matrix3d.m20 * matrix3d2.m00 + matrix3d.m21 * matrix3d2.m10 + matrix3d.m22 * matrix3d2.m20;
            double d8 = matrix3d.m20 * matrix3d2.m01 + matrix3d.m21 * matrix3d2.m11 + matrix3d.m22 * matrix3d2.m21;
            double d9 = matrix3d.m20 * matrix3d2.m02 + matrix3d.m21 * matrix3d2.m12 + matrix3d.m22 * matrix3d2.m22;
            this.m00 = d;
            this.m01 = d2;
            this.m02 = d3;
            this.m10 = d4;
            this.m11 = d5;
            this.m12 = d6;
            this.m20 = d7;
            this.m21 = d8;
            this.m22 = d9;
        }
    }

    public final void mulNormalize(Matrix3d matrix3d) {
        double[] dArray = new double[9];
        double[] dArray2 = new double[9];
        double[] dArray3 = new double[3];
        dArray[0] = this.m00 * matrix3d.m00 + this.m01 * matrix3d.m10 + this.m02 * matrix3d.m20;
        dArray[1] = this.m00 * matrix3d.m01 + this.m01 * matrix3d.m11 + this.m02 * matrix3d.m21;
        dArray[2] = this.m00 * matrix3d.m02 + this.m01 * matrix3d.m12 + this.m02 * matrix3d.m22;
        dArray[3] = this.m10 * matrix3d.m00 + this.m11 * matrix3d.m10 + this.m12 * matrix3d.m20;
        dArray[4] = this.m10 * matrix3d.m01 + this.m11 * matrix3d.m11 + this.m12 * matrix3d.m21;
        dArray[5] = this.m10 * matrix3d.m02 + this.m11 * matrix3d.m12 + this.m12 * matrix3d.m22;
        dArray[6] = this.m20 * matrix3d.m00 + this.m21 * matrix3d.m10 + this.m22 * matrix3d.m20;
        dArray[7] = this.m20 * matrix3d.m01 + this.m21 * matrix3d.m11 + this.m22 * matrix3d.m21;
        dArray[8] = this.m20 * matrix3d.m02 + this.m21 * matrix3d.m12 + this.m22 * matrix3d.m22;
        Matrix3d.compute_svd(dArray, dArray3, dArray2);
        this.m00 = dArray2[0];
        this.m01 = dArray2[1];
        this.m02 = dArray2[2];
        this.m10 = dArray2[3];
        this.m11 = dArray2[4];
        this.m12 = dArray2[5];
        this.m20 = dArray2[6];
        this.m21 = dArray2[7];
        this.m22 = dArray2[8];
    }

    public final void mulNormalize(Matrix3d matrix3d, Matrix3d matrix3d2) {
        double[] dArray = new double[9];
        double[] dArray2 = new double[9];
        double[] dArray3 = new double[3];
        dArray[0] = matrix3d.m00 * matrix3d2.m00 + matrix3d.m01 * matrix3d2.m10 + matrix3d.m02 * matrix3d2.m20;
        dArray[1] = matrix3d.m00 * matrix3d2.m01 + matrix3d.m01 * matrix3d2.m11 + matrix3d.m02 * matrix3d2.m21;
        dArray[2] = matrix3d.m00 * matrix3d2.m02 + matrix3d.m01 * matrix3d2.m12 + matrix3d.m02 * matrix3d2.m22;
        dArray[3] = matrix3d.m10 * matrix3d2.m00 + matrix3d.m11 * matrix3d2.m10 + matrix3d.m12 * matrix3d2.m20;
        dArray[4] = matrix3d.m10 * matrix3d2.m01 + matrix3d.m11 * matrix3d2.m11 + matrix3d.m12 * matrix3d2.m21;
        dArray[5] = matrix3d.m10 * matrix3d2.m02 + matrix3d.m11 * matrix3d2.m12 + matrix3d.m12 * matrix3d2.m22;
        dArray[6] = matrix3d.m20 * matrix3d2.m00 + matrix3d.m21 * matrix3d2.m10 + matrix3d.m22 * matrix3d2.m20;
        dArray[7] = matrix3d.m20 * matrix3d2.m01 + matrix3d.m21 * matrix3d2.m11 + matrix3d.m22 * matrix3d2.m21;
        dArray[8] = matrix3d.m20 * matrix3d2.m02 + matrix3d.m21 * matrix3d2.m12 + matrix3d.m22 * matrix3d2.m22;
        Matrix3d.compute_svd(dArray, dArray3, dArray2);
        this.m00 = dArray2[0];
        this.m01 = dArray2[1];
        this.m02 = dArray2[2];
        this.m10 = dArray2[3];
        this.m11 = dArray2[4];
        this.m12 = dArray2[5];
        this.m20 = dArray2[6];
        this.m21 = dArray2[7];
        this.m22 = dArray2[8];
    }

    public final void mulTransposeBoth(Matrix3d matrix3d, Matrix3d matrix3d2) {
        if (this != matrix3d && this != matrix3d2) {
            this.m00 = matrix3d.m00 * matrix3d2.m00 + matrix3d.m10 * matrix3d2.m01 + matrix3d.m20 * matrix3d2.m02;
            this.m01 = matrix3d.m00 * matrix3d2.m10 + matrix3d.m10 * matrix3d2.m11 + matrix3d.m20 * matrix3d2.m12;
            this.m02 = matrix3d.m00 * matrix3d2.m20 + matrix3d.m10 * matrix3d2.m21 + matrix3d.m20 * matrix3d2.m22;
            this.m10 = matrix3d.m01 * matrix3d2.m00 + matrix3d.m11 * matrix3d2.m01 + matrix3d.m21 * matrix3d2.m02;
            this.m11 = matrix3d.m01 * matrix3d2.m10 + matrix3d.m11 * matrix3d2.m11 + matrix3d.m21 * matrix3d2.m12;
            this.m12 = matrix3d.m01 * matrix3d2.m20 + matrix3d.m11 * matrix3d2.m21 + matrix3d.m21 * matrix3d2.m22;
            this.m20 = matrix3d.m02 * matrix3d2.m00 + matrix3d.m12 * matrix3d2.m01 + matrix3d.m22 * matrix3d2.m02;
            this.m21 = matrix3d.m02 * matrix3d2.m10 + matrix3d.m12 * matrix3d2.m11 + matrix3d.m22 * matrix3d2.m12;
            this.m22 = matrix3d.m02 * matrix3d2.m20 + matrix3d.m12 * matrix3d2.m21 + matrix3d.m22 * matrix3d2.m22;
        } else {
            double d = matrix3d.m00 * matrix3d2.m00 + matrix3d.m10 * matrix3d2.m01 + matrix3d.m20 * matrix3d2.m02;
            double d2 = matrix3d.m00 * matrix3d2.m10 + matrix3d.m10 * matrix3d2.m11 + matrix3d.m20 * matrix3d2.m12;
            double d3 = matrix3d.m00 * matrix3d2.m20 + matrix3d.m10 * matrix3d2.m21 + matrix3d.m20 * matrix3d2.m22;
            double d4 = matrix3d.m01 * matrix3d2.m00 + matrix3d.m11 * matrix3d2.m01 + matrix3d.m21 * matrix3d2.m02;
            double d5 = matrix3d.m01 * matrix3d2.m10 + matrix3d.m11 * matrix3d2.m11 + matrix3d.m21 * matrix3d2.m12;
            double d6 = matrix3d.m01 * matrix3d2.m20 + matrix3d.m11 * matrix3d2.m21 + matrix3d.m21 * matrix3d2.m22;
            double d7 = matrix3d.m02 * matrix3d2.m00 + matrix3d.m12 * matrix3d2.m01 + matrix3d.m22 * matrix3d2.m02;
            double d8 = matrix3d.m02 * matrix3d2.m10 + matrix3d.m12 * matrix3d2.m11 + matrix3d.m22 * matrix3d2.m12;
            double d9 = matrix3d.m02 * matrix3d2.m20 + matrix3d.m12 * matrix3d2.m21 + matrix3d.m22 * matrix3d2.m22;
            this.m00 = d;
            this.m01 = d2;
            this.m02 = d3;
            this.m10 = d4;
            this.m11 = d5;
            this.m12 = d6;
            this.m20 = d7;
            this.m21 = d8;
            this.m22 = d9;
        }
    }

    public final void mulTransposeRight(Matrix3d matrix3d, Matrix3d matrix3d2) {
        if (this != matrix3d && this != matrix3d2) {
            this.m00 = matrix3d.m00 * matrix3d2.m00 + matrix3d.m01 * matrix3d2.m01 + matrix3d.m02 * matrix3d2.m02;
            this.m01 = matrix3d.m00 * matrix3d2.m10 + matrix3d.m01 * matrix3d2.m11 + matrix3d.m02 * matrix3d2.m12;
            this.m02 = matrix3d.m00 * matrix3d2.m20 + matrix3d.m01 * matrix3d2.m21 + matrix3d.m02 * matrix3d2.m22;
            this.m10 = matrix3d.m10 * matrix3d2.m00 + matrix3d.m11 * matrix3d2.m01 + matrix3d.m12 * matrix3d2.m02;
            this.m11 = matrix3d.m10 * matrix3d2.m10 + matrix3d.m11 * matrix3d2.m11 + matrix3d.m12 * matrix3d2.m12;
            this.m12 = matrix3d.m10 * matrix3d2.m20 + matrix3d.m11 * matrix3d2.m21 + matrix3d.m12 * matrix3d2.m22;
            this.m20 = matrix3d.m20 * matrix3d2.m00 + matrix3d.m21 * matrix3d2.m01 + matrix3d.m22 * matrix3d2.m02;
            this.m21 = matrix3d.m20 * matrix3d2.m10 + matrix3d.m21 * matrix3d2.m11 + matrix3d.m22 * matrix3d2.m12;
            this.m22 = matrix3d.m20 * matrix3d2.m20 + matrix3d.m21 * matrix3d2.m21 + matrix3d.m22 * matrix3d2.m22;
        } else {
            double d = matrix3d.m00 * matrix3d2.m00 + matrix3d.m01 * matrix3d2.m01 + matrix3d.m02 * matrix3d2.m02;
            double d2 = matrix3d.m00 * matrix3d2.m10 + matrix3d.m01 * matrix3d2.m11 + matrix3d.m02 * matrix3d2.m12;
            double d3 = matrix3d.m00 * matrix3d2.m20 + matrix3d.m01 * matrix3d2.m21 + matrix3d.m02 * matrix3d2.m22;
            double d4 = matrix3d.m10 * matrix3d2.m00 + matrix3d.m11 * matrix3d2.m01 + matrix3d.m12 * matrix3d2.m02;
            double d5 = matrix3d.m10 * matrix3d2.m10 + matrix3d.m11 * matrix3d2.m11 + matrix3d.m12 * matrix3d2.m12;
            double d6 = matrix3d.m10 * matrix3d2.m20 + matrix3d.m11 * matrix3d2.m21 + matrix3d.m12 * matrix3d2.m22;
            double d7 = matrix3d.m20 * matrix3d2.m00 + matrix3d.m21 * matrix3d2.m01 + matrix3d.m22 * matrix3d2.m02;
            double d8 = matrix3d.m20 * matrix3d2.m10 + matrix3d.m21 * matrix3d2.m11 + matrix3d.m22 * matrix3d2.m12;
            double d9 = matrix3d.m20 * matrix3d2.m20 + matrix3d.m21 * matrix3d2.m21 + matrix3d.m22 * matrix3d2.m22;
            this.m00 = d;
            this.m01 = d2;
            this.m02 = d3;
            this.m10 = d4;
            this.m11 = d5;
            this.m12 = d6;
            this.m20 = d7;
            this.m21 = d8;
            this.m22 = d9;
        }
    }

    public final void mulTransposeLeft(Matrix3d matrix3d, Matrix3d matrix3d2) {
        if (this != matrix3d && this != matrix3d2) {
            this.m00 = matrix3d.m00 * matrix3d2.m00 + matrix3d.m10 * matrix3d2.m10 + matrix3d.m20 * matrix3d2.m20;
            this.m01 = matrix3d.m00 * matrix3d2.m01 + matrix3d.m10 * matrix3d2.m11 + matrix3d.m20 * matrix3d2.m21;
            this.m02 = matrix3d.m00 * matrix3d2.m02 + matrix3d.m10 * matrix3d2.m12 + matrix3d.m20 * matrix3d2.m22;
            this.m10 = matrix3d.m01 * matrix3d2.m00 + matrix3d.m11 * matrix3d2.m10 + matrix3d.m21 * matrix3d2.m20;
            this.m11 = matrix3d.m01 * matrix3d2.m01 + matrix3d.m11 * matrix3d2.m11 + matrix3d.m21 * matrix3d2.m21;
            this.m12 = matrix3d.m01 * matrix3d2.m02 + matrix3d.m11 * matrix3d2.m12 + matrix3d.m21 * matrix3d2.m22;
            this.m20 = matrix3d.m02 * matrix3d2.m00 + matrix3d.m12 * matrix3d2.m10 + matrix3d.m22 * matrix3d2.m20;
            this.m21 = matrix3d.m02 * matrix3d2.m01 + matrix3d.m12 * matrix3d2.m11 + matrix3d.m22 * matrix3d2.m21;
            this.m22 = matrix3d.m02 * matrix3d2.m02 + matrix3d.m12 * matrix3d2.m12 + matrix3d.m22 * matrix3d2.m22;
        } else {
            double d = matrix3d.m00 * matrix3d2.m00 + matrix3d.m10 * matrix3d2.m10 + matrix3d.m20 * matrix3d2.m20;
            double d2 = matrix3d.m00 * matrix3d2.m01 + matrix3d.m10 * matrix3d2.m11 + matrix3d.m20 * matrix3d2.m21;
            double d3 = matrix3d.m00 * matrix3d2.m02 + matrix3d.m10 * matrix3d2.m12 + matrix3d.m20 * matrix3d2.m22;
            double d4 = matrix3d.m01 * matrix3d2.m00 + matrix3d.m11 * matrix3d2.m10 + matrix3d.m21 * matrix3d2.m20;
            double d5 = matrix3d.m01 * matrix3d2.m01 + matrix3d.m11 * matrix3d2.m11 + matrix3d.m21 * matrix3d2.m21;
            double d6 = matrix3d.m01 * matrix3d2.m02 + matrix3d.m11 * matrix3d2.m12 + matrix3d.m21 * matrix3d2.m22;
            double d7 = matrix3d.m02 * matrix3d2.m00 + matrix3d.m12 * matrix3d2.m10 + matrix3d.m22 * matrix3d2.m20;
            double d8 = matrix3d.m02 * matrix3d2.m01 + matrix3d.m12 * matrix3d2.m11 + matrix3d.m22 * matrix3d2.m21;
            double d9 = matrix3d.m02 * matrix3d2.m02 + matrix3d.m12 * matrix3d2.m12 + matrix3d.m22 * matrix3d2.m22;
            this.m00 = d;
            this.m01 = d2;
            this.m02 = d3;
            this.m10 = d4;
            this.m11 = d5;
            this.m12 = d6;
            this.m20 = d7;
            this.m21 = d8;
            this.m22 = d9;
        }
    }

    public final void normalize() {
        double[] dArray = new double[9];
        double[] dArray2 = new double[3];
        this.getScaleRotate(dArray2, dArray);
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m02 = dArray[2];
        this.m10 = dArray[3];
        this.m11 = dArray[4];
        this.m12 = dArray[5];
        this.m20 = dArray[6];
        this.m21 = dArray[7];
        this.m22 = dArray[8];
    }

    public final void normalize(Matrix3d matrix3d) {
        double[] dArray = new double[9];
        double[] dArray2 = new double[9];
        double[] dArray3 = new double[3];
        dArray[0] = matrix3d.m00;
        dArray[1] = matrix3d.m01;
        dArray[2] = matrix3d.m02;
        dArray[3] = matrix3d.m10;
        dArray[4] = matrix3d.m11;
        dArray[5] = matrix3d.m12;
        dArray[6] = matrix3d.m20;
        dArray[7] = matrix3d.m21;
        dArray[8] = matrix3d.m22;
        Matrix3d.compute_svd(dArray, dArray3, dArray2);
        this.m00 = dArray2[0];
        this.m01 = dArray2[1];
        this.m02 = dArray2[2];
        this.m10 = dArray2[3];
        this.m11 = dArray2[4];
        this.m12 = dArray2[5];
        this.m20 = dArray2[6];
        this.m21 = dArray2[7];
        this.m22 = dArray2[8];
    }

    public final void normalizeCP() {
        double d = 1.0 / Matrix3d.\u84fc("\u7aaf", (double)(this.m00 * this.m00 + this.m10 * this.m10 + this.m20 * this.m20));
        this.m00 *= d;
        this.m10 *= d;
        this.m20 *= d;
        d = 1.0 / Matrix3d.\u84fc("\u7aaf", (double)(this.m01 * this.m01 + this.m11 * this.m11 + this.m21 * this.m21));
        this.m01 *= d;
        this.m11 *= d;
        this.m21 *= d;
        this.m02 = this.m10 * this.m21 - this.m11 * this.m20;
        this.m12 = this.m01 * this.m20 - this.m00 * this.m21;
        this.m22 = this.m00 * this.m11 - this.m01 * this.m10;
    }

    public final void normalizeCP(Matrix3d matrix3d) {
        double d = 1.0 / Matrix3d.\u84fc("\u7aaf", (double)(matrix3d.m00 * matrix3d.m00 + matrix3d.m10 * matrix3d.m10 + matrix3d.m20 * matrix3d.m20));
        this.m00 = matrix3d.m00 * d;
        this.m10 = matrix3d.m10 * d;
        this.m20 = matrix3d.m20 * d;
        d = 1.0 / Matrix3d.\u84fc("\u7aaf", (double)(matrix3d.m01 * matrix3d.m01 + matrix3d.m11 * matrix3d.m11 + matrix3d.m21 * matrix3d.m21));
        this.m01 = matrix3d.m01 * d;
        this.m11 = matrix3d.m11 * d;
        this.m21 = matrix3d.m21 * d;
        this.m02 = this.m10 * this.m21 - this.m11 * this.m20;
        this.m12 = this.m01 * this.m20 - this.m00 * this.m21;
        this.m22 = this.m00 * this.m11 - this.m01 * this.m10;
    }

    public boolean equals(Matrix3d matrix3d) {
        try {
            return this.m00 == matrix3d.m00 && this.m01 == matrix3d.m01 && this.m02 == matrix3d.m02 && this.m10 == matrix3d.m10 && this.m11 == matrix3d.m11 && this.m12 == matrix3d.m12 && this.m20 == matrix3d.m20 && this.m21 == matrix3d.m21 && this.m22 == matrix3d.m22;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean equals(Object object) {
        try {
            Matrix3d matrix3d = (Matrix3d)object;
            return this.m00 == matrix3d.m00 && this.m01 == matrix3d.m01 && this.m02 == matrix3d.m02 && this.m10 == matrix3d.m10 && this.m11 == matrix3d.m11 && this.m12 == matrix3d.m12 && this.m20 == matrix3d.m20 && this.m21 == matrix3d.m21 && this.m22 == matrix3d.m22;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean epsilonEquals(Matrix3d matrix3d, double d) {
        double d2 = this.m00 - matrix3d.m00;
        double d3 = d2 < 0.0 ? -d2 : d2;
        if (d3 > d) {
            return false;
        }
        d2 = this.m01 - matrix3d.m01;
        double d4 = d2 < 0.0 ? -d2 : d2;
        if (d4 > d) {
            return false;
        }
        d2 = this.m02 - matrix3d.m02;
        double d5 = d2 < 0.0 ? -d2 : d2;
        if (d5 > d) {
            return false;
        }
        d2 = this.m10 - matrix3d.m10;
        double d6 = d2 < 0.0 ? -d2 : d2;
        if (d6 > d) {
            return false;
        }
        d2 = this.m11 - matrix3d.m11;
        double d7 = d2 < 0.0 ? -d2 : d2;
        if (d7 > d) {
            return false;
        }
        d2 = this.m12 - matrix3d.m12;
        double d8 = d2 < 0.0 ? -d2 : d2;
        if (d8 > d) {
            return false;
        }
        d2 = this.m20 - matrix3d.m20;
        double d9 = d2 < 0.0 ? -d2 : d2;
        if (d9 > d) {
            return false;
        }
        d2 = this.m21 - matrix3d.m21;
        double d10 = d2 < 0.0 ? -d2 : d2;
        if (d10 > d) {
            return false;
        }
        d2 = this.m22 - matrix3d.m22;
        double d11 = d2 < 0.0 ? -d2 : d2;
        return !(d11 > d);
    }

    public final void setZero() {
        this.m00 = 0.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 0.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 0.0;
    }

    public final void negate() {
        this.m00 = -this.m00;
        this.m01 = -this.m01;
        this.m02 = -this.m02;
        this.m10 = -this.m10;
        this.m11 = -this.m11;
        this.m12 = -this.m12;
        this.m20 = -this.m20;
        this.m21 = -this.m21;
        this.m22 = -this.m22;
    }

    public final void negate(Matrix3d matrix3d) {
        this.m00 = -matrix3d.m00;
        this.m01 = -matrix3d.m01;
        this.m02 = -matrix3d.m02;
        this.m10 = -matrix3d.m10;
        this.m11 = -matrix3d.m11;
        this.m12 = -matrix3d.m12;
        this.m20 = -matrix3d.m20;
        this.m21 = -matrix3d.m21;
        this.m22 = -matrix3d.m22;
    }

    final void getScaleRotate(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22};
        Matrix3d.compute_svd(dArray3, dArray, dArray2);
    }

    static void compute_svd(double[] dArray, double[] dArray2, double[] dArray3) {
        double d;
        int n;
        double[] dArray4 = new double[9];
        double[] dArray5 = new double[9];
        double[] dArray6 = new double[9];
        double[] dArray7 = new double[9];
        double[] dArray8 = dArray6;
        double[] dArray9 = dArray7;
        double[] dArray10 = new double[9];
        double[] dArray11 = new double[3];
        double[] dArray12 = new double[3];
        int n2 = 0;
        for (n = 0; n < 9; ++n) {
            dArray10[n] = dArray[n];
        }
        if (dArray[3] * dArray[3] < 1.110223024E-16) {
            dArray4[0] = 1.0;
            dArray4[1] = 0.0;
            dArray4[2] = 0.0;
            dArray4[3] = 0.0;
            dArray4[4] = 1.0;
            dArray4[5] = 0.0;
            dArray4[6] = 0.0;
            dArray4[7] = 0.0;
            dArray4[8] = 1.0;
        } else if (dArray[0] * dArray[0] < 1.110223024E-16) {
            dArray8[0] = dArray[0];
            dArray8[1] = dArray[1];
            dArray8[2] = dArray[2];
            dArray[0] = dArray[3];
            dArray[1] = dArray[4];
            dArray[2] = dArray[5];
            dArray[3] = -dArray8[0];
            dArray[4] = -dArray8[1];
            dArray[5] = -dArray8[2];
            dArray4[0] = 0.0;
            dArray4[1] = 1.0;
            dArray4[2] = 0.0;
            dArray4[3] = -1.0;
            dArray4[4] = 0.0;
            dArray4[5] = 0.0;
            dArray4[6] = 0.0;
            dArray4[7] = 0.0;
            dArray4[8] = 1.0;
        } else {
            d = 1.0 / Matrix3d.\u84fc("\u7aaf", (double)(dArray[0] * dArray[0] + dArray[3] * dArray[3]));
            double d2 = dArray[0] * d;
            double d3 = dArray[3] * d;
            dArray8[0] = d2 * dArray[0] + d3 * dArray[3];
            dArray8[1] = d2 * dArray[1] + d3 * dArray[4];
            dArray8[2] = d2 * dArray[2] + d3 * dArray[5];
            dArray[3] = -d3 * dArray[0] + d2 * dArray[3];
            dArray[4] = -d3 * dArray[1] + d2 * dArray[4];
            dArray[5] = -d3 * dArray[2] + d2 * dArray[5];
            dArray[0] = dArray8[0];
            dArray[1] = dArray8[1];
            dArray[2] = dArray8[2];
            dArray4[0] = d2;
            dArray4[1] = d3;
            dArray4[2] = 0.0;
            dArray4[3] = -d3;
            dArray4[4] = d2;
            dArray4[5] = 0.0;
            dArray4[6] = 0.0;
            dArray4[7] = 0.0;
            dArray4[8] = 1.0;
        }
        if (!(dArray[6] * dArray[6] < 1.110223024E-16)) {
            if (dArray[0] * dArray[0] < 1.110223024E-16) {
                dArray8[0] = dArray[0];
                dArray8[1] = dArray[1];
                dArray8[2] = dArray[2];
                dArray[0] = dArray[6];
                dArray[1] = dArray[7];
                dArray[2] = dArray[8];
                dArray[6] = -dArray8[0];
                dArray[7] = -dArray8[1];
                dArray[8] = -dArray8[2];
                dArray8[0] = dArray4[0];
                dArray8[1] = dArray4[1];
                dArray8[2] = dArray4[2];
                dArray4[0] = dArray4[6];
                dArray4[1] = dArray4[7];
                dArray4[2] = dArray4[8];
                dArray4[6] = -dArray8[0];
                dArray4[7] = -dArray8[1];
                dArray4[8] = -dArray8[2];
            } else {
                d = 1.0 / Matrix3d.\u84fc("\u7aaf", (double)(dArray[0] * dArray[0] + dArray[6] * dArray[6]));
                double d4 = dArray[0] * d;
                double d5 = dArray[6] * d;
                dArray8[0] = d4 * dArray[0] + d5 * dArray[6];
                dArray8[1] = d4 * dArray[1] + d5 * dArray[7];
                dArray8[2] = d4 * dArray[2] + d5 * dArray[8];
                dArray[6] = -d5 * dArray[0] + d4 * dArray[6];
                dArray[7] = -d5 * dArray[1] + d4 * dArray[7];
                dArray[8] = -d5 * dArray[2] + d4 * dArray[8];
                dArray[0] = dArray8[0];
                dArray[1] = dArray8[1];
                dArray[2] = dArray8[2];
                dArray8[0] = d4 * dArray4[0];
                dArray8[1] = d4 * dArray4[1];
                dArray4[2] = d5;
                dArray8[6] = -dArray4[0] * d5;
                dArray8[7] = -dArray4[1] * d5;
                dArray4[8] = d4;
                dArray4[0] = dArray8[0];
                dArray4[1] = dArray8[1];
                dArray4[6] = dArray8[6];
                dArray4[7] = dArray8[7];
            }
        }
        if (dArray[2] * dArray[2] < 1.110223024E-16) {
            dArray5[0] = 1.0;
            dArray5[1] = 0.0;
            dArray5[2] = 0.0;
            dArray5[3] = 0.0;
            dArray5[4] = 1.0;
            dArray5[5] = 0.0;
            dArray5[6] = 0.0;
            dArray5[7] = 0.0;
            dArray5[8] = 1.0;
        } else if (dArray[1] * dArray[1] < 1.110223024E-16) {
            dArray8[2] = dArray[2];
            dArray8[5] = dArray[5];
            dArray8[8] = dArray[8];
            dArray[2] = -dArray[1];
            dArray[5] = -dArray[4];
            dArray[8] = -dArray[7];
            dArray[1] = dArray8[2];
            dArray[4] = dArray8[5];
            dArray[7] = dArray8[8];
            dArray5[0] = 1.0;
            dArray5[1] = 0.0;
            dArray5[2] = 0.0;
            dArray5[3] = 0.0;
            dArray5[4] = 0.0;
            dArray5[5] = -1.0;
            dArray5[6] = 0.0;
            dArray5[7] = 1.0;
            dArray5[8] = 0.0;
        } else {
            d = 1.0 / Matrix3d.\u84fc("\u7aaf", (double)(dArray[1] * dArray[1] + dArray[2] * dArray[2]));
            double d6 = dArray[1] * d;
            double d7 = dArray[2] * d;
            dArray8[1] = d6 * dArray[1] + d7 * dArray[2];
            dArray[2] = -d7 * dArray[1] + d6 * dArray[2];
            dArray[1] = dArray8[1];
            dArray8[4] = d6 * dArray[4] + d7 * dArray[5];
            dArray[5] = -d7 * dArray[4] + d6 * dArray[5];
            dArray[4] = dArray8[4];
            dArray8[7] = d6 * dArray[7] + d7 * dArray[8];
            dArray[8] = -d7 * dArray[7] + d6 * dArray[8];
            dArray[7] = dArray8[7];
            dArray5[0] = 1.0;
            dArray5[1] = 0.0;
            dArray5[2] = 0.0;
            dArray5[3] = 0.0;
            dArray5[4] = d6;
            dArray5[5] = -d7;
            dArray5[6] = 0.0;
            dArray5[7] = d7;
            dArray5[8] = d6;
        }
        if (!(dArray[7] * dArray[7] < 1.110223024E-16)) {
            if (dArray[4] * dArray[4] < 1.110223024E-16) {
                dArray8[3] = dArray[3];
                dArray8[4] = dArray[4];
                dArray8[5] = dArray[5];
                dArray[3] = dArray[6];
                dArray[4] = dArray[7];
                dArray[5] = dArray[8];
                dArray[6] = -dArray8[3];
                dArray[7] = -dArray8[4];
                dArray[8] = -dArray8[5];
                dArray8[3] = dArray4[3];
                dArray8[4] = dArray4[4];
                dArray8[5] = dArray4[5];
                dArray4[3] = dArray4[6];
                dArray4[4] = dArray4[7];
                dArray4[5] = dArray4[8];
                dArray4[6] = -dArray8[3];
                dArray4[7] = -dArray8[4];
                dArray4[8] = -dArray8[5];
            } else {
                d = 1.0 / Matrix3d.\u84fc("\u7aaf", (double)(dArray[4] * dArray[4] + dArray[7] * dArray[7]));
                double d8 = dArray[4] * d;
                double d9 = dArray[7] * d;
                dArray8[3] = d8 * dArray[3] + d9 * dArray[6];
                dArray[6] = -d9 * dArray[3] + d8 * dArray[6];
                dArray[3] = dArray8[3];
                dArray8[4] = d8 * dArray[4] + d9 * dArray[7];
                dArray[7] = -d9 * dArray[4] + d8 * dArray[7];
                dArray[4] = dArray8[4];
                dArray8[5] = d8 * dArray[5] + d9 * dArray[8];
                dArray[8] = -d9 * dArray[5] + d8 * dArray[8];
                dArray[5] = dArray8[5];
                dArray8[3] = d8 * dArray4[3] + d9 * dArray4[6];
                dArray4[6] = -d9 * dArray4[3] + d8 * dArray4[6];
                dArray4[3] = dArray8[3];
                dArray8[4] = d8 * dArray4[4] + d9 * dArray4[7];
                dArray4[7] = -d9 * dArray4[4] + d8 * dArray4[7];
                dArray4[4] = dArray8[4];
                dArray8[5] = d8 * dArray4[5] + d9 * dArray4[8];
                dArray4[8] = -d9 * dArray4[5] + d8 * dArray4[8];
                dArray4[5] = dArray8[5];
            }
        }
        dArray9[0] = dArray[0];
        dArray9[1] = dArray[4];
        dArray9[2] = dArray[8];
        dArray11[0] = dArray[1];
        dArray11[1] = dArray[5];
        if (!(dArray11[0] * dArray11[0] < 1.110223024E-16) || !(dArray11[1] * dArray11[1] < 1.110223024E-16)) {
            Matrix3d.compute_qr(dArray9, dArray11, dArray4, dArray5);
        }
        dArray12[0] = dArray9[0];
        dArray12[1] = dArray9[1];
        dArray12[2] = dArray9[2];
        if (Matrix3d.almostEqual((double)Matrix3d.\u63a8("\u6a9c", (double)dArray12[0]), 1.0) && Matrix3d.almostEqual((double)Matrix3d.\u63a8("\u6a9c", (double)dArray12[1]), 1.0) && Matrix3d.almostEqual((double)Matrix3d.\u63a8("\u6a9c", (double)dArray12[2]), 1.0)) {
            for (n = 0; n < 3; ++n) {
                if (!(dArray12[n] < 0.0)) continue;
                ++n2;
            }
            if (n2 == 0 || n2 == 2) {
                dArray2[2] = 1.0;
                dArray2[1] = 1.0;
                dArray2[0] = 1.0;
                for (n = 0; n < 9; ++n) {
                    dArray3[n] = dArray10[n];
                }
                return;
            }
        }
        Matrix3d.transpose_mat(dArray4, dArray6);
        Matrix3d.transpose_mat(dArray5, dArray7);
        Matrix3d.svdReorder(dArray, dArray6, dArray7, dArray12, dArray3, dArray2);
    }

    static void svdReorder(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) {
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        double[] dArray7 = new double[3];
        double[] dArray8 = new double[9];
        if (dArray4[0] < 0.0) {
            dArray4[0] = -dArray4[0];
            dArray3[0] = -dArray3[0];
            dArray3[1] = -dArray3[1];
            dArray3[2] = -dArray3[2];
        }
        if (dArray4[1] < 0.0) {
            dArray4[1] = -dArray4[1];
            dArray3[3] = -dArray3[3];
            dArray3[4] = -dArray3[4];
            dArray3[5] = -dArray3[5];
        }
        if (dArray4[2] < 0.0) {
            dArray4[2] = -dArray4[2];
            dArray3[6] = -dArray3[6];
            dArray3[7] = -dArray3[7];
            dArray3[8] = -dArray3[8];
        }
        Matrix3d.mat_mul(dArray2, dArray3, dArray8);
        if (Matrix3d.almostEqual((double)Matrix3d.\u63a8("\u6a9c", (double)dArray4[0]), (double)Matrix3d.\u63a8("\u6a9c", (double)dArray4[1])) && Matrix3d.almostEqual((double)Matrix3d.\u63a8("\u6a9c", (double)dArray4[1]), (double)Matrix3d.\u63a8("\u6a9c", (double)dArray4[2]))) {
            int n;
            for (n = 0; n < 9; ++n) {
                dArray5[n] = dArray8[n];
            }
            for (n = 0; n < 3; ++n) {
                dArray6[n] = dArray4[n];
            }
        } else {
            int n;
            int n2;
            int n3;
            if (dArray4[0] > dArray4[1]) {
                if (dArray4[0] > dArray4[2]) {
                    if (dArray4[2] > dArray4[1]) {
                        nArray[0] = 0;
                        nArray[1] = 2;
                        nArray[2] = 1;
                    } else {
                        nArray[0] = 0;
                        nArray[1] = 1;
                        nArray[2] = 2;
                    }
                } else {
                    nArray[0] = 2;
                    nArray[1] = 0;
                    nArray[2] = 1;
                }
            } else if (dArray4[1] > dArray4[2]) {
                if (dArray4[2] > dArray4[0]) {
                    nArray[0] = 1;
                    nArray[1] = 2;
                    nArray[2] = 0;
                } else {
                    nArray[0] = 1;
                    nArray[1] = 0;
                    nArray[2] = 2;
                }
            } else {
                nArray[0] = 2;
                nArray[1] = 1;
                nArray[2] = 0;
            }
            dArray7[0] = dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2];
            dArray7[1] = dArray[3] * dArray[3] + dArray[4] * dArray[4] + dArray[5] * dArray[5];
            dArray7[2] = dArray[6] * dArray[6] + dArray[7] * dArray[7] + dArray[8] * dArray[8];
            if (dArray7[0] > dArray7[1]) {
                if (dArray7[0] > dArray7[2]) {
                    if (dArray7[2] > dArray7[1]) {
                        n3 = 0;
                        n2 = 1;
                        n = 2;
                    } else {
                        n3 = 0;
                        n = 1;
                        n2 = 2;
                    }
                } else {
                    n2 = 0;
                    n3 = 1;
                    n = 2;
                }
            } else if (dArray7[1] > dArray7[2]) {
                if (dArray7[2] > dArray7[0]) {
                    n = 0;
                    n2 = 1;
                    n3 = 2;
                } else {
                    n = 0;
                    n3 = 1;
                    n2 = 2;
                }
            } else {
                n2 = 0;
                n = 1;
                n3 = 2;
            }
            int n4 = nArray[n3];
            dArray6[0] = dArray4[n4];
            n4 = nArray[n];
            dArray6[1] = dArray4[n4];
            n4 = nArray[n2];
            dArray6[2] = dArray4[n4];
            n4 = nArray[n3];
            dArray5[0] = dArray8[n4];
            n4 = nArray[n3] + 3;
            dArray5[3] = dArray8[n4];
            n4 = nArray[n3] + 6;
            dArray5[6] = dArray8[n4];
            n4 = nArray[n];
            dArray5[1] = dArray8[n4];
            n4 = nArray[n] + 3;
            dArray5[4] = dArray8[n4];
            n4 = nArray[n] + 6;
            dArray5[7] = dArray8[n4];
            n4 = nArray[n2];
            dArray5[2] = dArray8[n4];
            n4 = nArray[n2] + 3;
            dArray5[5] = dArray8[n4];
            n4 = nArray[n2] + 6;
            dArray5[8] = dArray8[n4];
        }
    }

    static int compute_qr(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        double d;
        double d2;
        double[] dArray5 = new double[2];
        double[] dArray6 = new double[2];
        double[] dArray7 = new double[2];
        double[] dArray8 = new double[2];
        double[] dArray9 = new double[9];
        int n = 10;
        double d3 = 4.89E-15;
        double d4 = 1.0;
        double d5 = -1.0;
        boolean bl = false;
        int n2 = 1;
        if (Matrix3d.\u63a8("\u6a9c", (double)dArray2[1]) < 4.89E-15 || Matrix3d.\u63a8("\u6a9c", (double)dArray2[0]) < 4.89E-15) {
            bl = true;
        }
        for (int i = 0; i < 10 && !bl; ++i) {
            double d6 = Matrix3d.compute_shift(dArray[1], dArray2[1], dArray[2]);
            Object object = (Matrix3d.\u63a8("\u6a9c", (double)dArray[0]) - d6) * (Matrix3d.d_sign(d4, dArray[0]) + d6 / dArray[0]);
            double d7 = dArray2[0];
            double d8 = Matrix3d.compute_rot((double)object, d7, dArray8, dArray6, 0, n2);
            object = dArray6[0] * dArray[0] + dArray8[0] * dArray2[0];
            dArray2[0] = dArray6[0] * dArray2[0] - dArray8[0] * dArray[0];
            d7 = dArray8[0] * dArray[1];
            dArray[1] = dArray6[0] * dArray[1];
            d8 = Matrix3d.compute_rot((double)object, d7, dArray7, dArray5, 0, n2);
            n2 = 0;
            dArray[0] = d8;
            object = dArray5[0] * dArray2[0] + dArray7[0] * dArray[1];
            dArray[1] = dArray5[0] * dArray[1] - dArray7[0] * dArray2[0];
            d7 = dArray7[0] * dArray2[1];
            dArray2[1] = dArray5[0] * dArray2[1];
            dArray2[0] = d8 = Matrix3d.compute_rot((double)object, d7, dArray8, dArray6, 1, n2);
            object = dArray6[1] * dArray[1] + dArray8[1] * dArray2[1];
            dArray2[1] = dArray6[1] * dArray2[1] - dArray8[1] * dArray[1];
            d7 = dArray8[1] * dArray[2];
            dArray[2] = dArray6[1] * dArray[2];
            dArray[1] = d8 = Matrix3d.compute_rot((double)object, d7, dArray7, dArray5, 1, n2);
            object = dArray5[1] * dArray2[1] + dArray7[1] * dArray[2];
            dArray[2] = dArray5[1] * dArray[2] - dArray7[1] * dArray2[1];
            dArray2[1] = (double)object;
            d2 = dArray3[0];
            dArray3[0] = dArray5[0] * d2 + dArray7[0] * dArray3[3];
            dArray3[3] = -dArray7[0] * d2 + dArray5[0] * dArray3[3];
            d2 = dArray3[1];
            dArray3[1] = dArray5[0] * d2 + dArray7[0] * dArray3[4];
            dArray3[4] = -dArray7[0] * d2 + dArray5[0] * dArray3[4];
            d2 = dArray3[2];
            dArray3[2] = dArray5[0] * d2 + dArray7[0] * dArray3[5];
            dArray3[5] = -dArray7[0] * d2 + dArray5[0] * dArray3[5];
            d2 = dArray3[3];
            dArray3[3] = dArray5[1] * d2 + dArray7[1] * dArray3[6];
            dArray3[6] = -dArray7[1] * d2 + dArray5[1] * dArray3[6];
            d2 = dArray3[4];
            dArray3[4] = dArray5[1] * d2 + dArray7[1] * dArray3[7];
            dArray3[7] = -dArray7[1] * d2 + dArray5[1] * dArray3[7];
            d2 = dArray3[5];
            dArray3[5] = dArray5[1] * d2 + dArray7[1] * dArray3[8];
            dArray3[8] = -dArray7[1] * d2 + dArray5[1] * dArray3[8];
            d = dArray4[0];
            dArray4[0] = dArray6[0] * d + dArray8[0] * dArray4[1];
            dArray4[1] = -dArray8[0] * d + dArray6[0] * dArray4[1];
            d = dArray4[3];
            dArray4[3] = dArray6[0] * d + dArray8[0] * dArray4[4];
            dArray4[4] = -dArray8[0] * d + dArray6[0] * dArray4[4];
            d = dArray4[6];
            dArray4[6] = dArray6[0] * d + dArray8[0] * dArray4[7];
            dArray4[7] = -dArray8[0] * d + dArray6[0] * dArray4[7];
            d = dArray4[1];
            dArray4[1] = dArray6[1] * d + dArray8[1] * dArray4[2];
            dArray4[2] = -dArray8[1] * d + dArray6[1] * dArray4[2];
            d = dArray4[4];
            dArray4[4] = dArray6[1] * d + dArray8[1] * dArray4[5];
            dArray4[5] = -dArray8[1] * d + dArray6[1] * dArray4[5];
            d = dArray4[7];
            dArray4[7] = dArray6[1] * d + dArray8[1] * dArray4[8];
            dArray4[8] = -dArray8[1] * d + dArray6[1] * dArray4[8];
            dArray9[0] = dArray[0];
            dArray9[1] = dArray2[0];
            dArray9[2] = 0.0;
            dArray9[3] = 0.0;
            dArray9[4] = dArray[1];
            dArray9[5] = dArray2[1];
            dArray9[6] = 0.0;
            dArray9[7] = 0.0;
            dArray9[8] = dArray[2];
            if (!(Matrix3d.\u63a8("\u6a9c", (double)dArray2[1]) < 4.89E-15) && !(Matrix3d.\u63a8("\u6a9c", (double)dArray2[0]) < 4.89E-15)) continue;
            bl = true;
        }
        if (Matrix3d.\u63a8("\u6a9c", (double)dArray2[1]) < 4.89E-15) {
            Matrix3d.compute_2X2(dArray[0], dArray2[0], dArray[1], dArray, dArray7, dArray5, dArray8, dArray6, 0);
            d2 = dArray3[0];
            dArray3[0] = dArray5[0] * d2 + dArray7[0] * dArray3[3];
            dArray3[3] = -dArray7[0] * d2 + dArray5[0] * dArray3[3];
            d2 = dArray3[1];
            dArray3[1] = dArray5[0] * d2 + dArray7[0] * dArray3[4];
            dArray3[4] = -dArray7[0] * d2 + dArray5[0] * dArray3[4];
            d2 = dArray3[2];
            dArray3[2] = dArray5[0] * d2 + dArray7[0] * dArray3[5];
            dArray3[5] = -dArray7[0] * d2 + dArray5[0] * dArray3[5];
            d = dArray4[0];
            dArray4[0] = dArray6[0] * d + dArray8[0] * dArray4[1];
            dArray4[1] = -dArray8[0] * d + dArray6[0] * dArray4[1];
            d = dArray4[3];
            dArray4[3] = dArray6[0] * d + dArray8[0] * dArray4[4];
            dArray4[4] = -dArray8[0] * d + dArray6[0] * dArray4[4];
            d = dArray4[6];
            dArray4[6] = dArray6[0] * d + dArray8[0] * dArray4[7];
            dArray4[7] = -dArray8[0] * d + dArray6[0] * dArray4[7];
        } else {
            Matrix3d.compute_2X2(dArray[1], dArray2[1], dArray[2], dArray, dArray7, dArray5, dArray8, dArray6, 1);
            d2 = dArray3[3];
            dArray3[3] = dArray5[0] * d2 + dArray7[0] * dArray3[6];
            dArray3[6] = -dArray7[0] * d2 + dArray5[0] * dArray3[6];
            d2 = dArray3[4];
            dArray3[4] = dArray5[0] * d2 + dArray7[0] * dArray3[7];
            dArray3[7] = -dArray7[0] * d2 + dArray5[0] * dArray3[7];
            d2 = dArray3[5];
            dArray3[5] = dArray5[0] * d2 + dArray7[0] * dArray3[8];
            dArray3[8] = -dArray7[0] * d2 + dArray5[0] * dArray3[8];
            d = dArray4[1];
            dArray4[1] = dArray6[0] * d + dArray8[0] * dArray4[2];
            dArray4[2] = -dArray8[0] * d + dArray6[0] * dArray4[2];
            d = dArray4[4];
            dArray4[4] = dArray6[0] * d + dArray8[0] * dArray4[5];
            dArray4[5] = -dArray8[0] * d + dArray6[0] * dArray4[5];
            d = dArray4[7];
            dArray4[7] = dArray6[0] * d + dArray8[0] * dArray4[8];
            dArray4[8] = -dArray8[0] * d + dArray6[0] * dArray4[8];
        }
        return 0;
    }

    static double max(double d, double d2) {
        if (d > d2) {
            return d;
        }
        return d2;
    }

    static double min(double d, double d2) {
        if (d < d2) {
            return d;
        }
        return d2;
    }

    static double d_sign(double d, double d2) {
        double d3 = d >= 0.0 ? d : -d;
        return d2 >= 0.0 ? d3 : -d3;
    }

    static double compute_shift(double d, double d2, double d3) {
        double d4;
        Object object = Matrix3d.\u63a8("\u6a9c", (double)d);
        Object object2 = Matrix3d.\u63a8("\u6a9c", (double)d2);
        Object object3 = Matrix3d.\u63a8("\u6a9c", (double)d3);
        double d5 = Matrix3d.min((double)object, (double)object3);
        double d6 = Matrix3d.max((double)object, (double)object3);
        if (d5 == 0.0) {
            d4 = 0.0;
            if (d6 != 0.0) {
                double d7 = Matrix3d.min(d6, (double)object2) / Matrix3d.max(d6, (double)object2);
            }
        } else if (object2 < d6) {
            double d8 = d5 / d6 + 1.0;
            double d9 = (d6 - d5) / d6;
            reference var6_10 = object2 / d6;
            reference var26_16 = var6_10 * var6_10;
            double d10 = 2.0 / (Matrix3d.\u84fc("\u7aaf", (double)(d8 * d8 + var26_16)) + Matrix3d.\u84fc("\u7aaf", (double)(d9 * d9 + var26_16)));
            d4 = d5 * d10;
        } else {
            double d11 = d6 / object2;
            if (d11 == 0.0) {
                d4 = d5 * d6 / object2;
            } else {
                double d12 = d5 / d6 + 1.0;
                double d13 = (d6 - d5) / d6;
                double d14 = d12 * d11;
                double d15 = d13 * d11;
                double d16 = 1.0 / (Matrix3d.\u84fc("\u7aaf", (double)(d14 * d14 + 1.0)) + Matrix3d.\u84fc("\u7aaf", (double)(d15 * d15 + 1.0)));
                d4 = d5 * d16 * d11;
                d4 += d4;
            }
        }
        return d4;
    }

    static int compute_2X2(double d, double d2, double d3, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, int n) {
        double d4;
        Object object;
        double d5 = 2.0;
        double d6 = 1.0;
        Object object2 = dArray[0];
        Object object3 = dArray[1];
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = d;
        Object object4 = Matrix3d.\u63a8("\u6a9c", (double)d12);
        double d13 = d3;
        Object object5 = Matrix3d.\u63a8("\u6a9c", (double)d3);
        int n2 = 1;
        boolean bl = object5 > object4;
        if (bl) {
            n2 = 3;
            Object object6 = d12;
            d12 = d13;
            d13 = object6;
            object6 = object4;
            object4 = object5;
            object5 = object6;
        }
        if ((object = Matrix3d.\u63a8("\u6a9c", (double)(d4 = d2))) == 0.0) {
            dArray[1] = (double)object5;
            dArray[0] = (double)object4;
            d7 = 1.0;
            d8 = 1.0;
            d9 = 0.0;
            d10 = 0.0;
        } else {
            boolean bl2 = true;
            if (object > object4) {
                n2 = 2;
                if (object4 / object < 1.110223024E-16) {
                    bl2 = false;
                    object2 = object;
                    object3 = object5 > 1.0 ? (Object)(object4 / (object / object5)) : (Object)(object4 / object * object5);
                    d7 = 1.0;
                    d9 = d13 / d4;
                    d10 = 1.0;
                    d8 = d12 / d4;
                }
            }
            if (bl2) {
                reference var24_28 = object4 - object5;
                Object object7 = var24_28 == object4 ? 1.0 : (Object)(var24_28 / object4);
                double d14 = d4 / d12;
                double d15 = 2.0 - object7;
                double d16 = d14 * d14;
                double d17 = d15 * d15;
                Object object8 = Matrix3d.\u84fc("\u7aaf", (double)(d17 + d16));
                Object object9 = object7 == 0.0 ? Matrix3d.\u63a8("\u6a9c", (double)d14) : Matrix3d.\u84fc("\u7aaf", (double)(object7 * object7 + d16));
                reference var22_36 = (object8 + object9) * 0.5;
                if (object > object4) {
                    n2 = 2;
                    if (object4 / object < 1.110223024E-16) {
                        bl2 = false;
                        object2 = object;
                        object3 = object5 > 1.0 ? (Object)(object4 / (object / object5)) : (Object)(object4 / object * object5);
                        d7 = 1.0;
                        d9 = d13 / d4;
                        d10 = 1.0;
                        d8 = d12 / d4;
                    }
                }
                if (bl2) {
                    var24_28 = object4 - object5;
                    object7 = var24_28 == object4 ? 1.0 : (Object)(var24_28 / object4);
                    d14 = d4 / d12;
                    d15 = 2.0 - object7;
                    d16 = d14 * d14;
                    d17 = d15 * d15;
                    object8 = Matrix3d.\u84fc("\u7aaf", (double)(d17 + d16));
                    object9 = object7 == 0.0 ? Matrix3d.\u63a8("\u6a9c", (double)d14) : Matrix3d.\u84fc("\u7aaf", (double)(object7 * object7 + d16));
                    var22_36 = (object8 + object9) * 0.5;
                    object3 = object5 / var22_36;
                    object2 = object4 * var22_36;
                    d15 = d16 == 0.0 ? (object7 == 0.0 ? Matrix3d.d_sign(d5, d12) * Matrix3d.d_sign(d6, d4) : d4 / Matrix3d.d_sign((double)var24_28, d12) + d14 / d15) : (d14 / (object8 + d15) + d14 / (object9 + object7)) * (var22_36 + 1.0);
                    object7 = Matrix3d.\u84fc("\u7aaf", (double)(d15 * d15 + 4.0));
                    d8 = 2.0 / object7;
                    d10 = d15 / object7;
                    d7 = (d8 + d10 * d14) / var22_36;
                    d9 = d13 / d12 * d10 / var22_36;
                }
            }
            if (bl) {
                dArray3[0] = d10;
                dArray2[0] = d8;
                dArray5[0] = d9;
                dArray4[0] = d7;
            } else {
                dArray3[0] = d7;
                dArray2[0] = d9;
                dArray5[0] = d8;
                dArray4[0] = d10;
            }
            if (n2 == 1) {
                d11 = Matrix3d.d_sign(d6, dArray5[0]) * Matrix3d.d_sign(d6, dArray3[0]) * Matrix3d.d_sign(d6, d);
            }
            if (n2 == 2) {
                d11 = Matrix3d.d_sign(d6, dArray4[0]) * Matrix3d.d_sign(d6, dArray3[0]) * Matrix3d.d_sign(d6, d2);
            }
            if (n2 == 3) {
                d11 = Matrix3d.d_sign(d6, dArray4[0]) * Matrix3d.d_sign(d6, dArray2[0]) * Matrix3d.d_sign(d6, d3);
            }
            dArray[n] = Matrix3d.d_sign(object2, d11);
            double d18 = d11 * Matrix3d.d_sign(d6, d) * Matrix3d.d_sign(d6, d3);
            dArray[n + 1] = Matrix3d.d_sign(object3, d18);
        }
        return 0;
    }

    static double compute_rot(double d, double d2, double[] dArray, double[] dArray2, int n, int n2) {
        double d3;
        double d4;
        double d5;
        double d6 = 2.002083095183101E-146;
        double d7 = 4.994797680505588E145;
        if (d2 == 0.0) {
            d5 = 1.0;
            d4 = 0.0;
            d3 = d;
        } else if (d == 0.0) {
            d5 = 0.0;
            d4 = 1.0;
            d3 = d2;
        } else {
            double d8 = d;
            double d9 = d2;
            double d10 = Matrix3d.max((double)Matrix3d.\u63a8("\u6a9c", (double)d8), (double)Matrix3d.\u63a8("\u6a9c", (double)d9));
            if (d10 >= 4.994797680505588E145) {
                int n3 = 0;
                while (d10 >= 4.994797680505588E145) {
                    ++n3;
                    d10 = Matrix3d.max((double)Matrix3d.\u63a8("\u6a9c", (double)(d8 *= 2.002083095183101E-146)), (double)Matrix3d.\u63a8("\u6a9c", (double)(d9 *= 2.002083095183101E-146)));
                }
                d3 = (double)Matrix3d.\u84fc("\u7aaf", (double)(d8 * d8 + d9 * d9));
                d5 = d8 / d3;
                d4 = d9 / d3;
                int n4 = n3;
                for (int i = 1; i <= n3; ++i) {
                    d3 *= 4.994797680505588E145;
                }
            } else if (d10 <= 2.002083095183101E-146) {
                int n5 = 0;
                while (d10 <= 2.002083095183101E-146) {
                    ++n5;
                    d10 = Matrix3d.max((double)Matrix3d.\u63a8("\u6a9c", (double)(d8 *= 4.994797680505588E145)), (double)Matrix3d.\u63a8("\u6a9c", (double)(d9 *= 4.994797680505588E145)));
                }
                d3 = (double)Matrix3d.\u84fc("\u7aaf", (double)(d8 * d8 + d9 * d9));
                d5 = d8 / d3;
                d4 = d9 / d3;
                int n6 = n5;
                for (int i = 1; i <= n5; ++i) {
                    d3 *= 2.002083095183101E-146;
                }
            } else {
                d3 = (double)Matrix3d.\u84fc("\u7aaf", (double)(d8 * d8 + d9 * d9));
                d5 = d8 / d3;
                d4 = d9 / d3;
            }
            if (Matrix3d.\u63a8("\u6a9c", (double)d) > Matrix3d.\u63a8("\u6a9c", (double)d2) && d5 < 0.0) {
                d5 = -d5;
                d4 = -d4;
                d3 = -d3;
            }
        }
        dArray[n] = d4;
        dArray2[n] = d5;
        return d3;
    }

    static void print_mat(double[] dArray) {
        for (int i = 0; i < 3; ++i) {
            Matrix3d.\ucb09("\uc860", (PrintStream)System.out, (String)Matrix3d.j("\u3f36", (StringBuilder)Matrix3d.\ud028("\u2ca9", (StringBuilder)Matrix3d.\u4079("\u9205", (StringBuilder)Matrix3d.\ud028("\u2ca9", (StringBuilder)Matrix3d.\u4079("\u9205", (StringBuilder)Matrix3d.\ud028("\u2ca9", (StringBuilder)Matrix3d.\u4079("\u9205", (StringBuilder)new StringBuilder(), (double)dArray[i * 3 + 0]), (String)Vector3f$Matrix3d.\u9c53("\u9814")), (double)dArray[i * 3 + 1]), (String)Vector3f$Matrix3d.\u9c53("\u9814")), (double)dArray[i * 3 + 2]), (String)Vector3f$Matrix3d.\u9c53("\u983e"))));
        }
    }

    static void print_det(double[] dArray) {
        double d = dArray[0] * dArray[4] * dArray[8] + dArray[1] * dArray[5] * dArray[6] + dArray[2] * dArray[3] * dArray[7] - dArray[2] * dArray[4] * dArray[6] - dArray[0] * dArray[5] * dArray[7] - dArray[1] * dArray[3] * dArray[8];
        Matrix3d.\ucb09("\uc860", (PrintStream)System.out, (String)Matrix3d.j("\u3f36", (StringBuilder)Matrix3d.\u4079("\u9205", (StringBuilder)Matrix3d.\ud028("\u2ca9", (StringBuilder)new StringBuilder(), (String)Matrix3f$Matrix3d.\u610c("\u122c\ua574\u7ee0\u8ebb\u1db7")), (double)d)));
    }

    static void mat_mul(double[] dArray, double[] dArray2, double[] dArray3) {
        double[] dArray4 = new double[]{dArray[0] * dArray2[0] + dArray[1] * dArray2[3] + dArray[2] * dArray2[6], dArray[0] * dArray2[1] + dArray[1] * dArray2[4] + dArray[2] * dArray2[7], dArray[0] * dArray2[2] + dArray[1] * dArray2[5] + dArray[2] * dArray2[8], dArray[3] * dArray2[0] + dArray[4] * dArray2[3] + dArray[5] * dArray2[6], dArray[3] * dArray2[1] + dArray[4] * dArray2[4] + dArray[5] * dArray2[7], dArray[3] * dArray2[2] + dArray[4] * dArray2[5] + dArray[5] * dArray2[8], dArray[6] * dArray2[0] + dArray[7] * dArray2[3] + dArray[8] * dArray2[6], dArray[6] * dArray2[1] + dArray[7] * dArray2[4] + dArray[8] * dArray2[7], dArray[6] * dArray2[2] + dArray[7] * dArray2[5] + dArray[8] * dArray2[8]};
        for (int i = 0; i < 9; ++i) {
            dArray3[i] = dArray4[i];
        }
    }

    static void transpose_mat(double[] dArray, double[] dArray2) {
        dArray2[0] = dArray[0];
        dArray2[1] = dArray[3];
        dArray2[2] = dArray[6];
        dArray2[3] = dArray[1];
        dArray2[4] = dArray[4];
        dArray2[5] = dArray[7];
        dArray2[6] = dArray[2];
        dArray2[7] = dArray[5];
        dArray2[8] = dArray[8];
    }

    static double max3(double[] dArray) {
        if (dArray[0] > dArray[1]) {
            if (dArray[0] > dArray[2]) {
                return dArray[0];
            }
            return dArray[2];
        }
        if (dArray[1] > dArray[2]) {
            return dArray[1];
        }
        return dArray[2];
    }

    private static final boolean almostEqual(double d, double d2) {
        Object object;
        Object object2;
        if (d == d2) {
            return true;
        }
        double d3 = 1.0E-6;
        double d4 = 1.0E-4;
        Object object3 = Matrix3d.\u63a8("\u6a9c", (double)(d - d2));
        Object object4 = Matrix3d.\u63a8("\u6a9c", (double)d);
        Object object5 = object2 = object4 >= (object = Matrix3d.\u63a8("\u6a9c", (double)d2)) ? object4 : object;
        if (object3 < 1.0E-6) {
            return true;
        }
        return object3 / object2 < 1.0E-4;
    }

    public Object clone() {
        Matrix3d matrix3d = null;
        try {
            matrix3d = (Matrix3d)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return matrix3d;
    }

    public final double getM00() {
        return this.m00;
    }

    public final void setM00(double d) {
        this.m00 = d;
    }

    public final double getM01() {
        return this.m01;
    }

    public final void setM01(double d) {
        this.m01 = d;
    }

    public final double getM02() {
        return this.m02;
    }

    public final void setM02(double d) {
        this.m02 = d;
    }

    public final double getM10() {
        return this.m10;
    }

    public final void setM10(double d) {
        this.m10 = d;
    }

    public final double getM11() {
        return this.m11;
    }

    public final void setM11(double d) {
        this.m11 = d;
    }

    public final double getM12() {
        return this.m12;
    }

    public final void setM12(double d) {
        this.m12 = d;
    }

    public final double getM20() {
        return this.m20;
    }

    public final void setM20(double d) {
        this.m20 = d;
    }

    public final double getM21() {
        return this.m21;
    }

    public final void setM21(double d) {
        this.m21 = d;
    }

    public final double getM22() {
        return this.m22;
    }

    public final void setM22(double d) {
        this.m22 = d;
    }

    private static Object \u4079(Object object, String string, MethodType methodType) {
        if (\uc717 == null) {
            \uc717 = new Object[9];
        }
        if (\uc717[1] == null) {
            Matrix3d.\uc717[1] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(AxisAngle4f$Matrix4f.\ufb61("\u363a\u2566\u5531\uf3d4\u8aea\u9a6f\ud755\u4c92\u3057\u3b76\u2d0c\u27d6\ud2d2\uc9aa\u9076\u99e1\ueed4\uf1e0\u1f68\u1d47\ua2ce\u0840\u6bac")), AxisAngle4f$Matrix4f.\ufb61("\u3631\u2577\u5537\uf3d0\u8aaa\u9a67"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \uc717[1];
    }

    private static Object j(Object object, String string, MethodType methodType) {
        if (\uc717 == null) {
            \uc717 = new Object[9];
        }
        if (\uc717[2] == null) {
            Matrix3d.\uc717[2] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(AxisAngle4f$Matrix4f.\ufb61("\u363a\u2566\u5531\uf3d4\u8aea\u9a6f\ud755\u4c92\u3057\u3b76\u2d0c\u27d6\ud2d2\uc9aa\u9076\u99e1\ueed4\uf1e0\u1f68\u1d47\ua2ce\u0840\u6bac")), AxisAngle4f$Matrix4f.\ufb61("\u3624\u2568\u5514\uf3c1\u8ab6\u9a6a\ud75a\u4c9b"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \uc717[2];
    }

    private static Object \ucb09(Object object, String string, MethodType methodType) {
        if (\uc717 == null) {
            \uc717 = new Object[9];
        }
        if (\uc717[7] == null) {
            Matrix3d.\uc717[7] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(Vector3f$Matrix3d.\u9c53("\u985e\u0f6b\u9944\ue00e\ue4ac\u4718\uee62\u036e\uc893\u5699\u511d\u95d1\ud9ca\u3d42\u975c\u413b\u6999\u7f36\u2801")), Vector3f$Matrix3d.\u9c53("\u9844\u0f78\u995b\ue001\ue4f6\u471d\uee63"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \uc717[7];
    }

    private static Object \u16ef(Object object, String string, MethodType methodType) {
        if (\uc717 == null) {
            \uc717 = new Object[9];
        }
        if (\uc717[5] == null) {
            Matrix3d.\uc717[5] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(Vector3f$Matrix3d.\u9c53("\u985e\u0f6b\u9944\ue00e\ue4ac\u471d\uee6c\u032e\uc8a4\u56c5\u5131\u95c7\ud9dd\u3d74\u9758\u413d\u6995\u7f38\u2802")), Vector3f$Matrix3d.\u9c53("\u9844\u0f78\u995b\ue001\ue4f6\u4722\uee79\u0321\uc8a0\u5680\u5120\u95cd\ud9df\u3d72\u974d"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \uc717[5];
    }

    private static Object \u63a8(Object object, String string, MethodType methodType) {
        if (\uc717 == null) {
            \uc717 = new Object[9];
        }
        if (\uc717[8] == null) {
            Matrix3d.\uc717[8] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(Matrix3f$Matrix3d.\u610c("\u1222\ua570\u7ee2\u8ee7\u1db9\u4d95\uf93c\u4125\u8f9f\u0492\u0345\ub3a6\u4a1f\u77d4")), Matrix3f$Matrix3d.\u610c("\u1229\ua573\u7ee7"), methodType).asType(methodType));
        }
        return \uc717[8];
    }

    private static Object \u4ce4(Object object, String string, MethodType methodType) {
        if (\uc717 == null) {
            \uc717 = new Object[9];
        }
        if (\uc717[4] == null) {
            Matrix3d.\uc717[4] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(AxisAngle4f$Matrix4f.\ufb61("\u363a\u2566\u5531\uf3d4\u8aea\u9a6f\ud755\u4c92\u3057\u3b76\u2d12\u27c3\ud2d4\uc9ab")), AxisAngle4f$Matrix4f.\ufb61("\u3633\u2568\u5534"), methodType).asType(methodType));
        }
        return \uc717[4];
    }

    private static Object \ud028(Object object, String string, MethodType methodType) {
        if (\uc717 == null) {
            \uc717 = new Object[9];
        }
        if (\uc717[0] == null) {
            Matrix3d.\uc717[0] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(AxisAngle4f$Matrix3d.\u6dd0("\u4afd\u0f95\uab4a\ua59c\u9eba\u1f18\u5496\uc54b\u6ccd\ueaec\uf1f9\uf5ed\u33fa\u92cc\u8120\u8393\u244c\ua920\u9432\ub422\ub323\u08d9\uf272")), AxisAngle4f$Matrix3d.\u6dd0("\u4af6\u0f84\uab4c\ua598\u9efa\u1f10"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \uc717[0];
    }

    private static Object \u582e(Object object, String string, MethodType methodType) {
        if (\uc717 == null) {
            \uc717 = new Object[9];
        }
        if (\uc717[3] == null) {
            Matrix3d.\uc717[3] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(Vector3f$Matrix3d.\u9c53("\u985e\u0f6b\u9944\ue00e\ue4ac\u471d\uee6c\u032e\uc8a4\u56c5\u5139\u95de\ud9ca\u3d79")), Vector3f$Matrix3d.\u9c53("\u9847\u0f63\u995c"), methodType).asType(methodType));
        }
        return \uc717[3];
    }

    private static Object \u84fc(Object object, String string, MethodType methodType) {
        if (\uc717 == null) {
            \uc717 = new Object[9];
        }
        if (\uc717[6] == null) {
            Matrix3d.\uc717[6] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(Vector3f$Matrix3d.\u9c53("\u985e\u0f6b\u9944\ue00e\ue4ac\u471d\uee6c\u032e\uc8a4\u56c5\u5139\u95de\ud9ca\u3d79")), Vector3f$Matrix3d.\u9c53("\u9847\u0f7b\u9940\ue01b"), methodType).asType(methodType));
        }
        return \uc717[6];
    }
}

