/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.animations.MCACommonLibrary.math;

import galaxyspace.core.animations.MCACommonLibrary.math.AxisAngle4f$Matrix3d;
import galaxyspace.core.animations.MCACommonLibrary.math.AxisAngle4f$Matrix4f;
import galaxyspace.core.animations.MCACommonLibrary.math.Matrix3f$Matrix3d;
import galaxyspace.core.animations.MCACommonLibrary.math.Vector3f;
import galaxyspace.core.animations.MCACommonLibrary.math.Vector3f$Matrix3d;
import java.io.Serializable;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.FloatBuffer;
import java.util.logging.Logger;

public final class Matrix3f
implements Cloneable,
Serializable {
    static final long serialVersionUID = 1L;
    private static final Logger logger = Matrix3f.\u66ae("\u16c3", (String)Matrix3f.\u4598("\u70a3", Matrix3f.class));
    protected float m00;
    protected float m01;
    protected float m02;
    protected float m10;
    protected float m11;
    protected float m12;
    protected float m20;
    protected float m21;
    protected float m22;
    public static final Matrix3f ZERO = new Matrix3f(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    public static final Matrix3f IDENTITY = new Matrix3f();
    private static volatile transient Object[] \u0ab3;

    public Matrix3f() {
        this.loadIdentity();
    }

    public Matrix3f(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.m00 = f;
        this.m01 = f2;
        this.m02 = f3;
        this.m10 = f4;
        this.m11 = f5;
        this.m12 = f6;
        this.m20 = f7;
        this.m21 = f8;
        this.m22 = f9;
    }

    public Matrix3f(Matrix3f matrix3f) {
        this.set(matrix3f);
    }

    public void absoluteLocal() {
        this.m00 = (float)Matrix3f.\uca57("\ubbe6", (float)this.m00);
        this.m01 = (float)Matrix3f.\uca57("\ubbe6", (float)this.m01);
        this.m02 = (float)Matrix3f.\uca57("\ubbe6", (float)this.m02);
        this.m10 = (float)Matrix3f.\uca57("\ubbe6", (float)this.m10);
        this.m11 = (float)Matrix3f.\uca57("\ubbe6", (float)this.m11);
        this.m12 = (float)Matrix3f.\uca57("\ubbe6", (float)this.m12);
        this.m20 = (float)Matrix3f.\uca57("\ubbe6", (float)this.m20);
        this.m21 = (float)Matrix3f.\uca57("\ubbe6", (float)this.m21);
        this.m22 = (float)Matrix3f.\uca57("\ubbe6", (float)this.m22);
    }

    public Matrix3f set(Matrix3f matrix3f) {
        if (null == matrix3f) {
            this.loadIdentity();
        } else {
            this.m00 = matrix3f.m00;
            this.m01 = matrix3f.m01;
            this.m02 = matrix3f.m02;
            this.m10 = matrix3f.m10;
            this.m11 = matrix3f.m11;
            this.m12 = matrix3f.m12;
            this.m20 = matrix3f.m20;
            this.m21 = matrix3f.m21;
            this.m22 = matrix3f.m22;
        }
        return this;
    }

    public float get(int n, int n2) {
        switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m01;
                    }
                    case 2: {
                        return this.m02;
                    }
                }
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        return this.m10;
                    }
                    case 1: {
                        return this.m11;
                    }
                    case 2: {
                        return this.m12;
                    }
                }
            }
            case 2: {
                switch (n2) {
                    case 0: {
                        return this.m20;
                    }
                    case 1: {
                        return this.m21;
                    }
                    case 2: {
                        return this.m22;
                    }
                }
            }
        }
        Matrix3f.\uba87("\u6e43", (Logger)logger, (String)Matrix3f$Matrix3d.\u610c("\u1201\ua57f\u7ee2\u8ee7\u1dfb\u4d90\uf939\u416b\u8f95\u04dd\u037c\ub3b5\u4a02\u77c4\ub30f\u0bd9\u6f1c\uc492\ubf39\u36c1\udd83"));
        throw new IllegalArgumentException(Matrix3f$Matrix3d.\u610c("\u1201\ua57f\u7ee2\u8ee7\u1dfb\u4d90\uf939\u416b\u8f91\u04d2\u036c\ub3ae\u4a08\u77d9\ub35c\u0b90\u6f1b\uc498\ubf28\u36d6\udd8d\u48e9\u8669\u4080\ud088\u475b\u047e\u4f73"));
    }

    public void get(float[] fArray, boolean bl) {
        if (fArray.length == 9) {
            if (bl) {
                fArray[0] = this.m00;
                fArray[1] = this.m01;
                fArray[2] = this.m02;
                fArray[3] = this.m10;
                fArray[4] = this.m11;
                fArray[5] = this.m12;
                fArray[6] = this.m20;
                fArray[7] = this.m21;
                fArray[8] = this.m22;
            } else {
                fArray[0] = this.m00;
                fArray[1] = this.m10;
                fArray[2] = this.m20;
                fArray[3] = this.m01;
                fArray[4] = this.m11;
                fArray[5] = this.m21;
                fArray[6] = this.m02;
                fArray[7] = this.m12;
                fArray[8] = this.m22;
            }
        } else if (fArray.length == 16) {
            if (bl) {
                fArray[0] = this.m00;
                fArray[1] = this.m01;
                fArray[2] = this.m02;
                fArray[4] = this.m10;
                fArray[5] = this.m11;
                fArray[6] = this.m12;
                fArray[8] = this.m20;
                fArray[9] = this.m21;
                fArray[10] = this.m22;
            } else {
                fArray[0] = this.m00;
                fArray[1] = this.m10;
                fArray[2] = this.m20;
                fArray[4] = this.m01;
                fArray[5] = this.m11;
                fArray[6] = this.m21;
                fArray[8] = this.m02;
                fArray[9] = this.m12;
                fArray[10] = this.m22;
            }
        } else {
            throw new IndexOutOfBoundsException(Matrix3f$Matrix3d.\u610c("\u1209\ua563\u7ee6\u8ee7\u1dee\u4dd9\uf92e\u4122\u8f82\u04d9\u0328\ub3aa\u4a1e\u77cf\ub35b\u0b90\u6f10\uc493\ubf7c\u3680\udd8d\u48eb\u867a\u40d4\ud0cb\u4704\u0426\u4f34\u0ec1\uf047\udb96\uc889\ua22b\u5db6\u849d\ubcb5\u9461\u0ce4\u67e3\uf771\u5bf7\u1d76\uafd4\u2ac4\ue365"));
        }
    }

    public Vector3f getColumn(int n) {
        return this.getColumn(n, null);
    }

    public Vector3f getColumn(int n, Vector3f vector3f) {
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        switch (n) {
            case 0: {
                vector3f.x = this.m00;
                vector3f.y = this.m10;
                vector3f.z = this.m20;
                break;
            }
            case 1: {
                vector3f.x = this.m01;
                vector3f.y = this.m11;
                vector3f.z = this.m21;
                break;
            }
            case 2: {
                vector3f.x = this.m02;
                vector3f.y = this.m12;
                vector3f.z = this.m22;
                break;
            }
            default: {
                Matrix3f.\uba87("\u6e43", (Logger)logger, (String)Matrix3f$Matrix3d.\u610c("\u1201\ua57f\u7ee2\u8ee7\u1dfb\u4d90\uf939\u416b\u8f9b\u04d3\u0364\ub3b2\u4a06\u77d2\ub30f\u0bd9\u6f1c\uc492\ubf39\u36c1\udd83"));
                throw new IllegalArgumentException((String)Matrix3f.\u660f("\u2c77", (StringBuilder)Matrix3f.\u6f1b("\u04d0", (StringBuilder)Matrix3f.\u5303("\ud286", (StringBuilder)new StringBuilder(), (String)Matrix3f$Matrix3d.\u610c("\u1201\ua57f\u7ee2\u8ee7\u1dfb\u4d90\uf939\u416b\u8f9b\u04d3\u0364\ub3b2\u4a06\u77d2\ub30f\u0bd9\u6f1c\uc492\ubf39\u36c1\udd83\u48a4")), (int)n)));
            }
        }
        return vector3f;
    }

    public Vector3f getRow(int n) {
        return this.getRow(n, null);
    }

    public Vector3f getRow(int n, Vector3f vector3f) {
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        switch (n) {
            case 0: {
                vector3f.x = this.m00;
                vector3f.y = this.m01;
                vector3f.z = this.m02;
                break;
            }
            case 1: {
                vector3f.x = this.m10;
                vector3f.y = this.m11;
                vector3f.z = this.m12;
                break;
            }
            case 2: {
                vector3f.x = this.m20;
                vector3f.y = this.m21;
                vector3f.z = this.m22;
                break;
            }
            default: {
                Matrix3f.\uba87("\u6e43", (Logger)logger, (String)AxisAngle4f$Matrix4f.\ufb61("\u3619\u2569\u5531\uf3d4\u8aa8\u9a6a\ud750\u4cdc\u3042\u3b37\u2d28\u2782\ud2c9\uc9ad\u907c\u99e3\ueeee\uf1bb"));
                throw new IllegalArgumentException((String)Matrix3f.\u660f("\u2c77", (StringBuilder)Matrix3f.\u6f1b("\u04d0", (StringBuilder)Matrix3f.\u5303("\ud286", (StringBuilder)new StringBuilder(), (String)AxisAngle4f$Matrix4f.\ufb61("\u3619\u2569\u5531\uf3d4\u8aa8\u9a6a\ud750\u4cdc\u3042\u3b37\u2d28\u2782\ud2c9\uc9ad\u907c\u99e3\ueeee\uf1bb\u1f21")), (int)n)));
            }
        }
        return vector3f;
    }

    public FloatBuffer fillFloatBuffer(FloatBuffer floatBuffer, boolean bl) {
        if (bl) {
            Matrix3f.\uc11f("\ub060", (FloatBuffer)Matrix3f.\uc11f("\ub060", (FloatBuffer)Matrix3f.\uc11f("\ub060", (FloatBuffer)floatBuffer, (float)this.m00), (float)this.m10), (float)this.m20);
            Matrix3f.\uc11f("\ub060", (FloatBuffer)Matrix3f.\uc11f("\ub060", (FloatBuffer)Matrix3f.\uc11f("\ub060", (FloatBuffer)floatBuffer, (float)this.m01), (float)this.m11), (float)this.m21);
            Matrix3f.\uc11f("\ub060", (FloatBuffer)Matrix3f.\uc11f("\ub060", (FloatBuffer)Matrix3f.\uc11f("\ub060", (FloatBuffer)floatBuffer, (float)this.m02), (float)this.m12), (float)this.m22);
        } else {
            Matrix3f.\uc11f("\ub060", (FloatBuffer)Matrix3f.\uc11f("\ub060", (FloatBuffer)Matrix3f.\uc11f("\ub060", (FloatBuffer)floatBuffer, (float)this.m00), (float)this.m01), (float)this.m02);
            Matrix3f.\uc11f("\ub060", (FloatBuffer)Matrix3f.\uc11f("\ub060", (FloatBuffer)Matrix3f.\uc11f("\ub060", (FloatBuffer)floatBuffer, (float)this.m10), (float)this.m11), (float)this.m12);
            Matrix3f.\uc11f("\ub060", (FloatBuffer)Matrix3f.\uc11f("\ub060", (FloatBuffer)Matrix3f.\uc11f("\ub060", (FloatBuffer)floatBuffer, (float)this.m20), (float)this.m21), (float)this.m22);
        }
        return floatBuffer;
    }

    public void fillFloatArray(float[] fArray, boolean bl) {
        if (bl) {
            fArray[0] = this.m00;
            fArray[1] = this.m10;
            fArray[2] = this.m20;
            fArray[3] = this.m01;
            fArray[4] = this.m11;
            fArray[5] = this.m21;
            fArray[6] = this.m02;
            fArray[7] = this.m12;
            fArray[8] = this.m22;
        } else {
            fArray[0] = this.m00;
            fArray[1] = this.m01;
            fArray[2] = this.m02;
            fArray[3] = this.m10;
            fArray[4] = this.m11;
            fArray[5] = this.m12;
            fArray[6] = this.m20;
            fArray[7] = this.m21;
            fArray[8] = this.m22;
        }
    }

    public Matrix3f setColumn(int n, Vector3f vector3f) {
        if (vector3f == null) {
            Matrix3f.\uba87("\u6e43", (Logger)logger, (String)AxisAngle4f$Matrix4f.\ufb61("\u3613\u2568\u552b\uf3c0\u8aa9\u9a6d\ud714\u4c95\u3043\u3b78\u2d31\u27d7\ud2cc\uc9af\u9036\u99a6\ueedf\uf1f2\u1f6f\u1d44\ua2d8\u084c\u6bb0\ud303\u5294"));
            return this;
        }
        switch (n) {
            case 0: {
                this.m00 = vector3f.x;
                this.m10 = vector3f.y;
                this.m20 = vector3f.z;
                break;
            }
            case 1: {
                this.m01 = vector3f.x;
                this.m11 = vector3f.y;
                this.m21 = vector3f.z;
                break;
            }
            case 2: {
                this.m02 = vector3f.x;
                this.m12 = vector3f.y;
                this.m22 = vector3f.z;
                break;
            }
            default: {
                Matrix3f.\uba87("\u6e43", (Logger)logger, (String)AxisAngle4f$Matrix4f.\ufb61("\u3619\u2569\u5531\uf3d4\u8aa8\u9a6a\ud750\u4cdc\u3053\u3b37\u2d33\u27d7\ud2cd\uc9ad\u9038\u99ef\ueef8\uf1f1\u1f64\u1d53\ua284"));
                throw new IllegalArgumentException((String)Matrix3f.\u660f("\u2c77", (StringBuilder)Matrix3f.\u6f1b("\u04d0", (StringBuilder)Matrix3f.\u5303("\ud286", (StringBuilder)new StringBuilder(), (String)AxisAngle4f$Matrix4f.\ufb61("\u3619\u2569\u5531\uf3d4\u8aa8\u9a6a\ud750\u4cdc\u3053\u3b37\u2d33\u27d7\ud2cd\uc9ad\u9038\u99ef\ueef8\uf1f1\u1f64\u1d53\ua284\u0805")), (int)n)));
            }
        }
        return this;
    }

    public Matrix3f setRow(int n, Vector3f vector3f) {
        if (vector3f == null) {
            Matrix3f.\uba87("\u6e43", (Logger)logger, (String)Matrix3f$Matrix3d.\u610c("\u121a\ua57e\u7ee3\u8ea6\u1dfe\u4d8a\uf97d\u4125\u8f8d\u04d0\u0364\ub3e9\u4a4b\u77f5\ub348\u0bde\u6f1d\uc484\ubf35\u36d7\uddca\u48aa"));
            return this;
        }
        switch (n) {
            case 0: {
                this.m00 = vector3f.x;
                this.m01 = vector3f.y;
                this.m02 = vector3f.z;
                break;
            }
            case 1: {
                this.m10 = vector3f.x;
                this.m11 = vector3f.y;
                this.m12 = vector3f.z;
                break;
            }
            case 2: {
                this.m20 = vector3f.x;
                this.m21 = vector3f.y;
                this.m22 = vector3f.z;
                break;
            }
            default: {
                Matrix3f.\uba87("\u6e43", (Logger)logger, (String)Matrix3f$Matrix3d.\u610c("\u1201\ua57f\u7ee2\u8ee7\u1dfb\u4d90\uf939\u416b\u8f8a\u04d3\u037f\ub3e7\u4a02\u77d2\ub34b\u0bd5\u6f0a\uc4d8"));
                throw new IllegalArgumentException((String)Matrix3f.\u660f("\u2c77", (StringBuilder)Matrix3f.\u6f1b("\u04d0", (StringBuilder)Matrix3f.\u5303("\ud286", (StringBuilder)new StringBuilder(), (String)Matrix3f$Matrix3d.\u610c("\u1201\ua57f\u7ee2\u8ee7\u1dfb\u4d90\uf939\u416b\u8f8a\u04d3\u037f\ub3e7\u4a02\u77d2\ub34b\u0bd5\u6f0a\uc4d8\ubf7c")), (int)n)));
            }
        }
        return this;
    }

    public Matrix3f set(int n, int n2, float f) {
        switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        this.m00 = f;
                        return this;
                    }
                    case 1: {
                        this.m01 = f;
                        return this;
                    }
                    case 2: {
                        this.m02 = f;
                        return this;
                    }
                }
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        this.m10 = f;
                        return this;
                    }
                    case 1: {
                        this.m11 = f;
                        return this;
                    }
                    case 2: {
                        this.m12 = f;
                        return this;
                    }
                }
            }
            case 2: {
                switch (n2) {
                    case 0: {
                        this.m20 = f;
                        return this;
                    }
                    case 1: {
                        this.m21 = f;
                        return this;
                    }
                    case 2: {
                        this.m22 = f;
                        return this;
                    }
                }
            }
        }
        Matrix3f.\uba87("\u6e43", (Logger)logger, (String)AxisAngle4f$Matrix4f.\ufb61("\u3619\u2569\u5531\uf3d4\u8aa8\u9a6a\ud750\u4cdc\u305d\u3b39\u2d2b\u27d0\ud2c9\uc9bb\u9038\u99ef\ueef8\uf1f1\u1f64\u1d53\ua284"));
        throw new IllegalArgumentException(AxisAngle4f$Matrix4f.\ufb61("\u3619\u2569\u5531\uf3d4\u8aa8\u9a6a\ud750\u4cdc\u3059\u3b36\u2d3b\u27cb\ud2c3\uc9a6\u906b\u99a6\ueeff\uf1fb\u1f75\u1d44\ua28a\u0848\u6bbf\ud310\u52c8\ueebd\u1e4c\u0379"));
    }

    public Matrix3f set(float[][] fArray) {
        if (fArray.length != 3 || fArray[0].length != 3) {
            throw new IllegalArgumentException(Vector3f$Matrix3d.\u9c53("\u9875\u0f78\u9940\ue00e\ue4fb\u4751\uee60\u0335\uc8b0\u569f\u5154\u95dd\ud9db\u3d31\u9747\u412f\u69dc\u7f24\u2805\u12ba\uef1f\uf94e\ubf2d\uacfa"));
        }
        this.m00 = fArray[0][0];
        this.m01 = fArray[0][1];
        this.m02 = fArray[0][2];
        this.m10 = fArray[1][0];
        this.m11 = fArray[1][1];
        this.m12 = fArray[1][2];
        this.m20 = fArray[2][0];
        this.m21 = fArray[2][1];
        this.m22 = fArray[2][2];
        return this;
    }

    public void fromAxes(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        this.m00 = vector3f.x;
        this.m10 = vector3f.y;
        this.m20 = vector3f.z;
        this.m01 = vector3f2.x;
        this.m11 = vector3f2.y;
        this.m21 = vector3f2.z;
        this.m02 = vector3f3.x;
        this.m12 = vector3f3.y;
        this.m22 = vector3f3.z;
    }

    public Matrix3f set(float[] fArray) {
        return this.set(fArray, true);
    }

    public Matrix3f set(float[] fArray, boolean bl) {
        if (fArray.length != 9) {
            throw new IllegalArgumentException(AxisAngle4f$Matrix3d.\u6dd0("\u4ad6\u0f86\uab4e\ua59c\u9eed\u1f54\u549a\uc550\u6cd9\ueab6\uf18a\uf5fb\u33ed\u9285\u8121\u8392\u242e\ua926\u9432\ub434\ub322\u089c\uf239\u4596"));
        }
        if (bl) {
            this.m00 = fArray[0];
            this.m01 = fArray[1];
            this.m02 = fArray[2];
            this.m10 = fArray[3];
            this.m11 = fArray[4];
            this.m12 = fArray[5];
            this.m20 = fArray[6];
            this.m21 = fArray[7];
            this.m22 = fArray[8];
        } else {
            this.m00 = fArray[0];
            this.m01 = fArray[3];
            this.m02 = fArray[6];
            this.m10 = fArray[1];
            this.m11 = fArray[4];
            this.m12 = fArray[7];
            this.m20 = fArray[2];
            this.m21 = fArray[5];
            this.m22 = fArray[8];
        }
        return this;
    }

    public void loadIdentity() {
        this.m21 = 0.0f;
        this.m20 = 0.0f;
        this.m12 = 0.0f;
        this.m10 = 0.0f;
        this.m02 = 0.0f;
        this.m01 = 0.0f;
        this.m22 = 1.0f;
        this.m11 = 1.0f;
        this.m00 = 1.0f;
    }

    public boolean isIdentity() {
        return this.m00 == 1.0f && this.m01 == 0.0f && this.m02 == 0.0f && this.m10 == 0.0f && this.m11 == 1.0f && this.m12 == 0.0f && this.m20 == 0.0f && this.m21 == 0.0f && this.m22 == 1.0f;
    }

    public void fromAngleAxis(float f, Vector3f vector3f) {
        Object object = Matrix3f.\u1d45("\u062c", (Vector3f)vector3f);
        this.fromAngleNormalAxis(f, (Vector3f)object);
    }

    public void fromAngleNormalAxis(float f, Vector3f vector3f) {
        Object object = Matrix3f.\u6a5e("\u5adc", (float)f);
        Object object2 = Matrix3f.\u6f1d("\ucd15", (float)f);
        float f2 = 1.0f - object;
        float f3 = vector3f.x * vector3f.x;
        float f4 = vector3f.y * vector3f.y;
        float f5 = vector3f.z * vector3f.z;
        float f6 = vector3f.x * vector3f.y * f2;
        float f7 = vector3f.x * vector3f.z * f2;
        float f8 = vector3f.y * vector3f.z * f2;
        float f9 = vector3f.x * object2;
        float f10 = vector3f.y * object2;
        float f11 = vector3f.z * object2;
        this.m00 = f3 * f2 + object;
        this.m01 = f6 - f11;
        this.m02 = f7 + f10;
        this.m10 = f6 + f11;
        this.m11 = f4 * f2 + object;
        this.m12 = f8 - f9;
        this.m20 = f7 - f10;
        this.m21 = f8 + f9;
        this.m22 = f5 * f2 + object;
    }

    public Matrix3f mult(Matrix3f matrix3f) {
        return this.mult(matrix3f, null);
    }

    public Matrix3f mult(Matrix3f matrix3f, Matrix3f matrix3f2) {
        if (matrix3f2 == null) {
            matrix3f2 = new Matrix3f();
        }
        float f = this.m00 * matrix3f.m00 + this.m01 * matrix3f.m10 + this.m02 * matrix3f.m20;
        float f2 = this.m00 * matrix3f.m01 + this.m01 * matrix3f.m11 + this.m02 * matrix3f.m21;
        float f3 = this.m00 * matrix3f.m02 + this.m01 * matrix3f.m12 + this.m02 * matrix3f.m22;
        float f4 = this.m10 * matrix3f.m00 + this.m11 * matrix3f.m10 + this.m12 * matrix3f.m20;
        float f5 = this.m10 * matrix3f.m01 + this.m11 * matrix3f.m11 + this.m12 * matrix3f.m21;
        float f6 = this.m10 * matrix3f.m02 + this.m11 * matrix3f.m12 + this.m12 * matrix3f.m22;
        float f7 = this.m20 * matrix3f.m00 + this.m21 * matrix3f.m10 + this.m22 * matrix3f.m20;
        float f8 = this.m20 * matrix3f.m01 + this.m21 * matrix3f.m11 + this.m22 * matrix3f.m21;
        float f9 = this.m20 * matrix3f.m02 + this.m21 * matrix3f.m12 + this.m22 * matrix3f.m22;
        matrix3f2.m00 = f;
        matrix3f2.m01 = f2;
        matrix3f2.m02 = f3;
        matrix3f2.m10 = f4;
        matrix3f2.m11 = f5;
        matrix3f2.m12 = f6;
        matrix3f2.m20 = f7;
        matrix3f2.m21 = f8;
        matrix3f2.m22 = f9;
        return matrix3f2;
    }

    public Vector3f mult(Vector3f vector3f) {
        return this.mult(vector3f, null);
    }

    public Vector3f mult(Vector3f vector3f, Vector3f vector3f2) {
        if (null == vector3f2) {
            vector3f2 = new Vector3f();
        }
        float f = vector3f.x;
        float f2 = vector3f.y;
        float f3 = vector3f.z;
        vector3f2.x = this.m00 * f + this.m01 * f2 + this.m02 * f3;
        vector3f2.y = this.m10 * f + this.m11 * f2 + this.m12 * f3;
        vector3f2.z = this.m20 * f + this.m21 * f2 + this.m22 * f3;
        return vector3f2;
    }

    public Matrix3f multLocal(float f) {
        this.m00 *= f;
        this.m01 *= f;
        this.m02 *= f;
        this.m10 *= f;
        this.m11 *= f;
        this.m12 *= f;
        this.m20 *= f;
        this.m21 *= f;
        this.m22 *= f;
        return this;
    }

    public Vector3f multLocal(Vector3f vector3f) {
        if (vector3f == null) {
            return null;
        }
        float f = vector3f.x;
        float f2 = vector3f.y;
        vector3f.x = this.m00 * f + this.m01 * f2 + this.m02 * vector3f.z;
        vector3f.y = this.m10 * f + this.m11 * f2 + this.m12 * vector3f.z;
        vector3f.z = this.m20 * f + this.m21 * f2 + this.m22 * vector3f.z;
        return vector3f;
    }

    public Matrix3f multLocal(Matrix3f matrix3f) {
        return this.mult(matrix3f, this);
    }

    public Matrix3f transposeLocal() {
        float f = this.m01;
        this.m01 = this.m10;
        this.m10 = f;
        f = this.m02;
        this.m02 = this.m20;
        this.m20 = f;
        f = this.m12;
        this.m12 = this.m21;
        this.m21 = f;
        return this;
    }

    public Matrix3f invert() {
        return this.invert(null);
    }

    public Matrix3f invert(Matrix3f matrix3f) {
        float f;
        if (matrix3f == null) {
            matrix3f = new Matrix3f();
        }
        if (Matrix3f.\uca57("\ubbe6", (float)(f = this.determinant())) <= 1.1920929E-7f) {
            return matrix3f.zero();
        }
        matrix3f.m00 = this.m11 * this.m22 - this.m12 * this.m21;
        matrix3f.m01 = this.m02 * this.m21 - this.m01 * this.m22;
        matrix3f.m02 = this.m01 * this.m12 - this.m02 * this.m11;
        matrix3f.m10 = this.m12 * this.m20 - this.m10 * this.m22;
        matrix3f.m11 = this.m00 * this.m22 - this.m02 * this.m20;
        matrix3f.m12 = this.m02 * this.m10 - this.m00 * this.m12;
        matrix3f.m20 = this.m10 * this.m21 - this.m11 * this.m20;
        matrix3f.m21 = this.m01 * this.m20 - this.m00 * this.m21;
        matrix3f.m22 = this.m00 * this.m11 - this.m01 * this.m10;
        matrix3f.multLocal(1.0f / f);
        return matrix3f;
    }

    public Matrix3f invertLocal() {
        float f = this.determinant();
        if (Matrix3f.\uca57("\ubbe6", (float)f) <= 1.1920929E-7f) {
            return this.zero();
        }
        float f2 = this.m11 * this.m22 - this.m12 * this.m21;
        float f3 = this.m02 * this.m21 - this.m01 * this.m22;
        float f4 = this.m01 * this.m12 - this.m02 * this.m11;
        float f5 = this.m12 * this.m20 - this.m10 * this.m22;
        float f6 = this.m00 * this.m22 - this.m02 * this.m20;
        float f7 = this.m02 * this.m10 - this.m00 * this.m12;
        float f8 = this.m10 * this.m21 - this.m11 * this.m20;
        float f9 = this.m01 * this.m20 - this.m00 * this.m21;
        float f10 = this.m00 * this.m11 - this.m01 * this.m10;
        this.m00 = f2;
        this.m01 = f3;
        this.m02 = f4;
        this.m10 = f5;
        this.m11 = f6;
        this.m12 = f7;
        this.m20 = f8;
        this.m21 = f9;
        this.m22 = f10;
        this.multLocal(1.0f / f);
        return this;
    }

    public Matrix3f adjoint() {
        return this.adjoint(null);
    }

    public Matrix3f adjoint(Matrix3f matrix3f) {
        if (matrix3f == null) {
            matrix3f = new Matrix3f();
        }
        matrix3f.m00 = this.m11 * this.m22 - this.m12 * this.m21;
        matrix3f.m01 = this.m02 * this.m21 - this.m01 * this.m22;
        matrix3f.m02 = this.m01 * this.m12 - this.m02 * this.m11;
        matrix3f.m10 = this.m12 * this.m20 - this.m10 * this.m22;
        matrix3f.m11 = this.m00 * this.m22 - this.m02 * this.m20;
        matrix3f.m12 = this.m02 * this.m10 - this.m00 * this.m12;
        matrix3f.m20 = this.m10 * this.m21 - this.m11 * this.m20;
        matrix3f.m21 = this.m01 * this.m20 - this.m00 * this.m21;
        matrix3f.m22 = this.m00 * this.m11 - this.m01 * this.m10;
        return matrix3f;
    }

    public float determinant() {
        float f = this.m11 * this.m22 - this.m12 * this.m21;
        float f2 = this.m12 * this.m20 - this.m10 * this.m22;
        float f3 = this.m10 * this.m21 - this.m11 * this.m20;
        float f4 = this.m00 * f + this.m01 * f2 + this.m02 * f3;
        return f4;
    }

    public Matrix3f zero() {
        this.m22 = 0.0f;
        this.m21 = 0.0f;
        this.m20 = 0.0f;
        this.m12 = 0.0f;
        this.m11 = 0.0f;
        this.m10 = 0.0f;
        this.m02 = 0.0f;
        this.m01 = 0.0f;
        this.m00 = 0.0f;
        return this;
    }

    public Matrix3f transpose() {
        return this.transposeLocal();
    }

    public Matrix3f transposeNew() {
        Matrix3f matrix3f = new Matrix3f(this.m00, this.m10, this.m20, this.m01, this.m11, this.m21, this.m02, this.m12, this.m22);
        return matrix3f;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(Vector3f$Matrix3d.\u9c53("\u9879\u0f6b\u9946\ue01d\ue4eb\u4709\uee3e\u0326\uc8c9\u56b0\u517e"));
        Matrix3f.\u5303("\ud286", (StringBuilder)stringBuilder, (String)Vector3f$Matrix3d.\u9c53("\u9814"));
        Matrix3f.\ub035("\u4058", (StringBuilder)stringBuilder, (float)this.m00);
        Matrix3f.\u5303("\ud286", (StringBuilder)stringBuilder, (String)Vector3f$Matrix3d.\u9c53("\u9814\u0f2a"));
        Matrix3f.\ub035("\u4058", (StringBuilder)stringBuilder, (float)this.m01);
        Matrix3f.\u5303("\ud286", (StringBuilder)stringBuilder, (String)Vector3f$Matrix3d.\u9c53("\u9814\u0f2a"));
        Matrix3f.\ub035("\u4058", (StringBuilder)stringBuilder, (float)this.m02);
        Matrix3f.\u5303("\ud286", (StringBuilder)stringBuilder, (String)Vector3f$Matrix3d.\u9c53("\u9814\u0f00"));
        Matrix3f.\u5303("\ud286", (StringBuilder)stringBuilder, (String)Vector3f$Matrix3d.\u9c53("\u9814"));
        Matrix3f.\ub035("\u4058", (StringBuilder)stringBuilder, (float)this.m10);
        Matrix3f.\u5303("\ud286", (StringBuilder)stringBuilder, (String)Vector3f$Matrix3d.\u9c53("\u9814\u0f2a"));
        Matrix3f.\ub035("\u4058", (StringBuilder)stringBuilder, (float)this.m11);
        Matrix3f.\u5303("\ud286", (StringBuilder)stringBuilder, (String)Vector3f$Matrix3d.\u9c53("\u9814\u0f2a"));
        Matrix3f.\ub035("\u4058", (StringBuilder)stringBuilder, (float)this.m12);
        Matrix3f.\u5303("\ud286", (StringBuilder)stringBuilder, (String)Vector3f$Matrix3d.\u9c53("\u9814\u0f00"));
        Matrix3f.\u5303("\ud286", (StringBuilder)stringBuilder, (String)Vector3f$Matrix3d.\u9c53("\u9814"));
        Matrix3f.\ub035("\u4058", (StringBuilder)stringBuilder, (float)this.m20);
        Matrix3f.\u5303("\ud286", (StringBuilder)stringBuilder, (String)Vector3f$Matrix3d.\u9c53("\u9814\u0f2a"));
        Matrix3f.\ub035("\u4058", (StringBuilder)stringBuilder, (float)this.m21);
        Matrix3f.\u5303("\ud286", (StringBuilder)stringBuilder, (String)Vector3f$Matrix3d.\u9c53("\u9814\u0f2a"));
        Matrix3f.\ub035("\u4058", (StringBuilder)stringBuilder, (float)this.m22);
        Matrix3f.\u5303("\ud286", (StringBuilder)stringBuilder, (String)Vector3f$Matrix3d.\u9c53("\u9814\u0f00\u996f"));
        return Matrix3f.\u660f("\u2c77", (StringBuilder)stringBuilder);
    }

    public int hashCode() {
        int n = 37;
        n = 37 * n + Matrix3f.\u03c1("\ufbe8", (float)this.m00);
        n = 37 * n + Matrix3f.\u03c1("\ufbe8", (float)this.m01);
        n = 37 * n + Matrix3f.\u03c1("\ufbe8", (float)this.m02);
        n = 37 * n + Matrix3f.\u03c1("\ufbe8", (float)this.m10);
        n = 37 * n + Matrix3f.\u03c1("\ufbe8", (float)this.m11);
        n = 37 * n + Matrix3f.\u03c1("\ufbe8", (float)this.m12);
        n = 37 * n + Matrix3f.\u03c1("\ufbe8", (float)this.m20);
        n = 37 * n + Matrix3f.\u03c1("\ufbe8", (float)this.m21);
        n = 37 * n + Matrix3f.\u03c1("\ufbe8", (float)this.m22);
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Matrix3f) || object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Matrix3f matrix3f = (Matrix3f)object;
        if (Matrix3f.\u1c5d("\ufc90", (float)this.m00, (float)matrix3f.m00) != false) {
            return false;
        }
        if (Matrix3f.\u1c5d("\ufc90", (float)this.m01, (float)matrix3f.m01) != false) {
            return false;
        }
        if (Matrix3f.\u1c5d("\ufc90", (float)this.m02, (float)matrix3f.m02) != false) {
            return false;
        }
        if (Matrix3f.\u1c5d("\ufc90", (float)this.m10, (float)matrix3f.m10) != false) {
            return false;
        }
        if (Matrix3f.\u1c5d("\ufc90", (float)this.m11, (float)matrix3f.m11) != false) {
            return false;
        }
        if (Matrix3f.\u1c5d("\ufc90", (float)this.m12, (float)matrix3f.m12) != false) {
            return false;
        }
        if (Matrix3f.\u1c5d("\ufc90", (float)this.m20, (float)matrix3f.m20) != false) {
            return false;
        }
        if (Matrix3f.\u1c5d("\ufc90", (float)this.m21, (float)matrix3f.m21) != false) {
            return false;
        }
        return Matrix3f.\u1c5d("\ufc90", (float)this.m22, (float)matrix3f.m22) == false;
    }

    public void fromStartEndVectors(Vector3f vector3f, Vector3f vector3f2) {
        Object object;
        Vector3f vector3f3 = new Vector3f();
        Matrix3f.\u18d9("\u93cd", (Vector3f)vector3f, (Vector3f)vector3f2, (Vector3f)vector3f3);
        Object object2 = Matrix3f.\u7312("\u7ab3", (Vector3f)vector3f, (Vector3f)vector3f2);
        Object object3 = object = object2 < 0.0f ? -object2 : object2;
        if (object > 0.9999f) {
            Vector3f vector3f4 = new Vector3f();
            Vector3f vector3f5 = new Vector3f();
            vector3f5.x = (double)vector3f.x > 0.0 ? vector3f.x : -vector3f.x;
            vector3f5.y = (double)vector3f.y > 0.0 ? vector3f.y : -vector3f.y;
            float f = vector3f5.z = (double)vector3f.z > 0.0 ? vector3f.z : -vector3f.z;
            if (vector3f5.x < vector3f5.y) {
                if (vector3f5.x < vector3f5.z) {
                    vector3f5.x = 1.0f;
                    vector3f5.z = 0.0f;
                    vector3f5.y = 0.0f;
                } else {
                    vector3f5.z = 1.0f;
                    vector3f5.y = 0.0f;
                    vector3f5.x = 0.0f;
                }
            } else if (vector3f5.y < vector3f5.z) {
                vector3f5.y = 1.0f;
                vector3f5.z = 0.0f;
                vector3f5.x = 0.0f;
            } else {
                vector3f5.z = 1.0f;
                vector3f5.y = 0.0f;
                vector3f5.x = 0.0f;
            }
            vector3f4.x = vector3f5.x - vector3f.x;
            vector3f4.y = vector3f5.y - vector3f.y;
            vector3f4.z = vector3f5.z - vector3f.z;
            vector3f3.x = vector3f5.x - vector3f2.x;
            vector3f3.y = vector3f5.y - vector3f2.y;
            vector3f3.z = vector3f5.z - vector3f2.z;
            float f2 = 2.0f / Matrix3f.\u7312("\u7ab3", (Vector3f)vector3f4, (Vector3f)vector3f4);
            float f3 = 2.0f / Matrix3f.\u7312("\u7ab3", (Vector3f)vector3f3, (Vector3f)vector3f3);
            float f4 = f2 * f3 * Matrix3f.\u7312("\u7ab3", (Vector3f)vector3f4, (Vector3f)vector3f3);
            for (int i = 0; i < 3; ++i) {
                float f5;
                for (int j = 0; j < 3; ++j) {
                    f5 = -f2 * Matrix3f.\u8247("\ub3ba", (Vector3f)vector3f4, (int)i) * Matrix3f.\u8247("\ub3ba", (Vector3f)vector3f4, (int)j) - f3 * Matrix3f.\u8247("\ub3ba", (Vector3f)vector3f3, (int)i) * Matrix3f.\u8247("\ub3ba", (Vector3f)vector3f3, (int)j) + f4 * Matrix3f.\u8247("\ub3ba", (Vector3f)vector3f3, (int)i) * Matrix3f.\u8247("\ub3ba", (Vector3f)vector3f4, (int)j);
                    this.set(i, j, f5);
                }
                f5 = this.get(i, i);
                this.set(i, i, f5 + 1.0f);
            }
        } else {
            float f = 1.0f / (1.0f + object2);
            float f6 = f * vector3f3.x;
            float f7 = f * vector3f3.z;
            float f8 = f6 * vector3f3.y;
            float f9 = f6 * vector3f3.z;
            float f10 = f7 * vector3f3.y;
            this.set(0, 0, (float)(object2 + f6 * vector3f3.x));
            this.set(0, 1, f8 - vector3f3.z);
            this.set(0, 2, f9 + vector3f3.y);
            this.set(1, 0, f8 + vector3f3.z);
            this.set(1, 1, (float)(object2 + f * vector3f3.y * vector3f3.y));
            this.set(1, 2, f10 - vector3f3.x);
            this.set(2, 0, f9 - vector3f3.y);
            this.set(2, 1, f10 + vector3f3.x);
            this.set(2, 2, (float)(object2 + f7 * vector3f3.z));
        }
    }

    public void scale(Vector3f vector3f) {
        this.m00 *= vector3f.x;
        this.m10 *= vector3f.x;
        this.m20 *= vector3f.x;
        this.m01 *= vector3f.y;
        this.m11 *= vector3f.y;
        this.m21 *= vector3f.y;
        this.m02 *= vector3f.z;
        this.m12 *= vector3f.z;
        this.m22 *= vector3f.z;
    }

    static boolean equalIdentity(Matrix3f matrix3f) {
        if ((double)Matrix3f.\ud03b("\ubce3", (float)(matrix3f.m00 - 1.0f)) > 1.0E-4) {
            return false;
        }
        if ((double)Matrix3f.\ud03b("\ubce3", (float)(matrix3f.m11 - 1.0f)) > 1.0E-4) {
            return false;
        }
        if ((double)Matrix3f.\ud03b("\ubce3", (float)(matrix3f.m22 - 1.0f)) > 1.0E-4) {
            return false;
        }
        if ((double)Matrix3f.\ud03b("\ubce3", (float)matrix3f.m01) > 1.0E-4) {
            return false;
        }
        if ((double)Matrix3f.\ud03b("\ubce3", (float)matrix3f.m02) > 1.0E-4) {
            return false;
        }
        if ((double)Matrix3f.\ud03b("\ubce3", (float)matrix3f.m10) > 1.0E-4) {
            return false;
        }
        if ((double)Matrix3f.\ud03b("\ubce3", (float)matrix3f.m12) > 1.0E-4) {
            return false;
        }
        if ((double)Matrix3f.\ud03b("\ubce3", (float)matrix3f.m20) > 1.0E-4) {
            return false;
        }
        return !((double)Matrix3f.\ud03b("\ubce3", (float)matrix3f.m21) > 1.0E-4);
    }

    public Matrix3f clone() {
        try {
            return (Matrix3f)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    private static Object \u18d9(Object object, String string, MethodType methodType) {
        if (\u0ab3 == null) {
            \u0ab3 = new Object[18];
        }
        if (\u0ab3[5] == null) {
            Matrix3f.\u0ab3[5] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(AxisAngle4f$Matrix3d.\u6dd0("\u4af0\u0f95\uab50\ua59c\u9eec\u1f0d\u5484\uc555\u6ccb\ueaa1\uf1cf\uf5b7\u33eb\u92ca\u813c\u8391\u2420\ua934\u9435\ub427\ub32a\u08dd\uf274\u45d1\u5a13\u42b6\u6ac2\u10ca\u6337\u24ef\ua724\u7a51\u5583\u9536\u7d4e\ubc4f\u3ecc\ubdac\u0867\u4428\u73e3\u1bd8\u9cca\u73e2\u649b\ud216\u5efb\u9148\u653a\u93c1\ue879\u75f5\u7f24\uf2ff\u4414\udcdb\ub569\ub394")), AxisAngle4f$Matrix3d.\u6dd0("\u4af4\u0f86\uab53\ua58e\u9ee7"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u0ab3[5];
    }

    private static Object \u660f(Object object, String string, MethodType methodType) {
        if (\u0ab3 == null) {
            \u0ab3 = new Object[18];
        }
        if (\u0ab3[12] == null) {
            Matrix3f.\u0ab3[12] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(Vector3f$Matrix3d.\u9c53("\u985e\u0f6b\u9944\ue00e\ue4ac\u471d\uee6c\u032e\uc8a4\u56c5\u5127\u95cb\ud9cc\u3d78\u9746\u412e\u69be\u7f22\u2805\u12ac\uef1e\uf90b\ubf66")), Vector3f$Matrix3d.\u9c53("\u9840\u0f65\u9961\ue01b\ue4f0\u4718\uee63\u0327"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u0ab3[12];
    }

    private static Object \u7312(Object object, String string, MethodType methodType) {
        if (\u0ab3 == null) {
            \u0ab3 = new Object[18];
        }
        if (\u0ab3[6] == null) {
            Matrix3f.\u0ab3[6] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(Vector3f$Matrix3d.\u9c53("\u9853\u0f6b\u995e\ue00e\ue4fa\u4708\uee7e\u0330\uc8a2\u5688\u5111\u9591\ud9dd\u3d7e\u975a\u412c\u69d2\u7f36\u2802\u12a9\uef17\uf90f\ubf60\uacbd\u39da\u39fa\u4688\ue33f\ube6e\u3a6b\u6f6b\u46c5\uc040\u1bbe\udc24\u4349\u4bd0\u481e\ub90a\ufd2f\u68b9\u7929\u8839\u077e\u79db\uc118\u32bd\uada3\u14d0\ubf2d\u27b8\u7fe1\u1473\u2a5d\u0817\uf467\ue97b\u078a")), Vector3f$Matrix3d.\u9c53("\u9850\u0f65\u9946"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u0ab3[6];
    }

    private static Object \ub035(Object object, String string, MethodType methodType) {
        if (\u0ab3 == null) {
            \u0ab3 = new Object[18];
        }
        if (\u0ab3[17] == null) {
            Matrix3f.\u0ab3[17] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(Vector3f$Matrix3d.\u9c53("\u985e\u0f6b\u9944\ue00e\ue4ac\u471d\uee6c\u032e\uc8a4\u56c5\u5127\u95cb\ud9cc\u3d78\u9746\u412e\u69be\u7f22\u2805\u12ac\uef1e\uf90b\ubf66")), Vector3f$Matrix3d.\u9c53("\u9855\u0f7a\u9942\ue00a\ue4ec\u4715"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u0ab3[17];
    }

    private static Object \u03c1(Object object, String string, MethodType methodType) {
        if (\u0ab3 == null) {
            \u0ab3 = new Object[18];
        }
        if (\u0ab3[13] == null) {
            Matrix3f.\u0ab3[13] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(AxisAngle4f$Matrix3d.\u6dd0("\u4afd\u0f95\uab4a\ua59c\u9eba\u1f18\u5496\uc54b\u6ccd\ueaec\uf1ec\uf5f5\u33e7\u92c4\u813a")), AxisAngle4f$Matrix3d.\u6dd0("\u4af1\u0f98\uab53\ua59c\u9ee0\u1f20\u5498\uc56c\u6cc4\ueab6\uf1e8\uf5f0\u33fc\u92d6"), methodType).asType(methodType));
        }
        return \u0ab3[13];
    }

    private static Object \uca57(Object object, String string, MethodType methodType) {
        if (\u0ab3 == null) {
            \u0ab3 = new Object[18];
        }
        if (\u0ab3[14] == null) {
            Matrix3f.\u0ab3[14] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(AxisAngle4f$Matrix3d.\u6dd0("\u4af0\u0f95\uab50\ua59c\u9eec\u1f0d\u5484\uc555\u6ccb\ueaa1\uf1cf\uf5b7\u33eb\u92ca\u813c\u8391\u2420\ua934\u9435\ub427\ub32a\u08dd\uf274\u45d1\u5a13\u42b6\u6ac2\u10ca\u6337\u24ef\ua724\u7a51\u5583\u9536\u7d4e\ubc4f\u3ecc\ubdac\u0867\u4428\u73e3\u1bd8\u9cca\u73e2\u649b\ud216\u5efb\u9148\u653a\u93c1\ue869\u75f1\u7f34\uf2ff\u4436\udcc8\ub52e\ub39a")), AxisAngle4f$Matrix3d.\u6dd0("\u4af6\u0f96\uab4f"), methodType).asType(methodType));
        }
        return \u0ab3[14];
    }

    private static Object \uba87(Object object, String string, MethodType methodType) {
        if (\u0ab3 == null) {
            \u0ab3 = new Object[18];
        }
        if (\u0ab3[8] == null) {
            Matrix3f.\u0ab3[8] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(AxisAngle4f$Matrix3d.\u6dd0("\u4afd\u0f95\uab4a\ua59c\u9eba\u1f01\u5483\uc54c\u6cc6\ueaec\uf1c6\uf5f6\u33ef\u92c2\u8127\u839a\u2469\ua97b\u9417\ub421\ub320\u08db\uf265\u45ca")), AxisAngle4f$Matrix3d.\u6dd0("\u4ae0\u0f95\uab4e\ua593\u9efd\u1f1a\u5490"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u0ab3[8];
    }

    private static Object \u6a5e(Object object, String string, MethodType methodType) {
        if (\u0ab3 == null) {
            \u0ab3 = new Object[18];
        }
        if (\u0ab3[3] == null) {
            Matrix3f.\u0ab3[3] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(Vector3f$Matrix3d.\u9c53("\u9853\u0f6b\u995e\ue00e\ue4fa\u4708\uee7e\u0330\uc8a2\u5688\u5111\u9591\ud9dd\u3d7e\u975a\u412c\u69d2\u7f36\u2802\u12a9\uef17\uf90f\ubf60\uacbd\u39da\u39fa\u4688\ue33f\ube6e\u3a6b\u6f6b\u46c5\uc040\u1bbe\udc24\u4349\u4bd0\u481e\ub90a\ufd2f\u68b9\u7929\u8839\u077e\u79db\uc118\u32bd\uada3\u14d0\ubf2d\u27a8\u7fe5\u1463\u2a5d\u0835\uf474\ue93c\u0784")), Vector3f$Matrix3d.\u9c53("\u9857\u0f65\u9941"), methodType).asType(methodType));
        }
        return \u0ab3[3];
    }

    private static Object \u5303(Object object, String string, MethodType methodType) {
        if (\u0ab3 == null) {
            \u0ab3 = new Object[18];
        }
        if (\u0ab3[11] == null) {
            Matrix3f.\u0ab3[11] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(Vector3f$Matrix3d.\u9c53("\u985e\u0f6b\u9944\ue00e\ue4ac\u471d\uee6c\u032e\uc8a4\u56c5\u5127\u95cb\ud9cc\u3d78\u9746\u412e\u69be\u7f22\u2805\u12ac\uef1e\uf90b\ubf66")), Vector3f$Matrix3d.\u9c53("\u9855\u0f7a\u9942\ue00a\ue4ec\u4715"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u0ab3[11];
    }

    private static Object \u1d45(Object object, String string, MethodType methodType) {
        if (\u0ab3 == null) {
            \u0ab3 = new Object[18];
        }
        if (\u0ab3[7] == null) {
            Matrix3f.\u0ab3[7] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(Matrix3f$Matrix3d.\u610c("\u122f\ua570\u7ef8\u8ee7\u1def\u4d80\uf92e\u413b\u8f99\u04df\u036d\ub3e9\u4a08\u77d3\ub35d\u0bd5\u6f5c\uc497\ubf32\u36d0\uddc0\u48e5\u867c\u409d\ud095\u475c\u0475\u4f73\u0ee2\uf024\udb9a\uc8ab\ua230\u5da9\u8499\ubca2\u943c\u0cce\u67a4\uf774\u5be0\u1d63\uaf8e\u2a94\ue365\u4379\u56ee\ub611\uc8ea\u269b\u067a\u5289\u351e\u2d9a\u6cb2\u1b64\ub901\ufea4")), Matrix3f$Matrix3d.\u610c("\u1226\ua57e\u7ee6\u8eeb\u1df6\u4d95\uf934\u4131\u8f9d"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u0ab3[7];
    }

    private static Object \u66ae(Object object, String string, MethodType methodType) {
        if (\u0ab3 == null) {
            \u0ab3 = new Object[18];
        }
        if (\u0ab3[15] == null) {
            Matrix3f.\u0ab3[15] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(AxisAngle4f$Matrix4f.\ufb61("\u363a\u2566\u5531\uf3d4\u8aea\u9a76\ud740\u4c95\u305c\u3b76\u2d33\u27cd\ud2c7\uc9a4\u9071\u99e8\ueef1\uf1bb\u1f4d\u1d44\ua2cd\u0842\u6bbb\ud316")), AxisAngle4f$Matrix4f.\ufb61("\u3637\u2562\u5533\uf3f9\u8aab\u9a64\ud753\u4c99\u3042"), methodType).asType(methodType));
        }
        return \u0ab3[15];
    }

    private static Object \u6f1d(Object object, String string, MethodType methodType) {
        if (\u0ab3 == null) {
            \u0ab3 = new Object[18];
        }
        if (\u0ab3[4] == null) {
            Matrix3f.\u0ab3[4] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(Matrix3f$Matrix3d.\u610c("\u122f\ua570\u7ef8\u8ee7\u1def\u4d80\uf92e\u413b\u8f99\u04df\u036d\ub3e9\u4a08\u77d3\ub35d\u0bd5\u6f5c\uc497\ubf32\u36d0\uddc0\u48e5\u867c\u409d\ud095\u475c\u0475\u4f73\u0ee2\uf024\udb9a\uc8ab\ua230\u5da9\u8499\ubca2\u943c\u0cce\u67a4\uf774\u5be0\u1d63\uaf8e\u2a94\ue365\u4379\u56ee\ub611\uc8ea\u269b\u066a\u528d\u350e\u2d9a\u6c90\u1b77\ub946\ufeaa")), Matrix3f$Matrix3d.\u610c("\u123b\ua578\u7efa"), methodType).asType(methodType));
        }
        return \u0ab3[4];
    }

    private static Object \u1c5d(Object object, String string, MethodType methodType) {
        if (\u0ab3 == null) {
            \u0ab3 = new Object[18];
        }
        if (\u0ab3[0] == null) {
            Matrix3f.\u0ab3[0] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(Matrix3f$Matrix3d.\u610c("\u1222\ua570\u7ee2\u8ee7\u1db9\u4d95\uf93c\u4125\u8f9f\u0492\u034e\ub3ab\u4a04\u77dd\ub35b")), Matrix3f$Matrix3d.\u610c("\u122b\ua57e\u7ef9\u8ef6\u1df6\u4d8b\uf938"), methodType).asType(methodType));
        }
        return \u0ab3[0];
    }

    private static Object \u8247(Object object, String string, MethodType methodType) {
        if (\u0ab3 == null) {
            \u0ab3 = new Object[18];
        }
        if (\u0ab3[10] == null) {
            Matrix3f.\u0ab3[10] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(Vector3f$Matrix3d.\u9c53("\u9853\u0f6b\u995e\ue00e\ue4fa\u4708\uee7e\u0330\uc8a2\u5688\u5111\u9591\ud9dd\u3d7e\u975a\u412c\u69d2\u7f36\u2802\u12a9\uef17\uf90f\ubf60\uacbd\u39da\u39fa\u4688\ue33f\ube6e\u3a6b\u6f6b\u46c5\uc040\u1bbe\udc24\u4349\u4bd0\u481e\ub90a\ufd2f\u68b9\u7929\u8839\u077e\u79db\uc118\u32bd\uada3\u14d0\ubf2d\u27b8\u7fe1\u1473\u2a5d\u0817\uf467\ue97b\u078a")), Vector3f$Matrix3d.\u9c53("\u9853\u0f6f\u9946"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u0ab3[10];
    }

    private static Object \u6f1b(Object object, String string, MethodType methodType) {
        if (\u0ab3 == null) {
            \u0ab3 = new Object[18];
        }
        if (\u0ab3[16] == null) {
            Matrix3f.\u0ab3[16] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(AxisAngle4f$Matrix3d.\u6dd0("\u4afd\u0f95\uab4a\ua59c\u9eba\u1f18\u5496\uc54b\u6ccd\ueaec\uf1f9\uf5ed\u33fa\u92cc\u8120\u8393\u244c\ua920\u9432\ub422\ub323\u08d9\uf272")), AxisAngle4f$Matrix3d.\u6dd0("\u4af6\u0f84\uab4c\ua598\u9efa\u1f10"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u0ab3[16];
    }

    private static Object \uc11f(Object object, String string, MethodType methodType) {
        if (\u0ab3 == null) {
            \u0ab3 = new Object[18];
        }
        if (\u0ab3[9] == null) {
            Matrix3f.\u0ab3[9] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(AxisAngle4f$Matrix4f.\ufb61("\u363a\u2566\u5531\uf3d4\u8aea\u9a6d\ud75d\u4c93\u301e\u3b1e\u2d33\u27cd\ud2c1\uc9b7\u905a\u99f3\ueef0\uf1f3\u1f64\u1d59")), AxisAngle4f$Matrix4f.\ufb61("\u3620\u2572\u5533"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u0ab3[9];
    }

    private static Object \ud03b(Object object, String string, MethodType methodType) {
        if (\u0ab3 == null) {
            \u0ab3 = new Object[18];
        }
        if (\u0ab3[2] == null) {
            Matrix3f.\u0ab3[2] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(Vector3f$Matrix3d.\u9c53("\u985e\u0f6b\u9944\ue00e\ue4ac\u471d\uee6c\u032e\uc8a4\u56c5\u5139\u95de\ud9ca\u3d79")), Vector3f$Matrix3d.\u9c53("\u9855\u0f68\u9941"), methodType).asType(methodType));
        }
        return \u0ab3[2];
    }

    private static Object \u4598(Object object, String string, MethodType methodType) {
        if (\u0ab3 == null) {
            \u0ab3 = new Object[18];
        }
        if (\u0ab3[1] == null) {
            Matrix3f.\u0ab3[1] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(Vector3f$Matrix3d.\u9c53("\u985e\u0f6b\u9944\ue00e\ue4ac\u471d\uee6c\u032e\uc8a4\u56c5\u5137\u95d3\ud9df\u3d62\u975b")), Vector3f$Matrix3d.\u9c53("\u9853\u0f6f\u9946\ue021\ue4e3\u471c\uee68"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u0ab3[1];
    }
}

