/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.animations.MCACommonLibrary.math;

import galaxyspace.core.animations.MCACommonLibrary.math.AxisAngle4f;
import galaxyspace.core.animations.MCACommonLibrary.math.AxisAngle4f$Matrix3d;
import galaxyspace.core.animations.MCACommonLibrary.math.AxisAngle4f$Matrix4f;
import galaxyspace.core.animations.MCACommonLibrary.math.Matrix3f;
import galaxyspace.core.animations.MCACommonLibrary.math.Matrix3f$Matrix3d;
import galaxyspace.core.animations.MCACommonLibrary.math.Quaternion;
import galaxyspace.core.animations.MCACommonLibrary.math.Vector3f;
import galaxyspace.core.animations.MCACommonLibrary.math.Vector3f$Matrix3d;
import java.io.Serializable;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public class Matrix4f
implements Serializable {
    public float m00;
    public float m01;
    public float m02;
    public float m03;
    public float m10;
    public float m11;
    public float m12;
    public float m13;
    public float m20;
    public float m21;
    public float m22;
    public float m23;
    public float m30;
    public float m31;
    public float m32;
    public float m33;
    private static final double EPS = 1.0E-8;
    private static volatile transient Object[] \ufb75;

    public Matrix4f(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.m00 = f;
        this.m01 = f2;
        this.m02 = f3;
        this.m03 = f4;
        this.m10 = f5;
        this.m11 = f6;
        this.m12 = f7;
        this.m13 = f8;
        this.m20 = f9;
        this.m21 = f10;
        this.m22 = f11;
        this.m23 = f12;
        this.m30 = f13;
        this.m31 = f14;
        this.m32 = f15;
        this.m33 = f16;
    }

    public Matrix4f(float[] fArray) {
        this.m00 = fArray[0];
        this.m01 = fArray[1];
        this.m02 = fArray[2];
        this.m03 = fArray[3];
        this.m10 = fArray[4];
        this.m11 = fArray[5];
        this.m12 = fArray[6];
        this.m13 = fArray[7];
        this.m20 = fArray[8];
        this.m21 = fArray[9];
        this.m22 = fArray[10];
        this.m23 = fArray[11];
        this.m30 = fArray[12];
        this.m31 = fArray[13];
        this.m32 = fArray[14];
        this.m33 = fArray[15];
    }

    public Matrix4f(Quaternion quaternion, Vector3f vector3f, float f) {
        this.m00 = (float)((double)f * (1.0 - 2.0 * (double)quaternion.y * (double)quaternion.y - 2.0 * (double)quaternion.z * (double)quaternion.z));
        this.m10 = (float)((double)f * (2.0 * (double)(quaternion.x * quaternion.y + quaternion.w * quaternion.z)));
        this.m20 = (float)((double)f * (2.0 * (double)(quaternion.x * quaternion.z - quaternion.w * quaternion.y)));
        this.m01 = (float)((double)f * (2.0 * (double)(quaternion.x * quaternion.y - quaternion.w * quaternion.z)));
        this.m11 = (float)((double)f * (1.0 - 2.0 * (double)quaternion.x * (double)quaternion.x - 2.0 * (double)quaternion.z * (double)quaternion.z));
        this.m21 = (float)((double)f * (2.0 * (double)(quaternion.y * quaternion.z + quaternion.w * quaternion.x)));
        this.m02 = (float)((double)f * (2.0 * (double)(quaternion.x * quaternion.z + quaternion.w * quaternion.y)));
        this.m12 = (float)((double)f * (2.0 * (double)(quaternion.y * quaternion.z - quaternion.w * quaternion.x)));
        this.m22 = (float)((double)f * (1.0 - 2.0 * (double)quaternion.x * (double)quaternion.x - 2.0 * (double)quaternion.y * (double)quaternion.y));
        this.m03 = vector3f.x;
        this.m13 = vector3f.y;
        this.m23 = vector3f.z;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public Matrix4f(Matrix4f matrix4f) {
        this.m00 = matrix4f.m00;
        this.m01 = matrix4f.m01;
        this.m02 = matrix4f.m02;
        this.m03 = matrix4f.m03;
        this.m10 = matrix4f.m10;
        this.m11 = matrix4f.m11;
        this.m12 = matrix4f.m12;
        this.m13 = matrix4f.m13;
        this.m20 = matrix4f.m20;
        this.m21 = matrix4f.m21;
        this.m22 = matrix4f.m22;
        this.m23 = matrix4f.m23;
        this.m30 = matrix4f.m30;
        this.m31 = matrix4f.m31;
        this.m32 = matrix4f.m32;
        this.m33 = matrix4f.m33;
    }

    public Matrix4f(Matrix3f matrix3f, Vector3f vector3f, float f) {
        this.m00 = matrix3f.m00 * f;
        this.m01 = matrix3f.m01 * f;
        this.m02 = matrix3f.m02 * f;
        this.m03 = vector3f.x;
        this.m10 = matrix3f.m10 * f;
        this.m11 = matrix3f.m11 * f;
        this.m12 = matrix3f.m12 * f;
        this.m13 = vector3f.y;
        this.m20 = matrix3f.m20 * f;
        this.m21 = matrix3f.m21 * f;
        this.m22 = matrix3f.m22 * f;
        this.m23 = vector3f.z;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public Matrix4f() {
        this.m00 = 0.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 0.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 0.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 0.0f;
    }

    public String toString() {
        return Matrix4f.\u9161("\ubdaf", (StringBuilder)Matrix4f.\u6249("\u5765", (StringBuilder)Matrix4f.\uc8e6("\u84ee", (StringBuilder)Matrix4f.\u6249("\u5765", (StringBuilder)Matrix4f.\uc8e6("\u84ee", (StringBuilder)Matrix4f.\u6249("\u5765", (StringBuilder)Matrix4f.\uc8e6("\u84ee", (StringBuilder)Matrix4f.\u6249("\u5765", (StringBuilder)Matrix4f.\uc8e6("\u84ee", (StringBuilder)Matrix4f.\u6249("\u5765", (StringBuilder)Matrix4f.\uc8e6("\u84ee", (StringBuilder)Matrix4f.\u6249("\u5765", (StringBuilder)Matrix4f.\uc8e6("\u84ee", (StringBuilder)Matrix4f.\u6249("\u5765", (StringBuilder)Matrix4f.\uc8e6("\u84ee", (StringBuilder)Matrix4f.\u6249("\u5765", (StringBuilder)Matrix4f.\uc8e6("\u84ee", (StringBuilder)Matrix4f.\u6249("\u5765", (StringBuilder)Matrix4f.\uc8e6("\u84ee", (StringBuilder)Matrix4f.\u6249("\u5765", (StringBuilder)Matrix4f.\uc8e6("\u84ee", (StringBuilder)Matrix4f.\u6249("\u5765", (StringBuilder)Matrix4f.\uc8e6("\u84ee", (StringBuilder)Matrix4f.\u6249("\u5765", (StringBuilder)Matrix4f.\uc8e6("\u84ee", (StringBuilder)Matrix4f.\u6249("\u5765", (StringBuilder)Matrix4f.\uc8e6("\u84ee", (StringBuilder)Matrix4f.\u6249("\u5765", (StringBuilder)Matrix4f.\uc8e6("\u84ee", (StringBuilder)Matrix4f.\u6249("\u5765", (StringBuilder)Matrix4f.\uc8e6("\u84ee", (StringBuilder)Matrix4f.\u6249("\u5765", (StringBuilder)Matrix4f.\uc8e6("\u84ee", (StringBuilder)new StringBuilder(), (float)this.m00), (String)Matrix3f$Matrix3d.\u610c("\u1264\ua531")), (float)this.m01), (String)Matrix3f$Matrix3d.\u610c("\u1264\ua531")), (float)this.m02), (String)Matrix3f$Matrix3d.\u610c("\u1264\ua531")), (float)this.m03), (String)Matrix3f$Matrix3d.\u610c("\u1242")), (float)this.m10), (String)Matrix3f$Matrix3d.\u610c("\u1264\ua531")), (float)this.m11), (String)Matrix3f$Matrix3d.\u610c("\u1264\ua531")), (float)this.m12), (String)Matrix3f$Matrix3d.\u610c("\u1264\ua531")), (float)this.m13), (String)Matrix3f$Matrix3d.\u610c("\u1242")), (float)this.m20), (String)Matrix3f$Matrix3d.\u610c("\u1264\ua531")), (float)this.m21), (String)Matrix3f$Matrix3d.\u610c("\u1264\ua531")), (float)this.m22), (String)Matrix3f$Matrix3d.\u610c("\u1264\ua531")), (float)this.m23), (String)Matrix3f$Matrix3d.\u610c("\u1242")), (float)this.m30), (String)Matrix3f$Matrix3d.\u610c("\u1264\ua531")), (float)this.m31), (String)Matrix3f$Matrix3d.\u610c("\u1264\ua531")), (float)this.m32), (String)Matrix3f$Matrix3d.\u610c("\u1264\ua531")), (float)this.m33), (String)Matrix3f$Matrix3d.\u610c("\u1242")));
    }

    public final void setIdentity() {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void setElement(int n, int n2, float f) {
        block0 : switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        this.m00 = f;
                        break block0;
                    }
                    case 1: {
                        this.m01 = f;
                        break block0;
                    }
                    case 2: {
                        this.m02 = f;
                        break block0;
                    }
                    case 3: {
                        this.m03 = f;
                        break block0;
                    }
                }
                throw new ArrayIndexOutOfBoundsException(Vector3f$Matrix3d.\u9c53("\u9864\u0f58\u997d\ue02d\ue4ce\u4734\uee40\u0361\uc8e2\u56ca\u5154\u95f2\ud9df\u3d65\u975a\u4120\u6984\u7f63\u280a"));
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        this.m10 = f;
                        break block0;
                    }
                    case 1: {
                        this.m11 = f;
                        break block0;
                    }
                    case 2: {
                        this.m12 = f;
                        break block0;
                    }
                    case 3: {
                        this.m13 = f;
                        break block0;
                    }
                }
                throw new ArrayIndexOutOfBoundsException(Vector3f$Matrix3d.\u9c53("\u9864\u0f58\u997d\ue02d\ue4ce\u4734\uee40\u0361\uc8e2\u56ca\u5154\u95f2\ud9df\u3d65\u975a\u4120\u6984\u7f63\u280a"));
            }
            case 2: {
                switch (n2) {
                    case 0: {
                        this.m20 = f;
                        break block0;
                    }
                    case 1: {
                        this.m21 = f;
                        break block0;
                    }
                    case 2: {
                        this.m22 = f;
                        break block0;
                    }
                    case 3: {
                        this.m23 = f;
                        break block0;
                    }
                }
                throw new ArrayIndexOutOfBoundsException(Vector3f$Matrix3d.\u9c53("\u9864\u0f58\u997d\ue02d\ue4ce\u4734\uee40\u0361\uc8e2\u56ca\u5154\u95f2\ud9df\u3d65\u975a\u4120\u6984\u7f63\u280a"));
            }
            case 3: {
                switch (n2) {
                    case 0: {
                        this.m30 = f;
                        break block0;
                    }
                    case 1: {
                        this.m31 = f;
                        break block0;
                    }
                    case 2: {
                        this.m32 = f;
                        break block0;
                    }
                    case 3: {
                        this.m33 = f;
                        break block0;
                    }
                }
                throw new ArrayIndexOutOfBoundsException(Vector3f$Matrix3d.\u9c53("\u9864\u0f58\u997d\ue02d\ue4ce\u4734\uee40\u0361\uc8e2\u56ca\u5154\u95f2\ud9df\u3d65\u975a\u4120\u6984\u7f63\u280a"));
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(Vector3f$Matrix3d.\u9c53("\u9864\u0f58\u997d\ue02d\ue4ce\u4734\uee40\u0361\uc8e2\u56ca\u5154\u95f2\ud9df\u3d65\u975a\u4120\u6984\u7f63\u280a"));
            }
        }
    }

    public final float getElement(int n, int n2) {
        switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m01;
                    }
                    case 2: {
                        return this.m02;
                    }
                    case 3: {
                        return this.m03;
                    }
                }
                break;
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        return this.m10;
                    }
                    case 1: {
                        return this.m11;
                    }
                    case 2: {
                        return this.m12;
                    }
                    case 3: {
                        return this.m13;
                    }
                }
                break;
            }
            case 2: {
                switch (n2) {
                    case 0: {
                        return this.m20;
                    }
                    case 1: {
                        return this.m21;
                    }
                    case 2: {
                        return this.m22;
                    }
                    case 3: {
                        return this.m23;
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 0: {
                        return this.m30;
                    }
                    case 1: {
                        return this.m31;
                    }
                    case 2: {
                        return this.m32;
                    }
                    case 3: {
                        return this.m33;
                    }
                }
                break;
            }
        }
        throw new ArrayIndexOutOfBoundsException(AxisAngle4f$Matrix4f.\ufb61("\u3600\u2555\u5508\uf3f7\u8a88\u9a46\ud779\u4cdd\u3011\u3b79\u2d7f\u27ef\ud2c1\uc9b7\u906a\u99ef\ueeee\uf1a1\u1f67"));
    }

    public final void get(Matrix3f matrix3f) {
        double[] dArray = new double[9];
        double[] dArray2 = new double[3];
        this.getScaleRotate(dArray2, dArray);
        matrix3f.m00 = (float)dArray[0];
        matrix3f.m01 = (float)dArray[1];
        matrix3f.m02 = (float)dArray[2];
        matrix3f.m10 = (float)dArray[3];
        matrix3f.m11 = (float)dArray[4];
        matrix3f.m12 = (float)dArray[5];
        matrix3f.m20 = (float)dArray[6];
        matrix3f.m21 = (float)dArray[7];
        matrix3f.m22 = (float)dArray[8];
    }

    public final void get(Quaternion quaternion) {
        double[] dArray = new double[9];
        double[] dArray2 = new double[3];
        this.getScaleRotate(dArray2, dArray);
        double d = 0.25 * (1.0 + dArray[0] + dArray[4] + dArray[8]);
        if (!((d < 0.0 ? -d : d) < 1.0E-30)) {
            quaternion.w = (float)Matrix4f.\u86e4("\u3567", (double)d);
            d = 0.25 / (double)quaternion.w;
            quaternion.x = (float)((dArray[7] - dArray[5]) * d);
            quaternion.y = (float)((dArray[2] - dArray[6]) * d);
            quaternion.z = (float)((dArray[3] - dArray[1]) * d);
            return;
        }
        quaternion.w = 0.0f;
        d = -0.5 * (dArray[4] + dArray[8]);
        if (!((d < 0.0 ? -d : d) < 1.0E-30)) {
            quaternion.x = (float)Matrix4f.\u86e4("\u3567", (double)d);
            d = 0.5 / (double)quaternion.x;
            quaternion.y = (float)(dArray[3] * d);
            quaternion.z = (float)(dArray[6] * d);
            return;
        }
        quaternion.x = 0.0f;
        d = 0.5 * (1.0 - dArray[8]);
        if (!((d < 0.0 ? -d : d) < 1.0E-30)) {
            quaternion.y = (float)Matrix4f.\u86e4("\u3567", (double)d);
            quaternion.z = (float)(dArray[7] / (2.0 * (double)quaternion.y));
            return;
        }
        quaternion.y = 0.0f;
        quaternion.z = 1.0f;
    }

    public final void get(Vector3f vector3f) {
        vector3f.x = this.m03;
        vector3f.y = this.m13;
        vector3f.z = this.m23;
    }

    public final void getRotationScale(Matrix3f matrix3f) {
        matrix3f.m00 = this.m00;
        matrix3f.m01 = this.m01;
        matrix3f.m02 = this.m02;
        matrix3f.m10 = this.m10;
        matrix3f.m11 = this.m11;
        matrix3f.m12 = this.m12;
        matrix3f.m20 = this.m20;
        matrix3f.m21 = this.m21;
        matrix3f.m22 = this.m22;
    }

    public final float getScale() {
        double[] dArray = new double[9];
        double[] dArray2 = new double[3];
        this.getScaleRotate(dArray2, dArray);
        return (float)Matrix4f.\u997c("\u719b", (double[])dArray2);
    }

    public final void setRotationScale(Matrix3f matrix3f) {
        this.m00 = matrix3f.m00;
        this.m01 = matrix3f.m01;
        this.m02 = matrix3f.m02;
        this.m10 = matrix3f.m10;
        this.m11 = matrix3f.m11;
        this.m12 = matrix3f.m12;
        this.m20 = matrix3f.m20;
        this.m21 = matrix3f.m21;
        this.m22 = matrix3f.m22;
    }

    public final void setRow(int n, float f, float f2, float f3, float f4) {
        switch (n) {
            case 0: {
                this.m00 = f;
                this.m01 = f2;
                this.m02 = f3;
                this.m03 = f4;
                break;
            }
            case 1: {
                this.m10 = f;
                this.m11 = f2;
                this.m12 = f3;
                this.m13 = f4;
                break;
            }
            case 2: {
                this.m20 = f;
                this.m21 = f2;
                this.m22 = f3;
                this.m23 = f4;
                break;
            }
            case 3: {
                this.m30 = f;
                this.m31 = f2;
                this.m32 = f3;
                this.m33 = f4;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(Vector3f$Matrix3d.\u9c53("\u9864\u0f58\u997d\ue02d\ue4ce\u4734\uee40\u0361\uc8e2\u56ca\u5154\u95f2\ud9df\u3d65\u975a\u4120\u6984\u7f63\u280a"));
            }
        }
    }

    public final void setRow(int n, float[] fArray) {
        switch (n) {
            case 0: {
                this.m00 = fArray[0];
                this.m01 = fArray[1];
                this.m02 = fArray[2];
                this.m03 = fArray[3];
                break;
            }
            case 1: {
                this.m10 = fArray[0];
                this.m11 = fArray[1];
                this.m12 = fArray[2];
                this.m13 = fArray[3];
                break;
            }
            case 2: {
                this.m20 = fArray[0];
                this.m21 = fArray[1];
                this.m22 = fArray[2];
                this.m23 = fArray[3];
                break;
            }
            case 3: {
                this.m30 = fArray[0];
                this.m31 = fArray[1];
                this.m32 = fArray[2];
                this.m33 = fArray[3];
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(AxisAngle4f$Matrix3d.\u6dd0("\u4ac7\u0fa6\uab73\ua5bf\u9ed8\u1f31\u54ba\uc504\u6c8b\ueae3\uf18a\uf5d4\u33e9\u92d1\u813c\u839d\u2476\ua961\u943d"));
            }
        }
    }

    public final void setColumn(int n, float f, float f2, float f3, float f4) {
        switch (n) {
            case 0: {
                this.m00 = f;
                this.m10 = f2;
                this.m20 = f3;
                this.m30 = f4;
                break;
            }
            case 1: {
                this.m01 = f;
                this.m11 = f2;
                this.m21 = f3;
                this.m31 = f4;
                break;
            }
            case 2: {
                this.m02 = f;
                this.m12 = f2;
                this.m22 = f3;
                this.m32 = f4;
                break;
            }
            case 3: {
                this.m03 = f;
                this.m13 = f2;
                this.m23 = f3;
                this.m33 = f4;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(AxisAngle4f$Matrix4f.\ufb61("\u3600\u2555\u5508\uf3f7\u8a88\u9a46\ud779\u4cdd\u3011\u3b79\u2d7f\u27ef\ud2c1\uc9b7\u906a\u99ef\ueeee\uf1a1\u1f67\u1d12"));
            }
        }
    }

    public final void setColumn(int n, float[] fArray) {
        switch (n) {
            case 0: {
                this.m00 = fArray[0];
                this.m10 = fArray[1];
                this.m20 = fArray[2];
                this.m30 = fArray[3];
                break;
            }
            case 1: {
                this.m01 = fArray[0];
                this.m11 = fArray[1];
                this.m21 = fArray[2];
                this.m31 = fArray[3];
                break;
            }
            case 2: {
                this.m02 = fArray[0];
                this.m12 = fArray[1];
                this.m22 = fArray[2];
                this.m32 = fArray[3];
                break;
            }
            case 3: {
                this.m03 = fArray[0];
                this.m13 = fArray[1];
                this.m23 = fArray[2];
                this.m33 = fArray[3];
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(AxisAngle4f$Matrix4f.\ufb61("\u3600\u2555\u5508\uf3f7\u8a88\u9a46\ud779\u4cdd\u3011\u3b79\u2d7f\u27ef\ud2c1\uc9b7\u906a\u99ef\ueeee\uf1a1\u1f67"));
            }
        }
    }

    public final void add(float f) {
        this.m00 += f;
        this.m01 += f;
        this.m02 += f;
        this.m03 += f;
        this.m10 += f;
        this.m11 += f;
        this.m12 += f;
        this.m13 += f;
        this.m20 += f;
        this.m21 += f;
        this.m22 += f;
        this.m23 += f;
        this.m30 += f;
        this.m31 += f;
        this.m32 += f;
        this.m33 += f;
    }

    public final void add(float f, Matrix4f matrix4f) {
        this.m00 = matrix4f.m00 + f;
        this.m01 = matrix4f.m01 + f;
        this.m02 = matrix4f.m02 + f;
        this.m03 = matrix4f.m03 + f;
        this.m10 = matrix4f.m10 + f;
        this.m11 = matrix4f.m11 + f;
        this.m12 = matrix4f.m12 + f;
        this.m13 = matrix4f.m13 + f;
        this.m20 = matrix4f.m20 + f;
        this.m21 = matrix4f.m21 + f;
        this.m22 = matrix4f.m22 + f;
        this.m23 = matrix4f.m23 + f;
        this.m30 = matrix4f.m30 + f;
        this.m31 = matrix4f.m31 + f;
        this.m32 = matrix4f.m32 + f;
        this.m33 = matrix4f.m33 + f;
    }

    public final void add(Matrix4f matrix4f, Matrix4f matrix4f2) {
        this.m00 = matrix4f.m00 + matrix4f2.m00;
        this.m01 = matrix4f.m01 + matrix4f2.m01;
        this.m02 = matrix4f.m02 + matrix4f2.m02;
        this.m03 = matrix4f.m03 + matrix4f2.m03;
        this.m10 = matrix4f.m10 + matrix4f2.m10;
        this.m11 = matrix4f.m11 + matrix4f2.m11;
        this.m12 = matrix4f.m12 + matrix4f2.m12;
        this.m13 = matrix4f.m13 + matrix4f2.m13;
        this.m20 = matrix4f.m20 + matrix4f2.m20;
        this.m21 = matrix4f.m21 + matrix4f2.m21;
        this.m22 = matrix4f.m22 + matrix4f2.m22;
        this.m23 = matrix4f.m23 + matrix4f2.m23;
        this.m30 = matrix4f.m30 + matrix4f2.m30;
        this.m31 = matrix4f.m31 + matrix4f2.m31;
        this.m32 = matrix4f.m32 + matrix4f2.m32;
        this.m33 = matrix4f.m33 + matrix4f2.m33;
    }

    public final void add(Matrix4f matrix4f) {
        this.m00 += matrix4f.m00;
        this.m01 += matrix4f.m01;
        this.m02 += matrix4f.m02;
        this.m03 += matrix4f.m03;
        this.m10 += matrix4f.m10;
        this.m11 += matrix4f.m11;
        this.m12 += matrix4f.m12;
        this.m13 += matrix4f.m13;
        this.m20 += matrix4f.m20;
        this.m21 += matrix4f.m21;
        this.m22 += matrix4f.m22;
        this.m23 += matrix4f.m23;
        this.m30 += matrix4f.m30;
        this.m31 += matrix4f.m31;
        this.m32 += matrix4f.m32;
        this.m33 += matrix4f.m33;
    }

    public final void sub(Matrix4f matrix4f, Matrix4f matrix4f2) {
        this.m00 = matrix4f.m00 - matrix4f2.m00;
        this.m01 = matrix4f.m01 - matrix4f2.m01;
        this.m02 = matrix4f.m02 - matrix4f2.m02;
        this.m03 = matrix4f.m03 - matrix4f2.m03;
        this.m10 = matrix4f.m10 - matrix4f2.m10;
        this.m11 = matrix4f.m11 - matrix4f2.m11;
        this.m12 = matrix4f.m12 - matrix4f2.m12;
        this.m13 = matrix4f.m13 - matrix4f2.m13;
        this.m20 = matrix4f.m20 - matrix4f2.m20;
        this.m21 = matrix4f.m21 - matrix4f2.m21;
        this.m22 = matrix4f.m22 - matrix4f2.m22;
        this.m23 = matrix4f.m23 - matrix4f2.m23;
        this.m30 = matrix4f.m30 - matrix4f2.m30;
        this.m31 = matrix4f.m31 - matrix4f2.m31;
        this.m32 = matrix4f.m32 - matrix4f2.m32;
        this.m33 = matrix4f.m33 - matrix4f2.m33;
    }

    public final void sub(Matrix4f matrix4f) {
        this.m00 -= matrix4f.m00;
        this.m01 -= matrix4f.m01;
        this.m02 -= matrix4f.m02;
        this.m03 -= matrix4f.m03;
        this.m10 -= matrix4f.m10;
        this.m11 -= matrix4f.m11;
        this.m12 -= matrix4f.m12;
        this.m13 -= matrix4f.m13;
        this.m20 -= matrix4f.m20;
        this.m21 -= matrix4f.m21;
        this.m22 -= matrix4f.m22;
        this.m23 -= matrix4f.m23;
        this.m30 -= matrix4f.m30;
        this.m31 -= matrix4f.m31;
        this.m32 -= matrix4f.m32;
        this.m33 -= matrix4f.m33;
    }

    public final Matrix4f transpose() {
        float f = this.m10;
        this.m10 = this.m01;
        this.m01 = f;
        f = this.m20;
        this.m20 = this.m02;
        this.m02 = f;
        f = this.m30;
        this.m30 = this.m03;
        this.m03 = f;
        f = this.m21;
        this.m21 = this.m12;
        this.m12 = f;
        f = this.m31;
        this.m31 = this.m13;
        this.m13 = f;
        f = this.m32;
        this.m32 = this.m23;
        this.m23 = f;
        return this;
    }

    public final void transpose(Matrix4f matrix4f) {
        if (this != matrix4f) {
            this.m00 = matrix4f.m00;
            this.m01 = matrix4f.m10;
            this.m02 = matrix4f.m20;
            this.m03 = matrix4f.m30;
            this.m10 = matrix4f.m01;
            this.m11 = matrix4f.m11;
            this.m12 = matrix4f.m21;
            this.m13 = matrix4f.m31;
            this.m20 = matrix4f.m02;
            this.m21 = matrix4f.m12;
            this.m22 = matrix4f.m22;
            this.m23 = matrix4f.m32;
            this.m30 = matrix4f.m03;
            this.m31 = matrix4f.m13;
            this.m32 = matrix4f.m23;
            this.m33 = matrix4f.m33;
        } else {
            this.transpose();
        }
    }

    public final Matrix4f set(Quaternion quaternion) {
        this.m00 = 1.0f - 2.0f * quaternion.y * quaternion.y - 2.0f * quaternion.z * quaternion.z;
        this.m10 = 2.0f * (quaternion.x * quaternion.y + quaternion.w * quaternion.z);
        this.m20 = 2.0f * (quaternion.x * quaternion.z - quaternion.w * quaternion.y);
        this.m01 = 2.0f * (quaternion.x * quaternion.y - quaternion.w * quaternion.z);
        this.m11 = 1.0f - 2.0f * quaternion.x * quaternion.x - 2.0f * quaternion.z * quaternion.z;
        this.m21 = 2.0f * (quaternion.y * quaternion.z + quaternion.w * quaternion.x);
        this.m02 = 2.0f * (quaternion.x * quaternion.z + quaternion.w * quaternion.y);
        this.m12 = 2.0f * (quaternion.y * quaternion.z - quaternion.w * quaternion.x);
        this.m22 = 1.0f - 2.0f * quaternion.x * quaternion.x - 2.0f * quaternion.y * quaternion.y;
        this.m03 = 0.0f;
        this.m13 = 0.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
        return this;
    }

    public final void set(AxisAngle4f axisAngle4f) {
        float f = (float)Matrix4f.\u86e4("\u3567", (double)(axisAngle4f.x * axisAngle4f.x + axisAngle4f.y * axisAngle4f.y + axisAngle4f.z * axisAngle4f.z));
        if ((double)f < 1.0E-8) {
            this.m00 = 1.0f;
            this.m01 = 0.0f;
            this.m02 = 0.0f;
            this.m10 = 0.0f;
            this.m11 = 1.0f;
            this.m12 = 0.0f;
            this.m20 = 0.0f;
            this.m21 = 0.0f;
            this.m22 = 1.0f;
        } else {
            f = 1.0f / f;
            float f2 = axisAngle4f.x * f;
            float f3 = axisAngle4f.y * f;
            float f4 = axisAngle4f.z * f;
            float f5 = (float)Matrix4f.\u359d("\ufa1a", (double)axisAngle4f.angle);
            float f6 = (float)Matrix4f.\u4651("\u5215", (double)axisAngle4f.angle);
            float f7 = 1.0f - f6;
            float f8 = f2 * f4;
            float f9 = f2 * f3;
            float f10 = f3 * f4;
            this.m00 = f7 * f2 * f2 + f6;
            this.m01 = f7 * f9 - f5 * f4;
            this.m02 = f7 * f8 + f5 * f3;
            this.m10 = f7 * f9 + f5 * f4;
            this.m11 = f7 * f3 * f3 + f6;
            this.m12 = f7 * f10 - f5 * f2;
            this.m20 = f7 * f8 - f5 * f3;
            this.m21 = f7 * f10 + f5 * f2;
            this.m22 = f7 * f4 * f4 + f6;
        }
        this.m03 = 0.0f;
        this.m13 = 0.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void set(Quaternion quaternion, Vector3f vector3f, float f) {
        this.m00 = f * (1.0f - 2.0f * quaternion.y * quaternion.y - 2.0f * quaternion.z * quaternion.z);
        this.m10 = f * (2.0f * (quaternion.x * quaternion.y + quaternion.w * quaternion.z));
        this.m20 = f * (2.0f * (quaternion.x * quaternion.z - quaternion.w * quaternion.y));
        this.m01 = f * (2.0f * (quaternion.x * quaternion.y - quaternion.w * quaternion.z));
        this.m11 = f * (1.0f - 2.0f * quaternion.x * quaternion.x - 2.0f * quaternion.z * quaternion.z);
        this.m21 = f * (2.0f * (quaternion.y * quaternion.z + quaternion.w * quaternion.x));
        this.m02 = f * (2.0f * (quaternion.x * quaternion.z + quaternion.w * quaternion.y));
        this.m12 = f * (2.0f * (quaternion.y * quaternion.z - quaternion.w * quaternion.x));
        this.m22 = f * (1.0f - 2.0f * quaternion.x * quaternion.x - 2.0f * quaternion.y * quaternion.y);
        this.m03 = vector3f.x;
        this.m13 = vector3f.y;
        this.m23 = vector3f.z;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void set(Matrix4f matrix4f) {
        this.m00 = matrix4f.m00;
        this.m01 = matrix4f.m01;
        this.m02 = matrix4f.m02;
        this.m03 = matrix4f.m03;
        this.m10 = matrix4f.m10;
        this.m11 = matrix4f.m11;
        this.m12 = matrix4f.m12;
        this.m13 = matrix4f.m13;
        this.m20 = matrix4f.m20;
        this.m21 = matrix4f.m21;
        this.m22 = matrix4f.m22;
        this.m23 = matrix4f.m23;
        this.m30 = matrix4f.m30;
        this.m31 = matrix4f.m31;
        this.m32 = matrix4f.m32;
        this.m33 = matrix4f.m33;
    }

    public final void invert(Matrix4f matrix4f) {
        this.invertGeneral(matrix4f);
    }

    public final void invert() {
        this.invertGeneral(this);
    }

    final void invertGeneral(Matrix4f matrix4f) {
        double[] dArray = new double[16];
        double[] dArray2 = new double[16];
        int[] nArray = new int[4];
        dArray[0] = matrix4f.m00;
        dArray[1] = matrix4f.m01;
        dArray[2] = matrix4f.m02;
        dArray[3] = matrix4f.m03;
        dArray[4] = matrix4f.m10;
        dArray[5] = matrix4f.m11;
        dArray[6] = matrix4f.m12;
        dArray[7] = matrix4f.m13;
        dArray[8] = matrix4f.m20;
        dArray[9] = matrix4f.m21;
        dArray[10] = matrix4f.m22;
        dArray[11] = matrix4f.m23;
        dArray[12] = matrix4f.m30;
        dArray[13] = matrix4f.m31;
        dArray[14] = matrix4f.m32;
        dArray[15] = matrix4f.m33;
        if (!Matrix4f.luDecomposition(dArray, nArray)) {
            try {
                throw new Exception(Matrix3f$Matrix3d.\u610c("\u1218\ua543\u7edb\u8ec4\u1ddb\u4dbc\uf910\u416a\u8fd9\u049d\u0328\ub38a\u4a0a\u77c8\ub35d\u0bd9\u6f0a\uc4c2\ubf3a\u3688\udd9f"));
            }
            catch (Exception exception) {
                Matrix4f.\ud6a9("\uad5a", (Exception)exception);
            }
        }
        for (int i = 0; i < 16; ++i) {
            dArray2[i] = 0.0;
        }
        dArray2[0] = 1.0;
        dArray2[5] = 1.0;
        dArray2[10] = 1.0;
        dArray2[15] = 1.0;
        Matrix4f.luBacksubstitution(dArray, nArray, dArray2);
        this.m00 = (float)dArray2[0];
        this.m01 = (float)dArray2[1];
        this.m02 = (float)dArray2[2];
        this.m03 = (float)dArray2[3];
        this.m10 = (float)dArray2[4];
        this.m11 = (float)dArray2[5];
        this.m12 = (float)dArray2[6];
        this.m13 = (float)dArray2[7];
        this.m20 = (float)dArray2[8];
        this.m21 = (float)dArray2[9];
        this.m22 = (float)dArray2[10];
        this.m23 = (float)dArray2[11];
        this.m30 = (float)dArray2[12];
        this.m31 = (float)dArray2[13];
        this.m32 = (float)dArray2[14];
        this.m33 = (float)dArray2[15];
    }

    static boolean luDecomposition(double[] dArray, int[] nArray) {
        int n;
        double[] dArray2 = new double[4];
        int n2 = 0;
        int n3 = 0;
        int n4 = 4;
        while (n4-- != 0) {
            Object object = 0.0;
            n = 4;
            while (n-- != 0) {
                Object object2 = dArray[n2++];
                if (!((object2 = (Object)Matrix4f.\ub4d5("\u8fa1", (double)object2)) > object)) continue;
                object = object2;
            }
            if (object == 0.0) {
                return false;
            }
            dArray2[n3++] = 1.0 / object;
        }
        n = 0;
        for (n4 = 0; n4 < 4; ++n4) {
            double d;
            int n5;
            int n6;
            int n7;
            double d2;
            int n8;
            for (n2 = 0; n2 < n4; ++n2) {
                n8 = n + 4 * n2 + n4;
                d2 = dArray[n8];
                int n9 = n2;
                int n10 = n + 4 * n2;
                n7 = n + n4;
                while (n9-- != 0) {
                    d2 -= dArray[n10] * dArray[n7];
                    ++n10;
                    n7 += 4;
                }
                dArray[n8] = d2;
            }
            double d3 = 0.0;
            n3 = -1;
            for (n2 = n4; n2 < 4; ++n2) {
                double d4;
                n8 = n + 4 * n2 + n4;
                d2 = dArray[n8];
                n6 = n4;
                n5 = n + 4 * n2;
                n7 = n + n4;
                while (n6-- != 0) {
                    d2 -= dArray[n5] * dArray[n7];
                    ++n5;
                    n7 += 4;
                }
                dArray[n8] = d2;
                d = dArray2[n2] * Matrix4f.\ub4d5("\u8fa1", (double)d2);
                if (!(d4 >= d3)) continue;
                d3 = d;
                n3 = n2;
            }
            if (n3 < 0) {
                throw new RuntimeException(Vector3f$Matrix3d.\u9c53("\u9864\u0f58\u997d\ue02d\ue4ce\u4734\uee40\u0361\uc8e2\u56ca\u5154\u95f2\ud9df\u3d65\u975a\u4120\u6984\u7f63\u280a"));
            }
            if (n4 != n3) {
                n6 = 4;
                n5 = n + 4 * n3;
                n7 = n + 4 * n4;
                while (n6-- != 0) {
                    d = dArray[n5];
                    dArray[n5++] = dArray[n7];
                    dArray[n7++] = d;
                }
                dArray2[n3] = dArray2[n4];
            }
            nArray[n4] = n3;
            if (dArray[n + 4 * n4 + n4] == 0.0) {
                return false;
            }
            if (n4 == 3) continue;
            d = 1.0 / dArray[n + 4 * n4 + n4];
            n8 = n + 4 * (n4 + 1) + n4;
            n2 = 3 - n4;
            while (n2-- != 0) {
                int n11 = n8;
                dArray[n11] = dArray[n11] * d;
                n8 += 4;
            }
        }
        return true;
    }

    static void luBacksubstitution(double[] dArray, int[] nArray, double[] dArray2) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2;
            int n3 = i;
            int n4 = -1;
            for (int j = 0; j < 4; ++j) {
                int n5 = nArray[n + j];
                double d = dArray2[n3 + 4 * n5];
                dArray2[n3 + 4 * n5] = dArray2[n3 + 4 * j];
                if (n4 >= 0) {
                    n2 = j * 4;
                    for (int k = n4; k <= j - 1; ++k) {
                        d -= dArray[n2 + k] * dArray2[n3 + 4 * k];
                    }
                } else if (d != 0.0) {
                    n4 = j;
                }
                dArray2[n3 + 4 * j] = d;
            }
            n2 = 12;
            int n6 = n3 + 12;
            dArray2[n6] = dArray2[n6] / dArray[n2 + 3];
            dArray2[n3 + 8] = (dArray2[n3 + 8] - dArray[(n2 -= 4) + 3] * dArray2[n3 + 12]) / dArray[n2 + 2];
            dArray2[n3 + 4] = (dArray2[n3 + 4] - dArray[(n2 -= 4) + 2] * dArray2[n3 + 8] - dArray[n2 + 3] * dArray2[n3 + 12]) / dArray[n2 + 1];
            dArray2[n3 + 0] = (dArray2[n3 + 0] - dArray[(n2 -= 4) + 1] * dArray2[n3 + 4] - dArray[n2 + 2] * dArray2[n3 + 8] - dArray[n2 + 3] * dArray2[n3 + 12]) / dArray[n2 + 0];
        }
    }

    public final float determinant() {
        float f = this.m00 * (this.m11 * this.m22 * this.m33 + this.m12 * this.m23 * this.m31 + this.m13 * this.m21 * this.m32 - this.m13 * this.m22 * this.m31 - this.m11 * this.m23 * this.m32 - this.m12 * this.m21 * this.m33);
        f -= this.m01 * (this.m10 * this.m22 * this.m33 + this.m12 * this.m23 * this.m30 + this.m13 * this.m20 * this.m32 - this.m13 * this.m22 * this.m30 - this.m10 * this.m23 * this.m32 - this.m12 * this.m20 * this.m33);
        f += this.m02 * (this.m10 * this.m21 * this.m33 + this.m11 * this.m23 * this.m30 + this.m13 * this.m20 * this.m31 - this.m13 * this.m21 * this.m30 - this.m10 * this.m23 * this.m31 - this.m11 * this.m20 * this.m33);
        return f -= this.m03 * (this.m10 * this.m21 * this.m32 + this.m11 * this.m22 * this.m30 + this.m12 * this.m20 * this.m31 - this.m12 * this.m21 * this.m30 - this.m10 * this.m22 * this.m31 - this.m11 * this.m20 * this.m32);
    }

    public final void set(Matrix3f matrix3f) {
        this.m00 = matrix3f.m00;
        this.m01 = matrix3f.m01;
        this.m02 = matrix3f.m02;
        this.m03 = 0.0f;
        this.m10 = matrix3f.m10;
        this.m11 = matrix3f.m11;
        this.m12 = matrix3f.m12;
        this.m13 = 0.0f;
        this.m20 = matrix3f.m20;
        this.m21 = matrix3f.m21;
        this.m22 = matrix3f.m22;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void set(float f) {
        this.m00 = f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void set(float[] fArray) {
        this.m00 = fArray[0];
        this.m01 = fArray[1];
        this.m02 = fArray[2];
        this.m03 = fArray[3];
        this.m10 = fArray[4];
        this.m11 = fArray[5];
        this.m12 = fArray[6];
        this.m13 = fArray[7];
        this.m20 = fArray[8];
        this.m21 = fArray[9];
        this.m22 = fArray[10];
        this.m23 = fArray[11];
        this.m30 = fArray[12];
        this.m31 = fArray[13];
        this.m32 = fArray[14];
        this.m33 = fArray[15];
    }

    public final void set(Vector3f vector3f) {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = vector3f.x;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m13 = vector3f.y;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        this.m23 = vector3f.z;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void set(float f, Vector3f vector3f) {
        this.m00 = f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = vector3f.x;
        this.m10 = 0.0f;
        this.m11 = f;
        this.m12 = 0.0f;
        this.m13 = vector3f.y;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = f;
        this.m23 = vector3f.z;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void set(Vector3f vector3f, float f) {
        this.m00 = f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = f * vector3f.x;
        this.m10 = 0.0f;
        this.m11 = f;
        this.m12 = 0.0f;
        this.m13 = f * vector3f.y;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = f;
        this.m23 = f * vector3f.z;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void set(Matrix3f matrix3f, Vector3f vector3f, float f) {
        this.m00 = matrix3f.m00 * f;
        this.m01 = matrix3f.m01 * f;
        this.m02 = matrix3f.m02 * f;
        this.m03 = vector3f.x;
        this.m10 = matrix3f.m10 * f;
        this.m11 = matrix3f.m11 * f;
        this.m12 = matrix3f.m12 * f;
        this.m13 = vector3f.y;
        this.m20 = matrix3f.m20 * f;
        this.m21 = matrix3f.m21 * f;
        this.m22 = matrix3f.m22 * f;
        this.m23 = vector3f.z;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void setTranslation(Vector3f vector3f) {
        this.m03 = vector3f.x;
        this.m13 = vector3f.y;
        this.m23 = vector3f.z;
    }

    public final void rotX(float f) {
        float f2 = (float)Matrix4f.\u359d("\ufa1a", (double)f);
        float f3 = (float)Matrix4f.\u4651("\u5215", (double)f);
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = f3;
        this.m12 = -f2;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = f2;
        this.m22 = f3;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void rotY(float f) {
        float f2;
        float f3 = (float)Matrix4f.\u359d("\ufa1a", (double)f);
        this.m00 = f2 = (float)Matrix4f.\u4651("\u5215", (double)f);
        this.m01 = 0.0f;
        this.m02 = f3;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = -f3;
        this.m21 = 0.0f;
        this.m22 = f2;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void rotZ(float f) {
        float f2;
        float f3 = (float)Matrix4f.\u359d("\ufa1a", (double)f);
        this.m00 = f2 = (float)Matrix4f.\u4651("\u5215", (double)f);
        this.m01 = -f3;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = f3;
        this.m11 = f2;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void mul(float f) {
        this.m00 *= f;
        this.m01 *= f;
        this.m02 *= f;
        this.m03 *= f;
        this.m10 *= f;
        this.m11 *= f;
        this.m12 *= f;
        this.m13 *= f;
        this.m20 *= f;
        this.m21 *= f;
        this.m22 *= f;
        this.m23 *= f;
        this.m30 *= f;
        this.m31 *= f;
        this.m32 *= f;
        this.m33 *= f;
    }

    public final void mul(float f, Matrix4f matrix4f) {
        this.m00 = matrix4f.m00 * f;
        this.m01 = matrix4f.m01 * f;
        this.m02 = matrix4f.m02 * f;
        this.m03 = matrix4f.m03 * f;
        this.m10 = matrix4f.m10 * f;
        this.m11 = matrix4f.m11 * f;
        this.m12 = matrix4f.m12 * f;
        this.m13 = matrix4f.m13 * f;
        this.m20 = matrix4f.m20 * f;
        this.m21 = matrix4f.m21 * f;
        this.m22 = matrix4f.m22 * f;
        this.m23 = matrix4f.m23 * f;
        this.m30 = matrix4f.m30 * f;
        this.m31 = matrix4f.m31 * f;
        this.m32 = matrix4f.m32 * f;
        this.m33 = matrix4f.m33 * f;
    }

    public final void mul(Matrix4f matrix4f) {
        float f = this.m00 * matrix4f.m00 + this.m01 * matrix4f.m10 + this.m02 * matrix4f.m20 + this.m03 * matrix4f.m30;
        float f2 = this.m00 * matrix4f.m01 + this.m01 * matrix4f.m11 + this.m02 * matrix4f.m21 + this.m03 * matrix4f.m31;
        float f3 = this.m00 * matrix4f.m02 + this.m01 * matrix4f.m12 + this.m02 * matrix4f.m22 + this.m03 * matrix4f.m32;
        float f4 = this.m00 * matrix4f.m03 + this.m01 * matrix4f.m13 + this.m02 * matrix4f.m23 + this.m03 * matrix4f.m33;
        float f5 = this.m10 * matrix4f.m00 + this.m11 * matrix4f.m10 + this.m12 * matrix4f.m20 + this.m13 * matrix4f.m30;
        float f6 = this.m10 * matrix4f.m01 + this.m11 * matrix4f.m11 + this.m12 * matrix4f.m21 + this.m13 * matrix4f.m31;
        float f7 = this.m10 * matrix4f.m02 + this.m11 * matrix4f.m12 + this.m12 * matrix4f.m22 + this.m13 * matrix4f.m32;
        float f8 = this.m10 * matrix4f.m03 + this.m11 * matrix4f.m13 + this.m12 * matrix4f.m23 + this.m13 * matrix4f.m33;
        float f9 = this.m20 * matrix4f.m00 + this.m21 * matrix4f.m10 + this.m22 * matrix4f.m20 + this.m23 * matrix4f.m30;
        float f10 = this.m20 * matrix4f.m01 + this.m21 * matrix4f.m11 + this.m22 * matrix4f.m21 + this.m23 * matrix4f.m31;
        float f11 = this.m20 * matrix4f.m02 + this.m21 * matrix4f.m12 + this.m22 * matrix4f.m22 + this.m23 * matrix4f.m32;
        float f12 = this.m20 * matrix4f.m03 + this.m21 * matrix4f.m13 + this.m22 * matrix4f.m23 + this.m23 * matrix4f.m33;
        float f13 = this.m30 * matrix4f.m00 + this.m31 * matrix4f.m10 + this.m32 * matrix4f.m20 + this.m33 * matrix4f.m30;
        float f14 = this.m30 * matrix4f.m01 + this.m31 * matrix4f.m11 + this.m32 * matrix4f.m21 + this.m33 * matrix4f.m31;
        float f15 = this.m30 * matrix4f.m02 + this.m31 * matrix4f.m12 + this.m32 * matrix4f.m22 + this.m33 * matrix4f.m32;
        float f16 = this.m30 * matrix4f.m03 + this.m31 * matrix4f.m13 + this.m32 * matrix4f.m23 + this.m33 * matrix4f.m33;
        this.m00 = f;
        this.m01 = f2;
        this.m02 = f3;
        this.m03 = f4;
        this.m10 = f5;
        this.m11 = f6;
        this.m12 = f7;
        this.m13 = f8;
        this.m20 = f9;
        this.m21 = f10;
        this.m22 = f11;
        this.m23 = f12;
        this.m30 = f13;
        this.m31 = f14;
        this.m32 = f15;
        this.m33 = f16;
    }

    public final void mul(Matrix4f matrix4f, Matrix4f matrix4f2) {
        if (this != matrix4f && this != matrix4f2) {
            this.m00 = matrix4f.m00 * matrix4f2.m00 + matrix4f.m01 * matrix4f2.m10 + matrix4f.m02 * matrix4f2.m20 + matrix4f.m03 * matrix4f2.m30;
            this.m01 = matrix4f.m00 * matrix4f2.m01 + matrix4f.m01 * matrix4f2.m11 + matrix4f.m02 * matrix4f2.m21 + matrix4f.m03 * matrix4f2.m31;
            this.m02 = matrix4f.m00 * matrix4f2.m02 + matrix4f.m01 * matrix4f2.m12 + matrix4f.m02 * matrix4f2.m22 + matrix4f.m03 * matrix4f2.m32;
            this.m03 = matrix4f.m00 * matrix4f2.m03 + matrix4f.m01 * matrix4f2.m13 + matrix4f.m02 * matrix4f2.m23 + matrix4f.m03 * matrix4f2.m33;
            this.m10 = matrix4f.m10 * matrix4f2.m00 + matrix4f.m11 * matrix4f2.m10 + matrix4f.m12 * matrix4f2.m20 + matrix4f.m13 * matrix4f2.m30;
            this.m11 = matrix4f.m10 * matrix4f2.m01 + matrix4f.m11 * matrix4f2.m11 + matrix4f.m12 * matrix4f2.m21 + matrix4f.m13 * matrix4f2.m31;
            this.m12 = matrix4f.m10 * matrix4f2.m02 + matrix4f.m11 * matrix4f2.m12 + matrix4f.m12 * matrix4f2.m22 + matrix4f.m13 * matrix4f2.m32;
            this.m13 = matrix4f.m10 * matrix4f2.m03 + matrix4f.m11 * matrix4f2.m13 + matrix4f.m12 * matrix4f2.m23 + matrix4f.m13 * matrix4f2.m33;
            this.m20 = matrix4f.m20 * matrix4f2.m00 + matrix4f.m21 * matrix4f2.m10 + matrix4f.m22 * matrix4f2.m20 + matrix4f.m23 * matrix4f2.m30;
            this.m21 = matrix4f.m20 * matrix4f2.m01 + matrix4f.m21 * matrix4f2.m11 + matrix4f.m22 * matrix4f2.m21 + matrix4f.m23 * matrix4f2.m31;
            this.m22 = matrix4f.m20 * matrix4f2.m02 + matrix4f.m21 * matrix4f2.m12 + matrix4f.m22 * matrix4f2.m22 + matrix4f.m23 * matrix4f2.m32;
            this.m23 = matrix4f.m20 * matrix4f2.m03 + matrix4f.m21 * matrix4f2.m13 + matrix4f.m22 * matrix4f2.m23 + matrix4f.m23 * matrix4f2.m33;
            this.m30 = matrix4f.m30 * matrix4f2.m00 + matrix4f.m31 * matrix4f2.m10 + matrix4f.m32 * matrix4f2.m20 + matrix4f.m33 * matrix4f2.m30;
            this.m31 = matrix4f.m30 * matrix4f2.m01 + matrix4f.m31 * matrix4f2.m11 + matrix4f.m32 * matrix4f2.m21 + matrix4f.m33 * matrix4f2.m31;
            this.m32 = matrix4f.m30 * matrix4f2.m02 + matrix4f.m31 * matrix4f2.m12 + matrix4f.m32 * matrix4f2.m22 + matrix4f.m33 * matrix4f2.m32;
            this.m33 = matrix4f.m30 * matrix4f2.m03 + matrix4f.m31 * matrix4f2.m13 + matrix4f.m32 * matrix4f2.m23 + matrix4f.m33 * matrix4f2.m33;
        } else {
            float f = matrix4f.m00 * matrix4f2.m00 + matrix4f.m01 * matrix4f2.m10 + matrix4f.m02 * matrix4f2.m20 + matrix4f.m03 * matrix4f2.m30;
            float f2 = matrix4f.m00 * matrix4f2.m01 + matrix4f.m01 * matrix4f2.m11 + matrix4f.m02 * matrix4f2.m21 + matrix4f.m03 * matrix4f2.m31;
            float f3 = matrix4f.m00 * matrix4f2.m02 + matrix4f.m01 * matrix4f2.m12 + matrix4f.m02 * matrix4f2.m22 + matrix4f.m03 * matrix4f2.m32;
            float f4 = matrix4f.m00 * matrix4f2.m03 + matrix4f.m01 * matrix4f2.m13 + matrix4f.m02 * matrix4f2.m23 + matrix4f.m03 * matrix4f2.m33;
            float f5 = matrix4f.m10 * matrix4f2.m00 + matrix4f.m11 * matrix4f2.m10 + matrix4f.m12 * matrix4f2.m20 + matrix4f.m13 * matrix4f2.m30;
            float f6 = matrix4f.m10 * matrix4f2.m01 + matrix4f.m11 * matrix4f2.m11 + matrix4f.m12 * matrix4f2.m21 + matrix4f.m13 * matrix4f2.m31;
            float f7 = matrix4f.m10 * matrix4f2.m02 + matrix4f.m11 * matrix4f2.m12 + matrix4f.m12 * matrix4f2.m22 + matrix4f.m13 * matrix4f2.m32;
            float f8 = matrix4f.m10 * matrix4f2.m03 + matrix4f.m11 * matrix4f2.m13 + matrix4f.m12 * matrix4f2.m23 + matrix4f.m13 * matrix4f2.m33;
            float f9 = matrix4f.m20 * matrix4f2.m00 + matrix4f.m21 * matrix4f2.m10 + matrix4f.m22 * matrix4f2.m20 + matrix4f.m23 * matrix4f2.m30;
            float f10 = matrix4f.m20 * matrix4f2.m01 + matrix4f.m21 * matrix4f2.m11 + matrix4f.m22 * matrix4f2.m21 + matrix4f.m23 * matrix4f2.m31;
            float f11 = matrix4f.m20 * matrix4f2.m02 + matrix4f.m21 * matrix4f2.m12 + matrix4f.m22 * matrix4f2.m22 + matrix4f.m23 * matrix4f2.m32;
            float f12 = matrix4f.m20 * matrix4f2.m03 + matrix4f.m21 * matrix4f2.m13 + matrix4f.m22 * matrix4f2.m23 + matrix4f.m23 * matrix4f2.m33;
            float f13 = matrix4f.m30 * matrix4f2.m00 + matrix4f.m31 * matrix4f2.m10 + matrix4f.m32 * matrix4f2.m20 + matrix4f.m33 * matrix4f2.m30;
            float f14 = matrix4f.m30 * matrix4f2.m01 + matrix4f.m31 * matrix4f2.m11 + matrix4f.m32 * matrix4f2.m21 + matrix4f.m33 * matrix4f2.m31;
            float f15 = matrix4f.m30 * matrix4f2.m02 + matrix4f.m31 * matrix4f2.m12 + matrix4f.m32 * matrix4f2.m22 + matrix4f.m33 * matrix4f2.m32;
            float f16 = matrix4f.m30 * matrix4f2.m03 + matrix4f.m31 * matrix4f2.m13 + matrix4f.m32 * matrix4f2.m23 + matrix4f.m33 * matrix4f2.m33;
            this.m00 = f;
            this.m01 = f2;
            this.m02 = f3;
            this.m03 = f4;
            this.m10 = f5;
            this.m11 = f6;
            this.m12 = f7;
            this.m13 = f8;
            this.m20 = f9;
            this.m21 = f10;
            this.m22 = f11;
            this.m23 = f12;
            this.m30 = f13;
            this.m31 = f14;
            this.m32 = f15;
            this.m33 = f16;
        }
    }

    public final void mulTransposeBoth(Matrix4f matrix4f, Matrix4f matrix4f2) {
        if (this != matrix4f && this != matrix4f2) {
            this.m00 = matrix4f.m00 * matrix4f2.m00 + matrix4f.m10 * matrix4f2.m01 + matrix4f.m20 * matrix4f2.m02 + matrix4f.m30 * matrix4f2.m03;
            this.m01 = matrix4f.m00 * matrix4f2.m10 + matrix4f.m10 * matrix4f2.m11 + matrix4f.m20 * matrix4f2.m12 + matrix4f.m30 * matrix4f2.m13;
            this.m02 = matrix4f.m00 * matrix4f2.m20 + matrix4f.m10 * matrix4f2.m21 + matrix4f.m20 * matrix4f2.m22 + matrix4f.m30 * matrix4f2.m23;
            this.m03 = matrix4f.m00 * matrix4f2.m30 + matrix4f.m10 * matrix4f2.m31 + matrix4f.m20 * matrix4f2.m32 + matrix4f.m30 * matrix4f2.m33;
            this.m10 = matrix4f.m01 * matrix4f2.m00 + matrix4f.m11 * matrix4f2.m01 + matrix4f.m21 * matrix4f2.m02 + matrix4f.m31 * matrix4f2.m03;
            this.m11 = matrix4f.m01 * matrix4f2.m10 + matrix4f.m11 * matrix4f2.m11 + matrix4f.m21 * matrix4f2.m12 + matrix4f.m31 * matrix4f2.m13;
            this.m12 = matrix4f.m01 * matrix4f2.m20 + matrix4f.m11 * matrix4f2.m21 + matrix4f.m21 * matrix4f2.m22 + matrix4f.m31 * matrix4f2.m23;
            this.m13 = matrix4f.m01 * matrix4f2.m30 + matrix4f.m11 * matrix4f2.m31 + matrix4f.m21 * matrix4f2.m32 + matrix4f.m31 * matrix4f2.m33;
            this.m20 = matrix4f.m02 * matrix4f2.m00 + matrix4f.m12 * matrix4f2.m01 + matrix4f.m22 * matrix4f2.m02 + matrix4f.m32 * matrix4f2.m03;
            this.m21 = matrix4f.m02 * matrix4f2.m10 + matrix4f.m12 * matrix4f2.m11 + matrix4f.m22 * matrix4f2.m12 + matrix4f.m32 * matrix4f2.m13;
            this.m22 = matrix4f.m02 * matrix4f2.m20 + matrix4f.m12 * matrix4f2.m21 + matrix4f.m22 * matrix4f2.m22 + matrix4f.m32 * matrix4f2.m23;
            this.m23 = matrix4f.m02 * matrix4f2.m30 + matrix4f.m12 * matrix4f2.m31 + matrix4f.m22 * matrix4f2.m32 + matrix4f.m32 * matrix4f2.m33;
            this.m30 = matrix4f.m03 * matrix4f2.m00 + matrix4f.m13 * matrix4f2.m01 + matrix4f.m23 * matrix4f2.m02 + matrix4f.m33 * matrix4f2.m03;
            this.m31 = matrix4f.m03 * matrix4f2.m10 + matrix4f.m13 * matrix4f2.m11 + matrix4f.m23 * matrix4f2.m12 + matrix4f.m33 * matrix4f2.m13;
            this.m32 = matrix4f.m03 * matrix4f2.m20 + matrix4f.m13 * matrix4f2.m21 + matrix4f.m23 * matrix4f2.m22 + matrix4f.m33 * matrix4f2.m23;
            this.m33 = matrix4f.m03 * matrix4f2.m30 + matrix4f.m13 * matrix4f2.m31 + matrix4f.m23 * matrix4f2.m32 + matrix4f.m33 * matrix4f2.m33;
        } else {
            float f = matrix4f.m00 * matrix4f2.m00 + matrix4f.m10 * matrix4f2.m01 + matrix4f.m20 * matrix4f2.m02 + matrix4f.m30 * matrix4f2.m03;
            float f2 = matrix4f.m00 * matrix4f2.m10 + matrix4f.m10 * matrix4f2.m11 + matrix4f.m20 * matrix4f2.m12 + matrix4f.m30 * matrix4f2.m13;
            float f3 = matrix4f.m00 * matrix4f2.m20 + matrix4f.m10 * matrix4f2.m21 + matrix4f.m20 * matrix4f2.m22 + matrix4f.m30 * matrix4f2.m23;
            float f4 = matrix4f.m00 * matrix4f2.m30 + matrix4f.m10 * matrix4f2.m31 + matrix4f.m20 * matrix4f2.m32 + matrix4f.m30 * matrix4f2.m33;
            float f5 = matrix4f.m01 * matrix4f2.m00 + matrix4f.m11 * matrix4f2.m01 + matrix4f.m21 * matrix4f2.m02 + matrix4f.m31 * matrix4f2.m03;
            float f6 = matrix4f.m01 * matrix4f2.m10 + matrix4f.m11 * matrix4f2.m11 + matrix4f.m21 * matrix4f2.m12 + matrix4f.m31 * matrix4f2.m13;
            float f7 = matrix4f.m01 * matrix4f2.m20 + matrix4f.m11 * matrix4f2.m21 + matrix4f.m21 * matrix4f2.m22 + matrix4f.m31 * matrix4f2.m23;
            float f8 = matrix4f.m01 * matrix4f2.m30 + matrix4f.m11 * matrix4f2.m31 + matrix4f.m21 * matrix4f2.m32 + matrix4f.m31 * matrix4f2.m33;
            float f9 = matrix4f.m02 * matrix4f2.m00 + matrix4f.m12 * matrix4f2.m01 + matrix4f.m22 * matrix4f2.m02 + matrix4f.m32 * matrix4f2.m03;
            float f10 = matrix4f.m02 * matrix4f2.m10 + matrix4f.m12 * matrix4f2.m11 + matrix4f.m22 * matrix4f2.m12 + matrix4f.m32 * matrix4f2.m13;
            float f11 = matrix4f.m02 * matrix4f2.m20 + matrix4f.m12 * matrix4f2.m21 + matrix4f.m22 * matrix4f2.m22 + matrix4f.m32 * matrix4f2.m23;
            float f12 = matrix4f.m02 * matrix4f2.m30 + matrix4f.m12 * matrix4f2.m31 + matrix4f.m22 * matrix4f2.m32 + matrix4f.m32 * matrix4f2.m33;
            float f13 = matrix4f.m03 * matrix4f2.m00 + matrix4f.m13 * matrix4f2.m01 + matrix4f.m23 * matrix4f2.m02 + matrix4f.m33 * matrix4f2.m03;
            float f14 = matrix4f.m03 * matrix4f2.m10 + matrix4f.m13 * matrix4f2.m11 + matrix4f.m23 * matrix4f2.m12 + matrix4f.m33 * matrix4f2.m13;
            float f15 = matrix4f.m03 * matrix4f2.m20 + matrix4f.m13 * matrix4f2.m21 + matrix4f.m23 * matrix4f2.m22 + matrix4f.m33 * matrix4f2.m23;
            float f16 = matrix4f.m03 * matrix4f2.m30 + matrix4f.m13 * matrix4f2.m31 + matrix4f.m23 * matrix4f2.m32 + matrix4f.m33 * matrix4f2.m33;
            this.m00 = f;
            this.m01 = f2;
            this.m02 = f3;
            this.m03 = f4;
            this.m10 = f5;
            this.m11 = f6;
            this.m12 = f7;
            this.m13 = f8;
            this.m20 = f9;
            this.m21 = f10;
            this.m22 = f11;
            this.m23 = f12;
            this.m30 = f13;
            this.m31 = f14;
            this.m32 = f15;
            this.m33 = f16;
        }
    }

    public final void mulTransposeRight(Matrix4f matrix4f, Matrix4f matrix4f2) {
        if (this != matrix4f && this != matrix4f2) {
            this.m00 = matrix4f.m00 * matrix4f2.m00 + matrix4f.m01 * matrix4f2.m01 + matrix4f.m02 * matrix4f2.m02 + matrix4f.m03 * matrix4f2.m03;
            this.m01 = matrix4f.m00 * matrix4f2.m10 + matrix4f.m01 * matrix4f2.m11 + matrix4f.m02 * matrix4f2.m12 + matrix4f.m03 * matrix4f2.m13;
            this.m02 = matrix4f.m00 * matrix4f2.m20 + matrix4f.m01 * matrix4f2.m21 + matrix4f.m02 * matrix4f2.m22 + matrix4f.m03 * matrix4f2.m23;
            this.m03 = matrix4f.m00 * matrix4f2.m30 + matrix4f.m01 * matrix4f2.m31 + matrix4f.m02 * matrix4f2.m32 + matrix4f.m03 * matrix4f2.m33;
            this.m10 = matrix4f.m10 * matrix4f2.m00 + matrix4f.m11 * matrix4f2.m01 + matrix4f.m12 * matrix4f2.m02 + matrix4f.m13 * matrix4f2.m03;
            this.m11 = matrix4f.m10 * matrix4f2.m10 + matrix4f.m11 * matrix4f2.m11 + matrix4f.m12 * matrix4f2.m12 + matrix4f.m13 * matrix4f2.m13;
            this.m12 = matrix4f.m10 * matrix4f2.m20 + matrix4f.m11 * matrix4f2.m21 + matrix4f.m12 * matrix4f2.m22 + matrix4f.m13 * matrix4f2.m23;
            this.m13 = matrix4f.m10 * matrix4f2.m30 + matrix4f.m11 * matrix4f2.m31 + matrix4f.m12 * matrix4f2.m32 + matrix4f.m13 * matrix4f2.m33;
            this.m20 = matrix4f.m20 * matrix4f2.m00 + matrix4f.m21 * matrix4f2.m01 + matrix4f.m22 * matrix4f2.m02 + matrix4f.m23 * matrix4f2.m03;
            this.m21 = matrix4f.m20 * matrix4f2.m10 + matrix4f.m21 * matrix4f2.m11 + matrix4f.m22 * matrix4f2.m12 + matrix4f.m23 * matrix4f2.m13;
            this.m22 = matrix4f.m20 * matrix4f2.m20 + matrix4f.m21 * matrix4f2.m21 + matrix4f.m22 * matrix4f2.m22 + matrix4f.m23 * matrix4f2.m23;
            this.m23 = matrix4f.m20 * matrix4f2.m30 + matrix4f.m21 * matrix4f2.m31 + matrix4f.m22 * matrix4f2.m32 + matrix4f.m23 * matrix4f2.m33;
            this.m30 = matrix4f.m30 * matrix4f2.m00 + matrix4f.m31 * matrix4f2.m01 + matrix4f.m32 * matrix4f2.m02 + matrix4f.m33 * matrix4f2.m03;
            this.m31 = matrix4f.m30 * matrix4f2.m10 + matrix4f.m31 * matrix4f2.m11 + matrix4f.m32 * matrix4f2.m12 + matrix4f.m33 * matrix4f2.m13;
            this.m32 = matrix4f.m30 * matrix4f2.m20 + matrix4f.m31 * matrix4f2.m21 + matrix4f.m32 * matrix4f2.m22 + matrix4f.m33 * matrix4f2.m23;
            this.m33 = matrix4f.m30 * matrix4f2.m30 + matrix4f.m31 * matrix4f2.m31 + matrix4f.m32 * matrix4f2.m32 + matrix4f.m33 * matrix4f2.m33;
        } else {
            float f = matrix4f.m00 * matrix4f2.m00 + matrix4f.m01 * matrix4f2.m01 + matrix4f.m02 * matrix4f2.m02 + matrix4f.m03 * matrix4f2.m03;
            float f2 = matrix4f.m00 * matrix4f2.m10 + matrix4f.m01 * matrix4f2.m11 + matrix4f.m02 * matrix4f2.m12 + matrix4f.m03 * matrix4f2.m13;
            float f3 = matrix4f.m00 * matrix4f2.m20 + matrix4f.m01 * matrix4f2.m21 + matrix4f.m02 * matrix4f2.m22 + matrix4f.m03 * matrix4f2.m23;
            float f4 = matrix4f.m00 * matrix4f2.m30 + matrix4f.m01 * matrix4f2.m31 + matrix4f.m02 * matrix4f2.m32 + matrix4f.m03 * matrix4f2.m33;
            float f5 = matrix4f.m10 * matrix4f2.m00 + matrix4f.m11 * matrix4f2.m01 + matrix4f.m12 * matrix4f2.m02 + matrix4f.m13 * matrix4f2.m03;
            float f6 = matrix4f.m10 * matrix4f2.m10 + matrix4f.m11 * matrix4f2.m11 + matrix4f.m12 * matrix4f2.m12 + matrix4f.m13 * matrix4f2.m13;
            float f7 = matrix4f.m10 * matrix4f2.m20 + matrix4f.m11 * matrix4f2.m21 + matrix4f.m12 * matrix4f2.m22 + matrix4f.m13 * matrix4f2.m23;
            float f8 = matrix4f.m10 * matrix4f2.m30 + matrix4f.m11 * matrix4f2.m31 + matrix4f.m12 * matrix4f2.m32 + matrix4f.m13 * matrix4f2.m33;
            float f9 = matrix4f.m20 * matrix4f2.m00 + matrix4f.m21 * matrix4f2.m01 + matrix4f.m22 * matrix4f2.m02 + matrix4f.m23 * matrix4f2.m03;
            float f10 = matrix4f.m20 * matrix4f2.m10 + matrix4f.m21 * matrix4f2.m11 + matrix4f.m22 * matrix4f2.m12 + matrix4f.m23 * matrix4f2.m13;
            float f11 = matrix4f.m20 * matrix4f2.m20 + matrix4f.m21 * matrix4f2.m21 + matrix4f.m22 * matrix4f2.m22 + matrix4f.m23 * matrix4f2.m23;
            float f12 = matrix4f.m20 * matrix4f2.m30 + matrix4f.m21 * matrix4f2.m31 + matrix4f.m22 * matrix4f2.m32 + matrix4f.m23 * matrix4f2.m33;
            float f13 = matrix4f.m30 * matrix4f2.m00 + matrix4f.m31 * matrix4f2.m01 + matrix4f.m32 * matrix4f2.m02 + matrix4f.m33 * matrix4f2.m03;
            float f14 = matrix4f.m30 * matrix4f2.m10 + matrix4f.m31 * matrix4f2.m11 + matrix4f.m32 * matrix4f2.m12 + matrix4f.m33 * matrix4f2.m13;
            float f15 = matrix4f.m30 * matrix4f2.m20 + matrix4f.m31 * matrix4f2.m21 + matrix4f.m32 * matrix4f2.m22 + matrix4f.m33 * matrix4f2.m23;
            float f16 = matrix4f.m30 * matrix4f2.m30 + matrix4f.m31 * matrix4f2.m31 + matrix4f.m32 * matrix4f2.m32 + matrix4f.m33 * matrix4f2.m33;
            this.m00 = f;
            this.m01 = f2;
            this.m02 = f3;
            this.m03 = f4;
            this.m10 = f5;
            this.m11 = f6;
            this.m12 = f7;
            this.m13 = f8;
            this.m20 = f9;
            this.m21 = f10;
            this.m22 = f11;
            this.m23 = f12;
            this.m30 = f13;
            this.m31 = f14;
            this.m32 = f15;
            this.m33 = f16;
        }
    }

    public final void mulTransposeLeft(Matrix4f matrix4f, Matrix4f matrix4f2) {
        if (this != matrix4f && this != matrix4f2) {
            this.m00 = matrix4f.m00 * matrix4f2.m00 + matrix4f.m10 * matrix4f2.m10 + matrix4f.m20 * matrix4f2.m20 + matrix4f.m30 * matrix4f2.m30;
            this.m01 = matrix4f.m00 * matrix4f2.m01 + matrix4f.m10 * matrix4f2.m11 + matrix4f.m20 * matrix4f2.m21 + matrix4f.m30 * matrix4f2.m31;
            this.m02 = matrix4f.m00 * matrix4f2.m02 + matrix4f.m10 * matrix4f2.m12 + matrix4f.m20 * matrix4f2.m22 + matrix4f.m30 * matrix4f2.m32;
            this.m03 = matrix4f.m00 * matrix4f2.m03 + matrix4f.m10 * matrix4f2.m13 + matrix4f.m20 * matrix4f2.m23 + matrix4f.m30 * matrix4f2.m33;
            this.m10 = matrix4f.m01 * matrix4f2.m00 + matrix4f.m11 * matrix4f2.m10 + matrix4f.m21 * matrix4f2.m20 + matrix4f.m31 * matrix4f2.m30;
            this.m11 = matrix4f.m01 * matrix4f2.m01 + matrix4f.m11 * matrix4f2.m11 + matrix4f.m21 * matrix4f2.m21 + matrix4f.m31 * matrix4f2.m31;
            this.m12 = matrix4f.m01 * matrix4f2.m02 + matrix4f.m11 * matrix4f2.m12 + matrix4f.m21 * matrix4f2.m22 + matrix4f.m31 * matrix4f2.m32;
            this.m13 = matrix4f.m01 * matrix4f2.m03 + matrix4f.m11 * matrix4f2.m13 + matrix4f.m21 * matrix4f2.m23 + matrix4f.m31 * matrix4f2.m33;
            this.m20 = matrix4f.m02 * matrix4f2.m00 + matrix4f.m12 * matrix4f2.m10 + matrix4f.m22 * matrix4f2.m20 + matrix4f.m32 * matrix4f2.m30;
            this.m21 = matrix4f.m02 * matrix4f2.m01 + matrix4f.m12 * matrix4f2.m11 + matrix4f.m22 * matrix4f2.m21 + matrix4f.m32 * matrix4f2.m31;
            this.m22 = matrix4f.m02 * matrix4f2.m02 + matrix4f.m12 * matrix4f2.m12 + matrix4f.m22 * matrix4f2.m22 + matrix4f.m32 * matrix4f2.m32;
            this.m23 = matrix4f.m02 * matrix4f2.m03 + matrix4f.m12 * matrix4f2.m13 + matrix4f.m22 * matrix4f2.m23 + matrix4f.m32 * matrix4f2.m33;
            this.m30 = matrix4f.m03 * matrix4f2.m00 + matrix4f.m13 * matrix4f2.m10 + matrix4f.m23 * matrix4f2.m20 + matrix4f.m33 * matrix4f2.m30;
            this.m31 = matrix4f.m03 * matrix4f2.m01 + matrix4f.m13 * matrix4f2.m11 + matrix4f.m23 * matrix4f2.m21 + matrix4f.m33 * matrix4f2.m31;
            this.m32 = matrix4f.m03 * matrix4f2.m02 + matrix4f.m13 * matrix4f2.m12 + matrix4f.m23 * matrix4f2.m22 + matrix4f.m33 * matrix4f2.m32;
            this.m33 = matrix4f.m03 * matrix4f2.m03 + matrix4f.m13 * matrix4f2.m13 + matrix4f.m23 * matrix4f2.m23 + matrix4f.m33 * matrix4f2.m33;
        } else {
            float f = matrix4f.m00 * matrix4f2.m00 + matrix4f.m10 * matrix4f2.m10 + matrix4f.m20 * matrix4f2.m20 + matrix4f.m30 * matrix4f2.m30;
            float f2 = matrix4f.m00 * matrix4f2.m01 + matrix4f.m10 * matrix4f2.m11 + matrix4f.m20 * matrix4f2.m21 + matrix4f.m30 * matrix4f2.m31;
            float f3 = matrix4f.m00 * matrix4f2.m02 + matrix4f.m10 * matrix4f2.m12 + matrix4f.m20 * matrix4f2.m22 + matrix4f.m30 * matrix4f2.m32;
            float f4 = matrix4f.m00 * matrix4f2.m03 + matrix4f.m10 * matrix4f2.m13 + matrix4f.m20 * matrix4f2.m23 + matrix4f.m30 * matrix4f2.m33;
            float f5 = matrix4f.m01 * matrix4f2.m00 + matrix4f.m11 * matrix4f2.m10 + matrix4f.m21 * matrix4f2.m20 + matrix4f.m31 * matrix4f2.m30;
            float f6 = matrix4f.m01 * matrix4f2.m01 + matrix4f.m11 * matrix4f2.m11 + matrix4f.m21 * matrix4f2.m21 + matrix4f.m31 * matrix4f2.m31;
            float f7 = matrix4f.m01 * matrix4f2.m02 + matrix4f.m11 * matrix4f2.m12 + matrix4f.m21 * matrix4f2.m22 + matrix4f.m31 * matrix4f2.m32;
            float f8 = matrix4f.m01 * matrix4f2.m03 + matrix4f.m11 * matrix4f2.m13 + matrix4f.m21 * matrix4f2.m23 + matrix4f.m31 * matrix4f2.m33;
            float f9 = matrix4f.m02 * matrix4f2.m00 + matrix4f.m12 * matrix4f2.m10 + matrix4f.m22 * matrix4f2.m20 + matrix4f.m32 * matrix4f2.m30;
            float f10 = matrix4f.m02 * matrix4f2.m01 + matrix4f.m12 * matrix4f2.m11 + matrix4f.m22 * matrix4f2.m21 + matrix4f.m32 * matrix4f2.m31;
            float f11 = matrix4f.m02 * matrix4f2.m02 + matrix4f.m12 * matrix4f2.m12 + matrix4f.m22 * matrix4f2.m22 + matrix4f.m32 * matrix4f2.m32;
            float f12 = matrix4f.m02 * matrix4f2.m03 + matrix4f.m12 * matrix4f2.m13 + matrix4f.m22 * matrix4f2.m23 + matrix4f.m32 * matrix4f2.m33;
            float f13 = matrix4f.m03 * matrix4f2.m00 + matrix4f.m13 * matrix4f2.m10 + matrix4f.m23 * matrix4f2.m20 + matrix4f.m33 * matrix4f2.m30;
            float f14 = matrix4f.m03 * matrix4f2.m01 + matrix4f.m13 * matrix4f2.m11 + matrix4f.m23 * matrix4f2.m21 + matrix4f.m33 * matrix4f2.m31;
            float f15 = matrix4f.m03 * matrix4f2.m02 + matrix4f.m13 * matrix4f2.m12 + matrix4f.m23 * matrix4f2.m22 + matrix4f.m33 * matrix4f2.m32;
            float f16 = matrix4f.m03 * matrix4f2.m03 + matrix4f.m13 * matrix4f2.m13 + matrix4f.m23 * matrix4f2.m23 + matrix4f.m33 * matrix4f2.m33;
            this.m00 = f;
            this.m01 = f2;
            this.m02 = f3;
            this.m03 = f4;
            this.m10 = f5;
            this.m11 = f6;
            this.m12 = f7;
            this.m13 = f8;
            this.m20 = f9;
            this.m21 = f10;
            this.m22 = f11;
            this.m23 = f12;
            this.m30 = f13;
            this.m31 = f14;
            this.m32 = f15;
            this.m33 = f16;
        }
    }

    public boolean equals(Matrix4f matrix4f) {
        try {
            return this.m00 == matrix4f.m00 && this.m01 == matrix4f.m01 && this.m02 == matrix4f.m02 && this.m03 == matrix4f.m03 && this.m10 == matrix4f.m10 && this.m11 == matrix4f.m11 && this.m12 == matrix4f.m12 && this.m13 == matrix4f.m13 && this.m20 == matrix4f.m20 && this.m21 == matrix4f.m21 && this.m22 == matrix4f.m22 && this.m23 == matrix4f.m23 && this.m30 == matrix4f.m30 && this.m31 == matrix4f.m31 && this.m32 == matrix4f.m32 && this.m33 == matrix4f.m33;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean equals(Object object) {
        try {
            Matrix4f matrix4f = (Matrix4f)object;
            return this.m00 == matrix4f.m00 && this.m01 == matrix4f.m01 && this.m02 == matrix4f.m02 && this.m03 == matrix4f.m03 && this.m10 == matrix4f.m10 && this.m11 == matrix4f.m11 && this.m12 == matrix4f.m12 && this.m13 == matrix4f.m13 && this.m20 == matrix4f.m20 && this.m21 == matrix4f.m21 && this.m22 == matrix4f.m22 && this.m23 == matrix4f.m23 && this.m30 == matrix4f.m30 && this.m31 == matrix4f.m31 && this.m32 == matrix4f.m32 && this.m33 == matrix4f.m33;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean epsilonEquals(Matrix4f matrix4f, float f) {
        boolean bl = true;
        if (Matrix4f.\u6dff("\ua290", (float)(this.m00 - matrix4f.m00)) > f) {
            bl = false;
        }
        if (Matrix4f.\u6dff("\ua290", (float)(this.m01 - matrix4f.m01)) > f) {
            bl = false;
        }
        if (Matrix4f.\u6dff("\ua290", (float)(this.m02 - matrix4f.m02)) > f) {
            bl = false;
        }
        if (Matrix4f.\u6dff("\ua290", (float)(this.m03 - matrix4f.m03)) > f) {
            bl = false;
        }
        if (Matrix4f.\u6dff("\ua290", (float)(this.m10 - matrix4f.m10)) > f) {
            bl = false;
        }
        if (Matrix4f.\u6dff("\ua290", (float)(this.m11 - matrix4f.m11)) > f) {
            bl = false;
        }
        if (Matrix4f.\u6dff("\ua290", (float)(this.m12 - matrix4f.m12)) > f) {
            bl = false;
        }
        if (Matrix4f.\u6dff("\ua290", (float)(this.m13 - matrix4f.m13)) > f) {
            bl = false;
        }
        if (Matrix4f.\u6dff("\ua290", (float)(this.m20 - matrix4f.m20)) > f) {
            bl = false;
        }
        if (Matrix4f.\u6dff("\ua290", (float)(this.m21 - matrix4f.m21)) > f) {
            bl = false;
        }
        if (Matrix4f.\u6dff("\ua290", (float)(this.m22 - matrix4f.m22)) > f) {
            bl = false;
        }
        if (Matrix4f.\u6dff("\ua290", (float)(this.m23 - matrix4f.m23)) > f) {
            bl = false;
        }
        if (Matrix4f.\u6dff("\ua290", (float)(this.m30 - matrix4f.m30)) > f) {
            bl = false;
        }
        if (Matrix4f.\u6dff("\ua290", (float)(this.m31 - matrix4f.m31)) > f) {
            bl = false;
        }
        if (Matrix4f.\u6dff("\ua290", (float)(this.m32 - matrix4f.m32)) > f) {
            bl = false;
        }
        if (Matrix4f.\u6dff("\ua290", (float)(this.m33 - matrix4f.m33)) > f) {
            bl = false;
        }
        return bl;
    }

    public final void transform(Vector3f vector3f, Vector3f vector3f2) {
        float f = this.m00 * vector3f.x + this.m01 * vector3f.y + this.m02 * vector3f.z;
        float f2 = this.m10 * vector3f.x + this.m11 * vector3f.y + this.m12 * vector3f.z;
        vector3f2.z = this.m20 * vector3f.x + this.m21 * vector3f.y + this.m22 * vector3f.z;
        vector3f2.x = f;
        vector3f2.y = f2;
    }

    public final void transform(Vector3f vector3f) {
        float f = this.m00 * vector3f.x + this.m01 * vector3f.y + this.m02 * vector3f.z;
        float f2 = this.m10 * vector3f.x + this.m11 * vector3f.y + this.m12 * vector3f.z;
        vector3f.z = this.m20 * vector3f.x + this.m21 * vector3f.y + this.m22 * vector3f.z;
        vector3f.x = f;
        vector3f.y = f2;
    }

    public final void setRotation(Matrix3f matrix3f) {
        double[] dArray = new double[9];
        double[] dArray2 = new double[3];
        this.getScaleRotate(dArray2, dArray);
        this.m00 = (float)((double)matrix3f.m00 * dArray2[0]);
        this.m01 = (float)((double)matrix3f.m01 * dArray2[1]);
        this.m02 = (float)((double)matrix3f.m02 * dArray2[2]);
        this.m10 = (float)((double)matrix3f.m10 * dArray2[0]);
        this.m11 = (float)((double)matrix3f.m11 * dArray2[1]);
        this.m12 = (float)((double)matrix3f.m12 * dArray2[2]);
        this.m20 = (float)((double)matrix3f.m20 * dArray2[0]);
        this.m21 = (float)((double)matrix3f.m21 * dArray2[1]);
        this.m22 = (float)((double)matrix3f.m22 * dArray2[2]);
    }

    public final void setRotation(Quaternion quaternion) {
        double[] dArray = new double[9];
        double[] dArray2 = new double[3];
        this.getScaleRotate(dArray2, dArray);
        this.m00 = (float)((double)(1.0f - 2.0f * quaternion.y * quaternion.y - 2.0f * quaternion.z * quaternion.z) * dArray2[0]);
        this.m10 = (float)((double)(2.0f * (quaternion.x * quaternion.y + quaternion.w * quaternion.z)) * dArray2[0]);
        this.m20 = (float)((double)(2.0f * (quaternion.x * quaternion.z - quaternion.w * quaternion.y)) * dArray2[0]);
        this.m01 = (float)((double)(2.0f * (quaternion.x * quaternion.y - quaternion.w * quaternion.z)) * dArray2[1]);
        this.m11 = (float)((double)(1.0f - 2.0f * quaternion.x * quaternion.x - 2.0f * quaternion.z * quaternion.z) * dArray2[1]);
        this.m21 = (float)((double)(2.0f * (quaternion.y * quaternion.z + quaternion.w * quaternion.x)) * dArray2[1]);
        this.m02 = (float)((double)(2.0f * (quaternion.x * quaternion.z + quaternion.w * quaternion.y)) * dArray2[2]);
        this.m12 = (float)((double)(2.0f * (quaternion.y * quaternion.z - quaternion.w * quaternion.x)) * dArray2[2]);
        this.m22 = (float)((double)(1.0f - 2.0f * quaternion.x * quaternion.x - 2.0f * quaternion.y * quaternion.y) * dArray2[2]);
    }

    public final void setRotation(AxisAngle4f axisAngle4f) {
        double[] dArray = new double[9];
        double[] dArray2 = new double[3];
        this.getScaleRotate(dArray2, dArray);
        Object object = Matrix4f.\u86e4("\u3567", (double)(axisAngle4f.x * axisAngle4f.x + axisAngle4f.y * axisAngle4f.y + axisAngle4f.z * axisAngle4f.z));
        if (object < 1.0E-8) {
            this.m00 = 1.0f;
            this.m01 = 0.0f;
            this.m02 = 0.0f;
            this.m10 = 0.0f;
            this.m11 = 1.0f;
            this.m12 = 0.0f;
            this.m20 = 0.0f;
            this.m21 = 0.0f;
            this.m22 = 1.0f;
        } else {
            object = 1.0 / object;
            double d = (double)axisAngle4f.x * object;
            double d2 = (double)axisAngle4f.y * object;
            double d3 = (double)axisAngle4f.z * object;
            Object object2 = Matrix4f.\u359d("\ufa1a", (double)axisAngle4f.angle);
            Object object3 = Matrix4f.\u4651("\u5215", (double)axisAngle4f.angle);
            double d4 = 1.0 - object3;
            double d5 = axisAngle4f.x * axisAngle4f.z;
            double d6 = axisAngle4f.x * axisAngle4f.y;
            double d7 = axisAngle4f.y * axisAngle4f.z;
            this.m00 = (float)((d4 * d * d + object3) * dArray2[0]);
            this.m01 = (float)((d4 * d6 - object2 * d3) * dArray2[1]);
            this.m02 = (float)((d4 * d5 + object2 * d2) * dArray2[2]);
            this.m10 = (float)((d4 * d6 + object2 * d3) * dArray2[0]);
            this.m11 = (float)((d4 * d2 * d2 + object3) * dArray2[1]);
            this.m12 = (float)((d4 * d7 - object2 * d) * dArray2[2]);
            this.m20 = (float)((d4 * d5 - object2 * d2) * dArray2[0]);
            this.m21 = (float)((d4 * d7 + object2 * d) * dArray2[1]);
            this.m22 = (float)((d4 * d3 * d3 + object3) * dArray2[2]);
        }
    }

    public final void setZero() {
        this.m00 = 0.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 0.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 0.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 0.0f;
    }

    public final void negate() {
        this.m00 = -this.m00;
        this.m01 = -this.m01;
        this.m02 = -this.m02;
        this.m03 = -this.m03;
        this.m10 = -this.m10;
        this.m11 = -this.m11;
        this.m12 = -this.m12;
        this.m13 = -this.m13;
        this.m20 = -this.m20;
        this.m21 = -this.m21;
        this.m22 = -this.m22;
        this.m23 = -this.m23;
        this.m30 = -this.m30;
        this.m31 = -this.m31;
        this.m32 = -this.m32;
        this.m33 = -this.m33;
    }

    public final void negate(Matrix4f matrix4f) {
        this.m00 = -matrix4f.m00;
        this.m01 = -matrix4f.m01;
        this.m02 = -matrix4f.m02;
        this.m03 = -matrix4f.m03;
        this.m10 = -matrix4f.m10;
        this.m11 = -matrix4f.m11;
        this.m12 = -matrix4f.m12;
        this.m13 = -matrix4f.m13;
        this.m20 = -matrix4f.m20;
        this.m21 = -matrix4f.m21;
        this.m22 = -matrix4f.m22;
        this.m23 = -matrix4f.m23;
        this.m30 = -matrix4f.m30;
        this.m31 = -matrix4f.m31;
        this.m32 = -matrix4f.m32;
        this.m33 = -matrix4f.m33;
    }

    private final void getScaleRotate(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22};
        Matrix4f.\u9de8("\u64d6", (double[])dArray3, (double[])dArray, (double[])dArray2);
    }

    public Object clone() {
        Matrix4f matrix4f = null;
        try {
            matrix4f = (Matrix4f)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return matrix4f;
    }

    public final float getM00() {
        return this.m00;
    }

    public final void setM00(float f) {
        this.m00 = f;
    }

    public final float getM01() {
        return this.m01;
    }

    public final void setM01(float f) {
        this.m01 = f;
    }

    public final float getM02() {
        return this.m02;
    }

    public final void setM02(float f) {
        this.m02 = f;
    }

    public final float getM10() {
        return this.m10;
    }

    public final void setM10(float f) {
        this.m10 = f;
    }

    public final float getM11() {
        return this.m11;
    }

    public final void setM11(float f) {
        this.m11 = f;
    }

    public final float getM12() {
        return this.m12;
    }

    public final void setM12(float f) {
        this.m12 = f;
    }

    public final float getM20() {
        return this.m20;
    }

    public final void setM20(float f) {
        this.m20 = f;
    }

    public final float getM21() {
        return this.m21;
    }

    public final void setM21(float f) {
        this.m21 = f;
    }

    public final float getM22() {
        return this.m22;
    }

    public final void setM22(float f) {
        this.m22 = f;
    }

    public final float getM03() {
        return this.m03;
    }

    public final void setM03(float f) {
        this.m03 = f;
    }

    public final float getM13() {
        return this.m13;
    }

    public final void setM13(float f) {
        this.m13 = f;
    }

    public final float getM23() {
        return this.m23;
    }

    public final void setM23(float f) {
        this.m23 = f;
    }

    public final float getM30() {
        return this.m30;
    }

    public final void setM30(float f) {
        this.m30 = f;
    }

    public final float getM31() {
        return this.m31;
    }

    public final void setM31(float f) {
        this.m31 = f;
    }

    public final float getM32() {
        return this.m32;
    }

    public final void setM32(float f) {
        this.m32 = f;
    }

    public final float getM33() {
        return this.m33;
    }

    public final void setM33(float f) {
        this.m33 = f;
    }

    public final float[] intoArray() {
        float[] fArray = new float[]{this.m00, this.m01, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23, this.m30, this.m31, this.m32, this.m33};
        return fArray;
    }

    public final boolean isEmptyRotationMatrix() {
        if (this.m00 == 1.0f && this.m11 == 1.0f && this.m22 == 1.0f) {
            float[] fArray = this.intoArray();
            boolean bl = true;
            for (int i = 0; i < fArray.length; ++i) {
                if (i == 0 || i == 5 || i == 10 || i > 10 || fArray[i] == 0.0f) continue;
                bl = false;
                break;
            }
            return bl;
        }
        return false;
    }

    private static Object \uc8e6(Object object, String string, MethodType methodType) {
        if (\ufb75 == null) {
            \ufb75 = new Object[11];
        }
        if (\ufb75[10] == null) {
            Matrix4f.\ufb75[10] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(Vector3f$Matrix3d.\u9c53("\u985e\u0f6b\u9944\ue00e\ue4ac\u471d\uee6c\u032e\uc8a4\u56c5\u5127\u95cb\ud9cc\u3d78\u9746\u412e\u69be\u7f22\u2805\u12ac\uef1e\uf90b\ubf66")), Vector3f$Matrix3d.\u9c53("\u9855\u0f7a\u9942\ue00a\ue4ec\u4715"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ufb75[10];
    }

    private static Object \u9161(Object object, String string, MethodType methodType) {
        if (\ufb75 == null) {
            \ufb75 = new Object[11];
        }
        if (\ufb75[9] == null) {
            Matrix4f.\ufb75[9] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(Matrix3f$Matrix3d.\u610c("\u1222\ua570\u7ee2\u8ee7\u1db9\u4d95\uf93c\u4125\u8f9f\u0492\u035b\ub3b3\u4a19\u77d5\ub341\u0bd7\u6f30\uc483\ubf35\u36d5\uddc9\u48e1\u867a")), Matrix3f$Matrix3d.\u610c("\u123c\ua57e\u7ec7\u8ef2\u1de5\u4d90\uf933\u412c"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ufb75[9];
    }

    private static Object \ud6a9(Object object, String string, MethodType methodType) {
        if (\ufb75 == null) {
            \ufb75 = new Object[11];
        }
        if (\ufb75[5] == null) {
            Matrix4f.\ufb75[5] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(AxisAngle4f$Matrix4f.\ufb61("\u363a\u2566\u5531\uf3d4\u8aea\u9a6f\ud755\u4c92\u3057\u3b76\u2d1a\u27da\ud2c3\uc9a6\u9068\u99f2\ueeff\uf1fa\u1f6f")), AxisAngle4f$Matrix4f.\ufb61("\u3620\u2575\u552e\uf3db\u8ab0\u9a50\ud740\u4c9d\u3053\u3b33\u2d0b\u27d0\ud2c1\uc9a0\u907d"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ufb75[5];
    }

    private static Object \ub4d5(Object object, String string, MethodType methodType) {
        if (\ufb75 == null) {
            \ufb75 = new Object[11];
        }
        if (\ufb75[2] == null) {
            Matrix4f.\ufb75[2] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(Vector3f$Matrix3d.\u9c53("\u985e\u0f6b\u9944\ue00e\ue4ac\u471d\uee6c\u032e\uc8a4\u56c5\u5139\u95de\ud9ca\u3d79")), Vector3f$Matrix3d.\u9c53("\u9855\u0f68\u9941"), methodType).asType(methodType));
        }
        return \ufb75[2];
    }

    private static Object \u4651(Object object, String string, MethodType methodType) {
        if (\ufb75 == null) {
            \ufb75 = new Object[11];
        }
        if (\ufb75[0] == null) {
            Matrix4f.\ufb75[0] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(AxisAngle4f$Matrix4f.\ufb61("\u363a\u2566\u5531\uf3d4\u8aea\u9a6f\ud755\u4c92\u3057\u3b76\u2d12\u27c3\ud2d4\uc9ab")), AxisAngle4f$Matrix4f.\ufb61("\u3633\u2568\u5534"), methodType).asType(methodType));
        }
        return \ufb75[0];
    }

    private static Object \u6249(Object object, String string, MethodType methodType) {
        if (\ufb75 == null) {
            \ufb75 = new Object[11];
        }
        if (\ufb75[6] == null) {
            Matrix4f.\ufb75[6] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(Matrix3f$Matrix3d.\u610c("\u1222\ua570\u7ee2\u8ee7\u1db9\u4d95\uf93c\u4125\u8f9f\u0492\u035b\ub3b3\u4a19\u77d5\ub341\u0bd7\u6f30\uc483\ubf35\u36d5\uddc9\u48e1\u867a")), Matrix3f$Matrix3d.\u610c("\u1229\ua561\u7ee4\u8ee3\u1df9\u4d9d"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ufb75[6];
    }

    private static Object \u359d(Object object, String string, MethodType methodType) {
        if (\ufb75 == null) {
            \ufb75 = new Object[11];
        }
        if (\ufb75[4] == null) {
            Matrix4f.\ufb75[4] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(AxisAngle4f$Matrix3d.\u6dd0("\u4afd\u0f95\uab4a\ua59c\u9eba\u1f18\u5496\uc54b\u6ccd\ueaec\uf1e7\uf5f8\u33fc\u92cd")), AxisAngle4f$Matrix3d.\u6dd0("\u4ae4\u0f9d\uab52"), methodType).asType(methodType));
        }
        return \ufb75[4];
    }

    private static Object \u9de8(Object object, String string, MethodType methodType) {
        if (\ufb75 == null) {
            \ufb75 = new Object[11];
        }
        if (\ufb75[3] == null) {
            Matrix4f.\ufb75[3] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(AxisAngle4f$Matrix4f.\ufb61("\u3637\u2566\u552b\uf3d4\u8abc\u9a7a\ud747\u4c8c\u3051\u3b3b\u2d3a\u278c\ud2c3\uc9ac\u906a\u99e3\ueeb8\uf1f4\u1f6f\u1d42\ua2c7\u0844\u6baa\ud30d\u52d5\ueeba\u1e47\u0379\u5c5e\u5db5\ud2b7\u7e98\u15f7\u09de\ue38d\ubedd\ud00b\u8200\u58d7\uc01e\ud83e\u8ce8\u0de6\u68b6\u0593\ufa7d\ua5d1\uf2d1\ub678\uc798\u4542\uc5d0\uc0d3\u0c12\u6c4d\u511c\u838c\ufac4")), AxisAngle4f$Matrix4f.\ufb61("\u3633\u2568\u552a\uf3c5\u8ab1\u9a77\ud751\u4ca3\u3043\u3b2e\u2d3b"), methodType).asType(methodType));
        }
        return \ufb75[3];
    }

    private static Object \u997c(Object object, String string, MethodType methodType) {
        if (\ufb75 == null) {
            \ufb75 = new Object[11];
        }
        if (\ufb75[7] == null) {
            Matrix4f.\ufb75[7] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(Vector3f$Matrix3d.\u9c53("\u9853\u0f6b\u995e\ue00e\ue4fa\u4708\uee7e\u0330\uc8a2\u5688\u5111\u9591\ud9dd\u3d7e\u975a\u412c\u69d2\u7f36\u2802\u12a9\uef17\uf90f\ubf60\uacbd\u39da\u39fa\u4688\ue33f\ube6e\u3a6b\u6f6b\u46c5\uc040\u1bbe\udc24\u4349\u4bd0\u481e\ub90a\ufd2f\u68b9\u7929\u8839\u077e\u79db\uc118\u32bd\uada3\u14d0\ubf2d\u27a3\u7fe5\u1464\u2a5b\u0811\uf46d\ue97b\u0788")), Vector3f$Matrix3d.\u9c53("\u9859\u0f6b\u994a\ue05c"), methodType).asType(methodType));
        }
        return \ufb75[7];
    }

    private static Object \u6dff(Object object, String string, MethodType methodType) {
        if (\ufb75 == null) {
            \ufb75 = new Object[11];
        }
        if (\ufb75[8] == null) {
            Matrix4f.\ufb75[8] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(AxisAngle4f$Matrix4f.\ufb61("\u363a\u2566\u5531\uf3d4\u8aea\u9a6f\ud755\u4c92\u3057\u3b76\u2d12\u27c3\ud2d4\uc9ab")), AxisAngle4f$Matrix4f.\ufb61("\u3631\u2565\u5534"), methodType).asType(methodType));
        }
        return \ufb75[8];
    }

    private static Object \u86e4(Object object, String string, MethodType methodType) {
        if (\ufb75 == null) {
            \ufb75 = new Object[11];
        }
        if (\ufb75[1] == null) {
            Matrix4f.\ufb75[1] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(Matrix3f$Matrix3d.\u610c("\u1222\ua570\u7ee2\u8ee7\u1db9\u4d95\uf93c\u4125\u8f9f\u0492\u0345\ub3a6\u4a1f\u77d4")), Matrix3f$Matrix3d.\u610c("\u123b\ua560\u7ee6\u8ef2"), methodType).asType(methodType));
        }
        return \ufb75[1];
    }
}

