/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.animations.MCACommonLibrary.math;

import galaxyspace.core.animations.MCACommonLibrary.math.AxisAngle4f$Matrix3d;
import galaxyspace.core.animations.MCACommonLibrary.math.AxisAngle4f$Matrix4f;
import galaxyspace.core.animations.MCACommonLibrary.math.Matrix3f$Matrix3d;
import galaxyspace.core.animations.MCACommonLibrary.math.Matrix4f;
import galaxyspace.core.animations.MCACommonLibrary.math.Vector3f;
import java.io.Serializable;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public class Quaternion
implements Serializable {
    public static final Quaternion EMPTY = new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);
    static final double EPS = 1.0E-6;
    public float x;
    public float y;
    public float z;
    public float w;
    private static volatile transient Object[] \uc6d5;

    public Quaternion(float f, float f2, float f3, float f4) {
        float f5 = (float)(1.0 / Quaternion.\u41eb("\uca47", (double)(f * f + f2 * f2 + f3 * f3 + f4 * f4)));
        this.x = f * f5;
        this.y = f2 * f5;
        this.z = f3 * f5;
        this.w = f4 * f5;
    }

    public Quaternion() {
        this(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Quaternion(Quaternion quaternion) {
        this.x = quaternion.x;
        this.y = quaternion.y;
        this.z = quaternion.z;
        this.w = quaternion.w;
    }

    public Quaternion(Vector3f vector3f, float f) {
        Object object = Quaternion.\u7269("\u78c3", (double)(f / 2.0f));
        this.x = (float)((double)vector3f.x * object);
        this.y = (float)((double)vector3f.y * object);
        this.z = (float)((double)vector3f.z * object);
        this.w = (float)Quaternion.\u7a7f("\u36cf", (double)(f / 2.0f));
    }

    public Quaternion(Matrix4f matrix4f) {
        double d = 1.0f + matrix4f.m00 + matrix4f.m11 + matrix4f.m22;
        if (d > 1.0E-8) {
            reference var4_3 = Quaternion.\u41eb("\uca47", (double)d) * 2.0;
            this.x = (float)((double)(matrix4f.m12 - matrix4f.m21) / var4_3);
            this.y = (float)((double)(matrix4f.m02 - matrix4f.m20) / var4_3);
            this.z = (float)((double)(matrix4f.m10 - matrix4f.m01) / var4_3);
            this.w = (float)(0.25 * var4_3);
        } else if (d == 0.0) {
            if (matrix4f.m00 > matrix4f.m11 && matrix4f.m00 > matrix4f.m22) {
                reference var4_4 = Quaternion.\u41eb("\uca47", (double)(1.0 + (double)matrix4f.m00 - (double)matrix4f.m11 - (double)matrix4f.m22)) * 2.0;
                this.x = (float)(0.25 * var4_4);
                this.y = (float)((double)(matrix4f.m10 + matrix4f.m01) / var4_4);
                this.z = (float)((double)(matrix4f.m02 + matrix4f.m20) / var4_4);
                this.w = (float)((double)(matrix4f.m21 - matrix4f.m12) / var4_4);
            } else if (matrix4f.m11 > matrix4f.m22) {
                reference var4_5 = Quaternion.\u41eb("\uca47", (double)(1.0 + (double)matrix4f.m11 - (double)matrix4f.m00 - (double)matrix4f.m22)) * 2.0;
                this.x = (float)((double)(matrix4f.m10 + matrix4f.m01) / var4_5);
                this.y = (float)(0.25 * var4_5);
                this.z = (float)((double)(matrix4f.m21 + matrix4f.m12) / var4_5);
                this.w = (float)((double)(matrix4f.m02 - matrix4f.m20) / var4_5);
            } else {
                reference var4_6 = Quaternion.\u41eb("\uca47", (double)(1.0 + (double)matrix4f.m22 - (double)matrix4f.m00 - (double)matrix4f.m11)) * 2.0;
                this.x = (float)((double)(matrix4f.m02 + matrix4f.m20) / var4_6);
                this.y = (float)((double)(matrix4f.m21 + matrix4f.m12) / var4_6);
                this.z = (float)(0.25 * var4_6);
                this.w = (float)((double)(matrix4f.m10 - matrix4f.m01) / var4_6);
            }
        }
    }

    public Quaternion set(Quaternion quaternion) {
        this.x = quaternion.x;
        this.y = quaternion.y;
        this.z = quaternion.z;
        this.w = quaternion.w;
        return this;
    }

    public final void conjugate(Quaternion quaternion) {
        this.x = -quaternion.x;
        this.y = -quaternion.y;
        this.z = -quaternion.z;
        this.w = quaternion.w;
    }

    public final void conjugate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public final void mul(Quaternion quaternion) {
        this.mul(this, quaternion);
    }

    public final void mul(Quaternion quaternion, Quaternion quaternion2) {
        if (this != quaternion && this != quaternion2) {
            this.w = quaternion.w * quaternion2.w - quaternion.x * quaternion2.x - quaternion.y * quaternion2.y - quaternion.z * quaternion2.z;
            this.x = quaternion.w * quaternion2.x + quaternion2.w * quaternion.x + quaternion.y * quaternion2.z - quaternion.z * quaternion2.y;
            this.y = quaternion.w * quaternion2.y + quaternion2.w * quaternion.y - quaternion.x * quaternion2.z + quaternion.z * quaternion2.x;
            this.z = quaternion.w * quaternion2.z + quaternion2.w * quaternion.z + quaternion.x * quaternion2.y - quaternion.y * quaternion2.x;
        } else {
            float f = quaternion.w * quaternion2.w - quaternion.x * quaternion2.x - quaternion.y * quaternion2.y - quaternion.z * quaternion2.z;
            float f2 = quaternion.w * quaternion2.x + quaternion2.w * quaternion.x + quaternion.y * quaternion2.z - quaternion.z * quaternion2.y;
            float f3 = quaternion.w * quaternion2.y + quaternion2.w * quaternion.y - quaternion.x * quaternion2.z + quaternion.z * quaternion2.x;
            this.z = quaternion.w * quaternion2.z + quaternion2.w * quaternion.z + quaternion.x * quaternion2.y - quaternion.y * quaternion2.x;
            this.w = f;
            this.x = f2;
            this.y = f3;
        }
    }

    public final void mulInverse(Quaternion quaternion, Quaternion quaternion2) {
        Quaternion quaternion3 = new Quaternion(quaternion2);
        quaternion3.inverse();
        this.mul(quaternion, quaternion3);
    }

    public final void inverse(Quaternion quaternion) {
        float f = 1.0f / (quaternion.w * quaternion.w + quaternion.x * quaternion.x + quaternion.y * quaternion.y + quaternion.z * quaternion.z);
        this.w = f * quaternion.w;
        this.x = -f * quaternion.x;
        this.y = -f * quaternion.y;
        this.z = -f * quaternion.z;
    }

    public final void inverse() {
        float f = 1.0f / (this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z);
        this.w *= f;
        this.x *= -f;
        this.y *= -f;
        this.z *= -f;
    }

    public final void normalize(Quaternion quaternion) {
        float f = quaternion.x * quaternion.x + quaternion.y * quaternion.y + quaternion.z * quaternion.z + quaternion.w * quaternion.w;
        if (f > 0.0f) {
            f = 1.0f / (float)Quaternion.\u41eb("\uca47", (double)f);
            this.x = f * quaternion.x;
            this.y = f * quaternion.y;
            this.z = f * quaternion.z;
            this.w = f * quaternion.w;
        } else {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 0.0f;
            this.w = 0.0f;
        }
    }

    public final void normalize() {
        float f = this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
        if (f > 0.0f) {
            f = 1.0f / (float)Quaternion.\u41eb("\uca47", (double)f);
            this.x *= f;
            this.y *= f;
            this.z *= f;
            this.w *= f;
        } else {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 0.0f;
            this.w = 0.0f;
        }
    }

    public Quaternion add(Quaternion quaternion) {
        this.x += quaternion.x;
        this.y += quaternion.y;
        this.z += quaternion.z;
        this.w += quaternion.w;
        return this;
    }

    public Quaternion subtract(Quaternion quaternion) {
        this.x -= quaternion.x;
        this.y -= quaternion.y;
        this.z -= quaternion.z;
        this.w -= quaternion.w;
        return this;
    }

    public float dot(Quaternion quaternion) {
        return this.w * quaternion.w + this.x * quaternion.x + this.y * quaternion.y + this.z * quaternion.z;
    }

    public float norm() {
        return this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Quaternion normalizeLocal() {
        Object object = Quaternion.\ufbd8("\u8a27", (float)this.norm());
        this.x *= object;
        this.y *= object;
        this.z *= object;
        this.w *= object;
        return this;
    }

    public Quaternion slerp(Quaternion quaternion, Quaternion quaternion2, float f) {
        if (quaternion.x == quaternion2.x && quaternion.y == quaternion2.y && quaternion.z == quaternion2.z && quaternion.w == quaternion2.w) {
            this.set(quaternion);
            return this;
        }
        float f2 = quaternion.x * quaternion2.x + quaternion.y * quaternion2.y + quaternion.z * quaternion2.z + quaternion.w * quaternion2.w;
        if (f2 < 0.0f) {
            quaternion2.x = -quaternion2.x;
            quaternion2.y = -quaternion2.y;
            quaternion2.z = -quaternion2.z;
            quaternion2.w = -quaternion2.w;
            f2 = -f2;
        }
        Object object = 1.0f - f;
        Object object2 = f;
        if (1.0f - f2 > 0.1f) {
            Object object3 = Quaternion.\u4a4f("\u6257", (float)f2);
            float f3 = 1.0f / Quaternion.\u4c66("\u934f", (float)object3);
            object = Quaternion.\u4c66("\u934f", (float)((1.0f - f) * object3)) * f3;
            object2 = Quaternion.\u4c66("\u934f", (float)(f * object3)) * f3;
        }
        this.x = object * quaternion.x + object2 * quaternion2.x;
        this.y = object * quaternion.y + object2 * quaternion2.y;
        this.z = object * quaternion.z + object2 * quaternion2.z;
        this.w = object * quaternion.w + object2 * quaternion2.w;
        return this;
    }

    public void slerp(Quaternion quaternion, float f) {
        if (this.x == quaternion.x && this.y == quaternion.y && this.z == quaternion.z && this.w == quaternion.w) {
            return;
        }
        float f2 = this.x * quaternion.x + this.y * quaternion.y + this.z * quaternion.z + this.w * quaternion.w;
        if (f2 < 0.0f) {
            quaternion.x = -quaternion.x;
            quaternion.y = -quaternion.y;
            quaternion.z = -quaternion.z;
            quaternion.w = -quaternion.w;
            f2 = -f2;
        }
        Object object = 1.0f - f;
        Object object2 = f;
        if (1.0f - f2 > 0.1f) {
            Object object3 = Quaternion.\u4a4f("\u6257", (float)f2);
            float f3 = 1.0f / Quaternion.\u4c66("\u934f", (float)object3);
            object = Quaternion.\u4c66("\u934f", (float)((1.0f - f) * object3)) * f3;
            object2 = Quaternion.\u4c66("\u934f", (float)(f * object3)) * f3;
        }
        this.x = object * this.x + object2 * quaternion.x;
        this.y = object * this.y + object2 * quaternion.y;
        this.z = object * this.z + object2 * quaternion.z;
        this.w = object * this.w + object2 * quaternion.w;
    }

    public void nlerp(Quaternion quaternion, float f) {
        float f2 = this.dot(quaternion);
        float f3 = 1.0f - f;
        if (f2 < 0.0f) {
            this.x = f3 * this.x - f * quaternion.x;
            this.y = f3 * this.y - f * quaternion.y;
            this.z = f3 * this.z - f * quaternion.z;
            this.w = f3 * this.w - f * quaternion.w;
        } else {
            this.x = f3 * this.x + f * quaternion.x;
            this.y = f3 * this.y + f * quaternion.y;
            this.z = f3 * this.z + f * quaternion.z;
            this.w = f3 * this.w + f * quaternion.w;
        }
        this.normalizeLocal();
    }

    private static Object \u4c66(Object object, String string, MethodType methodType) {
        if (\uc6d5 == null) {
            \uc6d5 = new Object[6];
        }
        if (\uc6d5[2] == null) {
            Quaternion.\uc6d5[2] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(AxisAngle4f$Matrix3d.\u6dd0("\u4af0\u0f95\uab50\ua59c\u9eec\u1f0d\u5484\uc555\u6ccb\ueaa1\uf1cf\uf5b7\u33eb\u92ca\u813c\u8391\u2420\ua934\u9435\ub427\ub32a\u08dd\uf274\u45d1\u5a13\u42b6\u6ac2\u10ca\u6337\u24ef\ua724\u7a51\u5583\u9536\u7d4e\ubc4f\u3ecc\ubdac\u0867\u4428\u73e3\u1bd8\u9cca\u73e2\u649b\ud216\u5efb\u9148\u653a\u93c1\ue869\u75f1\u7f34\uf2ff\u4436\udcc8\ub52e\ub39a")), AxisAngle4f$Matrix3d.\u6dd0("\u4ae4\u0f9d\uab52"), methodType).asType(methodType));
        }
        return \uc6d5[2];
    }

    private static Object \u41eb(Object object, String string, MethodType methodType) {
        if (\uc6d5 == null) {
            \uc6d5 = new Object[6];
        }
        if (\uc6d5[4] == null) {
            Quaternion.\uc6d5[4] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(Matrix3f$Matrix3d.\u610c("\u1222\ua570\u7ee2\u8ee7\u1db9\u4d95\uf93c\u4125\u8f9f\u0492\u0345\ub3a6\u4a1f\u77d4")), Matrix3f$Matrix3d.\u610c("\u123b\ua560\u7ee6\u8ef2"), methodType).asType(methodType));
        }
        return \uc6d5[4];
    }

    private static Object \ufbd8(Object object, String string, MethodType methodType) {
        if (\uc6d5 == null) {
            \uc6d5 = new Object[6];
        }
        if (\uc6d5[5] == null) {
            Quaternion.\uc6d5[5] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(AxisAngle4f$Matrix4f.\ufb61("\u3637\u2566\u552b\uf3d4\u8abc\u9a7a\ud747\u4c8c\u3051\u3b3b\u2d3a\u278c\ud2c3\uc9ac\u906a\u99e3\ueeb8\uf1f4\u1f6f\u1d42\ua2c7\u0844\u6baa\ud30d\u52d5\ueeba\u1e47\u0379\u5c5e\u5db5\ud2b7\u7e98\u15f7\u09de\ue38d\ubedd\ud00b\u8200\u58d7\uc01e\ud83e\u8ce8\u0de6\u68b6\u0593\ufa7d\ua5d1\uf2d1\ub678\uc798\u4549\uc5d0\uc0d4\u0c14\u6c69\u5105\u83cb\ufac8")), AxisAngle4f$Matrix4f.\ufb61("\u3639\u2569\u5531\uf3e6\u8ab5\u9a71\ud740"), methodType).asType(methodType));
        }
        return \uc6d5[5];
    }

    private static Object \u4a4f(Object object, String string, MethodType methodType) {
        if (\uc6d5 == null) {
            \uc6d5 = new Object[6];
        }
        if (\uc6d5[1] == null) {
            Quaternion.\uc6d5[1] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(AxisAngle4f$Matrix4f.\ufb61("\u3637\u2566\u552b\uf3d4\u8abc\u9a7a\ud747\u4c8c\u3051\u3b3b\u2d3a\u278c\ud2c3\uc9ac\u906a\u99e3\ueeb8\uf1f4\u1f6f\u1d42\ua2c7\u0844\u6baa\ud30d\u52d5\ueeba\u1e47\u0379\u5c5e\u5db5\ud2b7\u7e98\u15f7\u09de\ue38d\ubedd\ud00b\u8200\u58d7\uc01e\ud83e\u8ce8\u0de6\u68b6\u0593\ufa7d\ua5d1\uf2d1\ub678\uc798\u4549\uc5d0\uc0d4\u0c14\u6c69\u5105\u83cb\ufac8")), AxisAngle4f$Matrix4f.\ufb61("\u3631\u2564\u5528\uf3c6"), methodType).asType(methodType));
        }
        return \uc6d5[1];
    }

    private static Object \u7269(Object object, String string, MethodType methodType) {
        if (\uc6d5 == null) {
            \uc6d5 = new Object[6];
        }
        if (\uc6d5[0] == null) {
            Quaternion.\uc6d5[0] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(AxisAngle4f$Matrix4f.\ufb61("\u363a\u2566\u5531\uf3d4\u8aea\u9a6f\ud755\u4c92\u3057\u3b76\u2d12\u27c3\ud2d4\uc9ab")), AxisAngle4f$Matrix4f.\ufb61("\u3623\u256e\u5529"), methodType).asType(methodType));
        }
        return \uc6d5[0];
    }

    private static Object \u7a7f(Object object, String string, MethodType methodType) {
        if (\uc6d5 == null) {
            \uc6d5 = new Object[6];
        }
        if (\uc6d5[3] == null) {
            Quaternion.\uc6d5[3] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(Matrix3f$Matrix3d.\u610c("\u1222\ua570\u7ee2\u8ee7\u1db9\u4d95\uf93c\u4125\u8f9f\u0492\u0345\ub3a6\u4a1f\u77d4")), Matrix3f$Matrix3d.\u610c("\u122b\ua57e\u7ee7"), methodType).asType(methodType));
        }
        return \uc6d5[3];
    }
}

