/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.animations.MCACommonLibrary.math;

import galaxyspace.core.animations.MCACommonLibrary.math.AxisAngle4f$Matrix3d;
import galaxyspace.core.animations.MCACommonLibrary.math.AxisAngle4f$Matrix4f;
import galaxyspace.core.animations.MCACommonLibrary.math.Matrix3f$Matrix3d;
import galaxyspace.core.animations.MCACommonLibrary.math.Vector3f$Matrix3d;
import java.io.Serializable;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.logging.Logger;

public final class Vector3f
implements Cloneable,
Serializable {
    static final long serialVersionUID = 1L;
    private static final Logger logger = Vector3f.\ua064("\ua723", (String)Vector3f.\ua773("\uce61", Vector3f.class));
    public static final Vector3f ZERO = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Vector3f NAN = new Vector3f(Float.NaN, Float.NaN, Float.NaN);
    public static final Vector3f UNIT_X = new Vector3f(1.0f, 0.0f, 0.0f);
    public static final Vector3f UNIT_Y = new Vector3f(0.0f, 1.0f, 0.0f);
    public static final Vector3f UNIT_Z = new Vector3f(0.0f, 0.0f, 1.0f);
    public static final Vector3f UNIT_XYZ = new Vector3f(1.0f, 1.0f, 1.0f);
    public static final Vector3f POSITIVE_INFINITY = new Vector3f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
    public static final Vector3f NEGATIVE_INFINITY = new Vector3f(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
    public float x;
    public float y;
    public float z;
    private static volatile transient Object[] \u8024;

    public Vector3f() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
    }

    public Vector3f(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public Vector3f(Vector3f vector3f) {
        this.set(vector3f);
    }

    public Vector3f set(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        return this;
    }

    public Vector3f set(Vector3f vector3f) {
        this.x = vector3f.x;
        this.y = vector3f.y;
        this.z = vector3f.z;
        return this;
    }

    public Vector3f add(Vector3f vector3f) {
        if (null == vector3f) {
            Vector3f.\u4800("\u6baa", (Logger)logger, (String)Matrix3f$Matrix3d.\u610c("\u1218\ua563\u7efb\u8ef0\u1dfe\u4d9d\uf938\u412f\u8fd8\u04ca\u036d\ub3a4\u4a1f\u77d3\ub35d\u0b90\u6f1b\uc485\ubf7c\u36d7\uddd8\u48e8\u8664\u40d8\ud0da\u475c\u0473\u4f31\u0ec3\uf047\udba9\uc88d\ua22b\u5db1\u8486\ubca3\u9437\u0ce6\u67e3"));
            return null;
        }
        return new Vector3f(this.x + vector3f.x, this.y + vector3f.y, this.z + vector3f.z);
    }

    public Vector3f add(Vector3f vector3f, Vector3f vector3f2) {
        vector3f2.x = this.x + vector3f.x;
        vector3f2.y = this.y + vector3f.y;
        vector3f2.z = this.z + vector3f.z;
        return vector3f2;
    }

    public Vector3f addLocal(Vector3f vector3f) {
        if (null == vector3f) {
            Vector3f.\u4800("\u6baa", (Logger)logger, (String)Vector3f$Matrix3d.\u9c53("\u9864\u0f78\u995d\ue019\ue4eb\u4715\uee68\u0324\uc8e3\u569d\u5111\u95dc\ud9ca\u3d7e\u975a\u4169\u6995\u7f24\u284c\u12ae\uef0f\uf902\ubf78\uacf8\u3995\u39fa\u468e\ue37d\ube4f\u3a08\u6f58\u46e3\uc05b\u1ba6\udc3b\u4348\u4bdb\u4836\ub94d"));
            return null;
        }
        this.x += vector3f.x;
        this.y += vector3f.y;
        this.z += vector3f.z;
        return this;
    }

    public Vector3f add(float f, float f2, float f3) {
        return new Vector3f(this.x + f, this.y + f2, this.z + f3);
    }

    public Vector3f addLocal(float f, float f2, float f3) {
        this.x += f;
        this.y += f2;
        this.z += f3;
        return this;
    }

    public Vector3f scaleAdd(float f, Vector3f vector3f) {
        this.x = this.x * f + vector3f.x;
        this.y = this.y * f + vector3f.y;
        this.z = this.z * f + vector3f.z;
        return this;
    }

    public Vector3f scaleAdd(float f, Vector3f vector3f, Vector3f vector3f2) {
        this.x = vector3f.x * f + vector3f2.x;
        this.y = vector3f.y * f + vector3f2.y;
        this.z = vector3f.z * f + vector3f2.z;
        return this;
    }

    public float dot(Vector3f vector3f) {
        if (null == vector3f) {
            Vector3f.\u4800("\u6baa", (Logger)logger, (String)AxisAngle4f$Matrix3d.\u6dd0("\u4ac7\u0f86\uab53\ua58b\u9efd\u1f10\u5492\uc541\u6c8a\ueab4\uf1cf\uf5fa\u33fc\u92ca\u813c\u83d4\u2467\ua926\u947b\ub420\ub332\u08d0\uf26c\u4594\u5a5c\u42e8\u6a91\u1096\u631f\u24d8\ua710\u7a60\u5582\u953e\u7d47\ubc0e"));
            return 0.0f;
        }
        return this.x * vector3f.x + this.y * vector3f.y + this.z * vector3f.z;
    }

    public Vector3f cross(Vector3f vector3f) {
        return this.cross(vector3f, null);
    }

    public Vector3f cross(Vector3f vector3f, Vector3f vector3f2) {
        return this.cross(vector3f.x, vector3f.y, vector3f.z, vector3f2);
    }

    public Vector3f cross(float f, float f2, float f3, Vector3f vector3f) {
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        float f4 = this.y * f3 - this.z * f2;
        float f5 = this.z * f - this.x * f3;
        float f6 = this.x * f2 - this.y * f;
        vector3f.set(f4, f5, f6);
        return vector3f;
    }

    public Vector3f crossLocal(Vector3f vector3f) {
        return this.crossLocal(vector3f.x, vector3f.y, vector3f.z);
    }

    public Vector3f crossLocal(float f, float f2, float f3) {
        float f4 = this.y * f3 - this.z * f2;
        float f5 = this.z * f - this.x * f3;
        this.z = this.x * f2 - this.y * f;
        this.x = f4;
        this.y = f5;
        return this;
    }

    public Vector3f project(Vector3f vector3f) {
        float f = this.dot(vector3f);
        float f2 = vector3f.lengthSquared();
        return new Vector3f(vector3f).normalizeLocal().multLocal(f / f2);
    }

    public boolean isUnitVector() {
        float f = this.length();
        return 0.99f < f && f < 1.01f;
    }

    public float length() {
        return (float)Vector3f.\u1f6d("\u91f8", (float)this.lengthSquared());
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float distanceSquared(Vector3f vector3f) {
        double d = this.x - vector3f.x;
        double d2 = this.y - vector3f.y;
        double d3 = this.z - vector3f.z;
        return (float)(d * d + d2 * d2 + d3 * d3);
    }

    public float distance(Vector3f vector3f) {
        return (float)Vector3f.\u1f6d("\u91f8", (float)this.distanceSquared(vector3f));
    }

    public Vector3f mult(float f) {
        return new Vector3f(this.x * f, this.y * f, this.z * f);
    }

    public Vector3f mult(float f, Vector3f vector3f) {
        if (null == vector3f) {
            vector3f = new Vector3f();
        }
        vector3f.x = this.x * f;
        vector3f.y = this.y * f;
        vector3f.z = this.z * f;
        return vector3f;
    }

    public Vector3f multLocal(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
        return this;
    }

    public Vector3f multLocal(Vector3f vector3f) {
        if (null == vector3f) {
            Vector3f.\u4800("\u6baa", (Logger)logger, (String)Vector3f$Matrix3d.\u9c53("\u9864\u0f78\u995d\ue019\ue4eb\u4715\uee68\u0324\uc8e3\u569d\u5111\u95dc\ud9ca\u3d7e\u975a\u4169\u6995\u7f24\u284c\u12ae\uef0f\uf902\ubf78\uacf8\u3995\u39fa\u468e\ue37d\ube4f\u3a08\u6f58\u46e3\uc05b\u1ba6\udc3b\u4348\u4bdb\u4836\ub94d"));
            return null;
        }
        this.x *= vector3f.x;
        this.y *= vector3f.y;
        this.z *= vector3f.z;
        return this;
    }

    public Vector3f multLocal(float f, float f2, float f3) {
        this.x *= f;
        this.y *= f2;
        this.z *= f3;
        return this;
    }

    public Vector3f mult(Vector3f vector3f) {
        if (null == vector3f) {
            Vector3f.\u4800("\u6baa", (Logger)logger, (String)Vector3f$Matrix3d.\u9c53("\u9864\u0f78\u995d\ue019\ue4eb\u4715\uee68\u0324\uc8e3\u569d\u5111\u95dc\ud9ca\u3d7e\u975a\u4169\u6995\u7f24\u284c\u12ae\uef0f\uf902\ubf78\uacf8\u3995\u39fa\u468e\ue37d\ube4f\u3a08\u6f58\u46e3\uc05b\u1ba6\udc3b\u4348\u4bdb\u4836\ub94d"));
            return null;
        }
        return this.mult(vector3f, null);
    }

    public Vector3f mult(Vector3f vector3f, Vector3f vector3f2) {
        if (null == vector3f) {
            Vector3f.\u4800("\u6baa", (Logger)logger, (String)Vector3f$Matrix3d.\u9c53("\u9864\u0f78\u995d\ue019\ue4eb\u4715\uee68\u0324\uc8e3\u569d\u5111\u95dc\ud9ca\u3d7e\u975a\u4169\u6995\u7f24\u284c\u12ae\uef0f\uf902\ubf78\uacf8\u3995\u39fa\u468e\ue37d\ube4f\u3a08\u6f58\u46e3\uc05b\u1ba6\udc3b\u4348\u4bdb\u4836\ub94d"));
            return null;
        }
        if (vector3f2 == null) {
            vector3f2 = new Vector3f();
        }
        return vector3f2.set(this.x * vector3f.x, this.y * vector3f.y, this.z * vector3f.z);
    }

    public Vector3f divide(float f) {
        f = 1.0f / f;
        return new Vector3f(this.x * f, this.y * f, this.z * f);
    }

    public Vector3f divideLocal(float f) {
        f = 1.0f / f;
        this.x *= f;
        this.y *= f;
        this.z *= f;
        return this;
    }

    public Vector3f divide(Vector3f vector3f) {
        return new Vector3f(this.x / vector3f.x, this.y / vector3f.y, this.z / vector3f.z);
    }

    public Vector3f divideLocal(Vector3f vector3f) {
        this.x /= vector3f.x;
        this.y /= vector3f.y;
        this.z /= vector3f.z;
        return this;
    }

    public Vector3f negate() {
        return new Vector3f(-this.x, -this.y, -this.z);
    }

    public Vector3f negateLocal() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3f subtract(Vector3f vector3f) {
        return new Vector3f(this.x - vector3f.x, this.y - vector3f.y, this.z - vector3f.z);
    }

    public Vector3f subtractLocal(Vector3f vector3f) {
        if (null == vector3f) {
            Vector3f.\u4800("\u6baa", (Logger)logger, (String)Vector3f$Matrix3d.\u9c53("\u9864\u0f78\u995d\ue019\ue4eb\u4715\uee68\u0324\uc8e3\u569d\u5111\u95dc\ud9ca\u3d7e\u975a\u4169\u6995\u7f24\u284c\u12ae\uef0f\uf902\ubf78\uacf8\u3995\u39fa\u468e\ue37d\ube4f\u3a08\u6f58\u46e3\uc05b\u1ba6\udc3b\u4348\u4bdb\u4836\ub94d"));
            return null;
        }
        this.x -= vector3f.x;
        this.y -= vector3f.y;
        this.z -= vector3f.z;
        return this;
    }

    public Vector3f subtract(Vector3f vector3f, Vector3f vector3f2) {
        if (vector3f2 == null) {
            vector3f2 = new Vector3f();
        }
        vector3f2.x = this.x - vector3f.x;
        vector3f2.y = this.y - vector3f.y;
        vector3f2.z = this.z - vector3f.z;
        return vector3f2;
    }

    public Vector3f subtract(float f, float f2, float f3) {
        return new Vector3f(this.x - f, this.y - f2, this.z - f3);
    }

    public Vector3f subtractLocal(float f, float f2, float f3) {
        this.x -= f;
        this.y -= f2;
        this.z -= f3;
        return this;
    }

    public Vector3f normalize() {
        float f = this.x * this.x + this.y * this.y + this.z * this.z;
        if (f != 1.0f && f != 0.0f) {
            f = 1.0f / Vector3f.\u1f6d("\u91f8", (float)f);
            return new Vector3f(this.x * f, this.y * f, this.z * f);
        }
        return this.clone();
    }

    public Vector3f normalizeLocal() {
        float f = this.x * this.x + this.y * this.y + this.z * this.z;
        if (f != 1.0f && f != 0.0f) {
            f = 1.0f / Vector3f.\u1f6d("\u91f8", (float)f);
            this.x *= f;
            this.y *= f;
            this.z *= f;
        }
        return this;
    }

    public void maxLocal(Vector3f vector3f) {
        this.x = vector3f.x > this.x ? vector3f.x : this.x;
        this.y = vector3f.y > this.y ? vector3f.y : this.y;
        this.z = vector3f.z > this.z ? vector3f.z : this.z;
    }

    public void minLocal(Vector3f vector3f) {
        this.x = vector3f.x < this.x ? vector3f.x : this.x;
        this.y = vector3f.y < this.y ? vector3f.y : this.y;
        this.z = vector3f.z < this.z ? vector3f.z : this.z;
    }

    public Vector3f zero() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        return this;
    }

    public float angleBetween(Vector3f vector3f) {
        float f = this.dot(vector3f);
        Object object = Vector3f.\u04a7("\ud56d", (float)f);
        return (float)object;
    }

    public Vector3f interpolate(Vector3f vector3f, float f) {
        this.x = (1.0f - f) * this.x + f * vector3f.x;
        this.y = (1.0f - f) * this.y + f * vector3f.y;
        this.z = (1.0f - f) * this.z + f * vector3f.z;
        return this;
    }

    public Vector3f interpolate(Vector3f vector3f, Vector3f vector3f2, float f) {
        this.x = (1.0f - f) * vector3f.x + f * vector3f2.x;
        this.y = (1.0f - f) * vector3f.y + f * vector3f2.y;
        this.z = (1.0f - f) * vector3f.z + f * vector3f2.z;
        return this;
    }

    public static boolean isValidVector(Vector3f vector3f) {
        if (vector3f == null) {
            return false;
        }
        if (Vector3f.\u344f("\u1e0d", (float)vector3f.x) != false || Vector3f.\u344f("\u1e0d", (float)vector3f.y) != false || Vector3f.\u344f("\u1e0d", (float)vector3f.z) != false) {
            return false;
        }
        return Vector3f.\u9069("\u70e0", (float)vector3f.x) == false && Vector3f.\u9069("\u70e0", (float)vector3f.y) == false && Vector3f.\u9069("\u70e0", (float)vector3f.z) == false;
    }

    public static void generateOrthonormalBasis(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        vector3f3.normalizeLocal();
        Vector3f.generateComplementBasis(vector3f, vector3f2, vector3f3);
    }

    public static void generateComplementBasis(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        if (Vector3f.\u1b96("\u7abb", (float)vector3f3.x) >= Vector3f.\u1b96("\u7abb", (float)vector3f3.y)) {
            Object object = Vector3f.\u9d75("\ua531", (float)(vector3f3.x * vector3f3.x + vector3f3.z * vector3f3.z));
            vector3f.x = -vector3f3.z * object;
            vector3f.y = 0.0f;
            vector3f.z = vector3f3.x * object;
            vector3f2.x = vector3f3.y * vector3f.z;
            vector3f2.y = vector3f3.z * vector3f.x - vector3f3.x * vector3f.z;
            vector3f2.z = -vector3f3.y * vector3f.x;
        } else {
            Object object = Vector3f.\u9d75("\ua531", (float)(vector3f3.y * vector3f3.y + vector3f3.z * vector3f3.z));
            vector3f.x = 0.0f;
            vector3f.y = vector3f3.z * object;
            vector3f.z = -vector3f3.y * object;
            vector3f2.x = vector3f3.y * vector3f.z - vector3f3.z * vector3f.y;
            vector3f2.y = -vector3f3.x * vector3f.z;
            vector3f2.z = vector3f3.x * vector3f.y;
        }
    }

    public Vector3f clone() {
        try {
            return (Vector3f)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    public float[] toArray(float[] fArray) {
        if (fArray == null) {
            fArray = new float[]{this.x, this.y, this.z};
        }
        return fArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Vector3f)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Vector3f vector3f = (Vector3f)object;
        if (Vector3f.\uce30("\u1d03", (float)this.x, (float)vector3f.x) != false) {
            return false;
        }
        if (Vector3f.\uce30("\u1d03", (float)this.y, (float)vector3f.y) != false) {
            return false;
        }
        return Vector3f.\uce30("\u1d03", (float)this.z, (float)vector3f.z) == false;
    }

    public int hashCode() {
        int n = 37;
        n += 37 * n + Vector3f.\u72f1("\u77bb", (float)this.x);
        n += 37 * n + Vector3f.\u72f1("\u77bb", (float)this.y);
        n += 37 * n + Vector3f.\u72f1("\u77bb", (float)this.z);
        return n;
    }

    public String toString() {
        return Vector3f.\ua780("\u16c5", (StringBuilder)Vector3f.\u8b75("\u72df", (StringBuilder)Vector3f.\u6d23("\u80fd", (StringBuilder)Vector3f.\u8b75("\u72df", (StringBuilder)Vector3f.\u6d23("\u80fd", (StringBuilder)Vector3f.\u8b75("\u72df", (StringBuilder)Vector3f.\u6d23("\u80fd", (StringBuilder)Vector3f.\u8b75("\u72df", (StringBuilder)new StringBuilder(), (String)AxisAngle4f$Matrix3d.\u6dd0("\u4abf")), (float)this.x), (String)AxisAngle4f$Matrix3d.\u6dd0("\u4abb\u0fd4")), (float)this.y), (String)AxisAngle4f$Matrix3d.\u6dd0("\u4abb\u0fd4")), (float)this.z), (String)AxisAngle4f$Matrix3d.\u6dd0("\u4abe")));
    }

    public float getX() {
        return this.x;
    }

    public Vector3f setX(float f) {
        this.x = f;
        return this;
    }

    public float getY() {
        return this.y;
    }

    public Vector3f setY(float f) {
        this.y = f;
        return this;
    }

    public float getZ() {
        return this.z;
    }

    public Vector3f setZ(float f) {
        this.z = f;
        return this;
    }

    public float get(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IllegalArgumentException(Matrix3f$Matrix3d.\u610c("\u1221\ua57f\u7ef0\u8ee3\u1def\u4dd9\uf930\u413e\u8f8b\u04c8\u0328\ub3a5\u4a0e\u779c\ub34a\u0bd9\u6f06\uc49e\ubf39\u36cb\udd8d\u48b4\u8624\u40d4\ud0cb\u4712\u0469\u4f2f\u0e8f\uf055"));
    }

    public void set(int n, float f) {
        switch (n) {
            case 0: {
                this.x = f;
                return;
            }
            case 1: {
                this.y = f;
                return;
            }
            case 2: {
                this.z = f;
                return;
            }
        }
        throw new IllegalArgumentException(AxisAngle4f$Matrix3d.\u6dd0("\u4afe\u0f9a\uab58\ua598\u9eec\u1f54\u549a\uc550\u6cd9\ueab6\uf18a\uf5fb\u33ed\u9285\u812b\u839d\u247a\ua93d\u943e\ub43c\ub367\u088c\uf22c\u4598\u5a4d\u42f8\u6ade\u1096\u635a\u249e"));
    }

    private static Object \u04a7(Object object, String string, MethodType methodType) {
        if (\u8024 == null) {
            \u8024 = new Object[14];
        }
        if (\u8024[7] == null) {
            Vector3f.\u8024[7] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(AxisAngle4f$Matrix3d.\u6dd0("\u4af0\u0f95\uab50\ua59c\u9eec\u1f0d\u5484\uc555\u6ccb\ueaa1\uf1cf\uf5b7\u33eb\u92ca\u813c\u8391\u2420\ua934\u9435\ub427\ub32a\u08dd\uf274\u45d1\u5a13\u42b6\u6ac2\u10ca\u6337\u24ef\ua724\u7a51\u5583\u9536\u7d4e\ubc4f\u3ecc\ubdac\u0867\u4428\u73e3\u1bd8\u9cca\u73e2\u649b\ud216\u5efb\u9148\u653a\u93c1\ue869\u75f1\u7f34\uf2ff\u4436\udcc8\ub52e\ub39a")), AxisAngle4f$Matrix3d.\u6dd0("\u4af6\u0f97\uab53\ua58e"), methodType).asType(methodType));
        }
        return \u8024[7];
    }

    private static Object \ua064(Object object, String string, MethodType methodType) {
        if (\u8024 == null) {
            \u8024 = new Object[14];
        }
        if (\u8024[3] == null) {
            Vector3f.\u8024[3] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(AxisAngle4f$Matrix3d.\u6dd0("\u4afd\u0f95\uab4a\ua59c\u9eba\u1f01\u5483\uc54c\u6cc6\ueaec\uf1c6\uf5f6\u33ef\u92c2\u8127\u839a\u2469\ua97b\u9417\ub421\ub320\u08db\uf265\u45ca")), AxisAngle4f$Matrix3d.\u6dd0("\u4af0\u0f91\uab48\ua5b1\u9efb\u1f13\u5490\uc540\u6cd8"), methodType).asType(methodType));
        }
        return \u8024[3];
    }

    private static Object \u344f(Object object, String string, MethodType methodType) {
        if (\u8024 == null) {
            \u8024 = new Object[14];
        }
        if (\u8024[9] == null) {
            Vector3f.\u8024[9] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(Matrix3f$Matrix3d.\u610c("\u1222\ua570\u7ee2\u8ee7\u1db9\u4d95\uf93c\u4125\u8f9f\u0492\u034e\ub3ab\u4a04\u77dd\ub35b")), Matrix3f$Matrix3d.\u610c("\u1221\ua562\u7eda\u8ee7\u1dd9"), methodType).asType(methodType));
        }
        return \u8024[9];
    }

    private static Object \ua780(Object object, String string, MethodType methodType) {
        if (\u8024 == null) {
            \u8024 = new Object[14];
        }
        if (\u8024[6] == null) {
            Vector3f.\u8024[6] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(AxisAngle4f$Matrix3d.\u6dd0("\u4afd\u0f95\uab4a\ua59c\u9eba\u1f18\u5496\uc54b\u6ccd\ueaec\uf1f9\uf5ed\u33fa\u92cc\u8120\u8393\u244c\ua920\u9432\ub422\ub323\u08d9\uf272")), AxisAngle4f$Matrix3d.\u6dd0("\u4ae3\u0f9b\uab6f\ua589\u9ee6\u1f1d\u5499\uc542"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u8024[6];
    }

    private static Object \u6d23(Object object, String string, MethodType methodType) {
        if (\u8024 == null) {
            \u8024 = new Object[14];
        }
        if (\u8024[11] == null) {
            Vector3f.\u8024[11] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(Matrix3f$Matrix3d.\u610c("\u1222\ua570\u7ee2\u8ee7\u1db9\u4d95\uf93c\u4125\u8f9f\u0492\u035b\ub3b3\u4a19\u77d5\ub341\u0bd7\u6f30\uc483\ubf35\u36d5\uddc9\u48e1\u867a")), Matrix3f$Matrix3d.\u610c("\u1229\ua561\u7ee4\u8ee3\u1df9\u4d9d"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u8024[11];
    }

    private static Object \u1b96(Object object, String string, MethodType methodType) {
        if (\u8024 == null) {
            \u8024 = new Object[14];
        }
        if (\u8024[1] == null) {
            Vector3f.\u8024[1] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(Matrix3f$Matrix3d.\u610c("\u122f\ua570\u7ef8\u8ee7\u1def\u4d80\uf92e\u413b\u8f99\u04df\u036d\ub3e9\u4a08\u77d3\ub35d\u0bd5\u6f5c\uc497\ubf32\u36d0\uddc0\u48e5\u867c\u409d\ud095\u475c\u0475\u4f73\u0ee2\uf024\udb9a\uc8ab\ua230\u5da9\u8499\ubca2\u943c\u0cce\u67a4\uf774\u5be0\u1d63\uaf8e\u2a94\ue365\u4379\u56ee\ub611\uc8ea\u269b\u066a\u528d\u350e\u2d9a\u6c90\u1b77\ub946\ufeaa")), Matrix3f$Matrix3d.\u610c("\u1229\ua573\u7ee7"), methodType).asType(methodType));
        }
        return \u8024[1];
    }

    private static Object \u9069(Object object, String string, MethodType methodType) {
        if (\u8024 == null) {
            \u8024 = new Object[14];
        }
        if (\u8024[2] == null) {
            Vector3f.\u8024[2] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(Vector3f$Matrix3d.\u9c53("\u985e\u0f6b\u9944\ue00e\ue4ac\u471d\uee6c\u032e\uc8a4\u56c5\u5132\u95d3\ud9d1\u3d70\u975c")), Vector3f$Matrix3d.\u9c53("\u985d\u0f79\u997b\ue001\ue4e4\u4718\uee63\u0329\uc8b7\u568e"), methodType).asType(methodType));
        }
        return \u8024[2];
    }

    private static Object \u72f1(Object object, String string, MethodType methodType) {
        if (\u8024 == null) {
            \u8024 = new Object[14];
        }
        if (\u8024[8] == null) {
            Vector3f.\u8024[8] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(Vector3f$Matrix3d.\u9c53("\u985e\u0f6b\u9944\ue00e\ue4ac\u471d\uee6c\u032e\uc8a4\u56c5\u5132\u95d3\ud9d1\u3d70\u975c")), Vector3f$Matrix3d.\u9c53("\u9852\u0f66\u995d\ue00e\ue4f6\u4725\uee62\u0309\uc8ad\u569f\u5136\u95d6\ud9ca\u3d62"), methodType).asType(methodType));
        }
        return \u8024[8];
    }

    private static Object \u1f6d(Object object, String string, MethodType methodType) {
        if (\u8024 == null) {
            \u8024 = new Object[14];
        }
        if (\u8024[12] == null) {
            Vector3f.\u8024[12] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(AxisAngle4f$Matrix3d.\u6dd0("\u4af0\u0f95\uab50\ua59c\u9eec\u1f0d\u5484\uc555\u6ccb\ueaa1\uf1cf\uf5b7\u33eb\u92ca\u813c\u8391\u2420\ua934\u9435\ub427\ub32a\u08dd\uf274\u45d1\u5a13\u42b6\u6ac2\u10ca\u6337\u24ef\ua724\u7a51\u5583\u9536\u7d4e\ubc4f\u3ecc\ubdac\u0867\u4428\u73e3\u1bd8\u9cca\u73e2\u649b\ud216\u5efb\u9148\u653a\u93c1\ue869\u75f1\u7f34\uf2ff\u4436\udcc8\ub52e\ub39a")), AxisAngle4f$Matrix3d.\u6dd0("\u4ae4\u0f85\uab4e\ua589"), methodType).asType(methodType));
        }
        return \u8024[12];
    }

    private static Object \u4800(Object object, String string, MethodType methodType) {
        if (\u8024 == null) {
            \u8024 = new Object[14];
        }
        if (\u8024[4] == null) {
            Vector3f.\u8024[4] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(Vector3f$Matrix3d.\u9c53("\u985e\u0f6b\u9944\ue00e\ue4ac\u4704\uee79\u0329\uc8af\u56c5\u5118\u95d0\ud9d9\u3d76\u9741\u4127\u699b\u7f79\u2820\u12af\uef1d\uf909\ubf71\uaca6")), Vector3f$Matrix3d.\u9c53("\u9843\u0f6b\u9940\ue001\ue4eb\u471f\uee6a"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u8024[4];
    }

    private static Object \u8b75(Object object, String string, MethodType methodType) {
        if (\u8024 == null) {
            \u8024 = new Object[14];
        }
        if (\u8024[13] == null) {
            Vector3f.\u8024[13] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(Matrix3f$Matrix3d.\u610c("\u1222\ua570\u7ee2\u8ee7\u1db9\u4d95\uf93c\u4125\u8f9f\u0492\u035b\ub3b3\u4a19\u77d5\ub341\u0bd7\u6f30\uc483\ubf35\u36d5\uddc9\u48e1\u867a")), Matrix3f$Matrix3d.\u610c("\u1229\ua561\u7ee4\u8ee3\u1df9\u4d9d"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u8024[13];
    }

    private static Object \u9d75(Object object, String string, MethodType methodType) {
        if (\u8024 == null) {
            \u8024 = new Object[14];
        }
        if (\u8024[0] == null) {
            Vector3f.\u8024[0] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(AxisAngle4f$Matrix4f.\ufb61("\u3637\u2566\u552b\uf3d4\u8abc\u9a7a\ud747\u4c8c\u3051\u3b3b\u2d3a\u278c\ud2c3\uc9ac\u906a\u99e3\ueeb8\uf1f4\u1f6f\u1d42\ua2c7\u0844\u6baa\ud30d\u52d5\ueeba\u1e47\u0379\u5c5e\u5db5\ud2b7\u7e98\u15f7\u09de\ue38d\ubedd\ud00b\u8200\u58d7\uc01e\ud83e\u8ce8\u0de6\u68b6\u0593\ufa7d\ua5d1\uf2d1\ub678\uc798\u4549\uc5d0\uc0d4\u0c14\u6c69\u5105\u83cb\ufac8")), AxisAngle4f$Matrix4f.\ufb61("\u3639\u2569\u5531\uf3e6\u8ab5\u9a71\ud740"), methodType).asType(methodType));
        }
        return \u8024[0];
    }

    private static Object \uce30(Object object, String string, MethodType methodType) {
        if (\u8024 == null) {
            \u8024 = new Object[14];
        }
        if (\u8024[10] == null) {
            Vector3f.\u8024[10] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(Matrix3f$Matrix3d.\u610c("\u1222\ua570\u7ee2\u8ee7\u1db9\u4d95\uf93c\u4125\u8f9f\u0492\u034e\ub3ab\u4a04\u77dd\ub35b")), Matrix3f$Matrix3d.\u610c("\u122b\ua57e\u7ef9\u8ef6\u1df6\u4d8b\uf938"), methodType).asType(methodType));
        }
        return \u8024[10];
    }

    private static Object \ua773(Object object, String string, MethodType methodType) {
        if (\u8024 == null) {
            \u8024 = new Object[14];
        }
        if (\u8024[5] == null) {
            Vector3f.\u8024[5] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(Vector3f$Matrix3d.\u9c53("\u985e\u0f6b\u9944\ue00e\ue4ac\u471d\uee6c\u032e\uc8a4\u56c5\u5137\u95d3\ud9df\u3d62\u975b")), Vector3f$Matrix3d.\u9c53("\u9853\u0f6f\u9946\ue021\ue4e3\u471c\uee68"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u8024[5];
    }
}

