/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.client.gui.screen;

import com.google.common.collect.Maps;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.Event;
import galaxyspace.GalaxySpace;
import galaxyspace.api.BodiesHelper;
import galaxyspace.api.dimension.IAdvancedSpace;
import galaxyspace.core.client.gui.screen.GSGuiCelestialSelection$0;
import galaxyspace.core.client.gui.screen.GSGuiCelestialSelection$1;
import galaxyspace.core.client.gui.screen.GSGuiCelestialSelection$2;
import galaxyspace.core.client.gui.screen.GSGuiCelestialSelection$3;
import galaxyspace.core.configs.GSConfigCore;
import galaxyspace.core.network.packet.GSPacketSimple;
import galaxyspace.core.network.packet.GSPacketSimple$GSEnumSimplePacket;
import galaxyspace.core.network.packet.GalaxySpaceChannelHandler;
import galaxyspace.core.util.astronomy.AstronomyUtil$PathsSolarSystems;
import java.io.IOException;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.event.client.CelestialBodyRenderEvent;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.IChildBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.recipe.SpaceStationRecipe;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.api.world.SpaceStationType;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderSurface;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

public class GSGuiCelestialSelection
extends GuiCelestialSelection {
    public List<CelestialBody> possibleBodiesGS;
    private int posYSS = 1;
    private int timer = 0;
    private int traveltime = 0;
    private boolean check = false;
    private Random rand;
    private String galaxy = GalacticraftCore.planetOverworld.getParentSolarSystem().getUnlocalizedParentGalaxyName();
    private int tierneed = -1;
    public int currenttier = 0;
    private int coef;
    private int fuelRocketLevel = 0;
    private int fuelSet = 0;
    private boolean showStarList = false;
    private boolean showGalaxyList = false;
    private List<AstronomyUtil$PathsSolarSystems> paths = new ArrayList<AstronomyUtil$PathsSolarSystems>();
    private List<String> galaxylist = new ArrayList<String>();
    private HashMap<SolarSystem, Integer> starlist = new LinkedHashMap<SolarSystem, Integer>();
    protected int canCreateOffset = 0;
    protected int animateGrandchildren = 0;
    private double isometx = GSConfigCore.enable2DGalaxyMap ? 0.0 : 55.0;
    private double isometz = 45.0;
    private boolean hideInfo = false;
    private boolean small_mode;
    private int small_page;
    public static ResourceLocation guiMain2 = new ResourceLocation(GalaxySpace.ASSET_PREFIX, GSGuiCelestialSelection$1.\uc83e("\ua57b\ue926\u741a\u2af4\uc7b0\uf6ec\u086e\uece5\ufbec\u8c85\u5a5e\ub6bd\ua7ee\u8d2a\uc7fd\u328f\u037d\u5cd1\ueb65\uda87\u3db1\ucd09\u6640\uc82e\u72e4\u1338\u6993\ue835\u856f\uf3da\ue90b\u9aa9\u9085\ub095\ue788\u84f6"));
    private static volatile transient Object[] \ub4ae;

    public GSGuiCelestialSelection(boolean bl, List<CelestialBody> list, Integer[] integerArray) {
        super(bl, list);
        this.small_mode = Minecraft.func_71410_x().field_71474_y.field_74335_Z == 0;
        this.small_page = 0;
        if (integerArray != null) {
            this.currenttier = (int)GSGuiCelestialSelection.\u61d3("\u5de8", (Integer)integerArray[0]);
            this.coef = GSConfigCore.speedTimeTravel + GSGuiCelestialSelection.\u61d3("\u5de8", (Integer)integerArray[0]);
            this.fuelRocketLevel = (int)GSGuiCelestialSelection.\u61d3("\u5de8", (Integer)integerArray[1]);
        }
        int n = 0;
        for (SolarSystem solarSystem : GalaxyRegistry.getRegisteredSolarSystems().values()) {
            if (!this.galaxylist.contains(solarSystem.getUnlocalizedParentGalaxyName())) {
                this.galaxylist.add(solarSystem.getUnlocalizedParentGalaxyName());
            }
            if (GSGuiCelestialSelection.\u3652("\ucc81", solarSystem.getUnlocalizedParentGalaxyName(), (Object)this.galaxy) == false) continue;
            GSGuiCelestialSelection.\u4ce3("\u61d0", this.starlist, (Object)solarSystem, (Object)GSGuiCelestialSelection.\u8f2a("\u69d7", (int)(++n)));
        }
    }

    private void addPaths() {
        block0: for (SolarSystem solarSystem : GalaxyRegistry.getRegisteredSolarSystems().values()) {
            int n = 0;
            for (SolarSystem solarSystem2 : GalaxyRegistry.getRegisteredSolarSystems().values()) {
                if (solarSystem.equals(solarSystem2) || GSGuiCelestialSelection.\u3652("\ucc81", solarSystem.getUnlocalizedParentGalaxyName(), (Object)solarSystem2.getUnlocalizedParentGalaxyName()) == false || !(solarSystem.getMapPosition().distance(solarSystem2.getMapPosition()) < 800.0)) continue;
                if (!this.paths.contains(new AstronomyUtil$PathsSolarSystems(solarSystem2, solarSystem))) {
                    this.paths.add(new AstronomyUtil$PathsSolarSystems(solarSystem, solarSystem2));
                    if (n >= 1) continue block0;
                }
                ++n;
                GSGuiCelestialSelection.\u4d87("\ub217", (String)GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\u7903("\u9313", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)solarSystem.getUnlocalizedName()), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320\u2fac\u3a38\u22c5")), (double)solarSystem.getMapPosition().distance(solarSystem2.getMapPosition())), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320\u2fbd\u3a2b\u22c5")), (String)solarSystem2.getUnlocalizedName())));
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    public void setImgBackground(ResourceLocation resourceLocation) {
        GL11.glPushMatrix();
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(resourceLocation);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(0.0, (double)(0 + this.field_146295_m), (double)this.field_73735_i, 0.0, 1.0);
        tessellator.func_78374_a((double)(0 + this.field_146294_l), (double)(0 + this.field_146295_m), (double)this.field_73735_i, 1.0, 1.0);
        tessellator.func_78374_a((double)(0 + this.field_146294_l), 0.0, (double)this.field_73735_i, 1.0, 0.0);
        tessellator.func_78374_a(0.0, 0.0, (double)this.field_73735_i, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public void setBlackBackground() {
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        tessellator.func_78382_b();
        tessellator.func_78377_a(0.0, (double)this.field_146295_m, -90.0);
        tessellator.func_78377_a((double)this.field_146294_l, (double)this.field_146295_m, -90.0);
        tessellator.func_78377_a((double)this.field_146294_l, 0.0, -90.0);
        tessellator.func_78377_a(0.0, 0.0, -90.0);
        tessellator.func_78381_a();
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawGrid(float f, float f2) {
        GL11.glColor4f((float)0.0f, (float)0.2f, (float)0.5f, (float)0.55f);
        GL11.glBegin((int)1);
        for (float f3 = -(f += f2 / 2.0f); f3 <= f; f3 += f2) {
            GL11.glVertex3f((float)f3, (float)(-f), (float)-0.0f);
            GL11.glVertex3f((float)f3, (float)f, (float)-0.0f);
            GL11.glVertex3f((float)(-f), (float)f3, (float)-0.0f);
            GL11.glVertex3f((float)f, (float)f3, (float)-0.0f);
        }
        GL11.glEnd();
    }

    protected Vector3f getCelestialBodyPosition(CelestialBody celestialBody) {
        if (celestialBody instanceof Star) {
            if (GSGuiCelestialSelection.\u017a("\u7ddf", celestialBody.getUnlocalizedName(), (String)GSGuiCelestialSelection$3.\u87c3("\u48dc\u2206\ue6c3\uc880\uffe4\u1241\ue7b1\u5027")) != false) {
                return new Vector3f();
            }
            return ((Star)celestialBody).getParentSolarSystem().getMapPosition().toVector3f();
        }
        boolean bl = this.celestialBodyTicks.get(celestialBody) == null ? true : GSGuiCelestialSelection.\u61d3("\u5de8", (Integer)((Integer)this.celestialBodyTicks.get(celestialBody)));
        float f = celestialBody instanceof Planet ? 200.0f : 2.0f;
        float f2 = this.getScale(celestialBody);
        Vector3f vector3f = new Vector3f((float)GSGuiCelestialSelection.\u8be4("\u6a7b", (double)((float)bl / (f * celestialBody.getRelativeOrbitTime()) + celestialBody.getPhaseShift())) * f2, (float)GSGuiCelestialSelection.\uc104("\u420c", (double)((float)bl / (f * celestialBody.getRelativeOrbitTime()) + celestialBody.getPhaseShift())) * f2, 0.0f);
        if (celestialBody instanceof Planet) {
            Vector3f vector3f2 = this.getCelestialBodyPosition((CelestialBody)((Planet)celestialBody).getParentSolarSystem().getMainStar());
            return Vector3f.add((Vector3f)vector3f, (Vector3f)vector3f2, null);
        }
        if (celestialBody instanceof IChildBody) {
            Vector3f vector3f3 = this.getCelestialBodyPosition((CelestialBody)((IChildBody)celestialBody).getParentPlanet());
            return Vector3f.add((Vector3f)vector3f, (Vector3f)vector3f3, null);
        }
        if (celestialBody instanceof Satellite) {
            Vector3f vector3f4 = this.getCelestialBodyPosition((CelestialBody)((Satellite)celestialBody).getParentPlanet());
            return Vector3f.add((Vector3f)vector3f, (Vector3f)vector3f4, null);
        }
        return vector3f;
    }

    public void drawCircles() {
        CelestialBodyRenderEvent.CelestialRingRenderEvent.Post post;
        int n;
        float f;
        float f2;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glLineWidth((float)2.0f);
        int n2 = 0;
        float f3 = 0.06981317f;
        float f4 = (float)GSGuiCelestialSelection.\uc104("\u420c", (double)0.06981316953897476);
        float f5 = (float)GSGuiCelestialSelection.\u8be4("\u6a7b", (double)0.06981316953897476);
        for (Object object : GalaxyRegistry.getRegisteredPlanets().values()) {
            if (object.getParentSolarSystem() == null || GSGuiCelestialSelection.\u3652("\ucc81", object.getParentSolarSystem().getUnlocalizedParentGalaxyName(), (Object)this.galaxy) == false) continue;
            Vector3f vector3f2 = this.getCelestialBodyPosition((CelestialBody)object.getParentSolarSystem().getMainStar());
            f2 = 1.0f;
            if (this.selectedBody instanceof IChildBody && ((IChildBody)this.selectedBody).getParentPlanet() != object || this.selectedBody instanceof Planet && this.selectedBody != object && this.selectionCount >= 2) {
                f2 = this.lastSelectedBody == null && !(this.selectedBody instanceof IChildBody) && !(this.selectedBody instanceof Satellite) ? 1.0f - GSGuiCelestialSelection.\ufcc5("\u8275", (float)((float)this.ticksSinceSelection / 45.0f), (float)1.0f) : 0.0f;
            }
            if (this.selectedBody != object && this.selectionCount == 0) {
                f2 = 1.0f - GSGuiCelestialSelection.\ufcc5("\u8275", (float)(-this.zoom), (float)1.0f);
            }
            if (f2 == 0.0f) continue;
            switch (n2 % 2) {
                case 0: {
                    GL11.glColor4f((float)(object.getRingColorR() / 1.4f), (float)(object.getRingColorG() / 1.4f), (float)(object.getRingColorB() / 1.4f), (float)(f2 / 1.4f));
                    break;
                }
                case 1: {
                    GL11.glColor4f((float)object.getRingColorR(), (float)object.getRingColorG(), (float)object.getRingColorB(), (float)f2);
                }
            }
            CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre pre = new CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre((CelestialBody)object, vector3f2);
            MinecraftForge.EVENT_BUS.post((Event)pre);
            f = this.getScale((CelestialBody)object);
            float f6 = 0.0f;
            if (!pre.isCanceled()) {
                GL11.glTranslatef((float)vector3f2.x, (float)vector3f2.y, (float)vector3f2.z);
                GL11.glBegin((int)2);
                for (n = 0; n < 90; ++n) {
                    GL11.glVertex2f((float)f, (float)f6);
                    float f7 = f;
                    f = f4 * f - f5 * f6;
                    f6 = f5 * f7 + f4 * f6;
                }
                GL11.glEnd();
                GL11.glTranslatef((float)(-vector3f2.x), (float)(-vector3f2.y), (float)(-vector3f2.z));
                ++n2;
            }
            post = new CelestialBodyRenderEvent.CelestialRingRenderEvent.Post((CelestialBody)object);
            MinecraftForge.EVENT_BUS.post((Event)post);
        }
        n2 = 0;
        if (this.selectedBody != null) {
            Vector3f vector3f = this.getCelestialBodyPosition(this.selectedBody);
            if (this.selectedBody instanceof IChildBody) {
                vector3f = this.getCelestialBodyPosition((CelestialBody)((IChildBody)this.selectedBody).getParentPlanet());
            } else if (this.selectedBody instanceof Satellite) {
                vector3f = this.getCelestialBodyPosition((CelestialBody)((Satellite)this.selectedBody).getParentPlanet());
            }
            GL11.glTranslatef((float)vector3f.x, (float)vector3f.y, (float)0.0f);
            for (Vector3f vector3f2 : GalaxyRegistry.getRegisteredMoons().values()) {
                if ((vector3f2.getParentPlanet() != this.selectedBody || this.selectionCount < 2) && vector3f2 != this.selectedBody && !this.getSiblings(this.selectedBody).contains(vector3f2)) continue;
                f2 = this.getScale((CelestialBody)vector3f2);
                float f8 = 0.0f;
                f = 1.0f;
                if (this.selectionCount >= 2) {
                    float f9 = f = this.selectedBody instanceof IChildBody ? 1.0f : (float)GSGuiCelestialSelection.\ufcc5("\u8275", (float)GSGuiCelestialSelection.\u9f47("\u3a96", (float)((float)(this.ticksSinceSelection - 30) / 15.0f), (float)0.0f), (float)1.0f);
                    if (this.lastSelectedBody instanceof Moon && GalaxyRegistry.getMoonsForPlanet((Planet)((Moon)this.lastSelectedBody).getParentPlanet()).contains(vector3f2)) {
                        f = 1.0f;
                    }
                }
                if (f == 0.0f) continue;
                switch (n2 % 2) {
                    case 0: {
                        GL11.glColor4f((float)(vector3f2.getRingColorR() / 1.4f), (float)(vector3f2.getRingColorG() / 1.4f), (float)(vector3f2.getRingColorB() / 1.4f), (float)f);
                        break;
                    }
                    case 1: {
                        GL11.glColor4f((float)vector3f2.getRingColorR(), (float)vector3f2.getRingColorG(), (float)vector3f2.getRingColorB(), (float)f);
                    }
                }
                CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre pre = new CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre((CelestialBody)vector3f2, new Vector3f(0.0f, 0.0f, 0.0f));
                MinecraftForge.EVENT_BUS.post((Event)pre);
                if (!pre.isCanceled()) {
                    GL11.glBegin((int)2);
                    for (n = 0; n < 90; ++n) {
                        GL11.glVertex2f((float)f2, (float)f8);
                        float f10 = f2;
                        f2 = f4 * f2 - f5 * f8;
                        f8 = f5 * f10 + f4 * f8;
                    }
                    GL11.glEnd();
                    ++n2;
                }
                post = new CelestialBodyRenderEvent.CelestialRingRenderEvent.Post((CelestialBody)vector3f2);
                MinecraftForge.EVENT_BUS.post((Event)post);
            }
            for (Vector3f vector3f2 : GalaxyRegistry.getRegisteredSatellites().values()) {
                if (this.currenttier <= 0 || !this.possibleBodies.contains(vector3f2) || (vector3f2.getParentPlanet() != this.selectedBody || this.selectionCount == 1 || this.ticksSinceSelection <= 24) && vector3f2 != this.selectedBody && !(this.lastSelectedBody instanceof IChildBody)) continue;
                f2 = this.getScale((CelestialBody)vector3f2);
                float f11 = 0.0f;
                f = 1.0f;
                if (this.selectionCount >= 2) {
                    float f12 = f = this.selectedBody instanceof IChildBody ? 1.0f : (float)GSGuiCelestialSelection.\ufcc5("\u8275", (float)GSGuiCelestialSelection.\u9f47("\u3a96", (float)((float)(this.ticksSinceSelection - 30) / 15.0f), (float)0.0f), (float)1.0f);
                    if (this.lastSelectedBody instanceof Satellite && GalaxyRegistry.getSatellitesForCelestialBody((CelestialBody)((Satellite)this.lastSelectedBody).getParentPlanet()).contains(vector3f2)) {
                        f = 1.0f;
                    }
                }
                if (f == 0.0f) continue;
                switch (n2 % 2) {
                    case 0: {
                        GL11.glColor4f((float)vector3f2.getRingColorR(), (float)vector3f2.getRingColorG(), (float)vector3f2.getRingColorB(), (float)f);
                        break;
                    }
                    case 1: {
                        GL11.glColor4f((float)vector3f2.getRingColorR(), (float)vector3f2.getRingColorG(), (float)vector3f2.getRingColorB(), (float)f);
                    }
                }
                CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre pre = new CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre((CelestialBody)vector3f2, new Vector3f(0.0f, 0.0f, 0.0f));
                MinecraftForge.EVENT_BUS.post((Event)pre);
                if (!pre.isCanceled()) {
                    GL11.glBegin((int)2);
                    for (n = 0; n < 90; ++n) {
                        GL11.glVertex2f((float)f2, (float)f11);
                        float f13 = f2;
                        f2 = f4 * f2 - f5 * f11;
                        f11 = f5 * f13 + f4 * f11;
                    }
                    GL11.glEnd();
                    ++n2;
                }
                post = new CelestialBodyRenderEvent.CelestialRingRenderEvent.Post((CelestialBody)vector3f2);
                MinecraftForge.EVENT_BUS.post((Event)post);
            }
        }
        GL11.glLineWidth((float)1.0f);
    }

    protected float getScale(CelestialBody celestialBody) {
        return 3.0f * celestialBody.getRelativeDistanceFromCenter().unScaledDistance * (celestialBody instanceof Planet ? 25.0f : 0.2f);
    }

    public void func_73863_a(int n, int n2, float f) {
        block11: {
            Matrix4f matrix4f;
            float f2;
            if (Mouse.hasWheel() && (f2 = (float)Mouse.getDWheel() / (this.selectedBody == null ? 500.0f : 250.0f)) != 0.0f) {
                if (this.selectedBody == null || this.selectionState == GuiCelestialSelection.EnumSelectionState.PREVIEW && this.selectionCount < 2) {
                    this.zoom = (float)GSGuiCelestialSelection.\ufcc5("\u8275", (float)GSGuiCelestialSelection.\u9f47("\u3a96", (float)(this.zoom + f2 * (this.zoom + 2.0f) / 10.0f), (float)-1.0f), (float)3.0f);
                } else {
                    this.planetZoom = (float)GSGuiCelestialSelection.\ufcc5("\u8275", (float)GSGuiCelestialSelection.\u9f47("\u3a96", (float)(this.planetZoom + f2), (float)-11.0f), (float)5.0f);
                }
            }
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            Matrix4f matrix4f2 = new Matrix4f();
            Matrix4f.translate((Vector3f)new Vector3f(0.0f, 0.0f, -9000.0f), (Matrix4f)matrix4f2, (Matrix4f)matrix4f2);
            Matrix4f matrix4f3 = new Matrix4f();
            matrix4f3.m00 = 2.0f / (float)this.field_146294_l;
            matrix4f3.m11 = 2.0f / (float)(-this.field_146295_m);
            matrix4f3.m22 = -2.2222222E-4f;
            matrix4f3.m30 = -1.0f;
            matrix4f3.m31 = 1.0f;
            matrix4f3.m32 = -2.0f;
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            FloatBuffer floatBuffer = BufferUtils.createFloatBuffer((int)512);
            GSGuiCelestialSelection.\ufcbe("\u957e", (FloatBuffer)floatBuffer);
            matrix4f3.store(floatBuffer);
            GSGuiCelestialSelection.\u485e("\ucf10", (FloatBuffer)floatBuffer);
            GL11.glMultMatrix((FloatBuffer)floatBuffer);
            GSGuiCelestialSelection.\u473f("\ub6cc", (FloatBuffer)floatBuffer);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GSGuiCelestialSelection.\ufcbe("\u957e", (FloatBuffer)floatBuffer);
            matrix4f2.store(floatBuffer);
            GSGuiCelestialSelection.\u485e("\ucf10", (FloatBuffer)floatBuffer);
            GSGuiCelestialSelection.\u473f("\ub6cc", (FloatBuffer)floatBuffer);
            GL11.glMultMatrix((FloatBuffer)floatBuffer);
            this.setBlackBackground();
            ResourceLocation resourceLocation = BodiesHelper.galaxiesImg.get(GSGuiCelestialSelection.\u3478("\u94d3", this.galaxy, (CharSequence)GSGuiCelestialSelection$3.\u87c3("\u48c8\u2213\ue6ce\uc893\uffb2\u124b\ue7f0"), (CharSequence)"")) != null ? new ResourceLocation(BodiesHelper.galaxiesImg.get(GSGuiCelestialSelection.\u3478("\u94d3", this.galaxy, (CharSequence)GSGuiCelestialSelection$3.\u87c3("\u48c8\u2213\ue6ce\uc893\uffb2\u124b\ue7f0"), (CharSequence)""))) : new ResourceLocation((String)GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GalaxySpace.ASSET_PREFIX), (String)GSGuiCelestialSelection$3.\u87c3("\u4895\u2206\ue6c7\uc88a\uffbe\u1247\ue7ac\u502e\ufab6\uabcf\u0519\u5ca9\u27c4\u6d87\ue608\uf88e\u9410\u9bba\u6ac8\u0945\u713b")), (String)GSGuiCelestialSelection.\ua5f6("\u0173", this.galaxy)), (String)GSGuiCelestialSelection$3.\u87c3("\u4881\u2202\ue6cc\uc895"))));
            if (GSConfigCore.enableImgOnGalaxyMap) {
                try {
                    if (Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation) != null) {
                        this.setImgBackground(resourceLocation);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            GL11.glPushMatrix();
            this.mainWorldMatrix = matrix4f = this.setIsometric(f);
            float f3 = 7000.0f;
            if (!GSConfigCore.enableImgOnGalaxyMap) {
                this.drawGrid(f3, (float)(this.field_146295_m / 3) / 3.5f);
            }
            this.drawGyperCorridor();
            this.drawCircles();
            GL11.glPopMatrix();
            HashMap<CelestialBody, Matrix4f> hashMap = this.drawCelestialBodies(matrix4f);
            this.planetPosMap.clear();
            Iterator iterator = GSGuiCelestialSelection.\uaf79("\u9206", hashMap).iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Matrix4f matrix4f4 = (Matrix4f)entry.getValue();
                Matrix4f matrix4f5 = Matrix4f.mul((Matrix4f)matrix4f3, (Matrix4f)matrix4f4, (Matrix4f)matrix4f4);
                int n3 = (int)GSGuiCelestialSelection.\u3c2c("\u6c56", (double)(((double)matrix4f5.m30 * 0.5 + 0.5) * (double)Minecraft.func_71410_x().field_71443_c));
                int n4 = (int)GSGuiCelestialSelection.\u3c2c("\u6c56", (double)((double)Minecraft.func_71410_x().field_71440_d - ((double)matrix4f5.m31 * 0.5 + 0.5) * (double)Minecraft.func_71410_x().field_71440_d));
                Vector2f vector2f = new Vector2f((float)n3, (float)n4);
                Matrix4f matrix4f6 = new Matrix4f();
                matrix4f6.m00 = matrix4f5.m00;
                matrix4f6.m11 = matrix4f5.m11;
                matrix4f6.m22 = matrix4f5.m22;
                Vector4f vector4f = Matrix4f.transform((Matrix4f)matrix4f6, (Vector4f)new Vector4f(2.0f, -2.0f, 0.0f, 0.0f), null);
                float f4 = vector4f.y * ((float)Minecraft.func_71410_x().field_71440_d / 2.0f) * (float)(entry.getKey() instanceof Star ? 2 : 1) * (entry.getKey() == this.selectedBody ? 1.5f : 1.0f);
                this.planetPosMap.put(entry.getKey(), new Vector3f(vector2f.x, vector2f.y, f4));
            }
            this.drawSelectionCursor(floatBuffer, matrix4f);
            try {
                this.drawButtons(n, n2);
            }
            catch (Exception exception) {
                if (this.errorLogged) break block11;
                this.errorLogged = true;
                GCLog.severe((String)GSGuiCelestialSelection$3.\u87c3("\u48ff\u2200\ue6cd\uc890\uffa6\u1257\ue7b3\u506b\ufaac\uab84\u051b\u5cb2\u27d9\u6dc1\ue609\uf896\u9415\u9bb5\u6ad7\u091c\u7164\ua5ff\u3a47\u552c\ucf5a\ub86e\u9284\u7345\u22b2\udf5a\ua4ae\ua133\u68fb\ud2e3\u507b\ubfad\u0014\u82c3\u4a6b\ud096\u0a6a\ude87\u2496\ud115\u6964\u624b\u6b9c\u8035\u1874\u86c5\uf30f\u9401\u6764\ud4f8\uf019\u57ae\ufbc0\u7878\ua4a7\uabb9\u3e67\u23c1\u4598\u0df7\u9269\uc58c\u4a745\u45e6\u222b"));
                GCLog.severe((String)GSGuiCelestialSelection$3.\u87c3("\u4887\u2226\ue6ca\uc897\uffea\u1242\ue7ac\u5024\ufaa7\uab8c\u051b\u5cb1\u278d\u6dc1\ue61c\uf8cf\u9410\u9bb2\u6adb\u0959\u7178\ua5ea\u3a06\u5521\ucf5e\ub86f\u92d7\u734f\u22a4\udf5a\ua4a8\ua123\u68b6\ud2e7\u5035\ubfba\u0014\u82c1\u4a60\ud0d8\u0a70\ude80\u24d9\ud11a\u692a\u6222\u6bb9\u8071\u1873\u868a\uf30e\u9409\u6728\ud4f7\uf015\u57a8\ufbce\u781f\ua4e6\uab96\u3e6e\u23c7\u458f\u0df5\u922a\uc59d\u4a7a=\u45f4\u2263\u72eb\u3475\u5def\u200a\u9f2b\u8bd7\ua92c\u9a6b\uc568\u671f\ua479\u7d07\ua57e\ua131\ue657\u6d47\u7871\u4b2e\ud427\u4b90\u1b01\ue5f3\u273d\u0cb4\u9b87\uf02c\u7617\u575e\uba8d\u203f\u0c02\uce9e\ue505\u5c1a\u88be\ud672\u080d\uf632\uc7bf\uab8d\ufe46\u0dfc\ud6ec\u58f6\ua387\u45a3\ua6c7\uefef\u6335\udffd\u2ec2\u48f9\ubb34\u3ac2\u75eb\u0f24\u83a0\u9eae\u20f4\u5de1\u56e9\uafaf\ube06\uc4b4\u9677\ueafe\uc034\u910b\ub3b5\u30cc\uff89\u27e6\u1b2f\uee79\u4ee5\u2ffe\udcce\u721d\u7efb\u0359\u2ef2\ua38d\u2d17\udbae\uf448"));
                GSGuiCelestialSelection.\ucea2("\ua767", (Exception)exception);
            }
        }
        this.drawBorder();
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
    }

    public Matrix4f setIsometric(float f) {
        float f2;
        Matrix4f matrix4f = new Matrix4f();
        Matrix4f.translate((Vector3f)new Vector3f((float)this.field_146294_l / 2.0f, (float)this.field_146295_m / 2.0f, 0.0f), (Matrix4f)matrix4f, (Matrix4f)matrix4f);
        Matrix4f.rotate((float)((float)GSGuiCelestialSelection.\ub389("\u1d25", (double)this.isometx)), (Vector3f)new Vector3f(1.0f, 0.0f, 0.0f), (Matrix4f)matrix4f, (Matrix4f)matrix4f);
        Matrix4f.rotate((float)((float)GSGuiCelestialSelection.\ub389("\u1d25", (double)(-this.isometz))), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Matrix4f)matrix4f, (Matrix4f)matrix4f);
        this.zoom = f2 = this.getZoomAdvanced();
        Matrix4f.scale((Vector3f)new Vector3f(1.1f + f2, 1.1f + f2, 1.1f + f2), (Matrix4f)matrix4f, (Matrix4f)matrix4f);
        Vector2f vector2f = this.getTranslationAdvanced(f);
        this.position = this.getTranslationAdvanced(f);
        Matrix4f.translate((Vector3f)new Vector3f(-vector2f.x, -vector2f.y, 0.0f), (Matrix4f)matrix4f, (Matrix4f)matrix4f);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer((int)16);
        GSGuiCelestialSelection.\ufcbe("\u957e", (FloatBuffer)floatBuffer);
        matrix4f.store(floatBuffer);
        GSGuiCelestialSelection.\u485e("\ucf10", (FloatBuffer)floatBuffer);
        GL11.glMultMatrix((FloatBuffer)floatBuffer);
        return matrix4f;
    }

    public HashMap<CelestialBody, Matrix4f> drawCelestialBodies(Matrix4f matrix4f) {
        Object object;
        Object object2;
        Matrix4f matrix4f2;
        Star star2;
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer((int)512);
        HashMap hashMap = Maps.newHashMap();
        for (Object object3 : GalaxyRegistry.getRegisteredSolarSystems().values()) {
            star2 = object3.getMainStar();
            if (star2 == null || star2.getBodyIcon() == null || GSGuiCelestialSelection.\u3652("\ucc81", star2.getParentSolarSystem().getUnlocalizedParentGalaxyName(), (Object)this.galaxy) == false) continue;
            GL11.glPushMatrix();
            matrix4f2 = new Matrix4f(matrix4f);
            Matrix4f.translate((Vector3f)this.getCelestialBodyPosition((CelestialBody)star2), (Matrix4f)matrix4f2, (Matrix4f)matrix4f2);
            Matrix4f matrix4f3 = new Matrix4f();
            Matrix4f.rotate((float)((float)GSGuiCelestialSelection.\ub389("\u1d25", (double)this.isometz)), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Matrix4f)matrix4f3, (Matrix4f)matrix4f3);
            Matrix4f.rotate((float)((float)GSGuiCelestialSelection.\ub389("\u1d25", (double)(-this.isometx))), (Vector3f)new Vector3f(1.0f, 0.0f, 0.0f), (Matrix4f)matrix4f3, (Matrix4f)matrix4f3);
            matrix4f3 = Matrix4f.mul((Matrix4f)matrix4f2, (Matrix4f)matrix4f3, (Matrix4f)matrix4f3);
            GSGuiCelestialSelection.\ufcbe("\u957e", (FloatBuffer)floatBuffer);
            matrix4f3.store(floatBuffer);
            GSGuiCelestialSelection.\u485e("\ucf10", (FloatBuffer)floatBuffer);
            GL11.glMultMatrix((FloatBuffer)floatBuffer);
            float f = 1.0f;
            if (f != 0.0f) {
                object2 = new CelestialBodyRenderEvent.Pre((CelestialBody)star2, star2.getBodyIcon(), 8);
                MinecraftForge.EVENT_BUS.post((Event)object2);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f);
                if (object2.celestialBodyTexture != null) {
                    this.field_146297_k.field_71446_o.func_110577_a(object2.celestialBodyTexture);
                }
                if (!object2.isCanceled()) {
                    int n = GSGuiCelestialSelection.getWidthForCelestialBodyStatic((CelestialBody)star2);
                    if (star2 == this.selectedBody && this.selectionCount == 1) {
                        n /= 2;
                        n *= 3;
                    }
                    this.drawTexturedModalRect1(-n / 2, -n / 2, n, n, 0.0f, 0.0f, object2.textureSize, object2.textureSize, false, false, object2.textureSize, object2.textureSize);
                    GSGuiCelestialSelection.\u4ce3("\u61d0", (HashMap)hashMap, (Object)star2, (Object)matrix4f3);
                }
                object = new CelestialBodyRenderEvent.Post((CelestialBody)star2);
                MinecraftForge.EVENT_BUS.post((Event)object);
            }
            if (this.selectedBody == null) {
                GL11.glPushMatrix();
                GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
                object2 = object3.getMainStar().getLocalizedName();
                this.field_146289_q.func_78276_b((String)object2, 10, -5, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)0));
                GL11.glPopMatrix();
            }
            GSGuiCelestialSelection.\u473f("\ub6cc", (FloatBuffer)floatBuffer);
            GL11.glPopMatrix();
        }
        for (Object object3 : GalaxyRegistry.getRegisteredPlanets().values()) {
            if (object3.getBodyIcon() == null || GSGuiCelestialSelection.\u3652("\ucc81", object3.getParentSolarSystem().getUnlocalizedParentGalaxyName(), (Object)this.galaxy) == false) continue;
            GL11.glPushMatrix();
            star2 = new Matrix4f(matrix4f);
            Matrix4f.translate((Vector3f)this.getCelestialBodyPosition((CelestialBody)object3), (Matrix4f)star2, (Matrix4f)star2);
            matrix4f2 = new Matrix4f();
            Matrix4f.rotate((float)((float)GSGuiCelestialSelection.\ub389("\u1d25", (double)this.isometz)), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Matrix4f)matrix4f2, (Matrix4f)matrix4f2);
            Matrix4f.rotate((float)((float)GSGuiCelestialSelection.\ub389("\u1d25", (double)(-this.isometx))), (Vector3f)new Vector3f(1.0f, 0.0f, 0.0f), (Matrix4f)matrix4f2, (Matrix4f)matrix4f2);
            matrix4f2 = Matrix4f.mul((Matrix4f)star2, (Matrix4f)matrix4f2, (Matrix4f)matrix4f2);
            GSGuiCelestialSelection.\ufcbe("\u957e", (FloatBuffer)floatBuffer);
            matrix4f2.store(floatBuffer);
            GSGuiCelestialSelection.\u485e("\ucf10", (FloatBuffer)floatBuffer);
            GL11.glMultMatrix((FloatBuffer)floatBuffer);
            float f = 1.0f;
            if (this.selectedBody instanceof IChildBody && ((IChildBody)this.selectedBody).getParentPlanet() != object3 || this.selectedBody instanceof Planet && this.selectedBody != object3 && this.selectionCount >= 2) {
                f = this.lastSelectedBody == null && !(this.selectedBody instanceof IChildBody) ? 1.0f - GSGuiCelestialSelection.\ufcc5("\u8275", (float)((float)this.ticksSinceSelection / 25.0f), (float)1.0f) : 0.0f;
            }
            if (f != 0.0f) {
                String string;
                if (this.selectedBody == null) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                    string = object3.getLocalizedName();
                    this.field_146289_q.func_78276_b(string, 4 + GSGuiCelestialSelection.getWidthForCelestialBodyStatic((CelestialBody)object3), -5, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    GL11.glPopMatrix();
                }
                string = new CelestialBodyRenderEvent.Pre((CelestialBody)object3, object3.getBodyIcon(), 12);
                MinecraftForge.EVENT_BUS.post((Event)string);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f);
                if (((CelestialBodyRenderEvent.Pre)string).celestialBodyTexture != null) {
                    this.field_146297_k.field_71446_o.func_110577_a(((CelestialBodyRenderEvent.Pre)string).celestialBodyTexture);
                }
                if (!string.isCanceled()) {
                    int n = GSGuiCelestialSelection.getWidthForCelestialBodyStatic((CelestialBody)object3);
                    this.drawTexturedModalRect1(-n / 2, -n / 2, n, n, 0.0f, 0.0f, ((CelestialBodyRenderEvent.Pre)string).textureSize, ((CelestialBodyRenderEvent.Pre)string).textureSize, false, false, ((CelestialBodyRenderEvent.Pre)string).textureSize, ((CelestialBodyRenderEvent.Pre)string).textureSize);
                    GSGuiCelestialSelection.\u4ce3("\u61d0", (HashMap)hashMap, (Object)object3, (Object)matrix4f2);
                }
                object2 = new CelestialBodyRenderEvent.Post((CelestialBody)object3);
                MinecraftForge.EVENT_BUS.post((Event)object2);
            }
            GSGuiCelestialSelection.\u473f("\ub6cc", (FloatBuffer)floatBuffer);
            GL11.glPopMatrix();
        }
        for (Object object3 : GalaxyRegistry.getRegisteredMoons().values()) {
            if (object3.getBodyIcon() == null || this.selectionCount >= 2 || GSGuiCelestialSelection.\u3652("\ucc81", object3.getParentPlanet().getParentSolarSystem().getUnlocalizedParentGalaxyName(), (Object)this.galaxy) == false) continue;
            GL11.glPushMatrix();
            star2 = new Matrix4f(matrix4f);
            Matrix4f.translate((Vector3f)this.getCelestialBodyPosition((CelestialBody)object3), (Matrix4f)star2, (Matrix4f)star2);
            matrix4f2 = new Matrix4f();
            Matrix4f.rotate((float)((float)GSGuiCelestialSelection.\ub389("\u1d25", (double)this.isometz)), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Matrix4f)matrix4f2, (Matrix4f)matrix4f2);
            Matrix4f.rotate((float)((float)GSGuiCelestialSelection.\ub389("\u1d25", (double)(-this.isometx))), (Vector3f)new Vector3f(1.0f, 0.0f, 0.0f), (Matrix4f)matrix4f2, (Matrix4f)matrix4f2);
            Matrix4f.scale((Vector3f)new Vector3f(0.25f, 0.25f, 1.0f), (Matrix4f)matrix4f2, (Matrix4f)matrix4f2);
            matrix4f2 = Matrix4f.mul((Matrix4f)star2, (Matrix4f)matrix4f2, (Matrix4f)matrix4f2);
            GSGuiCelestialSelection.\ufcbe("\u957e", (FloatBuffer)floatBuffer);
            matrix4f2.store(floatBuffer);
            GSGuiCelestialSelection.\u485e("\ucf10", (FloatBuffer)floatBuffer);
            GL11.glMultMatrix((FloatBuffer)floatBuffer);
            float f = 1.0f;
            if (this.selectedBody instanceof IChildBody && (IChildBody)this.selectedBody != object3 || this.selectedBody instanceof Moon && this.selectedBody != object3 && this.selectionCount >= 2) {
                f = this.lastSelectedBody == null && !(this.selectedBody instanceof IChildBody) ? 1.0f - GSGuiCelestialSelection.\ufcc5("\u8275", (float)((float)this.ticksSinceSelection / 25.0f), (float)1.0f) : 0.0f;
            }
            if (f != 0.0f) {
                CelestialBodyRenderEvent.Pre pre = new CelestialBodyRenderEvent.Pre((CelestialBody)object3, object3.getBodyIcon(), 8);
                MinecraftForge.EVENT_BUS.post((Event)pre);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f);
                if (pre.celestialBodyTexture != null) {
                    this.field_146297_k.field_71446_o.func_110577_a(pre.celestialBodyTexture);
                }
                if (!pre.isCanceled()) {
                    int n = GSGuiCelestialSelection.getWidthForCelestialBodyStatic((CelestialBody)object3);
                    this.drawTexturedModalRect1(-n / 2, -n / 2, n, n, 0.0f, 0.0f, pre.textureSize, pre.textureSize, false, false, pre.textureSize, pre.textureSize);
                    GSGuiCelestialSelection.\u4ce3("\u61d0", (HashMap)hashMap, (Object)object3, (Object)matrix4f2);
                }
                object2 = new CelestialBodyRenderEvent.Post((CelestialBody)object3);
                MinecraftForge.EVENT_BUS.post((Event)object2);
            }
            GSGuiCelestialSelection.\u473f("\ub6cc", (FloatBuffer)floatBuffer);
            GL11.glPopMatrix();
        }
        if (this.selectedBody != null) {
            Matrix4f matrix4f4 = new Matrix4f(matrix4f);
            for (Star star2 : GalaxyRegistry.getRegisteredMoons().values()) {
                if (!((star2 == this.selectedBody || star2.getParentPlanet() == this.selectedBody) && (this.selectionCount != 1 && this.ticksSinceSelection > 35 || this.selectionCount == 1 && this.ticksSinceSelection > 2 || this.selectedBody == star2 || this.lastSelectedBody instanceof Moon && GalaxyRegistry.getMoonsForPlanet((Planet)((Moon)this.lastSelectedBody).getParentPlanet()).contains(star2))) && !this.getSiblings(this.selectedBody).contains(star2)) continue;
                GL11.glPushMatrix();
                matrix4f2 = new Matrix4f(matrix4f4);
                Matrix4f.translate((Vector3f)this.getCelestialBodyPosition((CelestialBody)star2), (Matrix4f)matrix4f2, (Matrix4f)matrix4f2);
                Matrix4f matrix4f5 = new Matrix4f();
                Matrix4f.rotate((float)((float)GSGuiCelestialSelection.\ub389("\u1d25", (double)this.isometz)), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Matrix4f)matrix4f5, (Matrix4f)matrix4f5);
                Matrix4f.rotate((float)((float)GSGuiCelestialSelection.\ub389("\u1d25", (double)(-this.isometx))), (Vector3f)new Vector3f(1.0f, 0.0f, 0.0f), (Matrix4f)matrix4f5, (Matrix4f)matrix4f5);
                Matrix4f.scale((Vector3f)new Vector3f(0.25f, 0.25f, 1.0f), (Matrix4f)matrix4f5, (Matrix4f)matrix4f5);
                matrix4f5 = Matrix4f.mul((Matrix4f)matrix4f2, (Matrix4f)matrix4f5, (Matrix4f)matrix4f5);
                GSGuiCelestialSelection.\ufcbe("\u957e", (FloatBuffer)floatBuffer);
                matrix4f5.store(floatBuffer);
                GSGuiCelestialSelection.\u485e("\ucf10", (FloatBuffer)floatBuffer);
                GL11.glMultMatrix((FloatBuffer)floatBuffer);
                GL11.glPushMatrix();
                CelestialBodyRenderEvent.Pre pre = new CelestialBodyRenderEvent.Pre((CelestialBody)star2, star2.getBodyIcon(), 8);
                MinecraftForge.EVENT_BUS.post((Event)pre);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (pre.celestialBodyTexture != null) {
                    this.field_146297_k.field_71446_o.func_110577_a(pre.celestialBodyTexture);
                }
                if (!pre.isCanceled()) {
                    int n = GSGuiCelestialSelection.getWidthForCelestialBodyStatic((CelestialBody)star2);
                    this.drawTexturedModalRect1(-n / 2, -n / 2, n, n, 0.0f, 0.0f, pre.textureSize, pre.textureSize, false, false, pre.textureSize, pre.textureSize);
                    GSGuiCelestialSelection.\u4ce3("\u61d0", (HashMap)hashMap, (Object)star2, (Object)matrix4f2);
                }
                object2 = new CelestialBodyRenderEvent.Post((CelestialBody)star2);
                MinecraftForge.EVENT_BUS.post((Event)object2);
                GL11.glPopMatrix();
                if (this.selectionCount == 2) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.4f, (float)0.4f, (float)0.3f);
                    object = star2.getLocalizedName();
                    this.field_146289_q.func_78276_b((String)object, 5, -5, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    GL11.glPopMatrix();
                }
                GSGuiCelestialSelection.\u473f("\ub6cc", (FloatBuffer)floatBuffer);
                GL11.glPopMatrix();
            }
            matrix4f4 = new Matrix4f(matrix4f);
            for (Star star2 : GalaxyRegistry.getRegisteredSatellites().values()) {
                if (this.currenttier <= 0 || !this.possibleBodies.contains(star2) || star2 != this.selectedBody && (star2.getParentPlanet() != this.selectedBody || this.selectionCount == 1) || this.ticksSinceSelection <= 35 && this.selectedBody != star2 && (!(this.lastSelectedBody instanceof Satellite) || !GalaxyRegistry.getSatellitesForCelestialBody((CelestialBody)((Satellite)this.lastSelectedBody).getParentPlanet()).contains(star2))) continue;
                GL11.glPushMatrix();
                matrix4f2 = new Matrix4f(matrix4f4);
                Matrix4f.translate((Vector3f)this.getCelestialBodyPosition((CelestialBody)star2), (Matrix4f)matrix4f2, (Matrix4f)matrix4f2);
                Matrix4f matrix4f6 = new Matrix4f();
                Matrix4f.rotate((float)((float)GSGuiCelestialSelection.\ub389("\u1d25", (double)this.isometz)), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Matrix4f)matrix4f6, (Matrix4f)matrix4f6);
                Matrix4f.rotate((float)((float)GSGuiCelestialSelection.\ub389("\u1d25", (double)(-this.isometx))), (Vector3f)new Vector3f(1.0f, 0.0f, 0.0f), (Matrix4f)matrix4f6, (Matrix4f)matrix4f6);
                Matrix4f.scale((Vector3f)new Vector3f(0.25f, 0.25f, 1.0f), (Matrix4f)matrix4f6, (Matrix4f)matrix4f6);
                matrix4f6 = Matrix4f.mul((Matrix4f)matrix4f2, (Matrix4f)matrix4f6, (Matrix4f)matrix4f6);
                GSGuiCelestialSelection.\ufcbe("\u957e", (FloatBuffer)floatBuffer);
                matrix4f6.store(floatBuffer);
                GSGuiCelestialSelection.\u485e("\ucf10", (FloatBuffer)floatBuffer);
                GL11.glMultMatrix((FloatBuffer)floatBuffer);
                CelestialBodyRenderEvent.Pre pre = new CelestialBodyRenderEvent.Pre((CelestialBody)star2, star2.getBodyIcon(), 8);
                MinecraftForge.EVENT_BUS.post((Event)pre);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(pre.celestialBodyTexture);
                if (!pre.isCanceled()) {
                    int n = GSGuiCelestialSelection.getWidthForCelestialBodyStatic((CelestialBody)star2);
                    this.drawTexturedModalRect(-n / 2, -n / 2, n, n, 0.0f, 0.0f, pre.textureSize, pre.textureSize, false, false, pre.textureSize, pre.textureSize);
                    GSGuiCelestialSelection.\u4ce3("\u61d0", (HashMap)hashMap, (Object)star2, (Object)matrix4f2);
                }
                object2 = new CelestialBodyRenderEvent.Post((CelestialBody)star2);
                MinecraftForge.EVENT_BUS.post((Event)object2);
                GSGuiCelestialSelection.\u473f("\ub6cc", (FloatBuffer)floatBuffer);
                GL11.glPopMatrix();
            }
        }
        return hashMap;
    }

    public void drawGyperCorridor() {
        for (AstronomyUtil$PathsSolarSystems astronomyUtil$PathsSolarSystems : this.paths) {
            Vector3 vector3 = GSGuiCelestialSelection.\ubab1("\ufd0a", (AstronomyUtil$PathsSolarSystems)astronomyUtil$PathsSolarSystems).getMapPosition();
            Vector3 vector32 = GSGuiCelestialSelection.\uc543("\u8ad4", (AstronomyUtil$PathsSolarSystems)astronomyUtil$PathsSolarSystems).getMapPosition();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            GL11.glLineWidth((float)2.0f);
            GL11.glBegin((int)1);
            GL11.glVertex3f((float)vector3.floatX(), (float)vector3.floatY(), (float)vector3.floatZ());
            GL11.glVertex3f((float)vector32.floatX(), (float)vector32.floatY(), (float)vector32.floatZ());
            GL11.glEnd();
            GL11.glLineWidth((float)1.0f);
        }
    }

    public void drawTexturedModalRect1(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, boolean bl, boolean bl2, float f9, float f10) {
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
        float f11 = 1.0f / f9;
        float f12 = 1.0f / f10;
        Tessellator tessellator = Tessellator.field_78398_a;
        float f13 = bl2 ? 0.0f : f8;
        float f14 = bl2 ? f8 : 0.0f;
        float f15 = bl ? f7 : 0.0f;
        float f16 = bl ? 0.0f : f7;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)f, (double)(f2 + f4), (double)this.field_73735_i, (double)((f5 + f15) * f11), (double)((f6 + f13) * f12));
        tessellator.func_78374_a((double)(f + f3), (double)(f2 + f4), (double)this.field_73735_i, (double)((f5 + f16) * f11), (double)((f6 + f13) * f12));
        tessellator.func_78374_a((double)(f + f3), (double)f2, (double)this.field_73735_i, (double)((f5 + f16) * f11), (double)((f6 + f14) * f12));
        tessellator.func_78374_a((double)f, (double)f2, (double)this.field_73735_i, (double)((f5 + f15) * f11), (double)((f6 + f14) * f12));
        tessellator.func_78381_a();
    }

    /*
     * WARNING - void declaration
     */
    protected void drawSelectionCursor(FloatBuffer floatBuffer, Matrix4f matrix4f) {
        switch (this.selectionCount) {
            case 1: {
                void var6_12;
                void var6_10;
                if (this.selectedBody == null) break;
                GL11.glPushMatrix();
                Matrix4f matrix4f2 = new Matrix4f(matrix4f);
                Matrix4f.translate((Vector3f)this.getCelestialBodyPosition(this.selectedBody), (Matrix4f)matrix4f2, (Matrix4f)matrix4f2);
                Matrix4f matrix4f3 = new Matrix4f();
                Matrix4f.rotate((float)((float)GSGuiCelestialSelection.\ub389("\u1d25", (double)this.isometz)), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Matrix4f)matrix4f3, (Matrix4f)matrix4f3);
                Matrix4f.rotate((float)((float)GSGuiCelestialSelection.\ub389("\u1d25", (double)(-this.isometx))), (Vector3f)new Vector3f(1.0f, 0.0f, 0.0f), (Matrix4f)matrix4f3, (Matrix4f)matrix4f3);
                matrix4f3 = Matrix4f.mul((Matrix4f)matrix4f2, (Matrix4f)matrix4f3, (Matrix4f)matrix4f3);
                GSGuiCelestialSelection.\ufcbe("\u957e", (FloatBuffer)floatBuffer);
                matrix4f3.store(floatBuffer);
                GSGuiCelestialSelection.\u485e("\ucf10", (FloatBuffer)floatBuffer);
                GL11.glMultMatrix((FloatBuffer)floatBuffer);
                GSGuiCelestialSelection.\u473f("\ub6cc", (FloatBuffer)floatBuffer);
                GL11.glPushMatrix();
                GL11.glScalef((float)0.06666667f, (float)0.06666667f, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                float f = this.getZoomAdvanced() < 4.9f ? (float)(GSGuiCelestialSelection.\u8be4("\u6a7b", (double)((float)this.ticksSinceSelection / 2.0f)) * 0.5 + 0.5) : 1.0f;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)(1.0f * f));
                int n = GSGuiCelestialSelection.getWidthForCelestialBodyStatic(this.selectedBody);
                if (n % 2 != 0) {
                    ++var6_10;
                }
                if (this.selectionCount == 1) {
                    void var6_12 = var6_10 / 2;
                    var6_12 = var6_12 * 3;
                }
                void var6_13 = var6_12 * 10;
                this.drawTexturedModalRect((int)(-var6_13), (int)(-var6_13), (int)(var6_13 * 2), (int)(var6_13 * 2), 266, 29, 100, 100, false, false);
                GL11.glPopMatrix();
                if (this.selectedBody instanceof Star) {
                    GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
                    String string = this.selectedBody.getLocalizedName();
                    this.field_146289_q.func_78276_b(string, 15 + GSGuiCelestialSelection.getWidthForCelestialBodyStatic(this.selectedBody), -5, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)0));
                } else if (this.selectedBody instanceof Planet) {
                    GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                    String string = this.selectedBody.getLocalizedName();
                    this.field_146289_q.func_78276_b(string, 10 + GSGuiCelestialSelection.getWidthForCelestialBodyStatic(this.selectedBody), -5, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                } else if (this.selectedBody instanceof IChildBody) {
                    GL11.glScalef((float)0.15f, (float)0.15f, (float)0.15f);
                    String string = this.selectedBody.getLocalizedName();
                    this.field_146289_q.func_78276_b(string, 12 + GSGuiCelestialSelection.getWidthForCelestialBodyStatic(this.selectedBody), -5, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                }
                GL11.glPopMatrix();
                break;
            }
            case 2: {
                if (this.selectedBody == null) break;
                GL11.glPushMatrix();
                Matrix4f matrix4f4 = new Matrix4f(matrix4f);
                Matrix4f.translate((Vector3f)this.getCelestialBodyPosition(this.selectedBody), (Matrix4f)matrix4f4, (Matrix4f)matrix4f4);
                Matrix4f matrix4f5 = new Matrix4f();
                Matrix4f.rotate((float)((float)GSGuiCelestialSelection.\ub389("\u1d25", (double)this.isometz)), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Matrix4f)matrix4f5, (Matrix4f)matrix4f5);
                Matrix4f.rotate((float)((float)GSGuiCelestialSelection.\ub389("\u1d25", (double)(-this.isometx))), (Vector3f)new Vector3f(1.0f, 0.0f, 0.0f), (Matrix4f)matrix4f5, (Matrix4f)matrix4f5);
                matrix4f5 = Matrix4f.mul((Matrix4f)matrix4f4, (Matrix4f)matrix4f5, (Matrix4f)matrix4f5);
                GSGuiCelestialSelection.\ufcbe("\u957e", (FloatBuffer)floatBuffer);
                matrix4f5.store(floatBuffer);
                GSGuiCelestialSelection.\u485e("\ucf10", (FloatBuffer)floatBuffer);
                GL11.glMultMatrix((FloatBuffer)floatBuffer);
                GSGuiCelestialSelection.\u473f("\ub6cc", (FloatBuffer)floatBuffer);
                Object object = this.zoom + 1.0f - this.planetZoom;
                reference var6_14 = GSGuiCelestialSelection.\u9f47("\u3a96", (float)0.3f, (float)(1.5f / ((float)this.ticksSinceSelection / 5.0f))) * 2.0f / object;
                object = GSGuiCelestialSelection.\u9f47("\u3a96", (float)object, (float)1.0E-4f);
                GL11.glScalef((float)var6_14, (float)var6_14, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                float f = this.getZoomAdvanced() < 4.9f ? (float)(GSGuiCelestialSelection.\u8be4("\u6a7b", (double)((float)this.ticksSinceSelection / 1.0f)) * 0.5 + 0.5) : 1.0f;
                GL11.glColor4f((float)0.4f, (float)0.8f, (float)1.0f, (float)(1.0f * f));
                this.drawTexturedModalRect(-50, -50, 100, 100, 266, 29, 100, 100, false, false);
                GL11.glPopMatrix();
                break;
            }
        }
    }

    public static int getWidthForCelestialBodyStatic(CelestialBody celestialBody) {
        float f = celestialBody.getRelativeSize();
        if (f > 5.0f) {
            f = 5.0f;
        }
        if ((double)f < 0.9 && celestialBody instanceof IChildBody) {
            f = 1.0f;
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiCelestialSelection && (celestialBody != ((GSGuiCelestialSelection)Minecraft.func_71410_x().field_71462_r).selectedBody || ((GSGuiCelestialSelection)Minecraft.func_71410_x().field_71462_r).selectionCount != 1)) {
            return (int)(celestialBody instanceof Star ? 8.0f * f : (celestialBody instanceof Planet ? 4.0f * f : (celestialBody instanceof IChildBody ? 2.0f * f : (float)(celestialBody instanceof Satellite ? 4 : 2))));
        }
        return (int)(celestialBody instanceof Star ? 12.0f * f : (celestialBody instanceof Planet ? 8.0f * f : (celestialBody instanceof IChildBody ? 6.0f * f : (float)(celestialBody instanceof Satellite ? 6 : 2))));
    }

    public void drawButtons(int n, int n2) {
        Object object;
        Object object2;
        if (this.coef < 1) {
            this.coef = 1;
        }
        if (this.coef > 10) {
            this.coef = 10;
        }
        if (!this.mapMode && this.ticksSinceMenuOpen % 1 == 0 && !this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d && this.timer < this.traveltime && this.check) {
            this.timer += 1 * this.coef;
        }
        if (this.selectedBody != null) {
            double d;
            CelestialBody celestialBody;
            float f = 0.0f;
            object2 = GalacticraftCore.solarSystemSol;
            Object object3 = 0.0;
            if (this.selectedBody instanceof Planet) {
                if (!(this.field_146297_k.field_71439_g.field_70170_p.field_73011_w instanceof WorldProviderSurface)) {
                    celestialBody = ((IGalacticraftWorldProvider)this.field_146297_k.field_71439_g.field_70170_p.field_73011_w).getCelestialBody();
                    if (celestialBody instanceof Planet) {
                        object2 = ((Planet)celestialBody).getParentSolarSystem();
                        f = celestialBody.getRelativeDistanceFromCenter().unScaledDistance;
                        object3 = GSGuiCelestialSelection.\u9008("\uc189", (double)GSGuiCelestialSelection.\u3c2c("\u6c56", (double)((f - this.selectedBody.getRelativeDistanceFromCenter().unScaledDistance) * 100.0f))) / 100.0;
                    }
                    if (celestialBody instanceof IChildBody) {
                        object2 = ((IChildBody)celestialBody).getParentPlanet().getParentSolarSystem();
                        f = ((IChildBody)celestialBody).getParentPlanet().getRelativeDistanceFromCenter().unScaledDistance;
                        object3 = GSGuiCelestialSelection.\u9008("\uc189", (double)GSGuiCelestialSelection.\u3c2c("\u6c56", (double)((f - this.selectedBody.getRelativeDistanceFromCenter().unScaledDistance) * 100.0f))) / 100.0 + (double)(celestialBody.getRelativeDistanceFromCenter().unScaledDistance / 100.0f);
                    }
                } else {
                    f = GalacticraftCore.planetOverworld.getRelativeDistanceFromCenter().unScaledDistance;
                    object2 = GalacticraftCore.solarSystemSol;
                    object3 = GSGuiCelestialSelection.\u9008("\uc189", (double)GSGuiCelestialSelection.\u3c2c("\u6c56", (double)((f - this.selectedBody.getRelativeDistanceFromCenter().unScaledDistance) * 100.0f))) / 100.0;
                }
                celestialBody = ((Planet)this.selectedBody).getParentSolarSystem();
                reference var10_13 = GSGuiCelestialSelection.\u3c2c("\u6c56", (double)(Vector3.distance((Vector3)object2.getMapPosition(), (Vector3)celestialBody.getMapPosition()) / 100.0)) * 100.0 - GSGuiCelestialSelection.\u9008("\uc189", (double)GSGuiCelestialSelection.\u3c2c("\u6c56", (double)((f + this.selectedBody.getRelativeDistanceFromCenter().unScaledDistance) * 100.0f)));
                d = (double)(object2 == celestialBody ? (double)GSGuiCelestialSelection.\u186e("\u0144", (double)(object3 * 70.0)) : var10_13);
                if (GSGuiCelestialSelection.\u3652("\ucc81", object2.getUnlocalizedParentGalaxyName(), (Object)celestialBody.getUnlocalizedParentGalaxyName()) == false) {
                    d *= 100.0;
                }
                this.traveltime = (d < 0.0 ? 10 : (int)d) * 100;
                for (object = 0; object <= 6; ++object) {
                    if (!(object3 >= 0.2 * (double)object) || GSGuiCelestialSelection.\u3652("\ucc81", object2.getUnlocalizedParentGalaxyName(), (Object)celestialBody.getUnlocalizedParentGalaxyName()) == false || !this.selectedBody.getReachable()) continue;
                    this.tierneed = object2 == celestialBody ? (object == 6 ? object : object + 1) : 6;
                }
                object = GSGuiCelestialSelection.\u186e("\u0144", (double)((double)this.fuelRocketLevel - (double)this.fuelRocketLevel * object3));
                this.fuelSet = object > 0 ? object : 0;
            } else if (!(this.selectedBody instanceof Star) && this.selectedBody instanceof IChildBody) {
                int n6;
                if (!(this.field_146297_k.field_71439_g.field_70170_p.field_73011_w instanceof WorldProviderSurface)) {
                    celestialBody = ((WorldProviderSpace)this.field_146297_k.field_71439_g.field_70170_p.field_73011_w).getCelestialBody();
                    f = 0.0f;
                    if (celestialBody instanceof Planet) {
                        object2 = ((Planet)celestialBody).getParentSolarSystem();
                        f = celestialBody.getRelativeDistanceFromCenter().unScaledDistance;
                        object3 = GSGuiCelestialSelection.\u9008("\uc189", (double)GSGuiCelestialSelection.\u3c2c("\u6c56", (double)((f - ((IChildBody)this.selectedBody).getParentPlanet().getRelativeDistanceFromCenter().unScaledDistance) * 100.0f))) / 100.0 + (double)(this.selectedBody.getRelativeDistanceFromCenter().unScaledDistance / 100.0f);
                    } else if (celestialBody instanceof IChildBody) {
                        object2 = ((IChildBody)celestialBody).getParentPlanet().getParentSolarSystem();
                        f = ((IChildBody)celestialBody).getParentPlanet().getRelativeDistanceFromCenter().unScaledDistance;
                        object3 = GSGuiCelestialSelection.\u9008("\uc189", (double)GSGuiCelestialSelection.\u3c2c("\u6c56", (double)((f - ((IChildBody)this.selectedBody).getParentPlanet().getRelativeDistanceFromCenter().unScaledDistance) * 100.0f))) / 100.0 + (double)(this.selectedBody.getRelativeDistanceFromCenter().unScaledDistance / 100.0f);
                    }
                } else {
                    f = GalacticraftCore.planetOverworld.getRelativeDistanceFromCenter().unScaledDistance;
                    object2 = GalacticraftCore.solarSystemSol;
                    object3 = GSGuiCelestialSelection.\u9008("\uc189", (double)GSGuiCelestialSelection.\u3c2c("\u6c56", (double)((f - ((IChildBody)this.selectedBody).getParentPlanet().getRelativeDistanceFromCenter().unScaledDistance) * 100.0f))) / 100.0 + (double)(this.selectedBody.getRelativeDistanceFromCenter().unScaledDistance / 100.0f);
                }
                celestialBody = ((IChildBody)this.selectedBody).getParentPlanet().getParentSolarSystem();
                double d2 = d = object2 == celestialBody ? (double)GSGuiCelestialSelection.\u186e("\u0144", (double)(object3 * 70.0)) : (double)(GSGuiCelestialSelection.\u3c2c("\u6c56", (double)(Vector3.distance((Vector3)object2.getMapPosition(), (Vector3)celestialBody.getMapPosition()) / 200.0)) * GSGuiCelestialSelection.\u3c2c("\u6c56", (double)((((IChildBody)this.selectedBody).getParentPlanet().getRelativeDistanceFromCenter().unScaledDistance + f) * 100.0f)));
                if (GSGuiCelestialSelection.\u3652("\ucc81", object2.getUnlocalizedParentGalaxyName(), (Object)celestialBody.getUnlocalizedParentGalaxyName()) == false) {
                    d *= 100.0;
                }
                this.traveltime = (int)d * 100;
                boolean n3 = false;
                while (n6 <= 6) {
                    if (object3 >= 0.25 * (double)n6 && GSGuiCelestialSelection.\u3652("\ucc81", object2.getUnlocalizedParentGalaxyName(), (Object)celestialBody.getUnlocalizedParentGalaxyName()) != false && this.selectedBody.getReachable()) {
                        this.tierneed = object2 == celestialBody ? (n6 == 6 ? n6 : n6 + true) : 6;
                    }
                    ++n6;
                }
                int satellite = (int)GSGuiCelestialSelection.\u186e("\u0144", (double)((double)this.fuelRocketLevel - (double)this.fuelRocketLevel * object3 * 1.2));
                this.fuelSet = satellite > 0 ? satellite : 0;
            }
        }
        this.field_73735_i = 0.0f;
        boolean bl = false;
        this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH, 74, 11, 0, 392, 148, 22, false, false);
        object2 = GSGuiCelestialSelection.\ub18c("\ubb3e", GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e1\u165b\ue24c\u7c9a\u8623\ue25d\ube61\u49d6\uf339\u0f51\u8912\u1e0c")));
        this.field_146289_q.func_78276_b((String)object2, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 40 - this.field_146289_q.func_78256_a((String)object2) / 2, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 1, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
        int n3 = (int)GSGuiCelestialSelection.\ufcc5("\u8275", (float)95.0f, (float)((float)this.ticksSinceMenuOpen * 12.0f));
        boolean bl2 = this.selectionCount == 2 && !(this.selectedParent instanceof Planet);
        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
        this.drawTexturedModalRect(GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH - 95 + n3, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 12, 95, 41, 0, 436, 95, 41, false, false);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        if (GalaxyRegistry.getRegisteredSolarSystems().size() > 1) {
            this.drawTexturedModalRect(GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 2 - 13 + n3, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 37, 5, 5, 110, 448, 5, 5, false, true);
        }
        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
        object2 = this.getParentName();
        this.field_146289_q.func_78276_b((String)object2, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 9 - 95 + n3, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 34, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)0));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
        this.drawTexturedModalRect(GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 2 - 95 + n3, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 14, 93, 17, 95, 436, 93, 17, false, false);
        if (this.galaxylist.size() > 1) {
            this.drawTexturedModalRect(GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 2 - 13 + n3, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 19, 5, 5, 110, 448, 5, 5, false, true);
        }
        object2 = GCCoreUtil.translate((String)this.galaxy);
        this.field_146289_q.func_78276_b((String)object2, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 7 - 95 + n3, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 16, ColorUtil.to32BitColor((int)255, (int)0, (int)255, (int)255));
        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
        if (this.showGalaxyList) {
            for (int i = 0; i < this.galaxylist.size(); ++i) {
                int n7 = 19;
                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)((float)n3 / 95.0f));
                this.drawTexturedModalRect(GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 6 + n3, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 14 * i + n7, 86, 10, 0, 489, 86, 10, false, false);
                GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)((float)n3 / 95.0f));
                this.drawTexturedModalRect(GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 5 + n3, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 14 * i + n7 - 1, 93, 12, 95, 464, 93, 12, false, false);
                object2 = GCCoreUtil.translate((String)this.galaxylist.get(i));
                this.field_146289_q.func_78276_b((String)object2, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 10 + n3, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 14 * i + n7 + 1, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)0));
            }
        }
        if (this.showStarList) {
            Iterator iterator = GSGuiCelestialSelection.\uaf79("\u9206", this.starlist).iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Object object4 = GSGuiCelestialSelection.\u61d3("\u5de8", (Integer)((Integer)entry.getValue()));
                int n18 = 19;
                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)((float)n3 / 95.0f));
                this.drawTexturedModalRect(GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 6 + n3, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 14 * object4 + n18, 86, 10, 0, 489, 86, 10, false, false);
                GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)((float)n3 / 95.0f));
                this.drawTexturedModalRect(GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 5 + n3, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 14 * object4 + n18 - 1, 93, 12, 95, 464, 93, 12, false, false);
                object2 = ((SolarSystem)entry.getKey()).getMainStar().getLocalizedName();
                this.field_146289_q.func_78276_b((String)object2, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 10 + n3, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 14 * object4 + n18 + 1, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)0));
            }
        }
        List list = this.getChildren(bl2 ? this.selectedBody : this.selectedParent);
        this.drawChildren(list, 0, 0, true);
        if (this.mapMode) {
            this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
            this.drawTexturedModalRect(this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 74, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH, 74, 11, 0, 392, 148, 22, true, false);
            object2 = GSGuiCelestialSelection.\ub18c("\ubb3e", GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e7\u1642\ue251\u7c8f\u8661\ue25c\ube67\u4995\uf332")));
            this.field_146289_q.func_78276_b((String)object2, this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 40 - this.field_146289_q.func_78256_a((String)object2) / 2, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 1, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
        }
        int n4 = this.field_146295_m - GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH - 22;
        int n8 = GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH - 53;
        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
        this.drawTexturedModalRect(n8 + 53, n4 - 5, 40, 12, 0, 456, 40, 12, false, false);
        this.drawTexturedModalRect(n8 + 93, n4 - 5, 45, 12, 50, 456, 45, 12, false, false);
        object2 = this.hideInfo ? GSGuiCelestialSelection$0.\uc2b0("\ue345\u2ffe\u3a74\u2287\u77e3\u3c7c\u1373\u4005\u4b63\u9591\u57a4") : GSGuiCelestialSelection$0.\uc2b0("\ue344\u2ff9\u3a66\u2284\u77ed\u3c75\u1336\u406c\u4b44\u9599\u57ad\uc4d0");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        this.field_146289_q.func_78276_b((String)object2, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 20, n4 - 3, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)0));
        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
        this.drawTexturedModalRect(n8 + 53, n4 - 19, 40, 12, 0, 456, 40, 12, false, false);
        this.drawTexturedModalRect(n8 + 93, n4 - 19, 45, 12, 50, 456, 45, 12, false, false);
        object2 = this.small_mode ? GSGuiCelestialSelection$0.\uc2b0("\ue353\u2ffd\u3a74\u2289\u77e3\u3c39\u131e\u4023\u4b69\u9592") : GSGuiCelestialSelection$0.\uc2b0("\ue34e\u2fff\u3a67\u2288\u77ee\u3c75\u1373\u4001\u4b62\u9593\u57ae");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        this.field_146289_q.func_78276_b((String)object2, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 20, n4 - 17, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)0));
        if (this.selectedBody != null) {
            int n5;
            int n6;
            int n7;
            int n9;
            int n36;
            int n10;
            int n11;
            Object object3;
            int n12;
            Object bl4;
            Object object9;
            int n13;
            this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain1);
            GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
            if (this.selectedBody instanceof Satellite) {
                Satellite bodiesData = (Satellite)this.selectedBody;
                n13 = ((Map)this.spaceStationMap.get(GSGuiCelestialSelection.\u8f2a("\u69d7", (int)this.getSatelliteParentID(bodiesData)))).size();
                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain1);
                object = GSGuiCelestialSelection.\u0e11("\u1e8a", (int)(this.field_146295_m / 2 / 14), (int)n13);
                this.drawTexturedModalRect(this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 95, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH, 95, 53, GSGuiCelestialSelection.\ua56c("\uaecc", this.selectedStationOwner) == false ? 95 : 0, 186, 95, 53, false, false);
                if (this.spaceStationListOffset <= 0) {
                    GL11.glColor4f((float)0.65f, (float)0.65f, (float)0.65f, (float)1.0f);
                } else {
                    GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                }
                this.drawTexturedModalRect(this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 85, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 45, 61, 4, 0, 239, 61, 4, false, false);
                if (object + this.spaceStationListOffset >= n13) {
                    GL11.glColor4f((float)0.65f, (float)0.65f, (float)0.65f, (float)1.0f);
                } else {
                    GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                }
                this.drawTexturedModalRect(this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 85, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 49 + object * 14, 61, 4, 0, 239, 61, 4, false, true);
                GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                if (((Map)this.spaceStationMap.get(GSGuiCelestialSelection.\u8f2a("\u69d7", (int)this.getSatelliteParentID(bodiesData)))).get(this.selectedStationOwner) == null) {
                    object2 = GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f1\u165f\ue254\u7c9e\u862c\ue246\ube55\u49ab\uf379\u0f5e\u891e\u1e04\uacdd"));
                    this.drawSplitString((String)object2, this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 47, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 20, 91, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255), false, false);
                } else {
                    object2 = GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f1\u1649\ue277\u7c8c\u8621\ue257\ube74\u49d6\uf339\u0f51\u8912\u1e0c"));
                    this.field_146289_q.func_78276_b((String)object2, this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 85, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 18, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    object2 = this.selectedStationOwner;
                    this.smallFontRenderer.drawString((String)object2, this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 47 - this.smallFontRenderer.getStringWidth((String)object2) / 2, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 30, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                }
                Iterator n23 = ((Map)this.spaceStationMap.get(GSGuiCelestialSelection.\u8f2a("\u69d7", (int)this.getSatelliteParentID(bodiesData)))).entrySet().iterator();
                object9 = 0;
                bl4 = 0;
                while (n23.hasNext() && object9 < object) {
                    Map.Entry n24 = n23.next();
                    if (bl4 >= this.spaceStationListOffset) {
                        this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                        n12 = 0;
                        if (GSGuiCelestialSelection.\u017a("\u7ddf", (String)n24.getKey(), (String)this.selectedStationOwner) != false) {
                            n12 -= 5;
                        }
                        this.drawTexturedModalRect(this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 95 + n12, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 50 + object9 * 14, 93, 12, 95, 464, 93, 12, true, false);
                        object2 = "";
                        String n30 = ((GuiCelestialSelection.StationDataGUI)n24.getValue()).getStationName();
                        for (int i = 0; this.smallFontRenderer.getStringWidth((String)object2) < 80 && i < GSGuiCelestialSelection.\ua56c("\uaecc", n30); ++i) {
                            object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)object2), (String)GSGuiCelestialSelection.\uf917("\u40b0", n30, (int)i, (int)(i + 1))));
                        }
                        if (this.smallFontRenderer.getStringWidth((String)object2) >= 80) {
                            object2 = GSGuiCelestialSelection.\uf917("\u40b0", (String)object2, (int)0, (int)(GSGuiCelestialSelection.\ua56c("\uaecc", (String)object2) - 3));
                            object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)object2), (String)GSGuiCelestialSelection$0.\uc2b0("\ue32e\u2fbe\u3a3b")));
                        }
                        this.smallFontRenderer.drawString((String)object2, this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 88 + n12, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 51 + object9 * 14, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                        ++object9;
                    }
                    ++bl4;
                }
            } else if (!this.hideInfo) {
                int n14 = GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH;
                n13 = this.field_146294_l - n14;
                object = n14;
                int n15 = this.field_146295_m - n14;
                this.field_146297_k.field_71446_o.func_110577_a(guiMain2);
                GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                object9 = 100;
                bl4 = this.zoomTooltipPos;
                if (this.zoomTooltipPos != 132) {
                    this.zoomTooltipPos = bl4 = (Object)GSGuiCelestialSelection.\u0e11("\u1e8a", (int)(this.ticksSinceSelection * 8), (int)132);
                }
                int n29 = GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + object9;
                n12 = this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - bl4 + 7;
                int n16 = this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 18;
                this.field_146297_k.field_71446_o.func_110577_a(guiMain2);
                GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                if (this.selectedBody instanceof Star || this.selectedBody.getTierRequirement() < 0) {
                    this.drawTexturedModalRect(n12 - 7, n29 + 12, 133, 31, 0, 79, 266, 62, true, false);
                    this.drawTexturedModalRect(n12 - 7, n29 + 43, 133, 37, 0, 442, 266, 70, true, false);
                } else if (!this.small_mode) {
                    this.drawTexturedModalRect(n12 - 7, n29 + 13, 133, 237, 0, 79, 266, 433, true, false);
                } else {
                    this.drawTexturedModalRect(n12 - 7, n29 + 13, 133, 80, 0, 79, 266, 142, true, false);
                    this.drawTexturedModalRect(n12 - 7, n29 + 93, 133, 17, 0, 472, 266, 40, true, false);
                    this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                    this.drawTexturedModalRect(n12 + 5, n29 + 112, 30, 11, 0, 414, 60, 22, false, false);
                    this.drawTexturedModalRect(n12 + 35, n29 + 112, 50, 11, 128, 414, 40, 22, false, false);
                    this.drawTexturedModalRect(n12 + 85, n29 + 112, 30, 11, 128, 414, 60, 22, false, false);
                    this.field_146289_q.func_78276_b(GSGuiCelestialSelection$0.\uc2b0("\ue33c\u2fbd"), n12 + 15, n29 + 114, ColorUtil.to32BitColor((int)255, (int)150, (int)200, (int)255));
                    this.field_146289_q.func_78276_b((String)GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\u2dc1("\u0398", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GSGuiCelestialSelection$0.\uc2b0("\ue350\u2ff1\u3a72\u2280\u77b5\u3c39")), (int)(this.small_page + 1))), n12 + 45, n29 + 113, ColorUtil.to32BitColor((int)255, (int)150, (int)200, (int)255));
                    this.field_146289_q.func_78276_b(GSGuiCelestialSelection$0.\uc2b0("\ue32d\u2fae"), n12 + 96, n29 + 114, ColorUtil.to32BitColor((int)255, (int)150, (int)200, (int)255));
                    this.field_146297_k.field_71446_o.func_110577_a(guiMain2);
                }
                object9 += 15;
                object2 = GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e5\u165f\ue256\u7c9e\u863d\ue253\ube6a\u4991\uf339\u0f56\u8910\u1e1b\uacd5\u2203\u84df\u0a48\u028d\u8b00"));
                if (!this.small_mode) {
                    this.field_146289_q.func_78276_b((String)object2, n12, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + object9, ColorUtil.to32BitColor((int)255, (int)150, (int)200, (int)255));
                } else if (this.small_page == 0 || this.selectedBody instanceof Star) {
                    this.field_146289_q.func_78276_b((String)object2, n12, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + object9, ColorUtil.to32BitColor((int)255, (int)150, (int)200, (int)255));
                }
                if (this.selectedBody.getTierRequirement() != -1 && !(this.selectedBody instanceof Star)) {
                    object2 = GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f2\u1652\ue241\u7c88\u8626\ue251\ube67\u4994\uf327\u0f51\u890d\u1e08\uacd5\u2207\u84df\u0a44\u0290\u8b1d"));
                    if (!this.small_mode) {
                        this.field_146289_q.func_78276_b((String)object2, n12, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + object9 + 40, ColorUtil.to32BitColor((int)255, (int)150, (int)200, (int)255));
                    } else if (this.small_page == 0) {
                        this.field_146289_q.func_78276_b((String)object2, n12, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + object9 + 40, ColorUtil.to32BitColor((int)255, (int)150, (int)200, (int)255));
                    }
                    object2 = GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e3\u164e\ue255\u7c94\u863c\ue242\ube6e\u499d\uf325\u0f59\u891c\u1e19\uacd9\u2210\u84ca\u0a4c\u0287\u8b1a\ud879\ude63\ud380"));
                    if (!this.small_mode) {
                        this.field_146289_q.func_78276_b((String)object2, n12, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + object9 + 82, ColorUtil.to32BitColor((int)255, (int)150, (int)200, (int)255));
                    } else if (this.small_page == 1) {
                        this.field_146289_q.func_78276_b((String)object2, n12, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + object9, ColorUtil.to32BitColor((int)255, (int)150, (int)200, (int)255));
                    }
                    object2 = GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e3\u164e\ue255\u7c94\u863c\ue242\ube6e\u499d\uf325\u0f59\u891c\u1e0a\uacd7\u220f\u84db\u0a4e\u028c\u8b0b\ud872\ude65\ud380"));
                    if (!this.small_mode) {
                        this.field_146289_q.func_78276_b((String)object2, n12, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + object9 + 166, ColorUtil.to32BitColor((int)255, (int)150, (int)200, (int)255));
                    } else if (this.small_page == 2) {
                        this.field_146289_q.func_78276_b((String)object2, n12, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + object9, ColorUtil.to32BitColor((int)255, (int)150, (int)200, (int)255));
                    }
                }
                if (this.selectedBody instanceof Star || this.selectedBody.getTierRequirement() == -1) {
                    object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f6\u1643\ue248\u7c9e"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f1\u164e\ue259\u7c89"))));
                }
                if (this.selectedBody instanceof Planet && this.selectedBody.getTierRequirement() != -1) {
                    object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f6\u1643\ue248\u7c9e"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f2\u1656\ue259\u7c95\u862a\ue246"))));
                }
                if (this.selectedBody instanceof Moon) {
                    object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f6\u1643\ue248\u7c9e"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41ef\u1655\ue257\u7c95"))));
                }
                if (this.selectedBody instanceof Satellite) {
                    object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f6\u1643\ue248\u7c9e"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f1\u165b\ue24c\u7c9e\u8623\ue25e\ube6f\u498c\uf332"))));
                }
                if (this.selectedBody.getTierRequirement() == -2) {
                    object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f6\u1643\ue248\u7c9e"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e6\u3c77\u1335\u4023\u4b23\u9595\u57a7\uc4de\u41e1\u1651\ue250\u7c94\u8623\ue257\ube28\u4996\uf336\u0f5d\u891a"))));
                }
                if (!this.small_mode) {
                    this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 10, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                } else if (this.small_page == 0 || this.selectedBody instanceof Star) {
                    this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 10, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                }
                WorldProvider iterator = WorldUtil.getProviderForDimensionClient((int)this.selectedBody.getDimensionID());
                if (iterator instanceof IGalacticraftWorldProvider) {
                    Planet n22;
                    if (((IGalacticraftWorldProvider)iterator).getCelestialBody() instanceof Planet) {
                        n22 = (Planet)((IGalacticraftWorldProvider)iterator).getCelestialBody();
                        this.galaxy = n22.getParentSolarSystem().getUnlocalizedParentGalaxyName();
                    } else if (((IGalacticraftWorldProvider)iterator).getCelestialBody() instanceof IChildBody) {
                        n22 = (IChildBody)((IGalacticraftWorldProvider)iterator).getCelestialBody();
                        this.galaxy = n22.getParentPlanet().getParentSolarSystem().getUnlocalizedParentGalaxyName();
                    }
                }
                object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e1\u1656\ue259\u7c88\u863c"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (String)GSGuiCelestialSelection.\ub721("\uff8b", (CelestialBody)this.selectedBody, (WorldProvider)iterator)));
                if (!this.small_mode) {
                    this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 20, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                } else if (this.small_page == 0 || this.selectedBody instanceof Star) {
                    this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 20, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                }
                if (this.selectedBody.getTierRequirement() != -1 && !(this.selectedBody instanceof Star)) {
                    object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e5\u1648\ue259\u7c8d\u8626\ue246\ube7f"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f7\u1654\ue253\u7c95\u8620\ue245\ube68"))));
                    if (this.selectedBody.getReachable() && this.selectedBody != GalacticraftCore.planetOverworld) {
                        object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\u62d4("\ubb12", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e5\u1648\ue259\u7c8d\u8626\ue246\ube7f"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (float)((IGalacticraftWorldProvider)iterator).getGravity()));
                    } else if (this.selectedBody == GalacticraftCore.planetOverworld) {
                        object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\u7903("\u9313", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e5\u1648\ue259\u7c8d\u8626\ue246\ube7f"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (double)0.085));
                    }
                    if (!this.small_mode) {
                        this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 38 + 12, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    } else if (this.small_page == 0) {
                        this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 38 + 12, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    }
                    object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e6\u165b\ue241\u7c97\u862a\ue25c\ube61\u498c\uf33f"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f7\u1654\ue253\u7c95\u8620\ue245\ube68"))));
                    if (this.selectedBody.getReachable() && this.selectedBody != GalacticraftCore.planetOverworld) {
                        object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub9ea("\ub529", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub9ea("\ub529", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e6\u165b\ue241\u7c97\u862a\ue25c\ube61\u498c\uf33f"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (long)(((WorldProviderSpace)iterator).getDayLength() / 1000L)), (String)GSGuiCelestialSelection$0.\uc2b0("\ue33a")), (long)(((WorldProviderSpace)iterator).getDayLength() % 1000L)), (String)GSGuiCelestialSelection$0.\uc2b0("\ue368")));
                    } else if (this.selectedBody == GalacticraftCore.planetOverworld) {
                        object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e6\u165b\ue241\u7c97\u862a\ue25c\ube61\u498c\uf33f"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320\u2fa2\u3a21\u22df\u77bf\u3c71")));
                    }
                    if (!this.small_mode) {
                        this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 38 + 22, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    } else if (this.small_page == 0) {
                        this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 38 + 22, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    }
                    object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e3\u164e\ue255\u7c94\u863f\ue240\ube63\u498b\uf324\u0f45\u890d\u1e0c"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f7\u1654\ue253\u7c95\u8620\ue245\ube68"))));
                    if (iterator instanceof IAdvancedSpace) {
                        object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\u2dc1("\u0398", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e3\u164e\ue255\u7c94\u863f\ue240\ube63\u498b\uf324\u0f45\u890d\u1e0c"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (int)((IAdvancedSpace)iterator).AtmosphericPressure()));
                    } else if (this.selectedBody == GalacticraftCore.planetOverworld) {
                        object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\u2dc1("\u0398", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e3\u164e\ue255\u7c94\u863f\ue240\ube63\u498b\uf324\u0f45\u890d\u1e0c"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (int)0));
                    }
                    if (!this.small_mode) {
                        this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 78 + 14, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    } else if (this.small_page == 1) {
                        this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 10, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    }
                    object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f6\u165f\ue255\u7c8b\u862a\ue240\ube67\u498c\uf322\u0f42\u891a"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f7\u1654\ue253\u7c95\u8620\ue245\ube68"))));
                    if (this.selectedBody.getReachable()) {
                        float itemStack = 0.0f;
                        try {
                            itemStack = ((IGalacticraftWorldProvider)iterator).getThermalLevelModifier();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        itemStack = itemStack == 0.0f ? 40.0f : itemStack * 40.0f;
                        object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\u2dc1("\u0398", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f6\u165f\ue255\u7c8b\u862a\ue240\ube67\u498c\uf322\u0f42\u891a"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (int)((int)itemStack)), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320\u2fd3")));
                    }
                    if (!this.small_mode) {
                        this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 78 + 24, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    } else if (this.small_page == 1) {
                        this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 20, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    }
                    object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f5\u1653\ue256\u7c9f\u862a\ue25c\ube63\u498a\uf330\u0f49"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f7\u1654\ue253\u7c95\u8620\ue245\ube68"))));
                    if (this.selectedBody.getReachable() && this.selectedBody != GalacticraftCore.planetOverworld && iterator instanceof IAdvancedSpace) {
                        object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\u62d4("\ubb12", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f5\u1653\ue256\u7c9f\u862a\ue25c\ube63\u498a\uf330\u0f49"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (float)((float)GSGuiCelestialSelection.\u186e("\u0144", (double)(((IAdvancedSpace)iterator).getSolarWindMultiplier() * 1000.0)) / 1000.0f)));
                    } else if (this.selectedBody == GalacticraftCore.planetOverworld) {
                        object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\u7903("\u9313", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f5\u1653\ue256\u7c9f\u862a\ue25c\ube63\u498a\uf330\u0f49"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (double)-1.0));
                    }
                    if (!this.small_mode) {
                        this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 76 + 36, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    } else if (this.small_page == 1) {
                        this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 30, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    }
                    object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f1\u1655\ue254\u7c9a\u863d\ue257\ube68\u499d\uf325\u0f57\u8906"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f7\u1654\ue253\u7c95\u8620\ue245\ube68"))));
                    if (iterator instanceof ISolarLevel) {
                        float entry = (float)GSGuiCelestialSelection.\u186e("\u0144", (double)((((ISolarLevel)iterator).getSolarEnergyMultiplier() - 1.0) * 1000.0)) / 10.0f;
                        object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\u62d4("\ubb12", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f1\u1655\ue254\u7c9a\u863d\ue257\ube68\u499d\uf325\u0f57\u8906"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (float)entry), (String)GSGuiCelestialSelection$0.\uc2b0("\ue325")));
                    }
                    if (this.selectedBody == GalacticraftCore.planetOverworld) {
                        object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f1\u1655\ue254\u7c9a\u863d\ue257\ube68\u499d\uf325\u0f57\u8906"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320\u2fa1\u3a25\u22d5\u77aa")));
                    }
                    if (!this.small_mode) {
                        this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 76 + 48, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    } else if (this.small_page == 1) {
                        this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 40, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    }
                    object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f5\u1653\ue256\u7c9f\u863c\ue242\ube63\u499d\uf333"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f7\u1654\ue253\u7c95\u8620\ue245\ube68"))));
                    if (iterator instanceof IGalacticraftWorldProvider) {
                        object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\u62d4("\ubb12", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f5\u1653\ue256\u7c9f\u863c\ue242\ube63\u499d\uf333"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (float)((IGalacticraftWorldProvider)iterator).getWindLevel()), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320\u2fc7\u3a3a\u2289")));
                    }
                    if (this.selectedBody == GalacticraftCore.planetOverworld) {
                        object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f5\u1653\ue256\u7c9f\u863c\ue242\ube63\u499d\uf333"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320\u2fa1\u3a3b\u22d5\u77af\u3c4e\u137c\u4020")));
                    }
                    if (!this.small_mode) {
                        this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 74 + 60, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    } else if (this.small_page == 1) {
                        this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 50, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    }
                    object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e0\u1648\ue25d\u7c9a\u863b\ue25a\ube67\u499a\uf33b\u0f55\u891e\u1e1d\uacd5\u220d"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f7\u1654\ue253\u7c95\u8620\ue245\ube68"))));
                    if (this.selectedBody.getReachable() && this.selectedBody != GalacticraftCore.planetOverworld) {
                        object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e0\u1648\ue25d\u7c9a\u863b\ue25a\ube67\u499a\uf33b\u0f55\u891e\u1e1d\uacd5\u220d"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (String)this.localeBoolean(((IGalacticraftWorldProvider)iterator).hasBreathableAtmosphere())));
                    }
                    if (this.selectedBody == GalacticraftCore.planetOverworld) {
                        object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e0\u1648\ue25d\u7c9a\u863b\ue25a\ube67\u499a\uf33b\u0f55\u891e\u1e1d\uacd5\u220d"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (String)this.localeBoolean(true)));
                    }
                    if (!this.small_mode) {
                        this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 77 + 99, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    } else if (this.small_page == 2) {
                        this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 10, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    }
                    object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f1\u1655\ue254\u7c9a\u863d\ue240\ube67\u499c\uf33e\u0f51\u890b\u1e00\uacd7\u220c"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f7\u1654\ue253\u7c95\u8620\ue245\ube68"))));
                    if (iterator instanceof IAdvancedSpace) {
                        object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f1\u1655\ue254\u7c9a\u863d\ue240\ube67\u499c\uf33e\u0f51\u890b\u1e00\uacd7\u220c"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (String)this.localeBoolean(((IAdvancedSpace)iterator).SolarRadiation())));
                    } else if (this.selectedBody == GalacticraftCore.planetOverworld) {
                        object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f1\u1655\ue254\u7c9a\u863d\ue240\ube67\u499c\uf33e\u0f51\u890b\u1e00\uacd7\u220c"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (String)this.localeBoolean(false)));
                    }
                    if (!this.small_mode) {
                        this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 78 + 66, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    } else if (this.small_page == 1) {
                        this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 60, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    }
                    object2 = this.selectedBody.getReachable() && GSGuiCelestialSelection.\u2da6("\ubd33", (ArrayList)this.selectedBody.atmosphere) == false ? GSGuiCelestialSelection.\u1f84("\ub5f8", (ArrayList)this.selectedBody.atmosphere) : GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41ec\u1655\ue259\u7c8f\u8622\ue25d\ube75\u4988\uf33f\u0f55\u890d\u1e0c"));
                    if (!this.small_mode) {
                        this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 75 + 121, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    } else if (this.small_page == 2) {
                        this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 30, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    }
                }
                object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\u2dc1("\u0398", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f6\u1648\ue259\u7c8d\u862a\ue25e\ube72\u4991\uf33a\u0f55"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (int)this.traveltime));
                if (this.selectedBody.getTierRequirement() != -1 && this.selectedBody.getReachable() && !this.mapMode) {
                    if (!this.small_mode) {
                        this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 82 + 143, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    } else if (this.small_page == 2) {
                        this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 50, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    }
                }
                object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\u2dc1("\u0398", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e4\u164f\ue25d\u7c97\u863c\ue257\ube72"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (int)this.fuelSet));
                if (this.selectedBody.getTierRequirement() != -1 && this.selectedBody.getReachable() && !this.mapMode) {
                    if (!this.small_mode) {
                        this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 84 + 132, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    } else if (this.small_page == 2) {
                        this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 60, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    }
                }
                if (!(this.selectedBody instanceof Moon)) {
                    if (this.selectedBody instanceof Star) {
                        int n17 = 0;
                        for (CelestialBody celestialBody : this.getChildren(this.selectedParent)) {
                            if (celestialBody.getTierRequirement() < 0) continue;
                            ++n17;
                        }
                        object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\u2dc1("\u0398", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f2\u1656\ue259\u7c95\u862a\ue246\ube75"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (int)n17));
                        this.field_146289_q.func_78276_b((String)object2, this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - bl4 + 7, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + object9 + 29 + 11, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    } else if (this.selectedBody.getTierRequirement() != -1) {
                        object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\u2dc1("\u0398", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41ef\u1655\ue257\u7c95\u863c"))), (String)GSGuiCelestialSelection$0.\uc2b0("\ue320")), (int)this.getChildren(this.selectedBody).size()));
                        if (!this.small_mode) {
                            this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 75 + 132, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                        } else if (this.small_page == 2) {
                            this.field_146289_q.func_78276_b((String)object2, n12, object + object9 + 40, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                        }
                    }
                }
                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
            }
            BodiesHelper.BodiesData bodiesData = (BodiesHelper.BodiesData)GSGuiCelestialSelection.\u57ef("\ua662", BodiesHelper.data, (Object)this.selectedBody);
            n13 = GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH;
            object = this.field_146294_l - n13;
            int n18 = n13;
            if (bodiesData != null && !bodiesData.getItemStacks().isEmpty()) {
                object9 = 99;
                bl4 = this.zoomTooltipPos;
                if (this.zoomTooltipPos != 125) {
                    this.zoomTooltipPos = bl4 = (Object)GSGuiCelestialSelection.\u0e11("\u1e8a", (int)(this.ticksSinceSelection * 8), (int)125);
                }
                int bl3 = this.field_146295_m - n13 - object9;
                n12 = object - bl4;
                if (!this.small_mode) {
                    this.field_146297_k.field_71446_o.func_110577_a(guiMain2);
                    GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                    this.drawTexturedModalRect(n12 - 7, bl3 + 12, 133, 31, 0, 79, 266, 62, true, false);
                    this.drawTexturedModalRect(n12 - 7, bl3 + 43, 133, 37, 0, 462, 266, 50, true, false);
                }
                if (!this.small_mode) {
                    this.field_146289_q.func_78276_b(GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f0\u165f\ue249\u7c8e\u8626\ue240\ube63\u499c\uf308\u0f55\u890e\u1e1c\uacd1\u2212\u84c6\u0a44\u028c\u8b1a\ud832\ude7f\ud392\u7248\u4d27")), n12, bl3 + 15, ColorUtil.to32BitColor((int)255, (int)150, (int)200, (int)255));
                } else if (this.small_page == 3) {
                    this.field_146289_q.func_78276_b(GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f0\u165f\ue249\u7c8e\u8626\ue240\ube63\u499c\uf308\u0f55\u890e\u1e1c\uacd1\u2212\u84c6\u0a44\u028c\u8b1a\ud832\ude7f\ud392\u7248\u4d27")), n12, bl3 - 245, ColorUtil.to32BitColor((int)255, (int)150, (int)200, (int)255));
                }
                int n19 = 0;
                for (ItemStack itemStack : bodiesData.getItemStacks()) {
                    int n35;
                    object3 = new ItemStack(itemStack.func_77973_b(), 1, itemStack.func_77960_j());
                    int n20 = this.getAmountInInventory(itemStack);
                    n11 = -1000;
                    int arrayList = -1000;
                    if (!this.small_mode) {
                        n11 = n12 - 5 + n19 % 6 * 85 / 4 + 5;
                        arrayList = this.field_146295_m - n18 - 70 + (n19 > 0 && n19 % 6 == 0 ? 24 : 0);
                        RenderHelper.func_74520_c();
                        field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.field_71446_o, object3.func_77946_l(), n11, arrayList);
                        RenderHelper.func_74518_a();
                    } else if (this.small_page == 3) {
                        n11 = n12 - 5 + n19 % 6 * 85 / 4 + 5;
                        arrayList = n18 + 155 + (n19 > 0 && n19 % 6 == 0 ? 24 : 0);
                        RenderHelper.func_74520_c();
                        field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.field_71446_o, object3.func_77946_l(), n11, arrayList);
                        RenderHelper.func_74518_a();
                    }
                    if (n >= n11 && n <= n11 + 16 && n2 >= arrayList && n2 <= arrayList + 16) {
                        GL11.glDepthMask((boolean)true);
                        GL11.glEnable((int)2929);
                        GL11.glPushMatrix();
                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)300.0f);
                        n10 = this.field_146289_q.func_78256_a(itemStack.func_82833_r());
                        n35 = n - n10 / 2;
                        n36 = n2 - 12;
                        n9 = 8;
                        if (n35 + n10 > this.field_146294_l) {
                            n35 -= n35 - this.field_146294_l + n10;
                        }
                        if (n36 + n9 + 6 > this.field_146295_m) {
                            n36 = this.field_146295_m - n9 - 6;
                        }
                        n7 = ColorUtil.to32BitColor((int)190, (int)0, (int)153, (int)255);
                        this.func_73733_a(n35 - 3, n36 - 4, n35 + n10 + 3, n36 - 3, n7, n7);
                        this.func_73733_a(n35 - 3, n36 + n9 + 3, n35 + n10 + 3, n36 + n9 + 4, n7, n7);
                        this.func_73733_a(n35 - 3, n36 - 3, n35 + n10 + 3, n36 + n9 + 3, n7, n7);
                        this.func_73733_a(n35 - 4, n36 - 3, n35 - 3, n36 + n9 + 3, n7, n7);
                        this.func_73733_a(n35 + n10 + 3, n36 - 3, n35 + n10 + 4, n36 + n9 + 3, n7, n7);
                        n6 = ColorUtil.to32BitColor((int)170, (int)0, (int)153, (int)255);
                        n5 = (n6 & 0xFEFEFE) >> 1 | n6 & 0xFF000000;
                        this.func_73733_a(n35 - 3, n36 - 3 + 1, n35 - 3 + 1, n36 + n9 + 3 - 1, n6, n5);
                        this.func_73733_a(n35 + n10 + 2, n36 - 3 + 1, n35 + n10 + 3, n36 + n9 + 3 - 1, n6, n5);
                        this.func_73733_a(n35 - 3, n36 - 3, n35 + n10 + 3, n36 - 3 + 1, n6, n6);
                        this.func_73733_a(n35 - 3, n36 + n9 + 2, n35 + n10 + 3, n36 + n9 + 3, n5, n5);
                        this.field_146289_q.func_78276_b(itemStack.func_82833_r(), n35, n36, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                        GL11.glPopMatrix();
                    }
                    n10 = n20 >= itemStack.field_77994_a ? 1 : 0;
                    object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\u2dc1("\u0398", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)""), (int)itemStack.field_77994_a));
                    n35 = n10 | this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d ? ColorUtil.to32BitColor((int)255, (int)0, (int)255, (int)0) : ColorUtil.to32BitColor((int)255, (int)255, (int)0, (int)0);
                    this.field_146289_q.func_78276_b((String)object2, n11 + 8 - this.field_146289_q.func_78256_a((String)object2) / 2, arrayList + 15, n35);
                    ++n19;
                }
            }
            if (this.check) {
                this.drawTransitBar(this.getScaledTravelTime(138));
            }
            if (this.canCreateSpaceStation(this.selectedBody) && !(this.selectedBody instanceof Satellite)) {
                reference var16_43;
                GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain1);
                object9 = GSGuiCelestialSelection.\uc4fa("\ub588", (int)0, (int)(this.drawSplitString(GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e1\u165b\ue256\u7cb8\u863d\ue257\ube67\u498c\uf332\u0f63\u890f\u1e08\uacdb\u2207\u84f8\u0a55\u0283\u8b1a\ud875\ude7e\ud39d\u720b\u4d2c\u0852\u00ca\ud831")), 0, 0, 91, 0, true, true) - 2));
                this.canCreateOffset = object9 * this.smallFontRenderer.FONT_HEIGHT;
                this.drawTexturedModalRect(this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 93, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 16, 93, 4, 159, 102, 93, 4, false, false);
                this.drawTexturedModalRect(this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 69, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 12, 61, 4, 0, 170, 61, 4, false, false);
                for (bl4 = 0; bl4 < object9; ++bl4) {
                    this.drawTexturedModalRect(this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 95, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + bl4 * this.smallFontRenderer.FONT_HEIGHT, 93, this.smallFontRenderer.FONT_HEIGHT, 159, 106, 93, this.smallFontRenderer.FONT_HEIGHT, false, false);
                }
                SpaceStationRecipe string = WorldUtil.getSpaceStationRecipe((int)this.selectedBody.getDimensionID());
                boolean bl3 = true;
                if (string != null) {
                    var16_43 = GSGuiCelestialSelection.\u3ce2("\u52f5", (float)((float)GSGuiCelestialSelection.\u7ac5("\ua017", (double)((float)string.getRecipeSize() / 4.0f)) - 1.0f)) * 25;
                }
                this.drawTexturedModalRect(this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 93, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 20 + this.canCreateOffset, 93, 43 + var16_43, 159, 106, 93, 43, false, false);
                if (string != null) {
                    GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.1f, (float)1.0f);
                    n12 = 1;
                    int n21 = 0;
                    Iterator iterator = GSGuiCelestialSelection.\uaf79("\u9206", (HashMap)string.getInput()).iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        object3 = entry.getKey();
                        int n22 = this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 95 + n21 % 4 * 93 / 4 + 5;
                        n11 = GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 35 + this.canCreateOffset + (n21 > 0 && n21 % 4 == 0 ? 24 : 0);
                        if (object3 instanceof ItemStack) {
                            int n23 = this.getAmountInInventory((ItemStack)object3);
                            RenderHelper.func_74520_c();
                            GuiCelestialSelection.field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.field_71446_o, object3.func_77946_l(), n22, n11);
                            RenderHelper.func_74518_a();
                            GL11.glEnable((int)3042);
                            if (n >= n22 && n <= n22 + 16 && n2 >= n11 && n2 <= n11 + 16) {
                                GL11.glDepthMask((boolean)true);
                                GL11.glEnable((int)2929);
                                GL11.glPushMatrix();
                                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)300.0f);
                                n10 = this.smallFontRenderer.getStringWidth(((ItemStack)object3).func_82833_r());
                                int n24 = n - n10 / 2;
                                n36 = n2 - 12;
                                n9 = 8;
                                if (n24 + n10 > this.field_146294_l) {
                                    n24 -= n24 - this.field_146294_l + n10;
                                }
                                if (n36 + n9 + 6 > this.field_146295_m) {
                                    n36 = this.field_146295_m - n9 - 6;
                                }
                                n7 = ColorUtil.to32BitColor((int)190, (int)0, (int)153, (int)255);
                                this.func_73733_a(n24 - 3, n36 - 4, n24 + n10 + 3, n36 - 3, n7, n7);
                                this.func_73733_a(n24 - 3, n36 + n9 + 3, n24 + n10 + 3, n36 + n9 + 4, n7, n7);
                                this.func_73733_a(n24 - 3, n36 - 3, n24 + n10 + 3, n36 + n9 + 3, n7, n7);
                                this.func_73733_a(n24 - 4, n36 - 3, n24 - 3, n36 + n9 + 3, n7, n7);
                                this.func_73733_a(n24 + n10 + 3, n36 - 3, n24 + n10 + 4, n36 + n9 + 3, n7, n7);
                                n6 = ColorUtil.to32BitColor((int)170, (int)0, (int)153, (int)255);
                                n5 = (n6 & 0xFEFEFE) >> 1 | n6 & 0xFF000000;
                                this.func_73733_a(n24 - 3, n36 - 3 + 1, n24 - 3 + 1, n36 + n9 + 3 - 1, n6, n5);
                                this.func_73733_a(n24 + n10 + 2, n36 - 3 + 1, n24 + n10 + 3, n36 + n9 + 3 - 1, n6, n5);
                                this.func_73733_a(n24 - 3, n36 - 3, n24 + n10 + 3, n36 - 3 + 1, n6, n6);
                                this.func_73733_a(n24 - 3, n36 + n9 + 2, n24 + n10 + 3, n36 + n9 + 3, n5, n5);
                                this.smallFontRenderer.drawString(((ItemStack)object3).func_82833_r(), n24, n36, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                                GL11.glPopMatrix();
                            }
                            object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ubfdf("\u7622", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\u2dc1("\u0398", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)""), (int)n23), (String)GSGuiCelestialSelection$0.\uc2b0("\ue32f")), entry.getValue()));
                            int n25 = n10 = n23 >= GSGuiCelestialSelection.\u61d3("\u5de8", (Integer)((Integer)entry.getValue())) ? 1 : 0;
                            if (n10 == 0 && n12 != 0) {
                                n12 = 0;
                            }
                            int n26 = (n10 | this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d) != 0 ? ColorUtil.to32BitColor((int)255, (int)0, (int)255, (int)0) : ColorUtil.to32BitColor((int)255, (int)255, (int)0, (int)0);
                            this.smallFontRenderer.drawString((String)object2, n22 + 8 - this.smallFontRenderer.getStringWidth((String)object2) / 2, n11 + 15, n26);
                        } else if (object3 instanceof ArrayList) {
                            ArrayList arrayList = (ArrayList)object3;
                            n10 = 0;
                            Object object4 = GSGuiCelestialSelection.\u8bd4("\ubc33", (ArrayList)arrayList);
                            while (object4.hasNext()) {
                                ItemStack itemStack = (ItemStack)object4.next();
                                n10 += this.getAmountInInventory(itemStack);
                            }
                            RenderHelper.func_74520_c();
                            object4 = ((ItemStack)GSGuiCelestialSelection.\u3105("\u7002", (ArrayList)arrayList, (int)(this.ticksSinceMenuOpen / 20 % GSGuiCelestialSelection.\uc047("\u9b65", (ArrayList)arrayList)))).func_77946_l();
                            GuiCelestialSelection.field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.field_71446_o, (ItemStack)object4, n22, n11);
                            RenderHelper.func_74518_a();
                            GL11.glEnable((int)3042);
                            if (n >= n22 && n <= n22 + 16 && n2 >= n11 && n2 <= n11 + 16) {
                                GL11.glDepthMask((boolean)true);
                                GL11.glEnable((int)2929);
                                GL11.glPushMatrix();
                                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)300.0f);
                                int n27 = this.smallFontRenderer.getStringWidth(object4.func_82833_r());
                                n9 = n - n27 / 2;
                                n7 = n2 - 12;
                                n6 = 8;
                                if (n9 + n27 > this.field_146294_l) {
                                    n9 -= n9 - this.field_146294_l + n27;
                                }
                                if (n7 + n6 + 6 > this.field_146295_m) {
                                    n7 = this.field_146295_m - n6 - 6;
                                }
                                n5 = ColorUtil.to32BitColor((int)190, (int)0, (int)153, (int)255);
                                this.func_73733_a(n9 - 3, n7 - 4, n9 + n27 + 3, n7 - 3, n5, n5);
                                this.func_73733_a(n9 - 3, n7 + n6 + 3, n9 + n27 + 3, n7 + n6 + 4, n5, n5);
                                this.func_73733_a(n9 - 3, n7 - 3, n9 + n27 + 3, n7 + n6 + 3, n5, n5);
                                this.func_73733_a(n9 - 4, n7 - 3, n9 - 3, n7 + n6 + 3, n5, n5);
                                this.func_73733_a(n9 + n27 + 3, n7 - 3, n9 + n27 + 4, n7 + n6 + 3, n5, n5);
                                int n28 = ColorUtil.to32BitColor((int)170, (int)0, (int)153, (int)255);
                                int n29 = (n28 & 0xFEFEFE) >> 1 | n28 & 0xFF000000;
                                this.func_73733_a(n9 - 3, n7 - 3 + 1, n9 - 3 + 1, n7 + n6 + 3 - 1, n28, n29);
                                this.func_73733_a(n9 + n27 + 2, n7 - 3 + 1, n9 + n27 + 3, n7 + n6 + 3 - 1, n28, n29);
                                this.func_73733_a(n9 - 3, n7 - 3, n9 + n27 + 3, n7 - 3 + 1, n28, n28);
                                this.func_73733_a(n9 - 3, n7 + n6 + 2, n9 + n27 + 3, n7 + n6 + 3, n29, n29);
                                this.smallFontRenderer.drawString(object4.func_82833_r(), n9, n7, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                                GL11.glPopMatrix();
                            }
                            object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ubfdf("\u7622", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\u2dc1("\u0398", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)""), (int)n10), (String)GSGuiCelestialSelection$0.\uc2b0("\ue32f")), entry.getValue()));
                            int n30 = n36 = n10 >= GSGuiCelestialSelection.\u61d3("\u5de8", (Integer)((Integer)entry.getValue())) ? 1 : 0;
                            if (n36 == 0 && n12 != 0) {
                                n12 = 0;
                            }
                            n9 = (n36 | this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d) != 0 ? ColorUtil.to32BitColor((int)255, (int)0, (int)255, (int)0) : ColorUtil.to32BitColor((int)255, (int)255, (int)0, (int)0);
                            this.smallFontRenderer.drawString((String)object2, n22 + 8 - this.smallFontRenderer.getStringWidth((String)object2) / 2, n11 + 15, n9);
                        }
                        ++n21;
                    }
                    if (n12 != 0 || this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d) {
                        if (n >= this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 93 && n < this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH && n2 > GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 62 + this.canCreateOffset && n2 < GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 62 + 13 + this.canCreateOffset) {
                            GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.1f, (float)1.0f);
                        }
                    } else {
                        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    }
                    this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain1);
                    this.canCreateOffset = (int)((long)this.canCreateOffset + GSGuiCelestialSelection.\u186e("\u0144", (double)(GSGuiCelestialSelection.\u7ac5("\ua017", (double)((float)string.getRecipeSize() / 4.0f)) - 1.0)) * 25L);
                    if (!this.mapMode && n >= this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 95 && n <= this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH && n2 >= GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 63 + this.canCreateOffset && n2 <= GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 63 + 12 + this.canCreateOffset) {
                        this.drawTexturedModalRect(this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 93, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 63 + this.canCreateOffset, 93, 12, 0, 174, 93, 12, false, false);
                    }
                    this.drawTexturedModalRect(this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 93, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 63 + this.canCreateOffset, 93, 12, 0, 174, 93, 12, false, false);
                    int n31 = (int)((GSGuiCelestialSelection.\u8be4("\u6a7b", (double)((double)this.ticksSinceMenuOpen / 5.0)) * 0.5 + 0.5) * 255.0);
                    this.drawSplitString(GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e1\u165b\ue256\u7cb8\u863d\ue257\ube67\u498c\uf332\u0f63\u890f\u1e08\uacdb\u2207\u84f8\u0a55\u0283\u8b1a\ud875\ude7e\ud39d\u720b\u4d2c\u0852\u00ca\ud831")), this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 46, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 18, 91, ColorUtil.to32BitColor((int)255, (int)n31, (int)255, (int)n31), true, false);
                    if (!this.mapMode) {
                        this.drawSplitString((String)GSGuiCelestialSelection.\ub18c("\ubb3e", GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e1\u1648\ue25d\u7c9a\u863b\ue257\ube55\u49ab\uf379\u0f5e\u891e\u1e04\uacdd"))), this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 46, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 65 + this.canCreateOffset, 91, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255), false, false);
                    }
                } else {
                    this.drawSplitString(GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e1\u165b\ue256\u7c95\u8620\ue246\ube45\u498a\uf332\u0f51\u890b\u1e0c\uaceb\u2212\u84ca\u0a42\u0287\u8b3d\ud868\ude70\ud387\u724c\u4d2d\u085d\u0089\ud83a\u0e7d\u5b7a\u5a78")), this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 48, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 138, 91, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255), true, false);
                }
            }
            this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.3f - GSGuiCelestialSelection.\ufcc5("\u8275", (float)0.3f, (float)((float)this.ticksSinceSelection / 50.0f))));
            this.drawTexturedModalRect(GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH, 74, 11, 0, 392, 148, 22, false, false);
            object2 = GSGuiCelestialSelection.\ub18c("\ubb3e", GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e1\u165b\ue24c\u7c9a\u8623\ue25d\ube61\u49d6\uf339\u0f51\u8912\u1e0c")));
            this.field_146289_q.func_78276_b((String)object2, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 40 - this.field_146289_q.func_78256_a((String)object2) / 2, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 1, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
            this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
            GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
            if (this.selectedBody instanceof Satellite) {
                if (GSGuiCelestialSelection.\ua56c("\uaecc", this.selectedStationOwner) == false || GSGuiCelestialSelection.\u017a("\u7ddf", this.selectedStationOwner, (String)this.field_146297_k.field_71439_g.func_146103_bH().getName()) == false) {
                    GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                } else {
                    GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                }
                this.drawTexturedModalRect(this.field_146294_l / 2 - 47, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH, 94, 11, 0, 414, 188, 22, false, false);
            } else {
                this.drawTexturedModalRect(this.field_146294_l / 2 - 47, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH, 94, 11, 0, 414, 188, 22, false, false);
            }
            if (this.selectedBody.getTierRequirement() >= 0 && !(this.selectedBody instanceof Satellite)) {
                if (!this.selectedBody.getReachable() || this.currenttier < this.tierneed) {
                    object9 = 0;
                    GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                } else {
                    object9 = 1;
                    GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                }
                this.drawTexturedModalRect(this.field_146294_l / 2 - 30, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 11, 30, 11, 0, 414, 60, 22, false, false);
                this.drawTexturedModalRect(this.field_146294_l / 2, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 11, 30, 11, 128, 414, 60, 22, false, false);
                object2 = GCCoreUtil.translateWithFormat((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f6\u1653\ue25d\u7c89\u8661\ue25c\ube67\u4995\uf332"), (Object[])new Object[]{this.tierneed > 0 ? GSGuiCelestialSelection.\u8f2a("\u69d7", (int)this.tierneed) : GSGuiCelestialSelection$0.\uc2b0("\ue33f")});
                this.field_146289_q.func_78276_b((String)object2, this.field_146294_l / 2 - this.field_146289_q.func_78256_a((String)object2) / 2, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 13, object9 != 0 ? ColorUtil.to32BitColor((int)255, (int)140, (int)140, (int)140) : ColorUtil.to32BitColor((int)255, (int)255, (int)100, (int)100));
            }
            if (this.selectedBody.getTierRequirement() == -2 && this.selectedBody instanceof Star) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                this.drawTexturedModalRect(this.field_146294_l / 2 - 40, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 11, 40, 11, 0, 414, 90, 22, false, false);
                this.drawTexturedModalRect(this.field_146294_l / 2, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 11, 60, 11, 121, 414, 100, 22, false, false);
                object2 = GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e6\u3c77\u1335\u4023\u4b23\u9595\u57a7\uc4de\u41e1\u1651\ue250\u7c94\u8623\ue257\ube28\u4996\uf336\u0f5d\u891a"));
                this.field_146289_q.func_78276_b((String)object2, this.field_146294_l / 2 - this.field_146289_q.func_78256_a((String)object2) / 2, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 13, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)0));
            }
            object2 = this.selectedBody.getLocalizedName();
            if (this.selectedBody instanceof Satellite) {
                object2 = GSGuiCelestialSelection.\ub18c("\ubb3e", GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41f0\u165f\ue256\u7c9a\u8622\ue257\ube28\u4996\uf336\u0f5d\u891a")));
            }
            this.field_146289_q.func_78276_b((String)object2, this.field_146294_l / 2 - this.field_146289_q.func_78256_a((String)object2) / 2, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 2, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
            this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
            GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
            this.drawTexturedModalRect(GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 4, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH, 83, 12, 0, 477, 83, 12, false, false);
            if (!this.mapMode) {
                if (!this.selectedBody.getReachable() || this.currenttier < this.tierneed || this.selectedBody instanceof Satellite && GSGuiCelestialSelection.\u3652("\ucc81", this.selectedStationOwner, (Object)"") != false) {
                    GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                } else if (n > this.field_146294_l - BORDER_WIDTH - BORDER_EDGE_WIDTH - 88 && n < this.field_146294_l - BORDER_WIDTH - BORDER_EDGE_WIDTH && n2 > BORDER_WIDTH + BORDER_EDGE_WIDTH && n2 < BORDER_WIDTH + BORDER_EDGE_WIDTH + 13) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                } else {
                    GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                }
                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                this.drawTexturedModalRect(this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 74, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH, 74, 11, 0, 392, 148, 22, true, false);
                object2 = GSGuiCelestialSelection.\ub18c("\ubb3e", GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41ee\u165b\ue24d\u7c95\u862c\ue25a\ube28\u4996\uf336\u0f5d\u891a")));
                this.field_146289_q.func_78276_b((String)object2, this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 40 - this.field_146289_q.func_78256_a((String)object2) / 2, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 1, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
            }
            if (this.selectionCount == 1 && !(this.selectedBody instanceof Satellite)) {
                boolean bl5;
                boolean bl6;
                bl = true;
                object9 = this.zoomTooltipPos;
                if (this.zoomTooltipPos != 38) {
                    this.zoomTooltipPos = object9 = (Object)GSGuiCelestialSelection.\u0e11("\u1e8a", (int)(this.ticksSinceSelection * 2), (int)38);
                }
                GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                this.drawTexturedModalRect(this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 182, this.field_146295_m - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - object9, 83, 38, 346, 436, 166, 76, true, true);
                boolean bl7 = bl6 = GalaxyRegistry.getSatellitesForCelestialBody((CelestialBody)this.selectedBody).size() > 0;
                boolean bl8 = this.selectedBody instanceof Planet ? GalaxyRegistry.getMoonsForPlanet((Planet)((Planet)this.selectedBody)).size() > 0 : (bl5 = false);
                if (bl6 && bl5) {
                    this.drawSplitString(GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e1\u1656\ue251\u7c98\u8624\ue273\ube61\u4999\uf33e\u0f5e\u8951\u1e59\uac96\u220c\u84ca\u0a4c\u0287")), this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 182 + 41, this.field_146295_m - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 1 + 7 - object9, 79, ColorUtil.to32BitColor((int)255, (int)150, (int)150, (int)150), false, false);
                } else if (!bl6 && bl5) {
                    this.drawSplitString(GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e1\u1656\ue251\u7c98\u8624\ue273\ube61\u4999\uf33e\u0f5e\u8951\u1e58\uac96\u220c\u84ca\u0a4c\u0287")), this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 182 + 41, this.field_146295_m - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 5 + 11 - object9, 79, ColorUtil.to32BitColor((int)255, (int)150, (int)150, (int)150), false, false);
                } else if (bl6) {
                    this.drawSplitString(GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e1\u1656\ue251\u7c98\u8624\ue273\ube61\u4999\uf33e\u0f5e\u8951\u1e5b\uac96\u220c\u84ca\u0a4c\u0287")), this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 182 + 41, this.field_146295_m - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 5 + 11 - object9, 79, ColorUtil.to32BitColor((int)255, (int)150, (int)150, (int)150), false, false);
                } else {
                    this.drawSplitString(GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e1\u1656\ue251\u7c98\u8624\ue273\ube61\u4999\uf33e\u0f5e\u8951\u1e5a\uac96\u220c\u84ca\u0a4c\u0287")), this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 182 + 41, this.field_146295_m - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 10 + 20 - object9, 79, ColorUtil.to32BitColor((int)255, (int)150, (int)150, (int)150), false, false);
                }
                GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
            }
            if (this.selectedBody instanceof Satellite && this.renamingSpaceStation) {
                this.func_146276_q_();
                GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain1);
                this.drawTexturedModalRect(this.field_146294_l / 2 - 90, this.field_146295_m / 2 - 38, 179, 67, 159, 0, 179, 67, false, false);
                this.drawTexturedModalRect(this.field_146294_l / 2 - 90 + 4, this.field_146295_m / 2 - 38 + 2, 171, 10, 159, 92, 171, 10, false, false);
                this.drawTexturedModalRect(this.field_146294_l / 2 - 90 + 8, this.field_146295_m / 2 - 38 + 18, 161, 13, 159, 67, 161, 13, false, false);
                this.drawTexturedModalRect(this.field_146294_l / 2 - 90 + 17, this.field_146295_m / 2 - 38 + 59, 72, 12, 159, 80, 72, 12, true, false);
                this.drawTexturedModalRect(this.field_146294_l / 2, this.field_146295_m / 2 - 38 + 59, 72, 12, 159, 80, 72, 12, false, false);
                object2 = GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e3\u1649\ue24b\u7c92\u8628\ue25c\ube48\u4999\uf33a\u0f55\u8951\u1e07\uacd9\u220f\u84ce"));
                this.field_146289_q.func_78276_b((String)object2, this.field_146294_l / 2 - this.field_146289_q.func_78256_a((String)object2) / 2, this.field_146295_m / 2 - 35, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                object2 = GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e3\u164a\ue248\u7c97\u8636\ue21c\ube68\u4999\uf33a\u0f55"));
                this.field_146289_q.func_78276_b((String)object2, this.field_146294_l / 2 - this.field_146289_q.func_78256_a((String)object2) / 2 - 36, this.field_146295_m / 2 + 23, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                object2 = GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41e1\u165b\ue256\u7c98\u862a\ue25e\ube28\u4996\uf336\u0f5d\u891a"));
                this.field_146289_q.func_78276_b((String)object2, this.field_146294_l / 2 + 36 - this.field_146289_q.func_78256_a((String)object2) / 2, this.field_146295_m / 2 + 23, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                if (this.renamingString == null) {
                    Satellite satellite = (Satellite)this.selectedBody;
                    String string = FMLClientHandler.instance().getClient().field_71439_g.func_146103_bH().getName();
                    this.renamingString = ((GuiCelestialSelection.StationDataGUI)((Map)this.spaceStationMap.get(GSGuiCelestialSelection.\u8f2a("\u69d7", (int)this.getSatelliteParentID(satellite)))).get(string)).getStationName();
                    if (this.renamingString == null) {
                        this.renamingString = ((GuiCelestialSelection.StationDataGUI)((Map)this.spaceStationMap.get(GSGuiCelestialSelection.\u8f2a("\u69d7", (int)this.getSatelliteParentID(satellite)))).get(GSGuiCelestialSelection.\ua5f6("\u0173", string))).getStationName();
                    }
                    if (this.renamingString == null) {
                        this.renamingString = "";
                    }
                }
                object2 = this.renamingString;
                Object object5 = this.renamingString;
                if (this.ticksSinceMenuOpen / 10 % 2 == 0) {
                    object5 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)object5), (String)GSGuiCelestialSelection$0.\uc2b0("\ue35f")));
                }
                this.field_146289_q.func_78276_b((String)object5, this.field_146294_l / 2 - this.field_146289_q.func_78256_a((String)object2) / 2, this.field_146295_m / 2 - 17, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
            }
        }
        object2 = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ubfdf("\u7622", (StringBuilder)new StringBuilder(), (Object)EnumColor.ORANGE), (String)GSGuiCelestialSelection$0.\uc2b0("\ue347\u2ff1\u3a79\u2284\u77f7\u3c60\u1300\u403c\u4b6c\u9594\u57ae\uc49f\u41c5\u165b\ue254\u7c9a\u8637\ue24b\ube26\u49b5\uf336\u0f40")));
        this.field_146289_q.func_78276_b((String)object2, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 5, this.field_146295_m - 20, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
        if (!bl) {
            this.zoomTooltipPos = 0;
        }
    }

    private int drawChildren(List<CelestialBody> list, int n, int n2, boolean bl) {
        n += GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH;
        int n3 = GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 50 + n2;
        int n4 = 0;
        for (int i = 0; i < list.size(); ++i) {
            List list2;
            int n5;
            float f;
            CelestialBody celestialBody = list.get(i);
            int n6 = n + (celestialBody.equals((Object)this.selectedBody) ? 5 : 0);
            int n7 = (int)GSGuiCelestialSelection.\ufcc5("\u8275", (float)95.0f, (float)GSGuiCelestialSelection.\u9f47("\u3a96", (float)0.0f, (float)((float)this.ticksSinceMenuOpen * 25.0f - (float)(95 * i))));
            this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
            float f2 = f = celestialBody.equals((Object)this.selectedBody) ? 0.2f : 0.0f;
            if (celestialBody.getReachable()) {
                if (celestialBody.equals((Object)this.selectedBody)) {
                    GL11.glColor4f((float)0.0f, (float)1.0f, (float)1.0f, (float)((float)n7 / 95.0f));
                } else {
                    GL11.glColor4f((float)0.0f, (float)(0.6f + f), (float)0.0f, (float)((float)n7 / 95.0f));
                }
            } else {
                n5 = 0;
                if (celestialBody instanceof Planet) {
                    for (Moon moon : GalaxyRegistry.getMoonsForPlanet((Planet)((Planet)celestialBody))) {
                        if (!moon.getReachable()) continue;
                        n5 = 1;
                        break;
                    }
                }
                if (celestialBody instanceof Planet && n5 != 0) {
                    GL11.glColor4f((float)(0.6f + f), (float)0.6f, (float)0.0f, (float)((float)n7 / 95.0f));
                } else {
                    GL11.glColor4f((float)((celestialBody.getTierRequirement() <= -1 ? 0.0f : 0.6f) + f), (float)0.0f, (float)0.0f, (float)((float)n7 / 95.0f));
                }
            }
            this.drawTexturedModalRect(3 + n6, n3 + n4 + 1, 86, 10, 0, 489, 86, 10, false, false);
            GL11.glColor4f((float)(3.0f * f), (float)(0.6f + 2.0f * f), (float)1.0f, (float)((float)n7 / 95.0f));
            this.drawTexturedModalRect(2 + n6, n3 + n4, 93, 12, 95, 464, 93, 12, false, false);
            if (n7 > 0) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                n5 = 0xE0E0E0;
                this.field_146289_q.func_78276_b(celestialBody.getLocalizedName(), 7 + n6, n3 + n4 + 2, n5);
            }
            n4 += 14;
            if (!celestialBody.equals((Object)this.selectedBody) || (list2 = this.getChildren(celestialBody)).size() <= 0) continue;
            if (this.animateGrandchildren == 14 * list2.size()) {
                n4 += this.drawChildren(list2, 10, n4, false);
                continue;
            }
            if (this.animateGrandchildren >= 14) {
                LinkedList linkedList = new LinkedList();
                for (int j = 0; j < this.animateGrandchildren / 14; ++j) {
                    linkedList.add(list2.get(j));
                }
                this.drawChildren(linkedList, 10, n4, false);
            }
            n4 += this.animateGrandchildren;
            this.animateGrandchildren += 2;
        }
        return n4;
    }

    protected void func_73869_a(char c, int n) {
        if (this.mapMode) {
            super.func_73869_a(c, n);
        }
        if (n == 1 && !this.check && this.selectedBody != null) {
            this.unselectCelestialBody();
        }
        if (this.renamingSpaceStation) {
            if (n == 14) {
                if (this.renamingString != null && GSGuiCelestialSelection.\ua56c("\uaecc", this.renamingString) > 0) {
                    Object object = GSGuiCelestialSelection.\uf917("\u40b0", this.renamingString, (int)0, (int)(GSGuiCelestialSelection.\ua56c("\uaecc", this.renamingString) - true));
                    this.renamingString = this.isValid((String)object) ? object : "";
                }
            } else if (c == '\u0016') {
                String string = GuiScreen.func_146277_j();
                if (string == null) {
                    string = "";
                }
                if (this.isValid((String)GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)this.renamingString), (String)string)))) {
                    this.renamingString = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)this.renamingString), (String)string));
                    this.renamingString = GSGuiCelestialSelection.\uf917("\u40b0", this.renamingString, (int)0, (int)GSGuiCelestialSelection.\u0e11("\u1e8a", (int)GSGuiCelestialSelection.\ua56c("\uaecc", (String)GSGuiCelestialSelection.\u4e76("\u67f2", this.renamingString)), (int)32));
                }
            } else if (this.isValid((String)GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ucba2("\u6f08", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)this.renamingString), (char)c)))) {
                this.renamingString = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ucba2("\u6f08", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)this.renamingString), (char)c));
                this.renamingString = GSGuiCelestialSelection.\uf917("\u40b0", this.renamingString, (int)0, (int)GSGuiCelestialSelection.\u0e11("\u1e8a", (int)GSGuiCelestialSelection.\ua56c("\uaecc", this.renamingString), (int)32));
            }
            return;
        }
        if (n == 28) {
            this.GSteleportToSelectedBody();
        }
    }

    protected void func_73864_a(int n, int n2, int n3) {
        boolean bl;
        int n4;
        Object object;
        int n5;
        SpaceStationRecipe spaceStationRecipe;
        boolean bl2 = false;
        int n6 = BORDER_WIDTH + BORDER_EDGE_WIDTH;
        int n7 = this.field_146294_l - n6;
        int n8 = n6;
        if (!this.check && this.selectedBody != null && n > BORDER_WIDTH + BORDER_EDGE_WIDTH && n < BORDER_WIDTH + BORDER_EDGE_WIDTH + 88 && n2 > BORDER_WIDTH + BORDER_EDGE_WIDTH && n2 < BORDER_WIDTH + BORDER_EDGE_WIDTH + 13) {
            this.unselectCelestialBody();
            return;
        }
        if (n > n6 && n < n6 + 84 && n2 > this.field_146295_m - n6 - 26 && n2 < this.field_146295_m - n6 - 16) {
            boolean bl3 = this.hideInfo = !this.hideInfo;
        }
        if (n > n6 && n < n6 + 84 && n2 > this.field_146295_m - n6 - 42 && n2 < this.field_146295_m - n6 - 30) {
            boolean bl4 = this.small_mode = !this.small_mode;
        }
        if (n > BORDER_WIDTH + BORDER_EDGE_WIDTH + 6 && n < BORDER_WIDTH + BORDER_EDGE_WIDTH + 93 && n2 > BORDER_WIDTH + BORDER_EDGE_WIDTH + 12 && n2 < BORDER_WIDTH + BORDER_EDGE_WIDTH + 26) {
            if (this.galaxylist.size() > 1) {
                boolean bl5 = this.showGalaxyList = !this.showGalaxyList;
            }
            if (this.showStarList) {
                this.showStarList = false;
            }
        }
        if (n > BORDER_WIDTH + BORDER_EDGE_WIDTH + 6 && n < BORDER_WIDTH + BORDER_EDGE_WIDTH + 93 && n2 > BORDER_WIDTH + BORDER_EDGE_WIDTH + 32 && n2 < BORDER_WIDTH + BORDER_EDGE_WIDTH + 43) {
            boolean bl6 = this.showStarList = !this.showStarList;
            if (this.showGalaxyList) {
                this.showGalaxyList = false;
            }
        }
        if (this.showStarList) {
            spaceStationRecipe = GSGuiCelestialSelection.\uaf79("\u9206", this.starlist).iterator();
            while (spaceStationRecipe.hasNext()) {
                Map.Entry entry = (Map.Entry)spaceStationRecipe.next();
                Object object2 = GSGuiCelestialSelection.\u61d3("\u5de8", (Integer)((Integer)entry.getValue()));
                if (n <= BORDER_WIDTH + BORDER_EDGE_WIDTH + 100 || n >= BORDER_WIDTH + BORDER_EDGE_WIDTH + 193 || n2 <= BORDER_WIDTH + BORDER_EDGE_WIDTH + 14 * object2 + 19 || n2 >= BORDER_WIDTH + BORDER_EDGE_WIDTH + 14 * object2 + 34) continue;
                this.selectedParent = (SolarSystem)entry.getKey();
                this.showStarList = false;
                this.selectedBody = ((SolarSystem)entry.getKey()).getMainStar();
                this.selectionCount = 1;
                this.zoom = -0.2f;
                this.position = new Vector2f(this.getCelestialBodyPosition((CelestialBody)this.selectedBody).x, this.getCelestialBodyPosition((CelestialBody)this.selectedBody).y);
                bl2 = true;
                if (this.selectedBody instanceof IChildBody) {
                    this.galaxy = ((IChildBody)this.selectedBody).getParentPlanet().getParentSolarSystem().getUnlocalizedParentGalaxyName();
                }
                if (this.selectedBody instanceof Planet) {
                    this.galaxy = ((Planet)this.selectedBody).getParentSolarSystem().getUnlocalizedParentGalaxyName();
                }
                if (!(this.selectedBody instanceof Star)) continue;
                this.galaxy = ((Star)this.selectedBody).getParentSolarSystem().getUnlocalizedParentGalaxyName();
            }
        }
        if (this.showGalaxyList) {
            boolean bl7 = true;
            for (int i = 0; i < this.galaxylist.size(); ++i) {
                if (n <= BORDER_WIDTH + BORDER_EDGE_WIDTH + 100 || n >= BORDER_WIDTH + BORDER_EDGE_WIDTH + 193 || n2 <= BORDER_WIDTH + BORDER_EDGE_WIDTH + 13 * i + 19 || n2 >= BORDER_WIDTH + BORDER_EDGE_WIDTH + 13 * i + 34) continue;
                this.galaxy = this.galaxylist.get(i);
                this.zoom = -1.0f;
                this.showGalaxyList = false;
                GSGuiCelestialSelection.\ufdfc("\u3a11", this.starlist);
            }
        }
        if (!this.mapMode && n >= this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 95 && n < this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH && n2 > GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 62 + this.canCreateOffset && n2 < GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 62 + 14 + this.canCreateOffset && this.selectedBody != null && (spaceStationRecipe = WorldUtil.getSpaceStationRecipe((int)this.selectedBody.getDimensionID())) != null && this.canCreateSpaceStation(this.selectedBody)) {
            if (spaceStationRecipe.matches((EntityPlayer)this.field_146297_k.field_71439_g, false) || this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d) {
                GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.S_BIND_SPACE_STATION_ID, new Object[]{GSGuiCelestialSelection.\u8f2a("\u69d7", (int)this.selectedBody.getDimensionID())}));
                if (this.selectionCount < 2) {
                    this.selectionCount = 2;
                    this.preSelectZoom = this.zoom;
                    this.preSelectPosition = this.position;
                    this.ticksSinceSelection = 0;
                    this.doneZooming = false;
                }
            }
            bl2 = true;
        }
        if (this.mapMode && n > this.field_146294_l - BORDER_WIDTH - BORDER_EDGE_WIDTH - 88 && n < this.field_146294_l - BORDER_WIDTH - BORDER_EDGE_WIDTH && n2 > BORDER_WIDTH + BORDER_EDGE_WIDTH && n2 < BORDER_WIDTH + BORDER_EDGE_WIDTH + 13) {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
            bl2 = true;
        }
        if (this.selectedBody != null && !this.mapMode && n > this.field_146294_l - BORDER_WIDTH - BORDER_EDGE_WIDTH - 88 && n < this.field_146294_l - BORDER_WIDTH - BORDER_EDGE_WIDTH && n2 > BORDER_WIDTH + BORDER_EDGE_WIDTH && n2 < BORDER_WIDTH + BORDER_EDGE_WIDTH + 13) {
            if (!(this.selectedBody instanceof Satellite) || GSGuiCelestialSelection.\u3652("\ucc81", this.selectedStationOwner, (Object)"") == false) {
                if (!this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d && this.currenttier >= this.tierneed) {
                    this.check = true;
                } else {
                    this.GSteleportToSelectedBody();
                }
            }
            bl2 = true;
        }
        int n9 = Mouse.getX();
        int n10 = Mouse.getY() * -1 + Minecraft.func_71410_x().field_71440_d - 1;
        if (this.selectedBody instanceof Satellite) {
            if (this.renamingSpaceStation) {
                if (n >= this.field_146294_l / 2 - 90 && n <= this.field_146294_l / 2 + 90 && n2 >= this.field_146295_m / 2 - 38 && n2 <= this.field_146295_m / 2 + 38) {
                    if (n >= this.field_146294_l / 2 - 90 + 17 && n <= this.field_146294_l / 2 - 90 + 17 + 72 && n2 >= this.field_146295_m / 2 - 38 + 59 && n2 <= this.field_146295_m / 2 - 38 + 59 + 12) {
                        String string = this.field_146297_k.field_71439_g.func_146103_bH().getName();
                        Satellite satellite = (Satellite)this.selectedBody;
                        Integer n11 = ((GuiCelestialSelection.StationDataGUI)((Map)this.spaceStationMap.get(GSGuiCelestialSelection.\u8f2a("\u69d7", (int)this.getSatelliteParentID(satellite)))).get(string)).getStationDimensionID();
                        if (n11 == null) {
                            n11 = ((GuiCelestialSelection.StationDataGUI)((Map)this.spaceStationMap.get(GSGuiCelestialSelection.\u8f2a("\u69d7", (int)this.getSatelliteParentID(satellite)))).get(GSGuiCelestialSelection.\ua5f6("\u0173", string))).getStationDimensionID();
                        }
                        if (n11 != null) {
                            ((GuiCelestialSelection.StationDataGUI)((Map)this.spaceStationMap.get(GSGuiCelestialSelection.\u8f2a("\u69d7", (int)this.getSatelliteParentID(satellite)))).get(string)).setStationName(this.renamingString);
                            GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.S_RENAME_SPACE_STATION, new Object[]{this.renamingString, n11}));
                        }
                        this.renamingSpaceStation = false;
                    }
                    if (n >= this.field_146294_l / 2 && n <= this.field_146294_l / 2 + 72 && n2 >= this.field_146295_m / 2 - 38 + 59 && n2 <= this.field_146295_m / 2 - 38 + 59 + 12) {
                        this.renamingSpaceStation = false;
                    }
                    bl2 = true;
                }
            } else {
                this.drawTexturedModalRect(this.field_146294_l / 2 - 47, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH, 94, 11, 0, 414, 188, 22, false, false);
                if (n >= this.field_146294_l / 2 - 47 && n <= this.field_146294_l / 2 - 47 + 94 && n2 >= GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH && n2 <= GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 11 && GSGuiCelestialSelection.\ua56c("\uaecc", this.selectedStationOwner) != false && GSGuiCelestialSelection.\u017a("\u7ddf", this.selectedStationOwner, (String)this.field_146297_k.field_71439_g.func_146103_bH().getName()) != false) {
                    this.renamingSpaceStation = true;
                    this.renamingString = null;
                    bl2 = true;
                }
                Satellite satellite = (Satellite)this.selectedBody;
                int n12 = ((Map)this.spaceStationMap.get(GSGuiCelestialSelection.\u8f2a("\u69d7", (int)this.getSatelliteParentID(satellite)))).size();
                Object object3 = GSGuiCelestialSelection.\u0e11("\u1e8a", (int)(this.field_146295_m / 2 / 14), (int)n12);
                n5 = this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 85;
                int n13 = GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 45;
                if (n >= n5 && n <= n5 + 61 && n2 >= n13 && n2 <= n13 + 4) {
                    if (this.spaceStationListOffset > 0) {
                        --this.spaceStationListOffset;
                    }
                    bl2 = true;
                }
                n5 = this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 85;
                n13 = GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 49 + object3 * 14;
                if (n >= n5 && n <= n5 + 61 && n2 >= n13 && n2 <= n13 + 4) {
                    if (object3 + this.spaceStationListOffset < n12) {
                        ++this.spaceStationListOffset;
                    }
                    bl2 = true;
                }
                object = ((Map)this.spaceStationMap.get(GSGuiCelestialSelection.\u8f2a("\u69d7", (int)this.getSatelliteParentID(satellite)))).entrySet().iterator();
                int n14 = 0;
                n4 = 0;
                while (object.hasNext() && n14 < object3) {
                    Map.Entry entry = (Map.Entry)object.next();
                    if (n4 >= this.spaceStationListOffset) {
                        int n15 = 0;
                        if (GSGuiCelestialSelection.\u017a("\u7ddf", (String)entry.getKey(), (String)this.selectedStationOwner) != false) {
                            n15 -= 5;
                        }
                        n5 = this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 95 + n15;
                        n13 = GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 50 + n14 * 14;
                        if (n >= n5 && n <= n5 + 93 && n2 >= n13 && n2 <= n13 + 12) {
                            this.selectedStationOwner = (String)entry.getKey();
                            bl2 = true;
                        }
                        ++n14;
                    }
                    ++n4;
                }
            }
        }
        int n16 = GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 2;
        int n17 = GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 10;
        boolean bl8 = bl = this.selectionCount == 2 && this.selectedParent instanceof Planet;
        if (n >= n16 && n <= n16 + 93 && n2 >= n17 && n2 <= n17 + 12 && this.selectedParent instanceof CelestialBody) {
            if (this.selectedBody == null) {
                this.preSelectZoom = this.zoom;
                this.preSelectPosition = this.position;
            }
            n5 = this.selectionCount;
            if (!this.check && this.selectionCount > 0) {
                this.unselectCelestialBody();
            }
            if (n5 == 2) {
                this.selectionCount = 1;
            }
            this.selectedBody = (CelestialBody)this.selectedParent;
            this.ticksSinceSelection = 0;
            ++this.selectionCount;
            if (this.selectionCount == 2 && !bl) {
                this.ticksSinceMenuOpen = 0;
            }
            bl2 = true;
        }
        if (n >= n16 && n <= n16 + 93 && n2 >= (n17 += 22) && n2 <= n17 + 12) {
            if (bl) {
                if (this.selectedBody == null) {
                    this.preSelectZoom = this.zoom;
                    this.preSelectPosition = this.position;
                }
                n5 = this.selectionCount;
                if (!this.check && this.selectionCount > 0) {
                    this.unselectCelestialBody();
                }
                if (n5 == 2) {
                    this.selectionCount = 1;
                }
                this.selectedBody = (CelestialBody)this.selectedParent;
                this.ticksSinceSelection = 0;
                ++this.selectionCount;
            }
            bl2 = true;
        }
        if (!bl2) {
            List list = this.getChildren(this.selectionCount == 2 ? this.selectedBody : this.selectedParent);
            n17 = GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 50;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                bl2 = this.testClicked((CelestialBody)object, (object = (CelestialBody)iterator.next()).equals((Object)this.selectedBody) ? 5 : 0, n17, n, n2, false);
                n17 += 14;
                if (!bl2 && this.selectionCount != 2 && object.equals((Object)this.selectedBody)) {
                    List list2 = this.getChildren(object);
                    n4 = 0;
                    for (CelestialBody celestialBody : list2) {
                        if (n4 + 14 > this.animateGrandchildren) break;
                        bl2 = this.testClicked(celestialBody, 10, n17, n, n2, true);
                        n17 += 14;
                        n4 += 14;
                        if (!bl2) continue;
                        break;
                    }
                    n17 += this.animateGrandchildren - n4;
                }
                if (!bl2) continue;
                break;
            }
        }
        if (!bl2) {
            for (Map.Entry entry : this.planetPosMap.entrySet()) {
                float f;
                object = (CelestialBody)entry.getKey();
                if (this.selectedBody == null && object instanceof IChildBody || !((float)n9 >= ((Vector3f)entry.getValue()).x - (f = ((Vector3f)entry.getValue()).z)) || !((float)n9 <= ((Vector3f)entry.getValue()).x + f) || !((float)n10 >= ((Vector3f)entry.getValue()).y - f) || !((float)n10 <= ((Vector3f)entry.getValue()).y + f) || this.selectedBody == object && this.selectionCount >= 2) continue;
                if (this.selectionCount > 0 && this.selectedBody != object) {
                    if (!(this.check || this.selectedBody instanceof IChildBody && ((IChildBody)this.selectedBody).getParentPlanet() == object)) {
                        this.unselectCelestialBody();
                    } else if (this.selectionCount == 2) {
                        --this.selectionCount;
                    }
                }
                this.doneZooming = false;
                this.planetZoom = 0.0f;
                if (object != this.selectedBody) {
                    this.lastSelectedBody = this.selectedBody;
                    this.animateGrandchildren = 0;
                }
                if (this.selectionCount == 1 && !(object instanceof IChildBody)) {
                    this.preSelectZoom = this.zoom;
                    this.preSelectPosition = this.position;
                }
                if (!this.check) {
                    this.selectedBody = object;
                }
                this.ticksSinceSelection = 0;
                ++this.selectionCount;
                if (this.selectionCount == 2) {
                    this.ticksSinceMenuOpen = 0;
                }
                if (this.selectedBody instanceof IChildBody) {
                    this.galaxy = ((IChildBody)this.selectedBody).getParentPlanet().getParentSolarSystem().getUnlocalizedParentGalaxyName();
                }
                if (this.selectedBody instanceof Planet) {
                    this.galaxy = ((Planet)this.selectedBody).getParentSolarSystem().getUnlocalizedParentGalaxyName();
                }
                if (this.selectedBody instanceof Star) {
                    this.galaxy = ((Star)this.selectedBody).getParentSolarSystem().getUnlocalizedParentGalaxyName();
                }
                if (this.selectedBody instanceof Satellite && ((Map)this.spaceStationMap.get(GSGuiCelestialSelection.\u8f2a("\u69d7", (int)this.getSatelliteParentID((Satellite)this.selectedBody)))).size() >= 1) {
                    Iterator iterator = ((Map)this.spaceStationMap.get(GSGuiCelestialSelection.\u8f2a("\u69d7", (int)this.getSatelliteParentID((Satellite)this.selectedBody)))).entrySet().iterator();
                    this.selectedStationOwner = (String)iterator.next().getKey();
                }
                bl2 = true;
                break;
            }
        }
        if (!bl2) {
            if (!this.check && this.selectedBody != null) {
                if (n > n7 - 35 && n < n7 - 10 && n2 > n8 + 210 && n2 < n8 + 220) {
                    BodiesHelper.BodiesData bodiesData = (BodiesHelper.BodiesData)GSGuiCelestialSelection.\u57ef("\ua662", BodiesHelper.data, (Object)this.selectedBody);
                    int n18 = bodiesData != null && bodiesData.getItemStacks().size() > 0 ? 3 : 2;
                    if (this.small_page < n18) {
                        ++this.small_page;
                    }
                } else if (n > n7 - 120 && n < n7 - 90 && n2 > n8 + 210 && n2 < n8 + 220) {
                    if (this.small_page > 0) {
                        --this.small_page;
                    }
                } else {
                    this.unselectCelestialBody();
                }
                this.showStarList = false;
            }
            this.mouseDragging = true;
        }
        Object object4 = this.selectedParent;
        if (this.selectedBody instanceof IChildBody) {
            object4 = ((IChildBody)this.selectedBody).getParentPlanet();
        } else if (this.selectedBody instanceof Planet) {
            object4 = ((Planet)this.selectedBody).getParentSolarSystem();
        } else if (this.selectedBody instanceof Star) {
            object4 = ((Star)this.selectedBody).getParentSolarSystem();
        } else if (this.selectedBody == null) {
            if (this.lastSelectedBody instanceof Planet) {
                object4 = ((Planet)this.lastSelectedBody).getParentSolarSystem();
            }
            if (this.lastSelectedBody instanceof IChildBody) {
                object4 = ((IChildBody)this.lastSelectedBody).getParentPlanet().getParentSolarSystem();
            }
        }
        if (this.selectedParent != object4) {
            this.selectedParent = object4;
            this.ticksSinceMenuOpen = 0;
        }
    }

    private boolean testClicked(CelestialBody celestialBody, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 2 + n;
        if (n3 >= n5 && n3 <= n5 + 93 && n4 >= n2 && n4 <= n2 + 12 && (this.selectedBody != celestialBody || this.selectionCount != 2)) {
            if (this.selectedBody == null) {
                this.preSelectZoom = this.zoom;
                this.preSelectPosition = this.position;
            }
            int n6 = this.selectionCount;
            if (this.selectionCount == 1 && this.selectedBody != celestialBody) {
                this.unselectCelestialBody();
            }
            if (n6 == 2) {
                this.selectionCount = 1;
            }
            this.doneZooming = false;
            this.planetZoom = 0.0f;
            if (celestialBody != this.selectedBody) {
                this.lastSelectedBody = this.selectedBody;
            }
            this.selectedBody = celestialBody;
            this.ticksSinceSelection = 0;
            this.small_page = 0;
            ++this.selectionCount;
            if (bl) {
                this.selectionCount = 2;
            }
            if (this.selectionCount == 2) {
                this.ticksSinceMenuOpen = 0;
            }
            this.animateGrandchildren = 0;
            return true;
        }
        return false;
    }

    protected void func_146273_a(int n, int n2, int n3, long l) {
        super.func_146273_a(n, n2, n3, l);
        if (this.mouseDragging && this.lastMovePosX != -1 && n3 == 0) {
            int n4 = n - this.lastMovePosX;
            int n5 = n2 - this.lastMovePosY;
            this.translation.x = this.translation.x + (float)(n4 - n5) * -0.4f * (ConfigManagerCore.invertMapMouseScroll ? -1.0f : 1.0f) * ConfigManagerCore.mapMouseScrollSensitivity;
            this.translation.y = this.translation.y + (float)(n5 + n4) * -0.4f * (ConfigManagerCore.invertMapMouseScroll ? -1.0f : 1.0f) * ConfigManagerCore.mapMouseScrollSensitivity;
        }
        this.lastMovePosX = n;
        this.lastMovePosY = n2;
        this.showStarList = false;
        this.showGalaxyList = false;
    }

    protected void drawTransitBar(int n) {
        Object object;
        int n2 = GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH;
        this.field_146297_k.field_71446_o.func_110577_a(guiMain2);
        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(this.field_146294_l / 2 - 113, n2 + 15, 225, 67, 0, 0, 225, 67, false, false);
        this.drawTexturedModalRect(this.field_146294_l / 2 - 50, n2 + 57, 0 + n, 78, 270, 0, 138, 77, false, false);
        if (!(this.field_146297_k.field_71439_g.field_70170_p.field_73011_w instanceof WorldProviderSurface)) {
            CelestialBody celestialBody = ((WorldProviderSpace)this.field_146297_k.field_71439_g.field_70170_p.field_73011_w).getCelestialBody();
            this.drawBodyOnGUI(celestialBody, this.field_146294_l / 2 - 76, n2 + 54, 16, 16);
            object = GCCoreUtil.translate((String)celestialBody.getLocalizedName());
        } else {
            this.drawBodyOnGUI((CelestialBody)GalacticraftCore.planetOverworld, this.field_146294_l / 2 - 76, n2 + 54, 16, 16);
            object = GCCoreUtil.translate((String)GalacticraftCore.planetOverworld.getLocalizedName());
        }
        this.field_146289_q.func_78276_b((String)object, this.field_146294_l / 2 - 105, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 35, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
        this.drawBodyOnGUI(this.selectedBody, this.field_146294_l / 2 + 59, n2 + 54, 16, 16);
        object = GCCoreUtil.translate((String)this.selectedBody.getLocalizedName());
        this.field_146289_q.func_78276_b((String)object, this.field_146294_l / 2 + 50, GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 35, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
        object = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\u2dc1("\u0398", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GSGuiCelestialSelection$2.\u310b("\uae5a\ub913\u1991\ue275\u305a\u9a42\u364e\u8f8d")), (int)this.coef));
        this.field_146289_q.func_78276_b((String)object, this.field_146294_l / 2 - (this.field_146289_q.func_78256_a((String)object) - 25), GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 48, ColorUtil.to32BitColor((int)255, (int)0, (int)255, (int)255));
        float f = this.traveltime - this.timer;
        object = GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\u2dc1("\u0398", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\u2dc1("\u0398", (StringBuilder)new StringBuilder(), (int)((int)(f / 100.0f))), (String)GSGuiCelestialSelection$2.\u310b("\uae70\ub95c")), (int)((int)(f % 100.0f))), (String)GSGuiCelestialSelection$2.\u310b("\uae75")));
        this.field_146289_q.func_78276_b((String)object, this.field_146294_l / 2 - (this.field_146289_q.func_78256_a((String)object) - 20), GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 59, ColorUtil.to32BitColor((int)255, (int)0, (int)255, (int)255));
        if (this.timer >= this.traveltime) {
            this.GSteleportToSelectedBody();
        }
    }

    protected int getScaledTravelTime(int n) {
        double d = this.timer;
        double d2 = this.traveltime;
        double d3 = d / d2;
        double d4 = d3 * (double)n;
        return (int)d4;
    }

    protected void drawBodyOnGUI(CelestialBody celestialBody, int n, int n2, int n3, int n4) {
        if (celestialBody == null) {
            return;
        }
        this.field_146297_k.field_71446_o.func_110577_a(celestialBody.getBodyIcon());
        this.drawFullSizedTexturedRect(n, n2, n3, n4);
    }

    public void drawFullSizedTexturedRect(int n, int n2, int n3, int n4) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)n, (double)(n2 + n4), (double)this.field_73735_i, 0.0, 0.0);
        tessellator.func_78374_a((double)(n + n3), (double)(n2 + n4), (double)this.field_73735_i, 1.0, 0.0);
        tessellator.func_78374_a((double)(n + n3), (double)n2, (double)this.field_73735_i, 1.0, 1.0);
        tessellator.func_78374_a((double)n, (double)n2, (double)this.field_73735_i, 0.0, 1.0);
        tessellator.func_78381_a();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean GSteleportToSelectedBody() {
        if (this.selectedBody != null && this.selectedBody.getReachable() && this.currenttier >= this.tierneed) {
            try {
                String string;
                if (this.selectedBody instanceof Satellite) {
                    if (this.spaceStationMap == null) {
                        GCLog.severe((String)GSGuiCelestialSelection$2.\u310b("\uae48\ub910\u199b\ue267\u305d\u9a1d\u364e\u8f87\u73c5\u59c7\uf078\u7899\u2d4d\uf914\ub1a1\ua66d\uc699\u4dcb\uc665\u1d38\uf787\u0ee5\u6822\ud825\uea88\u6a3c\ue754\ud17a\u1815\ufcf4\ue8ee\u3c2a\uc484\uc857\ub66f\u8c5d\u3e4f\u4c0b\u677e\uefd4\u1503\u8a0d\uc67a\u7c71\ua1f6\u50a4\ufa53\ub14f\u09f6"));
                        return false;
                    }
                    Satellite satellite = (Satellite)this.selectedBody;
                    Integer n = ((GuiCelestialSelection.StationDataGUI)((Map)this.spaceStationMap.get(GSGuiCelestialSelection.\u8f2a("\u69d7", (int)this.getSatelliteParentID(satellite)))).get(this.selectedStationOwner)).getStationDimensionID();
                    if (n == null) {
                        GCLog.severe((String)GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GSGuiCelestialSelection$2.\u310b("\uae48\ub90e\u1991\ue264\u3042\u9a1d\u3603\u8fd5\u73cd\u59d6\uf063\u7888\u2d51\uf95d\ub1ae\ua679\uc699\u4dda\uc629\u1d1b\uf7ab\u0ec7\u686a\ud825\uea95\u6a2d\ue758\ud17c\u1850\ufcce\ue8f4\u3c6b\uc483\uc84e\ub661\u8c50\u3e63\u4c6f\u677e\uef80\u1515\u8a18\uc660\u7c3e\ua1f6\u50f1\ufa5c\ub14b\u09bd\u43c8\u259a\u43b6\u6067")), (String)this.selectedStationOwner)));
                        return false;
                    }
                    Object object = GSGuiCelestialSelection.\u61d3("\u5de8", (Integer)n);
                    WorldProvider worldProvider = WorldUtil.getProviderForDimensionClient((int)object);
                    if (worldProvider == null) {
                        GCLog.severe((String)GSGuiCelestialSelection.\u5483("\u6a34", (StringBuilder)GSGuiCelestialSelection.\u2dc1("\u0398", (StringBuilder)GSGuiCelestialSelection.\ub484("\u5534", (StringBuilder)new StringBuilder(), (String)GSGuiCelestialSelection$2.\u310b("\uae5e\ub91d\u1997\ue26a\u304b\u9a1c\u364e\u8f81\u73cf\u5997\uf071\u7882\u2d57\uf950\ub1e0\ua67f\uc699\u4dd9\uc635\u1d1b\uf7b1\u0ec7\u686b\ud871\uea9a\u6a38\ue75c\ud176\u181e\ufc87\ue8ed\u3c22\uc484\uc856\ub620\u8c57\u3e6f\u4c22\u6768\uef9a\u1507\u8a05\uc666\u7c3f\ua1b8")), (int)object)));
                        return false;
                    }
                    string = WorldUtil.getDimensionName((WorldProvider)worldProvider);
                } else {
                    string = WorldUtil.getDimensionName((WorldProvider)WorldUtil.getProviderForDimensionClient((int)this.selectedBody.getDimensionID()));
                }
                if (GSGuiCelestialSelection.\u55b0("\u6d12", string, (CharSequence)GSGuiCelestialSelection$2.\u310b("\uae3c")) != false) {
                    this.field_146297_k.field_71474_y.field_74320_O = 0;
                }
                GSGuiCelestialSelection.\u963f("\ub98e", (GalaxySpaceChannelHandler)GalaxySpace.packetPipeline, (IPacket)new GSPacketSimple(GSPacketSimple$GSEnumSimplePacket.S_TELEPORT_ENTITY, string, GSGuiCelestialSelection.\u8f2a("\u69d7", (int)this.fuelSet)));
                this.field_146297_k.func_147108_a(null);
                return true;
            }
            catch (Exception exception) {
                GSGuiCelestialSelection.\ucea2("\ua767", (Exception)exception);
            }
        }
        return false;
    }

    private String localeBoolean(boolean bl) {
        if (bl) {
            return GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41fb\u165f\ue24b"));
        }
        return GCCoreUtil.translate((String)GSGuiCelestialSelection$0.\uc2b0("\ue367\u2fe5\u3a7c\u22cb\u77e2\u3c7c\u1320\u403f\u4b6c\u9590\u57ae\uc491\u41ec\u1655"));
    }

    protected boolean canCreateSpaceStation(CelestialBody celestialBody) {
        if (this.mapMode || ConfigManagerCore.disableSpaceStationCreation) {
            return false;
        }
        if (!celestialBody.getReachable() || this.currenttier < this.tierneed) {
            return false;
        }
        boolean bl = false;
        for (SpaceStationType spaceStationType : GalacticraftRegistry.getSpaceStationData()) {
            if (spaceStationType.getWorldToOrbitID() != celestialBody.getDimensionID()) continue;
            bl = true;
        }
        if (!bl) {
            return false;
        }
        if (GSGuiCelestialSelection.\u822d("\u1252", (HashMap)ClientProxyCore.clientSpaceStationID, (Object)GSGuiCelestialSelection.\u8f2a("\u69d7", (int)celestialBody.getDimensionID())) == false) {
            return true;
        }
        Object object = GSGuiCelestialSelection.\u61d3("\u5de8", (Integer)((Integer)GSGuiCelestialSelection.\u57ef("\ua662", (HashMap)ClientProxyCore.clientSpaceStationID, (Object)GSGuiCelestialSelection.\u8f2a("\u69d7", (int)celestialBody.getDimensionID()))));
        return object == false || object == -1;
    }

    protected void unselectCelestialBody() {
        this.selectionCount = 0;
        this.ticksSinceUnselection = 0;
        this.lastSelectedBody = this.selectedBody;
        this.selectedBody = null;
        this.doneZooming = false;
        this.selectedStationOwner = "";
        this.animateGrandchildren = 0;
    }

    protected String getParentName() {
        if (this.selectedBody instanceof Planet) {
            SolarSystem solarSystem = ((Planet)this.selectedBody).getParentSolarSystem();
            if (solarSystem != null) {
                return solarSystem.getLocalizedName();
            }
        } else if (this.selectedBody instanceof IChildBody) {
            Planet planet = ((IChildBody)this.selectedBody).getParentPlanet();
            if (planet != null) {
                return planet.getLocalizedName();
            }
        } else {
            SolarSystem solarSystem;
            if (this.selectedParent instanceof SolarSystem) {
                return ((SolarSystem)this.selectedParent).getLocalizedName();
            }
            if (this.selectedBody instanceof Star && (solarSystem = ((Star)this.selectedBody).getParentSolarSystem()) != null) {
                return solarSystem.getLocalizedName();
            }
        }
        return GSGuiCelestialSelection$0.\uc2b0("\ue34e\u2fe5\u3a79\u2289");
    }

    private static Object \uc047(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[10] == null) {
            GSGuiCelestialSelection.\ub4ae[10] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$0.\uc2b0("\ue36a\u2ff1\u3a63\u2284\u77a1\u3c6c\u1327\u4025\u4b61\u95d9\u578a\uc4cd\u41f0\u165b\ue241\u7cb7\u8626\ue241\ube72")), GSGuiCelestialSelection$0.\uc2b0("\ue373\u2ff9\u3a6f\u2280"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[10];
    }

    private static Object \u3478(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[43] == null) {
            GSGuiCelestialSelection.\ub4ae[43] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$1.\uc83e("\ua565\ue922\u7414\u2ae1\uc7eb\uf6f2\u086a\uecf8\ufba4\u8ccc\u5a78\ub6a0\ua7b3\u8d20\uc7f6\u3284")), GSGuiCelestialSelection$1.\uc83e("\ua57d\ue926\u7412\u2aec\uc7a4\uf6fd\u086e"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[43];
    }

    private static Object \u9008(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[47] == null) {
            GSGuiCelestialSelection.\ub4ae[47] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(GSGuiCelestialSelection$1.\uc83e("\ua565\ue922\u7414\u2ae1\uc7eb\uf6f2\u086a\uecf8\ufba4\u8ccc\u5a66\ub6b5\ua7b5\u8d21")), GSGuiCelestialSelection$1.\uc83e("\ua56e\ue921\u7411"), methodType).asType(methodType));
        }
        return \ub4ae[47];
    }

    private static Object \u8be4(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[15] == null) {
            GSGuiCelestialSelection.\ub4ae[15] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(GSGuiCelestialSelection$3.\u87c3("\u48c5\u2213\ue6d4\uc893\uffe4\u125e\ue7bf\u5025\ufaa2\uabce\u0533\u5cbd\u27d9\u6dc0")), GSGuiCelestialSelection$3.\u87c3("\u48dc\u221b\ue6cc"), methodType).asType(methodType));
        }
        return \ub4ae[15];
    }

    private static Object \u8f2a(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[39] == null) {
            GSGuiCelestialSelection.\ub4ae[39] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(GSGuiCelestialSelection$2.\u310b("\uae72\ub91d\u1988\ue267\u3000\u9a14\u360f\u8f9b\u73c7\u5999\uf05e\u7885\u2d4d\uf951\ub1a7\ua67b\uc6cb")), GSGuiCelestialSelection$2.\u310b("\uae6e\ub91d\u1992\ue273\u304b\u9a37\u3608"), methodType).asType(methodType));
        }
        return \ub4ae[39];
    }

    private static Object \u3652(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[32] == null) {
            GSGuiCelestialSelection.\ub4ae[32] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$3.\u87c3("\u48c5\u2213\ue6d4\uc893\uffe4\u125e\ue7bf\u5025\ufaa2\uabce\u052d\u5ca8\u27df\u6dc1\ue601\uf888")), GSGuiCelestialSelection$3.\u87c3("\u48ca\u2203\ue6d7\uc893\uffa6\u1241"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[32];
    }

    private static Object \u3ce2(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[2] == null) {
            GSGuiCelestialSelection.\ub4ae[2] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(GSGuiCelestialSelection$3.\u87c3("\u48c5\u2213\ue6d4\uc893\uffe4\u125e\ue7bf\u5025\ufaa2\uabce\u0533\u5cbd\u27d9\u6dc0")), GSGuiCelestialSelection$3.\u87c3("\u48dd\u221d\ue6d7\uc89c\uffae"), methodType).asType(methodType));
        }
        return \ub4ae[2];
    }

    private static Object \u2da6(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[38] == null) {
            GSGuiCelestialSelection.\ub4ae[38] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$3.\u87c3("\u48c5\u2213\ue6d4\uc893\uffe4\u1247\ue7aa\u5022\ufaa9\uabce\u053f\u5cae\u27df\u6dc9\ue616\uf8a3\u9415\u9ba8\u6ac4")), GSGuiCelestialSelection$3.\u87c3("\u48c6\u2201\ue6e7\uc89f\uffba\u1246\ue7a7"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[38];
    }

    private static Object \ufdfc(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[22] == null) {
            GSGuiCelestialSelection.\ub4ae[22] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$1.\uc83e("\ua565\ue922\u7414\u2ae1\uc7eb\uf6eb\u087f\uecff\ufbaf\u8ccc\u5a63\ub6b5\ua7b2\u8d21\uc7d5\u3282\u0368")), GSGuiCelestialSelection$1.\uc83e("\ua56c\ue92f\u7407\u2ae1\uc7b7"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[22];
    }

    private static Object \u3105(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[17] == null) {
            GSGuiCelestialSelection.\ub4ae[17] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$1.\uc83e("\ua565\ue922\u7414\u2ae1\uc7eb\uf6eb\u087f\uecff\ufbaf\u8ccc\u5a6a\ub6a6\ua7b3\u8d28\uc7e1\u32af\u0371\u5cd1\ueb65")), GSGuiCelestialSelection$1.\uc83e("\ua568\ue926\u7416"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[17];
    }

    private static Object \ucba2(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[30] == null) {
            GSGuiCelestialSelection.\ub4ae[30] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$2.\u310b("\uae72\ub91d\u1988\ue267\u3000\u9a14\u360f\u8f9b\u73c7\u5999\uf044\u789f\u2d4b\uf95d\ub1ae\ua679\uc6fb\u4ddf\uc62c\u1d16\uf7b6\u0ec7\u686a")), GSGuiCelestialSelection$2.\u310b("\uae79\ub90c\u198e\ue263\u3040\u9a1c"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[30];
    }

    private static Object \u1f84(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[19] == null) {
            GSGuiCelestialSelection.\ub4ae[19] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$3.\u87c3("\u48c5\u2213\ue6d4\uc893\uffe4\u1247\ue7aa\u5022\ufaa9\uabce\u053f\u5cae\u27df\u6dc9\ue616\uf8a3\u9415\u9ba8\u6ac4")), GSGuiCelestialSelection$3.\u87c3("\u48db\u221d\ue6f1\uc886\uffb8\u125b\ue7b0\u502c"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[19];
    }

    private static Object \u0e11(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[8] == null) {
            GSGuiCelestialSelection.\ub4ae[8] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(GSGuiCelestialSelection$2.\u310b("\uae72\ub91d\u1988\ue267\u3000\u9a14\u360f\u8f9b\u73c7\u5999\uf05a\u788a\u2d4d\uf95c")), GSGuiCelestialSelection$2.\u310b("\uae75\ub915\u1990"), methodType).asType(methodType));
        }
        return \ub4ae[8];
    }

    private static Object \ubab1(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[6] == null) {
            GSGuiCelestialSelection.\ub4ae[6] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$3.\u87c3("\u48c8\u2213\ue6ce\uc893\uffb2\u124b\ue7ad\u503b\ufaa4\uab83\u051b\u5cf2\u27ce\u6dc7\ue61d\uf88a\u9452\u9bae\u6ac4\u0955\u7178\ua5bd\u3a47\u5531\ucf4b\ub868\u92cb\u7344\u22af\udf17\ua4b3\ua174\u68d7\ud2f5\u5061\ubfac\u0012\u82c2\u4a6a\ud0db\u0a7a\udebc\u24c2\ud11d\u6966\u624f\u6bad\u8030\u1864\u868d\uf313\u943c\u672b\ud4f2\uf017\u57ae\ufbb3\u7846\ua4b5\uaba1\u3e63\u23cf\u459f")), GSGuiCelestialSelection$3.\u87c3("\u48c8\u2217\ue6d6\uc8a1\uffbe\u1253\ue7ac\u503f\ufa96\uab99\u050d\u5ca8\u27c8\u6dc5"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[6];
    }

    private static Object \u4e76(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[23] == null) {
            GSGuiCelestialSelection.\ub4ae[23] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(GSGuiCelestialSelection$2.\u310b("\uae72\ub91d\u1988\ue267\u3000\u9a14\u360f\u8f9b\u73c7\u5999\uf044\u789f\u2d4b\uf95d\ub1ae\ua679")), GSGuiCelestialSelection$2.\u310b("\uae6e\ub91d\u1992\ue273\u304b\u9a37\u3608"), methodType).asType(methodType));
        }
        return \ub4ae[23];
    }

    private static Object \u4ce3(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[11] == null) {
            GSGuiCelestialSelection.\ub4ae[11] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$0.\uc2b0("\ue36a\u2ff1\u3a63\u2284\u77a1\u3c6c\u1327\u4025\u4b61\u95d9\u5783\uc4de\u41f1\u1652\ue275\u7c9a\u863f")), GSGuiCelestialSelection$0.\uc2b0("\ue370\u2fe5\u3a61"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[11];
    }

    private static Object \u7ac5(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[36] == null) {
            GSGuiCelestialSelection.\ub4ae[36] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(GSGuiCelestialSelection$2.\u310b("\uae72\ub91d\u1988\ue267\u3000\u9a14\u360f\u8f9b\u73c7\u5999\uf05a\u788a\u2d4d\uf95c")), GSGuiCelestialSelection$2.\u310b("\uae7b\ub919\u1997\ue26a"), methodType).asType(methodType));
        }
        return \ub4ae[36];
    }

    private static Object \ua56c(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[28] == null) {
            GSGuiCelestialSelection.\ub4ae[28] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$1.\uc83e("\ua565\ue922\u7414\u2ae1\uc7eb\uf6f2\u086a\uecf8\ufba4\u8ccc\u5a78\ub6a0\ua7b3\u8d20\uc7f6\u3284")), GSGuiCelestialSelection$1.\uc83e("\ua563\ue926\u740c\u2ae7\uc7b1\uf6f6"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[28];
    }

    private static Object \u57ef(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[26] == null) {
            GSGuiCelestialSelection.\ub4ae[26] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$0.\uc2b0("\ue36a\u2ff1\u3a63\u2284\u77a1\u3c6c\u1327\u4025\u4b61\u95d9\u5783\uc4de\u41f1\u1652\ue275\u7c9a\u863f")), GSGuiCelestialSelection$0.\uc2b0("\ue367\u2ff5\u3a61"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[26];
    }

    private static Object \u186e(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[46] == null) {
            GSGuiCelestialSelection.\ub4ae[46] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(GSGuiCelestialSelection$3.\u87c3("\u48c5\u2213\ue6d4\uc893\uffe4\u125e\ue7bf\u5025\ufaa2\uabce\u0533\u5cbd\u27d9\u6dc0")), GSGuiCelestialSelection$3.\u87c3("\u48dd\u221d\ue6d7\uc89c\uffae"), methodType).asType(methodType));
        }
        return \ub4ae[46];
    }

    private static Object \uc4fa(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[41] == null) {
            GSGuiCelestialSelection.\ub4ae[41] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(GSGuiCelestialSelection$1.\uc83e("\ua565\ue922\u7414\u2ae1\uc7eb\uf6f2\u086a\uecf8\ufba4\u8ccc\u5a66\ub6b5\ua7b5\u8d21")), GSGuiCelestialSelection$1.\uc83e("\ua562\ue922\u741a"), methodType).asType(methodType));
        }
        return \ub4ae[41];
    }

    private static Object \ufcc5(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[0] == null) {
            GSGuiCelestialSelection.\ub4ae[0] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(GSGuiCelestialSelection$2.\u310b("\uae72\ub91d\u1988\ue267\u3000\u9a14\u360f\u8f9b\u73c7\u5999\uf05a\u788a\u2d4d\uf95c")), GSGuiCelestialSelection$2.\u310b("\uae75\ub915\u1990"), methodType).asType(methodType));
        }
        return \ub4ae[0];
    }

    private static Object \u7903(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[5] == null) {
            GSGuiCelestialSelection.\ub4ae[5] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$0.\uc2b0("\ue36a\u2ff1\u3a63\u2284\u77a1\u3c75\u1332\u4022\u4b6a\u95d9\u5798\uc4cb\u41f0\u1653\ue256\u7c9c\u860d\ue247\ube6f\u4994\uf333\u0f55\u890d")), GSGuiCelestialSelection$0.\uc2b0("\ue361\u2fe0\u3a65\u2280\u77e1\u3c7d"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[5];
    }

    private static Object \u5483(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[48] == null) {
            GSGuiCelestialSelection.\ub4ae[48] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$1.\uc83e("\ua565\ue922\u7414\u2ae1\uc7eb\uf6f2\u086a\uecf8\ufba4\u8ccc\u5a78\ub6a0\ua7b3\u8d20\uc7f6\u3284\u035a\u5cd7\ueb78\uda82\u3db4\ucd00\u6641")), GSGuiCelestialSelection$1.\uc83e("\ua57b\ue92c\u7431\u2af4\uc7b7\uf6f7\u0865\uecf1"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[48];
    }

    private static Object \u2dc1(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[49] == null) {
            GSGuiCelestialSelection.\ub4ae[49] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$3.\u87c3("\u48c5\u2213\ue6d4\uc893\uffe4\u125e\ue7bf\u5025\ufaa2\uabce\u052d\u5ca8\u27df\u6dc1\ue601\uf888\u943e\u9bae\u6ad9\u0950\u7170\ua5f6\u3a54")), GSGuiCelestialSelection$3.\u87c3("\u48ce\u2202\ue6d2\uc897\uffa4\u1256"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[49];
    }

    private static Object \ucea2(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[44] == null) {
            GSGuiCelestialSelection.\ub4ae[44] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$1.\uc83e("\ua565\ue922\u7414\u2ae1\uc7eb\uf6f2\u086a\uecf8\ufba4\u8ccc\u5a6e\ub6ac\ua7a2\u8d2c\uc7e8\u3297\u0371\u5ccd\ueb7f")), GSGuiCelestialSelection$1.\uc83e("\ua57f\ue931\u740b\u2aee\uc7b1\uf6cd\u087f\uecf7\ufba0\u8c89\u5a7f\ub6a6\ua7a0\u8d2a\uc7fd"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[44];
    }

    private static Object \uc543(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[37] == null) {
            GSGuiCelestialSelection.\ub4ae[37] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$3.\u87c3("\u48c8\u2213\ue6ce\uc893\uffb2\u124b\ue7ad\u503b\ufaa4\uab83\u051b\u5cf2\u27ce\u6dc7\ue61d\uf88a\u9452\u9bae\u6ac4\u0955\u7178\ua5bd\u3a47\u5531\ucf4b\ub868\u92cb\u7344\u22af\udf17\ua4b3\ua174\u68d7\ud2f5\u5061\ubfac\u0012\u82c2\u4a6a\ud0db\u0a7a\udebc\u24c2\ud11d\u6966\u624f\u6bad\u8030\u1864\u868d\uf313\u943c\u672b\ud4f2\uf017\u57ae\ufbb3\u7846\ua4b5\uaba1\u3e63\u23cf\u459f")), GSGuiCelestialSelection$3.\u87c3("\u48c8\u2217\ue6d6\uc8b7\uffa4\u1256\ue78d\u5032\ufab6\uab94\u051b\u5cb1"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[37];
    }

    private static Object \ufcbe(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[42] == null) {
            GSGuiCelestialSelection.\ub4ae[42] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$3.\u87c3("\u48c5\u2213\ue6d4\uc893\uffe4\u125c\ue7b7\u5024\ufaeb\uaba6\u0512\u5cb3\u27cc\u6ddc\ue62d\uf89a\u941a\u9bbd\u6ad5\u094e")), GSGuiCelestialSelection$3.\u87c3("\u48dd\u2217\ue6d5\uc89b\uffa4\u1256"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[42];
    }

    private static Object \u61d3(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[12] == null) {
            GSGuiCelestialSelection.\ub4ae[12] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$2.\u310b("\uae72\ub91d\u1988\ue267\u3000\u9a14\u360f\u8f9b\u73c7\u5999\uf05e\u7885\u2d4d\uf951\ub1a7\ua67b\uc6cb")), GSGuiCelestialSelection$2.\u310b("\uae71\ub912\u198a\ue250\u304f\u9a14\u361b\u8f90"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[12];
    }

    private static Object \u9f47(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[7] == null) {
            GSGuiCelestialSelection.\ub4ae[7] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(GSGuiCelestialSelection$0.\uc2b0("\ue36a\u2ff1\u3a63\u2284\u77a1\u3c75\u1332\u4022\u4b6a\u95d9\u5786\uc4de\u41f6\u1652")), GSGuiCelestialSelection$0.\uc2b0("\ue36d\u2ff1\u3a6d"), methodType).asType(methodType));
        }
        return \ub4ae[7];
    }

    private static Object \u4d87(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[40] == null) {
            GSGuiCelestialSelection.\ub4ae[40] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(GSGuiCelestialSelection$3.\u87c3("\u48c8\u2213\ue6ce\uc893\uffb2\u124b\ue7ad\u503b\ufaa4\uab83\u051b\u5cf2\u27ea\u6dc9\ue603\uf88e\u9404\u9ba2\u6ae3\u094c\u7175\ua5f0\u3a43")), GSGuiCelestialSelection$3.\u87c3("\u48cb\u2217\ue6c0\uc887\uffad"), methodType).asType(methodType));
        }
        return \ub4ae[40];
    }

    private static Object \u017a(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[4] == null) {
            GSGuiCelestialSelection.\ub4ae[4] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$0.\uc2b0("\ue36a\u2ff1\u3a63\u2284\u77a1\u3c75\u1332\u4022\u4b6a\u95d9\u5798\uc4cb\u41f0\u1653\ue256\u7c9c")), GSGuiCelestialSelection$0.\uc2b0("\ue365\u2fe1\u3a60\u2284\u77e3\u3c6a\u131a\u402b\u4b63\u9598\u57b9\uc4da\u41c1\u165b\ue24b\u7c9e"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[4];
    }

    private static Object \ub484(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[21] == null) {
            GSGuiCelestialSelection.\ub4ae[21] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$0.\uc2b0("\ue36a\u2ff1\u3a63\u2284\u77a1\u3c75\u1332\u4022\u4b6a\u95d9\u5798\uc4cb\u41f0\u1653\ue256\u7c9c\u860d\ue247\ube6f\u4994\uf333\u0f55\u890d")), GSGuiCelestialSelection$0.\uc2b0("\ue361\u2fe0\u3a65\u2280\u77e1\u3c7d"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[21];
    }

    private static Object \ubfdf(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[29] == null) {
            GSGuiCelestialSelection.\ub4ae[29] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$3.\u87c3("\u48c5\u2213\ue6d4\uc893\uffe4\u125e\ue7bf\u5025\ufaa2\uabce\u052d\u5ca8\u27df\u6dc1\ue601\uf888\u943e\u9bae\u6ad9\u0950\u7170\ua5f6\u3a54")), GSGuiCelestialSelection$3.\u87c3("\u48ce\u2202\ue6d2\uc897\uffa4\u1256"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[29];
    }

    private static Object \ub18c(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[45] == null) {
            GSGuiCelestialSelection.\ub4ae[45] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$1.\uc83e("\ua565\ue922\u7414\u2ae1\uc7eb\uf6f2\u086a\uecf8\ufba4\u8ccc\u5a78\ub6a0\ua7b3\u8d20\uc7f6\u3284")), GSGuiCelestialSelection$1.\uc83e("\ua57b\ue92c\u7437\u2af0\uc7b5\uf6fb\u0879\uecd5\ufba2\u8c91\u5a4e"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[45];
    }

    private static Object \ub9ea(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[24] == null) {
            GSGuiCelestialSelection.\ub4ae[24] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$1.\uc83e("\ua565\ue922\u7414\u2ae1\uc7eb\uf6f2\u086a\uecf8\ufba4\u8ccc\u5a78\ub6a0\ua7b3\u8d20\uc7f6\u3284\u035a\u5cd7\ueb78\uda82\u3db4\ucd00\u6641")), GSGuiCelestialSelection$1.\uc83e("\ua56e\ue933\u7412\u2ae5\uc7ab\uf6fa"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[24];
    }

    private static Object \u822d(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[25] == null) {
            GSGuiCelestialSelection.\ub4ae[25] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$3.\u87c3("\u48c5\u2213\ue6d4\uc893\uffe4\u1247\ue7aa\u5022\ufaa9\uabce\u0536\u5cbd\u27de\u6dc0\ue622\uf88e\u940c")), GSGuiCelestialSelection$3.\u87c3("\u48cc\u221d\ue6cc\uc886\uffab\u125b\ue7b0\u5038\ufa8e\uab85\u0507"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[25];
    }

    private static Object \ua5f6(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[33] == null) {
            GSGuiCelestialSelection.\ub4ae[33] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$2.\u310b("\uae72\ub91d\u1988\ue267\u3000\u9a14\u360f\u8f9b\u73c7\u5999\uf044\u789f\u2d4b\uf95d\ub1ae\ua679")), GSGuiCelestialSelection$2.\u310b("\uae6c\ub913\u19b2\ue269\u3059\u9a1d\u361c\u8fb6\u73c1\u59c4\uf072"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[33];
    }

    private static Object \uaf79(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[3] == null) {
            GSGuiCelestialSelection.\ub4ae[3] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$1.\uc83e("\ua565\ue922\u7414\u2ae1\uc7eb\uf6eb\u087f\uecff\ufbaf\u8ccc\u5a63\ub6b5\ua7b2\u8d21\uc7d5\u3282\u0368")), GSGuiCelestialSelection$1.\uc83e("\ua56a\ue92d\u7416\u2af2\uc7bc\uf6cd\u086e\uece2"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[3];
    }

    private static Object \u473f(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[16] == null) {
            GSGuiCelestialSelection.\ub4ae[16] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$3.\u87c3("\u48c5\u2213\ue6d4\uc893\uffe4\u125c\ue7b7\u5024\ufaeb\uaba6\u0512\u5cb3\u27cc\u6ddc\ue62d\uf89a\u941a\u9bbd\u6ad5\u094e")), GSGuiCelestialSelection$3.\u87c3("\u48cc\u221e\ue6c7\uc893\uffb8"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[16];
    }

    private static Object \u3c2c(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[31] == null) {
            GSGuiCelestialSelection.\ub4ae[31] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(GSGuiCelestialSelection$2.\u310b("\uae72\ub91d\u1988\ue267\u3000\u9a14\u360f\u8f9b\u73c7\u5999\uf05a\u788a\u2d4d\uf95c")), GSGuiCelestialSelection$2.\u310b("\uae7e\ub910\u1991\ue269\u305c"), methodType).asType(methodType));
        }
        return \ub4ae[31];
    }

    private static Object \ub389(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[35] == null) {
            GSGuiCelestialSelection.\ub4ae[35] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(GSGuiCelestialSelection$2.\u310b("\uae72\ub91d\u1988\ue267\u3000\u9a14\u360f\u8f9b\u73c7\u5999\uf05a\u788a\u2d4d\uf95c")), GSGuiCelestialSelection$2.\u310b("\uae6c\ub913\u19ac\ue267\u304a\u9a11\u360f\u8f9b\u73d3"), methodType).asType(methodType));
        }
        return \ub4ae[35];
    }

    private static Object \uc104(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[1] == null) {
            GSGuiCelestialSelection.\ub4ae[1] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(GSGuiCelestialSelection$0.\uc2b0("\ue36a\u2ff1\u3a63\u2284\u77a1\u3c75\u1332\u4022\u4b6a\u95d9\u5786\uc4de\u41f6\u1652")), GSGuiCelestialSelection$0.\uc2b0("\ue363\u2fff\u3a66"), methodType).asType(methodType));
        }
        return \ub4ae[1];
    }

    private static Object \uf917(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[13] == null) {
            GSGuiCelestialSelection.\ub4ae[13] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$3.\u87c3("\u48c5\u2213\ue6d4\uc893\uffe4\u125e\ue7bf\u5025\ufaa2\uabce\u052d\u5ca8\u27df\u6dc1\ue601\uf888")), GSGuiCelestialSelection$3.\u87c3("\u48dc\u2207\ue6c0\uc881\uffbe\u1240\ue7b7\u5025\ufaa2"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[13];
    }

    private static Object \u62d4(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[34] == null) {
            GSGuiCelestialSelection.\ub4ae[34] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$1.\uc83e("\ua565\ue922\u7414\u2ae1\uc7eb\uf6f2\u086a\uecf8\ufba4\u8ccc\u5a78\ub6a0\ua7b3\u8d20\uc7f6\u3284\u035a\u5cd7\ueb78\uda82\u3db4\ucd00\u6641")), GSGuiCelestialSelection$1.\uc83e("\ua56e\ue933\u7412\u2ae5\uc7ab\uf6fa"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[34];
    }

    private static Object \u55b0(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[18] == null) {
            GSGuiCelestialSelection.\ub4ae[18] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$0.\uc2b0("\ue36a\u2ff1\u3a63\u2284\u77a1\u3c75\u1332\u4022\u4b6a\u95d9\u5798\uc4cb\u41f0\u1653\ue256\u7c9c")), GSGuiCelestialSelection$0.\uc2b0("\ue363\u2fff\u3a7b\u2291\u77ee\u3c70\u133d\u403f"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[18];
    }

    private static Object \u8bd4(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[14] == null) {
            GSGuiCelestialSelection.\ub4ae[14] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$0.\uc2b0("\ue36a\u2ff1\u3a63\u2284\u77a1\u3c6c\u1327\u4025\u4b61\u95d9\u578a\uc4cd\u41f0\u165b\ue241\u7cb7\u8626\ue241\ube72")), GSGuiCelestialSelection$0.\uc2b0("\ue369\u2fe4\u3a70\u2297\u77ee\u3c6d\u133c\u403e"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[14];
    }

    private static Object \u485e(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[20] == null) {
            GSGuiCelestialSelection.\ub4ae[20] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$0.\uc2b0("\ue36a\u2ff1\u3a63\u2284\u77a1\u3c77\u133a\u4023\u4b23\u95b1\u57a7\uc4d0\u41e3\u164e\ue27a\u7c8e\u8629\ue254\ube63\u498a")), GSGuiCelestialSelection$0.\uc2b0("\ue366\u2ffc\u3a7c\u2295"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[20];
    }

    private static Object \u963f(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[27] == null) {
            GSGuiCelestialSelection.\ub4ae[27] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(GSGuiCelestialSelection$3.\u87c3("\u48c8\u2213\ue6ce\uc893\uffb2\u124b\ue7ad\u503b\ufaa4\uab83\u051b\u5cf2\u27ce\u6dc7\ue61d\uf88a\u9452\u9bb5\u6ad5\u0948\u7163\ua5fc\u3a54\u5529\ucf11\ub86a\u92c5\u7349\u22ab\udf1f\ua4be\ua174\u68d1\ud2e7\u5079\ubfbf\u0005\u82d5\u4a56\ud0c6\u0a62\ude8a\u24d3\ud137\u6962\u620a\u6b93\u803f\u1875\u8689\uf328\u940e\u672a\ud4fa\uf01a\u57b9\ufb92")), GSGuiCelestialSelection$3.\u87c3("\u48dc\u2217\ue6cc\uc896\uff9e\u125d\ue78d\u502e\ufab7\uab96\u051b\u5cae"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub4ae[27];
    }

    private static Object \ub721(Object object, String string, MethodType methodType) {
        if (\ub4ae == null) {
            \ub4ae = new Object[50];
        }
        if (\ub4ae[9] == null) {
            GSGuiCelestialSelection.\ub4ae[9] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(GSGuiCelestialSelection$0.\uc2b0("\ue367\u2ff1\u3a79\u2284\u77f7\u3c60\u1320\u403c\u4b6c\u9594\u57ae\uc491\u41e1\u1655\ue24a\u7c9e\u8661\ue247\ube72\u4991\uf33b\u0f1e\u891e\u1e1a\uaccc\u2210\u84c4\u0a4f\u028d\u8b03\ud865\ude3f\ud3b2\u7256\u4d36\u0841\u00c8\ud83a\u0e73\u5b7a\u5a64\ufe29\ua795\u1a47\u5c0f")), GSGuiCelestialSelection$0.\uc2b0("\ue363\u2ffc\u3a74\u2296\u77fc\u3c49\u133f\u402d\u4b63\u9592\u57bf"), methodType).asType(methodType));
        }
        return \ub4ae[9];
    }
}

