/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.client.render;

import galaxyspace.core.client.render.FluidRenderer$0;
import galaxyspace.core.client.render.FluidRenderer$3;
import galaxyspace.core.client.render.block.GSRenderEntityBlock;
import galaxyspace.core.client.render.block.GSRenderEntityBlock$RenderInfo;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class FluidRenderer {
    public static final int DISPLAY_STAGES = 50;
    private static Map<Fluid, int[]> flowingRenderCache = new HashMap<Fluid, int[]>();
    private static Map<Fluid, int[]> stillRenderCache = new HashMap<Fluid, int[]>();
    private static final GSRenderEntityBlock$RenderInfo liquidBlock = new GSRenderEntityBlock$RenderInfo();
    private static volatile transient Object[] \u3b28;

    private FluidRenderer() {
    }

    public static void onTextureReload() {
        for (int[] nArray : flowingRenderCache.values()) {
            for (int n : nArray) {
                GL11.glDeleteLists((int)n, (int)1);
            }
        }
        flowingRenderCache.clear();
        for (int[] nArray : stillRenderCache.values()) {
            for (int n : nArray) {
                GL11.glDeleteLists((int)n, (int)1);
            }
        }
        stillRenderCache.clear();
    }

    public static IIcon getFluidTexture(FluidStack fluidStack, boolean bl) {
        if (fluidStack == null) {
            return null;
        }
        return FluidRenderer.getFluidTexture(fluidStack.getFluid(), bl);
    }

    public static IIcon getFluidTexture(Fluid fluid, boolean bl) {
        IIcon iIcon;
        if (fluid == null) {
            return null;
        }
        IIcon iIcon2 = iIcon = bl ? fluid.getFlowingIcon() : fluid.getStillIcon();
        if (iIcon == null) {
            iIcon = ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b)).func_110572_b(FluidRenderer$0.\uc0b6("\uc45a\udb08\u13fa\u8b26\u8b06\ub6c4\u9cea\ud110\uf71a"));
        }
        return iIcon;
    }

    public static void setColorForFluidStack(FluidStack fluidStack) {
        if (fluidStack == null) {
            return;
        }
        int n = fluidStack.getFluid().getColor(fluidStack);
        FluidRenderer.setGLColorFromInt(n);
    }

    public static int[] getFluidDisplayLists(FluidStack fluidStack, World world, boolean bl) {
        if (fluidStack == null) {
            return null;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return null;
        }
        Map<Fluid, int[]> map = bl ? flowingRenderCache : stillRenderCache;
        int[] nArray = map.get(fluid);
        if (nArray != null) {
            return nArray;
        }
        nArray = new int[50];
        if (fluid.getBlock() != null) {
            FluidRenderer.liquidBlock.baseBlock = fluid.getBlock();
            FluidRenderer.liquidBlock.texture = FluidRenderer.getFluidTexture(fluidStack, bl);
        } else {
            FluidRenderer.liquidBlock.baseBlock = Blocks.field_150355_j;
            FluidRenderer.liquidBlock.texture = FluidRenderer.getFluidTexture(fluidStack, bl);
        }
        map.put(fluid, nArray);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2884);
        for (int i = 0; i < 50; ++i) {
            nArray[i] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)nArray[i], (int)4864);
            FluidRenderer.liquidBlock.minX = 0.01f;
            FluidRenderer.liquidBlock.minY = 0.0;
            FluidRenderer.liquidBlock.minZ = 0.01f;
            FluidRenderer.liquidBlock.maxX = 0.99f;
            FluidRenderer.liquidBlock.maxY = (float)FluidRenderer.\u3b07("\ud3dc", (int)i, (int)1) / 50.0f;
            FluidRenderer.liquidBlock.maxZ = 0.99f;
            FluidRenderer.\uca4f("\u0c8f", (GSRenderEntityBlock)GSRenderEntityBlock.INSTANCE, (GSRenderEntityBlock$RenderInfo)liquidBlock);
            GL11.glEndList();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2896);
        return nArray;
    }

    public static void setGLColorFromInt(int n) {
        float f = (float)(n >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(n >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(n & 0xFF) / 255.0f;
        GL11.glColor4f((float)f, (float)f2, (float)f3, (float)1.0f);
    }

    private static Object \uca4f(Object object, String string, MethodType methodType) {
        if (\u3b28 == null) {
            \u3b28 = new Object[2];
        }
        if (\u3b28[1] == null) {
            FluidRenderer.\u3b28[1] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(FluidRenderer$3.\u7df7("\ud675\uc576\u7ec0\u50da\u1c52\ucee0\u564f\ua8b6\uc1fc\ua863\u48da\u7d9d\u7ff2\ud143\u579f\u7d31\ucd6a\ud201\u917b\u15fb\ucdc7\u1943\ud45a\u12af\ua85f\ubdd1\u9054\u787e\u030c\ucaf6\u70b0\u8769\u9b93\u0d97\u2372\ufe0f\u4262\u9c27\u2750\uf90c\ubc18\u1fb5\ucf43\u1ac1\udb5b\u8433\u674f\ucb25\uf262\uf613\u0604\u7e44\u2917\u521c\uc737\u1626")), FluidRenderer$3.\u7df7("\ud660\uc572\u7ec2\u50df\u1c4f\uceeb\u567e\ua8aa\uc1f2\ua863\u48d4"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u3b28[1];
    }

    private static Object \u3b07(Object object, String string, MethodType methodType) {
        if (\u3b28 == null) {
            \u3b28 = new Object[2];
        }
        if (\u3b28[0] == null) {
            FluidRenderer.\u3b28[0] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(FluidRenderer$0.\uc0b6("\uc45d\udb00\u13ff\u8b34\u8b41\ub6c6\u9cec\ud110\uf712\u324a\uff5b\u5b91\ub148\u4974")), FluidRenderer$0.\uc0b6("\uc45a\udb00\u13f1"), methodType).asType(methodType));
        }
        return \u3b28[0];
    }
}

