/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.registers.fluids;

import cpw.mods.fml.common.registry.GameRegistry;
import galaxyspace.core.prefab.blocks.BlockFluidGS;
import galaxyspace.core.prefab.items.ItemGSBucket;
import galaxyspace.core.registers.items.GSItems;
import galaxyspace.galaxies.milkyway.SolarSystem.moons.titan.blocks.TitanBlockMethane;
import galaxyspace.galaxies.milkyway.SolarSystem.planets.overworld.items.ItemHeliumCanister;
import galaxyspace.galaxies.milkyway.SolarSystem.planets.overworld.items.ItemHydrogenCanister;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GSFluids {
    public static Fluid LiquidEthaneMethane;
    public static Fluid Helium3;
    public static Fluid Hydrogen2;
    public static Fluid HeliumHydrogen;
    public static Fluid SulfurAcid;
    public static Block BlockHelium3;
    public static Block BlockHydrogen2;
    public static Block BlockLiquidMethane;
    public static Block BlockHeliumHydrogen;
    public static Block BlockSulfurAcid;

    public static void initialize() {
        GSFluids.FluidRegistration();
        GSFluids.BlockFluidRegistration();
        GSFluids.ItemsFluidRegistration();
    }

    public static void FluidRegistration() {
        LiquidEthaneMethane = new Fluid("liquidethanemethane").setGaseous(false).setDensity(400).setViscosity(2500);
        Helium3 = new Fluid("helium3").setGaseous(true).setDensity(-1000).setViscosity(1000);
        Hydrogen2 = new Fluid("hydrogen2").setGaseous(false).setDensity(1000).setViscosity(3000);
        HeliumHydrogen = GSFluids.registerFluid("heliumhydrogen", 1200, 1500, 10, false);
        SulfurAcid = GSFluids.registerFluid("sulfuricacid", 1000, 1500, 150, false);
        FluidRegistry.registerFluid((Fluid)LiquidEthaneMethane);
        FluidRegistry.registerFluid((Fluid)Helium3);
        FluidRegistry.registerFluid((Fluid)Hydrogen2);
    }

    private static Fluid registerFluid(String fluidName, int density, int viscosity, int temperature, boolean gaseous) {
        Fluid returnFluid = FluidRegistry.getFluid((String)fluidName);
        if (returnFluid == null) {
            FluidRegistry.registerFluid((Fluid)new Fluid(fluidName).setDensity(density).setViscosity(viscosity).setTemperature(temperature).setGaseous(gaseous));
            returnFluid = FluidRegistry.getFluid((String)fluidName);
        }
        return returnFluid;
    }

    public static void BlockFluidRegistration() {
        BlockLiquidMethane = new TitanBlockMethane(LiquidEthaneMethane, Material.field_151586_h).func_149663_c("EthaneMethane");
        BlockHelium3 = new BlockFluidGS(Helium3, Material.field_151586_h, false).func_149663_c("Helium3");
        BlockHydrogen2 = new BlockFluidGS(Hydrogen2, Material.field_151586_h, false).func_149663_c("Hydrogen2");
        BlockHeliumHydrogen = new BlockFluidGS(HeliumHydrogen, Material.field_151586_h, false).func_149663_c("HeliumHydrogen");
        BlockSulfurAcid = new BlockFluidGS(SulfurAcid, Material.field_151586_h, true).func_149663_c("SulfurAcid");
        GameRegistry.registerBlock((Block)BlockLiquidMethane, (String)"liquidethanemethane");
        GameRegistry.registerBlock((Block)BlockHelium3, (String)"helium3");
        GameRegistry.registerBlock((Block)BlockHydrogen2, (String)"hydrogen2");
        GameRegistry.registerBlock((Block)BlockHeliumHydrogen, (String)"heliumhydrogen");
        GameRegistry.registerBlock((Block)BlockSulfurAcid, (String)"sulfuracid");
    }

    public static void ItemsFluidRegistration() {
        GSItems.IceBucket = new ItemGSBucket(Blocks.field_150432_aD, "IceBucket", "bucket_ice");
        GSItems.DetheriumBucket = new ItemGSBucket(BlockHydrogen2, "DetheriumBucket", "bucket_detherium");
        GSItems.EthaneMethaneBucket = new ItemGSBucket(BlockLiquidMethane, "EthaneMethaneBucket", "bucket_methane");
        GSItems.HeliumHydrogenBucket = new ItemGSBucket(BlockHeliumHydrogen, "HeliumHydrogenBucket", "bucket_heliumhydrogen_fuel");
        GSItems.Helium3Canister = new ItemHeliumCanister("ItemHelium3Canister");
        GSItems.HydrogenCanister = new ItemHydrogenCanister("ItemHydrogenCanister");
        GSItems.SulfurAcidBucket = new ItemGSBucket(BlockSulfurAcid, "SulfurAcidBucket", "bucket_sulfur_acid");
        GSItems.registerItem(GSItems.EthaneMethaneBucket);
        GSItems.registerItem(GSItems.Helium3Canister);
        GSItems.registerItem(GSItems.HydrogenCanister);
        GSItems.registerItem(GSItems.IceBucket);
        GSItems.registerItem(GSItems.SulfurAcidBucket);
        GSItems.registerItem(GSItems.HeliumHydrogenBucket);
        FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack(HeliumHydrogen, 1000), new ItemStack(GSItems.HeliumHydrogenBucket), new ItemStack(Items.field_151133_ar)));
        FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack(LiquidEthaneMethane, 1000), new ItemStack(GSItems.EthaneMethaneBucket), new ItemStack(Items.field_151133_ar)));
        FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack(SulfurAcid, 1000), new ItemStack(GSItems.SulfurAcidBucket), new ItemStack(Items.field_151133_ar)));
        FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack(Helium3, 1000), new ItemStack(GSItems.Helium3Canister, 1, 1), new ItemStack(GSItems.Helium3Canister, 1, 1001)));
        FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack(FluidRegistry.getFluid((String)"hydrogen"), 1000), new ItemStack(GSItems.HydrogenCanister, 1, 1), new ItemStack(GCItems.oilCanister, 1, 1001)));
    }
}

