/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.world.worldengine.perlinnoise;

import galaxyspace.core.world.worldengine.perlinnoise.WhiteNoise;

public abstract class GenNoiseTemplate {
    public long seed;
    public double persistence;
    public double scaleX;
    public double scaleY;
    public double scaleZ;
    public int octaves;
    public int height;
    public byte iType;
    public WhiteNoise rand;

    public GenNoiseTemplate(long l, double d, int n, double d2, double d3, double d4, int n2, byte by) {
        this.seed = l;
        this.persistence = d;
        this.octaves = n;
        this.scaleX = d2;
        this.scaleY = d3;
        this.scaleZ = d4;
        this.height = n2;
        this.iType = by;
        this.rand = new WhiteNoise(l);
    }

    public GenNoiseTemplate(long l, double d, int n, double d2, double d3, int n2) {
        this(l, d, n, d2, d3, d2, n2, 2);
    }

    public double lerp3d(double d, double d2, double d3) {
        return d + (d2 - d) * d3;
    }

    public float lerp3f(float f, float f2, float f3) {
        return f + (f2 - f) * f3;
    }

    public double smoothstep1d(double d) {
        return d * d * (3.0 - 2.0 * d);
    }

    public float smoothstep1f(float f) {
        return f * f * (3.0f - 2.0f * f);
    }

    public double smootherstep1d(double d) {
        return d * d * d * (d * (d * 6.0 - 15.0) + 10.0);
    }

    public float smootherstep1f(float f) {
        return f * f * f * (f * (f * 6.0f - 15.0f) + 10.0f);
    }

    public double autoSmooth1d(double d) {
        switch (this.iType) {
            case 2: {
                return this.smootherstep1d(d);
            }
            case 1: {
                return this.smoothstep1d(d);
            }
        }
        return d;
    }

    public float autoSmooth1f(float f) {
        switch (this.iType) {
            case 2: {
                return this.smootherstep1f(f);
            }
            case 1: {
                return this.smoothstep1f(f);
            }
        }
        return f;
    }

    public double dot2d(double[] dArray, double[] dArray2) {
        return dArray[0] * dArray2[0] + dArray[1] * dArray2[1];
    }

    public float dot2f(float[] fArray, float[] fArray2) {
        return fArray[0] * fArray2[0] + fArray[1] * fArray2[1];
    }

    public abstract double noiseOctave2d(double var1, double var3);

    public abstract float noiseOctave2f(float var1, float var2);

    public double genNoise2d(double d, double d2) {
        double d3 = 0.0;
        double d4 = 1.0;
        double d5 = d;
        double d6 = d2;
        for (int i = 0; i < this.octaves; ++i) {
            d3 += this.noiseOctave2d(d5 / this.scaleX, d6 / this.scaleZ) * d4;
            d4 *= this.persistence;
            d5 *= 2.0;
            d6 *= 2.0;
        }
        return (double)this.height + d3 * this.scaleY;
    }

    public float genNoise2f(float f, float f2) {
        float f3 = 0.0f;
        float f4 = 1.0f;
        float f5 = f;
        float f6 = f2;
        for (int i = 0; i < this.octaves; ++i) {
            f3 += this.noiseOctave2f(f5 / (float)this.scaleX, f6 / (float)this.scaleZ) * f4;
            f4 *= (float)this.persistence;
            f5 *= 2.0f;
            f6 *= 2.0f;
        }
        return (float)this.height + f3 * (float)this.scaleY;
    }
}

