/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.galaxies.milkyway.BarnardsSystem.planets.barnardaC.dimension;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import galaxyspace.api.dimension.IAdvancedSpace;
import galaxyspace.core.world.gen.WorldProviderAdvancedSpace;
import galaxyspace.galaxies.milkyway.BarnardsSystem.BarnardsSystemBodies;
import galaxyspace.galaxies.milkyway.BarnardsSystem.planets.barnardaC.dimension.ChunkProviderBarnardaC;
import galaxyspace.galaxies.milkyway.BarnardsSystem.planets.barnardaC.dimension.WorldChunkManagerBarnardaC;
import galaxyspace.galaxies.milkyway.BarnardsSystem.planets.barnardaC.dimension.sky.SkyProviderBarnardaC;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.core.client.CloudRenderer;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.util.MathHelper;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.IRenderHandler;

public class WorldProviderBarnardaC
extends WorldProviderAdvancedSpace
implements ISolarLevel,
IAdvancedSpace {
    @Override
    public double getSolarEnergyMultiplier() {
        double d = -1.0;
        if (d < 0.0) {
            double d2 = this.getSolarSize();
            d = d2 * d2 * d2 * ConfigManagerCore.spaceStationEnergyScalar;
        }
        return d;
    }

    @Override
    public boolean canSpaceshipTierPass(int n) {
        return n >= this.getCelestialBody().getTierRequirement();
    }

    public double getHorizon() {
        return 4.0;
    }

    public float getFallDamageModifier() {
        return 0.9f;
    }

    public double getFuelUsageMultiplier() {
        return 1.0;
    }

    public double getMeteorFrequency() {
        return 0.0;
    }

    public float getSoundVolReductionAmount() {
        return Float.MAX_VALUE;
    }

    public boolean canRainOrSnow() {
        return true;
    }

    public boolean canBlockFreeze(int n, int n2, int n3, boolean bl) {
        return false;
    }

    public CelestialBody getCelestialBody() {
        return BarnardsSystemBodies.barnardaC;
    }

    public Class<? extends IChunkProvider> getChunkProviderClass() {
        return ChunkProviderBarnardaC.class;
    }

    public Vector3 getFogColor() {
        float f = 1.0f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.98039216f * f), (double)(0.654902f * f), (double)(0.41960785f * f));
    }

    public Vector3 getSkyColor() {
        float f = 1.0f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.23921569f * f), (double)(0.3372549f * f), (double)(0.6862745f * f));
    }

    public boolean func_76561_g() {
        return true;
    }

    public Class<? extends WorldChunkManager> getWorldChunkManagerClass() {
        return WorldChunkManagerBarnardaC.class;
    }

    public boolean hasSunset() {
        return false;
    }

    public boolean shouldForceRespawn() {
        return !ConfigManagerCore.forceOverworldRespawn;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float f) {
        float f2 = this.field_76579_a.func_72826_c(f);
        float f3 = 1.0f - (MathHelper.func_76134_b((float)(f2 * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        return f3 * f3 * 0.5f + 0.3f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float f) {
        float f2 = this.field_76579_a.func_72826_c(1.0f);
        float f3 = 1.25f - (MathHelper.func_76134_b((float)(f2 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        f3 = 1.2f - f3;
        return f3 * 0.6f;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getCloudRenderer() {
        if (super.getCloudRenderer() == null) {
            this.setCloudRenderer((IRenderHandler)new CloudRenderer());
        }
        return super.getCloudRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        if (super.getSkyRenderer() == null) {
            this.setSkyRenderer(new SkyProviderBarnardaC());
        }
        return super.getSkyRenderer();
    }

    @Override
    public double getSolarWindMultiplier() {
        double d = -1.0;
        if (d < 0.0) {
            double d2 = this.getSolarSize();
            d = d2 * d2 * d2 * ConfigManagerCore.spaceStationEnergyScalar;
        }
        return d;
    }
}

