/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.galaxies.milkyway.SolarSystem.planets.kuiperbelt.dimension;

import galaxyspace.core.registers.blocks.GSBlocks;
import galaxyspace.core.world.gen.GSBiomeGenBase;
import galaxyspace.galaxies.milkyway.SolarSystem.moons.europa.entities.EntityEvolvedColdBlaze;
import galaxyspace.galaxies.milkyway.SolarSystem.planets.kuiperbelt.dimension.ChunkProviderKuiper$AsteroidData;
import galaxyspace.galaxies.milkyway.SolarSystem.planets.kuiperbelt.dimension.ChunkProviderKuiper$KuiperSaveData;
import galaxyspace.galaxies.milkyway.SolarSystem.planets.kuiperbelt.dimension.ChunkProviderKuiper$WorldProviderKuiper;
import galaxyspace.galaxies.milkyway.SolarSystem.planets.kuiperbelt.dimension.WorldChunkManagerKuiper$WorldProviderKuiper;
import galaxyspace.galaxies.milkyway.SolarSystem.planets.kuiperbelt.dimension.WorldChunkManagerKuiper$WorldProviderKuiper$AsteroidData;
import galaxyspace.galaxies.milkyway.SolarSystem.planets.kuiperbelt.dimension.WorldProviderKuiper;
import galaxyspace.galaxies.milkyway.SolarSystem.planets.kuiperbelt.world.gen.MapGenSpaceship;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import micdoodle8.mods.galacticraft.core.perlin.NoiseModule;
import micdoodle8.mods.galacticraft.core.perlin.generator.Billowed;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.planets.asteroids.ConfigManagerAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.SpecialAsteroidBlock;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.SpecialAsteroidBlockHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenTrees;

public class ChunkProviderKuiper
extends ChunkProviderGenerate {
    final Block ASTEROID_STONE = AsteroidBlocks.blockBasic;
    final byte ASTEROID_STONE_META_0 = 0;
    final byte ASTEROID_STONE_META_1 = 1;
    final byte ASTEROID_STONE_META_2 = (byte)2;
    final Block ASTEROID_ICE = AsteroidBlocks.blockDenseIce;
    final Block DIRT = Blocks.field_150346_d;
    final byte DIRT_META = 0;
    final Block GRASS = Blocks.field_150349_c;
    final byte GRASS_META = 0;
    final Block LIGHT = Blocks.field_150426_aN;
    final byte LIGHT_META = 0;
    final Block TALL_GRASS = Blocks.field_150329_H;
    final byte TALL_GRASS_META = 1;
    final Block FLOWER = Blocks.field_150328_O;
    final Block LAVA = Blocks.field_150353_l;
    final byte LAVA_META = 0;
    final Block WATER = Blocks.field_150355_j;
    final byte WATER_META = 0;
    private final Random rand;
    private final World worldObj;
    private final NoiseModule asteroidDensity;
    private final NoiseModule asteroidTurbulance;
    private final NoiseModule asteroidSkewX;
    private final NoiseModule asteroidSkewY;
    private final NoiseModule asteroidSkewZ;
    private final SpecialAsteroidBlockHandler coreHandler;
    private final SpecialAsteroidBlockHandler shellHandler;
    private static final int CHUNK_SIZE_X = 16;
    private static final int CHUNK_SIZE_Y = 256;
    private static final int CHUNK_SIZE_Z = 16;
    private static final int MAX_ASTEROID_RADIUS = 15;
    private static final int MIN_ASTEROID_RADIUS = 5;
    private static final int MAX_ASTEROID_SKEW = 8;
    private static final int MIN_ASTEROID_Y = 48;
    private static final int MAX_ASTEROID_Y = 208;
    private static final int ASTEROID_CHANCE = 2400;
    private static final int ASTEROID_CORE_CHANCE = 2;
    private static final int ASTEROID_SHELL_CHANCE = 2;
    private static final int MIN_BLOCKS_PER_CHUNK = 50;
    private static final int MAX_BLOCKS_PER_CHUNK = 200;
    private static final int ILMENITE_CHANCE = 400;
    private static final int IRON_CHANCE = 300;
    private static final int ALUMINUM_CHANCE = 250;
    private static final int RANDOM_BLOCK_FADE_SIZE = 32;
    private static final int FADE_BLOCK_CHANCE = 5;
    private static final int NOISE_OFFSET_SIZE = 256;
    private static final float MIN_HOLLOW_SIZE = 0.6f;
    private static final float MAX_HOLLOW_SIZE = 0.8f;
    private static final int HOLLOW_CHANCE = 10;
    private static final int MIN_RADIUS_FOR_HOLLOW = 15;
    private static final float HOLLOW_LAVA_SIZE = 0.12f;
    private static final int TREE_CHANCE = 2;
    private static final int TALL_GRASS_CHANCE = 2;
    private static final int FLOWER_CHANCE = 2;
    private static final int WATER_CHANCE = 2;
    private static final int LAVA_CHANCE = 2;
    private static final int GLOWSTONE_CHANCE = 20;
    private ArrayList<ChunkProviderKuiper$AsteroidData> largeAsteroids = new ArrayList();
    private int largeCount = 0;
    private static HashSet<BlockVec3> chunksDone = new HashSet();
    private int largeAsteroidsLastChunkX;
    private int largeAsteroidsLastChunkZ;
    private final MapGenSpaceship spaceship = new MapGenSpaceship();
    private static volatile transient Object[] \ub8f3;

    public ChunkProviderKuiper(World world, long l, boolean bl) {
        super(world, l, bl);
        this.worldObj = world;
        this.rand = new Random(l);
        this.asteroidDensity = new Billowed((long)ChunkProviderKuiper.\u6bbc("\ud19a", (Random)this.rand), 2, 0.25f);
        this.asteroidDensity.setFrequency(0.009f);
        this.asteroidDensity.amplitude = 0.6f;
        this.asteroidTurbulance = new Gradient((long)ChunkProviderKuiper.\u6bbc("\ud19a", (Random)this.rand), 1, 0.2f);
        this.asteroidTurbulance.setFrequency(0.08f);
        this.asteroidTurbulance.amplitude = 0.5f;
        this.asteroidSkewX = new Gradient((long)ChunkProviderKuiper.\u6bbc("\ud19a", (Random)this.rand), 1, 1.0f);
        this.asteroidSkewX.amplitude = 8.0f;
        this.asteroidSkewX.frequencyX = 0.005f;
        this.asteroidSkewY = new Gradient((long)ChunkProviderKuiper.\u6bbc("\ud19a", (Random)this.rand), 1, 1.0f);
        this.asteroidSkewY.amplitude = 8.0f;
        this.asteroidSkewY.frequencyY = 0.005f;
        this.asteroidSkewZ = new Gradient((long)ChunkProviderKuiper.\u6bbc("\ud19a", (Random)this.rand), 1, 1.0f);
        this.asteroidSkewZ.amplitude = 8.0f;
        this.asteroidSkewZ.frequencyZ = 0.005f;
        this.coreHandler = new SpecialAsteroidBlockHandler();
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, this.ASTEROID_STONE_META_2, 5, 0.3));
        ((Object)((Object)this)).getClass();
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 1, 7, 0.3));
        ((Object)((Object)this)).getClass();
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 0, 11, 0.25));
        this.coreHandler.addBlock(new SpecialAsteroidBlock(GSBlocks.Ores, 0, 3, 0.13));
        this.coreHandler.addBlock(new SpecialAsteroidBlock(GSBlocks.Ores, 1, 2, 0.5));
        this.coreHandler.addBlock(new SpecialAsteroidBlock(GSBlocks.Ores, 2, 1, 0.3));
        this.coreHandler.addBlock(new SpecialAsteroidBlock(GSBlocks.Ores, 3, 1, 0.1));
        this.coreHandler.addBlock(new SpecialAsteroidBlock(GSBlocks.CeresBlocks, 2, 3, 0.14));
        this.shellHandler = new SpecialAsteroidBlockHandler();
        ((Object)((Object)this)).getClass();
        this.shellHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 0, 1, 0.15));
        ((Object)((Object)this)).getClass();
        this.shellHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 1, 3, 0.15));
        this.shellHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, this.ASTEROID_STONE_META_2, 1, 0.15));
        this.shellHandler.addBlock(new SpecialAsteroidBlock(AsteroidBlocks.blockDenseIce, 0, 1, 0.15));
    }

    public void generateTerrain(int n, int n2, Block[] blockArray, byte[] byArray, boolean bl) {
        ChunkProviderKuiper.\u5d13("\ua60a", this.largeAsteroids);
        this.largeCount = 0;
        Random random = new Random();
        int n3 = 2400;
        int n4 = 160;
        int n5 = 10;
        for (int i = n - 3; i < n + 3; ++i) {
            int n6 = i * 16;
            int n7 = n6 + 16;
            for (int j = n2 - 3; j < n2 + 3; ++j) {
                int n8 = j * 16;
                int n9 = n8 + 16;
                for (int k = n6; k < n7; k += 2) {
                    for (int i2 = n8; i2 < n9; i2 += 2) {
                        if (!((double)this.randFromPointPos(k, i2) < ((double)this.asteroidDensity.getNoise((float)k, (float)i2) + 0.4) / 2400.0)) continue;
                        ChunkProviderKuiper.\u9dd1("\u8de5", (Random)random, (long)(k + i2 * 3067));
                        reference var18_18 = ChunkProviderKuiper.\u8273("\ubefd", (Random)random, (int)160) + 48;
                        reference var19_19 = ChunkProviderKuiper.\u8273("\ubefd", (Random)random, (int)10) + 5;
                        this.generateAsteroid(random, k, (int)var18_18, i2, n << 4, n2 << 4, (int)var19_19, blockArray, byArray, bl);
                        ++this.largeCount;
                    }
                }
            }
        }
    }

    private void generateAsteroid(Random random, int n, int n2, int n3, int n4, int n5, int n6, Block[] blockArray, byte[] byArray, boolean bl) {
        float f;
        int n7;
        int n8;
        float f2;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        SpecialAsteroidBlock specialAsteroidBlock = this.coreHandler.getBlock(random, n6);
        SpecialAsteroidBlock specialAsteroidBlock2 = null;
        if (ChunkProviderKuiper.\u8273("\ubefd", (Random)random, (int)2) == false) {
            specialAsteroidBlock2 = this.shellHandler.getBlock(random, n6);
        }
        boolean bl2 = false;
        reference var14_14 = ChunkProviderKuiper.\ua1c5("\u869a", (Random)random) * 0.19999999f + 0.6f;
        if (ChunkProviderKuiper.\u8273("\ubefd", (Random)random, (int)10) == false && n6 >= 15) {
            bl2 = true;
            specialAsteroidBlock2 = new SpecialAsteroidBlock(AsteroidBlocks.blockDenseIce, 0, 1, 0.15);
        }
        ChunkProviderKuiper.\u8332("\ub803", (WorldProviderKuiper)((WorldProviderKuiper)this.worldObj.field_73011_w), (int)n, (int)n2, (int)n3, (int)n6, (int)(bl2 ? -1 : specialAsteroidBlock.index));
        int n16 = this.clamp((int)(ChunkProviderKuiper.\ua1ce("\u7452", (int)n4, (int)(n - n6 - 8 - 2)) - n4), 0, 16);
        int n17 = this.clamp((int)(ChunkProviderKuiper.\ua1ce("\u7452", (int)n5, (int)(n3 - n6 - 8 - 2)) - n5), 0, 16);
        int n18 = n2 - n6 - 8 - 2;
        int n19 = n2 + n6 + 8 + 2;
        int n20 = this.clamp((int)(ChunkProviderKuiper.\ubba7("\ud3da", (int)(n4 + 16), (int)(n + n6 + 8 + 2)) - n4), 0, 16);
        int n21 = this.clamp((int)(ChunkProviderKuiper.\ubba7("\ud3da", (int)(n5 + 16), (int)(n3 + n6 + 8 + 2)) - n5), 0, 16);
        int n22 = n20 - n16;
        int n23 = n19 - n18;
        int n24 = n21 - n17;
        if (n22 <= 0 || n23 <= 0 || n24 <= 0) {
            return;
        }
        float f3 = this.randFromPoint(n, n2, n3) * 256.0f + (float)n4;
        float f4 = this.randFromPoint(n * 7, n2 * 11, n3 * 13) * 256.0f;
        float f5 = this.randFromPoint(n * 17, n2 * 23, n3 * 29) * 256.0f + (float)n5;
        this.setOtherAxisFrequency(1.0f / ((float)n6 * 2.0f / 2.0f));
        float[] fArray = new float[n23 * n24];
        float[] fArray2 = new float[n22 * n23];
        float[] fArray3 = new float[n22 * n24];
        for (int i = 0; i < n22; ++i) {
            n15 = i * n24;
            float f6 = (float)i + f3;
            for (int j = 0; j < n24; ++j) {
                fArray3[n15 + j] = this.asteroidSkewY.getNoise(f6, (float)j + f5);
            }
        }
        ChunkProviderKuiper$AsteroidData chunkProviderKuiper$AsteroidData = new ChunkProviderKuiper$AsteroidData(this, bl2, fArray3, n16, n17, n20, n21, n24, n6, n, n2, n3);
        ChunkProviderKuiper.\uc0af("\ub62b", this.largeAsteroids, (Object)chunkProviderKuiper$AsteroidData);
        this.largeAsteroidsLastChunkX = n4;
        this.largeAsteroidsLastChunkZ = n5;
        if (bl) {
            return;
        }
        for (n15 = 0; n15 < n23; ++n15) {
            int n25 = n15 * n24;
            float f7 = (float)n15 + f4;
            for (n14 = 0; n14 < n24; ++n14) {
                fArray[n25 + n14] = this.asteroidSkewX.getNoise(f7, (float)n14 + f5);
            }
        }
        for (n15 = 0; n15 < n22; ++n15) {
            int n26 = n15 * n23;
            float f8 = (float)n15 + f3;
            for (n14 = 0; n14 < n23; ++n14) {
                fArray2[n26 + n14] = this.asteroidSkewZ.getNoise(f8, (float)n14 + f4);
            }
        }
        double d = 0.0;
        int n27 = 0;
        n14 = 0;
        if (specialAsteroidBlock2 != null) {
            d = 1.0 - specialAsteroidBlock2.thickness;
        }
        for (n13 = n20 - 1; n13 >= n16; --n13) {
            n12 = (n13 - n16) * n23 - n18;
            n11 = (n13 - n16) * n24 - n17;
            n10 = n - (n13 + n4);
            n9 = n13 * 256 << 4;
            float f9 = n13 + n4;
            for (int i = n17; i < n21; ++i) {
                if (bl2) {
                    f2 = fArray3[n11 + i];
                    n27 = this.getTerrainHeightFor(f2, n2, n6);
                    n14 = this.getTerrainHeightFor(f2, n2 - 1, n6);
                }
                f2 = (float)n6 + fArray3[n11 + i];
                f2 *= f2;
                n8 = n3 - (i + n5);
                n7 = n9 | i * 256;
                float f10 = i + n5;
                for (int j = n18; j < n19; ++j) {
                    int n28;
                    float f11;
                    f = (float)n10 / ((float)n6 + fArray[(j - n18) * n24 + i - n17]);
                    float f12 = (float)n8 / ((float)n6 + fArray2[n12 + j]);
                    f *= f;
                    f12 *= f12;
                    int n29 = n2 - j;
                    n29 *= n29;
                    float f13 = f11 = f + (float)n29 / f2 + f12;
                    f11 += this.asteroidTurbulance.getNoise(f9, (float)j, f10);
                    if (bl2 && f11 <= var14_14 && (f13 += this.asteroidTurbulance.getNoise(f9, (float)(j + 1), f10)) <= 1.0f && j - 1 == n14) {
                        n28 = n7 | j + 1;
                        blockArray[n28] = this.LIGHT;
                        ((Object)((Object)this)).getClass();
                        byArray[n28] = 0;
                    }
                    if (!(f11 <= 1.0f)) continue;
                    n28 = n7 | j;
                    if (bl2 && f11 <= var14_14) {
                        if (j == n27) {
                            blockArray[n28] = this.GRASS;
                            ((Object)((Object)this)).getClass();
                            byArray[n28] = 0;
                            continue;
                        }
                        if (j < n27) {
                            blockArray[n28] = this.DIRT;
                            ((Object)((Object)this)).getClass();
                            byArray[n28] = 0;
                            continue;
                        }
                        blockArray[n28] = Blocks.field_150350_a;
                        byArray[n28] = 0;
                        continue;
                    }
                    if ((double)f11 <= specialAsteroidBlock.thickness) {
                        if (ChunkProviderKuiper.\u0d91("\u5d50", (Random)random) != false) {
                            blockArray[n28] = specialAsteroidBlock.block;
                            byArray[n28] = specialAsteroidBlock.meta;
                            continue;
                        }
                        blockArray[n28] = this.ASTEROID_STONE;
                        ((Object)((Object)this)).getClass();
                        byArray[n28] = 0;
                        continue;
                    }
                    if (specialAsteroidBlock2 != null && (double)f11 >= d) {
                        blockArray[n28] = specialAsteroidBlock2.block;
                        byArray[n28] = specialAsteroidBlock2.meta;
                        continue;
                    }
                    blockArray[n28] = this.ASTEROID_ICE;
                    ((Object)((Object)this)).getClass();
                    byArray[n28] = 1;
                }
            }
        }
        if (bl2) {
            d = 0.0;
            if (specialAsteroidBlock2 != null) {
                d = 1.0 - specialAsteroidBlock2.thickness;
            }
            for (n13 = n16; n13 < n20; ++n13) {
                n12 = (n13 - n16) * n23 - n18;
                n11 = (n13 - n16) * n24 - n17;
                n10 = n - (n13 + n4);
                n10 *= n10;
                n9 = n13 * 256 << 4;
                for (int i = n17; i < n21; ++i) {
                    float f14 = fArray3[n11 + i];
                    f2 = (float)n6 + fArray3[n11 + i];
                    f2 *= f2;
                    n8 = n3 - (i + n5);
                    n8 *= n8;
                    n7 = n9 | i * 256;
                    for (int j = n18; j < n19; ++j) {
                        float f15 = (float)n6 + fArray[(j - n18) * n24 + i - n17];
                        f = (float)n6 + fArray2[n12 + j];
                        f15 *= f15;
                        f *= f;
                        int n30 = n2 - j;
                        n30 *= n30;
                        float f16 = (float)n10 / f15 + (float)n30 / f2 + (float)n8 / f;
                        if (!((f16 += this.asteroidTurbulance.getNoise((float)(n13 + n4), (float)j, (float)(i + n5))) <= 1.0f)) continue;
                        int n31 = n7 | j;
                        int n32 = n7 | j + 1;
                        if (Blocks.field_150350_a != blockArray[n32] || blockArray[n31] != this.ASTEROID_STONE && blockArray[n31] != this.GRASS || ChunkProviderKuiper.\u8273("\ubefd", (Random)this.rand, (int)20) != false) continue;
                        blockArray[n31] = this.LIGHT;
                        ((Object)((Object)this)).getClass();
                        byArray[n31] = 0;
                    }
                }
            }
        }
    }

    private final void setOtherAxisFrequency(float f) {
        this.asteroidSkewX.frequencyY = f;
        this.asteroidSkewX.frequencyZ = f;
        this.asteroidSkewY.frequencyX = f;
        this.asteroidSkewY.frequencyZ = f;
        this.asteroidSkewZ.frequencyX = f;
        this.asteroidSkewZ.frequencyY = f;
    }

    private final int clamp(int n, int n2, int n3) {
        if (n < n2) {
            n = n2;
        } else if (n > n3) {
            n = n3;
        }
        return n;
    }

    private final double clamp(double d, double d2, double d3) {
        if (d < d2) {
            d = d2;
        } else if (d > d3) {
            d = d3;
        }
        return d;
    }

    private final int getTerrainHeightFor(float f, int n, int n2) {
        return (int)((float)(n - n2 / 4) + f * 1.5f);
    }

    private final int getTerrainHeightAt(int n, int n2, float[] fArray, int n3, int n4, int n5, int n6, int n7) {
        int n8 = (n - n3) * n5 - n4;
        if (n8 < fArray.length && n8 >= 0) {
            float f = fArray[n8];
            return this.getTerrainHeightFor(f, n6, n7);
        }
        return 1;
    }

    public Chunk func_73154_d(int n, int n2) {
        ChunkProviderKuiper.\u9dd1("\u8de5", (Random)this.rand, (long)((long)n * 341873128712L + (long)n2 * 132897987541L));
        Block[] blockArray = new Block[65536];
        byte[] byArray = new byte[65536];
        this.generateTerrain(n, n2, blockArray, byArray, false);
        ChunkProviderKuiper.\u4a69("\u16e5", (MapGenSpaceship)this.spaceship, (IChunkProvider)this, (World)this.worldObj, (int)n, (int)n2, (Block[])blockArray, (byte[])byArray);
        Chunk chunk = new Chunk(this.worldObj, blockArray, byArray, n, n2);
        byte[] byArray2 = chunk.func_76605_m();
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = (byte)GSBiomeGenBase.GSSpace.field_76756_M;
        }
        this.generateSkylightMap(chunk, n, n2);
        return chunk;
    }

    private int getIndex(int n, int n2, int n3) {
        return n * 256 * 16 | n3 * 256 | n2;
    }

    private String timeString(long l, long l2) {
        int n = (int)((l2 - l) / 10000L);
        int n2 = n % 100;
        Object object = ChunkProviderKuiper.\u8ca5("\ube9e", (StringBuilder)ChunkProviderKuiper.\u6c9b("\ub0af", (StringBuilder)ChunkProviderKuiper.\u76ce("\u65b2", (StringBuilder)new StringBuilder(), (String)(n < 10 ? ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u5827") : "")), (int)n));
        return ChunkProviderKuiper.\u8ca5("\ube9e", (StringBuilder)ChunkProviderKuiper.\u76ce("\u65b2", (StringBuilder)ChunkProviderKuiper.\u76ce("\u65b2", (StringBuilder)ChunkProviderKuiper.\u76ce("\u65b2", (StringBuilder)ChunkProviderKuiper.\u6c9b("\ub0af", (StringBuilder)ChunkProviderKuiper.\u76ce("\u65b2", (StringBuilder)new StringBuilder(), (String)""), (int)(n / 100)), (String)ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u5839")), (String)object), (String)ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u587a\u6352")));
    }

    private float randFromPoint(int n, int n2, int n3) {
        int n4 = n + n3 * 57 + n2 * 571;
        n4 ^= n4 << 13;
        n4 = n4 * (n4 * n4 * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE;
        return 1.0f - (float)n4 / 1.0737418E9f;
    }

    private float randFromPoint(int n, int n2) {
        int n3 = n + n2 * 57;
        n3 ^= n3 << 13;
        n3 = n3 * (n3 * n3 * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE;
        return 1.0f - (float)n3 / 1.0737418E9f;
    }

    private float randFromPointPos(int n, int n2) {
        int n3 = n + n2 * 57;
        n3 ^= n3 << 13;
        n3 = n3 * (n3 * n3 * 15731 + 789221) + 1376312589 & 0x3FFFFFFF;
        return 1.0f - (float)n3 / 1.0737418E9f;
    }

    public boolean func_73149_a(int n, int n2) {
        return true;
    }

    public void func_73153_a(IChunkProvider iChunkProvider, int n, int n2) {
        int n3;
        Object object;
        int n4;
        int n5;
        Object object2;
        int n6;
        int n7;
        reference var8_7;
        reference var6_6;
        int n8;
        int n9;
        block24: {
            n9 = n << 4;
            n8 = n2 << 4;
            if (ChunkProviderKuiper.\u9c71("\u86d0", chunksDone, (Object)new BlockVec3(n9, 0, n8)) == false) {
                return;
            }
            BlockFalling.field_149832_M = true;
            this.worldObj.func_72807_a(n9 + 16, n8 + 16);
            BlockFalling.field_149832_M = false;
            ChunkProviderKuiper.\u9dd1("\u8de5", (Random)this.rand, (long)this.worldObj.func_72905_C());
            var6_6 = ChunkProviderKuiper.\u6bbc("\ud19a", (Random)this.rand) / 2L * 2L + 1L;
            var8_7 = ChunkProviderKuiper.\u6bbc("\ud19a", (Random)this.rand) / 2L * 2L + 1L;
            ChunkProviderKuiper.\u9dd1("\u8de5", (Random)this.rand, (long)((long)n * var6_6 + (long)n2 * var8_7 ^ this.worldObj.func_72905_C()));
            if (ChunkProviderKuiper.\u0d91("\u5d50", (Random)this.rand) == false) break block24;
            double d = (double)this.asteroidDensity.getNoise((float)(n * 16), (float)(n2 * 16)) * 0.54;
            double d2 = this.clamp(this.randFromPoint(n, n2), 0.4, 1.0) * 200.0 * d + 50.0;
            Object object3 = ChunkProviderKuiper.\u8273("\ubefd", (Random)this.rand, (int)2);
            n7 = 160;
            n6 = 0;
            while ((double)n6 < d2) {
                block25: {
                    Block block;
                    int n10;
                    block27: {
                        block28: {
                            block26: {
                                object2 = ChunkProviderKuiper.\u8273("\ubefd", (Random)this.rand, (int)n7) + 48;
                                if (object3 != object2 / 16 % 2) break block25;
                                n10 = n9 + ChunkProviderKuiper.\u8273("\ubefd", (Random)this.rand, (int)16);
                                n5 = n8 + ChunkProviderKuiper.\u8273("\ubefd", (Random)this.rand, (int)16);
                                block = this.ASTEROID_ICE;
                                ((Object)((Object)this)).getClass();
                                n4 = 1;
                                if (ChunkProviderKuiper.\u8273("\ubefd", (Random)this.rand, (int)400) != false) break block26;
                                n4 = 4;
                                if (!ConfigManagerAsteroids.disableIlmeniteGen) break block27;
                                break block25;
                            }
                            if (ChunkProviderKuiper.\u8273("\ubefd", (Random)this.rand, (int)300) != false) break block28;
                            n4 = 5;
                            if (!ConfigManagerAsteroids.disableIronGen) break block27;
                            break block25;
                        }
                        if (ChunkProviderKuiper.\u8273("\ubefd", (Random)this.rand, (int)250) != false) break block27;
                        n4 = 3;
                        if (ConfigManagerAsteroids.disableAluminumGen) break block25;
                    }
                    this.worldObj.func_147465_d(n10, (int)object2, n5, block, n4, 2);
                    object = 9;
                    if (!(this.worldObj.func_147439_a(n10 - 1, (int)object2, n5) instanceof BlockAir)) {
                        object = true;
                    } else if (!(this.worldObj.func_147439_a(n10 - 2, (int)object2, n5) instanceof BlockAir)) {
                        object = 3;
                    } else if (!(this.worldObj.func_147439_a(n10 - 3, (int)object2, n5) instanceof BlockAir)) {
                        object = 5;
                    } else if (!(this.worldObj.func_147439_a(n10 - 4, (int)object2, n5) instanceof BlockAir)) {
                        object = 7;
                    }
                    this.worldObj.func_72915_b(EnumSkyBlock.Block, n10, (int)(object2 - true), n5, (int)object);
                }
                ++n6;
            }
        }
        if (this.largeAsteroidsLastChunkX != n || this.largeAsteroidsLastChunkZ != n2) {
            this.generateTerrain(n, n2, null, null, true);
        }
        ChunkProviderKuiper.\u9dd1("\u8de5", (Random)this.rand, (long)((long)n * var6_6 + (long)n2 * var8_7 ^ this.worldObj.func_72905_C()));
        if (ChunkProviderKuiper.\u6753("\u6134", this.largeAsteroids) == false) {
            Object object3 = ChunkProviderKuiper.\ub9f2("\u210c", this.largeAsteroids);
            while (object3.hasNext()) {
                ChunkProviderKuiper$AsteroidData chunkProviderKuiper$AsteroidData = (ChunkProviderKuiper$AsteroidData)object3.next();
                if (!chunkProviderKuiper$AsteroidData.isHollow) continue;
                float[] fArray = chunkProviderKuiper$AsteroidData.sizeYArray;
                n3 = chunkProviderKuiper$AsteroidData.xMinArray;
                int n11 = chunkProviderKuiper$AsteroidData.zMinArray;
                int n12 = chunkProviderKuiper$AsteroidData.zSizeArray;
                n4 = chunkProviderKuiper$AsteroidData.asteroidYArray;
                n7 = chunkProviderKuiper$AsteroidData.asteroidSizeArray;
                n6 = 0;
                if (ConfigManagerCore.challengeMode || ChunkProviderKuiper.\u8273("\ubefd", (Random)this.rand, (int)2) == false) {
                    reference var23_34;
                    object2 = ChunkProviderKuiper.\u8273("\ubefd", (Random)this.rand, (int)3);
                    if (object2 == true) {
                        object2 = false;
                    }
                    WorldGenTrees worldGenTrees = new WorldGenTrees(false, 2, 0, 0, false);
                    for (n5 = 0; n5 < 5 && !worldGenTrees.func_76484_a(this.worldObj, this.rand, (int)(object = ChunkProviderKuiper.\u8273("\ubefd", (Random)this.rand, (int)16) + n9 + 8), this.getTerrainHeightAt((int)(object - n9), (int)((var23_34 = ChunkProviderKuiper.\u8273("\ubefd", (Random)this.rand, (int)16) + n8 + 8) - n8), fArray, n3, n11, n12, n4, n7), (int)var23_34); ++n5) {
                    }
                    n6 = 1;
                }
                if (n6 == 0 || ChunkProviderKuiper.\u8273("\ubefd", (Random)this.rand, (int)2) == false) {
                    object2 = ChunkProviderKuiper.\u8273("\ubefd", (Random)this.rand, (int)16) + n9 + 8;
                    reference var20_25 = ChunkProviderKuiper.\u8273("\ubefd", (Random)this.rand, (int)16) + n8 + 8;
                    ((Object)((Object)this)).getClass();
                    new WorldGenTallGrass(this.TALL_GRASS, 1).func_76484_a(this.worldObj, this.rand, (int)object2, this.getTerrainHeightAt((int)(object2 - n9), (int)(var20_25 - n8), fArray, n3, n11, n12, n4, n7), (int)var20_25);
                }
                if (ChunkProviderKuiper.\u8273("\ubefd", (Random)this.rand, (int)2) == false) {
                    object2 = ChunkProviderKuiper.\u8273("\ubefd", (Random)this.rand, (int)16) + n9 + 8;
                    reference var20_26 = ChunkProviderKuiper.\u8273("\ubefd", (Random)this.rand, (int)16) + n8 + 8;
                    new WorldGenFlowers(this.FLOWER).func_76484_a(this.worldObj, this.rand, (int)object2, this.getTerrainHeightAt((int)(object2 - n9), (int)(var20_26 - n8), fArray, n3, n11, n12, n4, n7), (int)var20_26);
                }
                if (ChunkProviderKuiper.\u8273("\ubefd", (Random)this.rand, (int)2) == false) {
                    object2 = ChunkProviderKuiper.\u8273("\ubefd", (Random)this.rand, (int)16) + n9 + 8;
                    reference var20_27 = ChunkProviderKuiper.\u8273("\ubefd", (Random)this.rand, (int)16) + n8 + 8;
                    new WorldGenLakes(this.LAVA).func_76484_a(this.worldObj, this.rand, (int)object2, this.getTerrainHeightAt((int)(object2 - n9), (int)(var20_27 - n8), fArray, n3, n11, n12, n4, n7), (int)var20_27);
                }
                if (ChunkProviderKuiper.\u8273("\ubefd", (Random)this.rand, (int)2) != false) continue;
                object2 = ChunkProviderKuiper.\u8273("\ubefd", (Random)this.rand, (int)16) + n9 + 8;
                reference var20_28 = ChunkProviderKuiper.\u8273("\ubefd", (Random)this.rand, (int)16) + n8 + 8;
                new WorldGenLakes(this.WATER).func_76484_a(this.worldObj, this.rand, (int)object2, this.getTerrainHeightAt((int)(object2 - n9), (int)(var20_28 - n8), fArray, n3, n11, n12, n4, n7), (int)var20_28);
            }
        }
        for (int i = 0; i < 16; ++i) {
            int n13 = n9 + i;
            for (int j = 0; j < 16; ++j) {
                n3 = n8 + j;
                for (int k = 16; k < 240; ++k) {
                    this.worldObj.func_147463_c(EnumSkyBlock.Block, n13, k, n3);
                }
            }
        }
    }

    public void generateSkylightMap(Chunk chunk, int n, int n2) {
        int n3;
        int n4;
        World world = chunk.field_76637_e;
        boolean bl = world.func_72863_F().func_73149_a(n - 1, n2);
        boolean bl2 = world.func_72863_F().func_73149_a(n, n2 + 1);
        boolean bl3 = world.func_72863_F().func_73149_a(n, n2 - 1);
        boolean bl4 = world.func_72863_F().func_73149_a(n - 1, n2 + 1);
        boolean bl5 = world.func_72863_F().func_73149_a(n - 1, n2 - 1);
        for (n4 = 0; n4 < 16; ++n4) {
            if (chunk.func_76587_i()[n4] != null) continue;
            chunk.func_76587_i()[n4] = new ExtendedBlockStorage(n4 << 4, false);
        }
        n4 = chunk.func_76625_h();
        chunk.field_82912_p = Integer.MAX_VALUE;
        for (int i = 0; i < 16; ++i) {
            block2: for (int j = 0; j < 16; ++j) {
                chunk.field_76638_b[i + (j << 4)] = -999;
                for (n3 = n4 + 15; n3 > 0; --n3) {
                    if (chunk.func_150808_b(i, n3 - 1, j) == 0) {
                        continue;
                    }
                    chunk.field_76634_f[j << 4 | i] = n3;
                    if (n3 >= chunk.field_82912_p) continue block2;
                    chunk.field_82912_p = n3;
                    continue block2;
                }
            }
        }
        Object object = ChunkProviderKuiper.\ub9f2("\u210c", this.largeAsteroids);
        while (object.hasNext()) {
            ChunkProviderKuiper$AsteroidData chunkProviderKuiper$AsteroidData = (ChunkProviderKuiper$AsteroidData)object.next();
            n3 = chunkProviderKuiper$AsteroidData.asteroidYArray - chunkProviderKuiper$AsteroidData.asteroidSizeArray;
            int n5 = chunkProviderKuiper$AsteroidData.asteroidYArray + chunkProviderKuiper$AsteroidData.asteroidSizeArray;
            int n6 = chunkProviderKuiper$AsteroidData.xMinArray;
            if (n3 < 0) {
                n3 = 0;
            }
            if (n5 > 255) {
                n5 = 255;
            }
            if (n6 == 0) {
                n6 = 1;
            }
            for (int i = chunkProviderKuiper$AsteroidData.xMax - 1; i >= n6; --i) {
                for (int j = chunkProviderKuiper$AsteroidData.zMinArray; j < chunkProviderKuiper$AsteroidData.zMax; ++j) {
                    for (int k = n3; k < n5; ++k) {
                        if (!(chunk.func_150810_a(i - 1, k, j) instanceof BlockAir) || chunk.func_150810_a(i, k, j) instanceof BlockAir) continue;
                        int n7 = 2;
                        if (i > 1 && chunk.func_150810_a(i - 2, k, j) instanceof BlockAir) {
                            n7 += 2;
                        }
                        if (i > 2) {
                            if (chunk.func_150810_a(i - 3, k, j) instanceof BlockAir) {
                                n7 += 2;
                            }
                            if (chunk.func_150810_a(i - 3, k + 1, j) instanceof BlockAir) {
                                ++n7;
                            }
                            if (chunk.func_150810_a(i - 3, k + 1, j) instanceof BlockAir) {
                                ++n7;
                            }
                            if (j > 0 && chunk.func_150810_a(i - 3, k, j - 1) instanceof BlockAir) {
                                ++n7;
                            }
                            if (j < 15 && chunk.func_150810_a(i - 3, k, j + 1) instanceof BlockAir) {
                                ++n7;
                            }
                        }
                        if (i > 3) {
                            if (chunk.func_150810_a(i - 4, k, j) instanceof BlockAir) {
                                n7 += 2;
                            }
                            if (chunk.func_150810_a(i - 4, k + 1, j) instanceof BlockAir) {
                                ++n7;
                            }
                            if (chunk.func_150810_a(i - 4, k + 1, j) instanceof BlockAir) {
                                ++n7;
                            }
                            if (j > 0 && !(chunk.func_150810_a(i - 4, k, j - 1) instanceof BlockAir)) {
                                ++n7;
                            }
                            if (j < 15 && !(chunk.func_150810_a(i - 4, k, j + 1) instanceof BlockAir)) {
                                ++n7;
                            }
                        }
                        if (n7 > 12) {
                            n7 = 12;
                        }
                        chunk.func_150807_a(i - 1, k & 0xF, j, GCBlocks.brightAir, 13 - n7);
                        ExtendedBlockStorage extendedBlockStorage = chunk.func_76587_i()[k >> 4];
                        if (extendedBlockStorage == null) continue;
                        extendedBlockStorage.func_76677_d(i - 1, k & 0xF, j, n7 + 2);
                    }
                }
            }
        }
        chunk.field_76643_l = true;
    }

    public boolean func_73151_a(boolean bl, IProgressUpdate iProgressUpdate) {
        return true;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return ChunkProviderKuiper$KuiperSaveData.\u41fe("\ue88c\u1e64\ue4f6\ud9d8\u31b0\u4dbf\u34f0\u1671\ub6cf\u4b49\udf13\u98f3\ub820\ufaed\uc4a2\uead2\uc5a4");
    }

    public List func_73155_a(EnumCreatureType enumCreatureType, int n, int n2, int n3) {
        if (enumCreatureType == EnumCreatureType.monster) {
            ArrayList<BiomeGenBase.SpawnListEntry> arrayList = new ArrayList<BiomeGenBase.SpawnListEntry>();
            arrayList.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedZombie.class, 3000, 1, 3));
            arrayList.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedSpider.class, 2000, 1, 2));
            arrayList.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedSkeleton.class, 1500, 1, 1));
            arrayList.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedCreeper.class, 2000, 1, 1));
            arrayList.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedColdBlaze.class, 2000, 1, 1));
            return arrayList;
        }
        return null;
    }

    public BlockVec3 isLargeAsteroidAt(int n, int n2) {
        for (int i = 0; i <= 32; ++i) {
            for (int j = -i; j <= i; ++j) {
                int n3 = (n >> 4) + i;
                int n4 = (n2 >> 4) + j;
                if (this.isLargeAsteroidAt0(n3 * 16, n4 * 16)) {
                    return new BlockVec3(n3 * 16, 0, n4 * 16);
                }
                n3 = (n >> 4) + i;
                n4 = (n2 >> 4) - j;
                if (this.isLargeAsteroidAt0(n3 * 16, n4 * 16)) {
                    return new BlockVec3(n3 * 16, 0, n4 * 16);
                }
                n3 = (n >> 4) - i;
                n4 = (n2 >> 4) + j;
                if (this.isLargeAsteroidAt0(n3 * 16, n4 * 16)) {
                    return new BlockVec3(n3 * 16, 0, n4 * 16);
                }
                n3 = (n >> 4) - i;
                n4 = (n2 >> 4) - j;
                if (!this.isLargeAsteroidAt0(n3 * 16, n4 * 16)) continue;
                return new BlockVec3(n3 * 16, 0, n4 * 16);
            }
        }
        return null;
    }

    private boolean isLargeAsteroidAt0(int n, int n2) {
        for (int i = n; i < n + 16; i += 2) {
            for (int j = n2; j < n2 + 16; j += 2) {
                if (!((double)ChunkProviderKuiper.\u5c3c("\u8656", (float)this.randFromPoint(i, j)) < ((double)this.asteroidDensity.getNoise((float)i, (float)j) + 0.4) / 2400.0)) continue;
                return true;
            }
        }
        return false;
    }

    private static Object \u6753(Object object, String string, MethodType methodType) {
        if (\ub8f3 == null) {
            \ub8f3 = new Object[18];
        }
        if (\ub8f3[2] == null) {
            ChunkProviderKuiper.\ub8f3[2] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u6706\u3c4d\u2898\u5f46\uce5a\u3e74\u1c4c\ub4df\u5230\ud752\u6b8e\u553d\u65b5\uda98\u5fe8\uaf5d\u9933\ue3bc\ucd97")), WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u6705\u3c5f\u28ab\u5f4a\uce04\u3e75\u1c41"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub8f3[2];
    }

    private static Object \u8ca5(Object object, String string, MethodType methodType) {
        if (\ub8f3 == null) {
            \ub8f3 = new Object[18];
        }
        if (\ub8f3[14] == null) {
            ChunkProviderKuiper.\ub8f3[14] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u6706\u3c4d\u2898\u5f46\uce5a\u3e6d\u1c59\ub4d8\u523b\ud752\u6b9c\u553b\u65b5\uda90\u5fff\uaf76\u9918\ue3ba\ucd8a\uaf4b\u69e1\ue5b7\u405f")), WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u6718\u3c43\u28bd\u5f53\uce06\u3e68\u1c56\ub4d1"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub8f3[14];
    }

    private static Object \ua1ce(Object object, String string, MethodType methodType) {
        if (\ub8f3 == null) {
            \ub8f3 = new Object[18];
        }
        if (\ub8f3[15] == null) {
            ChunkProviderKuiper.\ub8f3[15] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u587d\u6340\u9d6c\ubf4b\ub971\ubec2\u7740\u5d1c\ua508\ue4a2\uf70a\u1d51\uea8d\u79e2")), ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u587a\u6340\u9d62"), methodType).asType(methodType));
        }
        return \ub8f3[15];
    }

    private static Object \u6bbc(Object object, String string, MethodType methodType) {
        if (\ub8f3 == null) {
            \ub8f3 = new Object[18];
        }
        if (\ub8f3[12] == null) {
            ChunkProviderKuiper.\ub8f3[12] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u6706\u3c4d\u2898\u5f46\uce5a\u3e74\u1c4c\ub4df\u5230\ud752\u6b9d\u552e\u65a9\uda9d\u5ffe\uaf7c")), WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u6702\u3c49\u2896\u5f53\uce38\u3e6e\u1c56\ub4d1"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub8f3[12];
    }

    private static Object \ua1c5(Object object, String string, MethodType methodType) {
        if (\ub8f3 == null) {
            \ub8f3 = new Object[18];
        }
        if (\ub8f3[9] == null) {
            ChunkProviderKuiper.\ub8f3[9] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u6706\u3c4d\u2898\u5f46\uce5a\u3e74\u1c4c\ub4df\u5230\ud752\u6b9d\u552e\u65a9\uda9d\u5ffe\uaf7c")), WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u6702\u3c49\u2896\u5f53\uce32\u3e6d\u1c57\ub4d7\u5228"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub8f3[9];
    }

    private static Object \u4a69(Object object, String string, MethodType methodType) {
        if (\ub8f3 == null) {
            \ub8f3 = new Object[18];
        }
        if (\ub8f3[1] == null) {
            ChunkProviderKuiper.\ub8f3[1] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u5870\u6340\u9d76\ubf4b\ub927\ubed7\u7752\u5d02\ua50e\ue4ef\uf722\u1d1e\uea9e\u79eb\u0f6c\u71ae\ubd83\u14fd\u1d8f\u5342\u0db3\u592b\u3eae\u48cf\u6a64\uda9a\u9e91\uaf6b\u7bdd\u19a2\ufdea\u2996\u42d4\u10c3\ud1aa\u901c\u56bb\ue2c3\u42c8\u33aa\u2209\u674c\ua92f\u22ba\u7106\ud3bf\u7972\u9d2d\ua7a3\ucc0c\ua6dc\udead\u1833\u2869\u10e3\ua305\u3534\u3c22\ub3c6\ua65f\u810a\ubb4d\ucb1d\u10b1\ufe97\uf411\u3682\u9e48\ub3a9\u0e2c\u642b\u9870\ud330\u8857\ub1a4\ud903\u8bc5\u22a9\u0478\u800e\uaf7f\u9e3b\u5ec5\u183b\u1a86\u2ab0")), ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u5870\u6344\u9d74\ubf4f\ub92d\ubecf\u7755\u5d17"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub8f3[1];
    }

    private static Object \ub9f2(Object object, String string, MethodType methodType) {
        if (\ub8f3 == null) {
            \ub8f3 = new Object[18];
        }
        if (\ub8f3[5] == null) {
            ChunkProviderKuiper.\ub8f3[5] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u6706\u3c4d\u2898\u5f46\uce5a\u3e74\u1c4c\ub4df\u5230\ud752\u6b8e\u553d\u65b5\uda98\u5fe8\uaf5d\u9933\ue3bc\ucd97")), WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u6705\u3c58\u288b\u5f55\uce15\u3e75\u1c57\ub4c4"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub8f3[5];
    }

    private static Object \u9dd1(Object object, String string, MethodType methodType) {
        if (\ub8f3 == null) {
            \ub8f3 = new Object[18];
        }
        if (\ub8f3[16] == null) {
            ChunkProviderKuiper.\ub8f3[16] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(ChunkProviderKuiper$KuiperSaveData.\u41fe("\ue8b4\u1e64\ue4ee\ud9dd\u31f1\u4da7\u34c8\u167d\ub6d5\u4b02\udf2d\u98c1\ub821\ufafc\uc4bf\ueadc")), ChunkProviderKuiper$KuiperSaveData.\u41fe("\ue8ad\u1e60\ue4ec\ud9ef\u31ba\u4db7\u34d8"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub8f3[16];
    }

    private static Object \u8273(Object object, String string, MethodType methodType) {
        if (\ub8f3 == null) {
            \ub8f3 = new Object[18];
        }
        if (\ub8f3[17] == null) {
            ChunkProviderKuiper.\ub8f3[17] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(ChunkProviderKuiper$KuiperSaveData.\u41fe("\ue8b4\u1e64\ue4ee\ud9dd\u31f1\u4da7\u34c8\u167d\ub6d5\u4b02\udf2d\u98c1\ub821\ufafc\uc4bf\ueadc")), ChunkProviderKuiper$KuiperSaveData.\u41fe("\ue8b0\u1e60\ue4e0\ud9c8\u3196\u4dbc\u34c8"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub8f3[17];
    }

    private static Object \u76ce(Object object, String string, MethodType methodType) {
        if (\ub8f3 == null) {
            \ub8f3 = new Object[18];
        }
        if (\ub8f3[7] == null) {
            ChunkProviderKuiper.\ub8f3[7] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(ChunkProviderKuiper$KuiperSaveData.\u41fe("\ue8b4\u1e64\ue4ee\ud9dd\u31f1\u4dbe\u34dd\u167a\ub6de\u4b02\udf2c\u98d4\ub83d\ufaf1\uc4be\uead6\uc583\u228e\u3de8\u4b48\u9496\u8b15\u6e14")), ChunkProviderKuiper$KuiperSaveData.\u41fe("\ue8bf\u1e75\ue4e8\ud9d9\u31b1\u4db6"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub8f3[7];
    }

    private static Object \u0d91(Object object, String string, MethodType methodType) {
        if (\ub8f3 == null) {
            \ub8f3 = new Object[18];
        }
        if (\ub8f3[4] == null) {
            ChunkProviderKuiper.\ub8f3[4] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u587d\u6340\u9d6c\ubf4b\ub971\ubedb\u7755\u5d1b\ua503\ue4a2\uf715\u1d51\uea97\u79ee\u0f6f\u71a2")), ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u5879\u6344\u9d62\ubf5e\ub91d\ubec1\u774e\u5d1e\ua50a\ue4ed\uf729"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub8f3[4];
    }

    private static Object \u5d13(Object object, String string, MethodType methodType) {
        if (\ub8f3 == null) {
            \ub8f3 = new Object[18];
        }
        if (\ub8f3[6] == null) {
            ChunkProviderKuiper.\ub8f3[6] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u6706\u3c4d\u2898\u5f46\uce5a\u3e74\u1c4c\ub4df\u5230\ud752\u6b8e\u553d\u65b5\uda98\u5fe8\uaf5d\u9933\ue3bc\ucd97")), WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u670f\u3c40\u288b\u5f46\uce06"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub8f3[6];
    }

    private static Object \u8332(Object object, String string, MethodType methodType) {
        if (\ub8f3 == null) {
            \ub8f3 = new Object[18];
        }
        if (\ub8f3[11] == null) {
            ChunkProviderKuiper.\ub8f3[11] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(WorldChunkManagerKuiper$WorldProviderKuiper$AsteroidData.\uf99e("\ufeee\ue031\u710b\uadfa\u92d2\u49c7\u5437\u7b8d\ued48\u70be\u12c9\u773f\u567e\ua9ef\u8307\u5b44\u1dbb\uf0d7\u8063\u0481\uf339\u996d\u6f4f\u29c0\u4e54\u13c7\u5a5f\u28e8\u639a\u117a\u233d\u5e45\ucfde\udc48\u1f37\u990b\u4350\u0468\ufa28\u3da8\u3e70\ub8c5\u5b6e\u3ad8\uc06c\ud495\ub0cb\ub3d6\uc5fa\uf776\u8b2a\uf2b0\u7ab0\ubd62\ufd4d\u17d7\u59a8\u7458\u0411\uef65\u7b09\ubd0c\u15a7\ubf00\u12f5\uf239\uc608\u838f\udf5a\u5977\ub2de\ud823\u7060\ud47c\uf332\ufc2f\udb7d\u1af7\uf15a\u6128\u20cd\u7344\ucf44\ude83\ua4eb\u4150\ufe04\u76c1\ub531\uc323")), WorldChunkManagerKuiper$WorldProviderKuiper$AsteroidData.\uf99e("\ufee8\ue034\u7103\uadda\u92d9\u49ca\u5421\u7b8f\ued46\u70b4\u12c8"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub8f3[11];
    }

    private static Object \uc0af(Object object, String string, MethodType methodType) {
        if (\ub8f3 == null) {
            \ub8f3 = new Object[18];
        }
        if (\ub8f3[10] == null) {
            ChunkProviderKuiper.\ub8f3[10] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(ChunkProviderKuiper$KuiperSaveData.\u41fe("\ue8b4\u1e64\ue4ee\ud9dd\u31f1\u4da7\u34c8\u167d\ub6d5\u4b02\udf3e\u98d2\ub83d\ufaf9\uc4a9\ueafd\uc5a8\u2288\u3df5")), ChunkProviderKuiper$KuiperSaveData.\u41fe("\ue8bf\u1e61\ue4fc"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub8f3[10];
    }

    private static Object \u6c9b(Object object, String string, MethodType methodType) {
        if (\ub8f3 == null) {
            \ub8f3 = new Object[18];
        }
        if (\ub8f3[0] == null) {
            ChunkProviderKuiper.\ub8f3[0] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u587d\u6340\u9d6c\ubf4b\ub971\ubec2\u7740\u5d1c\ua508\ue4a2\uf714\u1d44\uea8b\u79e3\u0f6e\u71a8\ubdb9\u14e1\u1d83\u535d\u0df9\u5923\u3eb5")), ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u5876\u6351\u9d6a\ubf4f\ub931\ubeca"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub8f3[0];
    }

    private static Object \u5c3c(Object object, String string, MethodType methodType) {
        if (\ub8f3 == null) {
            \ub8f3 = new Object[18];
        }
        if (\ub8f3[8] == null) {
            ChunkProviderKuiper.\ub8f3[8] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(WorldChunkManagerKuiper$WorldProviderKuiper$AsteroidData.\uf99e("\ufee3\ue031\u7111\uadfa\u9284\u49d2\u5425\u7b93\ued4e\u70f3\u12e1\u7770\u566d\ua9e6")), WorldChunkManagerKuiper$WorldProviderKuiper$AsteroidData.\uf99e("\ufee8\ue032\u7114"), methodType).asType(methodType));
        }
        return \ub8f3[8];
    }

    private static Object \ubba7(Object object, String string, MethodType methodType) {
        if (\ub8f3 == null) {
            \ub8f3 = new Object[18];
        }
        if (\ub8f3[3] == null) {
            ChunkProviderKuiper.\ub8f3[3] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u587d\u6340\u9d6c\ubf4b\ub971\ubec2\u7740\u5d1c\ua508\ue4a2\uf70a\u1d51\uea8d\u79e2")), ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u587a\u6348\u9d74"), methodType).asType(methodType));
        }
        return \ub8f3[3];
    }

    private static Object \u9c71(Object object, String string, MethodType methodType) {
        if (\ub8f3 == null) {
            \ub8f3 = new Object[18];
        }
        if (\ub8f3[13] == null) {
            ChunkProviderKuiper.\ub8f3[13] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u587d\u6340\u9d6c\ubf4b\ub971\ubedb\u7755\u5d1b\ua503\ue4a2\uf70f\u1d51\uea8a\u79e2\u0f53\u71aa\ubd8f")), ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u5876\u6345\u9d7e"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub8f3[13];
    }
}

