/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.galaxies.milkyway.SolarSystem.planets.kuiperbelt.dimension;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import galaxyspace.api.dimension.IAdvancedSpace;
import galaxyspace.core.world.gen.WorldProviderAdvancedSpace;
import galaxyspace.galaxies.milkyway.SolarSystem.SolarSystemBodies;
import galaxyspace.galaxies.milkyway.SolarSystem.planets.kuiperbelt.dimension.ChunkProviderKuiper;
import galaxyspace.galaxies.milkyway.SolarSystem.planets.kuiperbelt.dimension.ChunkProviderKuiper$KuiperSaveData;
import galaxyspace.galaxies.milkyway.SolarSystem.planets.kuiperbelt.dimension.ChunkProviderKuiper$WorldProviderKuiper;
import galaxyspace.galaxies.milkyway.SolarSystem.planets.kuiperbelt.dimension.KuiperSaveData;
import galaxyspace.galaxies.milkyway.SolarSystem.planets.kuiperbelt.dimension.WorldChunkManagerKuiper;
import galaxyspace.galaxies.milkyway.SolarSystem.planets.kuiperbelt.dimension.WorldChunkManagerKuiper$WorldProviderKuiper;
import galaxyspace.galaxies.milkyway.SolarSystem.planets.kuiperbelt.dimension.WorldChunkManagerKuiper$WorldProviderKuiper$AsteroidData;
import galaxyspace.galaxies.milkyway.SolarSystem.planets.kuiperbelt.dimension.WorldProviderKuiper$AsteroidData;
import galaxyspace.galaxies.milkyway.SolarSystem.planets.kuiperbelt.dimension.sky.SkyProviderKuiper;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeMap;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.api.world.IZeroGDimension;
import micdoodle8.mods.galacticraft.core.client.CloudRenderer;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.event.EventHandlerGC;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityEntryPod;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.client.IRenderHandler;

public class WorldProviderKuiper
extends WorldProviderAdvancedSpace
implements IZeroGDimension,
ISolarLevel,
ITeleportType,
IAdvancedSpace {
    private HashSet<WorldProviderKuiper$AsteroidData> asteroids = new HashSet();
    private boolean dataNotLoaded = true;
    private KuiperSaveData datafile;
    private double solarMultiplier = -1.0;
    public boolean doSpinning = true;
    private int pjumpticks = 0;
    private float angularVelocityRadians = 0.0f;
    private float skyAngularVelocity = (float)((double)(this.angularVelocityRadians * 180.0f) / Math.PI);
    private float angularVelocityTarget = 0.0f;
    private float angularVelocityAccel = 0.0f;
    private double spinCentreX;
    private double spinCentreZ;
    private double pPrevMotionX = 0.0;
    private double pPrevMotionY = 0.0;
    private double pPrevMotionZ = 0.0;
    private boolean pWasOnGround = false;
    private int ssBoundsMaxX;
    private int ssBoundsMinX;
    private int ssBoundsMaxY;
    private int ssBoundsMinY;
    private int ssBoundsMaxZ;
    private int ssBoundsMinZ;
    private static volatile transient Object[] \ub32e;

    public CelestialBody getCelestialBody() {
        return SolarSystemBodies.planetKuiperBelt;
    }

    public Vector3 getFogColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public Vector3 getSkyColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public boolean canRainOrSnow() {
        return false;
    }

    public boolean hasSunset() {
        return false;
    }

    public boolean isDaytime() {
        return true;
    }

    public Class<? extends IChunkProvider> getChunkProviderClass() {
        return ChunkProviderKuiper.class;
    }

    public Class<? extends WorldChunkManager> getWorldChunkManagerClass() {
        return WorldChunkManagerKuiper.class;
    }

    public boolean shouldForceRespawn() {
        return !ConfigManagerCore.forceOverworldRespawn;
    }

    public float func_76563_a(long l, float f) {
        return 0.24f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float f) {
        return 1.0f;
    }

    public double getHorizon() {
        return 44.0;
    }

    public int func_76557_i() {
        return 96;
    }

    public boolean func_76566_a(int n, int n2) {
        return true;
    }

    public boolean func_76569_d() {
        return this.field_76579_a == null ? false : this.field_76579_a.field_72995_K;
    }

    public boolean func_76567_e() {
        if (EventHandlerGC.bedActivated) {
            EventHandlerGC.bedActivated = false;
            return true;
        }
        return false;
    }

    public int getRespawnDimension(EntityPlayerMP entityPlayerMP) {
        return this.shouldForceRespawn() ? this.field_76574_g : 0;
    }

    public double getMeteorFrequency() {
        return 10.0;
    }

    public double getFuelUsageMultiplier() {
        return 0.9;
    }

    public float getFallDamageModifier() {
        return 0.1f;
    }

    public float getSoundVolReductionAmount() {
        return 10.0f;
    }

    public void addAsteroid(int n, int n2, int n3, int n4, int n5) {
        WorldProviderKuiper$AsteroidData worldProviderKuiper$AsteroidData = new WorldProviderKuiper$AsteroidData(n, n2, n3, n4, n5);
        if (WorldProviderKuiper.\u49c8("\u7bc1", this.asteroids, (Object)worldProviderKuiper$AsteroidData) == false) {
            if (this.dataNotLoaded) {
                this.loadAsteroidSavedData();
            }
            if (WorldProviderKuiper.\u49c8("\u7bc1", this.asteroids, (Object)worldProviderKuiper$AsteroidData) == false) {
                this.addToNBT(this.datafile.datacompound, worldProviderKuiper$AsteroidData);
                WorldProviderKuiper.\uc2cb("\u4ff5", this.asteroids, (Object)worldProviderKuiper$AsteroidData);
            }
        }
    }

    public void removeAsteroid(int n, int n2, int n3) {
        WorldProviderKuiper$AsteroidData worldProviderKuiper$AsteroidData = new WorldProviderKuiper$AsteroidData(n, n2, n3);
        if (WorldProviderKuiper.\u49c8("\u7bc1", this.asteroids, (Object)worldProviderKuiper$AsteroidData) != false) {
            WorldProviderKuiper.\u707c("\u6575", this.asteroids, (Object)worldProviderKuiper$AsteroidData);
            if (this.dataNotLoaded) {
                this.loadAsteroidSavedData();
            }
            this.writeToNBT(this.datafile.datacompound);
        }
    }

    private void loadAsteroidSavedData() {
        this.datafile = (KuiperSaveData)this.field_76579_a.func_72943_a(KuiperSaveData.class, WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u672b\u3c7f\u28a5\u5f52\uce1d\u3e71\u1c5d\ub4c4\u5218\ud71d\u6bbb\u552e"));
        if (this.datafile == null) {
            this.datafile = new KuiperSaveData("");
            this.field_76579_a.func_72823_a(WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u672b\u3c7f\u28a5\u5f52\uce1d\u3e71\u1c5d\ub4c4\u5218\ud71d\u6bbb\u552e"), (WorldSavedData)this.datafile);
            this.writeToNBT(this.datafile.datacompound);
        } else {
            this.readFromNBT(this.datafile.datacompound);
        }
        this.dataNotLoaded = false;
    }

    private void readFromNBT(NBTTagCompound nBTTagCompound) {
        NBTTagList nBTTagList = nBTTagCompound.func_150295_c(WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u670f\u3c43\u2881\u5f55\uce10\u3e72"), 10);
        if (nBTTagList.func_74745_c() > 0) {
            for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
                NBTTagCompound nBTTagCompound2 = nBTTagList.func_150305_b(i);
                if (nBTTagCompound2 == null) continue;
                WorldProviderKuiper.\uc2cb("\u4ff5", this.asteroids, (Object)WorldProviderKuiper.\u3e6e("\u3175", (NBTTagCompound)nBTTagCompound2));
            }
        }
    }

    private void writeToNBT(NBTTagCompound nBTTagCompound) {
        NBTTagList nBTTagList = new NBTTagList();
        Object object = WorldProviderKuiper.\u892c("\u1782", this.asteroids);
        while (object.hasNext()) {
            WorldProviderKuiper$AsteroidData worldProviderKuiper$AsteroidData = (WorldProviderKuiper$AsteroidData)object.next();
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            WorldProviderKuiper.\u6d5d("\ub447", (WorldProviderKuiper$AsteroidData)worldProviderKuiper$AsteroidData, (NBTTagCompound)nBTTagCompound2);
            nBTTagList.func_74742_a((NBTBase)nBTTagCompound2);
        }
        nBTTagCompound.func_74782_a(ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u5874\u634e\u9d75\ubf58\ub93b\ubedd"), (NBTBase)nBTTagList);
        WorldProviderKuiper.\u953f("\u9ef4", (KuiperSaveData)this.datafile);
    }

    private void addToNBT(NBTTagCompound nBTTagCompound, WorldProviderKuiper$AsteroidData worldProviderKuiper$AsteroidData) {
        NBTTagList nBTTagList = nBTTagCompound.func_150295_c(WorldChunkManagerKuiper$WorldProviderKuiper$AsteroidData.\uf99e("\ufeea\ue03f\u7108\uade9\u92ce\u49cd"), 10);
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        WorldProviderKuiper.\u6d5d("\ub447", (WorldProviderKuiper$AsteroidData)worldProviderKuiper$AsteroidData, (NBTTagCompound)nBTTagCompound2);
        nBTTagList.func_74742_a((NBTBase)nBTTagCompound2);
        nBTTagCompound.func_74782_a(WorldChunkManagerKuiper$WorldProviderKuiper$AsteroidData.\uf99e("\ufeea\ue03f\u7108\uade9\u92ce\u49cd"), (NBTBase)nBTTagList);
        WorldProviderKuiper.\u953f("\u9ef4", (KuiperSaveData)this.datafile);
    }

    public BlockVec3 getClosestAsteroidXZ(int n, int n2, int n3) {
        if (this.dataNotLoaded) {
            this.loadAsteroidSavedData();
        }
        if (WorldProviderKuiper.\ud168("\u9791", this.asteroids) == false) {
            return null;
        }
        BlockVec3 blockVec3 = null;
        WorldProviderKuiper$AsteroidData worldProviderKuiper$AsteroidData = null;
        int n4 = Integer.MAX_VALUE;
        Object object = WorldProviderKuiper.\u892c("\u1782", this.asteroids);
        while (object.hasNext()) {
            int n5;
            int n6;
            int n7;
            WorldProviderKuiper$AsteroidData worldProviderKuiper$AsteroidData2 = (WorldProviderKuiper$AsteroidData)object.next();
            if ((worldProviderKuiper$AsteroidData2.sizeAndLandedFlag & 0x80) > 0 || (n7 = (n6 = n - worldProviderKuiper$AsteroidData2.centre.x) * n6 + (n5 = n3 - worldProviderKuiper$AsteroidData2.centre.z) * n5) >= n4) continue;
            n4 = n7;
            blockVec3 = worldProviderKuiper$AsteroidData2.centre;
            worldProviderKuiper$AsteroidData = worldProviderKuiper$AsteroidData2;
        }
        if (blockVec3 == null) {
            return null;
        }
        worldProviderKuiper$AsteroidData.sizeAndLandedFlag |= 0x80;
        this.writeToNBT(this.datafile.datacompound);
        return blockVec3.clone();
    }

    public ArrayList<BlockVec3> getClosestAsteroidsXZ(int n, int n2, int n3, int n4, int n5) {
        int n6;
        Object object;
        if (this.dataNotLoaded) {
            this.loadAsteroidSavedData();
        }
        if (WorldProviderKuiper.\ud168("\u9791", this.asteroids) == false) {
            return null;
        }
        TreeMap treeMap = new TreeMap();
        Object object2 = WorldProviderKuiper.\u892c("\u1782", this.asteroids);
        block12: while (object2.hasNext()) {
            int n7;
            int n8;
            object = (WorldProviderKuiper$AsteroidData)object2.next();
            BlockVec3 blockVec3 = ((WorldProviderKuiper$AsteroidData)object).centre;
            switch (n4) {
                case 2: {
                    if (n3 - 16 >= blockVec3.z) break;
                    continue block12;
                }
                case 3: {
                    if (n3 + 16 <= blockVec3.z) break;
                    continue block12;
                }
                case 4: {
                    if (n - 16 >= blockVec3.x) break;
                    continue block12;
                }
                case 5: {
                    if (n + 16 <= blockVec3.x) break;
                    continue block12;
                }
            }
            if ((n8 = (n6 = n - blockVec3.x) * n6 + (n7 = n3 - blockVec3.z) * n7) >= 262144) continue;
            WorldProviderKuiper.\u3e61("\u9b3c", treeMap, (Object)WorldProviderKuiper.\ucf05("\u59b5", (int)n8), (Object)blockVec3);
        }
        Object object3 = WorldProviderKuiper.\u60a6("\u7829", (int)n5, (int)WorldProviderKuiper.\u1c1d("\u8f1c", treeMap));
        if (object3 <= 0) {
            return null;
        }
        object = new ArrayList();
        int n9 = 0;
        n6 = 6;
        Iterator iterator = WorldProviderKuiper.\u439e("\u3669", treeMap).iterator();
        while (iterator.hasNext()) {
            BlockVec3 blockVec3 = (BlockVec3)iterator.next();
            BlockVec3 blockVec32 = blockVec3.clone();
            GCLog.debug((String)WorldProviderKuiper.\u8d27("\u6b9d", (StringBuilder)WorldProviderKuiper.\ua2ec("\u42f2", (StringBuilder)WorldProviderKuiper.\ua2ec("\u42f2", (StringBuilder)new StringBuilder(), (String)ChunkProviderKuiper$KuiperSaveData.\u41fe("\ue898\u1e6a\ue4ed\ud9d2\u31bb\u4df2\u34d2\u1671\ub6d8\u4b5e\udf1d\u98d9\ub86f\ufaf9\uc4a3\ueac5\uc5a4\u2289\u3dee\u4b4d\u9496\u8b50\u6e07\uf4de\u6b23")), (String)blockVec3.toString())));
            switch (n4) {
                case 2: {
                    blockVec32.z += n6;
                    break;
                }
                case 3: {
                    blockVec32.z -= n6;
                    break;
                }
                case 4: {
                    blockVec32.x += n6;
                    break;
                }
                case 5: {
                    blockVec32.x -= n6;
                }
            }
            WorldProviderKuiper.\ua501("\u7dd7", (ArrayList)object, (Object)blockVec32);
            if (++n9 < n5) continue;
            break;
        }
        return object;
    }

    public int getActualHeight() {
        return 256;
    }

    public void func_76572_b() {
        super.func_76572_b();
        this.field_76576_e = true;
    }

    @Override
    public double getSolarEnergyMultiplier() {
        if (this.solarMultiplier < 0.0) {
            double d = this.getSolarSize();
            this.solarMultiplier = d * d * d * ConfigManagerCore.spaceStationEnergyScalar;
        }
        return this.solarMultiplier;
    }

    public boolean useParachute() {
        return false;
    }

    public Vector3 getPlayerSpawnLocation(WorldServer worldServer, EntityPlayerMP entityPlayerMP) {
        if (entityPlayerMP != null) {
            GCPlayerStats gCPlayerStats = GCPlayerStats.get((EntityPlayerMP)entityPlayerMP);
            int n = MathHelper.func_76128_c((double)gCPlayerStats.coordsTeleportedFromX);
            int n2 = MathHelper.func_76128_c((double)gCPlayerStats.coordsTeleportedFromZ);
            int n3 = 0;
            this.preGenChunks((World)worldServer, n >> 4, n2 >> 4);
            do {
                BlockVec3 blockVec3 = null;
                if (worldServer.field_73011_w instanceof WorldProviderKuiper) {
                    blockVec3 = ((WorldProviderKuiper)worldServer.field_73011_w).getClosestAsteroidXZ(n, 0, n2);
                }
                if (blockVec3 == null) continue;
                if (blockVec3.distanceSquared(new BlockVec3(n, 128, n2)) > 25600) break;
                if (ConfigManagerCore.enableDebug) {
                    GCLog.info((String)WorldProviderKuiper.\u8d27("\u6b9d", (StringBuilder)WorldProviderKuiper.\u3dba("\u904b", (StringBuilder)WorldProviderKuiper.\ua2ec("\u42f2", (StringBuilder)WorldProviderKuiper.\u3dba("\u904b", (StringBuilder)WorldProviderKuiper.\ua2ec("\u42f2", (StringBuilder)WorldProviderKuiper.\u3dba("\u904b", (StringBuilder)WorldProviderKuiper.\ua2ec("\u42f2", (StringBuilder)new StringBuilder(), (String)ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u5843\u6344\u9d69\ubf5e\ub936\ubec0\u7746\u5d52\ua50e\ue4ff\uf733\u1d55\uea8b\u79e5\u0f69\u71ab\ubddb\u14f5\u1d9e\u5311\u0de5")), (int)blockVec3.x), (String)ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u5837\u6358")), (int)blockVec3.y), (String)ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u5837\u635b")), (int)blockVec3.z)));
                }
                this.loadChunksAround(blockVec3.x, blockVec3.z, 2, worldServer.field_73059_b);
                this.loadChunksAround(blockVec3.x, blockVec3.z, -3, worldServer.field_73059_b);
                if (this.goodAsteroidEntry((World)worldServer, blockVec3.x, blockVec3.y, blockVec3.z)) {
                    return new Vector3((double)blockVec3.x, 310.0, (double)blockVec3.z);
                }
                if (this.goodAsteroidEntry((World)worldServer, blockVec3.x + 2, blockVec3.y, blockVec3.z + 2)) {
                    return new Vector3((double)(blockVec3.x + 2), 310.0, (double)(blockVec3.z + 2));
                }
                if (this.goodAsteroidEntry((World)worldServer, blockVec3.x + 2, blockVec3.y, blockVec3.z - 2)) {
                    return new Vector3((double)(blockVec3.x + 2), 310.0, (double)(blockVec3.z - 2));
                }
                if (this.goodAsteroidEntry((World)worldServer, blockVec3.x - 2, blockVec3.y, blockVec3.z - 2)) {
                    return new Vector3((double)(blockVec3.x - 2), 310.0, (double)(blockVec3.z - 2));
                }
                if (this.goodAsteroidEntry((World)worldServer, blockVec3.x - 2, blockVec3.y, blockVec3.z + 2)) {
                    return new Vector3((double)(blockVec3.x - 2), 310.0, (double)(blockVec3.z + 2));
                }
                if (ConfigManagerCore.enableDebug) {
                    GCLog.info((String)WorldProviderKuiper.\u8d27("\u6b9d", (StringBuilder)WorldProviderKuiper.\u3dba("\u904b", (StringBuilder)WorldProviderKuiper.\ua2ec("\u42f2", (StringBuilder)WorldProviderKuiper.\u3dba("\u904b", (StringBuilder)WorldProviderKuiper.\ua2ec("\u42f2", (StringBuilder)new StringBuilder(), (String)ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u5845\u6344\u9d77\ubf45\ub929\ubec7\u774f\u5d15\ua54f\ue4e8\uf735\u1d59\uea95\u79e6\u0f65\u71ab\ubddb\u14fb\u1d9f\u5345\u0dbd\u5927\u3eb4\u48d7\u6a6a\uda91\u9e89\uaf63\u7bc0\u19ac\ufdd8\u298d\u4298\u10da")), (int)blockVec3.x), (String)ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u5837\u635b")), (int)blockVec3.z)));
                }
                ((WorldProviderKuiper)worldServer.field_73011_w).removeAsteroid(blockVec3.x, blockVec3.y, blockVec3.z);
            } while (++n3 < 5);
            FMLLog.info((String)ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u5851\u6340\u9d73\ubf46\ub93a\ubeca\u7701\u5d06\ua500\ue4ac\uf721\u1d59\uea97\u79ee\u0f20\u71a8\ubd94\u14fb\u1d8e\u5311\u0df1\u5927\u3eb5\u48c4\u6a6a\udac3\u9e87\uaf79\u7bd0\u19e9\ufdcb\u2996\u42d1\u10c6\ud1f8\u9023\u56a3\ue2de\u42d8\u33a6\u220a\u6705\ua97f\u22a5\u7117\ud3be\u7963\u9d78\ua7f0\ucc64\ua6d6\udeb4\u1836\u2870\u10e8\ua310\u3576\u3c25\ub3cb\ua648\u814f\ubb1a\ucb06\u10ac\ufedb\uf418\u36cd\u9e44\ub3a5\u0e2c\u6462\u981d\ud330\u8807\ub190\ud90b\u8bca\u2296\u0464\u804f\uaf73\u9e30\u5ed3\u187d"), (Object[])new Object[0]);
            this.makeSmallLandingSpot((World)worldServer, n, n2);
            return new Vector3((double)n, 310.0, (double)n2);
        }
        FMLLog.severe((String)ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u5859\u6354\u9d76\ubf46\ub97f\ubede\u774d\u5d13\ua516\ue4e9\uf735\u1d10\uea8e\u79e2\u0f65\u71a1\ubddb\u14e0\u1d8f\u535d\u0df8\u5936\u3ea8\u48d1\u6a7b\uda8a\u9e88\uaf6d\u7b84\u19f8\ufdd6\u29d9\u42f9\u10d1\ud1ac\u902a\u56b0\ue2df\u42d5\u33ab\u2217\u6743"), (Object[])new Object[0]);
        return new Vector3(0.0, 310.0, 0.0);
    }

    private boolean goodAsteroidEntry(World world, int n, int n2, int n3) {
        for (int i = 208; i > 48; --i) {
            if (world.func_147437_c(n, i, n3) || WorldProviderKuiper.\u6834("\u6aa7", (int)(i - n2)) > 20) continue;
            for (int j = i + 2; j < 256; ++j) {
                if (world.func_147439_a(n, j, n3) == AsteroidBlocks.blockBasic) {
                    world.func_147468_f(n, j, n3);
                }
                if (world.func_147439_a(n - 1, j, n3) == AsteroidBlocks.blockBasic) {
                    world.func_147468_f(n - 1, j, n3);
                }
                if (world.func_147439_a(n, j, n3 - 1) == AsteroidBlocks.blockBasic) {
                    world.func_147468_f(n, j, n3 - 1);
                }
                if (world.func_147439_a(n - 1, j, n3 - 1) != AsteroidBlocks.blockBasic) continue;
                world.func_147468_f(n - 1, j, n3 - 1);
            }
            if (ConfigManagerCore.enableDebug) {
                GCLog.info((String)WorldProviderKuiper.\u8d27("\u6b9d", (StringBuilder)WorldProviderKuiper.\u3dba("\u904b", (StringBuilder)WorldProviderKuiper.\ua2ec("\u42f2", (StringBuilder)WorldProviderKuiper.\u3dba("\u904b", (StringBuilder)WorldProviderKuiper.\ua2ec("\u42f2", (StringBuilder)new StringBuilder(), (String)WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u672a\u3c43\u289b\u5f49\uce10\u3e21\u1c59\ub4c5\u5228\ud719\u6bbd\u5520\u65ae\uda9d\u5fb1\uaf70\u992e\ue3ef\ucd9b")), (int)n), (String)WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u674c\u3c56")), (int)n3)));
            }
            return true;
        }
        return false;
    }

    private void makeSmallLandingSpot(World world, int n, int n2) {
        this.loadChunksAround(n, n2, -1, (ChunkProviderServer)world.func_72863_F());
        for (int i = 255; i > 48; --i) {
            if (!world.func_147437_c(n, i, n2)) {
                this.makePlatform(world, n, i - 1, n2);
                return;
            }
            if (!world.func_147437_c(n - 1, i, n2)) {
                this.makePlatform(world, n - 1, i - 1, n2);
                return;
            }
            if (!world.func_147437_c(n - 1, i, n2 - 1)) {
                this.makePlatform(world, n - 1, i - 1, n2 - 1);
                return;
            }
            if (world.func_147437_c(n, i, n2 - 1)) continue;
            this.makePlatform(world, n, i - 1, n2 - 1);
            return;
        }
        this.makePlatform(world, n, 48 + WorldProviderKuiper.\u64e5("\u3139", (Random)world.field_73012_v, (int)128), n2);
    }

    private void loadChunksAround(int n, int n2, int n3, ChunkProviderServer chunkProviderServer) {
        chunkProviderServer.func_73158_c(n >> 4, n2 >> 4);
        if (n + n3 >> 4 != n >> 4) {
            chunkProviderServer.func_73158_c(n + n3 >> 4, n2 >> 4);
            if (n2 + n3 >> 4 != n2 >> 4) {
                chunkProviderServer.func_73158_c(n >> 4, n2 + n3 >> 4);
                chunkProviderServer.func_73158_c(n + n3 >> 4, n2 + n3 >> 4);
            }
        } else if (n2 + n3 >> 4 != n2 >> 4) {
            chunkProviderServer.func_73158_c(n >> 4, n2 + n3 >> 4);
        }
    }

    private void makePlatform(World world, int n, int n2, int n3) {
        int n4;
        int n5;
        for (n5 = -3; n5 < 3; ++n5) {
            for (n4 = -3; n4 < 3; ++n4) {
                if (n5 == -3 && (n4 == -3 || n4 == 2) || n5 == 2 && (n4 == -3 || n4 == 2)) continue;
                this.doBlock(world, n + n5, n2, n3 + n4);
            }
        }
        for (n5 = -2; n5 < 2; ++n5) {
            for (n4 = -2; n4 < 2; ++n4) {
                this.doBlock(world, n + n5, n2 - 1, n3 + n4);
            }
        }
        this.doBlock(world, n - 1, n2 - 2, n3 - 1);
        this.doBlock(world, n - 1, n2 - 2, n3);
        this.doBlock(world, n, n2 - 2, n3);
        this.doBlock(world, n, n2 - 2, n3 - 1);
    }

    private void doBlock(World world, int n, int n2, int n3) {
        int n4 = (int)(WorldProviderKuiper.\u0684("\u93e2", (Random)world.field_73012_v) * 1.5f);
        if (world.func_147437_c(n, n2, n3)) {
            world.func_147465_d(n, n2, n3, AsteroidBlocks.blockBasic, n4, 2);
        }
    }

    public Vector3 getEntitySpawnLocation(WorldServer worldServer, Entity entity) {
        return new Vector3(entity.field_70165_t, ConfigManagerCore.disableLander ? 250.0 : 900.0, entity.field_70161_v);
    }

    public Vector3 getParaChestSpawnLocation(WorldServer worldServer, EntityPlayerMP entityPlayerMP, Random random) {
        return null;
    }

    private void preGenChunks(World world, int n, int n2) {
        this.preGenChunk(world, n, n2);
        for (int i = 1; i < 3; ++i) {
            int n3 = n - i;
            int n4 = n + i;
            int n5 = n2 - i;
            int n6 = n2 + i;
            for (int j = -i; j < i; ++j) {
                this.preGenChunk(world, n3, n2 + j);
                this.preGenChunk(world, n4, n2 - j);
                this.preGenChunk(world, n - j, n5);
                this.preGenChunk(world, n + j, n6);
            }
        }
    }

    private void preGenChunk(World world, int n, int n2) {
        world.func_72964_e(n, n2);
    }

    public void onSpaceDimensionChanged(World world, EntityPlayerMP entityPlayerMP, boolean bl) {
        if (!bl && entityPlayerMP != null) {
            GCPlayerStats gCPlayerStats = GCPlayerStats.get((EntityPlayerMP)entityPlayerMP);
            if (gCPlayerStats.teleportCooldown <= 0) {
                if (entityPlayerMP.field_71075_bZ.field_75100_b) {
                    entityPlayerMP.field_71075_bZ.field_75100_b = false;
                }
                if (!world.field_72995_K) {
                    EntityEntryPod entityEntryPod = new EntityEntryPod(entityPlayerMP);
                    world.func_72838_d((Entity)entityEntryPod);
                }
                gCPlayerStats.teleportCooldown = 10;
            }
        }
    }

    public void setupAdventureSpawn(EntityPlayerMP entityPlayerMP) {
    }

    @Override
    public double getSolarWindMultiplier() {
        double d = -1.0;
        if (d < 0.0) {
            double d2 = this.getSolarSize();
            d = d2 * d2 * d2 * ConfigManagerCore.spaceStationEnergyScalar;
        }
        if (!this.getSkyColor().isZero()) {
            return 0.0;
        }
        return d;
    }

    public IRenderHandler getCloudRenderer() {
        return new CloudRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        if (super.getSkyRenderer() == null) {
            this.setSkyRenderer(new SkyProviderKuiper());
        }
        return super.getSkyRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float f) {
        float f2 = this.field_76579_a.func_72826_c(1.0f);
        float f3 = 1.25f - (MathHelper.func_76134_b((float)(f2 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        float f4 = this.field_76579_a.func_72820_D();
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        f3 = 1.2f - f3;
        return f3 * 1.0f;
    }

    private static Object \ud168(Object object, String string, MethodType methodType) {
        if (\ub32e == null) {
            \ub32e = new Object[20];
        }
        if (\ub32e[1] == null) {
            WorldProviderKuiper.\ub32e[1] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(WorldChunkManagerKuiper$WorldProviderKuiper$AsteroidData.\uf99e("\ufee3\ue031\u7111\uadfa\u9284\u49cb\u5430\u7b94\ued45\u70f3\u12e4\u7770\u566a\ua9e6\u8338\u5b40\u1db7")), WorldChunkManagerKuiper$WorldProviderKuiper$AsteroidData.\uf99e("\ufefa\ue039\u711d\uadfe"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub32e[1];
    }

    private static Object \u3e61(Object object, String string, MethodType methodType) {
        if (\ub32e == null) {
            \ub32e = new Object[20];
        }
        if (\ub32e[3] == null) {
            WorldProviderKuiper.\ub32e[3] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u6706\u3c4d\u2898\u5f46\uce5a\u3e74\u1c4c\ub4df\u5230\ud752\u6b9b\u553d\u65a2\uda9c\u5fdc\uaf70\u992a")), WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u671c\u3c59\u289a"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub32e[3];
    }

    private static Object \u8d27(Object object, String string, MethodType methodType) {
        if (\ub32e == null) {
            \ub32e = new Object[20];
        }
        if (\ub32e[15] == null) {
            WorldProviderKuiper.\ub32e[15] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(ChunkProviderKuiper$KuiperSaveData.\u41fe("\ue8b4\u1e64\ue4ee\ud9dd\u31f1\u4dbe\u34dd\u167a\ub6de\u4b02\udf2c\u98d4\ub83d\ufaf1\uc4be\uead6\uc583\u228e\u3de8\u4b48\u9496\u8b15\u6e14")), ChunkProviderKuiper$KuiperSaveData.\u41fe("\ue8aa\u1e6a\ue4cb\ud9c8\u31ad\u4dbb\u34d2\u1673"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub32e[15];
    }

    private static Object \u1c1d(Object object, String string, MethodType methodType) {
        if (\ub32e == null) {
            \ub32e = new Object[20];
        }
        if (\ub32e[9] == null) {
            WorldProviderKuiper.\ub32e[9] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u6706\u3c4d\u2898\u5f46\uce5a\u3e74\u1c4c\ub4df\u5230\ud752\u6b9b\u553d\u65a2\uda9c\u5fdc\uaf70\u992a")), WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u671f\u3c45\u2894\u5f42"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub32e[9];
    }

    private static Object \u439e(Object object, String string, MethodType methodType) {
        if (\ub32e == null) {
            \ub32e = new Object[20];
        }
        if (\ub32e[7] == null) {
            WorldProviderKuiper.\ub32e[7] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u6706\u3c4d\u2898\u5f46\uce5a\u3e74\u1c4c\ub4df\u5230\ud752\u6b9b\u553d\u65a2\uda9c\u5fdc\uaf70\u992a")), WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u671a\u3c4d\u2882\u5f52\uce11\u3e72"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub32e[7];
    }

    private static Object \u60a6(Object object, String string, MethodType methodType) {
        if (\ub32e == null) {
            \ub32e = new Object[20];
        }
        if (\ub32e[18] == null) {
            WorldProviderKuiper.\ub32e[18] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u6706\u3c4d\u2898\u5f46\uce5a\u3e6d\u1c59\ub4d8\u523b\ud752\u6b82\u552e\u65b3\uda91")), WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u6701\u3c4d\u2896"), methodType).asType(methodType));
        }
        return \ub32e[18];
    }

    private static Object \u0684(Object object, String string, MethodType methodType) {
        if (\ub32e == null) {
            \ub32e = new Object[20];
        }
        if (\ub32e[13] == null) {
            WorldProviderKuiper.\ub32e[13] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(ChunkProviderKuiper$KuiperSaveData.\u41fe("\ue8b4\u1e64\ue4ee\ud9dd\u31f1\u4da7\u34c8\u167d\ub6d5\u4b02\udf2d\u98c1\ub821\ufafc\uc4bf\ueadc")), ChunkProviderKuiper$KuiperSaveData.\u41fe("\ue8b0\u1e60\ue4e0\ud9c8\u3199\u4dbe\u34d3\u1675\ub6cd"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub32e[13];
    }

    private static Object \u6d5d(Object object, String string, MethodType methodType) {
        if (\ub32e == null) {
            \ub32e = new Object[20];
        }
        if (\ub32e[8] == null) {
            WorldProviderKuiper.\ub32e[8] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(WorldChunkManagerKuiper$WorldProviderKuiper$AsteroidData.\uf99e("\ufeee\ue031\u710b\uadfa\u92d2\u49c7\u5437\u7b8d\ued48\u70be\u12c9\u773f\u567e\ua9ef\u8307\u5b44\u1dbb\uf0d7\u8063\u0481\uf339\u996d\u6f4f\u29c0\u4e54\u13c7\u5a5f\u28e8\u639a\u117a\u233d\u5e45\ucfde\udc48\u1f37\u990b\u4350\u0468\ufa28\u3da8\u3e70\ub8c5\u5b6e\u3ad8\uc06c\ud495\ub0cb\ub3d6\uc5fa\uf776\u8b2a\uf2b0\u7ab0\ubd62\ufd4d\u17d7\u59a8\u7458\u0411\uef65\u7b09\ubd0c\u15a7\ubf00\u12f5\uf239\uc608\u838f\udf5a\u5977\ub2de\ud823\u7060\ud47c\uf332\ufc2f\udb7d\u1af7\uf15a\u6128\u20cd\u7344\ucf44\ude83\ua4eb\u4150\ufe04\u76c1\ub531\uc323\u5cbb\u46fb\u2467\u5235\u5506\uf6fd\u3538\ua896\u8b70\u6b25\u0168\u1519\u46db")), WorldChunkManagerKuiper$WorldProviderKuiper$AsteroidData.\uf99e("\ufefe\ue022\u710e\uadef\u92cf\u49ea\u542b\u7bb3\ued6b\u7089"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub32e[8];
    }

    private static Object \u3e6e(Object object, String string, MethodType methodType) {
        if (\ub32e == null) {
            \ub32e = new Object[20];
        }
        if (\ub32e[16] == null) {
            WorldProviderKuiper.\ub32e[16] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(ChunkProviderKuiper$KuiperSaveData.\u41fe("\ue8b9\u1e64\ue4f4\ud9dd\u31a7\u4dab\u34cf\u1664\ub6d8\u4b4f\udf1a\u988e\ub828\ufaf9\uc4bc\uead0\uc5b9\u2292\u3de4\u4b57\u94dc\u8b1d\u6e0f\uf4c6\u6b68\u356a\ub981\ud88f\u47d3\ub8eb\u5ce4\u69ab\ud026\u311a\u816d\u0e5d\u6c7b\ub5c2\ufcef\ucad6\u1b72\uedee\ub7ea\u7459\u7e7a\u8fb0\u86e8\u068d\u16b6\u47dd\u55df\t\ud68b\u92eb\uf452\u4e97\u93dc\ue54c\ud7c4\u3be3\uead8\u1024\u50ce\ud757\u4a21\ue3c0\u462f\u7935\uaf99\u07bf\u00e2\u2f15\u055e\u3208\ub0e8\ud673\ufe14\ufa2d\u2fce\u5f7f\u9f9f\ua2b7\ua921\u6780\u4393\u4395\u3706\u63a0\u7db2\u32ac\ud8fe\u44f0\ud8c2\ub07b\u682f\uf5ca\udd2e\u9de1\u6218\ude49\u4dee\u4c55\u585f")), ChunkProviderKuiper$KuiperSaveData.\u41fe("\ue8ac\u1e60\ue4f9\ud9d8\u3199\u4da0\u34d3\u1679\ub6f7\u4b6e\udf2b"), methodType).asType(methodType));
        }
        return \ub32e[16];
    }

    private static Object \u6834(Object object, String string, MethodType methodType) {
        if (\ub32e == null) {
            \ub32e = new Object[20];
        }
        if (\ub32e[19] == null) {
            WorldProviderKuiper.\ub32e[19] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u587d\u6340\u9d6c\ubf4b\ub971\ubec2\u7740\u5d1c\ua508\ue4a2\uf70a\u1d51\uea8d\u79e2")), ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u5876\u6343\u9d69"), methodType).asType(methodType));
        }
        return \ub32e[19];
    }

    private static Object \u49c8(Object object, String string, MethodType methodType) {
        if (\ub32e == null) {
            \ub32e = new Object[20];
        }
        if (\ub32e[2] == null) {
            WorldProviderKuiper.\ub32e[2] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(WorldChunkManagerKuiper$WorldProviderKuiper$AsteroidData.\uf99e("\ufee3\ue031\u7111\uadfa\u9284\u49cb\u5430\u7b94\ued45\u70f3\u12e4\u7770\u566a\ua9e6\u8338\u5b40\u1db7")), WorldChunkManagerKuiper$WorldProviderKuiper$AsteroidData.\uf99e("\ufeea\ue03f\u7109\uadef\u92cb\u49d7\u542a\u7b8e"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub32e[2];
    }

    private static Object \u64e5(Object object, String string, MethodType methodType) {
        if (\ub32e == null) {
            \ub32e = new Object[20];
        }
        if (\ub32e[6] == null) {
            WorldProviderKuiper.\ub32e[6] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u587d\u6340\u9d6c\ubf4b\ub971\ubedb\u7755\u5d1b\ua503\ue4a2\uf715\u1d51\uea97\u79ee\u0f6f\u71a2")), ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u5879\u6344\u9d62\ubf5e\ub916\ubec0\u7755"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub32e[6];
    }

    private static Object \ua2ec(Object object, String string, MethodType methodType) {
        if (\ub32e == null) {
            \ub32e = new Object[20];
        }
        if (\ub32e[5] == null) {
            WorldProviderKuiper.\ub32e[5] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(ChunkProviderKuiper$KuiperSaveData.\u41fe("\ue8b4\u1e64\ue4ee\ud9dd\u31f1\u4dbe\u34dd\u167a\ub6de\u4b02\udf2c\u98d4\ub83d\ufaf1\uc4be\uead6\uc583\u228e\u3de8\u4b48\u9496\u8b15\u6e14")), ChunkProviderKuiper$KuiperSaveData.\u41fe("\ue8bf\u1e75\ue4e8\ud9d9\u31b1\u4db6"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub32e[5];
    }

    private static Object \u892c(Object object, String string, MethodType methodType) {
        if (\ub32e == null) {
            \ub32e = new Object[20];
        }
        if (\ub32e[12] == null) {
            WorldProviderKuiper.\ub32e[12] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u6706\u3c4d\u2898\u5f46\uce5a\u3e74\u1c4c\ub4df\u5230\ud752\u6b87\u552e\u65b4\uda91\u5fc2\uaf74\u992e")), WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u6705\u3c58\u288b\u5f55\uce15\u3e75\u1c57\ub4c4"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub32e[12];
    }

    private static Object \ua501(Object object, String string, MethodType methodType) {
        if (\ub32e == null) {
            \ub32e = new Object[20];
        }
        if (\ub32e[4] == null) {
            WorldProviderKuiper.\ub32e[4] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u6706\u3c4d\u2898\u5f46\uce5a\u3e74\u1c4c\ub4df\u5230\ud752\u6b8e\u553d\u65b5\uda98\u5fe8\uaf5d\u9933\ue3bc\ucd97")), WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u670d\u3c48\u288a"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub32e[4];
    }

    private static Object \u3dba(Object object, String string, MethodType methodType) {
        if (\ub32e == null) {
            \ub32e = new Object[20];
        }
        if (\ub32e[14] == null) {
            WorldProviderKuiper.\ub32e[14] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u6706\u3c4d\u2898\u5f46\uce5a\u3e6d\u1c59\ub4d8\u523b\ud752\u6b9c\u553b\u65b5\uda90\u5fff\uaf76\u9918\ue3ba\ucd8a\uaf4b\u69e1\ue5b7\u405f")), WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u670d\u3c5c\u289e\u5f42\uce1a\u3e65"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub32e[14];
    }

    private static Object \u953f(Object object, String string, MethodType methodType) {
        if (\ub32e == null) {
            \ub32e = new Object[20];
        }
        if (\ub32e[0] == null) {
            WorldProviderKuiper.\ub32e[0] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u670b\u3c4d\u2882\u5f46\uce0c\u3e78\u1c4b\ub4c6\u523d\ud71f\u6baa\u5561\u65a0\uda98\u5ffd\uaf70\u9922\ue3a6\ucd86\uaf54\u69ab\ue5bf\u4044\u5f65\uc143\uc30c\ud11a\u695d\u3f7a\ub5a2\u92b6\u3cca\u6f89\ucc71\ua8b3\ua581\uc293\u0e27\ua5d6\ucd13\u650c\u2b4d\u1ef5\u9eb7\ue29d\u7047\uc31c\ube71\ud00c\u9685\u5387\u474f\u38f4\ue3f7\ue492\udc08\u4a0c\u5617\uf50f\u04e3\u92aa\u57a9\u998d\ua17c\ua4af\ua3a2\u439e\uf304\ube84\u90f3\u3cfa\u3e87\u0244\u1ad1\ufbd5\u6063\u49b2\u2bf6\udeea\u3170\u3e01\u80da\u68fe\udfb5\u2b79")), WorldChunkManagerKuiper$WorldProviderKuiper.\u63dd("\u670a\u3c59\u2880\u5f44\uce2b\u3e36\u1c0e\ub487\u5264\ud749\u6b90\u552e"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub32e[0];
    }

    private static Object \ucf05(Object object, String string, MethodType methodType) {
        if (\ub32e == null) {
            \ub32e = new Object[20];
        }
        if (\ub32e[10] == null) {
            WorldProviderKuiper.\ub32e[10] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u587d\u6340\u9d6c\ubf4b\ub971\ubec2\u7740\u5d1c\ua508\ue4a2\uf70e\u1d5e\uea8d\u79ef\u0f67\u71aa\ubd89")), ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u5861\u6340\u9d76\ubf5f\ub93a\ubee1\u7747"), methodType).asType(methodType));
        }
        return \ub32e[10];
    }

    private static Object \uc2cb(Object object, String string, MethodType methodType) {
        if (\ub32e == null) {
            \ub32e = new Object[20];
        }
        if (\ub32e[17] == null) {
            WorldProviderKuiper.\ub32e[17] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u587d\u6340\u9d6c\ubf4b\ub971\ubedb\u7755\u5d1b\ua503\ue4a2\uf70f\u1d51\uea8a\u79e2\u0f53\u71aa\ubd8f")), ChunkProviderKuiper$WorldProviderKuiper.\u9bf2("\u5876\u6345\u9d7e"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub32e[17];
    }

    private static Object \u707c(Object object, String string, MethodType methodType) {
        if (\ub32e == null) {
            \ub32e = new Object[20];
        }
        if (\ub32e[11] == null) {
            WorldProviderKuiper.\ub32e[11] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(WorldChunkManagerKuiper$WorldProviderKuiper$AsteroidData.\uf99e("\ufee3\ue031\u7111\uadfa\u9284\u49cb\u5430\u7b94\ued45\u70f3\u12e4\u7770\u566a\ua9e6\u8338\u5b40\u1db7")), WorldChunkManagerKuiper$WorldProviderKuiper$AsteroidData.\uf99e("\ufefb\ue035\u710a\uadf4\u92dc\u49db"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub32e[11];
    }
}

