/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.galaxies.milkyway.SolarSystem.planets.overworld.tile;

import cpw.mods.fml.relauncher.Side;
import galaxyspace.galaxies.milkyway.SolarSystem.planets.overworld.tile.TileEntitySolarWind$TileEntityStorageModule;
import micdoodle8.mods.galacticraft.api.entity.ICargoEntity;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityCargoFluidLoader
extends TileBaseElectricBlockWithInventory
implements IFluidHandler,
ISidedInventory,
ILandingPadAttachable {
    public static final int tankCapacity = 10000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank waterTank = new FluidTank(10000);
    private ItemStack[] containingItems = new ItemStack[1];
    public boolean outOfItems;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean targetFull;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean targetNoInventory;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean noTarget;
    public ICargoEntity attachedFuelable;

    public TileEntityCargoFluidLoader() {
        this.storage.setMaxExtract(45.0f);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.ticks % 100 == 0) {
                this.checkForCargoEntity();
            }
            if (this.attachedFuelable != null) {
                this.noTarget = false;
                ItemStack itemStack = this.removeCargo((boolean)false).resultStack;
                if (itemStack != null) {
                    this.outOfItems = false;
                    ICargoEntity.EnumCargoLoadingState enumCargoLoadingState = this.attachedFuelable.addCargo(itemStack, false);
                    this.targetFull = enumCargoLoadingState == ICargoEntity.EnumCargoLoadingState.FULL;
                    this.targetNoInventory = enumCargoLoadingState == ICargoEntity.EnumCargoLoadingState.NOINVENTORY;
                    boolean bl = this.noTarget = enumCargoLoadingState == ICargoEntity.EnumCargoLoadingState.NOTARGET;
                    if (this.ticks % 15 == 0 && enumCargoLoadingState == ICargoEntity.EnumCargoLoadingState.SUCCESS && !this.disabled && this.hasEnoughEnergyToRun) {
                        this.attachedFuelable.addCargo(this.removeCargo((boolean)true).resultStack, true);
                    }
                } else {
                    this.outOfItems = true;
                }
            } else {
                this.noTarget = true;
            }
        }
    }

    public void checkForCargoEntity() {
        boolean bl = false;
        for (ForgeDirection forgeDirection : ForgeDirection.values()) {
            if (forgeDirection == ForgeDirection.UNKNOWN) continue;
            TileEntity tileEntity = new BlockVec3((TileEntity)this).getTileEntityOnSide(this.field_145850_b, forgeDirection);
            if (tileEntity != null && tileEntity instanceof TileEntityMulti) {
                TileEntity tileEntity2 = ((TileEntityMulti)tileEntity).getMainBlockTile();
                if (!(tileEntity2 instanceof ICargoEntity)) continue;
                this.attachedFuelable = (ICargoEntity)tileEntity2;
                bl = true;
                break;
            }
            if (tileEntity == null || !(tileEntity instanceof ICargoEntity)) continue;
            this.attachedFuelable = (ICargoEntity)tileEntity;
            bl = true;
            break;
        }
        if (!bl) {
            this.attachedFuelable = null;
        }
    }

    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.containingItems = this.readStandardItemsFromNBT(nBTTagCompound);
        if (nBTTagCompound.func_74764_b(TileEntitySolarWind$TileEntityStorageModule.\u9b19("\u7c48\u5c09\uff32\u6b20\u7922\u69b6\u6843\ue720\u254a"))) {
            this.waterTank.readFromNBT(nBTTagCompound.func_74775_l(TileEntitySolarWind$TileEntityStorageModule.\u9b19("\u7c48\u5c09\uff32\u6b20\u7922\u69b6\u6843\ue720\u254a")));
        }
    }

    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        this.writeStandardItemsToNBT(nBTTagCompound);
        if (this.waterTank.getFluid() != null) {
            nBTTagCompound.func_74782_a(TileEntitySolarWind$TileEntityStorageModule.\u9b19("\u7c48\u5c09\uff32\u6b20\u7922\u69b6\u6843\ue720\u254a"), (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        }
    }

    protected ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)TileEntitySolarWind$TileEntityStorageModule.\u9b19("\u7c5c\u5c07\uff28\u6b31\u7931\u698b\u684c\ue72b\u2553\udafe\uee97\u9182\u50e9\u6c67\u8065\uaf04\u7adf\u4699\u2625\ua2b6\u6927\u8a61\u4cd6\ubfb2\u2bd6\ufbdf\u4621\uf929\uc2a9\uc2f1\ua446"));
    }

    public int[] func_94128_d(int n) {
        int[] nArray;
        if (n != this.func_145832_p() + 2) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        if (n2 != this.func_145832_p() + 2 && n == 0) {
            return ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
        }
        return false;
    }

    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return false;
    }

    public boolean func_94041_b(int n, ItemStack itemStack) {
        if (n == 0) {
            return ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
        }
        return true;
    }

    public boolean shouldUseEnergy() {
        return !this.getDisabled(0);
    }

    public ICargoEntity.EnumCargoLoadingState addCargo(ItemStack itemStack, boolean bl) {
        return ICargoEntity.EnumCargoLoadingState.FULL;
    }

    public ICargoEntity.RemovalResult removeCargo(boolean bl) {
        if (this.waterTank.getFluidAmount() > 0 && bl) {
            this.func_70296_d();
            return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.SUCCESS, null);
        }
        return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.EMPTY, null);
    }

    public boolean canAttachToLandingPad(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        return true;
    }

    public int getScaledWaterLevel(int n) {
        return this.waterTank.getFluidAmount() * n / this.waterTank.getCapacity();
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        String string;
        int n = 0;
        int n2 = this.func_145832_p() + 2;
        int n3 = forgeDirection.ordinal();
        if (n3 == n2 && (string = FluidRegistry.getFluidName((FluidStack)fluidStack)) != null) {
            n = this.waterTank.fill(fluidStack, bl);
        }
        return n;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return this.waterTank.getFluid() == null || this.waterTank.getFluidAmount() < this.waterTank.getCapacity();
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.waterTank)};
    }
}

