/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.galaxies.milkyway.SolarSystem.planets.overworld.tile;

import cpw.mods.fml.relauncher.Side;
import galaxyspace.core.registers.fluids.GSFluids;
import galaxyspace.core.registers.items.GSItems;
import galaxyspace.galaxies.milkyway.SolarSystem.planets.overworld.tile.TileEntityCargoFluidLoader$TileEntityConverterSurface;
import galaxyspace.galaxies.milkyway.SolarSystem.planets.overworld.tile.TileEntityPortableNuclearReactor$TileEntityLiquidExtractor;
import galaxyspace.galaxies.milkyway.SolarSystem.planets.overworld.tile.TileEntitySolarWind$TileEntityStorageModule;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityLiquidExtractor
extends TileBaseElectricBlockWithInventory
implements IFluidHandler,
ISidedInventory,
IPacketReceiver {
    int PROCESS_TIME_REQUIRED;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTimeRequired;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks;
    private final int tankCapacity = 3000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank waterTank;
    private ItemStack[] containingItems;
    public final Set<EntityPlayer> playersUsing;
    private boolean initialised;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    private int x;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    private int z;
    private static volatile transient Object[] \u12e8;

    public TileEntityLiquidExtractor() {
        this(1);
    }

    public TileEntityLiquidExtractor(int n) {
        this.processTimeRequired = this.PROCESS_TIME_REQUIRED = 10;
        this.processTicks = 0;
        this.tankCapacity = 3000;
        this.waterTank = new FluidTank(this.tankCapacity);
        this.containingItems = new ItemStack[4];
        this.playersUsing = new HashSet<EntityPlayer>();
        this.initialised = false;
        this.x = -2;
        this.z = -2;
        this.initialised = true;
        if (n == 1) {
            this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 60.0f : 45.0f);
            return;
        }
        this.setTier2();
    }

    private void setTier2() {
        this.storage.setCapacity(25000.0f);
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 90.0f : 60.0f);
        this.processTimeRequired = 100;
        this.setTierGC(2);
    }

    public void func_145845_h() {
        if (!this.initialised) {
            int n = this.func_145832_p();
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (block == GCBlocks.machineBase) {
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, GCBlocks.machineTiered, 4, 2);
            } else if (n >= 8) {
                this.setTier2();
            }
            this.initialised = true;
        }
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.checkFluidTankTransfer(1, this.waterTank);
            if (this.canProcess()) {
                if (this.hasEnoughEnergyToRun) {
                    if (this.tierGC == 2) {
                        this.processTimeRequired = 200 / (1 + this.poweredByTierGC);
                    }
                    if (this.processTicks == 0) {
                        this.processTicks = this.processTimeRequired;
                    } else if (--this.processTicks <= 0) {
                        this.smeltItem();
                        this.processTicks = this.canProcess() ? this.processTimeRequired : 0;
                    }
                } else if (this.processTicks > 0 && this.processTicks < this.processTimeRequired && TileEntityLiquidExtractor.\u9159("\u834f", (Random)this.field_145850_b.field_73012_v, (int)4) == false) {
                    ++this.processTicks;
                }
            } else {
                this.processTicks = 0;
            }
        }
    }

    private void checkFluidTankTransfer(int n, FluidTank fluidTank) {
        FluidStack fluidStack;
        if (FluidUtil.isValidContainer((ItemStack)this.containingItems[n]) && (fluidStack = fluidTank.getFluid()) != null) {
            if (TileEntityLiquidExtractor.\u8148("\u6975", fluidStack.getFluid().getName(), (CharSequence)TileEntityPortableNuclearReactor$TileEntityLiquidExtractor.\u0d13("\u073b\u4138\u2d5e\ufdf2\u7231\uebdc\ud32e")) != false) {
                FluidUtil.tryFillContainer((FluidTank)fluidTank, (FluidStack)fluidStack, (ItemStack[])this.containingItems, (int)n, (Item)AsteroidsItems.methaneCanister);
            } else if (fluidStack.getFluid() == GSFluids.Helium3) {
                FluidUtil.tryFillContainer((FluidTank)fluidTank, (FluidStack)fluidStack, (ItemStack[])this.containingItems, (int)n, (Item)GSItems.Helium3Canister);
            } else if (fluidStack.getFluid() == GSFluids.HeliumHydrogen) {
                FluidUtil.tryFillContainer((FluidTank)fluidTank, (FluidStack)fluidStack, (ItemStack[])this.containingItems, (int)n, (Item)GSItems.HeliumHydrogenBucket);
            } else if (TileEntityLiquidExtractor.\u8148("\u6975", fluidStack.getFluid().getName(), (CharSequence)TileEntityPortableNuclearReactor$TileEntityLiquidExtractor.\u0d13("\u073e\u4124\u2d4e\ufde8\u723f\uebd5\ud32e\ucee8")) != false) {
                FluidUtil.tryFillContainer((FluidTank)fluidTank, (FluidStack)fluidStack, (ItemStack[])this.containingItems, (int)n, (Item)GSItems.HydrogenCanister);
            } else if (TileEntityLiquidExtractor.\u8148("\u6975", fluidStack.getFluid().getName(), (CharSequence)TileEntityPortableNuclearReactor$TileEntityLiquidExtractor.\u0d13("\u073a\u4134\u2d5b\ufdef\u7239\uebd6\ud324\ucefe\ue23c\u4cf5\ue83e\u2f7f")) != false) {
                FluidUtil.tryFillContainer((FluidTank)fluidTank, (FluidStack)fluidStack, (ItemStack[])this.containingItems, (int)n, (Item)AsteroidsItems.canisterLOX);
            } else if (TileEntityLiquidExtractor.\u8148("\u6975", fluidStack.getFluid().getName(), (CharSequence)TileEntityPortableNuclearReactor$TileEntityLiquidExtractor.\u0d13("\u0739\u4134\u2d46")) != false) {
                FluidUtil.tryFillContainer((FluidTank)fluidTank, (FluidStack)fluidStack, (ItemStack[])this.containingItems, (int)n, (Item)GCItems.oilCanister);
            } else if (TileEntityLiquidExtractor.\u8148("\u6975", fluidStack.getFluid().getName(), (CharSequence)TileEntityPortableNuclearReactor$TileEntityLiquidExtractor.\u0d13("\u0730\u4128\u2d4f\ufdf6")) != false) {
                FluidUtil.tryFillContainer((FluidTank)fluidTank, (FluidStack)fluidStack, (ItemStack[])this.containingItems, (int)n, (Item)GCItems.fuelCanister);
            } else if (TileEntityLiquidExtractor.\u8148("\u6975", fluidStack.getFluid().getName(), (CharSequence)TileEntityPortableNuclearReactor$TileEntityLiquidExtractor.\u0d13("\u0738\u4134\u2d58\ufdee\u723f\uebd5\ud32e\ucee8")) != false) {
                FluidUtil.tryFillContainer((FluidTank)fluidTank, (FluidStack)fluidStack, (ItemStack[])this.containingItems, (int)n, (Item)AsteroidsItems.canisterLN2);
            } else {
                FluidUtil.tryFillContainer((FluidTank)fluidTank, (FluidStack)fluidStack, (ItemStack[])this.containingItems, (int)n, (Item)Items.field_151133_ar);
            }
        }
    }

    public boolean canProcess() {
        return this.waterTank.getFluidAmount() < this.waterTank.getCapacity();
    }

    public void smeltItem() {
        if (this.canProcess()) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c + this.x, this.field_145848_d - 1, this.field_145849_e + this.z);
            int n = this.field_145850_b.func_72805_g(this.field_145851_c + this.x, this.field_145848_d - 1, this.field_145849_e + this.z);
            if (n == 0) {
                if (block == Blocks.field_150355_j || block == Blocks.field_150432_aD) {
                    this.waterTank.fill(new FluidStack(this.containingItems[2] != null && this.containingItems[2] == new ItemStack(GSItems.BasicItems, 1, 3) ? GSFluids.Hydrogen2 : FluidRegistry.WATER, block == Blocks.field_150432_aD ? 20 : (this.containingItems[2] != null ? 100 : 1000)), true);
                    if (block != Blocks.field_150432_aD && this.waterTank.getFluid().isFluidEqual(new FluidStack(FluidRegistry.lookupFluidForBlock((Block)block), 0))) {
                        this.field_145850_b.func_147468_f(this.field_145851_c + this.x, this.field_145848_d - 1, this.field_145849_e + this.z);
                    }
                }
                if (block == Blocks.field_150353_l) {
                    this.waterTank.fill(new FluidStack(FluidRegistry.LAVA, 1000), true);
                    this.field_145850_b.func_147468_f(this.field_145851_c + this.x, this.field_145848_d - 1, this.field_145849_e + this.z);
                }
                if (block instanceof IFluidBlock) {
                    IFluidBlock iFluidBlock = (IFluidBlock)block;
                    this.waterTank.fill(new FluidStack(iFluidBlock.getFluid(), 1000), true);
                    this.field_145850_b.func_147468_f(this.field_145851_c + this.x, this.field_145848_d - 1, this.field_145849_e + this.z);
                }
            }
            if (this.x < 2) {
                ++this.x;
            } else {
                this.x = -2;
                ++this.z;
            }
            if (this.z > 2) {
                this.z = -2;
            }
        }
    }

    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        if (this.storage.getEnergyStoredGC() > 16000.0f) {
            this.setTier2();
            this.initialised = true;
        } else {
            this.initialised = false;
        }
        this.processTicks = nBTTagCompound.func_74762_e(TileEntityCargoFluidLoader$TileEntityConverterSurface.\u5565("\ub2cc\u41e0\u088c\u722f\ue978\u1b76\u2718\u640a\u28df\u5565\u314e\u17fe\u8b1c"));
        this.containingItems = this.readStandardItemsFromNBT(nBTTagCompound);
        this.x = nBTTagCompound.func_74762_e(TileEntityCargoFluidLoader$TileEntityConverterSurface.\u5565("\ub2cf\u41e2\u089a\u721b"));
        this.z = nBTTagCompound.func_74762_e(TileEntityCargoFluidLoader$TileEntityConverterSurface.\u5565("\ub2cf\u41e2\u089a\u7219"));
        if (nBTTagCompound.func_74764_b(TileEntityCargoFluidLoader$TileEntityConverterSurface.\u5565("\ub2c8\u41ec\u089d\u7226\ue97e\u1b4b\u2717\u6403\u28e0"))) {
            this.waterTank.readFromNBT(nBTTagCompound.func_74775_l(TileEntityCargoFluidLoader$TileEntityConverterSurface.\u5565("\ub2c8\u41ec\u089d\u7226\ue97e\u1b4b\u2717\u6403\u28e0")));
        }
    }

    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        if (this.tierGC == 1 && this.storage.getEnergyStoredGC() > 16000.0f) {
            this.storage.setEnergyStored(16000.0f);
        }
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a(TileEntitySolarWind$TileEntityStorageModule.\u9b19("\u7c4c\u5c05\uff23\u6b29\u7924\u698b\u684c\ue729\u2575\udab9\uee97\u9188\u50e8"), this.processTicks);
        nBTTagCompound.func_74768_a(TileEntitySolarWind$TileEntityStorageModule.\u9b19("\u7c4f\u5c07\uff35\u6b1d"), this.x);
        nBTTagCompound.func_74768_a(TileEntitySolarWind$TileEntityStorageModule.\u9b19("\u7c4f\u5c07\uff35\u6b1f"), this.z);
        this.writeStandardItemsToNBT(nBTTagCompound);
        if (this.waterTank.getFluid() != null) {
            nBTTagCompound.func_74782_a(TileEntitySolarWind$TileEntityStorageModule.\u9b19("\u7c48\u5c09\uff32\u6b20\u7922\u69b6\u6843\ue720\u254a"), (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        }
    }

    protected ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)TileEntityCargoFluidLoader$TileEntityConverterSurface.\u5565("\ub2cb\u41e4\u0885\u7226\ue922\u1b53\u271f\u641c\u28fe\u5565\u3149\u17d0\u8b17\ud786\u6c7e\u9897\u8363\ua329\uc4ff\u4e8c\uc8e4\ud708\ua368\u8898\u5117"));
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int n, ItemStack itemStack) {
        switch (n) {
            case 0: {
                return ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public int[] func_94128_d(int n) {
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return this.func_94041_b(n, itemStack);
    }

    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return n == 1;
    }

    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        int n = 0;
        return n;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        int n = this.func_145832_p() + 2;
        int n2 = forgeDirection.ordinal();
        if (n2 == (n ^ 1) && fluidStack != null && fluidStack.isFluidEqual(this.waterTank.getFluid())) {
            return this.waterTank.drain(fluidStack.amount, bl);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        int n2 = this.func_145832_p() + 2;
        int n3 = forgeDirection.ordinal();
        if (n3 == (n2 ^ 1)) {
            return this.waterTank.drain(n, bl);
        }
        return null;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        int n = this.func_145832_p() + 2;
        int n2 = forgeDirection.ordinal();
        if (n2 == (n ^ 1)) {
            return this.waterTank.getFluid() != null && this.waterTank.getFluidAmount() > 0;
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.waterTank)};
    }

    public int getScaledFuelLevel(int n) {
        return this.waterTank.getFluidAmount() * n / this.waterTank.getCapacity();
    }

    private static Object \u8148(Object object, String string, MethodType methodType) {
        if (\u12e8 == null) {
            \u12e8 = new Object[2];
        }
        if (\u12e8[1] == null) {
            TileEntityLiquidExtractor.\u12e8[1] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(TileEntitySolarWind$TileEntityStorageModule.\u9b19("\u7c55\u5c09\uff30\u6b24\u797e\u698e\u6843\ue720\u2546\udafe\ueea7\u9197\u50e9\u6c69\u8064\uaf05")), TileEntitySolarWind$TileEntityStorageModule.\u9b19("\u7c5c\u5c07\uff28\u6b31\u7931\u698b\u684c\ue73d"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u12e8[1];
    }

    private static Object \u9159(Object object, String string, MethodType methodType) {
        if (\u12e8 == null) {
            \u12e8 = new Object[2];
        }
        if (\u12e8[0] == null) {
            TileEntityLiquidExtractor.\u12e8[0] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(TileEntityCargoFluidLoader$TileEntityConverterSurface.\u5565("\ub2d5\u41ec\u089f\u7222\ue922\u1b6a\u2702\u6404\u28e7\u5522\u317f\u17f4\u8b01\ud796\u6c63\u989b")), TileEntityCargoFluidLoader$TileEntityConverterSurface.\u5565("\ub2d1\u41e8\u0891\u7237\ue945\u1b71\u2702"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u12e8[0];
    }
}

