/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.core.ISerializable;
import buildcraft.api.core.Position;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class LaserData
implements ISerializable {
    public Position head = new Position(0.0, 0.0, 0.0);
    public Position tail = new Position(0.0, 0.0, 0.0);
    public boolean isVisible = true;
    public boolean isGlowing = false;
    public double renderSize = 0.0625;
    public double angleY = 0.0;
    public double angleZ = 0.0;
    public double wavePosition = 0.0;
    public int laserTexAnimation = 0;
    public float waveSize = 1.0f;

    public LaserData() {
    }

    public LaserData(Position tail, Position head) {
        this.tail.x = tail.x;
        this.tail.y = tail.y;
        this.tail.z = tail.z;
        this.head.x = head.x;
        this.head.y = head.y;
        this.head.z = head.z;
    }

    public void update() {
        double dx = this.head.x - this.tail.x;
        double dy = this.head.y - this.tail.y;
        double dz = this.head.z - this.tail.z;
        this.renderSize = Math.sqrt(dx * dx + dy * dy + dz * dz);
        this.angleZ = 360.0 - (Math.atan2(dz, dx) * 180.0 / Math.PI + 180.0);
        dx = Math.sqrt(this.renderSize * this.renderSize - dy * dy);
        this.angleY = -Math.atan2(dy, dx) * 180.0 / Math.PI;
    }

    public void iterateTexture() {
        this.laserTexAnimation = (this.laserTexAnimation + 1) % 40;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound headNbt = new NBTTagCompound();
        this.head.writeToNBT(headNbt);
        nbt.func_74782_a("head", (NBTBase)headNbt);
        NBTTagCompound tailNbt = new NBTTagCompound();
        this.tail.writeToNBT(tailNbt);
        nbt.func_74782_a("tail", (NBTBase)tailNbt);
        nbt.func_74757_a("isVisible", this.isVisible);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.head.readFromNBT(nbt.func_74775_l("head"));
        this.tail.readFromNBT(nbt.func_74775_l("tail"));
        this.isVisible = nbt.func_74767_n("isVisible");
    }

    @Override
    public void readData(ByteBuf stream) {
        this.head.readData(stream);
        this.tail.readData(stream);
        short flags = stream.readUnsignedByte();
        this.isVisible = (flags & 1) != 0;
        this.isGlowing = (flags & 2) != 0;
    }

    @Override
    public void writeData(ByteBuf stream) {
        this.head.writeData(stream);
        this.tail.writeData(stream);
        int flags = (this.isVisible ? 1 : 0) | (this.isGlowing ? 2 : 0);
        stream.writeByte(flags);
    }
}

