/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.lib.RFBattery;
import buildcraft.core.lib.inventory.InvUtils;
import buildcraft.core.lib.inventory.InventoryWrapper;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.pipes.PipeLogicWood;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeItemsWood
extends Pipe<PipeTransportItems>
implements IEnergyHandler {
    protected RFBattery battery = new RFBattery(2560, 80, 0);
    protected int standardIconIndex = PipeIconProvider.TYPE.PipeItemsWood_Standard.ordinal();
    protected int solidIconIndex = PipeIconProvider.TYPE.PipeAllWood_Solid.ordinal();
    protected float speedMultiplier = 1.0f;
    private int ticksSincePull = 0;
    private PipeLogicWood logic = new PipeLogicWood(this){

        @Override
        protected boolean isValidConnectingTile(TileEntity tile) {
            if (tile instanceof IPipeTile) {
                return false;
            }
            return tile instanceof IInventory;
        }
    };

    public PipeItemsWood(Item item) {
        super(new PipeTransportItems(), item);
    }

    @Override
    public boolean blockActivated(EntityPlayer entityplayer, ForgeDirection side) {
        return this.logic.blockActivated(entityplayer, side);
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        this.logic.onNeighborBlockChange();
        super.onNeighborBlockChange(blockId);
    }

    @Override
    public void initialize() {
        this.logic.initialize();
        super.initialize();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return this.standardIconIndex;
        }
        int metadata = this.container.func_145832_p();
        if (metadata == direction.ordinal()) {
            return this.solidIconIndex;
        }
        return this.standardIconIndex;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.container.func_145831_w().field_72995_K) {
            return;
        }
        ++this.ticksSincePull;
        if (this.shouldTick()) {
            if (((PipeTransportItems)this.transport).getNumberOfStacks() < 64) {
                this.extractItems();
            }
            this.battery.setEnergy(0);
            this.ticksSincePull = 0;
            this.speedMultiplier = 1.0f;
            this.onPostTick();
        }
    }

    public void onPostTick() {
    }

    private boolean shouldTick() {
        ForgeDirection side;
        TileEntity tile;
        int meta;
        if (this.ticksSincePull < 8) {
            return false;
        }
        if (this.ticksSincePull < 16 && (meta = this.container.func_145832_p()) <= 5 && (tile = this.container.getTile(side = ForgeDirection.getOrientation((int)meta))) instanceof IInventory) {
            int stackSize = 0;
            IInventory inventory = (IInventory)tile;
            ItemStack[] extracted = this.checkExtract(inventory, false, side.getOpposite());
            if (extracted != null) {
                for (ItemStack s : extracted) {
                    stackSize += s.field_77994_a;
                }
            }
            if (this.battery.getEnergyStored() >= stackSize * 10) {
                return true;
            }
        }
        return this.ticksSincePull >= 16 && this.battery.getEnergyStored() >= 10;
    }

    private void extractItems() {
        int meta = this.container.func_145832_p();
        if (meta > 5) {
            return;
        }
        ForgeDirection side = ForgeDirection.getOrientation((int)meta);
        TileEntity tile = this.container.getTile(side);
        if (tile instanceof IInventory) {
            IInventory inventory = (IInventory)tile;
            ItemStack[] extracted = this.checkExtract(inventory, true, side.getOpposite());
            if (extracted == null) {
                return;
            }
            tile.func_70296_d();
            for (ItemStack stack : extracted) {
                if (stack == null || stack.field_77994_a == 0) continue;
                Position entityPos = new Position((double)tile.field_145851_c + 0.5, (double)tile.field_145848_d + 0.5, (double)tile.field_145849_e + 0.5, side.getOpposite());
                entityPos.moveForwards(0.6);
                TravelingItem entity = this.makeItem(entityPos.x, entityPos.y, entityPos.z, stack);
                entity.setSpeed(0.01f);
                ((PipeTransportItems)this.transport).injectItem(entity, entityPos.orientation);
            }
        }
    }

    protected TravelingItem makeItem(double x, double y, double z, ItemStack stack) {
        return TravelingItem.make(x, y, z, stack);
    }

    public ItemStack[] checkExtract(IInventory inventory, boolean doRemove, ForgeDirection from) {
        IInventory inv = InvUtils.getInventory(inventory);
        ItemStack result = this.checkExtractGeneric(inv, doRemove, from);
        if (result != null) {
            return new ItemStack[]{result};
        }
        return null;
    }

    public ItemStack checkExtractGeneric(IInventory inventory, boolean doRemove, ForgeDirection from) {
        return this.checkExtractGeneric(InventoryWrapper.getWrappedInventory(inventory), doRemove, from);
    }

    public ItemStack checkExtractGeneric(ISidedInventory inventory, boolean doRemove, ForgeDirection from) {
        if (inventory == null) {
            return null;
        }
        for (int k : inventory.func_94128_d(from.ordinal())) {
            ItemStack slot = inventory.func_70301_a(k);
            if (slot == null || slot.field_77994_a <= 0 || !inventory.func_102008_b(k, slot, from.ordinal())) continue;
            if (doRemove) {
                int maxStackSize = slot.field_77994_a;
                int stackSize = Math.min(maxStackSize, this.battery.getEnergyStored() / 10);
                int energyUsed = (int)((float)(stackSize * 10) * this.speedMultiplier);
                this.battery.useEnergy(energyUsed, energyUsed, false);
                return inventory.func_70298_a(k, stackSize);
            }
            return slot;
        }
        return null;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.battery.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.battery.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.battery.getMaxEnergyStored();
    }
}

