/*
 * Decompiled with CFR 0.152.
 */
package ic2.api.reactor;

import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;

public interface IReactorPlannerComponent
extends IReactorComponent {
    public static final NBTBase.NBTPrimitive nulltag = new NBTNull();

    public ItemStack[] getSubParts();

    public boolean hasSubParts();

    public ItemStack getReactorPart();

    public short getID(ItemStack var1);

    public ReactorType getReactorInfo(ItemStack var1);

    public ReactorComponentType getType(ItemStack var1);

    public List<ReactorComponentStat> getExtraStats(ItemStack var1);

    public NBTBase.NBTPrimitive getReactorStat(ReactorComponentStat var1, ItemStack var2);

    public boolean isAdvancedStat(ReactorComponentStat var1, ItemStack var2);

    public NBTBase.NBTPrimitive getReactorStat(IReactor var1, int var2, int var3, ItemStack var4, ReactorComponentStat var5);

    public static class NBTNull
    extends NBTTagInt {
        public NBTNull() {
            super(0);
        }
    }

    public static enum ReactorType {
        Reactor,
        SteamReactor,
        Both;


        public boolean isReactor() {
            return this == Reactor || this == Both;
        }

        public boolean isSteamReactor() {
            return this == SteamReactor || this == Both;
        }
    }

    public static enum ReactorComponentStat {
        HeatProduction(false),
        EnergyProduction(true),
        RodAmount(false),
        PulseAmount(false),
        SelfCooling(false),
        PartCooling(false),
        ReactorCooling(false),
        PartChange(false),
        ReactorChange(false),
        HeatStorage(false),
        ReactorMaxHeat(false),
        ReactorEEM(true),
        MaxDurability(false),
        EnergyUsage(true),
        WaterConsumtion(true),
        SteamProduction(true),
        WaterStorage(true);

        final boolean isFloat;

        private ReactorComponentStat(boolean isFloat) {
            this.isFloat = isFloat;
        }

        public NBTBase.NBTPrimitive createStat(Number nr) {
            if (this.isFloat) {
                return new NBTTagFloat(nr.floatValue());
            }
            return new NBTTagInt(nr.intValue());
        }
    }

    public static enum ReactorComponentType {
        FuelRod(ReactorComponentStat.RodAmount, ReactorComponentStat.PulseAmount, ReactorComponentStat.HeatProduction, ReactorComponentStat.EnergyProduction, ReactorComponentStat.MaxDurability, ReactorComponentStat.ReactorEEM),
        CoolantCell(ReactorComponentStat.HeatStorage),
        Conensator(ReactorComponentStat.HeatStorage),
        HeatPack(ReactorComponentStat.HeatProduction),
        Vent(ReactorComponentStat.SelfCooling, ReactorComponentStat.ReactorCooling),
        VentSpread(ReactorComponentStat.PartCooling, ReactorComponentStat.ReactorCooling),
        HeatSwitch(ReactorComponentStat.ReactorChange, ReactorComponentStat.PartChange),
        Plating(ReactorComponentStat.ReactorMaxHeat, ReactorComponentStat.ReactorEEM),
        Reflection(ReactorComponentStat.EnergyProduction, ReactorComponentStat.MaxDurability),
        IsotopeCell(ReactorComponentStat.MaxDurability, ReactorComponentStat.ReactorEEM);

        ReactorComponentStat[] parts;

        private ReactorComponentType(ReactorComponentStat ... par1) {
            this.parts = par1;
        }

        public ReactorComponentStat[] getStats() {
            return this.parts;
        }
    }
}

