/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.recipe.ICraftingRecipeManagerList;
import ic2.core.AdvRecipe;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class AdvShapelessRecipe
implements IRecipe,
ICraftingRecipeManagerList.IAdvRecipe {
    public ItemStack output;
    public boolean hidden;
    public ArrayList input = new ArrayList();
    public List<ICraftingRecipeManagerList.RecipeObject> objects = new ArrayList<ICraftingRecipeManagerList.RecipeObject>();

    public static AdvShapelessRecipe addAndRegister(ItemStack result, Object[] args) {
        AdvShapelessRecipe recipe = new AdvShapelessRecipe(result, args);
        CraftingManager.func_77594_a().func_77592_b().add(recipe);
        return recipe;
    }

    public AdvShapelessRecipe(ItemStack output, Object[] inputs) {
        this.output = output.func_77946_l();
        for (Object obj : inputs) {
            if (obj == null) continue;
            if (obj instanceof String) {
                String text = (String)obj;
                if (text.startsWith("liquid$")) {
                    this.add(AdvRecipe.getFluids(text));
                    continue;
                }
                this.add(OreDictionary.getOres((String)text));
                continue;
            }
            if (obj instanceof Boolean) {
                this.hidden = (Boolean)obj;
                continue;
            }
            if (obj instanceof Item) {
                this.add(new ItemStack((Item)obj, 1, Short.MAX_VALUE));
                continue;
            }
            if (obj instanceof Block) {
                this.add(new ItemStack((Block)obj, 1, Short.MAX_VALUE));
                continue;
            }
            if (!(obj instanceof ItemStack)) continue;
            this.add(ItemStack.func_77944_b((ItemStack)((ItemStack)obj)));
        }
    }

    private void add(ItemStack par1) {
        this.input.add(par1);
        this.objects.add(new ICraftingRecipeManagerList.RecipeObject(-1, par1));
    }

    private void add(List<ItemStack> par1) {
        this.input.add(par1);
        this.objects.add(new ICraftingRecipeManagerList.RecipeObject(-1, par1));
    }

    public boolean func_77569_a(InventoryCrafting inventorycrafting, World world) {
        return this.func_77572_b(inventorycrafting) != null;
    }

    public ItemStack func_77572_b(InventoryCrafting par1) {
        ArrayList list = new ArrayList(this.input);
        int totalCharge = 0;
        for (int i = 0; i < par1.func_70302_i_(); ++i) {
            ItemStack stack = par1.func_70301_a(i);
            if (stack == null) continue;
            boolean inRecipe = false;
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                boolean match = false;
                Object next = iter.next();
                if (next instanceof ItemStack) {
                    ItemStack recipeInput = (ItemStack)next;
                    match = AdvRecipe.ItemsMatch(stack, recipeInput);
                } else if (next instanceof ArrayList) {
                    match = AdvRecipe.ItemsMatch(stack, (ArrayList)next);
                }
                if (!match) continue;
                inRecipe = true;
                list.remove(next);
                break;
            }
            if (stack.func_77973_b() instanceof IElectricItem) {
                totalCharge = (int)((double)totalCharge + ElectricItem.manager.getCharge(stack));
            }
            if (inRecipe) continue;
            return null;
        }
        if (!list.isEmpty()) {
            return null;
        }
        ItemStack out = this.output.func_77946_l();
        if (out.func_77973_b() instanceof IElectricItem && totalCharge > 0) {
            ElectricItem.manager.charge(out, totalCharge, Integer.MAX_VALUE, true, false);
        }
        return out;
    }

    public int func_77570_a() {
        return this.input.size();
    }

    public ItemStack func_77571_b() {
        return this.output.func_77946_l();
    }

    @Override
    public boolean isShaped() {
        return false;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public List<ICraftingRecipeManagerList.RecipeObject> getRecipeInput() {
        return new ArrayList<ICraftingRecipeManagerList.RecipeObject>(this.objects);
    }

    @Override
    public int getRecipeHeight() {
        return -1;
    }

    @Override
    public int getRecipeLength() {
        return -1;
    }
}

