/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import ic2.api.recipe.IMachineRecipeManagerExp;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class BasicMachineRecipeManager
implements IMachineRecipeManagerExp {
    private final Map<IRecipeInput, RecipeOutput> recipes = new HashMap<IRecipeInput, RecipeOutput>();
    private final Map<IRecipeInput, Float> expList = new HashMap<IRecipeInput, Float>();

    @Override
    public void addRecipe(IRecipeInput input, NBTTagCompound metadata, ItemStack ... outputs) {
        this.addRecipe(input, metadata, 0.0f, outputs);
    }

    @Override
    public RecipeOutput getOutputFor(ItemStack input, boolean adjustInput) {
        if (input == null) {
            return null;
        }
        for (Map.Entry<IRecipeInput, RecipeOutput> recipe : this.recipes.entrySet()) {
            IRecipeInput recipeInput = recipe.getKey();
            if (!recipeInput.matches(input)) continue;
            if (input.field_77994_a < recipeInput.getAmount() || input.func_77973_b().hasContainerItem(input) && input.field_77994_a != recipeInput.getAmount()) break;
            if (adjustInput) {
                if (input.func_77973_b().hasContainerItem(input)) {
                    ItemStack container = input.func_77973_b().getContainerItem(input);
                    input.func_150996_a(container.func_77973_b());
                    input.field_77994_a = container.field_77994_a;
                    input.func_77964_b(container.func_77960_j());
                    input.field_77990_d = container.field_77990_d;
                } else {
                    input.field_77994_a -= recipeInput.getAmount();
                }
            }
            return recipe.getValue();
        }
        return null;
    }

    @Override
    public Map<IRecipeInput, RecipeOutput> getRecipes() {
        return this.recipes;
    }

    @Override
    public boolean addRecipe(IRecipeInput input, NBTTagCompound metadata, boolean overwrite, ItemStack ... outputs) {
        this.addRecipe(input, metadata, outputs);
        return true;
    }

    @Override
    public void addRecipe(IRecipeInput input, NBTTagCompound metadata, float exp, ItemStack ... outputs) {
        if (input == null) {
            throw new NullPointerException("The recipe input is null");
        }
        for (int i = 0; i < outputs.length; ++i) {
            if (outputs[i] == null) {
                throw new NullPointerException("The output ItemStack #" + i + " is null (counting from 0)");
            }
            outputs[i] = outputs[i].func_77946_l();
        }
        RecipeOutput out = new RecipeOutput(metadata, outputs);
        this.recipes.put(input, out);
        if (exp > 0.0f) {
            this.expList.put(new RecipeInputItemList(out), Float.valueOf(exp));
        }
    }

    @Override
    public float getExpResult(ItemStack output) {
        if (output == null) {
            return 0.0f;
        }
        for (Map.Entry<IRecipeInput, Float> entry : this.expList.entrySet()) {
            IRecipeInput input = entry.getKey();
            if (!input.matches(output)) continue;
            return entry.getValue().floatValue();
        }
        return 0.0f;
    }

    @Override
    public Map<IRecipeInput, Float> getExpMap() {
        return this.expList;
    }

    public class RecipeInputItemList
    implements IRecipeInput {
        public final List<ItemStack> items = new ArrayList<ItemStack>();

        public RecipeInputItemList(RecipeOutput par1) {
            this.items.addAll(par1.items);
        }

        @Override
        public boolean matches(ItemStack subject) {
            for (ItemStack stack : this.items) {
                if (!stack.func_77969_a(subject) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)subject)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int getAmount() {
            return 0;
        }

        @Override
        public List<ItemStack> getInputs() {
            return Collections.unmodifiableList(this.items);
        }
    }
}

