/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.SubIconHandler;
import ic2.core.fluids.IC2Fluid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;

public class Ic2Icons {
    public static Map<String, IIcon[]> textures = new HashMap<String, IIcon[]>();
    public static Map<String, String> iconToFile = new HashMap<String, String>();
    public static Map<String, SpriteData> iconIDToData = new HashMap<String, SpriteData>();
    public static Map<Integer, List<TextureEntry>> texturesToLoad = new HashMap<Integer, List<TextureEntry>>();
    public static Map<Integer, List<SpecialEntry>> specialTexturesToLoad = new HashMap<Integer, List<SpecialEntry>>();

    public static IIcon[] getTexture(String par1) {
        return textures.get(par1);
    }

    public static void addSprite(SpriteData data) {
        String id = data.spriteID;
        iconIDToData.put(id, data);
        int amount = data.info.spriteAmount;
        textures.put(id, new IIcon[amount]);
    }

    public static void addTextureEntry(int id, List<TextureEntry> entries) {
        Ic2Icons.check(id);
        texturesToLoad.get(id).addAll(entries);
    }

    public static void addTextureEntry(int id, TextureEntry entry) {
        Ic2Icons.check(id);
        texturesToLoad.get(id).add(entry);
    }

    public static void addSpecialEntry(int id, List<SpecialEntry> entries) {
        Ic2Icons.checkSpecial(id);
        specialTexturesToLoad.get(id).addAll(entries);
    }

    public static void addSpecialEntry(int id, SpecialEntry entry) {
        Ic2Icons.checkSpecial(id);
        specialTexturesToLoad.get(id).add(entry);
    }

    private static void checkSpecial(int id) {
        if (!specialTexturesToLoad.containsKey(id)) {
            specialTexturesToLoad.put(id, new ArrayList());
        }
    }

    private static void check(int id) {
        if (!texturesToLoad.containsKey(id)) {
            texturesToLoad.put(id, new ArrayList());
        }
    }

    public static void init() {
        Ic2Icons.addSprite(new SpriteData("b0", "ic2:textures/sprites/block_0.png", new SpriteInfo(16, 16)));
        Ic2Icons.addSprite(new SpriteData("bc", "ic2:textures/sprites/crops_0.png", new SpriteInfo(16, 16)));
        Ic2Icons.addSprite(new SpriteData("bgen", "ic2:textures/sprites/block_generator.png", new SpriteInfo(16, 12)));
        Ic2Icons.addSprite(new SpriteData("bmach", "ic2:textures/sprites/block_machine.png", new SpriteInfo(16, 12)));
        Ic2Icons.addSprite(new SpriteData("bmach2", "ic2:textures/sprites/block_machine2.png", new SpriteInfo(16, 12)));
        Ic2Icons.addSprite(new SpriteData("bpersonal", "ic2:textures/sprites/block_personal.png", new SpriteInfo(16, 12)));
        Ic2Icons.addSprite(new SpriteData("bcable", "ic2:textures/sprites/block_cable.png", new SpriteInfo(17, 17)));
        Ic2Icons.addSprite(new SpriteData("belec", "ic2:textures/sprites/block_electric.png", new SpriteInfo(16, 12)));
        Ic2Icons.addSprite(new SpriteData("i0", "ic2:textures/sprites/item_0.png", new SpriteInfo(16, 16)));
        Ic2Icons.addSprite(new SpriteData("i1", "ic2:textures/sprites/item_1.png", new SpriteInfo(16, 16)));
        Ic2Icons.addSprite(new SpriteData("i2", "ic2:textures/sprites/item_2.png", new SpriteInfo(16, 16)));
        Ic2Icons.addSprite(new SpriteData("i3", "ic2:textures/sprites/item_3.png", new SpriteInfo(16, 16)));
        Ic2Icons.addSprite(new SpriteData("batBox", "ic2:textures/sprites/Batbox.png", new SpriteInfo(4, 12)));
        Ic2Icons.addSprite(new SpriteData("mfe", "ic2:textures/sprites/MFE.png", new SpriteInfo(4, 12)));
        Ic2Icons.addSprite(new SpriteData("mfsu", "ic2:textures/sprites/MFSU.png", new SpriteInfo(4, 12)));
        Ic2Icons.addSprite(new SpriteData("bBox", "ic2:textures/sprites/BatteryBox.png", new SpriteInfo(4, 12)));
        Ic2Icons.addSprite(new SpriteData("triggers", "ic2:textures/sprites/bc_triggers.png", new SpriteInfo(5, 5)));
        Ic2Icons.addSprite(new SpriteData("conv", "ic2:textures/sprites/block_Converter.png", new SpriteInfo(16, 12)));
        Ic2Icons.addSprite(new SpriteData("CPad", "ic2:textures/sprites/block_pads.png", new SpriteInfo(4, 12)));
        ArrayList<TextureEntry> blocks = new ArrayList<TextureEntry>();
        ArrayList<TextureEntry> items = new ArrayList<TextureEntry>();
        ArrayList<SpecialEntry> specialBlocks = new ArrayList<SpecialEntry>();
        ArrayList<SpecialEntry> specialItems = new ArrayList<SpecialEntry>();
        blocks.add(new TextureEntry("b0", 1, 0, 2, 1));
        blocks.add(new TextureEntry("b0", 12, 0, 16, 1));
        blocks.add(new TextureEntry("b0", 0, 1, 4, 2));
        blocks.add(new TextureEntry("b0", 11, 1, 14, 2));
        blocks.add(new TextureEntry("b0", 15, 1, 16, 2));
        blocks.add(new TextureEntry("b0", 0, 2, 7, 3));
        blocks.add(new TextureEntry("b0", 8, 2, 16, 3));
        blocks.add(new TextureEntry("b0", 8, 3, 16, 4));
        blocks.add(new TextureEntry("b0", 3, 4, 5, 5));
        blocks.add(new TextureEntry("b0", 14, 4, 16, 5));
        blocks.add(new TextureEntry("b0", 13, 5, 16, 6));
        blocks.add(new TextureEntry("b0", 4, 7, 7, 9));
        blocks.add(new TextureEntry("bc", 0, 0, 16, 4));
        blocks.add(new TextureEntry("bc", 0, 4, 3, 5));
        blocks.add(new TextureEntry("bgen", 0, 0, 13, 12));
        blocks.add(new TextureEntry("bmach", 0, 0, 16, 12));
        blocks.add(new TextureEntry("bmach2", 0, 0, 16, 12));
        blocks.add(new TextureEntry("bpersonal", 0, 0, 4, 12));
        blocks.add(new TextureEntry("bcable", 0, 0, 17, 16));
        blocks.add(new TextureEntry("bcable", 0, 16, 5, 17));
        blocks.add(new TextureEntry("belec", 0, 0, 6, 12));
        blocks.add(new TextureEntry("batBox", 0, 0, 4, 12));
        blocks.add(new TextureEntry("mfe", 0, 0, 4, 12));
        blocks.add(new TextureEntry("mfsu", 0, 0, 4, 12));
        blocks.add(new TextureEntry("bBox", 0, 0, 4, 12));
        blocks.add(new TextureEntry("conv", 0, 0, 6, 6));
        blocks.add(new TextureEntry("conv", 6, 0, 7, 12));
        blocks.add(new TextureEntry("CPad", 0, 0, 4, 12));
        items.add(new TextureEntry("i0", 0, 0, 12, 2));
        items.add(new TextureEntry("i0", 0, 2, 10, 3));
        items.add(new TextureEntry("i0", 0, 3, 16, 5));
        items.add(new TextureEntry("i0", 0, 5, 10, 6));
        items.add(new TextureEntry("i0", 0, 6, 16, 7));
        items.add(new TextureEntry("i0", 0, 8, 16, 9));
        items.add(new TextureEntry("i0", 0, 9, 1, 10));
        items.add(new TextureEntry("i0", 0, 10, 16, 11));
        items.add(new TextureEntry("i1", 0, 0, 16, 1));
        items.add(new TextureEntry("i1", 0, 1, 10, 2));
        items.add(new TextureEntry("i1", 0, 2, 12, 3));
        items.add(new TextureEntry("i1", 0, 3, 10, 4));
        items.add(new TextureEntry("i1", 0, 4, 16, 5));
        items.add(new TextureEntry("i1", 0, 5, 6, 6));
        items.add(new TextureEntry("i1", 0, 6, 7, 7));
        items.add(new TextureEntry("i1", 0, 7, 10, 8));
        items.add(new TextureEntry("i1", 0, 8, 8, 9));
        items.add(new TextureEntry("i1", 0, 9, 12, 10));
        items.add(new TextureEntry("i2", 0, 0, 16, 1));
        items.add(new TextureEntry("i2", 0, 1, 4, 2));
        items.add(new TextureEntry("i2", 0, 2, 14, 3));
        items.add(new TextureEntry("i3", 0, 0, 11, 1));
        items.add(new TextureEntry("i3", 0, 1, 4, 3));
        items.add(new TextureEntry("i3", 0, 3, 3, 6));
        items.add(new TextureEntry("i3", 0, 6, 15, 7));
        items.add(new TextureEntry("i3", 0, 7, 8, 8));
        items.add(new TextureEntry("i3", 0, 8, 3, 9));
        items.add(new TextureEntry("i3", 0, 9, 5, 11));
        items.add(new TextureEntry("triggers", 0, 0, 5, 2));
        items.add(new TextureEntry("triggers", 0, 2, 4, 3));
        Ic2Icons.addTextureEntry(0, blocks);
        Ic2Icons.addTextureEntry(1, items);
        Ic2Icons.addSpecialEntry(0, specialBlocks);
        Ic2Icons.addSpecialEntry(1, specialItems);
    }

    @SideOnly(value=Side.CLIENT)
    static void load(TextureMap map, SpriteData data, int x, int y) {
        Ic2Icons.textures.get((Object)data.spriteID)[x + y * data.info.maxX] = SubIconHandler.getSubIcon(map, x, y, data, -1, map.func_130086_a() == 1);
    }

    @SideOnly(value=Side.CLIENT)
    static void loadSpecial(TextureMap r, SpriteData data, int x, int y, int modify) {
        int pos = x + y * data.info.maxX;
        TextureAtlasSprite texture = SubIconHandler.getSubIcon(r, x, y, data, modify, r.func_130086_a() == 1);
        IIcon[] array = textures.get(data.spriteID);
        for (int i = x; i < x + modify; ++i) {
            for (int j = y; j < y + modify; ++j) {
                pos = i + j * data.info.maxX;
                array[pos] = texture;
            }
        }
        textures.put(data.spriteID, array);
    }

    @SideOnly(value=Side.CLIENT)
    public static void load(TextureMap r) {
        List<SpecialEntry> special;
        List<TextureEntry> entries;
        if (r.func_130086_a() == 0) {
            IC2Fluid.initTextures((IIconRegister)r);
        }
        if ((entries = texturesToLoad.get(r.func_130086_a())) != null && entries.size() > 0) {
            for (TextureEntry entry : entries) {
                entry.load(r);
            }
        }
        if ((special = specialTexturesToLoad.get(r.func_130086_a())) != null && special.size() > 0) {
            for (SpecialEntry entry : special) {
                entry.load(r);
            }
        }
    }

    public static class SpriteInfo {
        int maxX;
        int maxY;
        int spriteAmount;

        public SpriteInfo(int maxX, int maxY) {
            this.maxX = maxX;
            this.maxY = maxY;
            this.spriteAmount = maxX * maxY;
        }
    }

    public static class SpriteData {
        String spriteID;
        String texture;
        SpriteInfo info;

        public SpriteData(String spriteID, String texture, SpriteInfo info) {
            this.spriteID = spriteID;
            this.texture = texture;
            this.info = info;
        }
    }

    public static class SpecialEntry {
        String sheetID;
        int xCoord;
        int yCoord;
        int modify;

        public SpecialEntry(String icon, int x, int y, int mod) {
            this.sheetID = icon;
            this.xCoord = x;
            this.yCoord = y;
            this.modify = mod;
        }

        @SideOnly(value=Side.CLIENT)
        public void load(TextureMap par1) {
            Ic2Icons.loadSpecial(par1, iconIDToData.get(this.sheetID), this.xCoord, this.yCoord, this.modify);
        }
    }

    public static class TextureEntry {
        String sheetID;
        int xMin;
        int xMax;
        int yMin;
        int yMax;

        public TextureEntry(String icon, int x, int y, int xM, int yM) {
            this.sheetID = icon;
            this.xMin = x;
            this.xMax = xM;
            this.yMin = y;
            this.yMax = yM;
        }

        @SideOnly(value=Side.CLIENT)
        public void load(TextureMap par1) {
            SpriteData sprite = iconIDToData.get(this.sheetID);
            for (int y = this.yMin; y < this.yMax; ++y) {
                for (int x = this.xMin; x < this.xMax; ++x) {
                    int pos = x + y * sprite.info.maxX;
                    Ic2Icons.load(par1, sprite, x, y);
                }
            }
        }
    }
}

