/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.Ic2Icons;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;

@SideOnly(value=Side.CLIENT)
public class SubIconHandler {
    private static Map<String, BufferedImage> sheetCache = new HashMap<String, BufferedImage>();

    public static TextureAtlasSprite getSubIcon(TextureMap map, int x, int y, Ic2Icons.SpriteData data, int modfiy, boolean items) {
        String name = "ic2:replacements/" + data.spriteID + "X" + x + "Y" + y;
        SubIcon icon = new SubIcon(name, data.texture, x + y * data.info.maxX, data.info, modfiy, items);
        map.setTextureEntry(name, (TextureAtlasSprite)icon);
        return icon;
    }

    private static BufferedImage loadSheet(IResourceManager manager, String sheet) throws Exception {
        try {
            InputStream stream = manager.func_110536_a(new ResourceLocation(sheet)).func_110527_b();
            if (stream == null) {
                throw new RuntimeException("Sheet not found: " + sheet);
            }
            return ImageIO.read(stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class SubIcon
    extends TextureAtlasSprite {
        public String sheetName;
        public int pos;
        public int modify = -1;
        public Ic2Icons.SpriteInfo info;
        public boolean item;

        public SubIcon(String name, String sheet, int pos, Ic2Icons.SpriteInfo info, int modify, boolean items) {
            super(name);
            this.sheetName = sheet;
            this.pos = pos;
            this.info = info;
            this.modify = modify;
            this.item = items;
        }

        public boolean load(IResourceManager manager, ResourceLocation location) {
            int xCoord = 0;
            int yCoord = 0;
            try {
                BufferedImage sheet = (BufferedImage)sheetCache.get(this.sheetName);
                if (sheet == null) {
                    sheet = SubIconHandler.loadSheet(manager, this.sheetName);
                    sheetCache.put(this.sheetName, sheet);
                }
                this.field_130223_c = sheet.getWidth() / this.info.maxX;
                this.field_130224_d = sheet.getHeight() / this.info.maxY;
                int x = this.pos % this.info.maxX * this.field_130223_c;
                int y = this.pos / this.info.maxX * this.field_130224_d;
                xCoord = x;
                yCoord = y;
                if (this.modify != -1) {
                    this.field_130223_c *= this.modify;
                    this.field_130224_d *= this.modify;
                }
                int[] data = new int[this.field_130223_c * this.field_130224_d];
                sheet.getRGB(x, y, this.field_130223_c, this.field_130224_d, data, 0, this.field_130223_c);
                int[][] mipmaps = new int[FMLClientHandler.instance().getClient().field_71474_y.field_151442_I + 1][];
                mipmaps[0] = data;
                this.field_110976_a.add(mipmaps);
                return false;
            }
            catch (Exception e) {
                FMLLog.getLogger().info("Crash at Texture loading: " + this.field_130223_c + ":" + this.field_130224_d + ":" + xCoord + ":" + yCoord);
                e.printStackTrace();
                FMLCommonHandler.instance().exitJava(0, false);
                return true;
            }
        }

        public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
            try {
                return manager.func_110536_a(this.completeResourceLocation(location)) == null;
            }
            catch (Exception exception) {
                return true;
            }
        }

        private ResourceLocation completeResourceLocation(ResourceLocation p_147634_1_) {
            return new ResourceLocation(p_147634_1_.func_110624_b(), String.format("%s/%s%s", this.item ? "textures/items" : "textures/blocks", p_147634_1_.func_110623_a(), ".png"));
        }
    }

    public static class ForgeEventHandler {
        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onTextureStitchPost(TextureStitchEvent.Post evt) {
            sheetCache.clear();
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onTextureStitchPre(TextureStitchEvent.Pre evt) {
            Ic2Icons.load(evt.map);
        }
    }
}

