/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import ic2.core.Ic2Icons;
import ic2.core.block.BlockIC2Explosive;
import ic2.core.block.EntityIC2Explosive;
import ic2.core.block.EntityItnt;
import ic2.core.block.EntityNuke;
import ic2.core.block.IRareBlock;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class BlockITNT
extends BlockIC2Explosive
implements IRareBlock {
    public boolean isITNT;

    public BlockITNT(boolean is) {
        super(is);
        this.isITNT = is;
        this.func_149647_a(IC2.tabIC2);
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        if (side == 0) {
            return Ic2Icons.getTexture("b0")[this.isITNT ? 58 : 61];
        }
        if (side == 1) {
            return Ic2Icons.getTexture("b0")[this.isITNT ? 59 : 62];
        }
        return this.isITNT ? Ic2Icons.getTexture("b0")[60] : Ic2Icons.getTexture("b0")[63];
    }

    @Override
    public EntityIC2Explosive getExplosionEntity(World world, float x, float y, float z, String username, BlockIC2Explosive.ActivationType type) {
        if (this.isITNT) {
            return new EntityItnt(world, x, y, z);
        }
        if (type == BlockIC2Explosive.ActivationType.Explosion) {
            return null;
        }
        return new EntityNuke(world, x, y, z).setIgniter(username);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack stack) {
        if (!this.isITNT && entityliving instanceof EntityPlayer) {
            IC2.log.log(Level.INFO, "Player " + ((EntityPlayer)entityliving).func_146103_bH().getName() + " placed a nuke at " + world.field_73011_w.field_76574_g + ":(" + x + "," + y + "," + z + ")");
        }
    }

    @Override
    public void onIgnite(World world, EntityPlayer player, int x, int y, int z) {
        if (!this.isITNT) {
            IC2.log.log(Level.INFO, "Nuke at " + world.field_73011_w.field_76574_g + ":(" + x + "," + y + "," + z + ") was ignited " + (player == null ? "indirectly" : "by " + player.func_146103_bH().getName()));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack stack) {
        return this.isITNT ? EnumRarity.common : EnumRarity.uncommon;
    }

    public void func_149666_a(Item i, CreativeTabs tabs, List itemList) {
        if (!this.isITNT && !IC2.enableCraftingNuke) {
            return;
        }
        super.func_149666_a(i, tabs, itemList);
    }
}

