/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.BlockContainerCommon;
import ic2.core.block.RenderBlockCable;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.machine.tileentity.TileEntityCropHarvester;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockMultiID
extends BlockContainerCommon {
    public static int[][] sideAndFacingToSpriteOffset = new int[][]{{3, 2, 0, 0, 0, 0}, {2, 3, 1, 1, 1, 1}, {1, 1, 3, 2, 5, 4}, {0, 0, 2, 3, 4, 5}, {4, 5, 4, 5, 3, 2}, {5, 4, 5, 4, 2, 3}};
    public boolean[] canRender = new boolean[6];
    public int colorMulti;
    public boolean specialRender = false;

    protected BlockMultiID(Material mat) {
        super(mat);
        this.func_149647_a(IC2.tabIC2);
    }

    protected abstract IIcon[] getIconSheet(int var1);

    protected abstract int getIconMeta(int var1);

    protected abstract int getMaxSheetSize(int var1);

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess p_149720_1_, int p_149720_2_, int p_149720_3_, int p_149720_4_) {
        if (this.specialRender) {
            return this.colorMulti;
        }
        return super.func_149720_d(p_149720_1_, p_149720_2_, p_149720_3_, p_149720_4_);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess p_149646_1_, int p_149646_2_, int p_149646_3_, int p_149646_4_, int p_149646_5_) {
        if (this.specialRender && !this.canRender[p_149646_5_]) {
            return false;
        }
        return super.func_149646_a(p_149646_1_, p_149646_2_, p_149646_3_, p_149646_4_, p_149646_5_);
    }

    public IIcon func_149673_e(IBlockAccess iblockaccess, int i, int j, int k, int side) {
        TileEntity te = iblockaccess.func_147438_o(i, j, k);
        int meta = iblockaccess.func_72805_g(i, j, k);
        int extraMeta = this.getIconMeta(meta);
        short facing = 0;
        if (te instanceof TileEntityBlock) {
            TileEntityBlock block = (TileEntityBlock)te;
            facing = block.getFacing();
            if (block.hasTileMeta()) {
                extraMeta = block.getTileMeta();
            }
        }
        if (BlockMultiID.isActive(iblockaccess, i, j, k)) {
            return this.getIconSheet(meta)[extraMeta + (sideAndFacingToSpriteOffset[side][facing] + 6) * this.getMaxSheetSize(meta)];
        }
        return this.getIconSheet(meta)[extraMeta + sideAndFacingToSpriteOffset[side][facing] * this.getMaxSheetSize(meta)];
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.getIconSheet(meta)[this.getIconMeta(meta) + sideAndFacingToSpriteOffset[side][3] * this.getMaxSheetSize(meta)];
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float a, float b, float c) {
        if (entityPlayer.func_70093_af()) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        return te instanceof IHasGui && (!IC2.platform.isSimulating() || IC2.platform.launchGui(entityPlayer, (IHasGui)te));
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList ret = super.getDrops(world, x, y, z, metadata, fortune);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IInventory) {
            ItemStack itemStack;
            int i;
            IInventory inv = (IInventory)te;
            for (i = 0; i < inv.func_70302_i_(); ++i) {
                itemStack = inv.func_70301_a(i);
                if (itemStack == null) continue;
                ret.add(itemStack);
                inv.func_70299_a(i, (ItemStack)null);
            }
            if (te instanceof TileEntityCropHarvester) {
                inv = ((TileEntityCropHarvester)te).inv;
                for (i = 0; i < inv.func_70302_i_(); ++i) {
                    itemStack = inv.func_70301_a(i);
                    if (itemStack == null) continue;
                    ret.add(itemStack);
                    inv.func_70299_a(i, (ItemStack)null);
                }
            }
        }
        return ret;
    }

    public abstract TileEntityBlock createNewTileEntity(World var1, int var2);

    public void func_149749_a(World world, int x, int y, int z, Block a, int b) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityBlock) {
            ((TileEntityBlock)te).onBlockBreak(a, b);
        }
        boolean firstItem = true;
        for (ItemStack itemStack : this.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0)) {
            if (firstItem) {
                firstItem = false;
                continue;
            }
            StackUtil.dropAsEntity(world, x, y, z, itemStack);
        }
        super.func_149749_a(world, x, y, z, a, b);
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        TileEntityBlock te = (TileEntityBlock)world.func_147438_o(i, j, k);
        if (entityliving == null) {
            te.setFacing((short)2);
        } else {
            int l = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            switch (l) {
                case 0: {
                    te.setFacing((short)2);
                    break;
                }
                case 1: {
                    te.setFacing((short)5);
                    break;
                }
                case 2: {
                    te.setFacing((short)3);
                    break;
                }
                case 3: {
                    te.setFacing((short)4);
                }
            }
        }
    }

    public static boolean isActive(IBlockAccess iblockaccess, int i, int j, int k) {
        TileEntity te = iblockaccess.func_147438_o(i, j, k);
        return te instanceof TileEntityBlock && ((TileEntityBlock)te).getActive();
    }

    public void func_149666_a(Item j, CreativeTabs tabs, List itemList) {
        for (int i = 0; i < 16; ++i) {
            ItemStack is = new ItemStack((Block)this, 1, i);
            if (Item.func_150898_a((Block)this).func_77667_c(is) == null) continue;
            itemList.add(is);
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return new ItemStack((Block)this, 1, world.func_72805_g(x, y, z));
    }

    public void resetSpecialRender() {
        this.canRender = new boolean[6];
        this.specialRender = false;
        this.colorMulti = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void applySpecialRender(RenderBlockCable.RenderInfo par1) {
        this.canRender = par1.renderSides;
        this.specialRender = true;
        this.colorMulti = par1.color;
    }

    public int func_149645_b() {
        return IC2.platform.getRenderId("rotated");
    }
}

