/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import ic2.core.IC2;
import ic2.core.Ic2Items;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenRubTree
extends WorldGenerator {
    public static int maxHeight = 8;

    public boolean func_76484_a(World world, Random random, int x, int count, int z) {
        while (count > 0) {
            int y;
            for (y = IC2.getWorldHeight(world) - 1; world.func_147437_c(x, y - 1, z) && y > 0; --y) {
            }
            if (!this.grow(world, x, y, z, random)) {
                count -= 3;
            }
            x += random.nextInt(15) - 7;
            z += random.nextInt(15) - 7;
            --count;
        }
        return true;
    }

    public boolean grow(World world, int x, int y, int z, Random random) {
        int i;
        if (world == null || Ic2Items.rubberWood == null) {
            System.out.println("[ERROR] Had a null that shouldn't have been. RubberTree did not spawn! w=" + world + " r=" + Ic2Items.rubberWood);
            return false;
        }
        int treeholechance = 25;
        int h = this.getGrowHeight(world, x, y, z);
        if (h < 2) {
            return false;
        }
        int height = h / 2;
        h -= h / 2;
        height += random.nextInt(h + 1);
        for (i = 0; i < height; ++i) {
            world.func_147449_b(x, y + i, z, Block.func_149634_a((Item)Ic2Items.rubberWood.func_77973_b()));
            if (random.nextInt(100) <= treeholechance) {
                treeholechance -= 10;
                world.func_72921_c(x, y + i, z, random.nextInt(4) + 2, 0);
            } else {
                world.func_72921_c(x, y + i, z, 1, 0);
            }
            IC2.network.get().announceBlockUpdate(world, x, y + i, z);
            if (height >= 4 && (height >= 7 || i <= 1) && i <= 2) continue;
            for (int a = x - 2; a <= x + 2; ++a) {
                for (int b = z - 2; b <= z + 2; ++b) {
                    boolean gen;
                    int c = i + 4 - height;
                    if (c < 1) {
                        c = 1;
                    }
                    boolean bl = gen = a > x - 2 && a < x + 2 && b > z - 2 && b < z + 2 || a > x - 2 && a < x + 2 && random.nextInt(c) == 0 || b > z - 2 && b < z + 2 && random.nextInt(c) == 0;
                    if (!gen || !world.func_147437_c(a, y + i, b)) continue;
                    world.func_147449_b(a, y + i, b, Block.func_149634_a((Item)Ic2Items.rubberLeaves.func_77973_b()));
                }
            }
        }
        for (i = 0; i <= height / 4 + random.nextInt(2); ++i) {
            if (!world.func_147437_c(x, y + height + i, z)) continue;
            world.func_147449_b(x, y + height + i, z, Block.func_149634_a((Item)Ic2Items.rubberLeaves.func_77973_b()));
        }
        return true;
    }

    public int getGrowHeight(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y - 1, z) != Blocks.field_150349_c && world.func_147439_a(x, y - 1, z) != Blocks.field_150346_d || !world.func_147437_c(x, y, z) && world.func_147439_a(x, y, z) != Block.func_149634_a((Item)Ic2Items.rubberSapling.func_77973_b())) {
            return 0;
        }
        int height = 1;
        while (world.func_147437_c(x, y + 1, z) && height < 8) {
            ++height;
            ++y;
        }
        return height;
    }
}

