/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop;

import ic2.api.crops.ICropTile;
import ic2.core.IC2;
import ic2.core.Ic2Icons;
import ic2.core.block.crop.CropCardBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class CropPumpkin
extends CropCardBase {
    @Override
    public String name() {
        return "Pumpkin";
    }

    @Override
    public String discoveredBy() {
        return "Notch";
    }

    @Override
    public int tier() {
        return 1;
    }

    @Override
    public int stat(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public String[] attributes() {
        return new String[]{"Orange", "Decoration", "Stem"};
    }

    @Override
    public IIcon getSprite(ICropTile crop) {
        return Ic2Icons.getTexture("bc")[crop.getSize() + 15];
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        return crop.getSize() <= 3;
    }

    @Override
    public int weightInfluences(ICropTile crop, float humidity, float nutrients, float air) {
        return (int)((double)humidity * 1.1 + (double)nutrients * 0.9 + (double)air);
    }

    @Override
    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() == 4;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        return new ItemStack(Blocks.field_150423_aK);
    }

    @Override
    public ItemStack getSeeds(ICropTile crop) {
        if (crop.getGain() <= 1 && crop.getGrowth() <= 1 && crop.getResistance() <= 1) {
            return new ItemStack(Items.field_151080_bb, IC2.random.nextInt(3) + 1);
        }
        return super.getSeeds(crop);
    }

    @Override
    public int growthDuration(ICropTile crop) {
        if (crop.getSize() == 3) {
            return 600;
        }
        return 200;
    }

    @Override
    public byte getSizeAfterHarvest(ICropTile crop) {
        return 3;
    }

    @Override
    public int maxSize() {
        return 4;
    }

    @Override
    public int getOptimalHavestSize(ICropTile crop) {
        return this.maxSize();
    }
}

