/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop;

import ic2.api.crops.ICropTile;
import ic2.core.Ic2Icons;
import ic2.core.block.crop.CropCardBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;

public class CropRedWheat
extends CropCardBase {
    @Override
    public String name() {
        return "Redwheat";
    }

    @Override
    public String discoveredBy() {
        return "raa1337";
    }

    @Override
    public int tier() {
        return 6;
    }

    @Override
    public int stat(int n) {
        switch (n) {
            case 0: {
                return 3;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public String[] attributes() {
        return new String[]{"Red", "Redstone", "Wheat"};
    }

    @Override
    public IIcon getSprite(ICropTile crop) {
        if (crop.getSize() == 7) {
            return Ic2Icons.getTexture("bc")[27];
        }
        return Ic2Icons.getTexture("bc")[crop.getSize() + 1];
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        return crop.getSize() < 7 && crop.getLightLevel() <= 10 && crop.getLightLevel() >= 5;
    }

    @Override
    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() == 7;
    }

    @Override
    public float dropGainChance() {
        return 0.5f;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        ChunkCoordinates coords = crop.getLocation();
        if (crop.getWorld().func_94577_B(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c) > 0 || crop.getWorld().field_73012_v.nextBoolean()) {
            return new ItemStack(Items.field_151137_ax, 1);
        }
        return new ItemStack(Items.field_151015_O, 1);
    }

    @Override
    public int emitRedstone(ICropTile crop) {
        return crop.getSize() == 7 ? 15 : 0;
    }

    @Override
    public int getEmittedLight(ICropTile crop) {
        return crop.getSize() == 7 ? 7 : 0;
    }

    @Override
    public int growthDuration(ICropTile crop) {
        return 600;
    }

    @Override
    public byte getSizeAfterHarvest(ICropTile crop) {
        return 2;
    }

    @Override
    public int maxSize() {
        return 7;
    }

    @Override
    public int getOptimalHavestSize(ICropTile crop) {
        return this.maxSize();
    }
}

