/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop;

import ic2.api.crops.ICropTile;
import ic2.core.Ic2Icons;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityCrop;
import ic2.core.block.crop.CropCardBase;
import ic2.core.block.crop.IC2Crops;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class CropTerraWart
extends CropCardBase {
    @Override
    public String name() {
        return "TerraWart";
    }

    @Override
    public int tier() {
        return 5;
    }

    @Override
    public int stat(int n) {
        switch (n) {
            case 0: {
                return 2;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public String[] attributes() {
        return new String[]{"Blue", "Aether", "Consumable", "Snow"};
    }

    @Override
    public IIcon getSprite(ICropTile crop) {
        if (crop.getSize() == 1) {
            return Ic2Icons.getTexture("bc")[37];
        }
        return Ic2Icons.getTexture("bc")[crop.getSize() + 38];
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        return crop.getSize() < 3;
    }

    @Override
    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() == 3;
    }

    @Override
    public float dropGainChance() {
        return 0.8f;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        return new ItemStack(Ic2Items.terraWart.func_77973_b(), 1);
    }

    @Override
    public void tick(ICropTile crop) {
        TileEntityCrop te = (TileEntityCrop)crop;
        if (te.isBlockBelow(Blocks.field_150433_aE)) {
            if (this.canGrow(te)) {
                TileEntityCrop tmp24_23 = te;
                tmp24_23.growthPoints += (int)((double)te.calcGrowthRate() * 0.5);
            }
        } else if (te.isBlockBelow(Blocks.field_150425_aM) && crop.getWorld().field_73012_v.nextInt(300) == 0) {
            te.setID((short)IC2Crops.cropNetherWart.getId());
        }
    }

    @Override
    public int maxSize() {
        return 3;
    }

    @Override
    public int getOptimalHavestSize(ICropTile crop) {
        return this.maxSize();
    }
}

