/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tileentity;

import com.google.common.math.DoubleMath;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyContainer;
import ic2.api.energy.tile.IEnergySource;
import ic2.core.block.TileEntityBlock;
import ic2.core.fluids.IC2Fluid;
import java.math.RoundingMode;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityBasicTurbine
extends TileEntityBlock
implements IEnergySource,
IFluidHandler,
IEnergyContainer {
    boolean addedToEnergyNet;
    public int storedEnergy;
    public float speed;
    public float[] change = new float[5];
    public byte current = 0;
    public FluidTank tank = new FluidTank(4000);

    @Override
    public boolean canUpdate() {
        return this.isSimulating();
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return true;
    }

    @Override
    public double getOfferedEnergy() {
        return Math.min(40, this.storedEnergy);
    }

    @Override
    public void drawEnergy(double amount) {
        this.storedEnergy = (int)((double)this.storedEnergy - amount);
        this.getNetwork().updateTileGuiField(this, "storedEnergy");
    }

    @Override
    public int getSourceTier() {
        return 1;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource != null && resource.getFluid() == IC2Fluid.fluids.get("steam")) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return IC2Fluid.fluids.get("steam") == fluid;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public void func_145845_h() {
        if (this.speed > 0.0f) {
            if (this.storedEnergy >= 4000) {
                if (this.speed > 0.0f) {
                    this.addChange(-0.005f);
                }
            } else {
                int usage = DoubleMath.roundToInt((double)(64.0f * this.speed), (RoundingMode)RoundingMode.DOWN);
                FluidStack drained = this.tank.drain(usage, true);
                if (drained == null) {
                    if (this.speed > 0.0f) {
                        this.addChange(-0.02f);
                    }
                } else {
                    int used = drained.amount;
                    int produced = (int)((float)used / 64.0f * 40.0f);
                    this.storedEnergy += produced;
                    this.getNetwork().updateTileGuiField(this, "storedEnergy");
                    if (usage > used) {
                        if (this.speed > 0.0f) {
                            this.addChange(-0.005f);
                        }
                    } else if (this.storedEnergy > 4000) {
                        if (this.speed > 0.0f) {
                            this.addChange(-0.02f);
                        }
                    } else if (this.speed < 1.0f) {
                        this.addChange(0.01f);
                    }
                }
            }
        } else if (this.tank.getFluidAmount() > 10 && this.storedEnergy <= 1000) {
            this.addChange(0.01f);
        }
        this.current = (byte)(this.current + 1);
        if (this.current >= 5) {
            this.current = 0;
            float data = 0.0f;
            for (int i = 0; i < 5; ++i) {
                data += this.change[i];
            }
            this.change = new float[5];
            this.speed += (data /= 5.0f);
            if (this.speed > 1.0f) {
                this.speed = 1.0f;
            }
            if (this.speed < 0.0f) {
                this.speed = 0.0f;
            }
            this.getNetwork().updateTileGuiField(this, "speed");
        }
        this.setActive(this.speed > 0.0f);
    }

    public void addChange(float par1) {
        byte by = this.current;
        this.change[by] = this.change[by] + par1;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (this.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storedEnergy = nbt.func_74762_e("Energy");
        this.speed = nbt.func_74760_g("Speed");
        this.tank.readFromNBT(nbt.func_74775_l("Tank"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("Energy", this.storedEnergy);
        nbt.func_74776_a("Speed", this.speed);
        this.tank.writeToNBT(this.getNBT(nbt, "Tank"));
    }

    @Override
    public int getStoredEnergy() {
        return this.storedEnergy;
    }

    @Override
    public int getEnergyCapacity() {
        return 4000;
    }

    @Override
    public int getEnergyUsage() {
        return 0;
    }

    @Override
    public int getEnergyProduction() {
        return DoubleMath.roundToInt((double)(40.0f * this.speed), (RoundingMode)RoundingMode.DOWN);
    }

    @Override
    public int getMaxEnergyInput() {
        return 0;
    }
}

