/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tileentity;

import com.google.common.math.DoubleMath;
import ic2.core.ContainerIC2;
import ic2.core.IC2;
import ic2.core.block.generator.container.ContainerSolarGenerator;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import java.math.RoundingMode;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenDesert;

public class TileEntitySolarGenerator
extends TileEntityBaseGenerator
implements ISidedInventory {
    public static Random randomizer = new Random();
    public int ticker = randomizer.nextInt(this.tickRate());
    public boolean sunIsVisible = false;
    public double extraEnergy = 0.0;

    public TileEntitySolarGenerator() {
        this(1, 1, 1);
    }

    public TileEntitySolarGenerator(int par1, int par2, int par3) {
        super(par1, par2, par3);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.updateSunVisibility();
    }

    @Override
    public int gaugeFuelScaled(int i) {
        return i;
    }

    @Override
    public boolean gainEnergy() {
        if (this.ticker++ % this.tickRate() == 0) {
            this.updateSunVisibility();
        }
        if (this.sunIsVisible && this.storage < this.maxStorage) {
            double gen = (double)this.production * ((double)IC2.energyGeneratorSolar / 100.0);
            this.extraEnergy += gen;
            if (this.extraEnergy >= 1.0) {
                int amount = DoubleMath.roundToInt((double)this.extraEnergy, (RoundingMode)RoundingMode.FLOOR);
                this.storage = (short)(this.storage + amount);
                this.extraEnergy -= (double)amount;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean gainFuel() {
        return false;
    }

    public void updateSunVisibility() {
        this.sunIsVisible = TileEntitySolarGenerator.isSunVisible(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        this.getNetwork().updateTileGuiField(this, "sunIsVisible");
    }

    public static boolean isSunVisible(World world, int x, int y, int z) {
        return world.func_72935_r() && !world.field_73011_w.field_76576_e && world.func_72937_j(x, y, z) && (world.func_72959_q().func_76935_a(x, z) instanceof BiomeGenDesert || !world.func_72896_J() && !world.func_72911_I());
    }

    @Override
    public boolean needsFuel() {
        return true;
    }

    @Override
    public String func_145825_b() {
        return "Solar Panel";
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerSolarGenerator(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.generator.gui.GuiSolarGenerator";
    }

    public int tickRate() {
        return 128;
    }

    @Override
    public boolean delayActiveUpdate() {
        return true;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return true;
    }

    public int[] func_94128_d(int var1) {
        return new int[]{0};
    }

    public String getName() {
        return StatCollector.func_74838_a((String)"blockSolarGenerator.name");
    }

    @Override
    public int getMaxEnergyAmount() {
        return (int)((double)this.production * ((double)IC2.energyGeneratorSolar / 100.0));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.extraEnergy = nbttagcompound.func_74769_h("ExtraEnergy");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("ExtraEnergy", this.extraEnergy);
    }
}

