/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.tile.IMachine;
import ic2.core.IC2;
import ic2.core.Ic2Icons;
import ic2.core.Ic2Items;
import ic2.core.block.BlockMultiID;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.machine.tileentity.TileEntityCanner;
import ic2.core.block.machine.tileentity.TileEntityCompressor;
import ic2.core.block.machine.tileentity.TileEntityElecFurnace;
import ic2.core.block.machine.tileentity.TileEntityElectrolyzer;
import ic2.core.block.machine.tileentity.TileEntityExtractor;
import ic2.core.block.machine.tileentity.TileEntityInduction;
import ic2.core.block.machine.tileentity.TileEntityIronFurnace;
import ic2.core.block.machine.tileentity.TileEntityMacerator;
import ic2.core.block.machine.tileentity.TileEntityMagnetizer;
import ic2.core.block.machine.tileentity.TileEntityMatter;
import ic2.core.block.machine.tileentity.TileEntityMiner;
import ic2.core.block.machine.tileentity.TileEntityPump;
import ic2.core.block.machine.tileentity.TileEntityRecycler;
import ic2.core.block.machine.tileentity.TileEntityTerra;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMachine
extends BlockMultiID {
    public BlockMachine() {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149672_a(field_149777_j);
        this.func_149647_a(IC2.tabIC2);
    }

    @Override
    protected IIcon[] getIconSheet(int meta) {
        return Ic2Icons.getTexture("bmach");
    }

    @Override
    protected int getIconMeta(int meta) {
        return meta;
    }

    @Override
    protected int getMaxSheetSize(int meta) {
        return 16;
    }

    public int func_149692_a(int meta) {
        switch (meta) {
            case 1: {
                return meta;
            }
            case 2: {
                return meta;
            }
            case 9: {
                return meta;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 12;
            }
            case 14: {
                return 12;
            }
            case 15: {
                return 12;
            }
        }
        return 0;
    }

    @Override
    public TileEntityBlock createNewTileEntity(World world, int meta) {
        switch (meta) {
            case 1: {
                return new TileEntityIronFurnace();
            }
            case 2: {
                return new TileEntityElecFurnace();
            }
            case 3: {
                return new TileEntityMacerator();
            }
            case 4: {
                return new TileEntityExtractor();
            }
            case 5: {
                return new TileEntityCompressor();
            }
            case 6: {
                return new TileEntityCanner();
            }
            case 7: {
                return new TileEntityMiner();
            }
            case 8: {
                return new TileEntityPump();
            }
            case 9: {
                return new TileEntityMagnetizer();
            }
            case 10: {
                return new TileEntityElectrolyzer();
            }
            case 11: {
                return new TileEntityRecycler();
            }
            case 13: {
                return new TileEntityInduction();
            }
            case 14: {
                return new TileEntityMatter();
            }
            case 15: {
                return new TileEntityTerra();
            }
        }
        return new TileEntityBlock();
    }

    public void func_149734_b(World world, int i, int j, int k, Random random) {
        if (!IC2.platform.isRendering()) {
            return;
        }
        int meta = world.func_72805_g(i, j, k);
        if (meta == 1 && BlockMultiID.isActive((IBlockAccess)world, i, j, k)) {
            TileEntity te = world.func_147438_o(i, j, k);
            short facing = te instanceof TileEntityBlock ? ((TileEntityBlock)te).getFacing() : (short)0;
            float f = (float)i + 0.5f;
            float f2 = (float)j + 0.0f + random.nextFloat() * 6.0f / 16.0f;
            float f3 = (float)k + 0.5f;
            float f4 = 0.52f;
            float f5 = random.nextFloat() * 0.6f - 0.3f;
            switch (facing) {
                case 4: {
                    world.func_72869_a("smoke", (double)(f - f4), (double)f2, (double)(f3 + f5), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f - f4), (double)f2, (double)(f3 + f5), 0.0, 0.0, 0.0);
                    break;
                }
                case 5: {
                    world.func_72869_a("smoke", (double)(f + f4), (double)f2, (double)(f3 + f5), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f + f4), (double)f2, (double)(f3 + f5), 0.0, 0.0, 0.0);
                    break;
                }
                case 2: {
                    world.func_72869_a("smoke", (double)(f + f5), (double)f2, (double)(f3 - f4), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f + f5), (double)f2, (double)(f3 - f4), 0.0, 0.0, 0.0);
                    break;
                }
                case 3: {
                    world.func_72869_a("smoke", (double)(f + f5), (double)f2, (double)(f3 + f4), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f + f5), (double)f2, (double)(f3 + f4), 0.0, 0.0, 0.0);
                }
            }
        }
        if (meta == 3 && BlockMultiID.isActive((IBlockAccess)world, i, j, k)) {
            float f6 = (float)i + 1.0f;
            float f7 = (float)j + 1.0f;
            float f8 = (float)k + 1.0f;
            for (int z = 0; z < 4; ++z) {
                float fmod = -0.2f - random.nextFloat() * 0.6f;
                float f1mod = -0.1f + random.nextFloat() * 0.2f;
                float f2mod = -0.2f - random.nextFloat() * 0.6f;
                world.func_72869_a("smoke", (double)(f6 + fmod), (double)(f7 + f1mod), (double)(f8 + f2mod), 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null) {
            if (tile instanceof IMachine) {
                return ((IMachine)tile).isRedstoneSensitive();
            }
            if (tile instanceof TileEntityMatter) {
                return true;
            }
        }
        return super.canConnectRedstone(world, x, y, z, side);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack stack) {
        return stack.func_77960_j() == 15 || stack.func_77960_j() == 13 || stack.func_77960_j() == 12 ? EnumRarity.uncommon : (stack.func_77960_j() == 14 ? EnumRarity.rare : EnumRarity.common);
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float a, float b, float c) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityMagnetizer) {
            ((TileEntityMagnetizer)tile).onRightClick(entityPlayer);
            return false;
        }
        return super.func_149727_a(world, x, y, z, entityPlayer, side, a, b, c);
    }

    @Override
    public void init() {
        Ic2Items.machine = new ItemStack((Block)this, 1, 0);
        Ic2Items.advancedMachine = new ItemStack((Block)this, 1, 12);
        Ic2Items.ironFurnace = new ItemStack((Block)this, 1, 1);
        Ic2Items.electroFurnace = new ItemStack((Block)this, 1, 2);
        Ic2Items.macerator = new ItemStack((Block)this, 1, 3);
        Ic2Items.extractor = new ItemStack((Block)this, 1, 4);
        Ic2Items.compressor = new ItemStack((Block)this, 1, 5);
        Ic2Items.canner = new ItemStack((Block)this, 1, 6);
        Ic2Items.miner = new ItemStack((Block)this, 1, 7);
        Ic2Items.pump = new ItemStack((Block)this, 1, 8);
        Ic2Items.magnetizer = new ItemStack((Block)this, 1, 9);
        Ic2Items.electrolyzer = new ItemStack((Block)this, 1, 10);
        Ic2Items.recycler = new ItemStack((Block)this, 1, 11);
        Ic2Items.inductionFurnace = new ItemStack((Block)this, 1, 13);
        Ic2Items.massFabricator = new ItemStack((Block)this, 1, 14);
        Ic2Items.terraformer = new ItemStack((Block)this, 1, 15);
    }
}

