/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.gui;

import com.google.common.base.Strings;
import cpw.mods.fml.relauncher.ReflectionHelper;
import ic2.api.reactor.IReactorPlannerComponent;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.machine.container.ContainerReactorPlanner;
import ic2.core.block.machine.logic.PlannerRegistry;
import ic2.core.block.machine.logic.ReactorLogicBase;
import ic2.core.block.machine.logic.TickingReactorLogic;
import ic2.core.block.machine.logic.TickingSteamReactorLogic;
import ic2.core.block.machine.logic.encoder.EncoderRegistry;
import ic2.core.block.machine.tileentity.TileEntityReactorPlanner;
import ic2.core.network.internal.PayloadPacket;
import ic2.core.util.GuiCustomButton;
import ic2.core.util.IDrawButton;
import ic2.core.util.Tuple;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiReactorPlanner
extends GuiContainer {
    static final ResourceLocation texture = new ResourceLocation("ic2", "textures/guiSprites/GUIReactorPlanner.png");
    static final String[] sortingLang = new String[]{"container.reactorplannerButton.sortButtonAll.name", "container.reactorplannerButton.sortButtonFuel.name", "container.reactorplannerButton.sortButtonCooolant.name", "container.reactorplannerButton.sortButtonCondensor.name", "container.reactorplannerButton.sortButtonHeatPack.name", "container.reactorplannerButton.sortButtonVent.name", "container.reactorplannerButton.sortButtonVentSpread.name", "container.reactorplannerButton.sortButtonSwtich.name", "container.reactorplannerButton.sortButtonPlate.name", "container.reactorplannerButton.sortButtonRelection.name", "container.reactorplannerButton.sortButtonIsotope.name"};
    TileEntityReactorPlanner planner;
    String name;
    String inv;
    Map<Integer, GuiButton> buttonMap = new HashMap<Integer, GuiButton>();
    GuiTextField field;

    public GuiReactorPlanner(ContainerReactorPlanner container) {
        super((Container)container);
        this.planner = container.planner;
        this.name = StatCollector.func_74838_a((String)"blockReactorPlanner.name");
        this.field_147000_g = 212;
        this.field_146999_f = 212;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        boolean cooling;
        ReactorLogicBase logic;
        ReactorLogicBase.IReactorPrediction predict;
        this.field_146289_q.func_78276_b(this.name, (this.field_146999_f - this.field_146289_q.func_78256_a(this.name) - 20) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b("" + this.planner.stackSize, 240, 111, 0x404040);
        String start = StatCollector.func_74838_a((String)"container.reactorplannerInfo.startingHeat.name");
        this.field_146289_q.func_78276_b(start, 243 - this.field_146289_q.func_78256_a(start) / 2, 125, 0x404040);
        start = StatCollector.func_74838_a((String)"container.reactorplannerInfo.customTime.name");
        this.field_146289_q.func_78276_b(start, 243 - this.field_146289_q.func_78256_a(start) / 2, 149, 0x404040);
        start = StatCollector.func_74838_a((String)"container.reactorplannerInfo.customSimSpeed.name");
        this.field_146289_q.func_78276_b(start, 243 - this.field_146289_q.func_78256_a(start) / 2, 173, 0x404040);
        DecimalFormat format = new DecimalFormat("###,###");
        TileEntityReactorPlanner.UserSettings settings = this.planner.getUserSettings();
        start = format.format(settings.startingHeat);
        this.field_146289_q.func_78276_b(start, 242 - this.field_146289_q.func_78256_a(start) / 2, 136, 0x404040);
        start = format.format(settings.maxTicks);
        this.field_146289_q.func_78276_b(start, 242 - this.field_146289_q.func_78256_a(start) / 2, 160, 0x404040);
        start = format.format(settings.ticksPerTick);
        this.field_146289_q.func_78276_b(start, 242 - this.field_146289_q.func_78256_a(start) / 2, 184, 0x404040);
        ReactorLogicBase base = this.planner.getReactorLogic();
        this.field.func_146195_b(false);
        if (this.planner.isSteamReactor) {
            predict = (TickingSteamReactorLogic.SteamReactorPrediction)this.planner.getPrediction();
            logic = (TickingSteamReactorLogic)base;
            if (this.planner.selectedView == 0) {
                DecimalFormat floatFormat = new DecimalFormat("#.#");
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.expectedSteam.name", (Object[])new Object[]{format.format(predict.steamPerTick)}), 5, 130, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.totalSteam.name", (Object[])new Object[]{format.format(predict.totalSteamProduced)}), 5, 139, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.totalHeat.name", (Object[])new Object[]{format.format(predict.totalHeatProduced)}), 5, 148, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.explosionEffect.name", (Object[])new Object[]{Float.valueOf(predict.totalExplosionPower)}), 5, 157, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.efficeny.name", (Object[])new Object[]{floatFormat.format(predict.efficency), floatFormat.format(predict.totalEfficency)}), 5, 166, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.isBreeder.name", (Object[])new Object[]{predict.breeder}), 5, 175, 0x404040);
            } else if (this.planner.selectedView == 1) {
                int excess = predict.heatPerTick - predict.coolingPerTick;
                boolean bl = cooling = excess < 0;
                if (cooling) {
                    excess = -excess;
                }
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.expectedHeat.name", (Object[])new Object[]{predict.heatPerTick}), 5, 130, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.expectedSteam.name", (Object[])new Object[]{format.format(predict.steamPerTick)}), 5, 140, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.ventCooling.name", (Object[])new Object[]{predict.coolingPerTick}), 5, 150, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.reactorCooling.name", (Object[])new Object[]{predict.reactorCoolingPerTick}), 5, 160, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)("container.reactorplannerInfo." + (cooling ? "excessCooling" : "excessHeat") + ".name"), (Object[])new Object[]{excess}), 5, 170, 0x404040);
            } else if (this.planner.selectedView == 2) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)2.0f, (float)32.0f, (float)0.0f);
                GL11.glScalef((float)0.75f, (float)0.75f, (float)0.0f);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.producedSteam.name", (Object[])new Object[]{format.format(((TickingSteamReactorLogic)logic).totalProducedSteam)}), 5, 130, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.usedWater.name", (Object[])new Object[]{format.format(((TickingSteamReactorLogic)logic).totalUsedWater)}), 5, 140, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.reactorHeat.name", (Object[])new Object[]{format.format(((TickingSteamReactorLogic)logic).currentHeat)}), 5, 150, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.meltingHeat.name", (Object[])new Object[]{format.format(((TickingSteamReactorLogic)logic).maxHeat)}), 5, 160, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.heatEffect.name", (Object[])new Object[]{format.format(((TickingSteamReactorLogic)logic).explosionEffect * 100.0f) + "%"}), 5, 170, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.SimulationTime.name", (Object[])new Object[]{((TickingSteamReactorLogic)logic).ticksDone}), 5, 180, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.activeTime.name", (Object[])new Object[]{((TickingSteamReactorLogic)logic).ticksLeft, ((TickingSteamReactorLogic)logic).maxTick}), 5, 190, 0x404040);
                GL11.glPopMatrix();
            }
        } else {
            predict = (TickingReactorLogic.ReactorPrediction)this.planner.getPrediction();
            logic = (TickingReactorLogic)base;
            if (this.planner.selectedView == 0) {
                DecimalFormat floatFormat = new DecimalFormat("#.#");
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.expectedEU.name", (Object[])new Object[]{format.format(((TickingReactorLogic.ReactorPrediction)predict).energyPerTick)}), 5, 130, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.totalEU.name", (Object[])new Object[]{format.format(((TickingReactorLogic.ReactorPrediction)predict).totalEnergyProduced)}), 5, 139, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.totalHeat.name", (Object[])new Object[]{format.format(((TickingReactorLogic.ReactorPrediction)predict).totalHeatProduced)}), 5, 148, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.explosionEffect.name", (Object[])new Object[]{Float.valueOf(((TickingReactorLogic.ReactorPrediction)predict).totalExplosionPower)}), 5, 157, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.efficeny.name", (Object[])new Object[]{floatFormat.format(((TickingReactorLogic.ReactorPrediction)predict).efficency), floatFormat.format(((TickingReactorLogic.ReactorPrediction)predict).totalEfficency)}), 5, 166, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.isBreeder.name", (Object[])new Object[]{((TickingReactorLogic.ReactorPrediction)predict).breeder}), 5, 175, 0x404040);
            } else if (this.planner.selectedView == 1) {
                int excess = ((TickingReactorLogic.ReactorPrediction)predict).heatPerTick - ((TickingReactorLogic.ReactorPrediction)predict).coolingPerTick;
                boolean bl = cooling = excess < 0;
                if (cooling) {
                    excess = -excess;
                }
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.heatCreated.name", (Object[])new Object[]{((TickingReactorLogic.ReactorPrediction)predict).heatPerTick}), 5, 130, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.heatPackHeat.name", (Object[])new Object[]{((TickingReactorLogic.ReactorPrediction)predict).heatPackHeatPerTick}), 5, 140, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.ventCooling.name", (Object[])new Object[]{((TickingReactorLogic.ReactorPrediction)predict).coolingPerTick}), 5, 150, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.reactorCooling.name", (Object[])new Object[]{((TickingReactorLogic.ReactorPrediction)predict).reactorCoolingPerTick}), 5, 160, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)("container.reactorplannerInfo." + (cooling ? "excessCooling" : "excessHeat") + ".name"), (Object[])new Object[]{excess}), 5, 170, 0x404040);
            } else if (this.planner.selectedView == 2) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)2.0f, (float)32.0f, (float)0.0f);
                GL11.glScalef((float)0.75f, (float)0.75f, (float)0.0f);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.activeEU.name", (Object[])new Object[]{format.format(logic.getReactorEUEnergyOutput())}), 5, 130, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.producedEU.name", (Object[])new Object[]{format.format(((TickingReactorLogic)logic).totalProducedEnergy)}), 5, 140, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.reactorHeat.name", (Object[])new Object[]{format.format(((TickingReactorLogic)logic).currentHeat)}), 5, 150, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.meltingHeat.name", (Object[])new Object[]{format.format(((TickingReactorLogic)logic).maxHeat)}), 5, 160, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.heatEffect.name", (Object[])new Object[]{format.format(((TickingReactorLogic)logic).explosionEffect * 100.0f) + "%"}), 5, 170, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.SimulationTime.name", (Object[])new Object[]{((TickingReactorLogic)logic).ticksDone}), 5, 180, 0x404040);
                this.field_146289_q.func_78276_b(StatCollector.func_74837_a((String)"container.reactorplannerInfo.activeTime.name", (Object[])new Object[]{((TickingReactorLogic)logic).ticksLeft, ((TickingReactorLogic)logic).maxTick}), 5, 190, 0x404040);
                GL11.glPopMatrix();
            }
        }
        if (this.planner.selectedView == 3) {
            Slot slot = this.getSlotUnderMouse();
            if (slot != null) {
                PlannerRegistry.ComponentStat stats = PlannerRegistry.getStatsFromItem(slot.func_75211_c());
                if (stats != null) {
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)2.0f, (float)32.0f, (float)0.0f);
                    GL11.glScalef((float)0.75f, (float)0.75f, (float)0.0f);
                    boolean x = false;
                    int y = 0;
                    Set<IReactorPlannerComponent.ReactorComponentStat> list = stats.getKeys();
                    for (IReactorPlannerComponent.ReactorComponentStat comp : list) {
                        this.field_146289_q.func_78276_b(stats.getComponentText(comp), 5, 130 + 10 * y, 0x404040);
                        ++y;
                    }
                    GL11.glPopMatrix();
                } else {
                    this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.reactorplannerInfo.noComponentSelected.name"), 5, 150, 0x404040);
                }
            } else {
                this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.reactorplannerInfo.noComponentSelected.name"), 5, 150, 0x404040);
            }
        } else if (this.planner.selectedView == 4) {
            this.field.func_146195_b(true);
            this.field.func_146194_f();
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int i;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int remove = this.planner.reactorSize * 9;
        for (i = 0; i < 3 + this.planner.reactorSize; ++i) {
            this.drawRow(60 + i * 18 - remove, 20, 6);
        }
        this.drawTopTab(20, -28, Ic2Items.nuclearReactor.func_77946_l(), !this.planner.isSteamReactor);
        this.drawTopTab(50, -28, Ic2Items.steamReactor.func_77946_l(), this.planner.isSteamReactor);
        this.func_73729_b(this.field_147003_i + 200, this.field_147009_r, 74, 212, 40, 38);
        this.func_73729_b(this.field_147003_i + 240, this.field_147009_r, 79, 212, 43, 38);
        this.func_73729_b(this.field_147003_i + 208, this.field_147009_r + 198, 74, 241, 40, 14);
        this.func_73729_b(this.field_147003_i + 240, this.field_147009_r + 198, 79, 241, 48, 14);
        this.func_73729_b(this.field_147003_i + 200, this.field_147009_r + 170, 74, 215, 40, 36);
        this.func_73729_b(this.field_147003_i + 240, this.field_147009_r + 170, 79, 215, 43, 36);
        for (i = 1; i < 5; ++i) {
            int offset = i * 36;
            this.func_73729_b(this.field_147003_i + 200, this.field_147009_r + offset, 74, 215, 40, 36);
            this.func_73729_b(this.field_147003_i + 240, this.field_147009_r + offset, 79, 215, 43, 36);
        }
        for (i = 0; i < 3; ++i) {
            this.drawRow(215 + i * 18, 17, 5);
        }
        int row = this.planner.selectedSlot / 3;
        int slot = this.planner.selectedSlot % 3;
        this.func_73729_b(this.field_147003_i + 215 + slot * 18, this.field_147009_r + 17 + 18 * row, 0, 230, 18, 18);
        this.drawSideTab(-28, 100, new ItemStack(Items.field_151061_bv), this.planner.selectedView == 0);
        this.drawSideTab(-28, 70, Ic2Items.nuclearReactor.func_77946_l(), this.planner.selectedView == 1);
        this.drawSideTab(-28, 40, new ItemStack(Blocks.field_150460_al), this.planner.selectedView == 2);
        this.drawSideTab(-28, 130, new ItemStack(Items.field_151122_aG), this.planner.selectedView == 3);
        this.drawSideTab(-28, 160, new ItemStack(Items.field_151121_aF), this.planner.selectedView == 4);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int amount;
        this.updateButtons();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            GuiButton button = (GuiButton)this.field_146292_n.get(i);
            if (!(button instanceof IDrawButton)) continue;
            ((IDrawButton)button).onPostDraw(this.field_146297_k, mouseX, mouseY);
        }
        int x = mouseX - this.field_147003_i;
        int y = mouseY - this.field_147009_r;
        if (x >= 20 && x <= 48 && y >= -28 && y <= 0) {
            this.drawHoveringText(Arrays.asList(StatCollector.func_74838_a((String)"container.reactorplannerButton.reactor.name")), mouseX, mouseY, this.field_146289_q);
        } else if (x >= 50 && x <= 78 && y >= -28 && y <= 0) {
            this.drawHoveringText(Arrays.asList(StatCollector.func_74838_a((String)"container.reactorplannerButton.steamReactor.name")), mouseX, mouseY, this.field_146289_q);
        } else if (x >= -28 && x <= 0 && y >= 160 && y <= 188) {
            this.drawHoveringText(Arrays.asList(StatCollector.func_74838_a((String)"container.reactorplannerButton.setupName.name")), mouseX, mouseY, this.field_146289_q);
        } else if (x >= -28 && x <= 0 && y >= 130 && y <= 158) {
            this.drawHoveringText(Arrays.asList(StatCollector.func_74838_a((String)"container.reactorplannerButton.itemInfo.name")), mouseX, mouseY, this.field_146289_q);
        } else if (x >= -28 && x <= 0 && y >= 90 && y <= 128) {
            this.drawHoveringText(Arrays.asList(StatCollector.func_74838_a((String)"container.reactorplannerButton.predictions.name")), mouseX, mouseY, this.field_146289_q);
        } else if (x >= -28 && x <= 0 && y >= 70 && y <= 98) {
            this.drawHoveringText(Arrays.asList(StatCollector.func_74838_a((String)"container.reactorplannerButton.reactorSetup.name")), mouseX, mouseY, this.field_146289_q);
        } else if (x >= -28 && x <= 0 && y >= 40 && y <= 68) {
            this.drawHoveringText(Arrays.asList(StatCollector.func_74838_a((String)"container.reactorplannerButton.activeReactorInfo.name")), mouseX, mouseY, this.field_146289_q);
        }
        Slot hoverSlot = this.getSlotUnderMouse();
        if (hoverSlot instanceof ContainerReactorPlanner.SlotComponent && (double)(amount = Mouse.getDWheel()) != 0.0) {
            PayloadPacket packet = new PayloadPacket(this.planner, 0, 2, 0);
            packet.addNumber(0, 1);
            packet.addNumber(1, -(amount /= 120));
            this.planner.getNetwork().sendCustomPacket(packet);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.addButton(new GuiButton(0, this.field_147003_i + 207, this.field_147009_r + 5, 10, 10, "-"));
        this.addButton(new GuiButton(1, this.field_147003_i + 265, this.field_147009_r + 5, 10, 10, "+"));
        this.addButton(new GuiCustomButton(2, this.field_147003_i + 220, this.field_147009_r + 5, 42, 10, StatCollector.func_74838_a((String)"container.reactorplannerButton.sortbutton.name")).addHoverText(StatCollector.func_74838_a((String)sortingLang[this.planner.components.type + 1])));
        this.addButton(new GuiButton(3, this.field_147003_i + 5, this.field_147009_r + 5, 10, 10, "-"));
        this.addButton(new GuiButton(4, this.field_147003_i + 157, this.field_147009_r + 5, 10, 10, "+"));
        this.addButton(new GuiButton(5, this.field_147003_i + 215, this.field_147009_r + 110, 10, 10, "-"));
        this.addButton(new GuiButton(6, this.field_147003_i + 260, this.field_147009_r + 110, 10, 10, "+"));
        this.addButton(new GuiButton(7, this.field_147003_i + 170, this.field_147009_r + 20, 43, 10, StatCollector.func_74838_a((String)"container.reactorplannerButton.start.name")));
        this.addButton(new GuiButton(8, this.field_147003_i + 170, this.field_147009_r + 44, 43, 10, StatCollector.func_74838_a((String)"container.reactorplannerButton.stop.name")));
        this.addButton(new GuiButton(9, this.field_147003_i + 170, this.field_147009_r + 58, 43, 10, StatCollector.func_74838_a((String)"container.reactorplannerButton.compile.name")));
        this.addButton(new GuiButton(10, this.field_147003_i + 170, this.field_147009_r + 70, 43, 10, StatCollector.func_74838_a((String)"container.reactorplannerButton.reset.name")));
        this.addButton(new GuiButton(11, this.field_147003_i + 170, this.field_147009_r + 84, 43, 10, StatCollector.func_74838_a((String)"container.reactorplannerButton.backup.name")));
        this.addButton(new GuiButton(12, this.field_147003_i + 170, this.field_147009_r + 96, 43, 10, StatCollector.func_74838_a((String)"container.reactorplannerButton.restore.name")));
        this.addButton(new GuiButton(13, this.field_147003_i + 170, this.field_147009_r + 110, 43, 10, StatCollector.func_74838_a((String)"container.reactorplannerButton.clear.name")));
        this.addButton(new GuiButton(14, this.field_147003_i + 205, this.field_147009_r + 135, 10, 10, "-"));
        this.addButton(new GuiButton(15, this.field_147003_i + 269, this.field_147009_r + 135, 10, 10, "+"));
        this.addButton(new GuiButton(16, this.field_147003_i + 170, this.field_147009_r + 32, 43, 10, StatCollector.func_74838_a((String)("container.reactorplannerButton." + (this.planner.getReactorLogic().producing ? "pause" : "run") + ".name"))));
        this.addButton(new GuiButton(17, this.field_147003_i + 205, this.field_147009_r + 159, 10, 10, "-"));
        this.addButton(new GuiButton(18, this.field_147003_i + 269, this.field_147009_r + 159, 10, 10, "+"));
        this.addButton(new GuiButton(19, this.field_147003_i + 205, this.field_147009_r + 183, 10, 10, "-"));
        this.addButton(new GuiButton(20, this.field_147003_i + 269, this.field_147009_r + 183, 10, 10, "+"));
        this.addButton(new GuiButton(21, this.field_147003_i + 175, this.field_147009_r + 197, 40, 10, StatCollector.func_74838_a((String)"container.reactorplannerButton.import.name")));
        this.addButton(new GuiButton(22, this.field_147003_i + 220, this.field_147009_r + 197, 40, 10, StatCollector.func_74838_a((String)"container.reactorplannerButton.export.name")));
        this.field = new GuiTextField(this.field_146289_q, 10, 145, 158, 20);
    }

    public void updateButtons() {
        ReactorLogicBase logic = this.planner.getReactorLogic();
        TileEntityReactorPlanner.UserSettings settings = this.planner.getUserSettings();
        this.getButton((int)0).field_146124_l = this.planner.components.canDecrease();
        this.getButton((int)1).field_146124_l = this.planner.components.canIncrease();
        ((GuiCustomButton)this.getButton(2)).clearText().addHoverText(StatCollector.func_74838_a((String)sortingLang[this.planner.components.type + 1]));
        this.getButton((int)3).field_146124_l = this.planner.reactorSize > 0;
        this.getButton((int)4).field_146124_l = this.planner.reactorSize < 6;
        this.getButton((int)5).field_146124_l = this.planner.stackSize > 1;
        this.getButton((int)6).field_146124_l = this.planner.stackSize < 64;
        this.getButton((int)7).field_146124_l = logic.isValid() && !this.planner.getActive();
        this.getButton((int)8).field_146124_l = this.planner.getActive();
        this.getButton((int)9).field_146124_l = !logic.isValid();
        this.getButton((int)10).field_146124_l = logic.isValid() && logic.ticksDone > 0;
        this.getButton((int)11).field_146124_l = logic.isValid();
        this.getButton((int)12).field_146124_l = this.planner.backup.hasBackup;
        GuiButton button = this.getButton(16);
        button.field_146126_j = StatCollector.func_74838_a((String)("container.reactorplannerButton." + (this.planner.getReactorLogic().producing ? "pause" : "run") + ".name"));
        button.field_146124_l = logic.isValid();
        this.getButton((int)14).field_146124_l = settings.startingHeat > 0;
        this.getButton((int)17).field_146124_l = settings.maxTicks > 0;
        this.getButton((int)19).field_146124_l = settings.ticksPerTick > 1;
        this.getButton((int)22).field_146124_l = logic.isValid();
        this.field.func_146180_a(this.planner.setupName);
    }

    protected void func_146284_a(GuiButton button) {
        PayloadPacket payload;
        PayloadPacket packet;
        PayloadPacket packet2;
        int id = button.field_146127_k;
        if (id == 0 || id == 1) {
            packet2 = new PayloadPacket(this.planner, 0, 2, 0);
            packet2.addNumber(0, 1);
            packet2.addNumber(1, id == 0 ? -1 : id);
            this.planner.getNetwork().sendCustomPacket(packet2);
        }
        if (id == 2) {
            packet2 = new PayloadPacket(this.planner, 0, 2, 0);
            packet2.addNumber(0, 2);
            packet2.addNumber(1, 0);
            this.planner.getNetwork().sendCustomPacket(packet2);
        }
        if (id == 3 || id == 4) {
            this.planner.reactorSize = this.planner.reactorSize + (id == 3 ? -1 : 1);
            if (this.planner.reactorSize < 0) {
                this.planner.reactorSize = 0;
            }
            if (this.planner.reactorSize > 6) {
                this.planner.reactorSize = 6;
            }
            this.planner.getReactorLogic().onSizeUpdate();
            ContainerReactorPlanner cont = this.getContainer();
            if (cont != null) {
                cont.reset(this.field_146297_k.field_71439_g.field_71071_by);
            }
            packet = new PayloadPacket(this.planner, 0, 2, 0);
            packet.addNumber(0, 3);
            packet.addNumber(1, id == 3 ? -1 : 1);
            this.planner.getNetwork().sendCustomPacket(packet);
        }
        if (id == 5 || id == 6) {
            int value;
            int n = value = id == 5 ? -1 : 1;
            if (GuiReactorPlanner.func_146272_n()) {
                value *= 10;
            }
            packet = new PayloadPacket(this.planner, 0, 2, 0);
            packet.addNumber(0, 4);
            packet.addNumber(1, value);
            this.planner.getNetwork().sendCustomPacket(packet);
        }
        if (id == 7 || id == 8) {
            PayloadPacket packet3 = new PayloadPacket(this.planner, 0, 2, 0);
            packet3.addNumber(0, 5);
            packet3.addNumber(1, id == 7 ? 0 : 1);
            this.planner.getNetwork().sendCustomPacket(packet3);
        }
        if (id == 9 || id == 10) {
            PayloadPacket packet4 = new PayloadPacket(this.planner, 0, 2, 0);
            packet4.addNumber(0, 6);
            packet4.addNumber(1, id == 9 ? 0 : 1);
            this.planner.getNetwork().sendCustomPacket(packet4);
        }
        if (id == 11) {
            PayloadPacket packet5 = new PayloadPacket(this.planner, 0, 2, 0);
            packet5.addNumber(0, 7);
            packet5.addNumber(1, 0);
            this.planner.getNetwork().sendCustomPacket(packet5);
        }
        if (id == 12) {
            TileEntityReactorPlanner.ReactorBackup backup = this.planner.backup;
            this.planner.getReactorLogic().clear();
            this.planner.getPrediction().clear();
            this.planner.isSteamReactor = backup.isSteam;
            this.planner.reactorSize = backup.reactorSize;
            ContainerReactorPlanner cont = this.getContainer();
            if (cont != null) {
                cont.reset(this.field_146297_k.field_71439_g.field_71071_by);
            }
            PayloadPacket packet6 = new PayloadPacket(this.planner, 0, 2, 0);
            packet6.addNumber(0, 7);
            packet6.addNumber(1, 1);
            this.planner.getNetwork().sendCustomPacket(packet6);
        }
        if (id == 13) {
            PayloadPacket packet7 = new PayloadPacket(this.planner, 0, 2, 0);
            packet7.addNumber(0, 8);
            packet7.addNumber(1, GuiReactorPlanner.func_146272_n() ? 1 : 0);
            this.planner.getNetwork().sendCustomPacket(packet7);
            if (!GuiReactorPlanner.func_146272_n()) {
                this.planner.getReactorLogic().clear();
            }
        }
        if (id == 14 || id == 15) {
            int value = 1;
            if (GuiReactorPlanner.func_146271_m()) {
                value *= 1000;
            }
            if (GuiReactorPlanner.func_146272_n()) {
                value *= 100;
            }
            if (GuiReactorPlanner.isAltKeyDown()) {
                value *= 10;
            }
            if (id == 14) {
                value = -value;
            }
            packet = new PayloadPacket(this.planner, 0, 2, 0);
            packet.addNumber(0, 10);
            packet.addNumber(1, value);
            this.planner.getNetwork().sendCustomPacket(packet);
        }
        if (id == 16) {
            PayloadPacket packet8 = new PayloadPacket(this.planner, 0, 2, 0);
            packet8.addNumber(0, 11);
            packet8.addNumber(1, 0);
            this.planner.getNetwork().sendCustomPacket(packet8);
        }
        if (id == 17 || id == 18) {
            int value = 1;
            if (GuiReactorPlanner.func_146271_m()) {
                value *= 1000;
            }
            if (GuiReactorPlanner.func_146272_n()) {
                value *= 100;
            }
            if (GuiReactorPlanner.isAltKeyDown()) {
                value *= 10;
            }
            if (id == 17) {
                value = -value;
            }
            packet = new PayloadPacket(this.planner, 0, 2, 0);
            packet.addNumber(0, 12);
            packet.addNumber(1, value);
            this.planner.getNetwork().sendCustomPacket(packet);
        }
        if (id == 19 || id == 20) {
            int value = 1;
            if (GuiReactorPlanner.func_146271_m()) {
                value = 1000;
            }
            if (GuiReactorPlanner.func_146272_n()) {
                value = 100;
            }
            if (GuiReactorPlanner.isAltKeyDown()) {
                value = 10;
            }
            if (id == 19) {
                value = -value;
            }
            packet = new PayloadPacket(this.planner, 0, 2, 0);
            packet.addNumber(0, 13);
            packet.addNumber(1, value);
            this.planner.getNetwork().sendCustomPacket(packet);
        }
        if (id == 21) {
            Tuple<String, NBTTagCompound> encoded = this.getSafeDecodedSetup();
            if (encoded == null) {
                IC2.platform.messagePlayer((EntityPlayer)this.field_146297_k.field_71439_g, StatCollector.func_74838_a((String)"container.reactorplannerAction.decoderCreatingFailed.name"));
                return;
            }
            payload = new PayloadPacket(this.planner, 2, 0, 0);
            payload.addString(0, encoded.getFirst());
            payload.addString(1, encoded.getSecond().toString());
            this.planner.getNetwork().sendCustomPacket(payload);
        }
        if (id == 22) {
            Tuple<String[], String[]> cases;
            int answer;
            String defaults = EncoderRegistry.instance.getDefaultEncoderID();
            if (GuiReactorPlanner.func_146272_n() && (answer = JOptionPane.showOptionDialog(null, "Choose a Encoder", "ReactorPlanner Enocder Choice", 1, 1, null, (cases = EncoderRegistry.instance.getChoiceList()).getSecond(), EncoderRegistry.instance.getDefaultEncoder().getName())) != -1) {
                defaults = cases.getFirst()[answer];
            }
            payload = new PayloadPacket(this.planner, 1, 0, 0);
            payload.addString(0, defaults);
            this.planner.getNetwork().sendCustomPacket(payload);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        int x = mouseX - this.field_147003_i;
        int y = mouseY - this.field_147009_r;
        if (x >= 20 && x <= 48 && y >= -28 && y <= 0) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            if (this.planner.isSteamReactor) {
                PayloadPacket packet = new PayloadPacket(this.planner, 0, 2, 0);
                packet.addNumber(0, 0);
                packet.addNumber(1, 0);
                this.planner.getNetwork().sendCustomPacket(packet);
                return;
            }
        } else if (x >= 50 && x <= 78 && y >= -28 && y <= 0) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            if (!this.planner.isSteamReactor) {
                PayloadPacket packet = new PayloadPacket(this.planner, 0, 2, 0);
                packet.addNumber(0, 0);
                packet.addNumber(1, 1);
                this.planner.getNetwork().sendCustomPacket(packet);
                return;
            }
        } else if (x >= -28 && x <= 0 && y >= 160 && y <= 188) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            if (this.planner.selectedView != 4) {
                PayloadPacket packet = new PayloadPacket(this.planner, 0, 2, 0);
                packet.addNumber(0, 9);
                packet.addNumber(1, 4);
                this.planner.getNetwork().sendCustomPacket(packet);
                return;
            }
        } else if (x >= -28 && x <= 0 && y >= 130 && y <= 158) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            if (this.planner.selectedView != 3) {
                PayloadPacket packet = new PayloadPacket(this.planner, 0, 2, 0);
                packet.addNumber(0, 9);
                packet.addNumber(1, 3);
                this.planner.getNetwork().sendCustomPacket(packet);
                return;
            }
        } else if (x >= -28 && x <= 0 && y >= 100 && y <= 128) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            if (this.planner.selectedView != 0) {
                PayloadPacket packet = new PayloadPacket(this.planner, 0, 2, 0);
                packet.addNumber(0, 9);
                packet.addNumber(1, 0);
                this.planner.getNetwork().sendCustomPacket(packet);
                return;
            }
        } else if (x >= -28 && x <= 0 && y >= 70 && y <= 98) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            if (this.planner.selectedView != 1) {
                PayloadPacket packet = new PayloadPacket(this.planner, 0, 2, 0);
                packet.addNumber(0, 9);
                packet.addNumber(1, 1);
                this.planner.getNetwork().sendCustomPacket(packet);
                return;
            }
        } else if (x >= -28 && x <= 0 && y >= 40 && y <= 68) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            if (this.planner.selectedView != 2) {
                PayloadPacket packet = new PayloadPacket(this.planner, 0, 2, 0);
                packet.addNumber(0, 9);
                packet.addNumber(1, 2);
                this.planner.getNetwork().sendCustomPacket(packet);
                return;
            }
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char p_73869_1_, int p_73869_2_) {
        if (this.field.func_146206_l() && this.field.func_146176_q()) {
            this.field.func_146201_a(p_73869_1_, p_73869_2_);
            this.planner.setupName = this.field.func_146179_b();
            PayloadPacket packet = new PayloadPacket(this.planner, 1, 1, 0);
            packet.addNumber(0, 0);
            packet.addString(0, this.field.func_146179_b());
            this.planner.getNetwork().sendCustomPacket(packet);
            return;
        }
        super.func_73869_a(p_73869_1_, p_73869_2_);
    }

    private void drawRow(int xOffset, int yOffset, int count) {
        for (int i = 0; i < count; ++i) {
            this.func_73729_b(this.field_147003_i + xOffset, this.field_147009_r + yOffset + 18 * i, 0, 212, 18, 18);
        }
    }

    private void drawTopTab(int xOffset, int yOffset, ItemStack item, boolean enabled) {
        GL11.glPushMatrix();
        this.func_73729_b(this.field_147003_i + xOffset, this.field_147009_r + yOffset, enabled ? 46 : 18, 212, 28, enabled ? 31 : 28);
        RenderHelper.func_74518_a();
        this.field_73735_i = 200.0f;
        GuiReactorPlanner.field_146296_j.field_77023_b = 200.0f;
        field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.field_71446_o, item, this.field_147003_i + xOffset + 6, this.field_147009_r + yOffset + 8);
        this.field_73735_i = 0.0f;
        GuiReactorPlanner.field_146296_j.field_77023_b = 0.0f;
        RenderHelper.func_74518_a();
        GL11.glPopMatrix();
        this.field_146297_k.field_71446_o.func_110577_a(texture);
    }

    private void drawSideTab(int xOffset, int yOffset, ItemStack item, boolean enabled) {
        GL11.glPushMatrix();
        this.func_73729_b(this.field_147003_i + xOffset, this.field_147009_r + yOffset, enabled ? 122 : 156, 212, enabled ? 31 : 28, 28);
        RenderHelper.func_74518_a();
        this.field_73735_i = 200.0f;
        GuiReactorPlanner.field_146296_j.field_77023_b = 200.0f;
        field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.field_71446_o, item, this.field_147003_i + xOffset + 8, this.field_147009_r + yOffset + 6);
        this.field_73735_i = 0.0f;
        GuiReactorPlanner.field_146296_j.field_77023_b = 0.0f;
        RenderHelper.func_74518_a();
        GL11.glPopMatrix();
        this.field_146297_k.field_71446_o.func_110577_a(texture);
    }

    public void addButton(GuiButton button) {
        this.buttonMap.put(button.field_146127_k, button);
        this.field_146292_n.add(button);
    }

    public GuiButton getButton(int id) {
        return this.buttonMap.get(id);
    }

    private ContainerReactorPlanner getContainer() {
        if (this.field_147002_h instanceof ContainerReactorPlanner) {
            return (ContainerReactorPlanner)this.field_147002_h;
        }
        return null;
    }

    public Tuple<String, NBTTagCompound> getSafeDecodedSetup() {
        try {
            return this.getDecodedSetup();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Tuple<String, NBTTagCompound> getDecodedSetup() throws Exception {
        Clipboard board = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (board.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
            String text = (String)board.getData(DataFlavor.stringFlavor);
            if (Strings.isNullOrEmpty((String)text)) {
                return null;
            }
            return EncoderRegistry.instance.createDecodedMessage(text);
        }
        return null;
    }

    public Slot getSlotUnderMouse() {
        try {
            return (Slot)ReflectionHelper.getPrivateValue(GuiContainer.class, (Object)((Object)this), (String[])new String[]{"theSlot", "field_147006_u"});
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isAltKeyDown() {
        return Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
    }
}

