/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.logic;

import ic2.api.reactor.IReactorPlannerComponent;
import ic2.api.reactor.ISteamReactorComponent;
import ic2.core.IC2;
import ic2.core.block.machine.logic.encoder.EncoderRegistry;
import ic2.core.util.StackUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.StatCollector;

public class PlannerRegistry {
    static Map<ItemWithMeta, ComponentStat> itemToStats = new HashMap<ItemWithMeta, ComponentStat>();
    static Map<ItemWithMeta, Short> itemToId = new HashMap<ItemWithMeta, Short>();
    static ItemStack[] idToItem = new ItemStack[Short.MAX_VALUE];
    static ItemStack[] reactorComponents = new ItemStack[0];
    static ItemStack[] steamReactorComponents = new ItemStack[0];
    static EnumMap<IReactorPlannerComponent.ReactorComponentType, List<Short>> typeToID = new EnumMap(IReactorPlannerComponent.ReactorComponentType.class);
    static EnumMap<IReactorPlannerComponent.ReactorComponentType, List<Short>> typeToIDNormal = new EnumMap(IReactorPlannerComponent.ReactorComponentType.class);
    static EnumMap<IReactorPlannerComponent.ReactorComponentType, List<Short>> typeToIDSteam = new EnumMap(IReactorPlannerComponent.ReactorComponentType.class);
    static IReactorPlannerComponent.ReactorComponentType[] idToType = new IReactorPlannerComponent.ReactorComponentType[Short.MAX_VALUE];
    static ComponentSorter sorter = new ComponentSorter();

    public static void init() {
        ArrayList<ItemStack> reactor = new ArrayList<ItemStack>();
        ArrayList<ItemStack> steamReactor = new ArrayList<ItemStack>();
        for (Item item : Item.field_150901_e) {
            if (!(item instanceof IReactorPlannerComponent)) continue;
            IReactorPlannerComponent component = (IReactorPlannerComponent)item;
            List<ItemStack> items = ComponentStat.createComponents(component);
            for (ItemStack stack : items) {
                List<Short> ids;
                short id = component.getID(stack);
                if (idToItem[id] != null) {
                    IC2.platform.displayError("ReactorPlanner ID is already used: " + id + ", Item Tried to be added: " + stack.func_82833_r() + ", Item that was added: " + idToItem[id].func_82833_r());
                    return;
                }
                ItemStack copy = StackUtil.copyWithSize(stack, 1);
                ItemWithMeta meta = new ItemWithMeta(stack);
                itemToId.put(meta, id);
                PlannerRegistry.idToItem[id] = copy;
                IReactorPlannerComponent.ReactorType type = component.getReactorInfo(stack);
                IReactorPlannerComponent.ReactorComponentType compType = component.getType(stack);
                if (type.isReactor()) {
                    reactor.add(copy);
                    ids = typeToIDNormal.get((Object)compType);
                    if (ids == null) {
                        ids = new ArrayList<Short>();
                        typeToIDNormal.put(compType, ids);
                    }
                    ids.add(id);
                }
                if (type.isSteamReactor() && component instanceof ISteamReactorComponent) {
                    steamReactor.add(copy);
                    ids = typeToIDSteam.get((Object)compType);
                    if (ids == null) {
                        ids = new ArrayList<Short>();
                        typeToIDSteam.put(compType, ids);
                    }
                    ids.add(id);
                }
                PlannerRegistry.idToType[id] = compType;
                ids = typeToID.get((Object)compType);
                if (ids == null) {
                    ids = new ArrayList<Short>();
                    typeToID.put(compType, ids);
                }
                ids.add(id);
            }
        }
        Collections.sort(reactor, sorter);
        Collections.sort(steamReactor, sorter);
        reactorComponents = reactor.toArray(new ItemStack[reactor.size()]);
        steamReactorComponents = steamReactor.toArray(new ItemStack[steamReactor.size()]);
        EncoderRegistry.instance.init();
    }

    public static short getID(ItemStack stack) {
        if (stack == null) {
            return -1;
        }
        Short meta = itemToId.get(new ItemWithMeta(stack));
        if (meta == null) {
            return -1;
        }
        return meta;
    }

    public static IReactorPlannerComponent.ReactorComponentType getTypeByItem(ItemStack stack) {
        short id = PlannerRegistry.getID(stack);
        if (id == -1) {
            return null;
        }
        return idToType[id];
    }

    public static ItemStack[] getItemsByType(byte sorting, boolean steam) {
        IReactorPlannerComponent.ReactorComponentType[] array = IReactorPlannerComponent.ReactorComponentType.values();
        if (sorting == -1 || sorting >= array.length) {
            return PlannerRegistry.getItemsByType(null, steam);
        }
        return PlannerRegistry.getItemsByType(array[sorting], steam);
    }

    public static ItemStack[] getItemsByType(IReactorPlannerComponent.ReactorComponentType type, boolean steam) {
        if (type == null) {
            return steam ? steamReactorComponents : reactorComponents;
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        List<Short> entries = (steam ? typeToIDSteam : typeToIDNormal).get((Object)type);
        if (entries == null || entries.isEmpty()) {
            return new ItemStack[0];
        }
        for (Short entry : entries) {
            ItemStack item = idToItem[entry];
            if (item == null) continue;
            list.add(item);
        }
        Collections.sort(list, sorter);
        return list.toArray(new ItemStack[list.size()]);
    }

    public static ItemStack getComponentFromID(short id) {
        if (id < 0 || id > idToItem.length) {
            return null;
        }
        return ItemStack.func_77944_b((ItemStack)idToItem[id]);
    }

    public static ComponentStat getStatsFromItem(ItemStack item) {
        if (item == null) {
            return null;
        }
        return itemToStats.get(new ItemWithMeta(item));
    }

    public static class ItemWithMeta {
        Item item;
        int meta;
        int hashCode;

        public ItemWithMeta(ItemStack par1) {
            this(par1.func_77973_b(), par1.func_77960_j());
        }

        public ItemWithMeta(Item par1, int par2) {
            this.item = par1;
            this.meta = par2;
            this.hashCode = Objects.hash(this.item, this.meta);
        }

        public ItemWithMeta(Item par1) {
            this(par1, 0);
        }

        public ItemStack toStack() {
            return new ItemStack(this.item, 1, this.meta);
        }

        public ItemWithMeta toWildcard() {
            return new ItemWithMeta(this.item, Short.MAX_VALUE);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ItemWithMeta) {
                ItemWithMeta itemWithMeta = (ItemWithMeta)obj;
                return itemWithMeta.item == this.item && itemWithMeta.meta == this.meta;
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    public static class ComponentSorter
    implements Comparator<ItemStack> {
        @Override
        public int compare(ItemStack par1, ItemStack par2) {
            short firstID = PlannerRegistry.getID(par1);
            short secID = PlannerRegistry.getID(par2);
            IReactorPlannerComponent.ReactorComponentType first = idToType[firstID];
            IReactorPlannerComponent.ReactorComponentType second = idToType[secID];
            if (first == null && second == null) {
                return 0;
            }
            if (first == null) {
                return 1;
            }
            if (second == null) {
                return -1;
            }
            if (first.ordinal() < second.ordinal()) {
                return -1;
            }
            if (first.ordinal() > second.ordinal()) {
                return 1;
            }
            if (firstID < secID) {
                return -1;
            }
            if (secID < firstID) {
                return 1;
            }
            return 0;
        }
    }

    public static class ComponentStat {
        static DecimalFormat format = new DecimalFormat("#.##");
        EnumMap<IReactorPlannerComponent.ReactorComponentStat, NBTBase.NBTPrimitive> stats = new EnumMap(IReactorPlannerComponent.ReactorComponentStat.class);

        public ComponentStat(IReactorPlannerComponent planner, ItemStack stack) {
            IReactorPlannerComponent.ReactorComponentType type = planner.getType(stack);
            for (IReactorPlannerComponent.ReactorComponentStat stat : type.getStats()) {
                this.stats.put(stat, planner.getReactorStat(stat, stack));
            }
            List<IReactorPlannerComponent.ReactorComponentStat> list = planner.getExtraStats(stack);
            if (list != null) {
                for (IReactorPlannerComponent.ReactorComponentStat stat : list) {
                    this.stats.put(stat, planner.getReactorStat(stat, stack));
                }
            }
        }

        public static List<ItemStack> createComponents(IReactorPlannerComponent comp) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            if (comp.hasSubParts()) {
                list.addAll(Arrays.asList(comp.getSubParts()));
            } else {
                list.add(comp.getReactorPart());
            }
            for (int i = 0; i < list.size(); ++i) {
                ItemStack stack = (ItemStack)list.get(i);
                if (stack == null) {
                    list.remove(i--);
                    continue;
                }
                itemToStats.put(new ItemWithMeta(stack), new ComponentStat(comp, stack));
            }
            return list;
        }

        public Set<IReactorPlannerComponent.ReactorComponentStat> getKeys() {
            return this.stats.keySet();
        }

        public String getComponentText(IReactorPlannerComponent.ReactorComponentStat comp) {
            NBTBase.NBTPrimitive nbt = this.stats.get((Object)comp);
            if (nbt.func_74732_a() == 5) {
                float value = nbt.func_150288_h();
                if (comp == IReactorPlannerComponent.ReactorComponentStat.ReactorEEM && value > 0.0f && value < 1.0f) {
                    return StatCollector.func_74837_a((String)("container.reactorplannerInfo.stat." + comp.name() + ".name"), (Object[])new Object[]{(int)(value * 100.0f) + "%"});
                }
                return StatCollector.func_74837_a((String)("container.reactorplannerInfo.stat." + comp.name() + ".name"), (Object[])new Object[]{format.format(nbt.func_150288_h())});
            }
            return StatCollector.func_74837_a((String)("container.reactorplannerInfo.stat." + comp.name() + ".name"), (Object[])new Object[]{nbt.func_150287_d()});
        }
    }
}

